# 数据集和模型下载



```bash
#模型
mkdir mistral-clip-ckpts
cd mistral-clip-ckpts
git clone https://modelscope.cn/models/rubraAI/Mistral-7B-Instruct-v0.3
git clone https://modelscope.cn/models/AI-ModelScope/clip-vit-large-patch14-336

#数据集
wget https://atp-modelzoo-wlcb-pai.oss-cn-wulanchabu.aliyuncs.com/release/models/pai-megatron-patch/vlm-datasets/wds.tgz
tar -zxf wds.tgz
```

## 依赖安装

```
cd /Pai-Megatron-Patch/examples/llava_mcore/CLIP-main
python setup.py install 
```



# 模型训练流程

### 模型转换

运行hf2mcore_convertor_llava.sh脚本，需要传入的参数列表如下：

```
MODEL_SIZE=$1                 # 模型参数：7B
SOURCE_LLM_CKPT_PATH=$2       # 源llm checkpoint路径
SOURCE_CLIP_CKPT_PATH=$3      # 源clip checkpoint路径
TARGET_CKPT_PATH=$4           # 目标checkpoint路径
TP=$5                         # 模型并行度
PP=$6                         # 流水并行度
mg2hf=$7                      # 是否执行mcore2hf转换
PR=$8                      # 精度设置，fp16/bf16/fp32     
HF_CKPT_PATH=$9            # HF的CKPT的路径【可选，mg2hf=true时必须提供】

```

例如，使用下述脚本将checkpoint转换到MCore-Dense并检查输出

```
cd /Pai-Megatron-Patch/toolkits/model_checkpoints_convertor/llava
bash hf2mcore_convertor_llava.sh \
    7B \
    /mnt/mistral-clip-ckpts/Mistral-7B-Instruct-v0.3 \
    /mnt/mistral-clip-ckpts/clip-vit-large-patch14-336  \
    /mnt/mistral-clip-ckpts/Mistral-7B-Instruct-v0.3-to-mcore-tp4-pp1 \
    4  \
    1  \
    false \
    bf16
```



### Megatron-Core预训练

**bf16和TE似乎不能够一起使用，属于官方BUG**

运行run-pretrain.sh脚本，需要传入的参数列表如下
```
ENV=$1                          # 运行环境配置开关: dsw单机训练训练，dlc表示多机训练环境
MODEL_SIZE=$2                   # 模型结构参数量级: 0.5B/1.5B/3B/7B/14B/32B/72B
BATCH_SIZE=$3                   # 一次迭代一个数据并行内的样本数
GLOBAL_BATCH_SIZE=$4            # 一次迭代多个数据并行的总样本数
LR=$5                           # 学习率
MIN_LR=$6                       # 最小学习率
SEQ_LEN=$7                      # 序列长度
DECODER_SEQ_LEN=$8              # 解码序列长度
PR=${9}                         # 训练精度: fp16, bf16, fp8
TP=${10}                        # 模型并行度
PP=${11}                        # 流水并行度
CP=${12}                        # 上下文并行度
DO=${13}                        # 是否使用Megatron版Zero-1降显存优化器: true, false
FL=${14}                        # 是否优先使用Flash Attention: true, false
AC=${15}                        # 激活检查点模式: sel, full, offload, false
OPTIMIZER_OFFLOAD=${16}         # 是否启用Offload optimizer: false, static, auto
SAVE_INTERVAL=${17}             # 保存ckpt的间隔
DATASET_PATH=${18}              # 训练数据集路径
VALID_DATASET_PATH=${19}        # 验证数据集路径
PRETRAIN_CHECKPOINT_PATH=${20}  # 预训练模型路径
TRAIN_ITERS=${21}               # 训练TOKEN或者Iter数
LR_WARMUP_ITERS=${22}           # 预热TOKEN或者Iter数        
OUTPUT_BASEPATH=${23}           # 训练输出日志文件路径
```

```
#这里建议用transformers==4.45

#在run_mcore_llava-dcu.sh设置好使用卡号和卡数后可以直接运行：
sh run-pretrain.sh
```







