// this file is generated by paddle/phi/api/yaml/generator/generate_op.py, do not edit.
#include <string>
#include "paddle/fluid/framework/infershape_utils.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/framework/op_version_registry.h"
#include "paddle/fluid/framework/convert_utils.h"
#include "paddle/phi/core/infermeta_utils.h"
#include "paddle/phi/infermeta/nullary.h"
#include "paddle/phi/infermeta/unary.h"
#include "paddle/phi/infermeta/binary.h"
#include "paddle/phi/infermeta/ternary.h"
#include "paddle/phi/infermeta/multiary.h"
#include "paddle/phi/infermeta/backward.h"

namespace paddle {
namespace operators {

using paddle::framework::GradVarName;


class Atan2OpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X1", "(Tensor), input 0 of atan2 op.");
    AddInput("X2", "(Tensor), input 1 of atan2 op.");
    AddOutput("Out", "(Tensor), output 0 of atan2 op.");
    AddComment(R"DOC(
TODO: Documentation of atan2 op.
)DOC");
  }
};


class Atan2Op : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(atan2, Atan2InferShapeFunctor,
                            PD_INFER_META(phi::Atan2InferMeta));



class BernoulliOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of bernoulli op.");
    AddOutput("Out", "(Tensor), output 0 of bernoulli op.");
    AddComment(R"DOC(
TODO: Documentation of bernoulli op.
)DOC");
  }
};


class BernoulliOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(bernoulli, BernoulliInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class CholeskyOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cholesky op.");
    AddOutput("Out", "(Tensor), output 0 of cholesky op.");
    AddAttr<bool>("upper", "(bool), attribute 0 for cholesky op.")
        .SetDefault(false);
    AddComment(R"DOC(
TODO: Documentation of cholesky op.
)DOC");
  }
};


class CholeskyOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky, CholeskyInferShapeFunctor,
                            PD_INFER_META(phi::CholeskyInferMeta));



class CholeskySolveOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cholesky_solve op.");
    AddInput("Y", "(Tensor), input 1 of cholesky_solve op.");
    AddOutput("Out", "(Tensor), output 0 of cholesky_solve op.");
    AddAttr<bool>("upper", "(bool), attribute 0 for cholesky_solve op.")
        .SetDefault(false);
    AddComment(R"DOC(
TODO: Documentation of cholesky_solve op.
)DOC");
  }
};


class CholeskySolveOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_solve, CholeskySolveInferShapeFunctor,
                            PD_INFER_META(phi::CholeskySolveInferMeta));



class CrossOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cross op.");
    AddInput("Y", "(Tensor), input 1 of cross op.");
    AddOutput("Out", "(Tensor), output 0 of cross op.");
    AddAttr<int>("dim", "(int), attribute 0 for cross op.")
        .SetDefault(9);
    AddComment(R"DOC(
TODO: Documentation of cross op.
)DOC");
  }
};


class CrossOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "X");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(cross, CrossInferShapeFunctor,
                            PD_INFER_META(phi::CrossInferMeta));



class DiagV2OpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of diag_v2 op.");
    AddOutput("Out", "(Tensor), output 0 of diag_v2 op.");
    AddAttr<int>("offset", "(int), attribute 0 for diag_v2 op.")
        .SetDefault(0);
    AddAttr<float>("padding_value", "(float), attribute 1 for diag_v2 op.")
        .SetDefault(0.0);
    AddComment(R"DOC(
TODO: Documentation of diag_v2 op.
)DOC");
  }
};


class DiagV2Op : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(diag_v2, DiagV2InferShapeFunctor,
                            PD_INFER_META(phi::DiagInferMeta));



class DiagonalOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("Input", "(Tensor), input 0 of diagonal op.");
    AddOutput("Out", "(Tensor), output 0 of diagonal op.");
    AddAttr<int>("offset", "(int), attribute 0 for diagonal op.")
        .SetDefault(0);
    AddAttr<int>("axis1", "(int), attribute 1 for diagonal op.")
        .SetDefault(0);
    AddAttr<int>("axis2", "(int), attribute 2 for diagonal op.")
        .SetDefault(1);
    AddComment(R"DOC(
TODO: Documentation of diagonal op.
)DOC");
  }
};


class DiagonalOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(diagonal, DiagonalInferShapeFunctor,
                            PD_INFER_META(phi::DiagonalInferMeta));



class DigammaOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of digamma op.");
    AddOutput("Out", "(Tensor), output 0 of digamma op.");
    AddComment(R"DOC(
TODO: Documentation of digamma op.
)DOC");
  }
};


class DigammaOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(digamma, DigammaInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class DistOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of dist op.");
    AddInput("Y", "(Tensor), input 1 of dist op.");
    AddOutput("Out", "(Tensor), output 0 of dist op.");
    AddAttr<float>("p", "(float), attribute 0 for dist op.")
        .SetDefault(2.0);
    AddComment(R"DOC(
TODO: Documentation of dist op.
)DOC");
  }
};


class DistOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(dist, DistInferShapeFunctor,
                            PD_INFER_META(phi::DistInferMeta));



class DotOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of dot op.");
    AddInput("Y", "(Tensor), input 1 of dot op.");
    AddOutput("Out", "(Tensor), output 0 of dot op.");
    AddComment(R"DOC(
TODO: Documentation of dot op.
)DOC");
  }
};


class DotOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "X");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(dot, DotInferShapeFunctor,
                            PD_INFER_META(phi::DotInferMeta));



class ErfOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of erf op.");
    AddOutput("Out", "(Tensor), output 0 of erf op.");
    AddComment(R"DOC(
TODO: Documentation of erf op.
)DOC");
  }
};


class ErfOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(erf, ErfInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class ErfinvOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of erfinv op.");
    AddOutput("Out", "(Tensor), output 0 of erfinv op.");
    AddComment(R"DOC(
TODO: Documentation of erfinv op.
)DOC");
  }
};


class ErfinvOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(erfinv, ErfinvInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));
DECLARE_INPLACE_OP_INFERER(ErfinvInplaceInferer,
                           {"X", "Out"});



class FftC2cOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of fft_c2c op.");
    AddOutput("Out", "(Tensor), output 0 of fft_c2c op.");
    AddAttr<std::vector<int64_t>>("axes", "(std::vector<int64_t>), attribute 0 for fft_c2c op.")
    ;
    AddAttr<std::string>("normalization", "(std::string), attribute 1 for fft_c2c op.")
    ;
    AddAttr<bool>("forward", "(bool), attribute 2 for fft_c2c op.")
    ;
    AddComment(R"DOC(
TODO: Documentation of fft_c2c op.
)DOC");
  }
};


class FftC2cOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(fft_c2c, FftC2cInferShapeFunctor,
                            PD_INFER_META(phi::FFTC2CInferMeta));



class FftC2rOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of fft_c2r op.");
    AddOutput("Out", "(Tensor), output 0 of fft_c2r op.");
    AddAttr<std::vector<int64_t>>("axes", "(std::vector<int64_t>), attribute 0 for fft_c2r op.")
    ;
    AddAttr<std::string>("normalization", "(std::string), attribute 1 for fft_c2r op.")
    ;
    AddAttr<bool>("forward", "(bool), attribute 2 for fft_c2r op.")
    ;
    AddAttr<int64_t>("last_dim_size", "(int64_t), attribute 3 for fft_c2r op.")
        .SetDefault(0L);
    AddComment(R"DOC(
TODO: Documentation of fft_c2r op.
)DOC");
  }
};


class FftC2rOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(fft_c2r, FftC2rInferShapeFunctor,
                            PD_INFER_META(phi::FFTC2RInferMeta));



class FftR2cOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of fft_r2c op.");
    AddOutput("Out", "(Tensor), output 0 of fft_r2c op.");
    AddAttr<std::vector<int64_t>>("axes", "(std::vector<int64_t>), attribute 0 for fft_r2c op.")
    ;
    AddAttr<std::string>("normalization", "(std::string), attribute 1 for fft_r2c op.")
    ;
    AddAttr<bool>("forward", "(bool), attribute 2 for fft_r2c op.")
    ;
    AddAttr<bool>("onesided", "(bool), attribute 3 for fft_r2c op.")
    ;
    AddComment(R"DOC(
TODO: Documentation of fft_r2c op.
)DOC");
  }
};


class FftR2cOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(fft_r2c, FftR2cInferShapeFunctor,
                            PD_INFER_META(phi::FFTR2CInferMeta));



class GraphSendUvOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("x", "(Tensor), input 0 of graph_send_uv op.");
    AddInput("y", "(Tensor), input 1 of graph_send_uv op.");
    AddInput("src_index", "(Tensor), input 2 of graph_send_uv op.");
    AddInput("dst_index", "(Tensor), input 3 of graph_send_uv op.");
    AddOutput("out", "(Tensor), output 0 of graph_send_uv op.");
    AddAttr<std::string>("message_op", "(std::string), attribute 0 for graph_send_uv op.")
        .SetDefault("ADD");
    AddComment(R"DOC(
TODO: Documentation of graph_send_uv op.
)DOC");
  }
};


class GraphSendUvOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "x");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(graph_send_uv, GraphSendUvInferShapeFunctor,
                            PD_INFER_META(phi::GraphSendUVInferMeta));



class LgammaOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of lgamma op.");
    AddOutput("Out", "(Tensor), output 0 of lgamma op.");
    AddComment(R"DOC(
TODO: Documentation of lgamma op.
)DOC");
  }
};


class LgammaOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(lgamma, LgammaInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class MvOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of mv op.");
    AddInput("Vec", "(Tensor), input 1 of mv op.");
    AddOutput("Out", "(Tensor), output 0 of mv op.");
    AddComment(R"DOC(
TODO: Documentation of mv op.
)DOC");
  }
};


class MvOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(mv, MvInferShapeFunctor,
                            PD_INFER_META(phi::MvInferMeta));



class PoissonOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of poisson op.");
    AddOutput("Out", "(Tensor), output 0 of poisson op.");
    AddComment(R"DOC(
TODO: Documentation of poisson op.
)DOC");
  }
};


class PoissonOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(poisson, PoissonInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class SolveOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of solve op.");
    AddInput("Y", "(Tensor), input 1 of solve op.");
    AddOutput("Out", "(Tensor), output 0 of solve op.");
    AddComment(R"DOC(
TODO: Documentation of solve op.
)DOC");
  }
};


class SolveOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "X");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(solve, SolveInferShapeFunctor,
                            PD_INFER_META(phi::SolveInferMeta));



class TraceOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("Input", "(Tensor), input 0 of trace op.");
    AddOutput("Out", "(Tensor), output 0 of trace op.");
    AddAttr<int>("offset", "(int), attribute 0 for trace op.")
        .SetDefault(0);
    AddAttr<int>("axis1", "(int), attribute 1 for trace op.")
        .SetDefault(0);
    AddAttr<int>("axis2", "(int), attribute 2 for trace op.")
        .SetDefault(1);
    AddComment(R"DOC(
TODO: Documentation of trace op.
)DOC");
  }
};


class TraceOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trace, TraceInferShapeFunctor,
                            PD_INFER_META(phi::TraceInferMeta));



class TruncOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of trunc op.");
    AddOutput("Out", "(Tensor), output 0 of trunc op.");
    AddComment(R"DOC(
TODO: Documentation of trunc op.
)DOC");
  }
};


class TruncOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trunc, TruncInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class FlipOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of flip op.");
    AddOutput("Out", "(Tensor), output 0 of flip op.");
    AddAttr<std::vector<int>>("axis", "(std::vector<int>), attribute 0 for flip op.")
    ;
    AddComment(R"DOC(
TODO: Documentation of flip op.
)DOC");
  }
};


class FlipOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(flip, FlipInferShapeFunctor,
                            PD_INFER_META(phi::FlipInferMeta));




template <typename T>
class Atan2GradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("atan2_grad");

    grad_op->SetInput("X1", this->Input("X1"));
    grad_op->SetInput("X2", this->Input("X2"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X1"), this->InputGrad("X1"));
    grad_op->SetOutput(GradVarName("X2"), this->InputGrad("X2"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class Atan2GradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(atan2_grad, Atan2GradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class CholeskyGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cholesky_grad");

    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class CholeskyGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_grad, CholeskyGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class CholeskySolveGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cholesky_solve_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class CholeskySolveGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_solve_grad, CholeskySolveGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class CrossGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cross_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class CrossGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(cross_grad, CrossGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class DiagV2GradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("diag_v2_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class DiagV2GradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(diag_v2_grad, DiagV2GradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(DiagV2GradNoNeedBufferVarInferer,
                                    "X");


template <typename T>
class DiagonalGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("diagonal_grad");

    grad_op->SetInput("Input", this->Input("Input"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("Input"), this->InputGrad("Input"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class DiagonalGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(diagonal_grad, DiagonalGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(DiagonalGradNoNeedBufferVarInferer,
                                    "Input");


template <typename T>
class DigammaGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("digamma_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class DigammaGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(digamma_grad, DigammaGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class DistGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("dist_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class DistGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(dist_grad, DistGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class DotGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("dot_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class DotGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(dot_grad, DotGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class ErfGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("erf_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class ErfGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(erf_grad, ErfGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class ErfinvGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("erfinv_grad");

    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class ErfinvGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(erfinv_grad, ErfinvGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class FftC2cGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("fft_c2c_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class FftC2cGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(fft_c2c_grad, FftC2cGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class FftC2rGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("fft_c2r_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class FftC2rGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(fft_c2r_grad, FftC2rGradInferShapeFunctor,
                            PD_INFER_META(phi::FFTC2RGradInferMeta));



template <typename T>
class FftR2cGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("fft_r2c_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class FftR2cGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(fft_r2c_grad, FftR2cGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(FftR2cGradNoNeedBufferVarInferer,
                                    "X");

template <typename T>
class FlipGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("flip");

    grad_op->SetInput("X", this->OutputGrad("Out"));

    grad_op->SetOutput("Out", this->InputGrad("X"));

    grad_op->SetAttr("axis", this->GetAttr("axis"));
  }
};


template <typename T>
class GraphSendUvGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("graph_send_uv_grad");

    grad_op->SetInput("x", this->Input("x"));
    grad_op->SetInput("y", this->Input("y"));
    grad_op->SetInput("src_index", this->Input("src_index"));
    grad_op->SetInput("dst_index", this->Input("dst_index"));
    grad_op->SetInput(GradVarName("out"), this->OutputGrad("out"));

    grad_op->SetOutput(GradVarName("x"), this->InputGrad("x"));
    grad_op->SetOutput(GradVarName("y"), this->InputGrad("y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class GraphSendUvGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "x");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(graph_send_uv_grad, GraphSendUvGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class LgammaGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("lgamma_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class LgammaGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(lgamma_grad, LgammaGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class MvGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("mv_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Vec", this->Input("Vec"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Vec"), this->InputGrad("Vec"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class MvGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(mv_grad, MvGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class PoissonGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("poisson_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class PoissonGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(poisson_grad, PoissonGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class SolveGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("solve_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class SolveGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(solve_grad, SolveGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class TraceGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("trace_grad");

    grad_op->SetInput("Input", this->Input("Input"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("Input"), this->InputGrad("Input"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class TraceGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(trace_grad, TraceGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(TraceGradNoNeedBufferVarInferer,
                                    "Input");


template <typename T>
class TruncGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("trunc_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  grad_op->SetAttrMap(this->Attrs());
  }
};


class TruncGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trunc_grad, TruncGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));


}  // namespace operators
}  // namespace paddle

namespace ops = paddle::operators;
REGISTER_OPERATOR(atan2, ops::Atan2Op,
                  ops::Atan2OpMaker,
                  ops::Atan2GradOpMaker<paddle::framework::OpDesc>,
                  ops::Atan2GradOpMaker<paddle::imperative::OpBase>,
                  ops::Atan2InferShapeFunctor);


REGISTER_OPERATOR(bernoulli, ops::BernoulliOp,
                  ops::BernoulliOpMaker,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::BernoulliInferShapeFunctor);


REGISTER_OPERATOR(cholesky, ops::CholeskyOp,
                  ops::CholeskyOpMaker,
                  ops::CholeskyGradOpMaker<paddle::framework::OpDesc>,
                  ops::CholeskyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskyInferShapeFunctor);


REGISTER_OPERATOR(cholesky_solve, ops::CholeskySolveOp,
                  ops::CholeskySolveOpMaker,
                  ops::CholeskySolveGradOpMaker<paddle::framework::OpDesc>,
                  ops::CholeskySolveGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskySolveInferShapeFunctor);


REGISTER_OPERATOR(cross, ops::CrossOp,
                  ops::CrossOpMaker,
                  ops::CrossGradOpMaker<paddle::framework::OpDesc>,
                  ops::CrossGradOpMaker<paddle::imperative::OpBase>,
                  ops::CrossInferShapeFunctor);


REGISTER_OPERATOR(diag_v2, ops::DiagV2Op,
                  ops::DiagV2OpMaker,
                  ops::DiagV2GradOpMaker<paddle::framework::OpDesc>,
                  ops::DiagV2GradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagV2InferShapeFunctor);


REGISTER_OPERATOR(diagonal, ops::DiagonalOp,
                  ops::DiagonalOpMaker,
                  ops::DiagonalGradOpMaker<paddle::framework::OpDesc>,
                  ops::DiagonalGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagonalInferShapeFunctor);


REGISTER_OPERATOR(digamma, ops::DigammaOp,
                  ops::DigammaOpMaker,
                  ops::DigammaGradOpMaker<paddle::framework::OpDesc>,
                  ops::DigammaGradOpMaker<paddle::imperative::OpBase>,
                  ops::DigammaInferShapeFunctor);


REGISTER_OPERATOR(dist, ops::DistOp,
                  ops::DistOpMaker,
                  ops::DistGradOpMaker<paddle::framework::OpDesc>,
                  ops::DistGradOpMaker<paddle::imperative::OpBase>,
                  ops::DistInferShapeFunctor);


REGISTER_OPERATOR(dot, ops::DotOp,
                  ops::DotOpMaker,
                  ops::DotGradOpMaker<paddle::framework::OpDesc>,
                  ops::DotGradOpMaker<paddle::imperative::OpBase>,
                  ops::DotInferShapeFunctor);


REGISTER_OPERATOR(erf, ops::ErfOp,
                  ops::ErfOpMaker,
                  ops::ErfGradOpMaker<paddle::framework::OpDesc>,
                  ops::ErfGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfInferShapeFunctor);


REGISTER_OPERATOR(erfinv, ops::ErfinvOp,
                  ops::ErfinvOpMaker,
                  ops::ErfinvGradOpMaker<paddle::framework::OpDesc>,
                  ops::ErfinvGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfinvInplaceInferer,
                  ops::ErfinvInferShapeFunctor);


REGISTER_OPERATOR(fft_c2c, ops::FftC2cOp,
                  ops::FftC2cOpMaker,
                  ops::FftC2cGradOpMaker<paddle::framework::OpDesc>,
                  ops::FftC2cGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftC2cInferShapeFunctor);


REGISTER_OPERATOR(fft_c2r, ops::FftC2rOp,
                  ops::FftC2rOpMaker,
                  ops::FftC2rGradOpMaker<paddle::framework::OpDesc>,
                  ops::FftC2rGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftC2rInferShapeFunctor);


REGISTER_OPERATOR(fft_r2c, ops::FftR2cOp,
                  ops::FftR2cOpMaker,
                  ops::FftR2cGradOpMaker<paddle::framework::OpDesc>,
                  ops::FftR2cGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftR2cInferShapeFunctor);


REGISTER_OPERATOR(graph_send_uv, ops::GraphSendUvOp,
                  ops::GraphSendUvOpMaker,
                  ops::GraphSendUvGradOpMaker<paddle::framework::OpDesc>,
                  ops::GraphSendUvGradOpMaker<paddle::imperative::OpBase>,
                  ops::GraphSendUvInferShapeFunctor);


REGISTER_OPERATOR(lgamma, ops::LgammaOp,
                  ops::LgammaOpMaker,
                  ops::LgammaGradOpMaker<paddle::framework::OpDesc>,
                  ops::LgammaGradOpMaker<paddle::imperative::OpBase>,
                  ops::LgammaInferShapeFunctor);


REGISTER_OPERATOR(mv, ops::MvOp,
                  ops::MvOpMaker,
                  ops::MvGradOpMaker<paddle::framework::OpDesc>,
                  ops::MvGradOpMaker<paddle::imperative::OpBase>,
                  ops::MvInferShapeFunctor);


REGISTER_OPERATOR(poisson, ops::PoissonOp,
                  ops::PoissonOpMaker,
                  ops::PoissonGradOpMaker<paddle::framework::OpDesc>,
                  ops::PoissonGradOpMaker<paddle::imperative::OpBase>,
                  ops::PoissonInferShapeFunctor);


REGISTER_OPERATOR(solve, ops::SolveOp,
                  ops::SolveOpMaker,
                  ops::SolveGradOpMaker<paddle::framework::OpDesc>,
                  ops::SolveGradOpMaker<paddle::imperative::OpBase>,
                  ops::SolveInferShapeFunctor);


REGISTER_OPERATOR(trace, ops::TraceOp,
                  ops::TraceOpMaker,
                  ops::TraceGradOpMaker<paddle::framework::OpDesc>,
                  ops::TraceGradOpMaker<paddle::imperative::OpBase>,
                  ops::TraceInferShapeFunctor);

REGISTER_OP_VERSION(trace)
  .AddCheckpoint(
    R"ROC(Upgrade trace add a new attribute [axis2])ROC",
      paddle::framework::compatible::OpVersionDesc()
        .NewAttr("axis1", "The added attribute 'axis1' is not yet registered.", std::vector<float>{0.0f})
        .NewAttr("None", "The added attribute 'axis2' is not yet registered.", std::vector<float>{1.0f})
        .DeleteAttr("dim1", "The attribute 'dim1' is not recommend according to the specification 2.0.")
        .DeleteAttr("dim2", "The attribute 'dim2' is not recommend according to the specification 2.0."))
;

REGISTER_OPERATOR(trunc, ops::TruncOp,
                  ops::TruncOpMaker,
                  ops::TruncGradOpMaker<paddle::framework::OpDesc>,
                  ops::TruncGradOpMaker<paddle::imperative::OpBase>,
                  ops::TruncInferShapeFunctor);


REGISTER_OPERATOR(flip, ops::FlipOp,
                  ops::FlipOpMaker,
                  ops::FlipGradOpMaker<paddle::framework::OpDesc>,
                  ops::FlipGradOpMaker<paddle::imperative::OpBase>,
                  ops::FlipInferShapeFunctor);

REGISTER_OP_VERSION(flip)
  .AddCheckpoint(
    R"ROC(Upgrade flip, add new attr [axis] and delete attr [dims])ROC",
      paddle::framework::compatible::OpVersionDesc()
        .NewAttr("axis", "The added attr 'axis' doesn't set default value", paddle::none)
        .DeleteAttr("dims", "The attr 'dims' is deleted."))
;

REGISTER_OPERATOR(atan2_grad, ops::Atan2GradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::Atan2GradInferShapeFunctor);


REGISTER_OPERATOR(cholesky_grad, ops::CholeskyGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskyGradInferShapeFunctor);


REGISTER_OPERATOR(cholesky_solve_grad, ops::CholeskySolveGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskySolveGradInferShapeFunctor);


REGISTER_OPERATOR(cross_grad, ops::CrossGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CrossGradInferShapeFunctor);


REGISTER_OPERATOR(diag_v2_grad, ops::DiagV2GradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagV2GradNoNeedBufferVarInferer,
                  ops::DiagV2GradInferShapeFunctor);


REGISTER_OPERATOR(diagonal_grad, ops::DiagonalGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagonalGradNoNeedBufferVarInferer,
                  ops::DiagonalGradInferShapeFunctor);


REGISTER_OPERATOR(digamma_grad, ops::DigammaGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DigammaGradInferShapeFunctor);


REGISTER_OPERATOR(dist_grad, ops::DistGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DistGradInferShapeFunctor);


REGISTER_OPERATOR(dot_grad, ops::DotGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DotGradInferShapeFunctor);


REGISTER_OPERATOR(erf_grad, ops::ErfGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfGradInferShapeFunctor);


REGISTER_OPERATOR(erfinv_grad, ops::ErfinvGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfinvGradInferShapeFunctor);


REGISTER_OPERATOR(fft_c2c_grad, ops::FftC2cGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftC2cGradInferShapeFunctor);


REGISTER_OPERATOR(fft_c2r_grad, ops::FftC2rGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftC2rGradInferShapeFunctor);


REGISTER_OPERATOR(fft_r2c_grad, ops::FftR2cGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::FftR2cGradNoNeedBufferVarInferer,
                  ops::FftR2cGradInferShapeFunctor);


REGISTER_OPERATOR(graph_send_uv_grad, ops::GraphSendUvGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::GraphSendUvGradInferShapeFunctor);


REGISTER_OPERATOR(lgamma_grad, ops::LgammaGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::LgammaGradInferShapeFunctor);


REGISTER_OPERATOR(mv_grad, ops::MvGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::MvGradInferShapeFunctor);


REGISTER_OPERATOR(poisson_grad, ops::PoissonGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::PoissonGradInferShapeFunctor);


REGISTER_OPERATOR(solve_grad, ops::SolveGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::SolveGradInferShapeFunctor);


REGISTER_OPERATOR(trace_grad, ops::TraceGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::TraceGradNoNeedBufferVarInferer,
                  ops::TraceGradInferShapeFunctor);


REGISTER_OPERATOR(trunc_grad, ops::TruncGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::TruncGradInferShapeFunctor);


