// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/phi/kernels/gelu_kernel.h"

#include "glog/logging.h"
#include "paddle/phi/backends/xpu/enforce_xpu.h"
#include "paddle/phi/backends/xpu/xpu_context.h"
#include "paddle/phi/common/float16.h"
#include "paddle/phi/core/kernel_registry.h"

namespace phi {

template <typename T, typename Context>
void GeluKernel(const Context& dev_ctx,
                const DenseTensor& x,
                bool approximate,
                DenseTensor* out) {
  using XPUType = typename XPUTypeTrait<T>::Type;
  dev_ctx.template Alloc<T>(out);
  if (approximate) {
    // int approximate_gelu(Context* ctx, const T* x, T* y, int64_t len, const
    // float* max_x = nullptr, float* max_y = nullptr);
    int r = xpu::approximate_gelu<XPUType>(
        dev_ctx.x_context(),
        reinterpret_cast<const XPUType*>(x.data<T>()),
        reinterpret_cast<XPUType*>(out->data<T>()),
        out->numel());
    PADDLE_ENFORCE_XDNN_SUCCESS(r, "approximate_gelu");
  } else {
    // int gelu(Context* ctx, const T* x, T* y, int64_t len, const float* max_x
    // = nullptr, float* max_y = nullptr);
    int r = xpu::gelu<XPUType>(dev_ctx.x_context(),
                               reinterpret_cast<const XPUType*>(x.data<T>()),
                               reinterpret_cast<XPUType*>(out->data<T>()),
                               out->numel());
    PADDLE_ENFORCE_XDNN_SUCCESS(r, "gelu");
  }
}
}  // namespace phi

PD_REGISTER_KERNEL(
    gelu, XPU, ALL_LAYOUT, phi::GeluKernel, float, phi::dtype::float16) {}
