## PDSA-2022-002: Code injection in paddle.audio.functional.get_window

### 影响

`paddle.audio.functional.get_window`由于使用`eval`用户提供的参数`winstr`而存在代码注入漏洞，将导致任意代码执行。

```python
def get_window(
    window: Union[str, Tuple[str, float]],
    win_length: int,
    fftbins: bool = True,
    dtype: str = 'float64',
) -> Tensor:
    ...
    try:
        winfunc = eval('_' + winstr)
    except NameError as e:
        raise ValueError("Unknown window type.") from e
```

### 补丁

我们在commit [26c419ca386aeae3c461faf2b828d00b48e908eb](https://github.com/PaddlePaddle/Paddle/commit/26c419ca386aeae3c461faf2b828d00b48e908eb)中对此问题进行了补丁。

修复将包含在飞桨2.4版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Tong Liu of ShanghaiTech University 提交。
