// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/phi/core/compat/op_utils.h"

namespace phi {

KernelSignature SGDOpArgumentMapping(const ArgumentMappingContext& ctx) {
  if (ctx.IsDenseTensorInput("Grad")) {
    return KernelSignature("sgd",
                           {"Param", "LearningRate", "Grad", "MasterParam"},
                           {"multi_precision"},
                           {"ParamOut", "MasterParamOut"});
  } else if (ctx.IsSelectedRowsInput("Grad")) {
    if (ctx.IsDenseTensorInput("Param")) {
      return KernelSignature("sgd_dense_param_sparse_grad",
                             {"Param", "LearningRate", "Grad", "MasterParam"},
                             {"multi_precision"},
                             {"ParamOut", "MasterParamOut"});
    } else {
      return KernelSignature("sgd_sparse_param_sparse_grad",
                             {"Param", "LearningRate", "Grad", "MasterParam"},
                             {"multi_precision"},
                             {"ParamOut", "MasterParamOut"});
    }
  }

  return KernelSignature("unregistered", {}, {}, {});
}

}  // namespace phi

PD_REGISTER_ARG_MAPPING_FN(sgd, phi::SGDOpArgumentMapping);
