// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/phi/api/ext/dispatch.h"
#include "paddle/phi/backends/xpu/enforce_xpu.h"
#include "paddle/phi/core/kernel_registry.h"
#include "paddle/phi/kernels/impl/elementwise_kernel_impl.h"

namespace phi {

template <typename T, typename Context>
void GradAddXPUKernel(const Context& dev_ctx,
                      const DenseTensor& x,
                      const DenseTensor& y,
                      DenseTensor* out) {
  dev_ctx.template Alloc<T>(out);
  auto x_shape = phi::vectorize<int>(x.dims());
  auto y_shape = phi::vectorize<int>(y.dims());
  int r = xpu::broadcast_add(dev_ctx.x_context(),
                             x.data<T>(),
                             y.data<T>(),
                             out->data<T>(),
                             x_shape,
                             y_shape);
  PADDLE_ENFORCE_XDNN_SUCCESS(r, "broadcast_add");
}

}  // namespace phi

PD_REGISTER_KERNEL(grad_add, XPU, ALL_LAYOUT, phi::GradAddXPUKernel, float) {}
