// this file is generated by paddle/phi/api/yaml/generator/generate_op.py, do not edit.
#include <string>
#include "paddle/fluid/framework/infershape_utils.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/framework/op_version_registry.h"
#include "paddle/fluid/framework/convert_utils.h"
#include "paddle/phi/core/infermeta_utils.h"
#include "paddle/phi/infermeta/nullary.h"
#include "paddle/phi/infermeta/unary.h"
#include "paddle/phi/infermeta/binary.h"
#include "paddle/phi/infermeta/ternary.h"
#include "paddle/phi/infermeta/multiary.h"
#include "paddle/phi/infermeta/backward.cc"

namespace paddle {
namespace operators {

using paddle::framework::GradVarName;


class Atan2OpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X1", "(Tensor), input 0 of atan2 op.");
    AddInput("X2", "(Tensor), input 1 of atan2 op.");
    AddOutput("Out", "(Tensor), output 0 of atan2 op.");
    AddComment(R"DOC(
TODO: Documentation of atan2 op.
)DOC");
  }
};


class Atan2Op : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(atan2, Atan2InferShapeFunctor,
                            PD_INFER_META(phi::Atan2InferMeta));



class BernoulliOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of bernoulli op.");
    AddOutput("Out", "(Tensor), output 0 of bernoulli op.");
    AddComment(R"DOC(
TODO: Documentation of bernoulli op.
)DOC");
  }
};


class BernoulliOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(bernoulli, BernoulliInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class CholeskyOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cholesky op.");
    AddOutput("Out", "(Tensor), output 0 of cholesky op.");
    AddAttr<bool>("upper", "(bool), attribute 0 for cholesky op.")
        .SetDefault(false);
    AddComment(R"DOC(
TODO: Documentation of cholesky op.
)DOC");
  }
};


class CholeskyOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky, CholeskyInferShapeFunctor,
                            PD_INFER_META(phi::CholeskyInferMeta));



class CholeskySolveOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cholesky_solve op.");
    AddInput("Y", "(Tensor), input 1 of cholesky_solve op.");
    AddOutput("Out", "(Tensor), output 0 of cholesky_solve op.");
    AddAttr<bool>("upper", "(bool), attribute 0 for cholesky_solve op.")
        .SetDefault(false);
    AddComment(R"DOC(
TODO: Documentation of cholesky_solve op.
)DOC");
  }
};


class CholeskySolveOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_solve, CholeskySolveInferShapeFunctor,
                            PD_INFER_META(phi::CholeskySolveInferMeta));



class CrossOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of cross op.");
    AddInput("Y", "(Tensor), input 1 of cross op.");
    AddOutput("Out", "(Tensor), output 0 of cross op.");
    AddAttr<int>("dim", "(int), attribute 0 for cross op.")
        .SetDefault(9);
    AddComment(R"DOC(
TODO: Documentation of cross op.
)DOC");
  }
};


class CrossOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "X");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(cross, CrossInferShapeFunctor,
                            PD_INFER_META(phi::CrossInferMeta));



class DiagV2OpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of diag_v2 op.");
    AddOutput("Out", "(Tensor), output 0 of diag_v2 op.");
    AddAttr<int>("offset", "(int), attribute 0 for diag_v2 op.")
        .SetDefault(0);
    AddAttr<float>("padding_value", "(float), attribute 1 for diag_v2 op.")
        .SetDefault(0.0);
    AddComment(R"DOC(
TODO: Documentation of diag_v2 op.
)DOC");
  }
};


class DiagV2Op : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(diag_v2, DiagV2InferShapeFunctor,
                            PD_INFER_META(phi::DiagInferMeta));



class DiagonalOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("Input", "(Tensor), input 0 of diagonal op.");
    AddOutput("Out", "(Tensor), output 0 of diagonal op.");
    AddAttr<int>("offset", "(int), attribute 0 for diagonal op.")
        .SetDefault(0);
    AddAttr<int>("axis1", "(int), attribute 1 for diagonal op.")
        .SetDefault(0);
    AddAttr<int>("axis2", "(int), attribute 2 for diagonal op.")
        .SetDefault(1);
    AddComment(R"DOC(
TODO: Documentation of diagonal op.
)DOC");
  }
};


class DiagonalOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(diagonal, DiagonalInferShapeFunctor,
                            PD_INFER_META(phi::DiagonalInferMeta));



class DigammaOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of digamma op.");
    AddOutput("Out", "(Tensor), output 0 of digamma op.");
    AddComment(R"DOC(
TODO: Documentation of digamma op.
)DOC");
  }
};


class DigammaOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(digamma, DigammaInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class DistOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of dist op.");
    AddInput("Y", "(Tensor), input 1 of dist op.");
    AddOutput("Out", "(Tensor), output 0 of dist op.");
    AddAttr<float>("p", "(float), attribute 0 for dist op.")
        .SetDefault(2.0);
    AddComment(R"DOC(
TODO: Documentation of dist op.
)DOC");
  }
};


class DistOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(dist, DistInferShapeFunctor,
                            PD_INFER_META(phi::DistInferMeta));



class DotOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of dot op.");
    AddInput("Y", "(Tensor), input 1 of dot op.");
    AddOutput("Out", "(Tensor), output 0 of dot op.");
    AddComment(R"DOC(
TODO: Documentation of dot op.
)DOC");
  }
};


class DotOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, "X");
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(dot, DotInferShapeFunctor,
                            PD_INFER_META(phi::DotInferMeta));



class ErfOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of erf op.");
    AddOutput("Out", "(Tensor), output 0 of erf op.");
    AddComment(R"DOC(
TODO: Documentation of erf op.
)DOC");
  }
};


class ErfOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(erf, ErfInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class MvOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of mv op.");
    AddInput("Vec", "(Tensor), input 1 of mv op.");
    AddOutput("Out", "(Tensor), output 0 of mv op.");
    AddComment(R"DOC(
TODO: Documentation of mv op.
)DOC");
  }
};


class MvOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(mv, MvInferShapeFunctor,
                            PD_INFER_META(phi::MvInferMeta));



class PoissonOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of poisson op.");
    AddOutput("Out", "(Tensor), output 0 of poisson op.");
    AddComment(R"DOC(
TODO: Documentation of poisson op.
)DOC");
  }
};


class PoissonOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(poisson, PoissonInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



class TraceOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("Input", "(Tensor), input 0 of trace op.");
    AddOutput("Out", "(Tensor), output 0 of trace op.");
    AddAttr<int>("offset", "(int), attribute 0 for trace op.")
        .SetDefault(0);
    AddAttr<int>("axis1", "(int), attribute 1 for trace op.")
        .SetDefault(0);
    AddAttr<int>("axis2", "(int), attribute 2 for trace op.")
        .SetDefault(1);
    AddComment(R"DOC(
TODO: Documentation of trace op.
)DOC");
  }
};


class TraceOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trace, TraceInferShapeFunctor,
                            PD_INFER_META(phi::TraceInferMeta));



class TruncOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddInput("X", "(Tensor), input 0 of trunc op.");
    AddOutput("Out", "(Tensor), output 0 of trunc op.");
    AddComment(R"DOC(
TODO: Documentation of trunc op.
)DOC");
  }
};


class TruncOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trunc, TruncInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));




template <typename T>
class Atan2GradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("atan2_grad");

    grad_op->SetInput("X1", this->Input("X1"));
    grad_op->SetInput("X2", this->Input("X2"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X1"), this->InputGrad("X1"));
    grad_op->SetOutput(GradVarName("X2"), this->InputGrad("X2"));

  }
};


class Atan2GradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(atan2_grad, Atan2GradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class CholeskyGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cholesky_grad");

    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

    grad_op->SetAttr("upper", this->GetAttr("upper"));
  }
};


class CholeskyGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_grad, CholeskyGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class CholeskySolveGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cholesky_solve_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

    grad_op->SetAttr("upper", this->GetAttr("upper"));
  }
};


class CholeskySolveGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(cholesky_solve_grad, CholeskySolveGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class CrossGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("cross_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

    grad_op->SetAttr("dim", this->GetAttr("dim"));
  }
};


class CrossGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(cross_grad, CrossGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class DiagV2GradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("diag_v2_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

    grad_op->SetAttr("offset", this->GetAttr("offset"));
  }
};


class DiagV2GradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(diag_v2_grad, DiagV2GradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(DiagV2GradNoNeedBufferVarInferer,
                                    "X");


template <typename T>
class DiagonalGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("diagonal_grad");

    grad_op->SetInput("Input", this->Input("Input"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("Input"), this->InputGrad("Input"));

    grad_op->SetAttr("offset", this->GetAttr("offset"));
    grad_op->SetAttr("axis1", this->GetAttr("axis1"));
    grad_op->SetAttr("axis2", this->GetAttr("axis2"));
  }
};


class DiagonalGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(diagonal_grad, DiagonalGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(DiagonalGradNoNeedBufferVarInferer,
                                    "Input");


template <typename T>
class DigammaGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("digamma_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  }
};


class DigammaGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(digamma_grad, DigammaGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class DistGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("dist_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput("Out", this->Output("Out"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

    grad_op->SetAttr("p", this->GetAttr("p"));
  }
};


class DistGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(dist_grad, DistGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class DotGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("dot_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Y", this->Input("Y"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Y"), this->InputGrad("Y"));

  }
};


class DotGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(dot_grad, DotGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class ErfGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("erf_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  }
};


class ErfGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(erf_grad, ErfGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class MvGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("mv_grad");

    grad_op->SetInput("X", this->Input("X"));
    grad_op->SetInput("Vec", this->Input("Vec"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));
    grad_op->SetOutput(GradVarName("Vec"), this->InputGrad("Vec"));

  }
};


class MvGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(mv_grad, MvGradInferShapeFunctor,
                            PD_INFER_META(phi::GeneralBinaryGradInferMeta));



template <typename T>
class PoissonGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("poisson_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  }
};


class PoissonGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(poisson_grad, PoissonGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));



template <typename T>
class TraceGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("trace_grad");

    grad_op->SetInput("Input", this->Input("Input"));
    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("Input"), this->InputGrad("Input"));

    grad_op->SetAttr("offset", this->GetAttr("offset"));
    grad_op->SetAttr("axis1", this->GetAttr("axis1"));
    grad_op->SetAttr("axis2", this->GetAttr("axis2"));
  }
};


class TraceGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
 protected:
  framework::OpKernelType GetExpectedKernelType(
      const framework::ExecutionContext& ctx) const override {
    auto data_type = framework::OperatorWithKernel::IndicateVarDataType(ctx, GradVarName("Out"));
    return framework::OpKernelType(data_type, ctx.GetPlace());
  }

};

DECLARE_INFER_SHAPE_FUNCTOR(trace_grad, TraceGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));

DECLARE_NO_NEED_BUFFER_VARS_INFERER(TraceGradNoNeedBufferVarInferer,
                                    "Input");


template <typename T>
class TruncGradOpMaker : public framework::SingleGradOpMaker<T> {
 public:
  using framework::SingleGradOpMaker<T>::SingleGradOpMaker;

 protected:
  void Apply(GradOpPtr<T> grad_op) const override {
    grad_op->SetType("trunc_grad");

    grad_op->SetInput(GradVarName("Out"), this->OutputGrad("Out"));

    grad_op->SetOutput(GradVarName("X"), this->InputGrad("X"));

  }
};


class TruncGradOp : public framework::OperatorWithKernel {
 public:
  using framework::OperatorWithKernel::OperatorWithKernel;
};

DECLARE_INFER_SHAPE_FUNCTOR(trunc_grad, TruncGradInferShapeFunctor,
                            PD_INFER_META(phi::UnchangedInferMeta));


}  // namespace operators
}  // namespace paddle

namespace ops = paddle::operators;
REGISTER_OPERATOR(atan2, ops::Atan2Op,
                  ops::Atan2OpMaker,
                  ops::Atan2GradOpMaker<paddle::framework::OpDesc>,
                  ops::Atan2GradOpMaker<paddle::imperative::OpBase>,
                  ops::Atan2InferShapeFunctor);


REGISTER_OPERATOR(bernoulli, ops::BernoulliOp,
                  ops::BernoulliOpMaker,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::BernoulliInferShapeFunctor);


REGISTER_OPERATOR(cholesky, ops::CholeskyOp,
                  ops::CholeskyOpMaker,
                  ops::CholeskyGradOpMaker<paddle::framework::OpDesc>,
                  ops::CholeskyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskyInferShapeFunctor);


REGISTER_OPERATOR(cholesky_solve, ops::CholeskySolveOp,
                  ops::CholeskySolveOpMaker,
                  ops::CholeskySolveGradOpMaker<paddle::framework::OpDesc>,
                  ops::CholeskySolveGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskySolveInferShapeFunctor);


REGISTER_OPERATOR(cross, ops::CrossOp,
                  ops::CrossOpMaker,
                  ops::CrossGradOpMaker<paddle::framework::OpDesc>,
                  ops::CrossGradOpMaker<paddle::imperative::OpBase>,
                  ops::CrossInferShapeFunctor);


REGISTER_OPERATOR(diag_v2, ops::DiagV2Op,
                  ops::DiagV2OpMaker,
                  ops::DiagV2GradOpMaker<paddle::framework::OpDesc>,
                  ops::DiagV2GradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagV2InferShapeFunctor);


REGISTER_OPERATOR(diagonal, ops::DiagonalOp,
                  ops::DiagonalOpMaker,
                  ops::DiagonalGradOpMaker<paddle::framework::OpDesc>,
                  ops::DiagonalGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagonalInferShapeFunctor);


REGISTER_OPERATOR(digamma, ops::DigammaOp,
                  ops::DigammaOpMaker,
                  ops::DigammaGradOpMaker<paddle::framework::OpDesc>,
                  ops::DigammaGradOpMaker<paddle::imperative::OpBase>,
                  ops::DigammaInferShapeFunctor);


REGISTER_OPERATOR(dist, ops::DistOp,
                  ops::DistOpMaker,
                  ops::DistGradOpMaker<paddle::framework::OpDesc>,
                  ops::DistGradOpMaker<paddle::imperative::OpBase>,
                  ops::DistInferShapeFunctor);


REGISTER_OPERATOR(dot, ops::DotOp,
                  ops::DotOpMaker,
                  ops::DotGradOpMaker<paddle::framework::OpDesc>,
                  ops::DotGradOpMaker<paddle::imperative::OpBase>,
                  ops::DotInferShapeFunctor);


REGISTER_OPERATOR(erf, ops::ErfOp,
                  ops::ErfOpMaker,
                  ops::ErfGradOpMaker<paddle::framework::OpDesc>,
                  ops::ErfGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfInferShapeFunctor);


REGISTER_OPERATOR(mv, ops::MvOp,
                  ops::MvOpMaker,
                  ops::MvGradOpMaker<paddle::framework::OpDesc>,
                  ops::MvGradOpMaker<paddle::imperative::OpBase>,
                  ops::MvInferShapeFunctor);


REGISTER_OPERATOR(poisson, ops::PoissonOp,
                  ops::PoissonOpMaker,
                  ops::PoissonGradOpMaker<paddle::framework::OpDesc>,
                  ops::PoissonGradOpMaker<paddle::imperative::OpBase>,
                  ops::PoissonInferShapeFunctor);


REGISTER_OPERATOR(trace, ops::TraceOp,
                  ops::TraceOpMaker,
                  ops::TraceGradOpMaker<paddle::framework::OpDesc>,
                  ops::TraceGradOpMaker<paddle::imperative::OpBase>,
                  ops::TraceInferShapeFunctor);

REGISTER_OP_VERSION(trace)
  .AddCheckpoint(
    R"ROC(Upgrade trace add a new attribute [axis2])ROC",
      paddle::framework::compatible::OpVersionDesc()
        .NewAttr("axis1", "The added attribute 'axis1' is not yet registered.", std::vector<float>{0.0f})
        .NewAttr("None", "The added attribute 'axis2' is not yet registered.", std::vector<float>{1.0f})
        .DeleteAttr("dim1", "The attribute 'dim1' is not recommend according to the specification 2.0.")
        .DeleteAttr("dim2", "The attribute 'dim2' is not recommend according to the specification 2.0."))
;

REGISTER_OPERATOR(trunc, ops::TruncOp,
                  ops::TruncOpMaker,
                  ops::TruncGradOpMaker<paddle::framework::OpDesc>,
                  ops::TruncGradOpMaker<paddle::imperative::OpBase>,
                  ops::TruncInferShapeFunctor);


REGISTER_OPERATOR(atan2_grad, ops::Atan2GradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::Atan2GradInferShapeFunctor);


REGISTER_OPERATOR(cholesky_grad, ops::CholeskyGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskyGradInferShapeFunctor);


REGISTER_OPERATOR(cholesky_solve_grad, ops::CholeskySolveGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CholeskySolveGradInferShapeFunctor);


REGISTER_OPERATOR(cross_grad, ops::CrossGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::CrossGradInferShapeFunctor);


REGISTER_OPERATOR(diag_v2_grad, ops::DiagV2GradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagV2GradNoNeedBufferVarInferer,
                  ops::DiagV2GradInferShapeFunctor);


REGISTER_OPERATOR(diagonal_grad, ops::DiagonalGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DiagonalGradNoNeedBufferVarInferer,
                  ops::DiagonalGradInferShapeFunctor);


REGISTER_OPERATOR(digamma_grad, ops::DigammaGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DigammaGradInferShapeFunctor);


REGISTER_OPERATOR(dist_grad, ops::DistGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DistGradInferShapeFunctor);


REGISTER_OPERATOR(dot_grad, ops::DotGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::DotGradInferShapeFunctor);


REGISTER_OPERATOR(erf_grad, ops::ErfGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::ErfGradInferShapeFunctor);


REGISTER_OPERATOR(mv_grad, ops::MvGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::MvGradInferShapeFunctor);


REGISTER_OPERATOR(poisson_grad, ops::PoissonGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::PoissonGradInferShapeFunctor);


REGISTER_OPERATOR(trace_grad, ops::TraceGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::TraceGradNoNeedBufferVarInferer,
                  ops::TraceGradInferShapeFunctor);


REGISTER_OPERATOR(trunc_grad, ops::TruncGradOp,
                  paddle::framework::EmptyGradOpMaker<paddle::framework::OpDesc>,
                  paddle::framework::EmptyGradOpMaker<paddle::imperative::OpBase>,
                  ops::TruncGradInferShapeFunctor);


