#include "glog/logging.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"

paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_powGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_powGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_powGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_pow_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> p_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: p_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = p_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("p_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> c_concatGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: c_concatGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = c_concatGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_split", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> lod_resetGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: lod_resetGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = lod_resetGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lod_reset_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> padGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: padGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = padGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pad_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sequence_convGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: sequence_convGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sequence_convGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Filter", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Filter_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Filter@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_conv_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Filter@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Filter@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> set_valueGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(5);
    VLOG(3) << "Running Eager Backward Node: set_valueGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = set_valueGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  if(this->EndsTensorList_.size() > 0) ins0["EndsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->EndsTensorList_));
  if(this->StartsTensorList_.size() > 0) ins0["StartsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StartsTensorList_));
  if(this->StepsTensorList_.size() > 0) ins0["StepsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StepsTensorList_));
  auto ValueTensor = egr::EagerUtils::RecoverTensorWrapper(&this->ValueTensor_);
  if(ValueTensor.defined()) ins0["ValueTensor"] =      egr::EagerUtils::TrySyncToVars(ValueTensor);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if(ValueTensor.defined() && (!out_metas[1].empty()) && (!out_metas[1][0].IsStopGradient())) outs0["ValueTensor@GRAD"] = {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())};
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("set_value_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }
 if (outs0.find("ValueTensor@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["ValueTensor@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> log10GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: log10GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = log10GradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log10_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> center_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: center_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = center_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[2]) },{ "SampleCenterDiff", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SampleCenterDiff_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("center_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sliceGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(5);
    VLOG(3) << "Running Eager Backward Node: sliceGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sliceGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  auto EndsTensor = egr::EagerUtils::RecoverTensorWrapper(&this->EndsTensor_);
  if(EndsTensor.defined()) ins0["EndsTensor"] =      egr::EagerUtils::TrySyncToVars(EndsTensor);
  if(this->EndsTensorList_.size() > 0) ins0["EndsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->EndsTensorList_));
  auto StartsTensor = egr::EagerUtils::RecoverTensorWrapper(&this->StartsTensor_);
  if(StartsTensor.defined()) ins0["StartsTensor"] =      egr::EagerUtils::TrySyncToVars(StartsTensor);
  if(this->StartsTensorList_.size() > 0) ins0["StartsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StartsTensorList_));
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("slice_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> meshgridGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: meshgridGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = meshgridGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if(!out_metas[0].empty()){ outs0.insert({ "X@GRAD", egr::EagerUtils::CreateVars(out_metas[0].size())});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("meshgrid_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hard_swishGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: hard_swishGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = hard_swishGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("hard_swish_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sinGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: sinGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sinGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sin_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pad2dGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pad2dGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pad2dGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pad2d_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> inverseGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: inverseGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = inverseGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Output", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Output_)) },{ "Output@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("inverse_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> spectral_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: spectral_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = spectral_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "U", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->U_)) },{ "V", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->V_)) },{ "Weight", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Weight_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Weight@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("spectral_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Weight@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Weight@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> shuffle_channelGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: shuffle_channelGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = shuffle_channelGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("shuffle_channel_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> psroi_poolGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: psroi_poolGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = psroi_poolGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ROIs", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ROIs_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto RoisNum = egr::EagerUtils::RecoverTensorWrapper(&this->RoisNum_);
  if(RoisNum.defined()) ins0["RoisNum"] =      egr::EagerUtils::TrySyncToVars(RoisNum);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("psroi_pool_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ceilGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: ceilGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = ceilGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("ceil_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> eigGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: eigGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = eigGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Eigenvalues", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Eigenvalues_)) },{ "Eigenvalues@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Eigenvectors", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Eigenvectors_)) },{ "Eigenvectors@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("eig_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reduce_minGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reduce_minGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reduce_minGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_min_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cosGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: cosGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cosGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cos_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cudnn_lstmGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: cudnn_lstmGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cudnn_lstmGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "InitC", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->InitC_)) },{ "InitH", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->InitH_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "LastC@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[4]) },{ "LastH@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[3]) },{ "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[2]) },{ "Reserve", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Reserve_)) },{ "StateOut", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StateOut_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "InitC@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "InitH@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cudnn_lstm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("InitC@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["InitC@GRAD"]); }
 if (outs0.find("InitH@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["InitH@GRAD"]); }
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reduce_sumGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reduce_sumGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reduce_sumGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_sum_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> digammaGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: digammaGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = digammaGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("digamma_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> incrementGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: incrementGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = incrementGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("increment", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> fused_softmax_maskGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: fused_softmax_maskGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = fused_softmax_maskGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Softmax", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fused_softmax_mask_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sequence_reverseGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: sequence_reverseGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sequence_reverseGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_reverse", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Y") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Y"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> eigvalshGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: eigvalshGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = eigvalshGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Eigenvalues@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Eigenvectors", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Eigenvectors_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("eigvalsh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> diagonalGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: diagonalGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = diagonalGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("diagonal_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> truncGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: truncGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = truncGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("trunc_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> log2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: log2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = log2GradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> tanhGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: tanhGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = tanhGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tanh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> yolov3_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: yolov3_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = yolov3_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "GTBox", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->GTBox_)) },{ "GTLabel", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->GTLabel_)) },{ "GTMatchMask", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->GTMatchMask_)) },{ "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ObjectnessMask", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ObjectnessMask_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto GTScore = egr::EagerUtils::RecoverTensorWrapper(&this->GTScore_);
  if(GTScore.defined()) ins0["GTScore"] =      egr::EagerUtils::TrySyncToVars(GTScore);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("yolov3_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> graph_send_recvGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: graph_send_recvGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = graph_send_recvGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Dst_index", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Dst_index_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Src_index", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Src_index_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("graph_send_recv_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> atanGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: atanGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = atanGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("atan_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reduce_amaxGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reduce_amaxGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reduce_amaxGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_amax_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> unsqueezeGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: unsqueezeGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = unsqueezeGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("unsqueeze_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> global_gatherGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: global_gatherGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = global_gatherGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "global_count", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->global_count_)) },{ "local_count", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->local_count_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("global_scatter", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> lerpGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: lerpGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = lerpGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Weight", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Weight_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lerp_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> log_softmaxGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: log_softmaxGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = log_softmaxGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log_softmax_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> top_k_v2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: top_k_v2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = top_k_v2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Indices", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Indices_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("top_k_v2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> castGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: castGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = castGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  auto temp_type = attrs_map0["in_dtype"];
  attrs_map0["in_dtype"] = attrs_map0["out_dtype"];
  attrs_map0["out_dtype"] = temp_type;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cast", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> tanh_shrinkGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: tanh_shrinkGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = tanh_shrinkGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tanh_shrink_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hard_shrinkGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: hard_shrinkGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = hard_shrinkGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("hard_shrink_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> logitGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: logitGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = logitGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("logit_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sequence_unpadGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: sequence_unpadGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sequence_unpadGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_unpad_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
