#include "glog/logging.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"

paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pad3dGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pad3dGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pad3dGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pad3d_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Norm", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Norm_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> mishGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: mishGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = mishGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mish_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> flattenGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: flattenGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = flattenGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> margin_cross_entropyGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: margin_cross_entropyGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = margin_cross_entropyGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "Logits", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Logits_)) },{ "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "Softmax", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Softmax_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Logits@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("margin_cross_entropy_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Logits@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Logits@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pull_sparseGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: pull_sparseGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pull_sparseGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Ids", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Ids_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "W", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->W_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ 
 outs0.insert({ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0])});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("push_sparse", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
  if (outs0.find("Out@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> powGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: powGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = powGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pow_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> stanhGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: stanhGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = stanhGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("stanh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> label_smoothGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: label_smoothGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = label_smoothGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("label_smooth_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> foldGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: foldGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = foldGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fold_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> roi_perspective_transformGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: roi_perspective_transformGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = roi_perspective_transformGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out2InIdx", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out2InIdx_)) },{ "Out2InWeights", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out2InWeights_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ROIs", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ROIs_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("roi_perspective_transform_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> expandGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: expandGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = expandGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto ExpandTimes = egr::EagerUtils::RecoverTensorWrapper(&this->ExpandTimes_);
  if(ExpandTimes.defined()) ins0["ExpandTimes"] =      egr::EagerUtils::TrySyncToVars(ExpandTimes);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expand_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> prroi_poolGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: prroi_poolGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = prroi_poolGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ROIs", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ROIs_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto BatchRoINums = egr::EagerUtils::RecoverTensorWrapper(&this->BatchRoINums_);
  if(BatchRoINums.defined()) ins0["BatchRoINums"] =      egr::EagerUtils::TrySyncToVars(BatchRoINums);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "ROIs@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("prroi_pool_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("ROIs@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["ROIs@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pool3dGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pool3dGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pool3dGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pool3d_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> frameGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: frameGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = frameGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("frame_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> modeGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: modeGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = modeGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Indices", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Indices_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mode_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> group_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: group_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = group_normGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Y@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Mean", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Mean_)) },{ "Variance", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Variance_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  auto Bias = egr::EagerUtils::RecoverTensorWrapper(&this->Bias_);
  if(Bias.defined()) ins0["Bias"] =      egr::EagerUtils::TrySyncToVars(Bias);
  auto Scale = egr::EagerUtils::RecoverTensorWrapper(&this->Scale_);
  if(Scale.defined()) ins0["Scale"] =      egr::EagerUtils::TrySyncToVars(Scale);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if(Bias.defined() && (!out_metas[2].empty()) && (!out_metas[2][0].IsStopGradient())) outs0["Bias@GRAD"] = {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())};
  if(Scale.defined() && (!out_metas[1].empty()) && (!out_metas[1][0].IsStopGradient())) outs0["Scale@GRAD"] = {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())};
  if (can_be_inplaced0 && ins0.count("Y@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Y@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("group_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Scale@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Scale@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> c_softmax_with_cross_entropyGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: c_softmax_with_cross_entropyGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = c_softmax_with_cross_entropyGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto backward_inplace_tensor0 = egr::EagerUtils::RecoverTensorWrapper(&this->Softmax_);
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Softmax) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == (&this->Softmax_)->get_intermidiate_tensor().impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "Softmax", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Softmax_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Logits@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Softmax") && outs0.count("Logits@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Softmax"][0], outs0["Logits@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_softmax_with_cross_entropy_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Logits@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Logits@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sequence_expand_asGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: sequence_expand_asGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sequence_expand_asGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_expand_as_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cos_simGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: cos_simGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cos_simGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "XNorm", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->XNorm_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) },{ "YNorm", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->YNorm_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cos_sim_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_fminGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_fminGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_fminGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_fmin_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> qrGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: qrGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = qrGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Q", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Q_)) },{ "Q@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "R", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->R_)) },{ "R@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("qr_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> layer_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: layer_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = layer_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Mean", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Mean_)) },{ "Variance", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Variance_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  auto Bias = egr::EagerUtils::RecoverTensorWrapper(&this->Bias_);
  if(Bias.defined()) ins0["Bias"] =      egr::EagerUtils::TrySyncToVars(Bias);
  auto Scale = egr::EagerUtils::RecoverTensorWrapper(&this->Scale_);
  if(Scale.defined()) ins0["Scale"] =      egr::EagerUtils::TrySyncToVars(Scale);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if(Bias.defined() && (!out_metas[2].empty()) && (!out_metas[2][0].IsStopGradient())) outs0["Bias@GRAD"] = {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())};
  if(Scale.defined() && (!out_metas[1].empty()) && (!out_metas[1][0].IsStopGradient())) outs0["Scale@GRAD"] = {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())};
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("layer_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Scale@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Scale@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> acoshGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: acoshGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = acoshGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("acosh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> stftGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: stftGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = stftGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Window", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Window_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("stft_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> rnnGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: rnnGradNodeCompat";
egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[2], this->InputMeta()[2]);
egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[3], this->InputMeta()[3]);
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = rnnGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "DropoutState", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->DropoutState_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[2]) },{ "PreState", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->PreState_)) },{ "Reserve", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Reserve_)) },{ "State@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[3]) },{ "WeightList", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->WeightList_)) } };
  auto SequenceLength = egr::EagerUtils::RecoverTensorWrapper(&this->SequenceLength_);
  if(SequenceLength.defined()) ins0["SequenceLength"] =      egr::EagerUtils::TrySyncToVars(SequenceLength);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if(!out_metas[1].empty()){ outs0.insert({ "PreState@GRAD", egr::EagerUtils::CreateVars(out_metas[1].size())});} 
  if(!out_metas[2].empty()){ outs0.insert({ "WeightList@GRAD", egr::EagerUtils::CreateVars(out_metas[2].size())});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("rnn_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }
 if (outs0.find("PreState@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["PreState@GRAD"]); }
 if (outs0.find("WeightList@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["WeightList@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hard_sigmoidGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: hard_sigmoidGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = hard_sigmoidGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("hard_sigmoid_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> correlationGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: correlationGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = correlationGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Input1", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input1_)) },{ "Input2", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input2_)) },{ "Output@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input1@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Input2@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("correlation_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input1@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input1@GRAD"]); }
 if (outs0.find("Input2@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Input2@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> nanmedianGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: nanmedianGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = nanmedianGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "MedianIndex", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->MedianIndex_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nanmedian_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> segment_poolGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: segment_poolGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = segment_poolGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "SegmentIds", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SegmentIds_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("segment_pool_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sync_batch_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(5);
    VLOG(3) << "Running Eager Backward Node: sync_batch_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sync_batch_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Bias", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Bias_)) },{ "SavedMean", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedMean_)) },{ "SavedVariance", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedVariance_)) },{ "Scale", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Scale_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Bias@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Scale@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sync_batch_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Scale@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Scale@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> filter_by_instagGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: filter_by_instagGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = filter_by_instagGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "IndexMap", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->IndexMap_)) },{ "Ins", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Ins_)) },{ "LossWeight", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->LossWeight_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Ins@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("filter_by_instag_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Ins@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Ins@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> expand_as_v2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: expand_as_v2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = expand_as_v2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expand_as_v2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> diag_v2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: diag_v2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = diag_v2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("diag_v2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pull_box_sparseGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pull_box_sparseGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pull_box_sparseGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Ids", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Ids_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ 
 outs0.insert({ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0])});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("push_box_sparse", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
  if (outs0.find("Out@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> nll_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: nll_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = nll_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Total_weight", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Total_weight_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto Weight = egr::EagerUtils::RecoverTensorWrapper(&this->Weight_);
  if(Weight.defined()) ins0["Weight"] =      egr::EagerUtils::TrySyncToVars(Weight);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nll_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> dotGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: dotGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = dotGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dot_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> scaleGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: scaleGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = scaleGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(X) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("X") && outs0.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["X"][0], outs0["Out"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  attrs_map0["bias"] = float(0.0f);
  attrs_map0["bias_after_scale"] = bool(true);
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("scale", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> shuffle_batchGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: shuffle_batchGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = shuffle_batchGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ShuffleIdx", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ShuffleIdx_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("shuffle_batch_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> multiplexGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: multiplexGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = multiplexGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Ids", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Ids_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if(!out_metas[1].empty()){ outs0.insert({ "X@GRAD", egr::EagerUtils::CreateVars(out_metas[1].size())});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("multiplex_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> leaky_reluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: leaky_reluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = leaky_reluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("leaky_relu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
