
#include "paddle/phi/api/lib/dygraph_api.h"
#include "paddle/fluid/eager/api/generated/eager_generated/forwards/dygraph_functions.h"
#include "paddle/fluid/eager/api/generated/eager_generated/backwards/nodes.h"

#include "paddle/phi/api/include/sparse_api.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"
#include "paddle/fluid/eager/amp_utils.h"
#include "paddle/fluid/eager/eager_amp_auto_cast.h"
#include "paddle/phi/backends/gpu/gpu_info.h"
#include "paddle/fluid/eager/nan_inf_utils.h"
#include "paddle/fluid/eager/api/manual/eager_manual/dygraph_forward_api.h"
DECLARE_bool(check_nan_inf);

std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_args_info = {
    { "final_state_atan2", { "x","y" } },
{ "final_state_cholesky", { "x","upper" } },
{ "final_state_cholesky_solve", { "x","y","upper" } },
{ "final_state_cross", { "x","y","axis" } },
{ "final_state_diag", { "x","offset","padding_value" } },
{ "final_state_diagonal", { "x","offset","axis1","axis2" } },
{ "final_state_digamma", { "x" } },
{ "final_state_dist", { "x","y","p" } },
{ "final_state_dot", { "x","y" } },
{ "final_state_erf", { "x" } },
{ "final_state_mv", { "x","vec" } },
{ "final_state_poisson", { "x" } },
{ "final_state_trace", { "x","offset","axis1","axis2" } },
{ "final_state_trunc", { "x" } },
{ "final_state_abs", { "x" } },
{ "final_state_acos", { "x" } },
{ "final_state_acosh", { "x" } },
{ "final_state_add", { "x","y" } },
{ "final_state_addmm", { "input","x","y","alpha","beta" } },
{ "final_state_argsort", { "x","axis","descending" } },
{ "final_state_asin", { "x" } },
{ "final_state_asinh", { "x" } },
{ "final_state_assign", { "x" } },
{ "final_state_assign_out_", { "x","output" } },
{ "final_state_atan", { "x" } },
{ "final_state_atanh", { "x" } },
{ "final_state_batch_norm", { "x","scale","bias","mean","variance","momentum","epsilon","data_layout","is_test","use_global_stats","trainable_statistics","fuse_with_relu" } },
{ "final_state_bce_loss", { "input","label" } },
{ "final_state_brelu", { "x","t_min","t_max" } },
{ "final_state_cast", { "x","index_dtype","value_dtype" } },
{ "final_state_ceil", { "x" } },
{ "final_state_celu", { "x","alpha" } },
{ "final_state_clip", { "x","min","max" } },
{ "final_state_clip_", { "x","min","max" } },
{ "final_state_complex", { "x","y" } },
{ "final_state_concat", { "x","axis" } },
{ "final_state_conj", { "x" } },
{ "final_state_conv2d_transpose", { "x","filter","strides","paddings","output_padding","output_size","padding_algorithm","groups","dilations","data_format" } },
{ "final_state_conv3d", { "x","kernel","paddings","dilations","strides","groups","subm" } },
{ "final_state_conv3d_transpose", { "x","filter","strides","paddings","output_padding","output_size","padding_algorithm","groups","dilations","data_format" } },
{ "final_state_cos", { "x" } },
{ "final_state_cosh", { "x" } },
{ "final_state_cross_entropy_with_softmax", { "input","label","soft_label","use_softmax","numeric_stable_mode","ignore_index","axis" } },
{ "final_state_cumprod", { "x","dim" } },
{ "final_state_cumsum", { "x","axis","flatten","exclusive","reverse" } },
{ "final_state_deformable_conv", { "x","offset","filter","mask","strides","paddings","dilations","deformable_groups","groups","im2col_step" } },
{ "final_state_depthwise_conv2d", { "input","filter","strides","paddings","paddding_algorithm","groups","dilations","data_format","use_addto","workspace_size_MB","exhaustive_search","fuse_relu","use_gpudnn" } },
{ "final_state_depthwise_conv2d_transpose", { "x","filter","strides","paddings","output_padding","output_size","padding_algorithm","groups","dilations","data_format" } },
{ "final_state_det", { "x" } },
{ "final_state_divide", { "x","y" } },
{ "final_state_dropout", { "x","seed_tensor","p","is_test","mode","seed","fix_seed" } },
{ "final_state_eigh", { "x","uplo" } },
{ "final_state_einsum", { "x","equation" } },
{ "final_state_elementwise_pow", { "x","y" } },
{ "final_state_elu", { "x","alpha" } },
{ "final_state_embedding", { "x","weight","padding_idx","sparse" } },
{ "final_state_erfinv", { "x" } },
{ "final_state_erfinv_", { "x" } },
{ "final_state_exp", { "x" } },
{ "final_state_expand", { "x","shape" } },
{ "final_state_expand_as", { "x","y","target_shape" } },
{ "final_state_expm1", { "x" } },
{ "final_state_flatten", { "x","start_axis","stop_axis" } },
{ "final_state_flatten_", { "x","start_axis","stop_axis" } },
{ "final_state_flip", { "x","axis" } },
{ "final_state_floor", { "x" } },
{ "final_state_fmax", { "x","y","axis" } },
{ "final_state_fmin", { "x","y","axis" } },
{ "final_state_frobenius_norm", { "x","axis","keep_dim","reduce_all" } },
{ "final_state_gather", { "x","index","axis" } },
{ "final_state_gather_nd", { "x","index" } },
{ "final_state_gelu", { "x","approximate" } },
{ "final_state_graph_send_recv", { "x","src_index","dst_index","pool_type","out_size" } },
{ "final_state_group_norm", { "x","scale","bias","epsilon","groups","data_layout" } },
{ "final_state_gumbel_softmax", { "x","temperature","hard","axis" } },
{ "final_state_hard_shrink", { "x","threshold" } },
{ "final_state_hard_sigmoid", { "x","slope","offset" } },
{ "final_state_hard_swish", { "x","threshold","scale","offset" } },
{ "final_state_huber_loss", { "input","label","delta" } },
{ "final_state_imag", { "x" } },
{ "final_state_index_sample", { "x","index" } },
{ "final_state_index_select", { "x","index","dim" } },
{ "final_state_instance_norm", { "x","scale","bias","epsilon" } },
{ "final_state_kldiv_loss", { "x","label","reduction" } },
{ "final_state_kron", { "x","y" } },
{ "final_state_kthvalue", { "x","k","axis","keepdim" } },
{ "final_state_label_smooth", { "label","prior_dist","epsilon" } },
{ "final_state_layer_norm", { "x","scale","bias","epsilon","begin_norm_axis","is_test" } },
{ "final_state_leaky_relu", { "x","alpha" } },
{ "final_state_lerp", { "x","y","weight" } },
{ "final_state_lgamma", { "x" } },
{ "final_state_log", { "x" } },
{ "final_state_log10", { "x" } },
{ "final_state_log1p", { "x" } },
{ "final_state_log2", { "x" } },
{ "final_state_log_loss", { "input","label","epsilon" } },
{ "final_state_log_softmax", { "x","axis" } },
{ "final_state_logcumsumexp", { "x","axis","flatten","exclusive","reverse" } },
{ "final_state_logit", { "x","eps" } },
{ "final_state_logsigmoid", { "x" } },
{ "final_state_logsumexp", { "x","axis","keepdim","reduce_all" } },
{ "final_state_masked_select", { "x","mask" } },
{ "final_state_matmul", { "x","y" } },
{ "final_state_matrix_power", { "x","n" } },
{ "final_state_max", { "x","dims","keep_dim" } },
{ "final_state_max_pool2d_with_index", { "x","kernel_size","strides","paddings","global_pooling","adaptive" } },
{ "final_state_max_pool3d_with_index", { "x","kernel_size","strides","paddings","global_pooling","adaptive" } },
{ "final_state_maximum", { "x","y" } },
{ "final_state_maxout", { "x","groups","axis" } },
{ "final_state_mean", { "x","dims","keep_dim" } },
{ "final_state_mean_all", { "x" } },
{ "final_state_meshgrid", { "inputs" } },
{ "final_state_min", { "x","dims","keep_dim" } },
{ "final_state_minimum", { "x","y" } },
{ "final_state_mish", { "x","threshold" } },
{ "final_state_mode", { "x","axis","keepdim" } },
{ "final_state_modulo", { "x","y" } },
{ "final_state_multi_dot", { "x" } },
{ "final_state_multiplex", { "ins","ids" } },
{ "final_state_multiply", { "x","y" } },
{ "final_state_nll_loss", { "input","label","weight","ignore_index","reduction" } },
{ "final_state_norm", { "x","axis","epsilon","is_test" } },
{ "final_state_p_norm", { "x","porder","axis","epsilon","keepdim","asvector" } },
{ "final_state_pad", { "x","paddings","pad_value" } },
{ "final_state_pad3d", { "x","paddings","mode","pad_value","data_format" } },
{ "final_state_pixel_shuffle", { "x","upscale_factor","data_format" } },
{ "final_state_pool2d", { "x","kernel_size","strides","paddings","ceil_mode","exclusive","data_format","pooling_type","global_pooling","adaptive","padding_algorithm" } },
{ "final_state_pool2d_gpudnn_unused", { "x","kernel_size","strides","paddings","ceil_mode","exclusive","data_format","pooling_type","global_pooling","adaptive","padding_algorithm" } },
{ "final_state_pool3d", { "x","kernel_size","strides","paddings","ceil_mode","exclusive","data_format","pooling_type","global_pooling","adaptive","padding_algorithm" } },
{ "final_state_pow", { "x","factor" } },
{ "final_state_prelu", { "x","alpha","data_format","mode" } },
{ "final_state_psroi_pool", { "x","boxes","boxes_num","pooled_height","pooled_width","output_channels","spatial_scale" } },
{ "final_state_put_along_axis", { "x","index","value","axis","reduce" } },
{ "final_state_real", { "x" } },
{ "final_state_reciprocal", { "x" } },
{ "final_state_reduce_prod", { "x","dims","keep_dim","reduce_all" } },
{ "final_state_relu", { "x" } },
{ "final_state_relu_", { "x" } },
{ "final_state_relu6", { "x","threshold" } },
{ "final_state_reshape", { "x","shape" } },
{ "final_state_reshape_", { "x","shape" } },
{ "final_state_roi_align", { "x","boxes","boxes_num","pooled_height","pooled_width","spatial_scale","sampling_ratio","aligned" } },
{ "final_state_roi_pool", { "x","boxes","boxes_num","pooled_height","pooled_width","spatial_scale" } },
{ "final_state_roll", { "x","shifts","axis" } },
{ "final_state_round", { "x" } },
{ "final_state_rsqrt", { "x" } },
{ "final_state_rsqrt_", { "x" } },
{ "final_state_scale", { "x","scale","bias","bias_after_scale" } },
{ "final_state_scale_", { "x","scale","bias","bias_after_scale" } },
{ "final_state_scatter", { "x","index","updates","overwrite" } },
{ "final_state_scatter_nd_add", { "x","index","updates" } },
{ "final_state_segment_pool", { "x","segment_ids","pooltype" } },
{ "final_state_selu", { "x","scale","alpha" } },
{ "final_state_sigmoid", { "x" } },
{ "final_state_sigmoid_cross_entropy_with_logits", { "x","label","normalize","ignore_index" } },
{ "final_state_silu", { "x" } },
{ "final_state_sin", { "x" } },
{ "final_state_sinh", { "x" } },
{ "final_state_slice", { "input","axes","starts","ends","infer_flags","decrease_axis" } },
{ "final_state_soft_shrink", { "x","lambda" } },
{ "final_state_softmax", { "x","axis" } },
{ "final_state_split", { "x","num_or_sections","axis" } },
{ "final_state_sqrt", { "x" } },
{ "final_state_square", { "x" } },
{ "final_state_squeeze", { "x","axes" } },
{ "final_state_stack", { "x","axis" } },
{ "final_state_strided_slice", { "x","axes","starts","ends","strides" } },
{ "final_state_subtract", { "x","y" } },
{ "final_state_sum", { "x","dims","out_dtype","keep_dim" } },
{ "final_state_swish", { "x","beta" } },
{ "final_state_take_along_axis", { "x","index","axis" } },
{ "final_state_tan", { "x" } },
{ "final_state_tanh", { "x" } },
{ "final_state_tanh_shrink", { "x" } },
{ "final_state_thresholded_relu", { "x","threshold" } },
{ "final_state_tile", { "x","repeat_times" } },
{ "final_state_top_k", { "x","k","axis","largest","sorted" } },
{ "final_state_transpose", { "x","axis" } },
{ "final_state_triangular_solve", { "x","y","upper","tranpose","unitriangular" } },
{ "final_state_tril_triu", { "x","diagonal","lower" } },
{ "final_state_unbind", { "input","axis" } },
{ "final_state_unfold", { "x","kernel_sizes","strides","paddings","dilations" } },
{ "final_state_unsqueeze", { "x","axes" } },
{ "final_state_where", { "condition","x","y" } },
{ "final_state_coo_to_dense", { "x" } },
{ "final_state_create_sparse_coo_tensor", { "values","indices","dense_shape" } },
{ "final_state_dense_to_coo", { "x","sparse_dim" } },
{ "final_state_divide_scalar", { "x","scalar" } },
{ "final_state_values", { "x" } },
{ "final_state_fused_attention", { "query","key","value","sparse_mask","key_padding_mask","attn_mask" } },
{ "final_state_masked_matmul", { "x","y","mask" } },
{ "final_state_maxpool", { "x","kernel_sizes","paddings","dilations","strides" } },
};
std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_args_type_info = {
    { "final_state_atan2", { "tensor","tensor" } },
{ "final_state_cholesky", { "tensor","" } },
{ "final_state_cholesky_solve", { "tensor","tensor","" } },
{ "final_state_cross", { "tensor","tensor","" } },
{ "final_state_diag", { "tensor","","" } },
{ "final_state_diagonal", { "tensor","","","" } },
{ "final_state_digamma", { "tensor" } },
{ "final_state_dist", { "tensor","tensor","" } },
{ "final_state_dot", { "tensor","tensor" } },
{ "final_state_erf", { "tensor" } },
{ "final_state_mv", { "tensor","tensor" } },
{ "final_state_poisson", { "tensor" } },
{ "final_state_trace", { "tensor","","","" } },
{ "final_state_trunc", { "tensor" } },
{ "final_state_abs", { "tensor" } },
{ "final_state_acos", { "tensor" } },
{ "final_state_acosh", { "tensor" } },
{ "final_state_add", { "tensor","tensor" } },
{ "final_state_addmm", { "tensor","tensor","tensor","","" } },
{ "final_state_argsort", { "tensor","","" } },
{ "final_state_asin", { "tensor" } },
{ "final_state_asinh", { "tensor" } },
{ "final_state_assign", { "tensor" } },
{ "final_state_assign_out_", { "tensor","tensor" } },
{ "final_state_atan", { "tensor" } },
{ "final_state_atanh", { "tensor" } },
{ "final_state_batch_norm", { "tensor","tensor","tensor","tensor","tensor","","","","","","","" } },
{ "final_state_bce_loss", { "tensor","tensor" } },
{ "final_state_brelu", { "tensor","","" } },
{ "final_state_cast", { "tensor","","" } },
{ "final_state_ceil", { "tensor" } },
{ "final_state_celu", { "tensor","" } },
{ "final_state_clip", { "tensor","","" } },
{ "final_state_clip_", { "tensor","","" } },
{ "final_state_complex", { "tensor","tensor" } },
{ "final_state_concat", { "list","" } },
{ "final_state_conj", { "tensor" } },
{ "final_state_conv2d_transpose", { "tensor","tensor","","","","","","","","" } },
{ "final_state_conv3d", { "tensor","tensor","","","","","" } },
{ "final_state_conv3d_transpose", { "tensor","tensor","","","","","","","","" } },
{ "final_state_cos", { "tensor" } },
{ "final_state_cosh", { "tensor" } },
{ "final_state_cross_entropy_with_softmax", { "tensor","tensor","","","","","" } },
{ "final_state_cumprod", { "tensor","" } },
{ "final_state_cumsum", { "tensor","","","","" } },
{ "final_state_deformable_conv", { "tensor","tensor","tensor","tensor","","","","","","" } },
{ "final_state_depthwise_conv2d", { "tensor","tensor","","","","","","","","","","","" } },
{ "final_state_depthwise_conv2d_transpose", { "tensor","tensor","","","","","","","","" } },
{ "final_state_det", { "tensor" } },
{ "final_state_divide", { "tensor","tensor" } },
{ "final_state_dropout", { "tensor","tensor","","","","","" } },
{ "final_state_eigh", { "tensor","" } },
{ "final_state_einsum", { "list","" } },
{ "final_state_elementwise_pow", { "tensor","tensor" } },
{ "final_state_elu", { "tensor","" } },
{ "final_state_embedding", { "tensor","tensor","","" } },
{ "final_state_erfinv", { "tensor" } },
{ "final_state_erfinv_", { "tensor" } },
{ "final_state_exp", { "tensor" } },
{ "final_state_expand", { "tensor","" } },
{ "final_state_expand_as", { "tensor","tensor","" } },
{ "final_state_expm1", { "tensor" } },
{ "final_state_flatten", { "tensor","","" } },
{ "final_state_flatten_", { "tensor","","" } },
{ "final_state_flip", { "tensor","" } },
{ "final_state_floor", { "tensor" } },
{ "final_state_fmax", { "tensor","tensor","" } },
{ "final_state_fmin", { "tensor","tensor","" } },
{ "final_state_frobenius_norm", { "tensor","","","" } },
{ "final_state_gather", { "tensor","tensor","" } },
{ "final_state_gather_nd", { "tensor","tensor" } },
{ "final_state_gelu", { "tensor","" } },
{ "final_state_graph_send_recv", { "tensor","tensor","tensor","","" } },
{ "final_state_group_norm", { "tensor","tensor","tensor","","","" } },
{ "final_state_gumbel_softmax", { "tensor","","","" } },
{ "final_state_hard_shrink", { "tensor","" } },
{ "final_state_hard_sigmoid", { "tensor","","" } },
{ "final_state_hard_swish", { "tensor","","","" } },
{ "final_state_huber_loss", { "tensor","tensor","" } },
{ "final_state_imag", { "tensor" } },
{ "final_state_index_sample", { "tensor","tensor" } },
{ "final_state_index_select", { "tensor","tensor","" } },
{ "final_state_instance_norm", { "tensor","tensor","tensor","" } },
{ "final_state_kldiv_loss", { "tensor","tensor","" } },
{ "final_state_kron", { "tensor","tensor" } },
{ "final_state_kthvalue", { "tensor","","","" } },
{ "final_state_label_smooth", { "tensor","tensor","" } },
{ "final_state_layer_norm", { "tensor","tensor","tensor","","","" } },
{ "final_state_leaky_relu", { "tensor","" } },
{ "final_state_lerp", { "tensor","tensor","tensor" } },
{ "final_state_lgamma", { "tensor" } },
{ "final_state_log", { "tensor" } },
{ "final_state_log10", { "tensor" } },
{ "final_state_log1p", { "tensor" } },
{ "final_state_log2", { "tensor" } },
{ "final_state_log_loss", { "tensor","tensor","" } },
{ "final_state_log_softmax", { "tensor","" } },
{ "final_state_logcumsumexp", { "tensor","","","","" } },
{ "final_state_logit", { "tensor","" } },
{ "final_state_logsigmoid", { "tensor" } },
{ "final_state_logsumexp", { "tensor","","","" } },
{ "final_state_masked_select", { "tensor","tensor" } },
{ "final_state_matmul", { "tensor","tensor" } },
{ "final_state_matrix_power", { "tensor","" } },
{ "final_state_max", { "tensor","","" } },
{ "final_state_max_pool2d_with_index", { "tensor","","","","","" } },
{ "final_state_max_pool3d_with_index", { "tensor","","","","","" } },
{ "final_state_maximum", { "tensor","tensor" } },
{ "final_state_maxout", { "tensor","","" } },
{ "final_state_mean", { "tensor","","" } },
{ "final_state_mean_all", { "tensor" } },
{ "final_state_meshgrid", { "list" } },
{ "final_state_min", { "tensor","","" } },
{ "final_state_minimum", { "tensor","tensor" } },
{ "final_state_mish", { "tensor","" } },
{ "final_state_mode", { "tensor","","" } },
{ "final_state_modulo", { "tensor","tensor" } },
{ "final_state_multi_dot", { "list" } },
{ "final_state_multiplex", { "list","tensor" } },
{ "final_state_multiply", { "tensor","tensor" } },
{ "final_state_nll_loss", { "tensor","tensor","tensor","","" } },
{ "final_state_norm", { "tensor","","","" } },
{ "final_state_p_norm", { "tensor","","","","","" } },
{ "final_state_pad", { "tensor","","" } },
{ "final_state_pad3d", { "tensor","","","","" } },
{ "final_state_pixel_shuffle", { "tensor","","" } },
{ "final_state_pool2d", { "tensor","","","","","","","","","","" } },
{ "final_state_pool2d_gpudnn_unused", { "tensor","","","","","","","","","","" } },
{ "final_state_pool3d", { "tensor","","","","","","","","","","" } },
{ "final_state_pow", { "tensor","" } },
{ "final_state_prelu", { "tensor","tensor","","" } },
{ "final_state_psroi_pool", { "tensor","tensor","tensor","","","","" } },
{ "final_state_put_along_axis", { "tensor","tensor","tensor","","" } },
{ "final_state_real", { "tensor" } },
{ "final_state_reciprocal", { "tensor" } },
{ "final_state_reduce_prod", { "tensor","","","" } },
{ "final_state_relu", { "tensor" } },
{ "final_state_relu_", { "tensor" } },
{ "final_state_relu6", { "tensor","" } },
{ "final_state_reshape", { "tensor","" } },
{ "final_state_reshape_", { "tensor","" } },
{ "final_state_roi_align", { "tensor","tensor","tensor","","","","","" } },
{ "final_state_roi_pool", { "tensor","tensor","tensor","","","" } },
{ "final_state_roll", { "tensor","","" } },
{ "final_state_round", { "tensor" } },
{ "final_state_rsqrt", { "tensor" } },
{ "final_state_rsqrt_", { "tensor" } },
{ "final_state_scale", { "tensor","","","" } },
{ "final_state_scale_", { "tensor","","","" } },
{ "final_state_scatter", { "tensor","tensor","tensor","" } },
{ "final_state_scatter_nd_add", { "tensor","tensor","tensor" } },
{ "final_state_segment_pool", { "tensor","tensor","" } },
{ "final_state_selu", { "tensor","","" } },
{ "final_state_sigmoid", { "tensor" } },
{ "final_state_sigmoid_cross_entropy_with_logits", { "tensor","tensor","","" } },
{ "final_state_silu", { "tensor" } },
{ "final_state_sin", { "tensor" } },
{ "final_state_sinh", { "tensor" } },
{ "final_state_slice", { "tensor","","","","","" } },
{ "final_state_soft_shrink", { "tensor","" } },
{ "final_state_softmax", { "tensor","" } },
{ "final_state_split", { "tensor","","" } },
{ "final_state_sqrt", { "tensor" } },
{ "final_state_square", { "tensor" } },
{ "final_state_squeeze", { "tensor","" } },
{ "final_state_stack", { "list","" } },
{ "final_state_strided_slice", { "tensor","","","","" } },
{ "final_state_subtract", { "tensor","tensor" } },
{ "final_state_sum", { "tensor","","","" } },
{ "final_state_swish", { "tensor","" } },
{ "final_state_take_along_axis", { "tensor","tensor","" } },
{ "final_state_tan", { "tensor" } },
{ "final_state_tanh", { "tensor" } },
{ "final_state_tanh_shrink", { "tensor" } },
{ "final_state_thresholded_relu", { "tensor","" } },
{ "final_state_tile", { "tensor","" } },
{ "final_state_top_k", { "tensor","","","","" } },
{ "final_state_transpose", { "tensor","" } },
{ "final_state_triangular_solve", { "tensor","tensor","","","" } },
{ "final_state_tril_triu", { "tensor","","" } },
{ "final_state_unbind", { "tensor","" } },
{ "final_state_unfold", { "tensor","","","","" } },
{ "final_state_unsqueeze", { "tensor","" } },
{ "final_state_where", { "tensor","tensor","tensor" } },
{ "final_state_coo_to_dense", { "tensor" } },
{ "final_state_create_sparse_coo_tensor", { "tensor","tensor","" } },
{ "final_state_dense_to_coo", { "tensor","" } },
{ "final_state_divide_scalar", { "tensor","" } },
{ "final_state_values", { "tensor" } },
{ "final_state_fused_attention", { "tensor","tensor","tensor","tensor","tensor","tensor" } },
{ "final_state_masked_matmul", { "tensor","tensor","tensor" } },
{ "final_state_maxpool", { "tensor","","","","" } },
};
std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_returns_info = {
    { "final_state_atan2", { "out" } },
{ "final_state_cholesky", { "out" } },
{ "final_state_cholesky_solve", { "out" } },
{ "final_state_cross", { "out" } },
{ "final_state_diag", { "out" } },
{ "final_state_diagonal", { "out" } },
{ "final_state_digamma", { "out" } },
{ "final_state_dist", { "out" } },
{ "final_state_dot", { "out" } },
{ "final_state_erf", { "out" } },
{ "final_state_mv", { "out" } },
{ "final_state_poisson", { "out" } },
{ "final_state_trace", { "out" } },
{ "final_state_trunc", { "out" } },
{ "final_state_abs", { "out" } },
{ "final_state_acos", { "out" } },
{ "final_state_acosh", { "out" } },
{ "final_state_add", { "out" } },
{ "final_state_addmm", { "out" } },
{ "final_state_argsort", { "out","indices" } },
{ "final_state_asin", { "out" } },
{ "final_state_asinh", { "out" } },
{ "final_state_assign", { "out" } },
{ "final_state_assign_out_", { "out" } },
{ "final_state_atan", { "out" } },
{ "final_state_atanh", { "out" } },
{ "final_state_batch_norm", { "out","mean_out","variance_out","saved_mean","saved_variance","reserve_space" } },
{ "final_state_bce_loss", { "out" } },
{ "final_state_brelu", { "out" } },
{ "final_state_cast", { "out" } },
{ "final_state_ceil", { "out" } },
{ "final_state_celu", { "out" } },
{ "final_state_clip", { "out" } },
{ "final_state_clip_", { "out" } },
{ "final_state_complex", { "out" } },
{ "final_state_concat", { "out" } },
{ "final_state_conj", { "out" } },
{ "final_state_conv2d_transpose", { "out" } },
{ "final_state_conv3d", { "out","rulebook" } },
{ "final_state_conv3d_transpose", { "out" } },
{ "final_state_cos", { "out" } },
{ "final_state_cosh", { "out" } },
{ "final_state_cross_entropy_with_softmax", { "softmax","loss" } },
{ "final_state_cumprod", { "out" } },
{ "final_state_cumsum", { "out" } },
{ "final_state_deformable_conv", { "out" } },
{ "final_state_depthwise_conv2d", { "out" } },
{ "final_state_depthwise_conv2d_transpose", { "out" } },
{ "final_state_det", { "out" } },
{ "final_state_divide", { "out" } },
{ "final_state_dropout", { "out","mask" } },
{ "final_state_eigh", { "out_w","out_v" } },
{ "final_state_einsum", { "out","inner_cache","x_shape" } },
{ "final_state_elementwise_pow", { "out" } },
{ "final_state_elu", { "out" } },
{ "final_state_embedding", { "out" } },
{ "final_state_erfinv", { "out" } },
{ "final_state_erfinv_", { "out" } },
{ "final_state_exp", { "out" } },
{ "final_state_expand", { "out" } },
{ "final_state_expand_as", { "out" } },
{ "final_state_expm1", { "out" } },
{ "final_state_flatten", { "out","xshape" } },
{ "final_state_flatten_", { "out","xshape" } },
{ "final_state_flip", { "out" } },
{ "final_state_floor", { "out" } },
{ "final_state_fmax", { "out" } },
{ "final_state_fmin", { "out" } },
{ "final_state_frobenius_norm", { "out" } },
{ "final_state_gather", { "out" } },
{ "final_state_gather_nd", { "out" } },
{ "final_state_gelu", { "out" } },
{ "final_state_graph_send_recv", { "out","dst_count" } },
{ "final_state_group_norm", { "y","mean","variance" } },
{ "final_state_gumbel_softmax", { "out" } },
{ "final_state_hard_shrink", { "out" } },
{ "final_state_hard_sigmoid", { "out" } },
{ "final_state_hard_swish", { "out" } },
{ "final_state_huber_loss", { "out","residual" } },
{ "final_state_imag", { "out" } },
{ "final_state_index_sample", { "out" } },
{ "final_state_index_select", { "out" } },
{ "final_state_instance_norm", { "y","saved_mean","saved_variance" } },
{ "final_state_kldiv_loss", { "out" } },
{ "final_state_kron", { "out" } },
{ "final_state_kthvalue", { "out","indices" } },
{ "final_state_label_smooth", { "out" } },
{ "final_state_layer_norm", { "out","mean","variance" } },
{ "final_state_leaky_relu", { "out" } },
{ "final_state_lerp", { "out" } },
{ "final_state_lgamma", { "out" } },
{ "final_state_log", { "out" } },
{ "final_state_log10", { "out" } },
{ "final_state_log1p", { "out" } },
{ "final_state_log2", { "out" } },
{ "final_state_log_loss", { "out" } },
{ "final_state_log_softmax", { "out" } },
{ "final_state_logcumsumexp", { "out" } },
{ "final_state_logit", { "out" } },
{ "final_state_logsigmoid", { "out" } },
{ "final_state_logsumexp", { "out" } },
{ "final_state_masked_select", { "out" } },
{ "final_state_matmul", { "out" } },
{ "final_state_matrix_power", { "out" } },
{ "final_state_max", { "out" } },
{ "final_state_max_pool2d_with_index", { "out","mask" } },
{ "final_state_max_pool3d_with_index", { "out","mask" } },
{ "final_state_maximum", { "out" } },
{ "final_state_maxout", { "out" } },
{ "final_state_mean", { "out" } },
{ "final_state_mean_all", { "out" } },
{ "final_state_meshgrid", { "outputs" } },
{ "final_state_min", { "out" } },
{ "final_state_minimum", { "out" } },
{ "final_state_mish", { "out" } },
{ "final_state_mode", { "out","indices" } },
{ "final_state_modulo", { "out" } },
{ "final_state_multi_dot", { "out" } },
{ "final_state_multiplex", { "out" } },
{ "final_state_multiply", { "out" } },
{ "final_state_nll_loss", { "out","total_weight" } },
{ "final_state_norm", { "out","norm" } },
{ "final_state_p_norm", { "out" } },
{ "final_state_pad", { "out" } },
{ "final_state_pad3d", { "out" } },
{ "final_state_pixel_shuffle", { "out" } },
{ "final_state_pool2d", { "out" } },
{ "final_state_pool2d_gpudnn_unused", { "out" } },
{ "final_state_pool3d", { "out" } },
{ "final_state_pow", { "out" } },
{ "final_state_prelu", { "out" } },
{ "final_state_psroi_pool", { "out" } },
{ "final_state_put_along_axis", { "out" } },
{ "final_state_real", { "out" } },
{ "final_state_reciprocal", { "out" } },
{ "final_state_reduce_prod", { "out" } },
{ "final_state_relu", { "out" } },
{ "final_state_relu_", { "out" } },
{ "final_state_relu6", { "out" } },
{ "final_state_reshape", { "out","xshape" } },
{ "final_state_reshape_", { "out","xshape" } },
{ "final_state_roi_align", { "out" } },
{ "final_state_roi_pool", { "out","arg_max" } },
{ "final_state_roll", { "out" } },
{ "final_state_round", { "out" } },
{ "final_state_rsqrt", { "out" } },
{ "final_state_rsqrt_", { "out" } },
{ "final_state_scale", { "out" } },
{ "final_state_scale_", { "out" } },
{ "final_state_scatter", { "out" } },
{ "final_state_scatter_nd_add", { "out" } },
{ "final_state_segment_pool", { "out","summed_ids" } },
{ "final_state_selu", { "out" } },
{ "final_state_sigmoid", { "out" } },
{ "final_state_sigmoid_cross_entropy_with_logits", { "out" } },
{ "final_state_silu", { "out" } },
{ "final_state_sin", { "out" } },
{ "final_state_sinh", { "out" } },
{ "final_state_slice", { "out" } },
{ "final_state_soft_shrink", { "out" } },
{ "final_state_softmax", { "out" } },
{ "final_state_split", { "out" } },
{ "final_state_sqrt", { "out" } },
{ "final_state_square", { "out" } },
{ "final_state_squeeze", { "out","xshape" } },
{ "final_state_stack", { "out" } },
{ "final_state_strided_slice", { "out" } },
{ "final_state_subtract", { "out" } },
{ "final_state_sum", { "out" } },
{ "final_state_swish", { "out" } },
{ "final_state_take_along_axis", { "out" } },
{ "final_state_tan", { "out" } },
{ "final_state_tanh", { "out" } },
{ "final_state_tanh_shrink", { "out" } },
{ "final_state_thresholded_relu", { "out" } },
{ "final_state_tile", { "out" } },
{ "final_state_top_k", { "out","indices" } },
{ "final_state_transpose", { "out" } },
{ "final_state_triangular_solve", { "out" } },
{ "final_state_tril_triu", { "out" } },
{ "final_state_unbind", { "out" } },
{ "final_state_unfold", { "out" } },
{ "final_state_unsqueeze", { "out","xshape" } },
{ "final_state_where", { "out" } },
{ "final_state_coo_to_dense", { "out" } },
{ "final_state_create_sparse_coo_tensor", { "out" } },
{ "final_state_dense_to_coo", { "out" } },
{ "final_state_divide_scalar", { "out" } },
{ "final_state_values", { "out" } },
{ "final_state_fused_attention", { "out","softmax" } },
{ "final_state_masked_matmul", { "out" } },
{ "final_state_maxpool", { "out","rulebook" } },
};



paddle::experimental::Tensor atan2_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("atan2 dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("atan2");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atan2_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "atan2_final_state_dygraph_function";
  auto api_result = paddle::experimental::atan2(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan2", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("atan2 node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Atan2GradNodeFinal>(new Atan2GradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor cholesky_final_state_dygraph_function(const paddle::experimental::Tensor& x, bool upper) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cholesky dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cholesky");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cholesky_final_state_dygraph_function(NEW_x, upper);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cholesky_final_state_dygraph_function";
  auto api_result = paddle::experimental::cholesky(x, upper);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cholesky", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cholesky node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CholeskyGradNodeFinal>(new CholeskyGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeupper(upper);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor cholesky_solve_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool upper) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cholesky_solve dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cholesky_solve");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cholesky_solve_final_state_dygraph_function(NEW_x, NEW_y, upper);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cholesky_solve_final_state_dygraph_function";
  auto api_result = paddle::experimental::cholesky_solve(x, y, upper);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cholesky_solve", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cholesky_solve node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CholeskySolveGradNodeFinal>(new CholeskySolveGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeupper(upper);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor cross_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cross dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cross");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cross_final_state_dygraph_function(NEW_x, NEW_y, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cross_final_state_dygraph_function";
  auto api_result = paddle::experimental::cross(x, y, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cross", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cross node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CrossGradNodeFinal>(new CrossGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor diag_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, float padding_value) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("diag dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("diag");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return diag_final_state_dygraph_function(NEW_x, offset, padding_value);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "diag_final_state_dygraph_function";
  auto api_result = paddle::experimental::diag(x, offset, padding_value);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("diag", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("diag node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DiagGradNodeFinal>(new DiagGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeoffset(offset);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor diagonal_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, int axis1, int axis2) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("diagonal dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("diagonal");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return diagonal_final_state_dygraph_function(NEW_x, offset, axis1, axis2);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "diagonal_final_state_dygraph_function";
  auto api_result = paddle::experimental::diagonal(x, offset, axis1, axis2);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("diagonal", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("diagonal node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DiagonalGradNodeFinal>(new DiagonalGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeoffset(offset);
    grad_node->SetAttributeaxis1(axis1);
    grad_node->SetAttributeaxis2(axis2);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor digamma_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("digamma dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("digamma");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return digamma_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "digamma_final_state_dygraph_function";
  auto api_result = paddle::experimental::digamma(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("digamma", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("digamma node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DigammaGradNodeFinal>(new DigammaGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor dist_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, float p) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("dist dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("dist");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dist_final_state_dygraph_function(NEW_x, NEW_y, p);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "dist_final_state_dygraph_function";
  auto api_result = paddle::experimental::dist(x, y, p);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dist", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("dist node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DistGradNodeFinal>(new DistGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributep(p);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor dot_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("dot dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("dot");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dot_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "dot_final_state_dygraph_function";
  auto api_result = paddle::experimental::dot(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dot", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("dot node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DotGradNodeFinal>(new DotGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor erf_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("erf dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("erf");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return erf_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "erf_final_state_dygraph_function";
  auto api_result = paddle::experimental::erf(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("erf", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("erf node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ErfGradNodeFinal>(new ErfGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor mv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& vec) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mv dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mv");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{vec} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_vec = egr::EagerAmpAutoCast("vec", vec, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mv_final_state_dygraph_function(NEW_x, NEW_vec);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* vec_autograd_meta = egr::EagerUtils::nullable_autograd_meta(vec);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mv_final_state_dygraph_function";
  auto api_result = paddle::experimental::mv(x, vec);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mv", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,vec_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MvGradNodeFinal>(new MvGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappervec(vec);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(vec, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor poisson_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("poisson dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("poisson");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return poisson_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "poisson_final_state_dygraph_function";
  auto api_result = paddle::experimental::poisson(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("poisson", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("poisson node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PoissonGradNodeFinal>(new PoissonGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor trace_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, int axis1, int axis2) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("trace dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("trace");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return trace_final_state_dygraph_function(NEW_x, offset, axis1, axis2);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "trace_final_state_dygraph_function";
  auto api_result = paddle::experimental::trace(x, offset, axis1, axis2);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("trace", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("trace node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TraceGradNodeFinal>(new TraceGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeoffset(offset);
    grad_node->SetAttributeaxis1(axis1);
    grad_node->SetAttributeaxis2(axis2);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor trunc_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("trunc dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("trunc");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return trunc_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "trunc_final_state_dygraph_function";
  auto api_result = paddle::experimental::trunc(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("trunc", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("trunc node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TruncGradNodeFinal>(new TruncGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}



paddle::experimental::Tensor abs_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("abs dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("abs");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return abs_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "abs_final_state_dygraph_function";
  auto api_result = paddle::experimental::abs(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("abs", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("abs node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AbsGradNodeFinal>(new AbsGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor acos_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("acos dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("acos");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return acos_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "acos_final_state_dygraph_function";
  auto api_result = paddle::experimental::acos(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acos", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("acos node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AcosGradNodeFinal>(new AcosGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor acosh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("acosh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("acosh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return acosh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "acosh_final_state_dygraph_function";
  auto api_result = paddle::experimental::acosh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acosh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("acosh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AcoshGradNodeFinal>(new AcoshGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("add dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("add");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return add_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "add_final_state_dygraph_function";
  auto api_result = paddle::experimental::add(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("add node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AddGradNodeFinal>(new AddGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor addmm_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, float alpha, float beta) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("addmm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("addmm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return addmm_final_state_dygraph_function(NEW_input, NEW_x, NEW_y, alpha, beta);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "addmm_final_state_dygraph_function";
  auto api_result = paddle::experimental::addmm(input, x, y, alpha, beta);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("addmm", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("addmm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AddmmGradNodeFinal>(new AddmmGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    grad_node->SetAttributebeta(beta);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(x, 1);
    grad_node->SetGradOutMeta(y, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> argsort_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool descending) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("argsort dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("argsort");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return argsort_final_state_dygraph_function(NEW_x, axis, descending);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "argsort_final_state_dygraph_function";
  auto api_result = paddle::experimental::argsort(x, axis, descending);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("argsort", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& indices = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* indices_autograd_meta = egr::EagerUtils::autograd_meta(&indices);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("argsort node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,indices_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ArgsortGradNodeFinal>(new ArgsortGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributedescending(descending);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(indices_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetHistory(indices_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(indices, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(indices);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperindices(indices);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, indices};
}


paddle::experimental::Tensor asin_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("asin dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("asin");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return asin_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "asin_final_state_dygraph_function";
  auto api_result = paddle::experimental::asin(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asin", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("asin node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AsinGradNodeFinal>(new AsinGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor asinh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("asinh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("asinh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return asinh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "asinh_final_state_dygraph_function";
  auto api_result = paddle::experimental::asinh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asinh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("asinh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AsinhGradNodeFinal>(new AsinhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor assign_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("assign dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("assign");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return assign_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "assign_final_state_dygraph_function";
  auto api_result = paddle::experimental::assign(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("assign node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AssignGradNodeFinal>(new AssignGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor& assign_out__final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Tensor& output) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("assign_out_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "assign_out__final_state_dygraph_function";
  auto& api_result = paddle::experimental::assign_out_(x, output);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign_out_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Bump Inplace Version
  output.bump_inplace_version();
  VLOG(3) << "Tensor(" << output.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("assign_out_ node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AssignOutGradNodeFinal>(new AssignOutGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor atan_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("atan dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("atan");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atan_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "atan_final_state_dygraph_function";
  auto api_result = paddle::experimental::atan(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("atan node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AtanGradNodeFinal>(new AtanGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor atanh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("atanh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("atanh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atanh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "atanh_final_state_dygraph_function";
  auto api_result = paddle::experimental::atanh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atanh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("atanh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AtanhGradNodeFinal>(new AtanhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor> batch_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& scale, const paddle::experimental::Tensor& bias, const paddle::experimental::Tensor& mean, const paddle::experimental::Tensor& variance, float momentum, float epsilon, std::string data_layout, bool is_test, bool use_global_stats, bool trainable_statistics, bool fuse_with_relu) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("batch_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("batch_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{scale},{bias},{mean},{variance} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_scale = egr::EagerAmpAutoCast("scale", scale, amp_dst_dtype, op_name);
    auto NEW_bias = egr::EagerAmpAutoCast("bias", bias, amp_dst_dtype, op_name);
    auto NEW_mean = egr::EagerAmpAutoCast("mean", mean, amp_dst_dtype, op_name);
    auto NEW_variance = egr::EagerAmpAutoCast("variance", variance, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return batch_norm_final_state_dygraph_function(NEW_x, NEW_scale, NEW_bias, NEW_mean, NEW_variance, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* scale_autograd_meta = egr::EagerUtils::nullable_autograd_meta(scale);
  egr::AutogradMeta* bias_autograd_meta = egr::EagerUtils::nullable_autograd_meta(bias);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "batch_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::batch_norm(x, scale, bias, mean, variance, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("batch_norm", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& mean_out = std::get<1>(api_result);
  auto& variance_out = std::get<2>(api_result);
  auto& saved_mean = std::get<3>(api_result);
  auto& saved_variance = std::get<4>(api_result);
  auto& reserve_space = std::get<5>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* mean_out_autograd_meta = egr::EagerUtils::autograd_meta(&mean_out);
  egr::AutogradMeta* variance_out_autograd_meta = egr::EagerUtils::autograd_meta(&variance_out);
  egr::AutogradMeta* saved_mean_autograd_meta = egr::EagerUtils::autograd_meta(&saved_mean);
  egr::AutogradMeta* saved_variance_autograd_meta = egr::EagerUtils::autograd_meta(&saved_variance);
  egr::AutogradMeta* reserve_space_autograd_meta = egr::EagerUtils::autograd_meta(&reserve_space);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,scale_autograd_meta,bias_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("batch_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,mean_out_autograd_meta,variance_out_autograd_meta,saved_mean_autograd_meta,saved_variance_autograd_meta,reserve_space_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<BatchNormGradNodeFinal>(new BatchNormGradNodeFinal(6, 5));
    // SetAttributes if needed
    grad_node->SetAttributemomentum(momentum);
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributedata_layout(data_layout);
    grad_node->SetAttributeis_test(is_test);
    grad_node->SetAttributeuse_global_stats(use_global_stats);
    grad_node->SetAttributetrainable_statistics(trainable_statistics);
    grad_node->SetAttributefuse_with_relu(fuse_with_relu);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperscale(scale);
    grad_node->SetTensorWrapperbias(bias);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(scale, 1);
    grad_node->SetGradOutMeta(bias, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (mean_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mean_out_autograd_meta, 1);
    }
    if (variance_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(variance_out_autograd_meta, 2);
    }
    if (saved_mean_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(saved_mean_autograd_meta, 3);
    }
    if (saved_variance_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(saved_variance_autograd_meta, 4);
    }
    if (reserve_space_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(reserve_space_autograd_meta, 5);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (mean_out_autograd_meta) {
      egr::EagerUtils::SetHistory(mean_out_autograd_meta, grad_node);
    }
    if (variance_out_autograd_meta) {
      egr::EagerUtils::SetHistory(variance_out_autograd_meta, grad_node);
    }
    if (saved_mean_autograd_meta) {
      egr::EagerUtils::SetHistory(saved_mean_autograd_meta, grad_node);
    }
    if (saved_variance_autograd_meta) {
      egr::EagerUtils::SetHistory(saved_variance_autograd_meta, grad_node);
    }
    if (reserve_space_autograd_meta) {
      egr::EagerUtils::SetHistory(reserve_space_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(mean_out, 1);
    grad_node->SetGradInMeta(variance_out, 2);
    grad_node->SetGradInMeta(saved_mean, 3);
    grad_node->SetGradInMeta(saved_variance, 4);
    grad_node->SetGradInMeta(reserve_space, 5);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(mean_out);
    egr::EagerUtils::CheckAndRetainGrad(variance_out);
    egr::EagerUtils::CheckAndRetainGrad(saved_mean);
    egr::EagerUtils::CheckAndRetainGrad(saved_variance);
    egr::EagerUtils::CheckAndRetainGrad(reserve_space);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappermean_out(mean_out);
    grad_node->SetTensorWrappervariance_out(variance_out);
    grad_node->SetTensorWrappersaved_mean(saved_mean);
    grad_node->SetTensorWrappersaved_variance(saved_variance);
    grad_node->SetTensorWrapperreserve_space(reserve_space);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor>{out, mean_out, variance_out, saved_mean, saved_variance, reserve_space};
}


paddle::experimental::Tensor bce_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("bce_loss dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("bce_loss");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return bce_loss_final_state_dygraph_function(NEW_input, NEW_label);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "bce_loss_final_state_dygraph_function";
  auto api_result = paddle::experimental::bce_loss(input, label);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("bce_loss", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("bce_loss node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<BceLossGradNodeFinal>(new BceLossGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperlabel(label);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor brelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float t_min, float t_max) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("brelu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("brelu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return brelu_final_state_dygraph_function(NEW_x, t_min, t_max);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "brelu_final_state_dygraph_function";
  auto api_result = paddle::experimental::brelu(x, t_min, t_max);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("brelu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("brelu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<BreluGradNodeFinal>(new BreluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributet_min(t_min);
    grad_node->SetAttributet_max(t_max);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor cast_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::DataType out_dtype) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cast dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cast_final_state_dygraph_function";
  auto api_result = paddle::experimental::cast(x, out_dtype);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cast", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cast node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CastGradNodeFinal>(new CastGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor ceil_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("ceil dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("ceil");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return ceil_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "ceil_final_state_dygraph_function";
  auto api_result = paddle::experimental::ceil(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("ceil", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("ceil node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CeilGradNodeFinal>(new CeilGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor celu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("celu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("celu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return celu_final_state_dygraph_function(NEW_x, alpha);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "celu_final_state_dygraph_function";
  auto api_result = paddle::experimental::celu(x, alpha);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("celu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("celu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CeluGradNodeFinal>(new CeluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor clip_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar min, paddle::experimental::Scalar max) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("clip dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("clip");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return clip_final_state_dygraph_function(NEW_x, min, max);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "clip_final_state_dygraph_function";
  auto api_result = paddle::experimental::clip(x, min, max);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("clip", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("clip node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ClipGradNodeFinal>(new ClipGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributemin(min);
    grad_node->SetAttributemax(max);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}

paddle::experimental::Tensor& clip__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::Scalar min, paddle::experimental::Scalar max) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("clip_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "clip__final_state_dygraph_function";
  auto& api_result = paddle::experimental::clip_(x, min, max);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("clip_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("clip node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ClipGradNodeFinal>(new ClipGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributemin(min);
    grad_node->SetAttributemax(max);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor complex_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("complex dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("complex");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return complex_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "complex_final_state_dygraph_function";
  auto api_result = paddle::experimental::complex(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("complex", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("complex node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ComplexGradNodeFinal>(new ComplexGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor concat_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, paddle::experimental::Scalar axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("concat dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("concat");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { x };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCasts("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return concat_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> x_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(x);
  std::vector<egr::AutogradMeta*>* x_autograd_meta = &x_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "concat_final_state_dygraph_function";
  auto api_result = paddle::experimental::concat(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("concat", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("concat node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ConcatGradNodeFinal>(new ConcatGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor conj_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("conj dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("conj");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conj_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "conj_final_state_dygraph_function";
  auto api_result = paddle::experimental::conj(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conj", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("conj node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ConjGradNodeFinal>(new ConjGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor conv2d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("conv2d_transpose dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("conv2d_transpose");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{filter} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv2d_transpose_final_state_dygraph_function(NEW_x, NEW_filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "conv2d_transpose_final_state_dygraph_function";
  auto api_result = paddle::experimental::conv2d_transpose(x, filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv2d_transpose", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,filter_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("conv2d_transpose node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv2dTransposeGradNodeFinal>(new Conv2dTransposeGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeoutput_padding(output_padding);
    grad_node->SetAttributeoutput_size(output_size);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperfilter(filter);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(filter, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor conv3d_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::string paddding_algorithm, int groups, std::vector<int> dilations, std::string data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("conv3d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("conv3d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{filter} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv3d_final_state_dygraph_function(NEW_input, NEW_filter, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "conv3d_final_state_dygraph_function";
  auto api_result = paddle::experimental::conv3d(input, filter, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta,filter_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("conv3d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv3dGradNodeFinal>(new Conv3dGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepaddding_algorithm(paddding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributeuse_addto(use_addto);
    grad_node->SetAttributeworkspace_size_MB(workspace_size_MB);
    grad_node->SetAttributeexhaustive_search(exhaustive_search);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperfilter(filter);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(filter, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor conv3d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("conv3d_transpose dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("conv3d_transpose");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{filter} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv3d_transpose_final_state_dygraph_function(NEW_x, NEW_filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "conv3d_transpose_final_state_dygraph_function";
  auto api_result = paddle::experimental::conv3d_transpose(x, filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_transpose", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,filter_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("conv3d_transpose node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv3dTransposeGradNodeFinal>(new Conv3dTransposeGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeoutput_padding(output_padding);
    grad_node->SetAttributeoutput_size(output_size);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperfilter(filter);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(filter, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor cos_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cos dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cos");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cos_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cos_final_state_dygraph_function";
  auto api_result = paddle::experimental::cos(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cos", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cos node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CosGradNodeFinal>(new CosGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor cosh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cosh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cosh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cosh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cosh_final_state_dygraph_function";
  auto api_result = paddle::experimental::cosh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cosh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cosh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CoshGradNodeFinal>(new CoshGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> cross_entropy_with_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, bool soft_label, bool use_softmax, bool numeric_stable_mode, int ignore_index, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cross_entropy_with_softmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cross_entropy_with_softmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cross_entropy_with_softmax_final_state_dygraph_function(NEW_input, NEW_label, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cross_entropy_with_softmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::cross_entropy_with_softmax(input, label, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cross_entropy_with_softmax", api_result); }

  // Get Outputs
  auto& softmax = std::get<0>(api_result);
  auto& loss = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* softmax_autograd_meta = egr::EagerUtils::autograd_meta(&softmax);
  egr::AutogradMeta* loss_autograd_meta = egr::EagerUtils::autograd_meta(&loss);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cross_entropy_with_softmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,softmax_autograd_meta,loss_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CrossEntropyWithSoftmaxGradNodeFinal>(new CrossEntropyWithSoftmaxGradNodeFinal(2, 2));
    // SetAttributes if needed
    grad_node->SetAttributesoft_label(soft_label);
    grad_node->SetAttributeuse_softmax(use_softmax);
    grad_node->SetAttributenumeric_stable_mode(numeric_stable_mode);
    grad_node->SetAttributeignore_index(ignore_index);
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperlabel(label);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (softmax_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(softmax_autograd_meta, 0);
    }
    if (loss_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(loss_autograd_meta, 1);
    }
    if (softmax_autograd_meta) {
      egr::EagerUtils::SetHistory(softmax_autograd_meta, grad_node);
    }
    if (loss_autograd_meta) {
      egr::EagerUtils::SetHistory(loss_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(softmax, 0);
    grad_node->SetGradInMeta(loss, 1);
    egr::EagerUtils::CheckAndRetainGrad(softmax);
    egr::EagerUtils::CheckAndRetainGrad(loss);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappersoftmax(softmax);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{softmax, loss};
}


paddle::experimental::Tensor cumprod_final_state_dygraph_function(const paddle::experimental::Tensor& x, int dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cumprod dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cumprod");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cumprod_final_state_dygraph_function(NEW_x, dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cumprod_final_state_dygraph_function";
  auto api_result = paddle::experimental::cumprod(x, dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cumprod", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cumprod node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CumprodGradNodeFinal>(new CumprodGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedim(dim);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor cumsum_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool flatten, bool exclusive, bool reverse) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cumsum dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("cumsum");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cumsum_final_state_dygraph_function(NEW_x, axis, flatten, exclusive, reverse);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cumsum_final_state_dygraph_function";
  auto api_result = paddle::experimental::cumsum(x, axis, flatten, exclusive, reverse);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cumsum", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cumsum node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CumsumGradNodeFinal>(new CumsumGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributeflatten(flatten);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributereverse(reverse);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor deformable_conv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& offset, const paddle::experimental::Tensor& filter, const paddle::optional<paddle::experimental::Tensor>& mask, std::vector<int> strides, std::vector<int> paddings, std::vector<int> dilations, int deformable_groups, int groups, int im2col_step) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("deformable_conv dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("deformable_conv");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{offset},{filter} };
    if (mask) amp_tensors_vector.push_back({ *mask });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_offset = egr::EagerAmpAutoCast("offset", offset, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    auto NEW_mask = egr::EagerAmpAutoCast("mask", mask, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return deformable_conv_final_state_dygraph_function(NEW_x, NEW_offset, NEW_filter, NEW_mask, strides, paddings, dilations, deformable_groups, groups, im2col_step);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* offset_autograd_meta = egr::EagerUtils::nullable_autograd_meta(offset);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  egr::AutogradMeta* mask_autograd_meta = egr::EagerUtils::nullable_autograd_meta(mask);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "deformable_conv_final_state_dygraph_function";
  auto api_result = paddle::experimental::deformable_conv(x, offset, filter, mask, strides, paddings, dilations, deformable_groups, groups, im2col_step);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("deformable_conv", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,offset_autograd_meta,filter_autograd_meta,mask_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("deformable_conv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DeformableConvGradNodeFinal>(new DeformableConvGradNodeFinal(1, 4));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedeformable_groups(deformable_groups);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributeim2col_step(im2col_step);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperoffset(offset);
    grad_node->SetTensorWrapperfilter(filter);
    if(mask) grad_node->SetTensorWrappermask(*mask);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(offset, 1);
    grad_node->SetGradOutMeta(filter, 2);
    if(mask.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(mask.get_ptr()), 3);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor depthwise_conv2d_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::string paddding_algorithm, int groups, std::vector<int> dilations, std::string data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, bool fuse_relu, bool use_gpudnn) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("depthwise_conv2d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("depthwise_conv2d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{filter} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return depthwise_conv2d_final_state_dygraph_function(NEW_input, NEW_filter, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, use_gpudnn);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "depthwise_conv2d_final_state_dygraph_function";
  auto api_result = paddle::experimental::depthwise_conv2d(input, filter, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, use_gpudnn);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("depthwise_conv2d", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta,filter_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("depthwise_conv2d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DepthwiseConv2dGradNodeFinal>(new DepthwiseConv2dGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepaddding_algorithm(paddding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributeuse_addto(use_addto);
    grad_node->SetAttributeworkspace_size_MB(workspace_size_MB);
    grad_node->SetAttributeexhaustive_search(exhaustive_search);
    grad_node->SetAttributefuse_relu(fuse_relu);
    grad_node->SetAttributeuse_gpudnn(use_gpudnn);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperfilter(filter);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(filter, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor depthwise_conv2d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("depthwise_conv2d_transpose dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("depthwise_conv2d_transpose");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{filter} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_filter = egr::EagerAmpAutoCast("filter", filter, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return depthwise_conv2d_transpose_final_state_dygraph_function(NEW_x, NEW_filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* filter_autograd_meta = egr::EagerUtils::nullable_autograd_meta(filter);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "depthwise_conv2d_transpose_final_state_dygraph_function";
  auto api_result = paddle::experimental::depthwise_conv2d_transpose(x, filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("depthwise_conv2d_transpose", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,filter_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("depthwise_conv2d_transpose node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DepthwiseConv2dTransposeGradNodeFinal>(new DepthwiseConv2dTransposeGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeoutput_padding(output_padding);
    grad_node->SetAttributeoutput_size(output_size);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperfilter(filter);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(filter, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor det_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("det dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("det");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return det_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "det_final_state_dygraph_function";
  auto api_result = paddle::experimental::det(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("det", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("det node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DetGradNodeFinal>(new DetGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor divide_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("divide dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("divide");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return divide_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "divide_final_state_dygraph_function";
  auto api_result = paddle::experimental::divide(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("divide node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DivideGradNodeFinal>(new DivideGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> dropout_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& seed_tensor, float p, bool is_test, std::string mode, int seed, bool fix_seed) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("dropout dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("dropout");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    if (seed_tensor) amp_tensors_vector.push_back({ *seed_tensor });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_seed_tensor = egr::EagerAmpAutoCast("seed_tensor", seed_tensor, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dropout_final_state_dygraph_function(NEW_x, NEW_seed_tensor, p, is_test, mode, seed, fix_seed);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "dropout_final_state_dygraph_function";
  auto api_result = paddle::experimental::dropout(x, seed_tensor, p, is_test, mode, seed, fix_seed);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dropout", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& mask = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* mask_autograd_meta = egr::EagerUtils::autograd_meta(&mask);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("dropout node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,mask_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DropoutGradNodeFinal>(new DropoutGradNodeFinal(2, 2));
    // SetAttributes if needed
    grad_node->SetAttributep(p);
    grad_node->SetAttributeis_test(is_test);
    grad_node->SetAttributemode(mode);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mask_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetHistory(mask_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(mask, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(mask);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappermask(mask);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, mask};
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> eigh_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::string uplo) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("eigh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("eigh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return eigh_final_state_dygraph_function(NEW_x, uplo);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "eigh_final_state_dygraph_function";
  auto api_result = paddle::experimental::eigh(x, uplo);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("eigh", api_result); }

  // Get Outputs
  auto& out_w = std::get<0>(api_result);
  auto& out_v = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_w_autograd_meta = egr::EagerUtils::autograd_meta(&out_w);
  egr::AutogradMeta* out_v_autograd_meta = egr::EagerUtils::autograd_meta(&out_v);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("eigh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_w_autograd_meta,out_v_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<EighGradNodeFinal>(new EighGradNodeFinal(2, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_w_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_w_autograd_meta, 0);
    }
    if (out_v_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_v_autograd_meta, 1);
    }
    if (out_w_autograd_meta) {
      egr::EagerUtils::SetHistory(out_w_autograd_meta, grad_node);
    }
    if (out_v_autograd_meta) {
      egr::EagerUtils::SetHistory(out_v_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out_w, 0);
    grad_node->SetGradInMeta(out_v, 1);
    egr::EagerUtils::CheckAndRetainGrad(out_w);
    egr::EagerUtils::CheckAndRetainGrad(out_v);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout_w(out_w);
    grad_node->SetTensorWrapperout_v(out_v);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out_w, out_v};
}


std::tuple<paddle::experimental::Tensor, std::vector<paddle::experimental::Tensor>, std::vector<paddle::experimental::Tensor>> einsum_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, std::string equation) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("einsum dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("einsum");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { x };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCasts("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return einsum_final_state_dygraph_function(NEW_x, equation);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> x_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(x);
  std::vector<egr::AutogradMeta*>* x_autograd_meta = &x_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "einsum_final_state_dygraph_function";
  auto api_result = paddle::experimental::einsum(x, equation);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("einsum", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& inner_cache = std::get<1>(api_result);
  auto& x_shape = std::get<2>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  std::vector<egr::AutogradMeta*> inner_cache_autograd_meta_vec = egr::EagerUtils::autograd_meta(&inner_cache);
  std::vector<egr::AutogradMeta*>* inner_cache_autograd_meta = &inner_cache_autograd_meta_vec;
  std::vector<egr::AutogradMeta*> x_shape_autograd_meta_vec = egr::EagerUtils::autograd_meta(&x_shape);
  std::vector<egr::AutogradMeta*>* x_shape_autograd_meta = &x_shape_autograd_meta_vec;
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("einsum node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,inner_cache_autograd_meta,x_shape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<EinsumGradNodeFinal>(new EinsumGradNodeFinal(3, 1));
    // SetAttributes if needed
    grad_node->SetAttributeequation(equation);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (inner_cache_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(inner_cache_autograd_meta, 1);
    }
    if (x_shape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(x_shape_autograd_meta, 2);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (inner_cache_autograd_meta) {
      egr::EagerUtils::SetHistory(inner_cache_autograd_meta, grad_node);
    }
    if (x_shape_autograd_meta) {
      egr::EagerUtils::SetHistory(x_shape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(inner_cache, 1);
    grad_node->SetGradInMeta(x_shape, 2);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(inner_cache);
    egr::EagerUtils::CheckAndRetainGrad(x_shape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperx_shape(x_shape);
    grad_node->SetTensorWrapperinner_cache(inner_cache);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, std::vector<paddle::experimental::Tensor>, std::vector<paddle::experimental::Tensor>>{out, inner_cache, x_shape};
}


paddle::experimental::Tensor elementwise_pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_pow dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("elementwise_pow");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elementwise_pow_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "elementwise_pow_final_state_dygraph_function";
  auto api_result = paddle::experimental::elementwise_pow(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("elementwise_pow", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_pow node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ElementwisePowGradNodeFinal>(new ElementwisePowGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor elu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("elu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("elu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elu_final_state_dygraph_function(NEW_x, alpha);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "elu_final_state_dygraph_function";
  auto api_result = paddle::experimental::elu(x, alpha);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("elu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("elu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<EluGradNodeFinal>(new EluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor embedding_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& weight, int64_t padding_idx, bool sparse) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("embedding dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("embedding");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{weight} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_weight = egr::EagerAmpAutoCast("weight", weight, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return embedding_final_state_dygraph_function(NEW_x, NEW_weight, padding_idx, sparse);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* weight_autograd_meta = egr::EagerUtils::nullable_autograd_meta(weight);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "embedding_final_state_dygraph_function";
  auto api_result = paddle::experimental::embedding(x, weight, padding_idx, sparse);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("embedding", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,weight_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("embedding node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<EmbeddingGradNodeFinal>(new EmbeddingGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributepadding_idx(padding_idx);
    grad_node->SetAttributesparse(sparse);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperweight(weight);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(weight, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor erfinv_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("erfinv dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("erfinv");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return erfinv_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "erfinv_final_state_dygraph_function";
  auto api_result = paddle::experimental::erfinv(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("erfinv", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("erfinv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ErfinvGradNodeFinal>(new ErfinvGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}

paddle::experimental::Tensor& erfinv__final_state_dygraph_function(paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("erfinv_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "erfinv__final_state_dygraph_function";
  auto& api_result = paddle::experimental::erfinv_(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("erfinv_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("erfinv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ErfinvGradNodeFinal>(new ErfinvGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor exp_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("exp dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("exp");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return exp_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "exp_final_state_dygraph_function";
  auto api_result = paddle::experimental::exp(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("exp", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("exp node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ExpGradNodeFinal>(new ExpGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor expand_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shape) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("expand dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("expand");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return expand_final_state_dygraph_function(NEW_x, shape);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "expand_final_state_dygraph_function";
  auto api_result = paddle::experimental::expand(x, shape);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expand", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("expand node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ExpandGradNodeFinal>(new ExpandGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeshape(shape);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor expand_as_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& y, std::vector<int> target_shape) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("expand_as dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("expand_as");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    if (y) amp_tensors_vector.push_back({ *y });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return expand_as_final_state_dygraph_function(NEW_x, NEW_y, target_shape);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "expand_as_final_state_dygraph_function";
  auto api_result = paddle::experimental::expand_as(x, y, target_shape);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expand_as", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("expand_as node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ExpandAsGradNodeFinal>(new ExpandAsGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributetarget_shape(target_shape);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor expm1_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("expm1 dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("expm1");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return expm1_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "expm1_final_state_dygraph_function";
  auto api_result = paddle::experimental::expm1(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expm1", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("expm1 node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Expm1GradNodeFinal>(new Expm1GradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor flatten_final_state_dygraph_function(const paddle::experimental::Tensor& x, int start_axis, int stop_axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("flatten");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return flatten_final_state_dygraph_function(NEW_x, start_axis, stop_axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "flatten_final_state_dygraph_function";
  auto api_result = paddle::experimental::flatten_intermediate(x, start_axis, stop_axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("flatten_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("flatten node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FlattenGradNodeFinal>(new FlattenGradNodeFinal(2, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}

paddle::experimental::Tensor& flatten__final_state_dygraph_function(paddle::experimental::Tensor& x, int start_axis, int stop_axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "flatten__final_state_dygraph_function";
  auto api_result = paddle::experimental::flatten_intermediate_(x, start_axis, stop_axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("flatten_intermediate_", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("flatten node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FlattenGradNodeFinal>(new FlattenGradNodeFinal(2, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor flip_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("flip dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("flip");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return flip_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "flip_final_state_dygraph_function";
  auto api_result = paddle::experimental::flip(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("flip", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("flip node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FlipGradNodeFinal>(new FlipGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor floor_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("floor dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("floor");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return floor_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "floor_final_state_dygraph_function";
  auto api_result = paddle::experimental::floor(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("floor", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("floor node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FloorGradNodeFinal>(new FloorGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor fmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("fmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("fmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fmax_final_state_dygraph_function(NEW_x, NEW_y, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "fmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::fmax(x, y, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fmax", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("fmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FmaxGradNodeFinal>(new FmaxGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor fmin_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("fmin dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("fmin");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fmin_final_state_dygraph_function(NEW_x, NEW_y, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "fmin_final_state_dygraph_function";
  auto api_result = paddle::experimental::fmin(x, y, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fmin", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("fmin node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FminGradNodeFinal>(new FminGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor frobenius_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> axis, bool keep_dim, bool reduce_all) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("frobenius_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("frobenius_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return frobenius_norm_final_state_dygraph_function(NEW_x, axis, keep_dim, reduce_all);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "frobenius_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::frobenius_norm(x, axis, keep_dim, reduce_all);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("frobenius_norm", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("frobenius_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FrobeniusNormGradNodeFinal>(new FrobeniusNormGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(reduce_all);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor gather_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, paddle::experimental::Scalar axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("gather dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("gather");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gather_final_state_dygraph_function(NEW_x, NEW_index, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "gather_final_state_dygraph_function";
  auto api_result = paddle::experimental::gather(x, index, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gather", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("gather node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GatherGradNodeFinal>(new GatherGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributeoverwrite(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor gather_nd_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("gather_nd dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("gather_nd");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gather_nd_final_state_dygraph_function(NEW_x, NEW_index);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "gather_nd_final_state_dygraph_function";
  auto api_result = paddle::experimental::gather_nd(x, index);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gather_nd", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("gather_nd node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GatherNdGradNodeFinal>(new GatherNdGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor gelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, bool approximate) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("gelu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("gelu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gelu_final_state_dygraph_function(NEW_x, approximate);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "gelu_final_state_dygraph_function";
  auto api_result = paddle::experimental::gelu(x, approximate);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gelu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("gelu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GeluGradNodeFinal>(new GeluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeapproximate(approximate);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor graph_send_recv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& src_index, const paddle::experimental::Tensor& dst_index, std::string pool_type, int64_t out_size) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("graph_send_recv dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("graph_send_recv");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{src_index},{dst_index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_src_index = egr::EagerAmpAutoCast("src_index", src_index, amp_dst_dtype, op_name);
    auto NEW_dst_index = egr::EagerAmpAutoCast("dst_index", dst_index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return graph_send_recv_final_state_dygraph_function(NEW_x, NEW_src_index, NEW_dst_index, pool_type, out_size);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "graph_send_recv_final_state_dygraph_function";
  auto api_result = paddle::experimental::graph_send_recv_intermediate(x, src_index, dst_index, pool_type, out_size);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("graph_send_recv_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& dst_count = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* dst_count_autograd_meta = egr::EagerUtils::autograd_meta(&dst_count);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("graph_send_recv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,dst_count_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GraphSendRecvGradNodeFinal>(new GraphSendRecvGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributepool_type(pool_type);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappersrc_index(src_index);
    grad_node->SetTensorWrapperdst_index(dst_index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (dst_count_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(dst_count_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (dst_count_autograd_meta) {
      egr::EagerUtils::SetHistory(dst_count_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(dst_count, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(dst_count);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrapperdst_count(dst_count);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor group_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon, int groups, std::string data_layout) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("group_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("group_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    if (scale) amp_tensors_vector.push_back({ *scale });
if (bias) amp_tensors_vector.push_back({ *bias });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_scale = egr::EagerAmpAutoCast("scale", scale, amp_dst_dtype, op_name);
    auto NEW_bias = egr::EagerAmpAutoCast("bias", bias, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return group_norm_final_state_dygraph_function(NEW_x, NEW_scale, NEW_bias, epsilon, groups, data_layout);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* scale_autograd_meta = egr::EagerUtils::nullable_autograd_meta(scale);
  egr::AutogradMeta* bias_autograd_meta = egr::EagerUtils::nullable_autograd_meta(bias);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "group_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::group_norm_intermediate(x, scale, bias, epsilon, groups, data_layout);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("group_norm_intermediate", api_result); }

  // Get Outputs
  auto& y = std::get<0>(api_result);
  auto& mean = std::get<1>(api_result);
  auto& variance = std::get<2>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::autograd_meta(&y);
  egr::AutogradMeta* mean_autograd_meta = egr::EagerUtils::autograd_meta(&mean);
  egr::AutogradMeta* variance_autograd_meta = egr::EagerUtils::autograd_meta(&variance);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,scale_autograd_meta,bias_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("group_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,y_autograd_meta,mean_autograd_meta,variance_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GroupNormGradNodeFinal>(new GroupNormGradNodeFinal(3, 3));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedata_layout(data_layout);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    if(scale) grad_node->SetTensorWrapperscale(*scale);
    if(bias) grad_node->SetTensorWrapperbias(*bias);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    if(scale.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(scale.get_ptr()), 1);
    if(bias.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(bias.get_ptr()), 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(y_autograd_meta, 0);
    }
    if (mean_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mean_autograd_meta, 1);
    }
    if (variance_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(variance_autograd_meta, 2);
    }
    if (y_autograd_meta) {
      egr::EagerUtils::SetHistory(y_autograd_meta, grad_node);
    }
    if (mean_autograd_meta) {
      egr::EagerUtils::SetHistory(mean_autograd_meta, grad_node);
    }
    if (variance_autograd_meta) {
      egr::EagerUtils::SetHistory(variance_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(y, 0);
    grad_node->SetGradInMeta(mean, 1);
    grad_node->SetGradInMeta(variance, 2);
    egr::EagerUtils::CheckAndRetainGrad(y);
    egr::EagerUtils::CheckAndRetainGrad(mean);
    egr::EagerUtils::CheckAndRetainGrad(variance);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrappermean(mean);
    grad_node->SetTensorWrappervariance(variance);
  }

  // Returns
  return y;
}


paddle::experimental::Tensor gumbel_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, float temperature, bool hard, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("gumbel_softmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("gumbel_softmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gumbel_softmax_final_state_dygraph_function(NEW_x, temperature, hard, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "gumbel_softmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::gumbel_softmax(x, temperature, hard, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gumbel_softmax", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("gumbel_softmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<GumbelSoftmaxGradNodeFinal>(new GumbelSoftmaxGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor hard_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("hard_shrink dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("hard_shrink");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return hard_shrink_final_state_dygraph_function(NEW_x, threshold);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "hard_shrink_final_state_dygraph_function";
  auto api_result = paddle::experimental::hard_shrink(x, threshold);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_shrink", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("hard_shrink node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<HardShrinkGradNodeFinal>(new HardShrinkGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributethreshold(threshold);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor hard_sigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x, float slope, float offset) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("hard_sigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("hard_sigmoid");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return hard_sigmoid_final_state_dygraph_function(NEW_x, slope, offset);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "hard_sigmoid_final_state_dygraph_function";
  auto api_result = paddle::experimental::hard_sigmoid(x, slope, offset);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_sigmoid", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("hard_sigmoid node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<HardSigmoidGradNodeFinal>(new HardSigmoidGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeslope(slope);
    grad_node->SetAttributeoffset(offset);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor hard_swish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold, float scale, float offset) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("hard_swish dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("hard_swish");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return hard_swish_final_state_dygraph_function(NEW_x, threshold, scale, offset);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "hard_swish_final_state_dygraph_function";
  auto api_result = paddle::experimental::hard_swish(x, threshold, scale, offset);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_swish", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("hard_swish node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<HardSwishGradNodeFinal>(new HardSwishGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributethreshold(threshold);
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributeoffset(offset);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> huber_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, float delta) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("huber_loss dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("huber_loss");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return huber_loss_final_state_dygraph_function(NEW_input, NEW_label, delta);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  egr::AutogradMeta* label_autograd_meta = egr::EagerUtils::nullable_autograd_meta(label);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "huber_loss_final_state_dygraph_function";
  auto api_result = paddle::experimental::huber_loss(input, label, delta);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("huber_loss", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& residual = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* residual_autograd_meta = egr::EagerUtils::autograd_meta(&residual);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta,label_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("huber_loss node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,residual_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<HuberLossGradNodeFinal>(new HuberLossGradNodeFinal(2, 2));
    // SetAttributes if needed
    grad_node->SetAttributedelta(delta);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(label, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (residual_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(residual_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (residual_autograd_meta) {
      egr::EagerUtils::SetHistory(residual_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(residual, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(residual);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperresidual(residual);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, residual};
}


paddle::experimental::Tensor imag_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("imag dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("imag");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return imag_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "imag_final_state_dygraph_function";
  auto api_result = paddle::experimental::imag(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("imag", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("imag node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ImagGradNodeFinal>(new ImagGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor index_sample_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("index_sample dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("index_sample");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return index_sample_final_state_dygraph_function(NEW_x, NEW_index);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "index_sample_final_state_dygraph_function";
  auto api_result = paddle::experimental::index_sample(x, index);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("index_sample", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("index_sample node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<IndexSampleGradNodeFinal>(new IndexSampleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor index_select_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, int dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("index_select dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("index_select");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return index_select_final_state_dygraph_function(NEW_x, NEW_index, dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "index_select_final_state_dygraph_function";
  auto api_result = paddle::experimental::index_select(x, index, dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("index_select", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("index_select node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<IndexSelectGradNodeFinal>(new IndexSelectGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributedim(dim);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor instance_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("instance_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("instance_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    if (scale) amp_tensors_vector.push_back({ *scale });
if (bias) amp_tensors_vector.push_back({ *bias });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_scale = egr::EagerAmpAutoCast("scale", scale, amp_dst_dtype, op_name);
    auto NEW_bias = egr::EagerAmpAutoCast("bias", bias, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return instance_norm_final_state_dygraph_function(NEW_x, NEW_scale, NEW_bias, epsilon);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* scale_autograd_meta = egr::EagerUtils::nullable_autograd_meta(scale);
  egr::AutogradMeta* bias_autograd_meta = egr::EagerUtils::nullable_autograd_meta(bias);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "instance_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::instance_norm_intermediate(x, scale, bias, epsilon);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("instance_norm_intermediate", api_result); }

  // Get Outputs
  auto& y = std::get<0>(api_result);
  auto& saved_mean = std::get<1>(api_result);
  auto& saved_variance = std::get<2>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::autograd_meta(&y);
  egr::AutogradMeta* saved_mean_autograd_meta = egr::EagerUtils::autograd_meta(&saved_mean);
  egr::AutogradMeta* saved_variance_autograd_meta = egr::EagerUtils::autograd_meta(&saved_variance);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,scale_autograd_meta,bias_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("instance_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,y_autograd_meta,saved_mean_autograd_meta,saved_variance_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<InstanceNormGradNodeFinal>(new InstanceNormGradNodeFinal(3, 3));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    if(scale) grad_node->SetTensorWrapperscale(*scale);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    if(scale.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(scale.get_ptr()), 1);
    if(bias.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(bias.get_ptr()), 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(y_autograd_meta, 0);
    }
    if (saved_mean_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(saved_mean_autograd_meta, 1);
    }
    if (saved_variance_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(saved_variance_autograd_meta, 2);
    }
    if (y_autograd_meta) {
      egr::EagerUtils::SetHistory(y_autograd_meta, grad_node);
    }
    if (saved_mean_autograd_meta) {
      egr::EagerUtils::SetHistory(saved_mean_autograd_meta, grad_node);
    }
    if (saved_variance_autograd_meta) {
      egr::EagerUtils::SetHistory(saved_variance_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(y, 0);
    grad_node->SetGradInMeta(saved_mean, 1);
    grad_node->SetGradInMeta(saved_variance, 2);
    egr::EagerUtils::CheckAndRetainGrad(y);
    egr::EagerUtils::CheckAndRetainGrad(saved_mean);
    egr::EagerUtils::CheckAndRetainGrad(saved_variance);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappersaved_mean(saved_mean);
    grad_node->SetTensorWrappersaved_variance(saved_variance);
  }

  // Returns
  return y;
}


paddle::experimental::Tensor kldiv_loss_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& label, std::string reduction) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("kldiv_loss dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("kldiv_loss");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return kldiv_loss_final_state_dygraph_function(NEW_x, NEW_label, reduction);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "kldiv_loss_final_state_dygraph_function";
  auto api_result = paddle::experimental::kldiv_loss(x, label, reduction);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kldiv_loss", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("kldiv_loss node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<KldivLossGradNodeFinal>(new KldivLossGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributereduction(reduction);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperlabel(label);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor kron_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("kron dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("kron");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return kron_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "kron_final_state_dygraph_function";
  auto api_result = paddle::experimental::kron(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kron", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("kron node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<KronGradNodeFinal>(new KronGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> kthvalue_final_state_dygraph_function(const paddle::experimental::Tensor& x, int k, int axis, bool keepdim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("kthvalue dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("kthvalue");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return kthvalue_final_state_dygraph_function(NEW_x, k, axis, keepdim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "kthvalue_final_state_dygraph_function";
  auto api_result = paddle::experimental::kthvalue(x, k, axis, keepdim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kthvalue", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& indices = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* indices_autograd_meta = egr::EagerUtils::autograd_meta(&indices);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("kthvalue node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,indices_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<KthvalueGradNodeFinal>(new KthvalueGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributek(k);
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributekeepdim(keepdim);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(indices_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetHistory(indices_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(indices, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(indices);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperindices(indices);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, indices};
}


paddle::experimental::Tensor label_smooth_final_state_dygraph_function(const paddle::experimental::Tensor& label, const paddle::optional<paddle::experimental::Tensor>& prior_dist, float epsilon) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("label_smooth dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("label_smooth");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {label} };
    if (prior_dist) amp_tensors_vector.push_back({ *prior_dist });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    auto NEW_prior_dist = egr::EagerAmpAutoCast("prior_dist", prior_dist, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return label_smooth_final_state_dygraph_function(NEW_label, NEW_prior_dist, epsilon);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* label_autograd_meta = egr::EagerUtils::nullable_autograd_meta(label);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "label_smooth_final_state_dygraph_function";
  auto api_result = paddle::experimental::label_smooth(label, prior_dist, epsilon);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("label_smooth", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,label_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("label_smooth node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LabelSmoothGradNodeFinal>(new LabelSmoothGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(label, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor> layer_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon, int begin_norm_axis, bool is_test) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("layer_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("layer_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    if (scale) amp_tensors_vector.push_back({ *scale });
if (bias) amp_tensors_vector.push_back({ *bias });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_scale = egr::EagerAmpAutoCast("scale", scale, amp_dst_dtype, op_name);
    auto NEW_bias = egr::EagerAmpAutoCast("bias", bias, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return layer_norm_final_state_dygraph_function(NEW_x, NEW_scale, NEW_bias, epsilon, begin_norm_axis, is_test);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* scale_autograd_meta = egr::EagerUtils::nullable_autograd_meta(scale);
  egr::AutogradMeta* bias_autograd_meta = egr::EagerUtils::nullable_autograd_meta(bias);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "layer_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::layer_norm(x, scale, bias, epsilon, begin_norm_axis, is_test);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("layer_norm", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& mean = std::get<1>(api_result);
  auto& variance = std::get<2>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* mean_autograd_meta = egr::EagerUtils::autograd_meta(&mean);
  egr::AutogradMeta* variance_autograd_meta = egr::EagerUtils::autograd_meta(&variance);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,scale_autograd_meta,bias_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("layer_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,mean_autograd_meta,variance_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LayerNormGradNodeFinal>(new LayerNormGradNodeFinal(3, 3));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributebegin_norm_axis(begin_norm_axis);
    grad_node->SetAttributeis_test(is_test);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    if(scale) grad_node->SetTensorWrapperscale(*scale);
    if(bias) grad_node->SetTensorWrapperbias(*bias);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    if(scale.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(scale.get_ptr()), 1);
    if(bias.get_ptr() != nullptr) grad_node->SetGradOutMeta(*(bias.get_ptr()), 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (mean_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mean_autograd_meta, 1);
    }
    if (variance_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(variance_autograd_meta, 2);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (mean_autograd_meta) {
      egr::EagerUtils::SetHistory(mean_autograd_meta, grad_node);
    }
    if (variance_autograd_meta) {
      egr::EagerUtils::SetHistory(variance_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(mean, 1);
    grad_node->SetGradInMeta(variance, 2);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(mean);
    egr::EagerUtils::CheckAndRetainGrad(variance);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappermean(mean);
    grad_node->SetTensorWrappervariance(variance);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor>{out, mean, variance};
}


paddle::experimental::Tensor leaky_relu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("leaky_relu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("leaky_relu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return leaky_relu_final_state_dygraph_function(NEW_x, alpha);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "leaky_relu_final_state_dygraph_function";
  auto api_result = paddle::experimental::leaky_relu(x, alpha);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("leaky_relu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("leaky_relu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LeakyReluGradNodeFinal>(new LeakyReluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor lerp_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, const paddle::experimental::Tensor& weight) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("lerp dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("lerp");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y},{weight} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    auto NEW_weight = egr::EagerAmpAutoCast("weight", weight, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lerp_final_state_dygraph_function(NEW_x, NEW_y, NEW_weight);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "lerp_final_state_dygraph_function";
  auto api_result = paddle::experimental::lerp(x, y, weight);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("lerp", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("lerp node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LerpGradNodeFinal>(new LerpGradNodeFinal(1, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrapperweight(weight);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor lgamma_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("lgamma dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("lgamma");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lgamma_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "lgamma_final_state_dygraph_function";
  auto api_result = paddle::experimental::lgamma(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("lgamma", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("lgamma node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LgammaGradNodeFinal>(new LgammaGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log_final_state_dygraph_function";
  auto api_result = paddle::experimental::log(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogGradNodeFinal>(new LogGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log10_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log10 dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log10");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log10_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log10_final_state_dygraph_function";
  auto api_result = paddle::experimental::log10(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log10", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log10 node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Log10GradNodeFinal>(new Log10GradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log1p_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log1p dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log1p");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log1p_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log1p_final_state_dygraph_function";
  auto api_result = paddle::experimental::log1p(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log1p", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log1p node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Log1pGradNodeFinal>(new Log1pGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log2_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log2 dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log2");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log2_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log2_final_state_dygraph_function";
  auto api_result = paddle::experimental::log2(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log2", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log2 node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Log2GradNodeFinal>(new Log2GradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, float epsilon) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log_loss dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log_loss");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log_loss_final_state_dygraph_function(NEW_input, NEW_label, epsilon);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log_loss_final_state_dygraph_function";
  auto api_result = paddle::experimental::log_loss(input, label, epsilon);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_loss", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log_loss node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogLossGradNodeFinal>(new LogLossGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperlabel(label);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log_softmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log_softmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log_softmax_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log_softmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::log_softmax(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_softmax", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log_softmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogSoftmaxGradNodeFinal>(new LogSoftmaxGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor logcumsumexp_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool flatten, bool exclusive, bool reverse) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("logcumsumexp dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("logcumsumexp");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logcumsumexp_final_state_dygraph_function(NEW_x, axis, flatten, exclusive, reverse);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "logcumsumexp_final_state_dygraph_function";
  auto api_result = paddle::experimental::logcumsumexp(x, axis, flatten, exclusive, reverse);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logcumsumexp", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("logcumsumexp node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogcumsumexpGradNodeFinal>(new LogcumsumexpGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributeflatten(flatten);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributereverse(reverse);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor logit_final_state_dygraph_function(const paddle::experimental::Tensor& x, float eps) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("logit dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("logit");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logit_final_state_dygraph_function(NEW_x, eps);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "logit_final_state_dygraph_function";
  auto api_result = paddle::experimental::logit(x, eps);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logit", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("logit node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogitGradNodeFinal>(new LogitGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeeps(eps);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor logsigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("logsigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("logsigmoid");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logsigmoid_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "logsigmoid_final_state_dygraph_function";
  auto api_result = paddle::experimental::logsigmoid(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logsigmoid", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("logsigmoid node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogsigmoidGradNodeFinal>(new LogsigmoidGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor logsumexp_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> axis, bool keepdim, bool reduce_all) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("logsumexp dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("logsumexp");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logsumexp_final_state_dygraph_function(NEW_x, axis, keepdim, reduce_all);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "logsumexp_final_state_dygraph_function";
  auto api_result = paddle::experimental::logsumexp(x, axis, keepdim, reduce_all);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logsumexp", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("logsumexp node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<LogsumexpGradNodeFinal>(new LogsumexpGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributekeepdim(keepdim);
    grad_node->SetAttributereduce_all(reduce_all);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor masked_select_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& mask) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("masked_select dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("masked_select");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{mask} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_mask = egr::EagerAmpAutoCast("mask", mask, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return masked_select_final_state_dygraph_function(NEW_x, NEW_mask);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "masked_select_final_state_dygraph_function";
  auto api_result = paddle::experimental::masked_select(x, mask);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("masked_select", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("masked_select node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaskedSelectGradNodeFinal>(new MaskedSelectGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappermask(mask);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool transpose_x, bool transpose_y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("matmul dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("matmul");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return matmul_final_state_dygraph_function(NEW_x, NEW_y, transpose_x, transpose_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "matmul_final_state_dygraph_function";
  auto api_result = paddle::experimental::matmul(x, y, transpose_x, transpose_y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("matmul node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MatmulGradNodeFinal>(new MatmulGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributetranspose_x(transpose_x);
    grad_node->SetAttributetranspose_y(transpose_y);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor matrix_power_final_state_dygraph_function(const paddle::experimental::Tensor& x, int n) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("matrix_power dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("matrix_power");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return matrix_power_final_state_dygraph_function(NEW_x, n);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "matrix_power_final_state_dygraph_function";
  auto api_result = paddle::experimental::matrix_power(x, n);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matrix_power", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("matrix_power node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MatrixPowerGradNodeFinal>(new MatrixPowerGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributen(n);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor max_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, bool keep_dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("max dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("max");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return max_final_state_dygraph_function(NEW_x, dims, keep_dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "max_final_state_dygraph_function";
  auto api_result = paddle::experimental::max(x, dims, keep_dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("max node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaxGradNodeFinal>(new MaxGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> max_pool2d_with_index_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool global_pooling, bool adaptive) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("max_pool2d_with_index dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("max_pool2d_with_index");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return max_pool2d_with_index_final_state_dygraph_function(NEW_x, kernel_size, strides, paddings, global_pooling, adaptive);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "max_pool2d_with_index_final_state_dygraph_function";
  auto api_result = paddle::experimental::max_pool2d_with_index(x, kernel_size, strides, paddings, global_pooling, adaptive);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max_pool2d_with_index", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& mask = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* mask_autograd_meta = egr::EagerUtils::autograd_meta(&mask);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("max_pool2d_with_index node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,mask_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaxPool2dWithIndexGradNodeFinal>(new MaxPool2dWithIndexGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mask_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetHistory(mask_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(mask, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(mask);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappermask(mask);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, mask};
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> max_pool3d_with_index_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool global_pooling, bool adaptive) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("max_pool3d_with_index dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("max_pool3d_with_index");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return max_pool3d_with_index_final_state_dygraph_function(NEW_x, kernel_size, strides, paddings, global_pooling, adaptive);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "max_pool3d_with_index_final_state_dygraph_function";
  auto api_result = paddle::experimental::max_pool3d_with_index(x, kernel_size, strides, paddings, global_pooling, adaptive);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max_pool3d_with_index", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& mask = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* mask_autograd_meta = egr::EagerUtils::autograd_meta(&mask);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("max_pool3d_with_index node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,mask_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaxPool3dWithIndexGradNodeFinal>(new MaxPool3dWithIndexGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(mask_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (mask_autograd_meta) {
      egr::EagerUtils::SetHistory(mask_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(mask, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(mask);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappermask(mask);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, mask};
}


paddle::experimental::Tensor maximum_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("maximum dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("maximum");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return maximum_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "maximum_final_state_dygraph_function";
  auto api_result = paddle::experimental::maximum(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("maximum", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("maximum node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaximumGradNodeFinal>(new MaximumGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor maxout_final_state_dygraph_function(const paddle::experimental::Tensor& x, int groups, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("maxout dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("maxout");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return maxout_final_state_dygraph_function(NEW_x, groups, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "maxout_final_state_dygraph_function";
  auto api_result = paddle::experimental::maxout(x, groups, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("maxout", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("maxout node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaxoutGradNodeFinal>(new MaxoutGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor mean_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, bool keep_dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mean dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mean");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mean_final_state_dygraph_function(NEW_x, dims, keep_dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mean_final_state_dygraph_function";
  auto api_result = paddle::experimental::mean(x, dims, keep_dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mean", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mean node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MeanGradNodeFinal>(new MeanGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor mean_all_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mean_all dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mean_all");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mean_all_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mean_all_final_state_dygraph_function";
  auto api_result = paddle::experimental::mean_all(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mean_all", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mean_all node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MeanAllGradNodeFinal>(new MeanAllGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::vector<paddle::experimental::Tensor> meshgrid_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& inputs) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("meshgrid dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("meshgrid");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { inputs };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_inputs = egr::EagerAmpAutoCasts("inputs", inputs, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return meshgrid_final_state_dygraph_function(NEW_inputs);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> inputs_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(inputs);
  std::vector<egr::AutogradMeta*>* inputs_autograd_meta = &inputs_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "meshgrid_final_state_dygraph_function";
  auto api_result = paddle::experimental::meshgrid(inputs);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("meshgrid", api_result); }

  // Get Outputs
  auto& outputs = api_result;

  // Get Output AutoGradMeta
  std::vector<egr::AutogradMeta*> outputs_autograd_meta_vec = egr::EagerUtils::autograd_meta(&outputs);
  std::vector<egr::AutogradMeta*>* outputs_autograd_meta = &outputs_autograd_meta_vec;
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,inputs_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("meshgrid node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,outputs_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MeshgridGradNodeFinal>(new MeshgridGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinputs(inputs);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(inputs, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (outputs_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(outputs_autograd_meta, 0);
    }
    if (outputs_autograd_meta) {
      egr::EagerUtils::SetHistory(outputs_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(outputs, 0);
    egr::EagerUtils::CheckAndRetainGrad(outputs);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return outputs;
}


paddle::experimental::Tensor min_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, bool keep_dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("min dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("min");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return min_final_state_dygraph_function(NEW_x, dims, keep_dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "min_final_state_dygraph_function";
  auto api_result = paddle::experimental::min(x, dims, keep_dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("min", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("min node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MinGradNodeFinal>(new MinGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor minimum_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("minimum dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("minimum");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return minimum_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "minimum_final_state_dygraph_function";
  auto api_result = paddle::experimental::minimum(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("minimum", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("minimum node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MinimumGradNodeFinal>(new MinimumGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor mish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mish dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mish");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mish_final_state_dygraph_function(NEW_x, threshold);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mish_final_state_dygraph_function";
  auto api_result = paddle::experimental::mish(x, threshold);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mish", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mish node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MishGradNodeFinal>(new MishGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributethreshold(threshold);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> mode_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool keepdim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mode dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mode");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mode_final_state_dygraph_function(NEW_x, axis, keepdim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mode_final_state_dygraph_function";
  auto api_result = paddle::experimental::mode(x, axis, keepdim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mode", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& indices = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* indices_autograd_meta = egr::EagerUtils::autograd_meta(&indices);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mode node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,indices_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ModeGradNodeFinal>(new ModeGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributekeepdim(keepdim);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(indices_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetHistory(indices_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(indices, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(indices);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperindices(indices);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, indices};
}


paddle::experimental::Tensor modulo_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("modulo dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("modulo");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return modulo_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "modulo_final_state_dygraph_function";
  auto api_result = paddle::experimental::modulo(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("modulo", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("modulo node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ModuloGradNodeFinal>(new ModuloGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor multi_dot_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("multi_dot dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("multi_dot");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { x };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCasts("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multi_dot_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> x_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(x);
  std::vector<egr::AutogradMeta*>* x_autograd_meta = &x_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "multi_dot_final_state_dygraph_function";
  auto api_result = paddle::experimental::multi_dot(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multi_dot", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("multi_dot node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiDotGradNodeFinal>(new MultiDotGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor multiplex_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& ins, const paddle::experimental::Tensor& ids) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("multiplex dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("multiplex");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { ins,{ids} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_ins = egr::EagerAmpAutoCasts("ins", ins, amp_dst_dtype, op_name);
    auto NEW_ids = egr::EagerAmpAutoCast("ids", ids, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multiplex_final_state_dygraph_function(NEW_ins, NEW_ids);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> ins_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(ins);
  std::vector<egr::AutogradMeta*>* ins_autograd_meta = &ins_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "multiplex_final_state_dygraph_function";
  auto api_result = paddle::experimental::multiplex(ins, ids);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiplex", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,ins_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("multiplex node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiplexGradNodeFinal>(new MultiplexGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperins(ins);
    grad_node->SetTensorWrapperids(ids);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(ins, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor multiply_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("multiply dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("multiply");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multiply_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "multiply_final_state_dygraph_function";
  auto api_result = paddle::experimental::multiply(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("multiply node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiplyGradNodeFinal>(new MultiplyGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> nll_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, const paddle::optional<paddle::experimental::Tensor>& weight, int64_t ignore_index, std::string reduction) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("nll_loss dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("nll_loss");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input},{label} };
    if (weight) amp_tensors_vector.push_back({ *weight });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    auto NEW_weight = egr::EagerAmpAutoCast("weight", weight, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return nll_loss_final_state_dygraph_function(NEW_input, NEW_label, NEW_weight, ignore_index, reduction);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "nll_loss_final_state_dygraph_function";
  auto api_result = paddle::experimental::nll_loss(input, label, weight, ignore_index, reduction);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("nll_loss", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& total_weight = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* total_weight_autograd_meta = egr::EagerUtils::autograd_meta(&total_weight);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("nll_loss node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,total_weight_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<NllLossGradNodeFinal>(new NllLossGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributeignore_index(ignore_index);
    grad_node->SetAttributereduction(reduction);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperlabel(label);
    if(weight) grad_node->SetTensorWrapperweight(*weight);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (total_weight_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(total_weight_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (total_weight_autograd_meta) {
      egr::EagerUtils::SetHistory(total_weight_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(total_weight, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(total_weight);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappertotal_weight(total_weight);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, total_weight};
}


paddle::experimental::Tensor norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, float epsilon, bool is_test) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return norm_final_state_dygraph_function(NEW_x, axis, epsilon, is_test);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::norm_intermediate(x, axis, epsilon, is_test);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("norm_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& norm = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* norm_autograd_meta = egr::EagerUtils::autograd_meta(&norm);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,norm_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<NormGradNodeFinal>(new NormGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributeis_test(is_test);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (norm_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(norm_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (norm_autograd_meta) {
      egr::EagerUtils::SetHistory(norm_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(norm, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(norm);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappernorm(norm);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor p_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, float porder, int axis, float epsilon, bool keepdim, bool asvector) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("p_norm dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("p_norm");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return p_norm_final_state_dygraph_function(NEW_x, porder, axis, epsilon, keepdim, asvector);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "p_norm_final_state_dygraph_function";
  auto api_result = paddle::experimental::p_norm(x, porder, axis, epsilon, keepdim, asvector);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("p_norm", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("p_norm node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PNormGradNodeFinal>(new PNormGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeporder(porder);
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributekeepdim(keepdim);
    grad_node->SetAttributeasvector(asvector);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor pad_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> paddings, float pad_value) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pad dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pad");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pad_final_state_dygraph_function(NEW_x, paddings, pad_value);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pad_final_state_dygraph_function";
  auto api_result = paddle::experimental::pad(x, paddings, pad_value);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PadGradNodeFinal>(new PadGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepad_value(pad_value);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor pad3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray paddings, std::string mode, float pad_value, std::string data_format) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pad3d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pad3d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pad3d_final_state_dygraph_function(NEW_x, paddings, mode, pad_value, data_format);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pad3d_final_state_dygraph_function";
  auto api_result = paddle::experimental::pad3d(x, paddings, mode, pad_value, data_format);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad3d", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pad3d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Pad3dGradNodeFinal>(new Pad3dGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributemode(mode);
    grad_node->SetAttributepad_value(pad_value);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor pixel_shuffle_final_state_dygraph_function(const paddle::experimental::Tensor& x, int upscale_factor, std::string data_format) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pixel_shuffle dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pixel_shuffle");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pixel_shuffle_final_state_dygraph_function(NEW_x, upscale_factor, data_format);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pixel_shuffle_final_state_dygraph_function";
  auto api_result = paddle::experimental::pixel_shuffle(x, upscale_factor, data_format);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pixel_shuffle", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pixel_shuffle node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PixelShuffleGradNodeFinal>(new PixelShuffleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeupscale_factor(upscale_factor);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor pool2d_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pool2d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pool2d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pool2d_final_state_dygraph_function(NEW_x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pool2d_final_state_dygraph_function";
  auto api_result = paddle::experimental::pool2d(x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool2d", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pool2d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Pool2dGradNodeFinal>(new Pool2dGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeceil_mode(ceil_mode);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributepooling_type(pooling_type);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor pool2d_gpudnn_unused_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pool2d_gpudnn_unused dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pool2d_gpudnn_unused");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pool2d_gpudnn_unused_final_state_dygraph_function(NEW_x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pool2d_gpudnn_unused_final_state_dygraph_function";
  auto api_result = paddle::experimental::pool2d_gpudnn_unused(x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool2d_gpudnn_unused", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pool2d_gpudnn_unused node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Pool2dGradGpudnnUnusedGradNodeFinal>(new Pool2dGradGpudnnUnusedGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeceil_mode(ceil_mode);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributepooling_type(pooling_type);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor pool3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pool3d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pool3d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pool3d_final_state_dygraph_function(NEW_x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pool3d_final_state_dygraph_function";
  auto api_result = paddle::experimental::pool3d(x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool3d", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pool3d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Pool3dGradNodeFinal>(new Pool3dGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeceil_mode(ceil_mode);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributepooling_type(pooling_type);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar s) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pow dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pow");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pow_final_state_dygraph_function(NEW_x, s);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pow_final_state_dygraph_function";
  auto api_result = paddle::experimental::pow(x, s);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pow", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pow node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PowGradNodeFinal>(new PowGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributes(s);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor prelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& alpha, std::string data_format, std::string mode) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("prelu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("prelu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{alpha} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_alpha = egr::EagerAmpAutoCast("alpha", alpha, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return prelu_final_state_dygraph_function(NEW_x, NEW_alpha, data_format, mode);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* alpha_autograd_meta = egr::EagerUtils::nullable_autograd_meta(alpha);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "prelu_final_state_dygraph_function";
  auto api_result = paddle::experimental::prelu(x, alpha, data_format, mode);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("prelu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,alpha_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("prelu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PreluGradNodeFinal>(new PreluGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributemode(mode);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperalpha(alpha);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(alpha, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor psroi_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, int output_channels, float spatial_scale) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("psroi_pool dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("psroi_pool");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{boxes} };
    if (boxes_num) amp_tensors_vector.push_back({ *boxes_num });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_boxes = egr::EagerAmpAutoCast("boxes", boxes, amp_dst_dtype, op_name);
    auto NEW_boxes_num = egr::EagerAmpAutoCast("boxes_num", boxes_num, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return psroi_pool_final_state_dygraph_function(NEW_x, NEW_boxes, NEW_boxes_num, pooled_height, pooled_width, output_channels, spatial_scale);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "psroi_pool_final_state_dygraph_function";
  auto api_result = paddle::experimental::psroi_pool(x, boxes, boxes_num, pooled_height, pooled_width, output_channels, spatial_scale);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("psroi_pool", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("psroi_pool node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PsroiPoolGradNodeFinal>(new PsroiPoolGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributepooled_height(pooled_height);
    grad_node->SetAttributepooled_width(pooled_width);
    grad_node->SetAttributeoutput_channels(output_channels);
    grad_node->SetAttributespatial_scale(spatial_scale);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperboxes(boxes);
    if(boxes_num) grad_node->SetTensorWrapperboxes_num(*boxes_num);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor put_along_axis_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& value, int axis, std::string reduce) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("put_along_axis dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("put_along_axis");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index},{value} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    auto NEW_value = egr::EagerAmpAutoCast("value", value, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return put_along_axis_final_state_dygraph_function(NEW_x, NEW_index, NEW_value, axis, reduce);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* value_autograd_meta = egr::EagerUtils::nullable_autograd_meta(value);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "put_along_axis_final_state_dygraph_function";
  auto api_result = paddle::experimental::put_along_axis(x, index, value, axis, reduce);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("put_along_axis", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,value_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("put_along_axis node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PutAlongAxisGradNodeFinal>(new PutAlongAxisGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributereduce(reduce);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(value, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor real_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("real dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("real");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return real_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "real_final_state_dygraph_function";
  auto api_result = paddle::experimental::real(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("real", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("real node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RealGradNodeFinal>(new RealGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor reciprocal_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("reciprocal dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("reciprocal");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reciprocal_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "reciprocal_final_state_dygraph_function";
  auto api_result = paddle::experimental::reciprocal(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reciprocal", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("reciprocal node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReciprocalGradNodeFinal>(new ReciprocalGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor reduce_prod_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, bool keep_dim, bool reduce_all) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("reduce_prod dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("reduce_prod");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reduce_prod_final_state_dygraph_function(NEW_x, dims, keep_dim, reduce_all);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "reduce_prod_final_state_dygraph_function";
  auto api_result = paddle::experimental::reduce_prod(x, dims, keep_dim, reduce_all);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reduce_prod", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("reduce_prod node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReduceProdGradNodeFinal>(new ReduceProdGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(reduce_all);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor relu_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("relu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("relu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return relu_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "relu_final_state_dygraph_function";
  auto api_result = paddle::experimental::relu(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("relu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReluGradNodeFinal>(new ReluGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}

paddle::experimental::Tensor& relu__final_state_dygraph_function(paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("relu_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "relu__final_state_dygraph_function";
  auto& api_result = paddle::experimental::relu_(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("relu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReluGradNodeFinal>(new ReluGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor relu6_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("relu6 dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("relu6");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return relu6_final_state_dygraph_function(NEW_x, threshold);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "relu6_final_state_dygraph_function";
  auto api_result = paddle::experimental::relu6(x, threshold);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu6", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("relu6 node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Relu6GradNodeFinal>(new Relu6GradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributethreshold(threshold);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor reshape_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shape) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("reshape dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("reshape");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reshape_final_state_dygraph_function(NEW_x, shape);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "reshape_final_state_dygraph_function";
  auto api_result = paddle::experimental::reshape_intermediate(x, shape);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reshape_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("reshape node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReshapeGradNodeFinal>(new ReshapeGradNodeFinal(2, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}

paddle::experimental::Tensor& reshape__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::IntArray shape) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("reshape_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "reshape__final_state_dygraph_function";
  auto api_result = paddle::experimental::reshape_intermediate_(x, shape);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reshape_intermediate_", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("reshape node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReshapeGradNodeFinal>(new ReshapeGradNodeFinal(2, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor roi_align_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, float spatial_scale, int sampling_ratio, bool aligned) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("roi_align dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("roi_align");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{boxes} };
    if (boxes_num) amp_tensors_vector.push_back({ *boxes_num });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_boxes = egr::EagerAmpAutoCast("boxes", boxes, amp_dst_dtype, op_name);
    auto NEW_boxes_num = egr::EagerAmpAutoCast("boxes_num", boxes_num, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return roi_align_final_state_dygraph_function(NEW_x, NEW_boxes, NEW_boxes_num, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "roi_align_final_state_dygraph_function";
  auto api_result = paddle::experimental::roi_align(x, boxes, boxes_num, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roi_align", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("roi_align node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RoiAlignGradNodeFinal>(new RoiAlignGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributepooled_height(pooled_height);
    grad_node->SetAttributepooled_width(pooled_width);
    grad_node->SetAttributespatial_scale(spatial_scale);
    grad_node->SetAttributesampling_ratio(sampling_ratio);
    grad_node->SetAttributealigned(aligned);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperboxes(boxes);
    if(boxes_num) grad_node->SetTensorWrapperboxes_num(*boxes_num);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor roi_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, float spatial_scale) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("roi_pool dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("roi_pool");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{boxes} };
    if (boxes_num) amp_tensors_vector.push_back({ *boxes_num });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_boxes = egr::EagerAmpAutoCast("boxes", boxes, amp_dst_dtype, op_name);
    auto NEW_boxes_num = egr::EagerAmpAutoCast("boxes_num", boxes_num, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return roi_pool_final_state_dygraph_function(NEW_x, NEW_boxes, NEW_boxes_num, pooled_height, pooled_width, spatial_scale);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "roi_pool_final_state_dygraph_function";
  auto api_result = paddle::experimental::roi_pool_intermediate(x, boxes, boxes_num, pooled_height, pooled_width, spatial_scale);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roi_pool_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& arg_max = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* arg_max_autograd_meta = egr::EagerUtils::autograd_meta(&arg_max);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("roi_pool node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,arg_max_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RoiPoolGradNodeFinal>(new RoiPoolGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributepooled_height(pooled_height);
    grad_node->SetAttributepooled_width(pooled_width);
    grad_node->SetAttributespatial_scale(spatial_scale);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperboxes(boxes);
    if(boxes_num) grad_node->SetTensorWrapperboxes_num(*boxes_num);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (arg_max_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(arg_max_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (arg_max_autograd_meta) {
      egr::EagerUtils::SetHistory(arg_max_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(arg_max, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(arg_max);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperarg_max(arg_max);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor roll_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shifts, std::vector<int64_t> axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("roll dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("roll");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return roll_final_state_dygraph_function(NEW_x, shifts, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "roll_final_state_dygraph_function";
  auto api_result = paddle::experimental::roll(x, shifts, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roll", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("roll node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RollGradNodeFinal>(new RollGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeshifts(shifts);
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor round_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("round dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("round");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return round_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "round_final_state_dygraph_function";
  auto api_result = paddle::experimental::round(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("round", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("round node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RoundGradNodeFinal>(new RoundGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor rsqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("rsqrt dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("rsqrt");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return rsqrt_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "rsqrt_final_state_dygraph_function";
  auto api_result = paddle::experimental::rsqrt(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("rsqrt", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("rsqrt node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RsqrtGradNodeFinal>(new RsqrtGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}

paddle::experimental::Tensor& rsqrt__final_state_dygraph_function(paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("rsqrt_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "rsqrt__final_state_dygraph_function";
  auto& api_result = paddle::experimental::rsqrt_(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("rsqrt_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("rsqrt node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<RsqrtGradNodeFinal>(new RsqrtGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor scale_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar scale, float bias, bool bias_after_scale) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("scale dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("scale");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return scale_final_state_dygraph_function(NEW_x, scale, bias, bias_after_scale);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "scale_final_state_dygraph_function";
  auto api_result = paddle::experimental::scale(x, scale, bias, bias_after_scale);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("scale node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ScaleGradNodeFinal>(new ScaleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributebias(bias);
    grad_node->SetAttributebias_after_scale(bias_after_scale);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}

paddle::experimental::Tensor& scale__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::Scalar scale, float bias, bool bias_after_scale) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("scale_ dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "scale__final_state_dygraph_function";
  auto& api_result = paddle::experimental::scale_(x, scale, bias, bias_after_scale);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale_", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  egr::EagerUtils::CheckInplace(x, x_autograd_meta, require_any_grad);

  // Bump Inplace Version
  x.bump_inplace_version();
  VLOG(3) << "Tensor(" << x.name() << ") uses Inplace Strategy.";

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("scale node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ScaleGradNodeFinal>(new ScaleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributebias(bias);
    grad_node->SetAttributebias_after_scale(bias_after_scale);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor scatter_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& updates, bool overwrite) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("scatter dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("scatter");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index},{updates} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    auto NEW_updates = egr::EagerAmpAutoCast("updates", updates, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return scatter_final_state_dygraph_function(NEW_x, NEW_index, NEW_updates, overwrite);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* updates_autograd_meta = egr::EagerUtils::nullable_autograd_meta(updates);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "scatter_final_state_dygraph_function";
  auto api_result = paddle::experimental::scatter(x, index, updates, overwrite);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scatter", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,updates_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("scatter node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ScatterGradNodeFinal>(new ScatterGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributeoverwrite(overwrite);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperindex(index);
    grad_node->SetTensorWrapperupdates(updates);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(updates, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor scatter_nd_add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& updates) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("scatter_nd_add dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("scatter_nd_add");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index},{updates} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    auto NEW_updates = egr::EagerAmpAutoCast("updates", updates, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return scatter_nd_add_final_state_dygraph_function(NEW_x, NEW_index, NEW_updates);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* updates_autograd_meta = egr::EagerUtils::nullable_autograd_meta(updates);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "scatter_nd_add_final_state_dygraph_function";
  auto api_result = paddle::experimental::scatter_nd_add(x, index, updates);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scatter_nd_add", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,updates_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("scatter_nd_add node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ScatterNdAddGradNodeFinal>(new ScatterNdAddGradNodeFinal(1, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperindex(index);
    grad_node->SetTensorWrapperupdates(updates);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(updates, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> segment_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& segment_ids, std::string pooltype) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("segment_pool dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("segment_pool");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{segment_ids} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_segment_ids = egr::EagerAmpAutoCast("segment_ids", segment_ids, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return segment_pool_final_state_dygraph_function(NEW_x, NEW_segment_ids, pooltype);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "segment_pool_final_state_dygraph_function";
  auto api_result = paddle::experimental::segment_pool(x, segment_ids, pooltype);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("segment_pool", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& summed_ids = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* summed_ids_autograd_meta = egr::EagerUtils::autograd_meta(&summed_ids);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("segment_pool node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,summed_ids_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SegmentPoolGradNodeFinal>(new SegmentPoolGradNodeFinal(2, 2));
    // SetAttributes if needed
    grad_node->SetAttributepooltype(pooltype);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappersegment_ids(segment_ids);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (summed_ids_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(summed_ids_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (summed_ids_autograd_meta) {
      egr::EagerUtils::SetHistory(summed_ids_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(summed_ids, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(summed_ids);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrappersummed_ids(summed_ids);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, summed_ids};
}


paddle::experimental::Tensor selu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scale, float alpha) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("selu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("selu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return selu_final_state_dygraph_function(NEW_x, scale, alpha);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "selu_final_state_dygraph_function";
  auto api_result = paddle::experimental::selu(x, scale, alpha);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("selu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("selu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SeluGradNodeFinal>(new SeluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor sigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sigmoid");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sigmoid_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sigmoid_final_state_dygraph_function";
  auto api_result = paddle::experimental::sigmoid(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SigmoidGradNodeFinal>(new SigmoidGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor sigmoid_cross_entropy_with_logits_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& label, bool normalize, int ignore_index) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sigmoid_cross_entropy_with_logits dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sigmoid_cross_entropy_with_logits");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{label} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_label = egr::EagerAmpAutoCast("label", label, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sigmoid_cross_entropy_with_logits_final_state_dygraph_function(NEW_x, NEW_label, normalize, ignore_index);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sigmoid_cross_entropy_with_logits_final_state_dygraph_function";
  auto api_result = paddle::experimental::sigmoid_cross_entropy_with_logits(x, label, normalize, ignore_index);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid_cross_entropy_with_logits", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid_cross_entropy_with_logits node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SigmoidCrossEntropyWithLogitsGradNodeFinal>(new SigmoidCrossEntropyWithLogitsGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributenormalize(normalize);
    grad_node->SetAttributeignore_index(ignore_index);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperlabel(label);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor silu_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("silu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("silu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return silu_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "silu_final_state_dygraph_function";
  auto api_result = paddle::experimental::silu(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("silu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("silu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SiluGradNodeFinal>(new SiluGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sin_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sin dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sin");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sin_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sin_final_state_dygraph_function";
  auto api_result = paddle::experimental::sin(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sin", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sin node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SinGradNodeFinal>(new SinGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sinh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sinh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sinh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sinh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sinh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sinh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sinh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sinh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SinhGradNodeFinal>(new SinhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor slice_final_state_dygraph_function(const paddle::experimental::Tensor& input, std::vector<int64_t> axes, paddle::experimental::IntArray starts, paddle::experimental::IntArray ends, std::vector<int64_t> infer_flags, std::vector<int64_t> decrease_axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("slice dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("slice");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return slice_final_state_dygraph_function(NEW_input, axes, starts, ends, infer_flags, decrease_axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "slice_final_state_dygraph_function";
  auto api_result = paddle::experimental::slice(input, axes, starts, ends, infer_flags, decrease_axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("slice", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("slice node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SliceGradNodeFinal>(new SliceGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    grad_node->SetAttributestarts(starts);
    grad_node->SetAttributeends(ends);
    grad_node->SetAttributeinfer_flags(infer_flags);
    grad_node->SetAttributedecrease_axis(decrease_axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor soft_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x, float lambda) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("soft_shrink dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("soft_shrink");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return soft_shrink_final_state_dygraph_function(NEW_x, lambda);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "soft_shrink_final_state_dygraph_function";
  auto api_result = paddle::experimental::soft_shrink(x, lambda);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("soft_shrink", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("soft_shrink node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SoftShrinkGradNodeFinal>(new SoftShrinkGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributelambda(lambda);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("softmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return softmax_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "softmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::softmax(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("softmax", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("softmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SoftmaxGradNodeFinal>(new SoftmaxGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


std::vector<paddle::experimental::Tensor> split_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray num_or_sections, paddle::experimental::Scalar axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("split dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("split");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return split_final_state_dygraph_function(NEW_x, num_or_sections, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "split_final_state_dygraph_function";
  auto api_result = paddle::experimental::split(x, num_or_sections, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("split", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  std::vector<egr::AutogradMeta*> out_autograd_meta_vec = egr::EagerUtils::autograd_meta(&out);
  std::vector<egr::AutogradMeta*>* out_autograd_meta = &out_autograd_meta_vec;
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("split node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SplitGradNodeFinal>(new SplitGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sqrt dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sqrt");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sqrt_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sqrt_final_state_dygraph_function";
  auto api_result = paddle::experimental::sqrt(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sqrt", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sqrt node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SqrtGradNodeFinal>(new SqrtGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor square_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("square dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("square");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return square_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "square_final_state_dygraph_function";
  auto api_result = paddle::experimental::square(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("square", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("square node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SquareGradNodeFinal>(new SquareGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor squeeze_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axes) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("squeeze dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("squeeze");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return squeeze_final_state_dygraph_function(NEW_x, axes);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "squeeze_final_state_dygraph_function";
  auto api_result = paddle::experimental::squeeze_intermediate(x, axes);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("squeeze_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("squeeze node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SqueezeGradNodeFinal>(new SqueezeGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor stack_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("stack dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("stack");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { x };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCasts("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return stack_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  std::vector<egr::AutogradMeta*> x_autograd_meta_vec = egr::EagerUtils::nullable_autograd_meta(x);
  std::vector<egr::AutogradMeta*>* x_autograd_meta = &x_autograd_meta_vec;
  // Forward API Call
  VLOG(3) << "Final State Running: " << "stack_final_state_dygraph_function";
  auto api_result = paddle::experimental::stack(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("stack", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("stack node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<StackGradNodeFinal>(new StackGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor strided_slice_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axes, paddle::experimental::IntArray starts, paddle::experimental::IntArray ends, paddle::experimental::IntArray strides) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("strided_slice dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("strided_slice");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return strided_slice_final_state_dygraph_function(NEW_x, axes, starts, ends, strides);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "strided_slice_final_state_dygraph_function";
  auto api_result = paddle::experimental::strided_slice(x, axes, starts, ends, strides);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("strided_slice", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("strided_slice node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<StridedSliceGradNodeFinal>(new StridedSliceGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    grad_node->SetAttributestarts(starts);
    grad_node->SetAttributeends(ends);
    grad_node->SetAttributestrides(strides);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor subtract_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("subtract dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("subtract");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return subtract_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "subtract_final_state_dygraph_function";
  auto api_result = paddle::experimental::subtract(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("subtract", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("subtract node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SubtractGradNodeFinal>(new SubtractGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sum_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, paddle::experimental::DataType out_dtype, bool keep_dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sum dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sum");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sum_final_state_dygraph_function(NEW_x, dims, out_dtype, keep_dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sum_final_state_dygraph_function";
  auto api_result = paddle::experimental::sum(x, dims, out_dtype, keep_dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sum", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sum node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SumGradNodeFinal>(new SumGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor swish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float beta) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("swish dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("swish");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return swish_final_state_dygraph_function(NEW_x, beta);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "swish_final_state_dygraph_function";
  auto api_result = paddle::experimental::swish(x, beta);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("swish", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("swish node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SwishGradNodeFinal>(new SwishGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributebete(1.0);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor take_along_axis_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("take_along_axis dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("take_along_axis");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{index} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_index = egr::EagerAmpAutoCast("index", index, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return take_along_axis_final_state_dygraph_function(NEW_x, NEW_index, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "take_along_axis_final_state_dygraph_function";
  auto api_result = paddle::experimental::take_along_axis(x, index, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("take_along_axis", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("take_along_axis node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TakeAlongAxisGradNodeFinal>(new TakeAlongAxisGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperindex(index);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor tan_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tan dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tan");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tan_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tan_final_state_dygraph_function";
  auto api_result = paddle::experimental::tan(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tan", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tan node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TanGradNodeFinal>(new TanGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor tanh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tanh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tanh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tanh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tanh_final_state_dygraph_function";
  auto api_result = paddle::experimental::tanh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tanh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TanhGradNodeFinal>(new TanhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor tanh_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tanh_shrink dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tanh_shrink");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tanh_shrink_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tanh_shrink_final_state_dygraph_function";
  auto api_result = paddle::experimental::tanh_shrink(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_shrink", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tanh_shrink node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TanhShrinkGradNodeFinal>(new TanhShrinkGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor thresholded_relu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("thresholded_relu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("thresholded_relu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return thresholded_relu_final_state_dygraph_function(NEW_x, threshold);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "thresholded_relu_final_state_dygraph_function";
  auto api_result = paddle::experimental::thresholded_relu(x, threshold);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("thresholded_relu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("thresholded_relu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ThresholdedReluGradNodeFinal>(new ThresholdedReluGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributethreshold(threshold);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor tile_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray repeat_times) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tile dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tile");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tile_final_state_dygraph_function(NEW_x, repeat_times);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tile_final_state_dygraph_function";
  auto api_result = paddle::experimental::tile(x, repeat_times);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tile", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tile node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TileGradNodeFinal>(new TileGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributerepeat_times(repeat_times);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> top_k_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar k, int axis, bool largest, bool sorted) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("top_k dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("top_k");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return top_k_final_state_dygraph_function(NEW_x, k, axis, largest, sorted);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "top_k_final_state_dygraph_function";
  auto api_result = paddle::experimental::top_k(x, k, axis, largest, sorted);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("top_k", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& indices = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* indices_autograd_meta = egr::EagerUtils::autograd_meta(&indices);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("top_k node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,indices_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TopKGradNodeFinal>(new TopKGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributek(k);
    grad_node->SetAttributeaxis(axis);
    grad_node->SetAttributelargest(largest);
    grad_node->SetAttributesorted(sorted);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(indices_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (indices_autograd_meta) {
      egr::EagerUtils::SetHistory(indices_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(indices, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(indices);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperindices(indices);
  }

  // Returns
  return std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor>{out, indices};
}


paddle::experimental::Tensor transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("transpose dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("transpose");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return transpose_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "transpose_final_state_dygraph_function";
  auto api_result = paddle::experimental::transpose(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("transpose", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("transpose node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TransposeGradNodeFinal>(new TransposeGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor triangular_solve_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool upper, bool tranpose, bool unitriangular) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("triangular_solve dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("triangular_solve");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return triangular_solve_final_state_dygraph_function(NEW_x, NEW_y, upper, tranpose, unitriangular);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "triangular_solve_final_state_dygraph_function";
  auto api_result = paddle::experimental::triangular_solve(x, y, upper, tranpose, unitriangular);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("triangular_solve", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("triangular_solve node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TriangularSolveGradNodeFinal>(new TriangularSolveGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeupper(upper);
    grad_node->SetAttributetranpose(tranpose);
    grad_node->SetAttributeunitriangular(unitriangular);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor tril_triu_final_state_dygraph_function(const paddle::experimental::Tensor& x, int diagonal, bool lower) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tril_triu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tril_triu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tril_triu_final_state_dygraph_function(NEW_x, diagonal, lower);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tril_triu_final_state_dygraph_function";
  auto api_result = paddle::experimental::tril_triu(x, diagonal, lower);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tril_triu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tril_triu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TrilTriuGradNodeFinal>(new TrilTriuGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributediagonal(diagonal);
    grad_node->SetAttributelower(lower);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


std::vector<paddle::experimental::Tensor> unbind_final_state_dygraph_function(const paddle::experimental::Tensor& input, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("unbind dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("unbind");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {input} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_input = egr::EagerAmpAutoCast("input", input, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unbind_final_state_dygraph_function(NEW_input, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* input_autograd_meta = egr::EagerUtils::nullable_autograd_meta(input);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "unbind_final_state_dygraph_function";
  auto api_result = paddle::experimental::unbind(input, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unbind", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  std::vector<egr::AutogradMeta*> out_autograd_meta_vec = egr::EagerUtils::autograd_meta(&out);
  std::vector<egr::AutogradMeta*>* out_autograd_meta = &out_autograd_meta_vec;
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,input_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("unbind node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<UnbindGradNodeFinal>(new UnbindGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor unfold_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_sizes, std::vector<int> strides, std::vector<int> paddings, std::vector<int> dilations) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("unfold dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("unfold");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unfold_final_state_dygraph_function(NEW_x, kernel_sizes, strides, paddings, dilations);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "unfold_final_state_dygraph_function";
  auto api_result = paddle::experimental::unfold(x, kernel_sizes, strides, paddings, dilations);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unfold", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("unfold node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<UnfoldGradNodeFinal>(new UnfoldGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_sizes(kernel_sizes);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributedilations(dilations);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor unsqueeze_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray axes) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("unsqueeze dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("unsqueeze");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unsqueeze_final_state_dygraph_function(NEW_x, axes);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "unsqueeze_final_state_dygraph_function";
  auto api_result = paddle::experimental::unsqueeze_intermediate(x, axes);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unsqueeze_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& xshape = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* xshape_autograd_meta = egr::EagerUtils::autograd_meta(&xshape);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("unsqueeze node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,xshape_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<UnsqueezeGradNodeFinal>(new UnsqueezeGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(xshape_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (xshape_autograd_meta) {
      egr::EagerUtils::SetHistory(xshape_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(xshape, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(xshape);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperxshape(xshape);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor where_final_state_dygraph_function(const paddle::experimental::Tensor& condition, const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("where dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("where");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {condition},{x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_condition = egr::EagerAmpAutoCast("condition", condition, amp_dst_dtype, op_name);
    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return where_final_state_dygraph_function(NEW_condition, NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "where_final_state_dygraph_function";
  auto api_result = paddle::experimental::where(condition, x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("where", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("where node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<WhereGradNodeFinal>(new WhereGradNodeFinal(1, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappercondition(condition);
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 1);
    grad_node->SetGradOutMeta(y, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}



namespace sparse {
    
paddle::experimental::Tensor abs_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("abs dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("abs");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return abs_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "abs_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::abs(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("abs", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("abs node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AbsGradNodeFinal>(new AbsGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor acos_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("acos dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("acos");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return acos_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "acos_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::acos(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acos", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("acos node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AcosGradNodeFinal>(new AcosGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor acosh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("acosh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("acosh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return acosh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "acosh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::acosh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acosh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("acosh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AcoshGradNodeFinal>(new AcoshGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("add dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("add");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return add_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "add_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::add(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("add node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AddGradNodeFinal>(new AddGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor asin_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("asin dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("asin");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return asin_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "asin_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::asin(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asin", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("asin node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AsinGradNodeFinal>(new AsinGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor asinh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("asinh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("asinh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return asinh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "asinh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::asinh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asinh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("asinh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AsinhGradNodeFinal>(new AsinhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor atan_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("atan dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("atan");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atan_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "atan_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::atan(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("atan node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AtanGradNodeFinal>(new AtanGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor atanh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("atanh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("atanh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atanh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "atanh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::atanh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atanh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("atanh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<AtanhGradNodeFinal>(new AtanhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor cast_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::DataType index_dtype, paddle::experimental::DataType value_dtype) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("cast dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "cast_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::cast(x, index_dtype, value_dtype);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cast", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("cast node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CastGradNodeFinal>(new CastGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributevalue_dtype(value_dtype);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor conv3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& kernel, std::vector<int> paddings, std::vector<int> dilations, std::vector<int> strides, int groups, bool subm) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("conv3d dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("conv3d");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{kernel} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_kernel = egr::EagerAmpAutoCast("kernel", kernel, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv3d_final_state_dygraph_function(NEW_x, NEW_kernel, paddings, dilations, strides, groups, subm);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* kernel_autograd_meta = egr::EagerUtils::nullable_autograd_meta(kernel);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "conv3d_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::conv3d_intermediate(x, kernel, paddings, dilations, strides, groups, subm);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& rulebook = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* rulebook_autograd_meta = egr::EagerUtils::autograd_meta(&rulebook);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,kernel_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("conv3d node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,rulebook_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv3dGradNodeFinal>(new Conv3dGradNodeFinal(2, 2));
    // SetAttributes if needed
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributesubm(subm);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperkernel(kernel);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(kernel, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (rulebook_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(rulebook_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (rulebook_autograd_meta) {
      egr::EagerUtils::SetHistory(rulebook_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(rulebook, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(rulebook);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperrulebook(rulebook);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor coo_to_dense_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("coo_to_dense dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("coo_to_dense");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return coo_to_dense_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "coo_to_dense_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::coo_to_dense(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("coo_to_dense", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("coo_to_dense node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CooToDenseGradNodeFinal>(new CooToDenseGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor create_sparse_coo_tensor_final_state_dygraph_function(const paddle::experimental::Tensor& values, const paddle::experimental::Tensor& indices, paddle::experimental::IntArray dense_shape) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("create_sparse_coo_tensor dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("create_sparse_coo_tensor");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {values},{indices} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_values = egr::EagerAmpAutoCast("values", values, amp_dst_dtype, op_name);
    auto NEW_indices = egr::EagerAmpAutoCast("indices", indices, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return create_sparse_coo_tensor_final_state_dygraph_function(NEW_values, NEW_indices, dense_shape);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* values_autograd_meta = egr::EagerUtils::nullable_autograd_meta(values);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "create_sparse_coo_tensor_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::create_sparse_coo_tensor(values, indices, dense_shape);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("create_sparse_coo_tensor", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,values_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("create_sparse_coo_tensor node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<CreateSparseCooTensorGradNodeFinal>(new CreateSparseCooTensorGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperindices(indices);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(values, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor dense_to_coo_final_state_dygraph_function(const paddle::experimental::Tensor& x, int64_t sparse_dim) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("dense_to_coo dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("dense_to_coo");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dense_to_coo_final_state_dygraph_function(NEW_x, sparse_dim);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "dense_to_coo_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::dense_to_coo(x, sparse_dim);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dense_to_coo", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("dense_to_coo node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DenseToCooGradNodeFinal>(new DenseToCooGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor divide_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("divide dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("divide");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return divide_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "divide_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::divide(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("divide node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DivideGradNodeFinal>(new DivideGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor divide_scalar_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scalar) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("divide_scalar dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("divide_scalar");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return divide_scalar_final_state_dygraph_function(NEW_x, scalar);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "divide_scalar_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::divide_scalar(x, scalar);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide_scalar", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("divide_scalar node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<DivideScalarGradNodeFinal>(new DivideScalarGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescalar(scalar);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor log1p_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("log1p dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("log1p");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log1p_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "log1p_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::log1p(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log1p", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("log1p node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<Log1pGradNodeFinal>(new Log1pGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor multiply_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("multiply dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("multiply");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multiply_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "multiply_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::multiply(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("multiply node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiplyGradNodeFinal>(new MultiplyGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, float factor) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("pow dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("pow");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pow_final_state_dygraph_function(NEW_x, factor);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "pow_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::pow(x, factor);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pow", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("pow node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<PowGradNodeFinal>(new PowGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributefactor(factor);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor relu_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("relu dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("relu");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return relu_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "relu_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::relu(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("relu node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ReluGradNodeFinal>(new ReluGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor scale_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scale, float bias, bool bias_after_scale) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("scale dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("scale");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return scale_final_state_dygraph_function(NEW_x, scale, bias, bias_after_scale);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "scale_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::scale(x, scale, bias, bias_after_scale);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("scale node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ScaleGradNodeFinal>(new ScaleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sin_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sin dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sin");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sin_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sin_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::sin(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sin", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sin node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SinGradNodeFinal>(new SinGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor sinh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sinh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sinh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sinh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sinh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::sinh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sinh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sinh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SinhGradNodeFinal>(new SinhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("softmax");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return softmax_final_state_dygraph_function(NEW_x, axis);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "softmax_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::softmax(x, axis);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("softmax", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("softmax node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SoftmaxGradNodeFinal>(new SoftmaxGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor sqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("sqrt dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("sqrt");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sqrt_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "sqrt_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::sqrt(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sqrt", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("sqrt node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SqrtGradNodeFinal>(new SqrtGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor square_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("square dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("square");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return square_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "square_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::square(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("square", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("square node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SquareGradNodeFinal>(new SquareGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor subtract_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("subtract dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("subtract");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return subtract_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "subtract_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::subtract(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("subtract", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("subtract node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SubtractGradNodeFinal>(new SubtractGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor tan_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tan dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tan");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tan_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tan_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::tan(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tan", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tan node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TanGradNodeFinal>(new TanGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor tanh_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("tanh dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("tanh");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tanh_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "tanh_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::tanh(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("tanh node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<TanhGradNodeFinal>(new TanhGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor values_final_state_dygraph_function(const paddle::experimental::Tensor& x) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("values dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("values");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return values_final_state_dygraph_function(NEW_x);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "values_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::values(x);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("values", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("values node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<ValuesGradNodeFinal>(new ValuesGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor fused_attention_final_state_dygraph_function(const paddle::experimental::Tensor& query, const paddle::experimental::Tensor& key, const paddle::experimental::Tensor& value, const paddle::experimental::Tensor& sparse_mask, const paddle::optional<paddle::experimental::Tensor>& key_padding_mask, const paddle::optional<paddle::experimental::Tensor>& attn_mask) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("fused_attention dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("fused_attention");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {query},{key},{value},{sparse_mask} };
    if (key_padding_mask) amp_tensors_vector.push_back({ *key_padding_mask });
if (attn_mask) amp_tensors_vector.push_back({ *attn_mask });

    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_query = egr::EagerAmpAutoCast("query", query, amp_dst_dtype, op_name);
    auto NEW_key = egr::EagerAmpAutoCast("key", key, amp_dst_dtype, op_name);
    auto NEW_value = egr::EagerAmpAutoCast("value", value, amp_dst_dtype, op_name);
    auto NEW_sparse_mask = egr::EagerAmpAutoCast("sparse_mask", sparse_mask, amp_dst_dtype, op_name);
    auto NEW_key_padding_mask = egr::EagerAmpAutoCast("key_padding_mask", key_padding_mask, amp_dst_dtype, op_name);
    auto NEW_attn_mask = egr::EagerAmpAutoCast("attn_mask", attn_mask, amp_dst_dtype, op_name);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fused_attention_final_state_dygraph_function(NEW_query, NEW_key, NEW_value, NEW_sparse_mask, NEW_key_padding_mask, NEW_attn_mask);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* query_autograd_meta = egr::EagerUtils::nullable_autograd_meta(query);
  egr::AutogradMeta* key_autograd_meta = egr::EagerUtils::nullable_autograd_meta(key);
  egr::AutogradMeta* value_autograd_meta = egr::EagerUtils::nullable_autograd_meta(value);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "fused_attention_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::fused_attention_intermediate(query, key, value, sparse_mask, key_padding_mask, attn_mask);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fused_attention_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& softmax = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* softmax_autograd_meta = egr::EagerUtils::autograd_meta(&softmax);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,query_autograd_meta,key_autograd_meta,value_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("fused_attention node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,softmax_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<FusedAttentionGradNodeFinal>(new FusedAttentionGradNodeFinal(2, 6));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperquery(query);
    grad_node->SetTensorWrapperkey(key);
    grad_node->SetTensorWrappervalue(value);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(query, 0);
    grad_node->SetGradOutMeta(key, 1);
    grad_node->SetGradOutMeta(value, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (softmax_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(softmax_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (softmax_autograd_meta) {
      egr::EagerUtils::SetHistory(softmax_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(softmax, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(softmax);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappersoftmax(softmax);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor masked_matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, const paddle::experimental::Tensor& mask) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("masked_matmul dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("masked_matmul");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y},{mask} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    auto NEW_mask = egr::EagerAmpAutoCast("mask", mask, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return masked_matmul_final_state_dygraph_function(NEW_x, NEW_y, NEW_mask);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "masked_matmul_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::masked_matmul(x, y, mask);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("masked_matmul", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("masked_matmul node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MaskedMatmulGradNodeFinal>(new MaskedMatmulGradNodeFinal(1, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("matmul dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("matmul");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{y} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_y = egr::EagerAmpAutoCast("y", y, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return matmul_final_state_dygraph_function(NEW_x, NEW_y);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* y_autograd_meta = egr::EagerUtils::nullable_autograd_meta(y);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "matmul_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::matmul(x, y);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,y_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("matmul node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MatmulGradNodeFinal>(new MatmulGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


paddle::experimental::Tensor maxpool_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_sizes, std::vector<int> paddings, std::vector<int> dilations, std::vector<int> strides) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("maxpool dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("maxpool");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return maxpool_final_state_dygraph_function(NEW_x, kernel_sizes, paddings, dilations, strides);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "maxpool_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::maxpool_intermediate(x, kernel_sizes, paddings, dilations, strides);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("maxpool_intermediate", api_result); }

  // Get Outputs
  auto& out = std::get<0>(api_result);
  auto& rulebook = std::get<1>(api_result);

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  egr::AutogradMeta* rulebook_autograd_meta = egr::EagerUtils::autograd_meta(&rulebook);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("maxpool node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta,rulebook_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<SparseMaxpoolGradNodeFinal>(new SparseMaxpoolGradNodeFinal(2, 1));
    // SetAttributes if needed
    grad_node->SetAttributekernel_sizes(kernel_sizes);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (rulebook_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(rulebook_autograd_meta, 1);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    if (rulebook_autograd_meta) {
      egr::EagerUtils::SetHistory(rulebook_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    grad_node->SetGradInMeta(rulebook, 1);
    egr::EagerUtils::CheckAndRetainGrad(out);
    egr::EagerUtils::CheckAndRetainGrad(rulebook);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrapperrulebook(rulebook);
    grad_node->SetTensorWrapperout(out);
  }

  // Returns
  return out;
}


paddle::experimental::Tensor mv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& vec) {
  // Dygraph Record Event
  paddle::platform::RecordEvent dygraph_entrance_record_event("mv dygraph", paddle::platform::TracerEventType::Operator, 1);

  // AMP Logic
  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
    auto op_name = phi::TransToFluidOpName("mv");
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {x},{vec} };
    
    auto amp_dst_dtype = egr::GetAmpDestDtype(op_name, amp_tensors_vector);

    auto NEW_x = egr::EagerAmpAutoCast("x", x, amp_dst_dtype, op_name);
    auto NEW_vec = egr::EagerAmpAutoCast("vec", vec, amp_dst_dtype, op_name);
    
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mv_final_state_dygraph_function(NEW_x, NEW_vec);
    }
  }

  // Get Input AutoGradMeta
  egr::AutogradMeta* x_autograd_meta = egr::EagerUtils::nullable_autograd_meta(x);
  egr::AutogradMeta* vec_autograd_meta = egr::EagerUtils::nullable_autograd_meta(vec);
  // Forward API Call
  VLOG(3) << "Final State Running: " << "mv_final_state_dygraph_function";
  auto api_result = paddle::experimental::sparse::mv(x, vec);
  // Check NaN and Inf if needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mv", api_result); }

  // Get Outputs
  auto& out = api_result;

  // Get Output AutoGradMeta
  egr::AutogradMeta* out_autograd_meta = egr::EagerUtils::autograd_meta(&out);
  bool trace_backward = egr::Controller::Instance().HasGrad();
  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward,x_autograd_meta,vec_autograd_meta);

  // Check Inplace if needed

  // Node Creation
  if(require_any_grad) {
    paddle::platform::RecordEvent node_creation_record_event("mv node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    egr::EagerUtils::PassStopGradient(false,out_autograd_meta);

    // Node Construction
    auto grad_node = std::shared_ptr<MvGradNodeFinal>(new MvGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappervec(vec);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(vec, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(out_autograd_meta, 0);
    }
    if (out_autograd_meta) {
      egr::EagerUtils::SetHistory(out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(out, 0);
    egr::EagerUtils::CheckAndRetainGrad(out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Returns
  return out;
}


}


