## PDSA-2023-004: FPE in paddle.linalg.matrix_power

### CVE编号

CVE-2023-38672

### 影响

当张量包含纬度值为0的情况，`paddle.linalg.matrix_power`会触发除0异常，导致程序运行时崩溃，PoC代码如下：

```python
import paddle
import numpy as np
from paddle.linalg import matrix_power

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 1, 0, 0]).astype(np.float32))

matrix_power(x, -1)
```

### 补丁

我们在commit [09926af166b060c9a9845c309110d3baa82921fd](https://github.com/PaddlePaddle/Paddle/commit/09926af166b060c9a9845c309110d3baa82921fd)中对此问题进行了补丁。
修复将包含在飞桨2.5.0版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Tong Liu of ShanghaiTech University 提交。
