
#include "paddle/phi/api/backward/backward_api.h"
#include <memory>

#include "glog/logging.h"

#include "paddle/phi/api/lib/api_custom_impl.h"
#include "paddle/phi/api/lib/api_gen_utils.h"
#include "paddle/phi/api/lib/data_transform.h"
#include "paddle/phi/api/lib/kernel_dispatch.h"
#include "paddle/phi/core/kernel_registry.h"
#include "paddle/phi/api/include/api.h"
#include "paddle/phi/infermeta/backward.h"
#include "paddle/phi/infermeta/unary.h"

#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"

DECLARE_bool(conv2d_disable_cudnn);

namespace paddle {
namespace experimental {


PADDLE_API void atan2_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "atan2_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "atan2_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "atan2_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("atan2_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void cholesky_grad(const Tensor& out, const Tensor& out_grad, bool upper, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cholesky_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cholesky_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cholesky_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cholesky_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, upper, kernel_out);
  }

  
}

PADDLE_API void cholesky_solve_grad(const Tensor& x, const Tensor& y, const Tensor& out, const Tensor& out_grad, bool upper, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cholesky_solve_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cholesky_solve_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cholesky_solve_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out = PrepareData(out, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cholesky_solve_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out, *input_out_grad, upper, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void cross_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cross_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cross_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cross_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cross_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void diag_grad(const Tensor& x, const Tensor& out_grad, int offset, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "diag_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "diag_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "diag_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("diag_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, offset, kernel_out);
  }

  
}

PADDLE_API void diagonal_grad(const Tensor& x, const Tensor& out_grad, int offset, int axis1, int axis2, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "diagonal_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "diagonal_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "diagonal_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, int, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("diagonal_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, offset, axis1, axis2, kernel_out);
  }

  
}

PADDLE_API void digamma_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "digamma_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "digamma_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "digamma_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("digamma_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void dist_grad(const Tensor& x, const Tensor& y, const Tensor& out, const Tensor& out_grad, float p, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "dist_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "dist_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "dist_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out = PrepareData(out, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("dist_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out, *input_out_grad, p, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void dot_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "dot_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "dot_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "dot_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("dot_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void erf_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "erf_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "erf_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "erf_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("erf_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void mv_grad(const Tensor& x, const Tensor& vec, const Tensor& out_grad, Tensor* x_grad, Tensor* vec_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, vec, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "mv_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "mv_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "mv_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_vec = PrepareData(vec, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, vec_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_vec), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("mv_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_vec, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void poisson_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "poisson_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "poisson_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "poisson_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("poisson_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void trace_grad(const Tensor& x, const Tensor& out_grad, int offset, int axis1, int axis2, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "trace_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "trace_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "trace_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, int, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("trace_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, offset, axis1, axis2, kernel_out);
  }

  
}

PADDLE_API void trunc_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "trunc_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "trunc_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "trunc_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("trunc_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void abs_double_grad(const Tensor& x, const Tensor& grad_x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "abs_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "abs_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "abs_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {true});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(1), {true});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("abs_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_x_grad, kernel_out);
  }

  
}

PADDLE_API void abs_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "abs_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "abs_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "abs_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {true});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("abs_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void acos_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "acos_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "acos_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "acos_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("acos_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void acosh_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "acosh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "acosh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "acosh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("acosh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void add_double_grad(const Tensor& y, const Tensor& grad_out, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, int axis, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(y, grad_out, grad_x_grad, grad_y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "add_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "add_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "add_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_y = PrepareData(y, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(3), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("add_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_y, *input_grad_out, input_grad_x_grad, input_grad_y_grad, axis, kernel_out);
  }

  
}

PADDLE_API void add_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "add_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "add_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "add_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("add_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void add_triple_grad(const Tensor& grad_grad_x, const Tensor& grad_grad_y, const Tensor& grad_grad_out_grad, int axis, Tensor* grad_grad_x_grad, Tensor* grad_grad_y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_grad_x, grad_grad_y, grad_grad_out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "add_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "add_triple_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "add_triple_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_grad_x = PrepareData(grad_grad_x, kernel.InputAt(0), {});
  auto input_grad_grad_y = PrepareData(grad_grad_y, kernel.InputAt(1), {});
  auto input_grad_grad_out_grad = PrepareData(grad_grad_out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, grad_grad_x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_grad_y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_grad_grad_x), MakeMetaTensor(*input_grad_grad_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("add_triple_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_grad_x, *input_grad_grad_y, *input_grad_grad_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void addmm_grad(const Tensor& input, const Tensor& x, const Tensor& y, const Tensor& out_grad, float alpha, float beta, Tensor* input_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "addmm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "addmm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "addmm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_x = PrepareData(x, kernel.InputAt(1), {});
  auto input_y = PrepareData(y, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("addmm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_x, *input_y, *input_out_grad, alpha, beta, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void argsort_grad(const Tensor& indices, const Tensor& x, const Tensor& out_grad, int axis, bool descending, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(indices, x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "argsort_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "argsort_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "argsort_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_indices = PrepareData(indices, kernel.InputAt(0), {});
  auto input_x = PrepareData(x, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("argsort_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_indices, *input_x, *input_out_grad, axis, descending, kernel_out);
  }

  
}

PADDLE_API void asin_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "asin_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "asin_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "asin_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("asin_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void asinh_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "asinh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "asinh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "asinh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("asinh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void assign_double_grad(const Tensor& grad_x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "assign_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "assign", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "assign kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_x_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("assign compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, kernel_out);
  }

  
}

PADDLE_API void assign_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "assign_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "assign", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "assign kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("assign compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void assign_out__grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "assign_out__grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "assign", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "assign kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("assign compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void assign_triple_grad(const Tensor& grad_x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "assign_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "assign", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "assign kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_x_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("assign compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, kernel_out);
  }

  
}

PADDLE_API void atan_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "atan_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "atan_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "atan_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("atan_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void atanh_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "atanh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "atanh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "atanh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("atanh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void batch_norm_double_grad(const Tensor& x, const Tensor& scale, const paddle::optional<Tensor>& out_mean, const paddle::optional<Tensor>& out_variance, const Tensor& saved_mean, const Tensor& saved_variance, const Tensor& grad_out, const Tensor& grad_x_grad, const Tensor& grad_scale_grad, const Tensor& grad_bias_grad, float momentum, float epsilon, const std::string& data_layout, bool is_test, bool use_global_stats, bool trainable_statistics, bool fuse_with_relu, Tensor* x_grad, Tensor* scale_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, scale, out_mean, out_variance, saved_mean, saved_variance, grad_out, grad_x_grad, grad_scale_grad, grad_bias_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "batch_norm_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "batch_norm_grad_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "batch_norm_grad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_scale = PrepareData(scale, kernel.InputAt(1), {});
  auto input_out_mean = PrepareData(out_mean, kernel.InputAt(2), {});
  auto input_out_variance = PrepareData(out_variance, kernel.InputAt(3), {});
  auto input_saved_mean = PrepareData(saved_mean, kernel.InputAt(4), {});
  auto input_saved_variance = PrepareData(saved_variance, kernel.InputAt(5), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(6), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(7), {});
  auto input_grad_scale_grad = PrepareData(grad_scale_grad, kernel.InputAt(8), {});
  auto input_grad_bias_grad = PrepareData(grad_bias_grad, kernel.InputAt(9), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_scale), MakeMetaTensor(*input_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, const std::string&, bool, bool, bool, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("batch_norm_grad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_scale, input_out_mean, input_out_variance, *input_saved_mean, *input_saved_variance, *input_grad_out, *input_grad_x_grad, *input_grad_scale_grad, *input_grad_bias_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void batch_norm_grad(const Tensor& x, const Tensor& scale, const Tensor& bias, const paddle::optional<Tensor>& mean_out, const paddle::optional<Tensor>& variance_out, const Tensor& saved_mean, const Tensor& saved_variance, const paddle::optional<Tensor>& reserve_space, const Tensor& out_grad, float momentum, float epsilon, const std::string& data_layout, bool is_test, bool use_global_stats, bool trainable_statistics, bool fuse_with_relu, Tensor* x_grad, Tensor* scale_grad, Tensor* bias_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, scale, bias, mean_out, variance_out, saved_mean, saved_variance, reserve_space, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "batch_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "batch_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "batch_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_scale = PrepareData(scale, kernel.InputAt(1), {});
  auto input_bias = PrepareData(bias, kernel.InputAt(2), {});
  auto input_mean_out = PrepareData(mean_out, kernel.InputAt(3), {});
  auto input_variance_out = PrepareData(variance_out, kernel.InputAt(4), {});
  auto input_saved_mean = PrepareData(saved_mean, kernel.InputAt(5), {});
  auto input_saved_variance = PrepareData(saved_variance, kernel.InputAt(6), {});
  auto input_reserve_space = PrepareData(reserve_space, kernel.InputAt(7), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(8), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, bias_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_scale), MakeMetaTensor(*input_bias), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, float, float, const std::string&, bool, bool, bool, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("batch_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_scale, *input_bias, input_mean_out, input_variance_out, *input_saved_mean, *input_saved_variance, input_reserve_space, *input_out_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void bce_loss_grad(const Tensor& input, const Tensor& label, const Tensor& out_grad, Tensor* input_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, label, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "bce_loss_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "bce_loss_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "bce_loss_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_label = PrepareData(label, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, input_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_input), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("bce_loss_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_label, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void brelu_grad(const Tensor& x, const Tensor& out_grad, float t_min, float t_max, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "brelu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "brelu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "brelu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("brelu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, t_min, t_max, kernel_out);
  }

  
}

PADDLE_API void cast_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cast_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cast_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cast_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cast_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void ceil_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "ceil_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "ceil_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "ceil_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("ceil_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void celu_double_grad(const Tensor& x, const Tensor& grad_out, const Tensor& grad_x_grad, float alpha, Tensor* x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "celu_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "celu_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "celu_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("celu_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_out, *input_grad_x_grad, alpha, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void celu_grad(const Tensor& x, const Tensor& out_grad, float alpha, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "celu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "celu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "celu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("celu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, alpha, kernel_out);
  }

  
}

PADDLE_API void clip_double_grad(const Tensor& x, const Tensor& grad_x_grad, const Scalar& min, const Scalar& max, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "clip_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "clip_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "clip_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::Scalar&, const phi::Scalar&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("clip_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_x_grad, phi::Scalar(min), phi::Scalar(max), kernel_out);
  }

  
}

PADDLE_API void clip_grad(const Tensor& x, const Tensor& out_grad, const Scalar& min, const Scalar& max, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "clip_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "clip_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "clip_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::Scalar&, const phi::Scalar&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("clip_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::Scalar(min), phi::Scalar(max), kernel_out);
  }

  
}

PADDLE_API void complex_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "complex_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "complex_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "complex_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ComplexGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), MakeMetaTensor(*input_out_grad), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("complex_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void concat_double_grad(const std::vector<Tensor>& grad_x_grad, const Scalar& axis, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "concat_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "concat", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "concat kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad_vec = PrepareData(grad_x_grad, kernel.InputAt(0), {});
  std::vector<const phi::DenseTensor*> input_grad_x_grad(input_grad_x_grad_vec->size());
  for (size_t i = 0; i < input_grad_x_grad.size(); ++i) {
    input_grad_x_grad[i] = &input_grad_x_grad_vec->at(i);
  }

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);

  auto grad_x_grad_meta_vec = MakeMetaTensor(input_grad_x_grad);
  std::vector<const phi::MetaTensor*> grad_x_grad_metas(grad_x_grad_meta_vec.size());
  for (size_t i = 0; i < grad_x_grad_meta_vec.size(); ++i) {
    grad_x_grad_metas[i] = &grad_x_grad_meta_vec[i];
  }
  phi::MetaTensor meta_out(kernel_out);

  phi::ConcatInferMeta(grad_x_grad_metas, axis, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const std::vector<const phi::DenseTensor*>&, const phi::Scalar&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("concat compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, input_grad_x_grad, phi::Scalar(axis), kernel_out);
  }

  
}

PADDLE_API void concat_grad(const std::vector<Tensor>& x, const Tensor& out_grad, const Scalar& axis, std::vector<Tensor*> x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "concat_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "concat_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "concat_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x_vec = PrepareData(x, kernel.InputAt(0), {});
  std::vector<const phi::DenseTensor*> input_x(input_x_vec->size());
  for (size_t i = 0; i < input_x.size(); ++i) {
    input_x[i] = &input_x_vec->at(i);
  }
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(&x_grad);

  auto x_meta_vec = MakeMetaTensor(input_x);
  std::vector<const phi::MetaTensor*> x_metas(x_meta_vec.size());
  for (size_t i = 0; i < x_meta_vec.size(); ++i) {
    x_metas[i] = &x_meta_vec[i];
  }

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::UnchangedMultiInferMeta(x_metas, kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const std::vector<const phi::DenseTensor*>&, const phi::DenseTensor&, const phi::Scalar&, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("concat_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, input_x, *input_out_grad, phi::Scalar(axis), kernel_out);
  }

  
}

PADDLE_API void conj_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conj_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conj", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "conj kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conj compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void conv2d_grad(const Tensor& input, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, Tensor* input_grad, Tensor* filter_grad) {
  conv2d_grad_impl(input, filter, out_grad,  strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, input_grad, filter_grad);
}
PADDLE_API void conv2d_grad_grad(const Tensor& input, const Tensor& filter, const Tensor& grad_out, const paddle::optional<Tensor>& grad_input_grad, const paddle::optional<Tensor>& grad_filter_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, Tensor* input_grad, Tensor* filter_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, filter, grad_out, grad_input_grad, grad_filter_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conv2d_grad_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conv2d_grad_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "conv2d_grad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_input_grad = PrepareData(grad_input_grad, kernel.InputAt(3), {});
  auto input_grad_filter_grad = PrepareData(grad_filter_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, bool, int, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conv2d_grad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_filter, *input_grad_out, input_grad_input_grad, input_grad_filter_grad, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void conv2d_transpose_double_grad(const Tensor& x, const Tensor& filter, const Tensor& grad_out, const Tensor& grad_x_grad, const Tensor& grad_filter_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& output_padding, const std::vector<int>& output_size, const std::string& padding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, Tensor* x_grad, Tensor* filter_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, filter, grad_out, grad_x_grad, grad_filter_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conv2d_transpose_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conv2d_transpose_grad_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "conv2d_transpose_grad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(3), {});
  auto input_grad_filter_grad = PrepareData(grad_filter_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::Conv2dTransposeDoubleGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_grad_out), MakeMetaTensor(*input_grad_x_grad), MakeMetaTensor(*input_grad_filter_grad), strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conv2d_transpose_grad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_filter, *input_grad_out, *input_grad_x_grad, *input_grad_filter_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void conv2d_transpose_grad(const Tensor& x, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& output_padding, const std::vector<int>& output_size, const std::string& padding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, Tensor* x_grad, Tensor* filter_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, filter, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conv2d_transpose_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conv2d_transpose_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "conv2d_transpose_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ConvTransposeGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_out_grad), strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conv2d_transpose_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_filter, *input_out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void conv3d_grad(const Tensor& input, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, Tensor* input_grad, Tensor* filter_grad) {
  conv3d_grad_impl(input, filter, out_grad,  strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, input_grad, filter_grad);
}
PADDLE_API void conv3d_grad_grad(const Tensor& input, const Tensor& filter, const Tensor& grad_out, const paddle::optional<Tensor>& grad_input_grad, const paddle::optional<Tensor>& grad_filter_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, Tensor* input_grad, Tensor* filter_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, filter, grad_out, grad_input_grad, grad_filter_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conv3d_grad_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conv3d_grad_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "conv3d_grad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_input_grad = PrepareData(grad_input_grad, kernel.InputAt(3), {});
  auto input_grad_filter_grad = PrepareData(grad_filter_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, bool, int, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conv3d_grad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_filter, *input_grad_out, input_grad_input_grad, input_grad_filter_grad, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void conv3d_transpose_grad(const Tensor& x, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& output_padding, const std::vector<int>& output_size, const std::string& padding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, Tensor* x_grad, Tensor* filter_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, filter, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "conv3d_transpose_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "conv3d_transpose_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "conv3d_transpose_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ConvTransposeGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_out_grad), strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("conv3d_transpose_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_filter, *input_out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void cos_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cos_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cos_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cos_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cos_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void cosh_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cosh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cosh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cosh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cosh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void cross_entropy_with_softmax_grad(const Tensor& label, const Tensor& softmax, const Tensor& loss_grad, bool soft_label, bool use_softmax, bool numeric_stable_mode, int ignore_index, int axis, Tensor* input_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(softmax);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(label, softmax, loss_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cross_entropy_with_softmax_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cross_entropy_with_softmax_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cross_entropy_with_softmax_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_label = PrepareData(label, kernel.InputAt(0), {});
  auto input_softmax = PrepareData(softmax, kernel.InputAt(1), {});
  auto input_loss_grad = PrepareData(loss_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, input_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::CrossEntropyWithSoftmaxGradInferMeta(MakeMetaTensor(*input_label), MakeMetaTensor(*input_softmax), MakeMetaTensor(*input_loss_grad), soft_label, use_softmax, numeric_stable_mode, ignore_index, axis, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, bool, bool, int, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cross_entropy_with_softmax_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_label, *input_softmax, *input_loss_grad, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis, kernel_out);
  }

  
}

PADDLE_API void cumprod_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, int dim, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "cumprod_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "cumprod_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "cumprod_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("cumprod_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, dim, kernel_out);
  }

  
}

PADDLE_API void cumsum_grad(const Tensor& out_grad, int axis, bool flatten, bool exclusive, bool reverse, Tensor* x_grad) {
  *x_grad = cumsum(out_grad, axis, flatten, exclusive, !reverse);
}
PADDLE_API void deformable_conv_grad(const Tensor& x, const Tensor& offset, const Tensor& filter, const paddle::optional<Tensor>& mask, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& dilations, int deformable_groups, int groups, int im2col_step, Tensor* x_grad, Tensor* offset_grad, Tensor* filter_grad, Tensor* mask_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, offset, filter, mask, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "deformable_conv_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "deformable_conv_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "deformable_conv_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_offset = PrepareData(offset, kernel.InputAt(1), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(2), {});
  auto input_mask = PrepareData(mask, kernel.InputAt(3), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, offset_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, filter_grad);
  auto kernel_out_3 = SetKernelOutput(kernel_backend, mask_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);
  phi::MetaTensor meta_out_3(kernel_out_3);

  phi::DeformableConvGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_offset), MakeMetaTensor(*input_filter), MakeMetaTensor(input_mask), MakeMetaTensor(*input_out_grad), strides, paddings, dilations, deformable_groups, groups, im2col_step, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr, kernel_out_3 ? &meta_out_3 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, int, int, int, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("deformable_conv_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_offset, *input_filter, input_mask, *input_out_grad, strides, paddings, dilations, deformable_groups, groups, im2col_step, kernel_out_0, kernel_out_1, kernel_out_2, kernel_out_3);
  }

  
}

PADDLE_API void depthwise_conv2d_grad(const Tensor& input, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, bool fuse_relu, bool use_gpudnn, Tensor* input_grad, Tensor* filter_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, filter, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "depthwise_conv2d_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "depthwise_conv2d_grad", {kernel_backend, kernel_layout, kernel_data_type}, use_gpudnn);
  VLOG(6) << "depthwise_conv2d_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_filter), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, bool, int, bool, bool, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("depthwise_conv2d_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_filter, *input_out_grad, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void depthwise_conv2d_grad_grad(const Tensor& input, const Tensor& filter, const Tensor& grad_out, const paddle::optional<Tensor>& grad_input_grad, const paddle::optional<Tensor>& grad_filter_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::string& paddding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, bool fuse_relu, Tensor* input_grad, Tensor* filter_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, filter, grad_out, grad_input_grad, grad_filter_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "depthwise_conv2d_grad_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "depthwise_conv2d_grad_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "depthwise_conv2d_grad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_input_grad = PrepareData(grad_input_grad, kernel.InputAt(3), {});
  auto input_grad_filter_grad = PrepareData(grad_filter_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, bool, int, bool, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("depthwise_conv2d_grad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_filter, *input_grad_out, input_grad_input_grad, input_grad_filter_grad, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void depthwise_conv2d_transpose_grad(const Tensor& x, const Tensor& filter, const Tensor& out_grad, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& output_padding, const std::vector<int>& output_size, const std::string& padding_algorithm, int groups, const std::vector<int>& dilations, const std::string& data_format, Tensor* x_grad, Tensor* filter_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, filter, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "depthwise_conv2d_transpose_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "depthwise_conv2d_transpose_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "depthwise_conv2d_transpose_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_filter = PrepareData(filter, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, filter_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ConvTransposeGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_filter), MakeMetaTensor(*input_out_grad), strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::string&, int, const std::vector<int>&, const std::string&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("depthwise_conv2d_transpose_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_filter, *input_out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void det_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "det_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "determinant_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "determinant_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("determinant_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void divide_double_grad(const Tensor& y, const Tensor& out, const Tensor& grad_x, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, int axis, Tensor* y_grad, Tensor* out_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(y, out, grad_x, grad_x_grad, grad_y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "divide_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "divide_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "divide_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_y = PrepareData(y, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_grad_x = PrepareData(grad_x, kernel.InputAt(2), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(3), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, y_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_y), MakeMetaTensor(*input_grad_x), MakeMetaTensor(*input_grad_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, int, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("divide_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_y, *input_out, *input_grad_x, input_grad_x_grad, input_grad_y_grad, axis, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void divide_grad(const Tensor& x, const Tensor& y, const Tensor& out, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "divide_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "divide_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "divide_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out = PrepareData(out, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("divide_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void dropout_grad(const Tensor& mask, const Tensor& out_grad, float p, bool is_test, const std::string& mode, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(mask, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "dropout_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "dropout_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "dropout_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_mask = PrepareData(mask, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, bool, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("dropout_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_mask, *input_out_grad, p, is_test, mode, kernel_out);
  }

  
}

PADDLE_API void eigh_grad(const Tensor& out_w, const Tensor& out_v, const Tensor& out_w_grad, const Tensor& out_v_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_v);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_w, out_v, out_w_grad, out_v_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "eigh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "eigh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "eigh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_w = PrepareData(out_w, kernel.InputAt(0), {true});
  auto input_out_v = PrepareData(out_v, kernel.InputAt(1), {});
  auto input_out_w_grad = PrepareData(out_w_grad, kernel.InputAt(2), {true});
  auto input_out_v_grad = PrepareData(out_v_grad, kernel.InputAt(3), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_v), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("eigh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_w, *input_out_v, *input_out_w_grad, *input_out_v_grad, kernel_out);
  }

  
}

PADDLE_API void einsum_grad(const std::vector<Tensor>& x_shape, const std::vector<Tensor>& inner_cache, const Tensor& out_grad, const std::string& equation, std::vector<Tensor*> x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x_shape, inner_cache, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "einsum_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "einsum_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "einsum_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x_shape_vec = PrepareData(x_shape, kernel.InputAt(0), {});
  std::vector<const phi::DenseTensor*> input_x_shape(input_x_shape_vec->size());
  for (size_t i = 0; i < input_x_shape.size(); ++i) {
    input_x_shape[i] = &input_x_shape_vec->at(i);
  }
  auto input_inner_cache_vec = PrepareData(inner_cache, kernel.InputAt(1), {});
  std::vector<const phi::DenseTensor*> input_inner_cache(input_inner_cache_vec->size());
  for (size_t i = 0; i < input_inner_cache.size(); ++i) {
    input_inner_cache[i] = &input_inner_cache_vec->at(i);
  }
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(&x_grad);

  auto x_shape_meta_vec = MakeMetaTensor(input_x_shape);
  std::vector<const phi::MetaTensor*> x_shape_metas(x_shape_meta_vec.size());
  for (size_t i = 0; i < x_shape_meta_vec.size(); ++i) {
    x_shape_metas[i] = &x_shape_meta_vec[i];
  }

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::UnchangedMultiInferMeta(x_shape_metas, kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const std::vector<const phi::DenseTensor*>&, const std::vector<const phi::DenseTensor*>&, const phi::DenseTensor&, const std::string&, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("einsum_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, input_x_shape, input_inner_cache, *input_out_grad, equation, kernel_out);
  }

  
}

PADDLE_API void elementwise_pow_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "elementwise_pow_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "elementwise_pow_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "elementwise_pow_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("elementwise_pow_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void elu_double_grad(const Tensor& x, const Tensor& grad_out, const Tensor& grad_x_grad, float alpha, Tensor* x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "elu_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "elu_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "elu_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("elu_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_out, *input_grad_x_grad, alpha, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void elu_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, float alpha, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "elu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "elu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "elu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("elu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, alpha, kernel_out);
  }

  
}

PADDLE_API void embedding_grad(const Tensor& x, const Tensor& weight, const Tensor& out_grad, int64_t padding_idx, bool sparse, Tensor* weight_grad) {
  embedding_grad_impl(x, weight, out_grad, padding_idx, sparse, weight_grad);
}
PADDLE_API void erfinv_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "erfinv_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "erfinv_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "erfinv_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("erfinv_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void exp_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "exp_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "exp_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "exp_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("exp_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void expand_as_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int>& target_shape, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "expand_as_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "expand_as_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "expand_as_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("expand_as_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, target_shape, kernel_out);
  }

  
}

PADDLE_API void expand_double_grad(const Tensor& grad_x_grad, const IntArray& shape, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "expand_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "expand", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "expand kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::ExpandInferMeta(MakeMetaTensor(*input_grad_x_grad), shape, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::IntArray&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("expand compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, phi::IntArray(shape), kernel_out);
  }

  
}

PADDLE_API void expand_grad(const Tensor& x, const Tensor& out_grad, const IntArray& shape, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "expand_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "expand_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "expand_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::IntArray&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("expand_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::IntArray(shape), kernel_out);
  }

  
}

PADDLE_API void expm1_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "expm1_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "expm1_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "expm1_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("expm1_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void flatten_grad(const Tensor& xshape, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_backend = ParseBackend(out_grad);

  kernel_layout = ParseLayout(out_grad);

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(xshape, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "flatten_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "flatten_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "flatten_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_xshape = PrepareData(xshape, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::KernelWithXShapeInferMeta(MakeMetaTensor(*input_xshape), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("flatten_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_xshape, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void flip_grad(const Tensor& out_grad, const std::vector<int>& axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "flip_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "flip", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "flip kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("flip compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void floor_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "floor_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "floor_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "floor_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("floor_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void fmax_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "fmax_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "fmax_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "fmax_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("fmax_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void fmin_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "fmin_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "fmin_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "fmin_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("fmin_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void frobenius_norm_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int64_t>& axis, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "frobenius_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "frobenius_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "frobenius_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("frobenius_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, axis, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void gather_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, const Scalar& axis, bool overwrite, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "gather_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "gather_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "gather_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::Scalar&, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("gather_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, phi::Scalar(axis), overwrite, kernel_out);
  }

  
}

PADDLE_API void gather_nd_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "gather_nd_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "gather_nd_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "gather_nd_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("gather_nd_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void gelu_grad(const Tensor& x, const Tensor& out_grad, bool approximate, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "gelu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "gelu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "gelu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("gelu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, approximate, kernel_out);
  }

  
}

PADDLE_API void graph_send_recv_grad(const Tensor& x, const Tensor& src_index, const Tensor& dst_index, const paddle::optional<Tensor>& out, const paddle::optional<Tensor>& dst_count, const Tensor& out_grad, const std::string& pool_type, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, src_index, dst_index, out, dst_count, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "graph_send_recv_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "graph_send_recv_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "graph_send_recv_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_src_index = PrepareData(src_index, kernel.InputAt(1), {});
  auto input_dst_index = PrepareData(dst_index, kernel.InputAt(2), {});
  auto input_out = PrepareData(out, kernel.InputAt(3), {});
  auto input_dst_count = PrepareData(dst_count, kernel.InputAt(4), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(5), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GeneralUnaryGradInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("graph_send_recv_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_src_index, *input_dst_index, input_out, input_dst_count, *input_out_grad, pool_type, kernel_out);
  }

  
}

PADDLE_API void group_norm_grad(const Tensor& x, const paddle::optional<Tensor>& scale, const paddle::optional<Tensor>& bias, const Tensor& y, const Tensor& mean, const Tensor& variance, const Tensor& y_grad, float epsilon, int groups, const std::string& data_layout, Tensor* x_grad, Tensor* scale_grad, Tensor* bias_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(y_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, scale, bias, y, mean, variance, y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "group_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "group_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "group_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_scale = PrepareData(scale, kernel.InputAt(1), {});
  auto input_bias = PrepareData(bias, kernel.InputAt(2), {});
  auto input_y = PrepareData(y, kernel.InputAt(3), {});
  auto input_mean = PrepareData(mean, kernel.InputAt(4), {});
  auto input_variance = PrepareData(variance, kernel.InputAt(5), {});
  auto input_y_grad = PrepareData(y_grad, kernel.InputAt(6), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, bias_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_y), MakeMetaTensor(input_scale), MakeMetaTensor(input_bias), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, int, const std::string&, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("group_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, input_scale, input_bias, *input_y, *input_mean, *input_variance, *input_y_grad, epsilon, groups, data_layout, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void gumbel_softmax_grad(const Tensor& out, const Tensor& out_grad, int axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "gumbel_softmax_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "gumbel_softmax_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "gumbel_softmax_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GumbelSoftmaxGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_out_grad), axis, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("gumbel_softmax_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void hard_shrink_grad(const Tensor& x, const Tensor& out_grad, float threshold, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "hard_shrink_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "hard_shrink_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "hard_shrink_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("hard_shrink_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, threshold, kernel_out);
  }

  
}

PADDLE_API void hard_sigmoid_grad(const Tensor& out, const Tensor& out_grad, float slope, float offset, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "hard_sigmoid_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "hard_sigmoid_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "hard_sigmoid_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("hard_sigmoid_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, slope, offset, kernel_out);
  }

  
}

PADDLE_API void hard_swish_grad(const Tensor& x, const Tensor& out_grad, float threshold, float scale, float offset, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "hard_swish_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "hard_swish_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "hard_swish_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("hard_swish_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, threshold, scale, offset, kernel_out);
  }

  
}

PADDLE_API void huber_loss_grad(const Tensor& residual, const Tensor& out_grad, float delta, Tensor* input_grad, Tensor* label_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(residual, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "huber_loss_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "huber_loss_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "huber_loss_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_residual = PrepareData(residual, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, input_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, label_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_residual), MakeMetaTensor(*input_residual), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("huber_loss_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_residual, *input_out_grad, delta, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void imag_grad(const Tensor& out_grad, Tensor* x_grad) {
  imag_grad_impl(out_grad, x_grad);
}
PADDLE_API void index_sample_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "index_sample_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "index_sample_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "index_sample_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("index_sample_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void index_select_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, int dim, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "index_select_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "index_select_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "index_select_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("index_select_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, dim, kernel_out);
  }

  
}

PADDLE_API void instance_norm_double_grad(const Tensor& x, const paddle::optional<Tensor>& fwd_scale, const Tensor& saved_mean, const Tensor& saved_variance, const Tensor& grad_y, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_scale_grad, const paddle::optional<Tensor>& grad_bias_grad, float epsilon, Tensor* x_grad, Tensor* fwd_scale_grad, Tensor* grad_y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, fwd_scale, saved_mean, saved_variance, grad_y, grad_x_grad, grad_scale_grad, grad_bias_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "instance_norm_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "instance_norm_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "instance_norm_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_fwd_scale = PrepareData(fwd_scale, kernel.InputAt(1), {});
  auto input_saved_mean = PrepareData(saved_mean, kernel.InputAt(2), {});
  auto input_saved_variance = PrepareData(saved_variance, kernel.InputAt(3), {});
  auto input_grad_y = PrepareData(grad_y, kernel.InputAt(4), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(5), {});
  auto input_grad_scale_grad = PrepareData(grad_scale_grad, kernel.InputAt(6), {});
  auto input_grad_bias_grad = PrepareData(grad_bias_grad, kernel.InputAt(7), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, fwd_scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::InstanceNormDoubleGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(input_fwd_scale), MakeMetaTensor(*input_saved_mean), MakeMetaTensor(*input_saved_variance), MakeMetaTensor(*input_grad_y), MakeMetaTensor(input_grad_x_grad), MakeMetaTensor(input_grad_scale_grad), MakeMetaTensor(input_grad_bias_grad), epsilon, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, float, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("instance_norm_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, input_fwd_scale, *input_saved_mean, *input_saved_variance, *input_grad_y, input_grad_x_grad, input_grad_scale_grad, input_grad_bias_grad, epsilon, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void instance_norm_grad(const Tensor& x, const paddle::optional<Tensor>& scale, const Tensor& saved_mean, const Tensor& saved_variance, const Tensor& y_grad, float epsilon, Tensor* x_grad, Tensor* scale_grad, Tensor* bias_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, scale, saved_mean, saved_variance, y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "instance_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "instance_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "instance_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_scale = PrepareData(scale, kernel.InputAt(1), {});
  auto input_saved_mean = PrepareData(saved_mean, kernel.InputAt(2), {});
  auto input_saved_variance = PrepareData(saved_variance, kernel.InputAt(3), {});
  auto input_y_grad = PrepareData(y_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, bias_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::InstanceNormGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(input_scale), MakeMetaTensor(*input_saved_mean), MakeMetaTensor(*input_saved_variance), MakeMetaTensor(*input_y_grad), epsilon, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("instance_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, input_scale, *input_saved_mean, *input_saved_variance, *input_y_grad, epsilon, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void kldiv_loss_grad(const Tensor& x, const Tensor& label, const Tensor& out_grad, const std::string& reduction, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, label, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "kldiv_loss_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "kldiv_loss_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "kldiv_loss_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_label = PrepareData(label, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("kldiv_loss_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_label, *input_out_grad, reduction, kernel_out);
  }

  
}

PADDLE_API void kron_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "kron_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "kron_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "kron_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("kron_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void kthvalue_grad(const Tensor& x, const Tensor& indices, const Tensor& out_grad, int k, int axis, bool keepdim, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, indices, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "kthvalue_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "kthvalue_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "kthvalue_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_indices = PrepareData(indices, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, int, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("kthvalue_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_indices, *input_out_grad, k, axis, keepdim, kernel_out);
  }

  
}

PADDLE_API void label_smooth_grad(const Tensor& out_grad, float epsilon, Tensor* label_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "label_smooth_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "label_smooth_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "label_smooth_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, label_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("label_smooth_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, epsilon, kernel_out);
  }

  
}

PADDLE_API void layer_norm_grad(const Tensor& x, const paddle::optional<Tensor>& scale, const paddle::optional<Tensor>& bias, const Tensor& mean, const Tensor& variance, const Tensor& out_grad, float epsilon, int begin_norm_axis, bool is_test, Tensor* x_grad, Tensor* scale_grad, Tensor* bias_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, scale, bias, mean, variance, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "layer_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "layer_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "layer_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_scale = PrepareData(scale, kernel.InputAt(1), {});
  auto input_bias = PrepareData(bias, kernel.InputAt(2), {});
  auto input_mean = PrepareData(mean, kernel.InputAt(3), {});
  auto input_variance = PrepareData(variance, kernel.InputAt(4), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(5), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, scale_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, bias_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::LayerNormGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(input_scale), MakeMetaTensor(input_bias), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, int, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("layer_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, input_scale, input_bias, *input_mean, *input_variance, *input_out_grad, epsilon, begin_norm_axis, is_test, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void leaky_relu_double_grad(const Tensor& x, const Tensor& grad_x_grad, float alpha, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "leaky_relu_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "leaky_relu_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "leaky_relu_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_x_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("leaky_relu_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_x_grad, alpha, kernel_out);
  }

  
}

PADDLE_API void leaky_relu_grad(const Tensor& x, const Tensor& out_grad, float alpha, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "leaky_relu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "leaky_relu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "leaky_relu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("leaky_relu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, alpha, kernel_out);
  }

  
}

PADDLE_API void lerp_grad(const Tensor& x, const Tensor& y, const Tensor& weight, const Tensor& out, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, weight, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "lerp_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "lerp_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "lerp_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_weight = PrepareData(weight, kernel.InputAt(2), {});
  auto input_out = PrepareData(out, kernel.InputAt(3), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("lerp_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_weight, *input_out, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void lgamma_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "lgamma_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "lgamma_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "lgamma_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("lgamma_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void log10_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log10_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log10_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log10_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log10_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void log1p_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log1p_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log1p_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log1p_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log1p_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void log2_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log2_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log2_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log2_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log2_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void log_double_grad(const Tensor& x, const Tensor& grad_out, const Tensor& grad_x_grad, Tensor* x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_out, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void log_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void log_loss_grad(const Tensor& input, const Tensor& label, const Tensor& out_grad, float epsilon, Tensor* input_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, label, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log_loss_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log_loss_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log_loss_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_label = PrepareData(label, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, input_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_input), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log_loss_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_label, *input_out_grad, epsilon, kernel_out);
  }

  
}

PADDLE_API void log_softmax_grad(const Tensor& out, const Tensor& out_grad, int axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "log_softmax_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "log_softmax_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "log_softmax_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("log_softmax_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void logcumsumexp_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, int axis, bool flatten, bool exclusive, bool reverse, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "logcumsumexp_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "logcumsumexp_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "logcumsumexp_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, bool, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("logcumsumexp_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, axis, flatten, exclusive, reverse, kernel_out);
  }

  
}

PADDLE_API void logit_grad(const Tensor& x, const Tensor& out_grad, float eps, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "logit_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "logit_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "logit_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("logit_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, eps, kernel_out);
  }

  
}

PADDLE_API void logsigmoid_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "logsigmoid_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "logsigmoid_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "logsigmoid_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("logsigmoid_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void logsumexp_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int64_t>& axis, bool keepdim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "logsumexp_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "logsumexp_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "logsumexp_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("logsumexp_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, axis, keepdim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void masked_select_grad(const Tensor& x, const Tensor& mask, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, mask, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "masked_select_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "masked_select_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "masked_select_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_mask = PrepareData(mask, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("masked_select_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_mask, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void matmul_double_grad(const Tensor& x, const Tensor& y, const Tensor& grad_out, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, bool transpose_x, bool transpose_y, Tensor* x_grad, Tensor* y_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, grad_out, grad_x_grad, grad_y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "matmul_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "matmul_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "matmul_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(3), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), MakeMetaTensor(*input_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, bool, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("matmul_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_grad_out, input_grad_x_grad, input_grad_y_grad, transpose_x, transpose_y, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void matmul_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, bool transpose_x, bool transpose_y, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "matmul_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "matmul_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "matmul_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, bool, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("matmul_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, transpose_x, transpose_y, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void matmul_triple_grad(const Tensor& x, const Tensor& y, const Tensor& fwd_grad_out, const Tensor& fwd_grad_grad_x, const Tensor& fwd_grad_grad_y, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, const paddle::optional<Tensor>& grad_grad_out_grad, bool transpose_x, bool transpose_y, Tensor* x_grad, Tensor* y_grad, Tensor* fwd_grad_out_grad, Tensor* fwd_grad_grad_x_grad, Tensor* fwd_grad_grad_y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, fwd_grad_out, fwd_grad_grad_x, fwd_grad_grad_y, grad_x_grad, grad_y_grad, grad_grad_out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "matmul_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "matmul_triple_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "matmul_triple_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_fwd_grad_out = PrepareData(fwd_grad_out, kernel.InputAt(2), {});
  auto input_fwd_grad_grad_x = PrepareData(fwd_grad_grad_x, kernel.InputAt(3), {});
  auto input_fwd_grad_grad_y = PrepareData(fwd_grad_grad_y, kernel.InputAt(4), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(5), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(6), {});
  auto input_grad_grad_out_grad = PrepareData(grad_grad_out_grad, kernel.InputAt(7), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, fwd_grad_out_grad);
  auto kernel_out_3 = SetKernelOutput(kernel_backend, fwd_grad_grad_x_grad);
  auto kernel_out_4 = SetKernelOutput(kernel_backend, fwd_grad_grad_y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);
  phi::MetaTensor meta_out_3(kernel_out_3);
  phi::MetaTensor meta_out_4(kernel_out_4);

  phi::GeneralQuinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), MakeMetaTensor(*input_fwd_grad_out), MakeMetaTensor(*input_fwd_grad_grad_x), MakeMetaTensor(*input_fwd_grad_grad_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr, kernel_out_3 ? &meta_out_3 : nullptr, kernel_out_4 ? &meta_out_4 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, bool, bool, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("matmul_triple_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_fwd_grad_out, *input_fwd_grad_grad_x, *input_fwd_grad_grad_y, input_grad_x_grad, input_grad_y_grad, input_grad_grad_out_grad, transpose_x, transpose_y, kernel_out_0, kernel_out_1, kernel_out_2, kernel_out_3, kernel_out_4);
  }

  
}

PADDLE_API void matrix_power_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, int n, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "matrix_power_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "matrix_power_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "matrix_power_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("matrix_power_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, n, kernel_out);
  }

  
}

PADDLE_API void max_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "max_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "max_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "max_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("max_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, dims, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void max_pool2d_with_index_grad(const Tensor& x, const Tensor& mask, const Tensor& out_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool global_pooling, bool adaptive, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, mask, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "max_pool2d_with_index_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "max_pool2d_with_index_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "max_pool2d_with_index_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_mask = PrepareData(mask, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::MaxPoolWithIndexGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_mask), MakeMetaTensor(*input_out_grad), kernel_size, strides, paddings, global_pooling, adaptive, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("max_pool2d_with_index_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_mask, *input_out_grad, kernel_size, strides, paddings, global_pooling, adaptive, kernel_out);
  }

  
}

PADDLE_API void max_pool3d_with_index_grad(const Tensor& x, const Tensor& mask, const Tensor& out_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool global_pooling, bool adaptive, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, mask, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "max_pool3d_with_index_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "max_pool3d_with_index_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "max_pool3d_with_index_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_mask = PrepareData(mask, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::MaxPoolWithIndexGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_mask), MakeMetaTensor(*input_out_grad), kernel_size, strides, paddings, global_pooling, adaptive, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("max_pool3d_with_index_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_mask, *input_out_grad, kernel_size, strides, paddings, global_pooling, adaptive, kernel_out);
  }

  
}

PADDLE_API void maximum_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "maximum_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "maximum_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "maximum_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("maximum_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void maxout_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, int groups, int axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "maxout_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "maxout_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "maxout_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GeneralUnaryGradInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("maxout_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, groups, axis, kernel_out);
  }

  
}

PADDLE_API void mean_all_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "mean_all_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "mean_all_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "mean_all_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("mean_all_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void mean_double_grad(const Tensor& grad_x_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* grad_out_grad) {
  *grad_out_grad = mean(grad_x_grad, dims, keep_dim);
}
PADDLE_API void mean_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "mean_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "mean_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "mean_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("mean_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, dims, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void meshgrid_grad(const std::vector<Tensor>& inputs, const std::vector<Tensor>& outputs_grad, std::vector<Tensor*> inputs_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(inputs, outputs_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "meshgrid_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "meshgrid_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "meshgrid_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_inputs_vec = PrepareData(inputs, kernel.InputAt(0), {});
  std::vector<const phi::DenseTensor*> input_inputs(input_inputs_vec->size());
  for (size_t i = 0; i < input_inputs.size(); ++i) {
    input_inputs[i] = &input_inputs_vec->at(i);
  }
  auto input_outputs_grad_vec = PrepareData(outputs_grad, kernel.InputAt(1), {});
  std::vector<const phi::DenseTensor*> input_outputs_grad(input_outputs_grad_vec->size());
  for (size_t i = 0; i < input_outputs_grad.size(); ++i) {
    input_outputs_grad[i] = &input_outputs_grad_vec->at(i);
  }

  auto kernel_out = SetKernelOutput(&inputs_grad);

  auto inputs_meta_vec = MakeMetaTensor(input_inputs);
  std::vector<const phi::MetaTensor*> inputs_metas(inputs_meta_vec.size());
  for (size_t i = 0; i < inputs_meta_vec.size(); ++i) {
    inputs_metas[i] = &inputs_meta_vec[i];
  }

  auto outputs_grad_meta_vec = MakeMetaTensor(input_outputs_grad);
  std::vector<const phi::MetaTensor*> outputs_grad_metas(outputs_grad_meta_vec.size());
  for (size_t i = 0; i < outputs_grad_meta_vec.size(); ++i) {
    outputs_grad_metas[i] = &outputs_grad_meta_vec[i];
  }

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::MeshgridGradInferMeta(inputs_metas, outputs_grad_metas, kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const std::vector<const phi::DenseTensor*>&, const std::vector<const phi::DenseTensor*>&, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("meshgrid_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, input_inputs, input_outputs_grad, kernel_out);
  }

  
}

PADDLE_API void min_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "min_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "min_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "min_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("min_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, dims, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void minimum_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "minimum_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "minimum_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "minimum_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("minimum_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void mish_grad(const Tensor& x, const Tensor& out_grad, float threshold, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "mish_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "mish_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "mish_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("mish_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, threshold, kernel_out);
  }

  
}

PADDLE_API void mode_grad(const Tensor& x, const Tensor& indices, const Tensor& out_grad, int axis, bool keepdim, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, indices, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "mode_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "mode_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "mode_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_indices = PrepareData(indices, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("mode_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_indices, *input_out_grad, axis, keepdim, kernel_out);
  }

  
}

PADDLE_API void modulo_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "modulo_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "modulo_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "modulo_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("modulo_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void multi_dot_grad(const std::vector<Tensor>& x, const Tensor& out_grad, std::vector<Tensor*> x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "multi_dot_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "multi_dot_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "multi_dot_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x_vec = PrepareData(x, kernel.InputAt(0), {});
  std::vector<const phi::DenseTensor*> input_x(input_x_vec->size());
  for (size_t i = 0; i < input_x.size(); ++i) {
    input_x[i] = &input_x_vec->at(i);
  }
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(&x_grad);

  auto x_meta_vec = MakeMetaTensor(input_x);
  std::vector<const phi::MetaTensor*> x_metas(x_meta_vec.size());
  for (size_t i = 0; i < x_meta_vec.size(); ++i) {
    x_metas[i] = &x_meta_vec[i];
  }

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::MultiDotGradInferMeta(x_metas, MakeMetaTensor(*input_out_grad), kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const std::vector<const phi::DenseTensor*>&, const phi::DenseTensor&, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("multi_dot_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void multiplex_grad(const std::vector<Tensor>& ins, const Tensor& ids, const Tensor& out_grad, std::vector<Tensor*> ins_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(ins, ids, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "multiplex_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "multiplex_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "multiplex_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_ids = PrepareData(ids, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(&ins_grad);

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::MultiplexGradInferMeta(MakeMetaTensor(*input_ids), MakeMetaTensor(*input_out_grad), kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("multiplex_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_ids, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void multiply_double_grad(const Tensor& x, const Tensor& y, const Tensor& grad_out, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, int axis, Tensor* x_grad, Tensor* y_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, grad_out, grad_x_grad, grad_y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "multiply_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "multiply_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "multiply_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(2), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(3), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), MakeMetaTensor(*input_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, int, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("multiply_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_grad_out, input_grad_x_grad, input_grad_y_grad, axis, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void multiply_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "multiply_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "multiply_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "multiply_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("multiply_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void multiply_triple_grad(const Tensor& x, const Tensor& y, const Tensor& fwd_grad_out, const paddle::optional<Tensor>& fwd_grad_grad_x, const paddle::optional<Tensor>& fwd_grad_grad_y, const Tensor& grad_x_grad, const Tensor& grad_y_grad, const paddle::optional<Tensor>& grad_grad_out_grad, int axis, Tensor* x_grad, Tensor* y_grad, Tensor* fwd_grad_out_grad, Tensor* fwd_grad_grad_x_grad, Tensor* fwd_grad_grad_y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, fwd_grad_out, fwd_grad_grad_x, fwd_grad_grad_y, grad_x_grad, grad_y_grad, grad_grad_out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "multiply_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "multiply_triple_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "multiply_triple_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_fwd_grad_out = PrepareData(fwd_grad_out, kernel.InputAt(2), {});
  auto input_fwd_grad_grad_x = PrepareData(fwd_grad_grad_x, kernel.InputAt(3), {});
  auto input_fwd_grad_grad_y = PrepareData(fwd_grad_grad_y, kernel.InputAt(4), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(5), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(6), {});
  auto input_grad_grad_out_grad = PrepareData(grad_grad_out_grad, kernel.InputAt(7), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, fwd_grad_out_grad);
  auto kernel_out_3 = SetKernelOutput(kernel_backend, fwd_grad_grad_x_grad);
  auto kernel_out_4 = SetKernelOutput(kernel_backend, fwd_grad_grad_y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);
  phi::MetaTensor meta_out_3(kernel_out_3);
  phi::MetaTensor meta_out_4(kernel_out_4);

  phi::GeneralQuinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), MakeMetaTensor(*input_fwd_grad_out), MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr, kernel_out_3 ? &meta_out_3 : nullptr, kernel_out_4 ? &meta_out_4 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, int, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("multiply_triple_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_fwd_grad_out, input_fwd_grad_grad_x, input_fwd_grad_grad_y, *input_grad_x_grad, *input_grad_y_grad, input_grad_grad_out_grad, axis, kernel_out_0, kernel_out_1, kernel_out_2, kernel_out_3, kernel_out_4);
  }

  
}

PADDLE_API void nll_loss_grad(const Tensor& input, const Tensor& label, const paddle::optional<Tensor>& weight, const Tensor& total_weight, const Tensor& out_grad, int64_t ignore_index, const std::string& reduction, Tensor* input_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(input);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, label, weight, total_weight, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "nll_loss_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "nll_loss_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "nll_loss_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_label = PrepareData(label, kernel.InputAt(1), {});
  auto input_weight = PrepareData(weight, kernel.InputAt(2), {});
  auto input_total_weight = PrepareData(total_weight, kernel.InputAt(3), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(4), {});

  auto kernel_out = SetKernelOutput(kernel_backend, input_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::NllLossGradInferMeta(MakeMetaTensor(*input_input), MakeMetaTensor(*input_label), MakeMetaTensor(input_weight), MakeMetaTensor(*input_total_weight), MakeMetaTensor(*input_out_grad), ignore_index, reduction, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, int64_t, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("nll_loss_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_label, input_weight, *input_total_weight, *input_out_grad, ignore_index, reduction, kernel_out);
  }

  
}

PADDLE_API void norm_grad(const Tensor& x, const Tensor& norm, const Tensor& out_grad, int axis, float epsilon, bool is_test, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, norm, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_norm = PrepareData(norm, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, float, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_norm, *input_out_grad, axis, epsilon, is_test, kernel_out);
  }

  
}

PADDLE_API void p_norm_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, float porder, int axis, float epsilon, bool keepdim, bool asvector, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "p_norm_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "p_norm_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "p_norm_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, float, int, float, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("p_norm_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, porder, axis, epsilon, keepdim, asvector, kernel_out);
  }

  
}

PADDLE_API void pad3d_double_grad(const Tensor& grad_x_grad, const IntArray& paddings, const std::string& mode, float pad_value, const std::string& data_format, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pad3d_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pad3d", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pad3d kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::Pad3dInferMeta(MakeMetaTensor(*input_grad_x_grad), paddings, mode, pad_value, data_format, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::IntArray&, const std::string&, float, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pad3d compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, phi::IntArray(paddings), mode, pad_value, data_format, kernel_out);
  }

  
}

PADDLE_API void pad3d_grad(const Tensor& x, const Tensor& out_grad, const IntArray& paddings, const std::string& mode, float pad_value, const std::string& data_format, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pad3d_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pad3d_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pad3d_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::IntArray&, const std::string&, float, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pad3d_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::IntArray(paddings), mode, pad_value, data_format, kernel_out);
  }

  
}

PADDLE_API void pad_double_grad(const Tensor& grad_x_grad, const std::vector<int>& paddings, float pad_value, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pad_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PadInferMeta(MakeMetaTensor(*input_grad_x_grad), paddings, pad_value, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int>&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, paddings, pad_value, kernel_out);
  }

  
}

PADDLE_API void pad_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int>& paddings, float pad_value, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pad_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pad_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pad_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = x.impl();
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int>&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pad_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, paddings, pad_value, kernel_out);
  }

  
}

PADDLE_API void pixel_shuffle_grad(const Tensor& out_grad, int upscale_factor, const std::string& data_format, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pixel_shuffle_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pixel_shuffle_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pixel_shuffle_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PixelShuffleGradInferMeta(MakeMetaTensor(*input_out_grad), upscale_factor, data_format, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, int, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pixel_shuffle_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, upscale_factor, data_format, kernel_out);
  }

  
}

PADDLE_API void pool2d_double_grad(const Tensor& grad_x_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pool2d_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pool2d_double_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "pool2d_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PoolInferMeta(MakeMetaTensor(*input_grad_x_grad), kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, const std::string&, const std::string&, bool, bool, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pool2d_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, kernel_out);
  }

  
}

PADDLE_API void pool2d_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pool2d_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pool2d_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "pool2d_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PoolGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_out), MakeMetaTensor(*input_out_grad), kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, const std::string&, const std::string&, bool, bool, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pool2d_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, kernel_out);
  }

  
}

PADDLE_API void pool2d_grad_gpudnn_unused(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pool2d_grad_gpudnn_unused API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pool2d_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pool2d_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PoolGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_out), MakeMetaTensor(*input_out_grad), kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, const std::string&, const std::string&, bool, bool, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pool2d_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, kernel_out);
  }

  
}

PADDLE_API void pool3d_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int>& kernel_size, const std::vector<int>& strides, const std::vector<int>& paddings, bool ceil_mode, bool exclusive, const std::string& data_format, const std::string& pooling_type, bool global_pooling, bool adaptive, const std::string& padding_algorithm, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pool3d_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pool3d_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "pool3d_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::PoolGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_out), MakeMetaTensor(*input_out_grad), kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, bool, bool, const std::string&, const std::string&, bool, bool, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pool3d_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, kernel_out);
  }

  
}

PADDLE_API void pow_grad(const Tensor& x, const Tensor& out_grad, const Scalar& s, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "pow_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "pow_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "pow_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::Scalar&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("pow_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::Scalar(s), kernel_out);
  }

  
}

PADDLE_API void prelu_grad(const Tensor& x, const Tensor& alpha, const Tensor& out_grad, const std::string& data_format, const std::string& mode, Tensor* x_grad, Tensor* alpha_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, alpha, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "prelu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "prelu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "prelu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_alpha = PrepareData(alpha, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, alpha_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_alpha), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::string&, const std::string&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("prelu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_alpha, *input_out_grad, data_format, mode, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void psroi_pool_grad(const Tensor& x, const Tensor& boxes, const paddle::optional<Tensor>& boxes_num, const Tensor& out_grad, int pooled_height, int pooled_width, int output_channels, float spatial_scale, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, boxes, boxes_num, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "psroi_pool_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "psroi_pool_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "psroi_pool_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_boxes = PrepareData(boxes, kernel.InputAt(1), {});
  auto input_boxes_num = PrepareData(boxes_num, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GeneralUnaryGradInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, int, int, int, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("psroi_pool_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_boxes, input_boxes_num, *input_out_grad, pooled_height, pooled_width, output_channels, spatial_scale, kernel_out);
  }

  
}

PADDLE_API void put_along_axis_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, int axis, const std::string& reduce, Tensor* x_grad, Tensor* value_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "put_along_axis_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "put_along_axis_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "put_along_axis_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, value_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_index), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, const std::string&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("put_along_axis_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, axis, reduce, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void real_grad(const Tensor& out_grad, Tensor* x_grad) {
  real_grad_impl(out_grad, x_grad);
}
PADDLE_API void reciprocal_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "reciprocal_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "reciprocal_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "reciprocal_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("reciprocal_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void reduce_prod_grad(const Tensor& x, const Tensor& out, const Tensor& out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "reduce_prod_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "prod_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "prod_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out = PrepareData(out, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("prod_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out, *input_out_grad, dims, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void relu6_grad(const Tensor& out, const Tensor& out_grad, float threshold, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "relu6_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "relu6_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "relu6_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("relu6_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, threshold, kernel_out);
  }

  
}

PADDLE_API void relu_double_grad(const Tensor& out, const Tensor& grad_x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "relu_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "relu_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "relu_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("relu_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_grad_x_grad, kernel_out);
  }

  
}

PADDLE_API void relu_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "relu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "relu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "relu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("relu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void reshape_double_grad(const Tensor& grad_out, const Tensor& grad_x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "reshape_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "reshape_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "reshape_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(0), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("reshape_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_out, *input_grad_x_grad, kernel_out);
  }

  
}

PADDLE_API void reshape_grad(const Tensor& xshape, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_backend = ParseBackend(out_grad);

  kernel_layout = ParseLayout(out_grad);

  kernel_data_type = ParseDataType(out_grad);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(xshape, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "reshape_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "reshape_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "reshape_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_xshape = xshape.impl();
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::KernelWithXShapeInferMeta(MakeMetaTensor(*input_xshape), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("reshape_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void roi_align_grad(const Tensor& x, const Tensor& boxes, const paddle::optional<Tensor>& boxes_num, const Tensor& out_grad, int pooled_height, int pooled_width, float spatial_scale, int sampling_ratio, bool aligned, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(boxes);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, boxes, boxes_num, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "roi_align_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "roi_align_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "roi_align_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_boxes = PrepareData(boxes, kernel.InputAt(1), {});
  auto input_boxes_num = PrepareData(boxes_num, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, int, int, float, int, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("roi_align_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_boxes, input_boxes_num, *input_out_grad, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned, kernel_out);
  }

  
}

PADDLE_API void roi_pool_grad(const Tensor& x, const Tensor& boxes, const paddle::optional<Tensor>& boxes_num, const Tensor& arg_max, const Tensor& out_grad, int pooled_height, int pooled_width, float spatial_scale, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, boxes, boxes_num, arg_max, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "roi_pool_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "roi_pool_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "roi_pool_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_boxes = PrepareData(boxes, kernel.InputAt(1), {});
  auto input_boxes_num = PrepareData(boxes_num, kernel.InputAt(2), {});
  auto input_arg_max = PrepareData(arg_max, kernel.InputAt(3), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(4), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const phi::DenseTensor&, int, int, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("roi_pool_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_boxes, input_boxes_num, *input_arg_max, *input_out_grad, pooled_height, pooled_width, spatial_scale, kernel_out);
  }

  
}

PADDLE_API void roll_grad(const Tensor& x, const Tensor& out_grad, const IntArray& shifts, const std::vector<int64_t>& axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "roll_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "roll_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "roll_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::IntArray&, const std::vector<int64_t>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("roll_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::IntArray(shifts), axis, kernel_out);
  }

  
}

PADDLE_API void round_grad(const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "round_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "round_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "round_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("round_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void rsqrt_double_grad(const Tensor& out, const Tensor& grad_x, const Tensor& grad_x_grad, Tensor* out_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, grad_x, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "rsqrt_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "rsqrt_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "rsqrt_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_grad_x = PrepareData(grad_x, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("rsqrt_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_grad_x, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void rsqrt_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "rsqrt_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "rsqrt_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "rsqrt_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("rsqrt_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void scale_double_grad(const Tensor& grad_x_grad, const Scalar& scale_val, float bias, bool bias_after_scale, Tensor* grad_out_grad) {
  *grad_out_grad = scale(grad_x_grad, scale_val, 0.0, bias_after_scale);
}
PADDLE_API void scale_grad(const Tensor& out_grad, const Scalar& scale_val, float bias, bool bias_after_scale, Tensor* x_grad) {
  *x_grad = scale(out_grad, scale_val, 0.0, bias_after_scale);
}
PADDLE_API void scale_triple_grad(const Tensor& grad_grad_out_grad, const Scalar& scale_val, float bias, bool bias_after_scale, Tensor* grad_grad_x_grad) {
  *grad_grad_x_grad = scale(grad_grad_out_grad, scale_val, 0.0, bias_after_scale);
}
PADDLE_API void scatter_grad(const Tensor& index, const Tensor& updates, const Tensor& out_grad, bool overwrite, Tensor* x_grad, Tensor* updates_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(index, updates, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "scatter_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "scatter_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "scatter_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_index = PrepareData(index, kernel.InputAt(0), {});
  auto input_updates = PrepareData(updates, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, updates_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ScatterGradInferMeta(MakeMetaTensor(*input_index), MakeMetaTensor(*input_updates), MakeMetaTensor(*input_out_grad), overwrite, kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("scatter_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_index, *input_updates, *input_out_grad, overwrite, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void scatter_nd_add_grad(const Tensor& index, const Tensor& updates, const Tensor& out_grad, Tensor* x_grad, Tensor* updates_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(index, updates, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "scatter_nd_add_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "scatter_nd_add_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "scatter_nd_add_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_index = PrepareData(index, kernel.InputAt(0), {});
  auto input_updates = PrepareData(updates, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, updates_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::ScatterNdAddGradInferMeta(MakeMetaTensor(*input_index), MakeMetaTensor(*input_updates), MakeMetaTensor(*input_out_grad), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("scatter_nd_add_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_index, *input_updates, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void segment_pool_grad(const Tensor& x, const Tensor& segment_ids, const Tensor& out, const paddle::optional<Tensor>& summed_ids, const Tensor& out_grad, const std::string& pooltype, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  kernel_data_type = ParseDataType(x);

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, segment_ids, out, summed_ids, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "segment_pool_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "segment_pool_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "segment_pool_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_segment_ids = PrepareData(segment_ids, kernel.InputAt(1), {});
  auto input_out = PrepareData(out, kernel.InputAt(2), {});
  auto input_summed_ids = PrepareData(summed_ids, kernel.InputAt(3), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(4), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const phi::DenseTensor&, const std::string&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("segment_pool_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_segment_ids, *input_out, input_summed_ids, *input_out_grad, pooltype, kernel_out);
  }

  
}

PADDLE_API void selu_grad(const Tensor& out, const Tensor& out_grad, float scale, float alpha, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "selu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "selu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "selu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("selu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, scale, alpha, kernel_out);
  }

  
}

PADDLE_API void sigmoid_cross_entropy_with_logits_grad(const Tensor& x, const Tensor& label, const Tensor& out_grad, bool normalize, int ignore_index, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, label, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sigmoid_cross_entropy_with_logits_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sigmoid_cross_entropy_with_logits_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sigmoid_cross_entropy_with_logits_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_label = PrepareData(label, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sigmoid_cross_entropy_with_logits_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_label, *input_out_grad, normalize, ignore_index, kernel_out);
  }

  
}

PADDLE_API void sigmoid_double_grad(const Tensor& out, const Tensor& fwd_grad_out, const Tensor& grad_x_grad, Tensor* out_grad, Tensor* fwd_grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, fwd_grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sigmoid_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sigmoid_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sigmoid_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_fwd_grad_out = PrepareData(fwd_grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, fwd_grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_fwd_grad_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sigmoid_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_fwd_grad_out, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void sigmoid_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sigmoid_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sigmoid_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sigmoid_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sigmoid_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void sigmoid_triple_grad(const Tensor& out, const Tensor& fwd_grad_out, const Tensor& grad_grad_x, const Tensor& grad_out_grad, const paddle::optional<Tensor>& grad_grad_out_grad, Tensor* out_grad, Tensor* fwd_grad_out_grad, Tensor* grad_grad_x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, fwd_grad_out, grad_grad_x, grad_out_grad, grad_grad_out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sigmoid_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sigmoid_triple_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sigmoid_triple_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_fwd_grad_out = PrepareData(fwd_grad_out, kernel.InputAt(1), {});
  auto input_grad_grad_x = PrepareData(grad_grad_x, kernel.InputAt(2), {});
  auto input_grad_out_grad = PrepareData(grad_out_grad, kernel.InputAt(3), {});
  auto input_grad_grad_out_grad = PrepareData(grad_grad_out_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, fwd_grad_out_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_grad_x_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_fwd_grad_out), MakeMetaTensor(*input_grad_grad_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sigmoid_triple_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_fwd_grad_out, *input_grad_grad_x, *input_grad_out_grad, input_grad_grad_out_grad, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void silu_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "silu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "silu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "silu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("silu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void sin_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sin_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sin_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sin_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sin_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void sinh_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sinh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sinh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sinh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sinh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void slice_double_grad(const Tensor& grad_input_grad, const std::vector<int64_t>& axes, const IntArray& starts, const IntArray& ends, const std::vector<int64_t>& infer_flags, const std::vector<int64_t>& decrease_axis, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_input_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "slice_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "slice", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "slice kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_input_grad = PrepareData(grad_input_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_input_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int64_t>&, const phi::IntArray&, const phi::IntArray&, const std::vector<int64_t>&, const std::vector<int64_t>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("slice compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_input_grad, axes, phi::IntArray(starts), phi::IntArray(ends), infer_flags, decrease_axis, kernel_out);
  }

  
}

PADDLE_API void slice_grad(const Tensor& input, const Tensor& out_grad, const std::vector<int64_t>& axes, const IntArray& starts, const IntArray& ends, const std::vector<int64_t>& infer_flags, const std::vector<int64_t>& decrease_axis, Tensor* input_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(input, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "slice_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "slice_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "slice_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_input = PrepareData(input, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, input_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_input), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, const phi::IntArray&, const phi::IntArray&, const std::vector<int64_t>&, const std::vector<int64_t>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("slice_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_input, *input_out_grad, axes, phi::IntArray(starts), phi::IntArray(ends), infer_flags, decrease_axis, kernel_out);
  }

  
}

PADDLE_API void soft_shrink_grad(const Tensor& x, const Tensor& out_grad, float lambda, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "soft_shrink_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "soft_shrink_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "soft_shrink_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("soft_shrink_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, lambda, kernel_out);
  }

  
}

PADDLE_API void softmax_grad(const Tensor& out, const Tensor& out_grad, int axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "softmax_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "softmax_grad", {kernel_backend, kernel_layout, kernel_data_type}, true);
  VLOG(6) << "softmax_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("softmax_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void split_grad(const std::vector<Tensor>& out_grad, const Scalar& axis, Tensor* x_grad) {
  *x_grad = concat( out_grad, axis);
}
PADDLE_API void sqrt_double_grad(const Tensor& out, const Tensor& grad_x, const Tensor& grad_x_grad, Tensor* out_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, grad_x, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sqrt_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sqrt_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sqrt_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_grad_x = PrepareData(grad_x, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sqrt_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_grad_x, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void sqrt_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sqrt_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sqrt_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sqrt_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sqrt_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void square_double_grad(const Tensor& x, const Tensor& grad_out, const Tensor& grad_x_grad, Tensor* x_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "square_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "square_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "square_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_x), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("square_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_grad_out, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void square_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "square_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "square_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "square_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("square_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void squeeze_double_grad(const Tensor& grad_x_grad, const std::vector<int>& axes, Tensor* grad_out_grad) {
  *grad_out_grad = squeeze(grad_x_grad, axes);
}
PADDLE_API void squeeze_grad(const Tensor& xshape, const Tensor& out_grad, const std::vector<int>& axes, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(xshape, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "squeeze_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "squeeze_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "squeeze_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_xshape = PrepareData(xshape, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::KernelWithXShapeInferMeta(MakeMetaTensor(*input_xshape), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("squeeze_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_xshape, *input_out_grad, axes, kernel_out);
  }

  
}

PADDLE_API void stack_grad(const std::vector<Tensor>& x, const Tensor& out_grad, int axis, std::vector<Tensor*> x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "stack_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "stack_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "stack_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(&x_grad);

  auto kernel_out_meta_vec = MakeMetaTensor(kernel_out);
  std::vector<phi::MetaTensor*> kernel_out_metas(kernel_out_meta_vec.size());
  for (size_t i = 0; i < kernel_out_meta_vec.size(); ++i) {
    kernel_out_metas[i] = kernel_out[i] ? &kernel_out_meta_vec[i] : nullptr;
  }
  phi::StackGradInferMeta(MakeMetaTensor(*input_out_grad), axis, kernel_out_metas);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, int, std::vector<phi::DenseTensor*>&);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("stack_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void strided_slice_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int>& axes, const IntArray& starts, const IntArray& ends, const IntArray& strides, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "strided_slice_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "strided_slice_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "strided_slice_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GeneralUnaryGradInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const phi::IntArray&, const phi::IntArray&, const phi::IntArray&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("strided_slice_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, axes, phi::IntArray(starts), phi::IntArray(ends), phi::IntArray(strides), kernel_out);
  }

  
}

PADDLE_API void subtract_double_grad(const Tensor& y, const Tensor& grad_out, const paddle::optional<Tensor>& grad_x_grad, const paddle::optional<Tensor>& grad_y_grad, int axis, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(y, grad_out, grad_x_grad, grad_y_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "subtract_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "subtract_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "subtract_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_y = PrepareData(y, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});
  auto input_grad_y_grad = PrepareData(grad_y_grad, kernel.InputAt(3), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_grad_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const paddle::optional<phi::DenseTensor>&, const paddle::optional<phi::DenseTensor>&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("subtract_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_y, *input_grad_out, input_grad_x_grad, input_grad_y_grad, axis, kernel_out);
  }

  
}

PADDLE_API void subtract_grad(const Tensor& x, const Tensor& y, const Tensor& out_grad, int axis, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "subtract_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "subtract_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "subtract_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("subtract_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out_grad, axis, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void sum_double_grad(const Tensor& grad_x_grad, const std::vector<int64_t>& dims, bool keep_dim, Tensor* grad_out_grad) {
  *grad_out_grad = sum(grad_x_grad, dims, grad_x_grad.dtype(), keep_dim);
}
PADDLE_API void sum_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "sum_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "sum_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "sum_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int64_t>&, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("sum_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, dims, keep_dim, reduce_all, kernel_out);
  }

  
}

PADDLE_API void sum_triple_grad(const Tensor& grad_grad_x, const Tensor& grad_grad_out_grad, const std::vector<int64_t>& dims, bool keep_dim, bool reduce_all, Tensor* grad_grad_x_grad) {
  sum_grad(grad_grad_x, grad_grad_out_grad, dims, keep_dim, reduce_all, grad_grad_x_grad);
}
PADDLE_API void swish_grad(const Tensor& x, const Tensor& out_grad, float bete, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "swish_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "swish_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "swish_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::GeneralUnaryGradInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("swish_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, bete, kernel_out);
  }

  
}

PADDLE_API void take_along_axis_grad(const Tensor& x, const Tensor& index, const Tensor& out_grad, int axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, index, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "take_along_axis_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "take_along_axis_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "take_along_axis_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_index = PrepareData(index, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, int, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("take_along_axis_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_index, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void tan_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tan_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tan_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tan_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tan_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void tanh_double_grad(const Tensor& out, const Tensor& grad_out, const Tensor& grad_x_grad, Tensor* out_grad, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, grad_out, grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tanh_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tanh_double_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tanh_double_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_grad_out = PrepareData(grad_out, kernel.InputAt(1), {});
  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(2), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_out), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tanh_double_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_grad_out, *input_grad_x_grad, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void tanh_grad(const Tensor& out, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tanh_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tanh_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tanh_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tanh_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void tanh_shrink_grad(const Tensor& x, const Tensor& out_grad, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tanh_shrink_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tanh_shrink_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tanh_shrink_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tanh_shrink_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void tanh_triple_grad(const Tensor& out, const Tensor& grad_out_forward, const Tensor& grad_x_grad_forward, const Tensor& grad_out_new_grad, const Tensor& grad_out_grad_grad, Tensor* out_grad, Tensor* grad_out_forward_grad, Tensor* grad_x_grad_forward_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out, grad_out_forward, grad_x_grad_forward, grad_out_new_grad, grad_out_grad_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tanh_triple_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tanh_triple_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tanh_triple_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out = PrepareData(out, kernel.InputAt(0), {});
  auto input_grad_out_forward = PrepareData(grad_out_forward, kernel.InputAt(1), {});
  auto input_grad_x_grad_forward = PrepareData(grad_x_grad_forward, kernel.InputAt(2), {});
  auto input_grad_out_new_grad = PrepareData(grad_out_new_grad, kernel.InputAt(3), {});
  auto input_grad_out_grad_grad = PrepareData(grad_out_grad_grad, kernel.InputAt(4), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, out_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, grad_out_forward_grad);
  auto kernel_out_2 = SetKernelOutput(kernel_backend, grad_x_grad_forward_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);
  phi::MetaTensor meta_out_2(kernel_out_2);

  phi::GeneralTernaryGradInferMeta(MakeMetaTensor(*input_out), MakeMetaTensor(*input_out), MakeMetaTensor(*input_grad_x_grad_forward), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr, kernel_out_2 ? &meta_out_2 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tanh_triple_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out, *input_grad_out_forward, *input_grad_x_grad_forward, *input_grad_out_new_grad, *input_grad_out_grad_grad, kernel_out_0, kernel_out_1, kernel_out_2);
  }

  
}

PADDLE_API void thresholded_relu_grad(const Tensor& x, const Tensor& out_grad, float threshold, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "thresholded_relu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "thresholded_relu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "thresholded_relu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, float, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("thresholded_relu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, threshold, kernel_out);
  }

  
}

PADDLE_API void tile_double_grad(const Tensor& grad_x_grad, const IntArray& repeat_times, Tensor* grad_out_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(grad_x_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tile_double_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tile", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tile kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_grad_x_grad = PrepareData(grad_x_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, grad_out_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::TileInferMeta(MakeMetaTensor(*input_grad_x_grad), repeat_times, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::IntArray&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tile compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_grad_x_grad, phi::IntArray(repeat_times), kernel_out);
  }

  
}

PADDLE_API void tile_grad(const Tensor& x, const Tensor& out_grad, const IntArray& repeat_times, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tile_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tile_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tile_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::IntArray&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tile_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, phi::IntArray(repeat_times), kernel_out);
  }

  
}

PADDLE_API void top_k_grad(const Tensor& x, const Tensor& indices, const Tensor& out_grad, const Scalar& k, int axis, bool largest, bool sorted, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, indices, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "top_k_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "top_k_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "top_k_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_indices = PrepareData(indices, kernel.InputAt(1), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(2), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::Scalar&, int, bool, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("top_k_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_indices, *input_out_grad, phi::Scalar(k), axis, largest, sorted, kernel_out);
  }

  
}

PADDLE_API void transpose_double_grad(const Tensor& grad_x_grad, const std::vector<int>& axis, Tensor* grad_out_grad) {
  *grad_out_grad = transpose(grad_x_grad, axis);
}
PADDLE_API void transpose_grad(const Tensor& out_grad, const std::vector<int>& axis, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "transpose_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "transpose_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "transpose_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::TransposeGradInferMeta(MakeMetaTensor(*input_out_grad), axis, &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const std::vector<int>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("transpose_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, axis, kernel_out);
  }

  
}

PADDLE_API void triangular_solve_grad(const Tensor& x, const Tensor& y, const Tensor& out, const Tensor& out_grad, bool upper, bool tranpose, bool unitriangular, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, y, out, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "triangular_solve_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "triangular_solve_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "triangular_solve_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_y = PrepareData(y, kernel.InputAt(1), {});
  auto input_out = PrepareData(out, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, bool, bool, bool, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("triangular_solve_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_y, *input_out, *input_out_grad, upper, tranpose, unitriangular, kernel_out_0, kernel_out_1);
  }

  
}

PADDLE_API void tril_triu_grad(const Tensor& out_grad, int diagonal, bool lower, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "tril_triu_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "tril_triu_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "tril_triu_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(0), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_out_grad), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, int, bool, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("tril_triu_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_out_grad, diagonal, lower, kernel_out);
  }

  
}

PADDLE_API void unbind_grad(const std::vector<Tensor>& out_grad, int axis, Tensor* input_grad) {
  *input_grad = stack(out_grad, axis);
}
PADDLE_API void unfold_grad(const Tensor& x, const Tensor& out_grad, const std::vector<int>& kernel_sizes, const std::vector<int>& strides, const std::vector<int>& paddings, const std::vector<int>& dilations, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(x, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "unfold_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "unfold_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "unfold_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_x = PrepareData(x, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::UnchangedInferMeta(MakeMetaTensor(*input_x), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, const std::vector<int>&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("unfold_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_x, *input_out_grad, kernel_sizes, strides, paddings, dilations, kernel_out);
  }

  
}

PADDLE_API void unsqueeze_double_grad(const Tensor& grad_x_grad, const IntArray& axes, Tensor* grad_out_grad) {
  *grad_out_grad = unsqueeze(grad_x_grad, axes);
}
PADDLE_API void unsqueeze_grad(const Tensor& xshape, const Tensor& out_grad, const IntArray& axes, Tensor* x_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(xshape, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "unsqueeze_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "unsqueeze_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "unsqueeze_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_xshape = PrepareData(xshape, kernel.InputAt(0), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(1), {});

  auto kernel_out = SetKernelOutput(kernel_backend, x_grad);
  phi::MetaTensor meta_out(kernel_out);

  phi::KernelWithXShapeInferMeta(MakeMetaTensor(*input_xshape), &meta_out);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("unsqueeze_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_xshape, *input_out_grad, kernel_out);
  }

  
}

PADDLE_API void where_grad(const Tensor& condition, const Tensor& x, const Tensor& y, const Tensor& out_grad, Tensor* x_grad, Tensor* y_grad) {

  Backend kernel_backend = Backend::UNDEFINED;
  DataLayout kernel_layout = DataLayout::UNDEFINED;
  DataType kernel_data_type = DataType::UNDEFINED;

  if (kernel_backend == Backend::UNDEFINED
        || kernel_layout == DataLayout::UNDEFINED
        || kernel_data_type == DataType::UNDEFINED ) {
    auto kernel_key_set = ParseKernelKeyByInputArgs(condition, x, y, out_grad);
    auto kernel_key = kernel_key_set.GetHighestPriorityKernelKey();
    if (kernel_backend == Backend::UNDEFINED) {
      kernel_backend = kernel_key.backend();
    }
    if (kernel_layout == DataLayout::UNDEFINED) {
      kernel_layout = kernel_key.layout();
    }
    if (kernel_data_type == DataType::UNDEFINED) {
      kernel_data_type = kernel_key.dtype();
    }
  }

  VLOG(6) << "where_grad API kernel key: [" << kernel_backend << ", " << kernel_layout << ", "<< kernel_data_type << "]";
  const auto& kernel = phi::KernelFactory::Instance().SelectKernelOrThrowError(
      "where_grad", {kernel_backend, kernel_layout, kernel_data_type});
  VLOG(6) << "where_grad kernel: " << kernel;

  auto* dev_ctx = GetDeviceContextByBackend(kernel_backend);

  auto input_condition = PrepareData(condition, kernel.InputAt(0), {});
  auto input_x = PrepareData(x, kernel.InputAt(1), {});
  auto input_y = PrepareData(y, kernel.InputAt(2), {});
  auto input_out_grad = PrepareData(out_grad, kernel.InputAt(3), {});

  auto kernel_out_0 = SetKernelOutput(kernel_backend, x_grad);
  auto kernel_out_1 = SetKernelOutput(kernel_backend, y_grad);
  phi::MetaTensor meta_out_0(kernel_out_0);
  phi::MetaTensor meta_out_1(kernel_out_1);

  phi::GeneralBinaryGradInferMeta(MakeMetaTensor(*input_x), MakeMetaTensor(*input_y), kernel_out_0 ? &meta_out_0 : nullptr, kernel_out_1 ? &meta_out_1 : nullptr);


  using kernel_signature = void(*)(const platform::DeviceContext&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, const phi::DenseTensor&, phi::DenseTensor*, phi::DenseTensor*);
  auto* kernel_fn = kernel.GetVariadicKernelFn<kernel_signature>();
  {
    paddle::platform::RecordEvent kernel_record_event("where_grad compute", paddle::platform::TracerEventType::OperatorInner, 1);
    (*kernel_fn)(*dev_ctx, *input_condition, *input_x, *input_y, *input_out_grad, kernel_out_0, kernel_out_1);
  }

  
}


}  // namespace experimental
}  // namespace paddle
