#include "paddle/fluid/eager/api/generated/fluid_generated/dygraph_forward_api.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/amp_utils.h"
#include "paddle/fluid/eager/amp_auto_cast.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"
#pragma GCC diagnostic ignored "-Wunused-variable"

paddle::experimental::Tensor log_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("log dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: log";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("log", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "log");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("log node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for log "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<logGradNodeCompat>(new logGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor log__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("log dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: log";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("log node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for log "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<logGradNodeCompat>(new logGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor conv_shift_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("conv_shift dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: conv_shift";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("conv_shift", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "conv_shift");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "conv_shift");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv_shift_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conv_shift", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("conv_shift node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for conv_shift "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<conv_shiftGradNodeCompat>(new conv_shiftGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor as_complex_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("as_complex dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: as_complex";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("as_complex", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "as_complex");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return as_complex_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("as_complex", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("as_complex node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for as_complex "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<as_complexGradNodeCompat>(new as_complexGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> smooth_l1_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& InsideWeight,const paddle::experimental::Tensor& OutsideWeight, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("smooth_l1_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: smooth_l1_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };
    if(InsideWeight.initialized()) amp_tensors_vector.push_back({ InsideWeight });
    if(OutsideWeight.initialized()) amp_tensors_vector.push_back({ OutsideWeight });

    auto amp_dst_dtype = egr::GetAmpDestDtype("smooth_l1_loss", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "smooth_l1_loss");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "smooth_l1_loss");
    auto NEW_InsideWeight = ((InsideWeight.initialized()) ? egr::AmpAutoCast("InsideWeight", InsideWeight, amp_dst_dtype, "smooth_l1_loss") : InsideWeight);
    auto NEW_OutsideWeight = ((OutsideWeight.initialized()) ? egr::AmpAutoCast("OutsideWeight", OutsideWeight, amp_dst_dtype, "smooth_l1_loss") : OutsideWeight);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return smooth_l1_loss_dygraph_function( NEW_X, NEW_Y, NEW_InsideWeight, NEW_OutsideWeight, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };
  if(InsideWeight.initialized()) ins["InsideWeight"] = egr::EagerUtils::TrySyncToVars(InsideWeight);
  if(OutsideWeight.initialized()) ins["OutsideWeight"] = egr::EagerUtils::TrySyncToVars(OutsideWeight);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Diff", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);
  egr::AutogradMeta* p_autograd_InsideWeight = egr::EagerUtils::nullable_autograd_meta(InsideWeight);
  egr::AutogradMeta* p_autograd_OutsideWeight = egr::EagerUtils::nullable_autograd_meta(OutsideWeight);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y, p_autograd_InsideWeight, p_autograd_OutsideWeight);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("smooth_l1_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Diff;
  egr::EagerUtils::GetOutput(outs["Diff"][0], &Diff);
  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("smooth_l1_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Diff = egr::EagerUtils::autograd_meta(&Diff);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for smooth_l1_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Diff, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<smooth_l1_lossGradNodeCompat>(new smooth_l1_lossGradNodeCompat(2, 4));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperDiff(Diff);
      grad_node->SetTensorWrapperInsideWeight(InsideWeight);
      grad_node->SetTensorWrapperOutsideWeight(OutsideWeight);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Diff, 0);
      grad_node->SetGradInMeta(Diff, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 1);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 1);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return std::make_tuple(Diff,Out);

}


paddle::experimental::Tensor linear_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("linear_interp_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: linear_interp_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("linear_interp_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "linear_interp_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return linear_interp_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("linear_interp_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("linear_interp_v2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for linear_interp_v2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<linear_interp_v2GradNodeCompat>(new linear_interp_v2GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> momentum_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Velocity,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* VelocityOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("momentum dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: momentum";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Param},{Grad},{Velocity},{LearningRate} };
    if(MasterParam.initialized()) amp_tensors_vector.push_back({ MasterParam });

    auto amp_dst_dtype = egr::GetAmpDestDtype("momentum", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCast("Param", Param, amp_dst_dtype, "momentum");
    auto NEW_Grad = egr::AmpAutoCast("Grad", Grad, amp_dst_dtype, "momentum");
    auto NEW_Velocity = egr::AmpAutoCast("Velocity", Velocity, amp_dst_dtype, "momentum");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "momentum");
    auto NEW_MasterParam = ((MasterParam.initialized()) ? egr::AmpAutoCast("MasterParam", MasterParam, amp_dst_dtype, "momentum") : MasterParam);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return momentum_dygraph_function( NEW_Param, NEW_Grad, NEW_Velocity, NEW_LearningRate, NEW_MasterParam, ParamOutVar, VelocityOutVar, MasterParamOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "Velocity", egr::EagerUtils::TrySyncToVars(Velocity) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) } };
  if(MasterParam.initialized()) ins["MasterParam"] = egr::EagerUtils::TrySyncToVars(MasterParam);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ParamOut", ins["Param"] },{ "VelocityOut", ins["Velocity"] } };

  if (ins.count("MasterParam")) outs["MasterParamOut"] = ins["MasterParam"];

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("momentum", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["ParamOut"][0], ParamOutVar);
  paddle::experimental::Tensor& ParamOut = *ParamOutVar;
  egr::EagerUtils::GetOutput(outs["VelocityOut"][0], VelocityOutVar);
  paddle::experimental::Tensor& VelocityOut = *VelocityOutVar;
  if (outs.count("MasterParamOut"))  egr::EagerUtils::GetOutput(outs["MasterParamOut"][0], MasterParamOutVar);
  paddle::experimental::Tensor& MasterParamOut = *MasterParamOutVar;


  return std::make_tuple(ParamOut,VelocityOut,MasterParamOut);

}


paddle::experimental::Tensor temporal_shift_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("temporal_shift dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: temporal_shift";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("temporal_shift", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "temporal_shift");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return temporal_shift_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("temporal_shift", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("temporal_shift node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for temporal_shift "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<temporal_shiftGradNodeCompat>(new temporal_shiftGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> nce_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& SampleWeight,const paddle::experimental::Tensor& CustomDistProbs,const paddle::experimental::Tensor& CustomDistAlias,const paddle::experimental::Tensor& CustomDistAliasProbs, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("nce dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: nce";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Label},{Weight} };
    if(Bias.initialized()) amp_tensors_vector.push_back({ Bias });
    if(SampleWeight.initialized()) amp_tensors_vector.push_back({ SampleWeight });
    if(CustomDistProbs.initialized()) amp_tensors_vector.push_back({ CustomDistProbs });
    if(CustomDistAlias.initialized()) amp_tensors_vector.push_back({ CustomDistAlias });
    if(CustomDistAliasProbs.initialized()) amp_tensors_vector.push_back({ CustomDistAliasProbs });

    auto amp_dst_dtype = egr::GetAmpDestDtype("nce", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "nce");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "nce");
    auto NEW_Weight = egr::AmpAutoCast("Weight", Weight, amp_dst_dtype, "nce");
    auto NEW_Bias = ((Bias.initialized()) ? egr::AmpAutoCast("Bias", Bias, amp_dst_dtype, "nce") : Bias);
    auto NEW_SampleWeight = ((SampleWeight.initialized()) ? egr::AmpAutoCast("SampleWeight", SampleWeight, amp_dst_dtype, "nce") : SampleWeight);
    auto NEW_CustomDistProbs = ((CustomDistProbs.initialized()) ? egr::AmpAutoCast("CustomDistProbs", CustomDistProbs, amp_dst_dtype, "nce") : CustomDistProbs);
    auto NEW_CustomDistAlias = ((CustomDistAlias.initialized()) ? egr::AmpAutoCast("CustomDistAlias", CustomDistAlias, amp_dst_dtype, "nce") : CustomDistAlias);
    auto NEW_CustomDistAliasProbs = ((CustomDistAliasProbs.initialized()) ? egr::AmpAutoCast("CustomDistAliasProbs", CustomDistAliasProbs, amp_dst_dtype, "nce") : CustomDistAliasProbs);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return nce_dygraph_function( NEW_Input, NEW_Label, NEW_Weight, NEW_Bias, NEW_SampleWeight, NEW_CustomDistProbs, NEW_CustomDistAlias, NEW_CustomDistAliasProbs, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) },{ "Weight", egr::EagerUtils::TrySyncToVars(Weight) } };
  if(Bias.initialized()) ins["Bias"] = egr::EagerUtils::TrySyncToVars(Bias);
  if(SampleWeight.initialized()) ins["SampleWeight"] = egr::EagerUtils::TrySyncToVars(SampleWeight);
  if(CustomDistProbs.initialized()) ins["CustomDistProbs"] = egr::EagerUtils::TrySyncToVars(CustomDistProbs);
  if(CustomDistAlias.initialized()) ins["CustomDistAlias"] = egr::EagerUtils::TrySyncToVars(CustomDistAlias);
  if(CustomDistAliasProbs.initialized()) ins["CustomDistAliasProbs"] = egr::EagerUtils::TrySyncToVars(CustomDistAliasProbs);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Cost", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SampleLogits", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SampleLabels", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);
  egr::AutogradMeta* p_autograd_Weight = egr::EagerUtils::nullable_autograd_meta(Weight);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);
  egr::AutogradMeta* p_autograd_SampleWeight = egr::EagerUtils::nullable_autograd_meta(SampleWeight);
  egr::AutogradMeta* p_autograd_CustomDistProbs = egr::EagerUtils::nullable_autograd_meta(CustomDistProbs);
  egr::AutogradMeta* p_autograd_CustomDistAlias = egr::EagerUtils::nullable_autograd_meta(CustomDistAlias);
  egr::AutogradMeta* p_autograd_CustomDistAliasProbs = egr::EagerUtils::nullable_autograd_meta(CustomDistAliasProbs);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Label, p_autograd_Weight, p_autograd_Bias, p_autograd_SampleWeight, p_autograd_CustomDistProbs, p_autograd_CustomDistAlias, p_autograd_CustomDistAliasProbs);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nce", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Cost;
  egr::EagerUtils::GetOutput(outs["Cost"][0], &Cost);
  paddle::experimental::Tensor SampleLogits;
  egr::EagerUtils::GetOutput(outs["SampleLogits"][0], &SampleLogits);
  paddle::experimental::Tensor SampleLabels;
  egr::EagerUtils::GetOutput(outs["SampleLabels"][0], &SampleLabels);

  {
    paddle::platform::RecordEvent node_creation_record_event("nce node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Cost = egr::EagerUtils::autograd_meta(&Cost);
    egr::AutogradMeta* p_autograd_SampleLogits = egr::EagerUtils::autograd_meta(&SampleLogits);
    egr::AutogradMeta* p_autograd_SampleLabels = egr::EagerUtils::autograd_meta(&SampleLabels);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for nce "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Cost, p_autograd_SampleLogits, p_autograd_SampleLabels);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<nceGradNodeCompat>(new nceGradNodeCompat(3, 8));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperCustomDistAlias(CustomDistAlias);
      grad_node->SetTensorWrapperCustomDistAliasProbs(CustomDistAliasProbs);
      grad_node->SetTensorWrapperCustomDistProbs(CustomDistProbs);
      grad_node->SetTensorWrapperInput(Input);
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperSampleLabels(SampleLabels);
      grad_node->SetTensorWrapperSampleLogits(SampleLogits);
      grad_node->SetTensorWrapperSampleWeight(SampleWeight);
      grad_node->SetTensorWrapperWeight(Weight);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Weight, 2);
      grad_node->SetGradOutMeta(Bias, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Cost, 0);
      egr::EagerUtils::SetHistory(p_autograd_Cost, grad_node);
      grad_node->SetGradInMeta(Cost, 0);
      egr::EagerUtils::CheckAndRetainGrad(Cost);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SampleLogits, 1);
      grad_node->SetGradInMeta(SampleLogits, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SampleLabels, 2);
      grad_node->SetGradInMeta(SampleLabels, 2);

    }
  }

  return std::make_tuple(Cost,SampleLogits,SampleLabels);

}


paddle::experimental::Tensor mv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Vec, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("mv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: mv";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Vec} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("mv", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "mv");
    auto NEW_Vec = egr::AmpAutoCast("Vec", Vec, amp_dst_dtype, "mv");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mv_dygraph_function( NEW_X, NEW_Vec, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Vec", egr::EagerUtils::TrySyncToVars(Vec) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Vec = egr::EagerUtils::nullable_autograd_meta(Vec);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Vec);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("mv node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for mv "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<mvGradNodeCompat>(new mvGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperVec(Vec);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Vec, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor global_scatter_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& local_count,const paddle::experimental::Tensor& global_count, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("global_scatter dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: global_scatter";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{local_count},{global_count} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("global_scatter", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "global_scatter");
    auto NEW_local_count = egr::AmpAutoCast("local_count", local_count, amp_dst_dtype, "global_scatter");
    auto NEW_global_count = egr::AmpAutoCast("global_count", global_count, amp_dst_dtype, "global_scatter");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return global_scatter_dygraph_function( NEW_X, NEW_local_count, NEW_global_count, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "local_count", egr::EagerUtils::TrySyncToVars(local_count) },{ "global_count", egr::EagerUtils::TrySyncToVars(global_count) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_local_count = egr::EagerUtils::nullable_autograd_meta(local_count);
  egr::AutogradMeta* p_autograd_global_count = egr::EagerUtils::nullable_autograd_meta(global_count);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_local_count, p_autograd_global_count);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("global_scatter", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("global_scatter node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for global_scatter "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<global_scatterGradNodeCompat>(new global_scatterGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperglobal_count(global_count);
      grad_node->SetTensorWrapperlocal_count(local_count);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> dropout_nd_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("dropout_nd dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: dropout_nd";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("dropout_nd", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "dropout_nd");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dropout_nd_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Mask", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dropout_nd", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Mask;
  egr::EagerUtils::GetOutput(outs["Mask"][0], &Mask);

  {
    paddle::platform::RecordEvent node_creation_record_event("dropout_nd node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Mask = egr::EagerUtils::autograd_meta(&Mask);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for dropout_nd "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Mask);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<dropout_ndGradNodeCompat>(new dropout_ndGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMask(Mask);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Mask, 1);
      grad_node->SetGradInMeta(Mask, 1);

    }
  }

  return std::make_tuple(Out,Mask);

}


paddle::experimental::Tensor proximal_gd_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("proximal_gd dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: proximal_gd";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Param},{Grad},{LearningRate} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("proximal_gd", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCast("Param", Param, amp_dst_dtype, "proximal_gd");
    auto NEW_Grad = egr::AmpAutoCast("Grad", Grad, amp_dst_dtype, "proximal_gd");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "proximal_gd");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return proximal_gd_dygraph_function( NEW_Param, NEW_Grad, NEW_LearningRate, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ParamOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("proximal_gd", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor ParamOut;
  egr::EagerUtils::GetOutput(outs["ParamOut"][0], &ParamOut);


  return ParamOut;

}


paddle::experimental::Tensor memcpy_h2d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("memcpy_h2d dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: memcpy_h2d";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("memcpy_h2d", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "memcpy_h2d");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return memcpy_h2d_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("memcpy_h2d", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor add_position_encoding_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("add_position_encoding dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: add_position_encoding";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("add_position_encoding", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "add_position_encoding");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return add_position_encoding_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("add_position_encoding", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("add_position_encoding node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for add_position_encoding "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<add_position_encodingGradNodeCompat>(new add_position_encodingGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor cosh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cosh dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cosh";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cosh", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cosh");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cosh_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cosh", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("cosh node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cosh "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<coshGradNodeCompat>(new coshGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor hash_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("hash dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: hash";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("hash", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "hash");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return hash_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("hash", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor grad_add_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("grad_add dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: grad_add";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("grad_add", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "grad_add");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "grad_add");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return grad_add_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("grad_add", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor sign_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sign dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sign";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sign", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sign");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sign_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sign", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("sign node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sign "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<signGradNodeCompat>(new signGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor prelu_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Alpha, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("prelu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: prelu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Alpha} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("prelu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "prelu");
    auto NEW_Alpha = egr::AmpAutoCast("Alpha", Alpha, amp_dst_dtype, "prelu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return prelu_dygraph_function( NEW_X, NEW_Alpha, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Alpha", egr::EagerUtils::TrySyncToVars(Alpha) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Alpha = egr::EagerUtils::nullable_autograd_meta(Alpha);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Alpha);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("prelu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("prelu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for prelu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<preluGradNodeCompat>(new preluGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperAlpha(Alpha);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Alpha, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor linspace_dygraph_function(const paddle::experimental::Tensor& Start,const paddle::experimental::Tensor& Stop,const paddle::experimental::Tensor& Num, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("linspace dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: linspace";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Start},{Stop},{Num} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("linspace", amp_tensors_vector);

    auto NEW_Start = egr::AmpAutoCast("Start", Start, amp_dst_dtype, "linspace");
    auto NEW_Stop = egr::AmpAutoCast("Stop", Stop, amp_dst_dtype, "linspace");
    auto NEW_Num = egr::AmpAutoCast("Num", Num, amp_dst_dtype, "linspace");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return linspace_dygraph_function( NEW_Start, NEW_Stop, NEW_Num, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Start", egr::EagerUtils::TrySyncToVars(Start) },{ "Stop", egr::EagerUtils::TrySyncToVars(Stop) },{ "Num", egr::EagerUtils::TrySyncToVars(Num) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("linspace", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor fill_diagonal_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_diagonal dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_diagonal";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fill_diagonal", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fill_diagonal");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_diagonal_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_diagonal", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("fill_diagonal node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fill_diagonal "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fill_diagonalGradNodeCompat>(new fill_diagonalGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fill_diagonal__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_diagonal dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_diagonal";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_diagonal", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("fill_diagonal node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fill_diagonal "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fill_diagonalGradNodeCompat>(new fill_diagonalGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor logsigmoid_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("logsigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: logsigmoid";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("logsigmoid", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "logsigmoid");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logsigmoid_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("logsigmoid", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("logsigmoid node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for logsigmoid "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<logsigmoidGradNodeCompat>(new logsigmoidGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::vector<paddle::experimental::Tensor> load_combine_dygraph_function( size_t OutNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("load_combine dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: load_combine";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return load_combine_dygraph_function( OutNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::CreateVars(OutNum) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("load_combine", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], &Out);


  return Out;

}


paddle::experimental::Tensor fetch_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fetch_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fetch_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fetch_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fetch_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fetch_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fetch_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor randperm_dygraph_function( const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("randperm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: randperm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return randperm_dygraph_function( attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("randperm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor sequence_scatter_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Updates, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sequence_scatter dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sequence_scatter";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Ids},{Updates} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sequence_scatter", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sequence_scatter");
    auto NEW_Ids = egr::AmpAutoCast("Ids", Ids, amp_dst_dtype, "sequence_scatter");
    auto NEW_Updates = egr::AmpAutoCast("Updates", Updates, amp_dst_dtype, "sequence_scatter");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sequence_scatter_dygraph_function( NEW_X, NEW_Ids, NEW_Updates, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Ids", egr::EagerUtils::TrySyncToVars(Ids) },{ "Updates", egr::EagerUtils::TrySyncToVars(Updates) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Ids = egr::EagerUtils::nullable_autograd_meta(Ids);
  egr::AutogradMeta* p_autograd_Updates = egr::EagerUtils::nullable_autograd_meta(Updates);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Ids, p_autograd_Updates);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_scatter", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("sequence_scatter node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sequence_scatter "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sequence_scatterGradNodeCompat>(new sequence_scatterGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIds(Ids);
      grad_node->SetTensorWrapperUpdates(Updates);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Updates, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor relu6_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("relu6 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: relu6";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("relu6", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "relu6");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return relu6_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("relu6", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("relu6 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for relu6 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<relu6GradNodeCompat>(new relu6GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor relu6__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("relu6 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: relu6";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("relu6", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("relu6 node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for relu6 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<relu6GradNodeCompat>(new relu6GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor partial_sum_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("partial_sum dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: partial_sum";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X };

    auto amp_dst_dtype = egr::GetAmpDestDtype("partial_sum", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "partial_sum");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return partial_sum_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  std::vector<egr::AutogradMeta*> p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, &p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("partial_sum", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("partial_sum node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for partial_sum "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<partial_sumGradNodeCompat>(new partial_sumGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor partial_allgather_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("partial_allgather dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: partial_allgather";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("partial_allgather", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "partial_allgather");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return partial_allgather_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("partial_allgather", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor partial_allgather__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("partial_allgather dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: partial_allgather";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("partial_allgather", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";


  return X;

}


paddle::experimental::Tensor c_scatter_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_scatter dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_scatter";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_scatter", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_scatter");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_scatter_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_scatter", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor alltoall_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("alltoall dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: alltoall";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("alltoall", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "alltoall");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return alltoall_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("alltoall", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("alltoall node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for alltoall "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<alltoallGradNodeCompat>(new alltoallGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor alltoall__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("alltoall dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: alltoall";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("alltoall", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("alltoall node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for alltoall "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<alltoallGradNodeCompat>(new alltoallGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor conv3d_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("conv3d dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: conv3d";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("conv3d", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "conv3d");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "conv3d");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv3d_dygraph_function( NEW_Input, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Filter = egr::EagerUtils::nullable_autograd_meta(Filter);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Filter);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conv3d", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);

  {
    paddle::platform::RecordEvent node_creation_record_event("conv3d node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Output = egr::EagerUtils::autograd_meta(&Output);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for conv3d "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Output);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<conv3dGradNodeCompat>(new conv3dGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperFilter(Filter);
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Filter, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Output, 0);
      egr::EagerUtils::SetHistory(p_autograd_Output, grad_node);
      grad_node->SetGradInMeta(Output, 0);
      egr::EagerUtils::CheckAndRetainGrad(Output);

    }
  }

  return Output;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu_unpack_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Pivots, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lu_unpack dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lu_unpack";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Pivots} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lu_unpack", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "lu_unpack");
    auto NEW_Pivots = egr::AmpAutoCast("Pivots", Pivots, amp_dst_dtype, "lu_unpack");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lu_unpack_dygraph_function( NEW_X, NEW_Pivots, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Pivots", egr::EagerUtils::TrySyncToVars(Pivots) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Pmat", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "L", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "U", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Pivots = egr::EagerUtils::nullable_autograd_meta(Pivots);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Pivots);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lu_unpack", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Pmat;
  egr::EagerUtils::GetOutput(outs["Pmat"][0], &Pmat);
  paddle::experimental::Tensor L;
  egr::EagerUtils::GetOutput(outs["L"][0], &L);
  paddle::experimental::Tensor U;
  egr::EagerUtils::GetOutput(outs["U"][0], &U);

  {
    paddle::platform::RecordEvent node_creation_record_event("lu_unpack node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Pmat = egr::EagerUtils::autograd_meta(&Pmat);
    egr::AutogradMeta* p_autograd_L = egr::EagerUtils::autograd_meta(&L);
    egr::AutogradMeta* p_autograd_U = egr::EagerUtils::autograd_meta(&U);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for lu_unpack "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Pmat, p_autograd_L, p_autograd_U);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<lu_unpackGradNodeCompat>(new lu_unpackGradNodeCompat(3, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperL(L);
      grad_node->SetTensorWrapperPivots(Pivots);
      grad_node->SetTensorWrapperPmat(Pmat);
      grad_node->SetTensorWrapperU(U);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Pmat, 0);
      egr::EagerUtils::SetHistory(p_autograd_Pmat, grad_node);
      grad_node->SetGradInMeta(Pmat, 0);
      egr::EagerUtils::CheckAndRetainGrad(Pmat);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_L, 1);
      egr::EagerUtils::SetHistory(p_autograd_L, grad_node);
      grad_node->SetGradInMeta(L, 1);
      egr::EagerUtils::CheckAndRetainGrad(L);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_U, 2);
      egr::EagerUtils::SetHistory(p_autograd_U, grad_node);
      grad_node->SetGradInMeta(U, 2);
      egr::EagerUtils::CheckAndRetainGrad(U);

    }
  }

  return std::make_tuple(Pmat,L,U);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> lstm_unit_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& C_prev, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lstm_unit dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lstm_unit";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{C_prev} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lstm_unit", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "lstm_unit");
    auto NEW_C_prev = egr::AmpAutoCast("C_prev", C_prev, amp_dst_dtype, "lstm_unit");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lstm_unit_dygraph_function( NEW_X, NEW_C_prev, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "C_prev", egr::EagerUtils::TrySyncToVars(C_prev) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "C", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "H", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_C_prev = egr::EagerUtils::nullable_autograd_meta(C_prev);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_C_prev);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lstm_unit", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor C;
  egr::EagerUtils::GetOutput(outs["C"][0], &C);
  paddle::experimental::Tensor H;
  egr::EagerUtils::GetOutput(outs["H"][0], &H);

  {
    paddle::platform::RecordEvent node_creation_record_event("lstm_unit node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_C = egr::EagerUtils::autograd_meta(&C);
    egr::AutogradMeta* p_autograd_H = egr::EagerUtils::autograd_meta(&H);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for lstm_unit "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_C, p_autograd_H);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<lstm_unitGradNodeCompat>(new lstm_unitGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperC(C);
      grad_node->SetTensorWrapperC_prev(C_prev);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(C_prev, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_C, 0);
      egr::EagerUtils::SetHistory(p_autograd_C, grad_node);
      grad_node->SetGradInMeta(C, 0);
      egr::EagerUtils::CheckAndRetainGrad(C);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_H, 1);
      egr::EagerUtils::SetHistory(p_autograd_H, grad_node);
      grad_node->SetGradInMeta(H, 1);
      egr::EagerUtils::CheckAndRetainGrad(H);

    }
  }

  return std::make_tuple(C,H);

}


paddle::experimental::Tensor not_equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("not_equal dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: not_equal";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("not_equal", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "not_equal");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "not_equal");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return not_equal_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("not_equal", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> transpose2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("transpose2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: transpose2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("transpose2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "transpose2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return transpose2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("transpose2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("transpose2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for transpose2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<transpose2GradNodeCompat>(new transpose2GradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(Out,XShape);

}


std::vector<paddle::experimental::Tensor> c_sync_comm_stream_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, std::vector<paddle::experimental::Tensor*>& OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_sync_comm_stream dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_sync_comm_stream";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_sync_comm_stream", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "c_sync_comm_stream");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_sync_comm_stream_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_sync_comm_stream", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], OutVar);
  egr::EagerUtils::Output2Result(OutVar, &Out);


  return Out;

}


paddle::experimental::Tensor uniform_random_batch_size_like_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("uniform_random_batch_size_like dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: uniform_random_batch_size_like";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("uniform_random_batch_size_like", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "uniform_random_batch_size_like");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return uniform_random_batch_size_like_dygraph_function( NEW_Input, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("uniform_random_batch_size_like", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor yolo_box_head_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("yolo_box_head dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: yolo_box_head";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("yolo_box_head", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "yolo_box_head");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return yolo_box_head_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("yolo_box_head", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor unfold_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("unfold dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: unfold";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("unfold", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "unfold");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unfold_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("unfold", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);

  {
    paddle::platform::RecordEvent node_creation_record_event("unfold node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for unfold "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<unfoldGradNodeCompat>(new unfoldGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);

    }
  }

  return Y;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> lrn_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lrn dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lrn";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lrn", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "lrn");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lrn_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "MidOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lrn", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor MidOut;
  egr::EagerUtils::GetOutput(outs["MidOut"][0], &MidOut);

  {
    paddle::platform::RecordEvent node_creation_record_event("lrn node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_MidOut = egr::EagerUtils::autograd_meta(&MidOut);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for lrn "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_MidOut);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<lrnGradNodeCompat>(new lrnGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMidOut(MidOut);
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_MidOut, 1);
      egr::EagerUtils::SetHistory(p_autograd_MidOut, grad_node);
      grad_node->SetGradInMeta(MidOut, 1);
      egr::EagerUtils::CheckAndRetainGrad(MidOut);

    }
  }

  return std::make_tuple(Out,MidOut);

}


paddle::experimental::Tensor isclose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Other, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("isclose dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: isclose";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Other} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("isclose", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "isclose");
    auto NEW_Other = egr::AmpAutoCast("Other", Other, amp_dst_dtype, "isclose");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return isclose_dygraph_function( NEW_Input, NEW_Other, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Other", egr::EagerUtils::TrySyncToVars(Other) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("isclose", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> softmax_with_cross_entropy_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax_with_cross_entropy dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: softmax_with_cross_entropy";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Logits},{Label} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("softmax_with_cross_entropy", amp_tensors_vector);

    auto NEW_Logits = egr::AmpAutoCast("Logits", Logits, amp_dst_dtype, "softmax_with_cross_entropy");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "softmax_with_cross_entropy");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return softmax_with_cross_entropy_dygraph_function( NEW_Logits, NEW_Label, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Logits", egr::EagerUtils::TrySyncToVars(Logits) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Softmax", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Loss", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Logits = egr::EagerUtils::nullable_autograd_meta(Logits);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Logits, p_autograd_Label);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softmax_with_cross_entropy", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Softmax;
  egr::EagerUtils::GetOutput(outs["Softmax"][0], &Softmax);
  paddle::experimental::Tensor Loss;
  egr::EagerUtils::GetOutput(outs["Loss"][0], &Loss);

  {
    paddle::platform::RecordEvent node_creation_record_event("softmax_with_cross_entropy node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Softmax = egr::EagerUtils::autograd_meta(&Softmax);
    egr::AutogradMeta* p_autograd_Loss = egr::EagerUtils::autograd_meta(&Loss);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for softmax_with_cross_entropy "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Softmax, p_autograd_Loss);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<softmax_with_cross_entropyGradNodeCompat>(new softmax_with_cross_entropyGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperSoftmax(Softmax);

      grad_node->SetGradOutMeta(Logits, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Softmax, 0);
      grad_node->SetGradInMeta(Softmax, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Loss, 1);
      egr::EagerUtils::SetHistory(p_autograd_Loss, grad_node);
      grad_node->SetGradInMeta(Loss, 1);
      egr::EagerUtils::CheckAndRetainGrad(Loss);

    }
  }

  return std::make_tuple(Softmax,Loss);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> softmax_with_cross_entropy__dygraph_function(paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax_with_cross_entropy dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: softmax_with_cross_entropy";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Logits", egr::EagerUtils::TrySyncToVars(Logits) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Softmax", ins["Logits"] },{ "Loss", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Logits = egr::EagerUtils::nullable_autograd_meta(Logits);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Logits, p_autograd_Label);
  // Check Inplace
  egr::EagerUtils::CheckInplace(Logits, p_autograd_Logits, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softmax_with_cross_entropy", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"Logits", "Softmax"}});

  egr::EagerUtils::GetOutput(outs["Softmax"][0], &Logits);
  Logits.bump_inplace_version();
  VLOG(3) << "Tensor(" << Logits.name() << ") uses Inplace Strategy.";
  paddle::experimental::Tensor Loss;
  egr::EagerUtils::GetOutput(outs["Loss"][0], &Loss);

  {
    paddle::platform::RecordEvent node_creation_record_event("softmax_with_cross_entropy node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_Logits = egr::EagerUtils::autograd_meta(&Logits);
    egr::AutogradMeta* p_autograd_Loss = egr::EagerUtils::autograd_meta(&Loss);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for softmax_with_cross_entropy "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Logits, p_autograd_Loss);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<softmax_with_cross_entropyGradNodeCompat>(new softmax_with_cross_entropyGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperSoftmax(Logits);

      grad_node->SetGradOutMeta(Logits, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Logits, 0);
      grad_node->SetGradInMeta(Logits, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Loss, 1);
      egr::EagerUtils::SetHistory(p_autograd_Loss, grad_node);
      grad_node->SetGradInMeta(Loss, 1);
      egr::EagerUtils::CheckAndRetainGrad(Loss);

    }
  }

  return std::make_tuple(Logits,Loss);

}


paddle::experimental::Tensor isfinite_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("isfinite_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: isfinite_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("isfinite_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "isfinite_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return isfinite_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("isfinite_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor bernoulli_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("bernoulli dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: bernoulli";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("bernoulli", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "bernoulli");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return bernoulli_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bernoulli", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> max_pool3d_with_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("max_pool3d_with_index dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: max_pool3d_with_index";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("max_pool3d_with_index", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "max_pool3d_with_index");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return max_pool3d_with_index_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Mask", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("max_pool3d_with_index", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Mask;
  egr::EagerUtils::GetOutput(outs["Mask"][0], &Mask);

  {
    paddle::platform::RecordEvent node_creation_record_event("max_pool3d_with_index node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Mask = egr::EagerUtils::autograd_meta(&Mask);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for max_pool3d_with_index "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Mask);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<max_pool3d_with_indexGradNodeCompat>(new max_pool3d_with_indexGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMask(Mask);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Mask, 1);
      egr::EagerUtils::SetHistory(p_autograd_Mask, grad_node);
      grad_node->SetGradInMeta(Mask, 1);
      egr::EagerUtils::CheckAndRetainGrad(Mask);

    }
  }

  return std::make_tuple(Out,Mask);

}


std::vector<paddle::experimental::Tensor> fused_seqpool_cvm_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& CVM, size_t OutNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fused_seqpool_cvm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fused_seqpool_cvm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X,{CVM} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fused_seqpool_cvm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "fused_seqpool_cvm");
    auto NEW_CVM = egr::AmpAutoCast("CVM", CVM, amp_dst_dtype, "fused_seqpool_cvm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fused_seqpool_cvm_dygraph_function( NEW_X, NEW_CVM, OutNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "CVM", egr::EagerUtils::TrySyncToVars(CVM) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::CreateVars(OutNum) } };


  // Prepare Autograd Meta 
  std::vector<egr::AutogradMeta*> p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_CVM = egr::EagerUtils::nullable_autograd_meta(CVM);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, &p_autograd_X, p_autograd_CVM);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fused_seqpool_cvm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("fused_seqpool_cvm node_creation", paddle::platform::TracerEventType::Operator, 1);
    std::vector<egr::AutogradMeta*> p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fused_seqpool_cvm "; 
      egr::EagerUtils::PassStopGradient(false, &p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fused_seqpool_cvmGradNodeCompat>(new fused_seqpool_cvmGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperCVM(CVM);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(CVM, 1);
      egr::EagerUtils::SetOutRankWithSlot(&p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(&p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor gaussian_random_dygraph_function( const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("gaussian_random dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: gaussian_random";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gaussian_random_dygraph_function( attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gaussian_random", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: flatten2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("flatten2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "flatten2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return flatten2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("flatten2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for flatten2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<flatten2GradNodeCompat>(new flatten2GradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(Out,XShape);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten2__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: flatten2";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] },{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("flatten2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for flatten2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<flatten2GradNodeCompat>(new flatten2GradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(X,XShape);

}


paddle::experimental::Tensor matmul_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("matmul dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: matmul";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("matmul", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "matmul");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "matmul");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return matmul_dygraph_function( NEW_X, NEW_Y, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("matmul", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;

  {
    paddle::platform::RecordEvent node_creation_record_event("matmul node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for matmul "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<matmulGradNodeCompat>(new matmulGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor cvm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& CVM, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cvm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cvm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{CVM} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cvm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cvm");
    auto NEW_CVM = egr::AmpAutoCast("CVM", CVM, amp_dst_dtype, "cvm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cvm_dygraph_function( NEW_X, NEW_CVM, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "CVM", egr::EagerUtils::TrySyncToVars(CVM) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_CVM = egr::EagerUtils::nullable_autograd_meta(CVM);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_CVM);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cvm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);

  {
    paddle::platform::RecordEvent node_creation_record_event("cvm node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cvm "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<cvmGradNodeCompat>(new cvmGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperCVM(CVM);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);

    }
  }

  return Y;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> adamax_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& InfNorm,const paddle::experimental::Tensor& Beta1Pow, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MomentOutVar, paddle::experimental::Tensor* InfNormOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("adamax dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: adamax";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Param},{Grad},{LearningRate},{Moment},{InfNorm},{Beta1Pow} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("adamax", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCast("Param", Param, amp_dst_dtype, "adamax");
    auto NEW_Grad = egr::AmpAutoCast("Grad", Grad, amp_dst_dtype, "adamax");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "adamax");
    auto NEW_Moment = egr::AmpAutoCast("Moment", Moment, amp_dst_dtype, "adamax");
    auto NEW_InfNorm = egr::AmpAutoCast("InfNorm", InfNorm, amp_dst_dtype, "adamax");
    auto NEW_Beta1Pow = egr::AmpAutoCast("Beta1Pow", Beta1Pow, amp_dst_dtype, "adamax");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return adamax_dygraph_function( NEW_Param, NEW_Grad, NEW_LearningRate, NEW_Moment, NEW_InfNorm, NEW_Beta1Pow, ParamOutVar, MomentOutVar, InfNormOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) },{ "Moment", egr::EagerUtils::TrySyncToVars(Moment) },{ "InfNorm", egr::EagerUtils::TrySyncToVars(InfNorm) },{ "Beta1Pow", egr::EagerUtils::TrySyncToVars(Beta1Pow) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ParamOut", ins["Param"] },{ "MomentOut", ins["Moment"] },{ "InfNormOut", ins["InfNorm"] } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("adamax", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["ParamOut"][0], ParamOutVar);
  paddle::experimental::Tensor& ParamOut = *ParamOutVar;
  egr::EagerUtils::GetOutput(outs["MomentOut"][0], MomentOutVar);
  paddle::experimental::Tensor& MomentOut = *MomentOutVar;
  egr::EagerUtils::GetOutput(outs["InfNormOut"][0], InfNormOutVar);
  paddle::experimental::Tensor& InfNormOut = *InfNormOutVar;


  return std::make_tuple(ParamOut,MomentOut,InfNormOut);

}


paddle::experimental::Tensor recv_v2_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("recv_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: recv_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return recv_v2_dygraph_function( OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("recv_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor masked_select_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Mask, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("masked_select dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: masked_select";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Mask} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("masked_select", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "masked_select");
    auto NEW_Mask = egr::AmpAutoCast("Mask", Mask, amp_dst_dtype, "masked_select");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return masked_select_dygraph_function( NEW_X, NEW_Mask, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Mask", egr::EagerUtils::TrySyncToVars(Mask) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Mask = egr::EagerUtils::nullable_autograd_meta(Mask);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Mask);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("masked_select", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);

  {
    paddle::platform::RecordEvent node_creation_record_event("masked_select node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for masked_select "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<masked_selectGradNodeCompat>(new masked_selectGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMask(Mask);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);

    }
  }

  return Y;

}


paddle::experimental::Tensor range_dygraph_function(const paddle::experimental::Tensor& Start,const paddle::experimental::Tensor& End,const paddle::experimental::Tensor& Step, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("range dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: range";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Start},{End},{Step} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("range", amp_tensors_vector);

    auto NEW_Start = egr::AmpAutoCast("Start", Start, amp_dst_dtype, "range");
    auto NEW_End = egr::AmpAutoCast("End", End, amp_dst_dtype, "range");
    auto NEW_Step = egr::AmpAutoCast("Step", Step, amp_dst_dtype, "range");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return range_dygraph_function( NEW_Start, NEW_End, NEW_Step, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Start", egr::EagerUtils::TrySyncToVars(Start) },{ "End", egr::EagerUtils::TrySyncToVars(End) },{ "Step", egr::EagerUtils::TrySyncToVars(Step) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("range", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor bitwise_not_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("bitwise_not dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: bitwise_not";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("bitwise_not", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "bitwise_not");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return bitwise_not_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bitwise_not", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor trace_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("trace dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: trace";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("trace", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "trace");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return trace_dygraph_function( NEW_Input, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("trace", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("trace node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for trace "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<traceGradNodeCompat>(new traceGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor multinomial_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("multinomial dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: multinomial";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("multinomial", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "multinomial");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multinomial_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("multinomial", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> modified_huber_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("modified_huber_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: modified_huber_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("modified_huber_loss", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "modified_huber_loss");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "modified_huber_loss");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return modified_huber_loss_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "IntermediateVal", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("modified_huber_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor IntermediateVal;
  egr::EagerUtils::GetOutput(outs["IntermediateVal"][0], &IntermediateVal);
  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("modified_huber_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_IntermediateVal = egr::EagerUtils::autograd_meta(&IntermediateVal);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for modified_huber_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_IntermediateVal, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<modified_huber_lossGradNodeCompat>(new modified_huber_lossGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIntermediateVal(IntermediateVal);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_IntermediateVal, 0);
      grad_node->SetGradInMeta(IntermediateVal, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 1);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 1);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return std::make_tuple(IntermediateVal,Out);

}


paddle::experimental::Tensor c_reduce_prod_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_reduce_prod dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_reduce_prod";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_reduce_prod", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_reduce_prod");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_reduce_prod_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_reduce_prod", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor roll_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("roll dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: roll";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("roll", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "roll");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return roll_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("roll", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("roll node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for roll "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<rollGradNodeCompat>(new rollGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squared_l2_distance_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("squared_l2_distance dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: squared_l2_distance";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("squared_l2_distance", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "squared_l2_distance");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "squared_l2_distance");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return squared_l2_distance_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "sub_result", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squared_l2_distance", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor sub_result;
  egr::EagerUtils::GetOutput(outs["sub_result"][0], &sub_result);
  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("squared_l2_distance node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_sub_result = egr::EagerUtils::autograd_meta(&sub_result);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for squared_l2_distance "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_sub_result, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squared_l2_distanceGradNodeCompat>(new squared_l2_distanceGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);
      grad_node->SetTensorWrappersub_result(sub_result);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_sub_result, 0);
      grad_node->SetGradInMeta(sub_result, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 1);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 1);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return std::make_tuple(sub_result,Out);

}


paddle::experimental::Tensor conv3d_transpose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("conv3d_transpose dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: conv3d_transpose";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("conv3d_transpose", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "conv3d_transpose");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "conv3d_transpose");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv3d_transpose_dygraph_function( NEW_Input, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Filter = egr::EagerUtils::nullable_autograd_meta(Filter);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Filter);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conv3d_transpose", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);

  {
    paddle::platform::RecordEvent node_creation_record_event("conv3d_transpose node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Output = egr::EagerUtils::autograd_meta(&Output);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for conv3d_transpose "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Output);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<conv3d_transposeGradNodeCompat>(new conv3d_transposeGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperFilter(Filter);
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Filter, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Output, 0);
      egr::EagerUtils::SetHistory(p_autograd_Output, grad_node);
      grad_node->SetGradInMeta(Output, 0);
      egr::EagerUtils::CheckAndRetainGrad(Output);

    }
  }

  return Output;

}


paddle::experimental::Tensor share_data_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("share_data dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: share_data";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("share_data", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "share_data");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return share_data_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("share_data", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fake_quantize_abs_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fake_quantize_abs_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fake_quantize_abs_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fake_quantize_abs_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fake_quantize_abs_max_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "OutScale", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fake_quantize_abs_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor OutScale;
  egr::EagerUtils::GetOutput(outs["OutScale"][0], &OutScale);


  return std::make_tuple(Out,OutScale);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> rrelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("rrelu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: rrelu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("rrelu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "rrelu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return rrelu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Noise", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("rrelu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Noise;
  egr::EagerUtils::GetOutput(outs["Noise"][0], &Noise);

  {
    paddle::platform::RecordEvent node_creation_record_event("rrelu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Noise = egr::EagerUtils::autograd_meta(&Noise);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for rrelu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Noise);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<rreluGradNodeCompat>(new rreluGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperNoise(Noise);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Noise, 1);
      grad_node->SetGradInMeta(Noise, 1);

    }
  }

  return std::make_tuple(Out,Noise);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> unique_with_counts_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("unique_with_counts dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: unique_with_counts";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("unique_with_counts", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "unique_with_counts");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unique_with_counts_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Index", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Count", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("unique_with_counts", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Index;
  egr::EagerUtils::GetOutput(outs["Index"][0], &Index);
  paddle::experimental::Tensor Count;
  egr::EagerUtils::GetOutput(outs["Count"][0], &Count);


  return std::make_tuple(Out,Index,Count);

}


paddle::experimental::Tensor fill_dygraph_function( const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_dygraph_function( attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("concat dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: concat";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X };

    auto amp_dst_dtype = egr::GetAmpDestDtype("concat", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "concat");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return concat_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  // Prepare Autograd Meta 
  std::vector<egr::AutogradMeta*> p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, &p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("concat", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;

  {
    paddle::platform::RecordEvent node_creation_record_event("concat node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for concat "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<concatGradNodeCompat>(new concatGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fill_zeros_like_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_zeros_like dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_zeros_like";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fill_zeros_like", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fill_zeros_like");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_zeros_like_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_zeros_like", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> hierarchical_sigmoid_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& PathTable,const paddle::experimental::Tensor& PathCode,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("hierarchical_sigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: hierarchical_sigmoid";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{W},{Label} };
    if(PathTable.initialized()) amp_tensors_vector.push_back({ PathTable });
    if(PathCode.initialized()) amp_tensors_vector.push_back({ PathCode });
    if(Bias.initialized()) amp_tensors_vector.push_back({ Bias });

    auto amp_dst_dtype = egr::GetAmpDestDtype("hierarchical_sigmoid", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "hierarchical_sigmoid");
    auto NEW_W = egr::AmpAutoCast("W", W, amp_dst_dtype, "hierarchical_sigmoid");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "hierarchical_sigmoid");
    auto NEW_PathTable = ((PathTable.initialized()) ? egr::AmpAutoCast("PathTable", PathTable, amp_dst_dtype, "hierarchical_sigmoid") : PathTable);
    auto NEW_PathCode = ((PathCode.initialized()) ? egr::AmpAutoCast("PathCode", PathCode, amp_dst_dtype, "hierarchical_sigmoid") : PathCode);
    auto NEW_Bias = ((Bias.initialized()) ? egr::AmpAutoCast("Bias", Bias, amp_dst_dtype, "hierarchical_sigmoid") : Bias);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return hierarchical_sigmoid_dygraph_function( NEW_X, NEW_W, NEW_Label, NEW_PathTable, NEW_PathCode, NEW_Bias, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "W", egr::EagerUtils::TrySyncToVars(W) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };
  if(PathTable.initialized()) ins["PathTable"] = egr::EagerUtils::TrySyncToVars(PathTable);
  if(PathCode.initialized()) ins["PathCode"] = egr::EagerUtils::TrySyncToVars(PathCode);
  if(Bias.initialized()) ins["Bias"] = egr::EagerUtils::TrySyncToVars(Bias);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "PreOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "W_Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_W = egr::EagerUtils::nullable_autograd_meta(W);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);
  egr::AutogradMeta* p_autograd_PathTable = egr::EagerUtils::nullable_autograd_meta(PathTable);
  egr::AutogradMeta* p_autograd_PathCode = egr::EagerUtils::nullable_autograd_meta(PathCode);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_W, p_autograd_Label, p_autograd_PathTable, p_autograd_PathCode, p_autograd_Bias);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("hierarchical_sigmoid", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor PreOut;
  egr::EagerUtils::GetOutput(outs["PreOut"][0], &PreOut);
  paddle::experimental::Tensor W_Out;
  egr::EagerUtils::GetOutput(outs["W_Out"][0], &W_Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("hierarchical_sigmoid node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_PreOut = egr::EagerUtils::autograd_meta(&PreOut);
    egr::AutogradMeta* p_autograd_W_Out = egr::EagerUtils::autograd_meta(&W_Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for hierarchical_sigmoid "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_PreOut, p_autograd_W_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<hierarchical_sigmoidGradNodeCompat>(new hierarchical_sigmoidGradNodeCompat(3, 6));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperPathCode(PathCode);
      grad_node->SetTensorWrapperPathTable(PathTable);
      grad_node->SetTensorWrapperPreOut(PreOut);
      grad_node->SetTensorWrapperW(W);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(W, 1);
      grad_node->SetGradOutMeta(Bias, 5);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_PreOut, 1);
      grad_node->SetGradInMeta(PreOut, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_W_Out, 2);
      grad_node->SetGradInMeta(W_Out, 2);

    }
  }

  return std::make_tuple(Out,PreOut,W_Out);

}


paddle::experimental::Tensor isinf_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("isinf_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: isinf_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("isinf_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "isinf_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return isinf_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("isinf_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor squeeze_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("squeeze dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: squeeze";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("squeeze", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "squeeze");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return squeeze_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squeeze", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("squeeze node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for squeeze "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squeezeGradNodeCompat>(new squeezeGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> multiclass_nms2_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("multiclass_nms2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: multiclass_nms2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {BBoxes},{Scores} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("multiclass_nms2", amp_tensors_vector);

    auto NEW_BBoxes = egr::AmpAutoCast("BBoxes", BBoxes, amp_dst_dtype, "multiclass_nms2");
    auto NEW_Scores = egr::AmpAutoCast("Scores", Scores, amp_dst_dtype, "multiclass_nms2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return multiclass_nms2_dygraph_function( NEW_BBoxes, NEW_Scores, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "BBoxes", egr::EagerUtils::TrySyncToVars(BBoxes) },{ "Scores", egr::EagerUtils::TrySyncToVars(Scores) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Index", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("multiclass_nms2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Index;
  egr::EagerUtils::GetOutput(outs["Index"][0], &Index);


  return std::make_tuple(Out,Index);

}



