
#pragma once
#include "glog/logging.h"
#include "paddle/fluid/eager/autograd_meta.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/to_static/run_program_op_func.h"
#include "paddle/fluid/eager/api/manual/eager_manual/dygraph_forward_api.h"


extern std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_args_info;
extern std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_args_type_info;
extern std::unordered_map<std::string, std::vector<std::string>> core_ops_final_state_returns_info;


paddle::experimental::Tensor atan2_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor cholesky_final_state_dygraph_function(const paddle::experimental::Tensor& x, bool upper);

paddle::experimental::Tensor cholesky_solve_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool upper);

paddle::experimental::Tensor cross_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis = 9);

paddle::experimental::Tensor diag_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, float padding_value);

paddle::experimental::Tensor diagonal_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, int axis1, int axis2);

paddle::experimental::Tensor digamma_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor dist_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, float p);

paddle::experimental::Tensor dot_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor erf_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor mv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& vec);

paddle::experimental::Tensor poisson_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor trace_final_state_dygraph_function(const paddle::experimental::Tensor& x, int offset, int axis1, int axis2);

paddle::experimental::Tensor trunc_final_state_dygraph_function(const paddle::experimental::Tensor& x);


paddle::experimental::Tensor abs_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor acos_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor acosh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor addmm_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, float alpha, float beta);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> argsort_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool descending);

paddle::experimental::Tensor asin_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor asinh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor assign_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor& assign_out__final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Tensor& output);

paddle::experimental::Tensor atan_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor atanh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor> batch_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& scale, const paddle::experimental::Tensor& bias, const paddle::experimental::Tensor& mean, const paddle::experimental::Tensor& variance, float momentum, float epsilon, std::string data_layout, bool is_test, bool use_global_stats, bool trainable_statistics, bool fuse_with_relu);

paddle::experimental::Tensor bce_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label);

paddle::experimental::Tensor brelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float t_min, float t_max);

paddle::experimental::Tensor cast_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::DataType out_dtype);

paddle::experimental::Tensor ceil_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor celu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha);

paddle::experimental::Tensor clip_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar min, paddle::experimental::Scalar max);
paddle::experimental::Tensor& clip__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::Scalar min, paddle::experimental::Scalar max);

paddle::experimental::Tensor complex_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor concat_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, paddle::experimental::Scalar axis);

paddle::experimental::Tensor conj_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor conv2d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format);

paddle::experimental::Tensor conv3d_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::string paddding_algorithm, int groups, std::vector<int> dilations, std::string data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search);

paddle::experimental::Tensor conv3d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format);

paddle::experimental::Tensor cos_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor cosh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> cross_entropy_with_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, bool soft_label, bool use_softmax, bool numeric_stable_mode, int ignore_index, int axis);

paddle::experimental::Tensor cumprod_final_state_dygraph_function(const paddle::experimental::Tensor& x, int dim);

paddle::experimental::Tensor cumsum_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool flatten, bool exclusive, bool reverse);

paddle::experimental::Tensor deformable_conv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& offset, const paddle::experimental::Tensor& filter, const paddle::optional<paddle::experimental::Tensor>& mask, std::vector<int> strides, std::vector<int> paddings, std::vector<int> dilations, int deformable_groups, int groups, int im2col_step);

paddle::experimental::Tensor depthwise_conv2d_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::string paddding_algorithm, int groups, std::vector<int> dilations, std::string data_format, bool use_addto, int workspace_size_MB, bool exhaustive_search, bool fuse_relu, bool use_gpudnn);

paddle::experimental::Tensor depthwise_conv2d_transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& filter, std::vector<int> strides, std::vector<int> paddings, std::vector<int> output_padding, std::vector<int> output_size, std::string padding_algorithm, int groups, std::vector<int> dilations, std::string data_format);

paddle::experimental::Tensor det_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor divide_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> dropout_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& seed_tensor, float p, bool is_test, std::string mode, int seed, bool fix_seed);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> eigh_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::string uplo);

std::tuple<paddle::experimental::Tensor, std::vector<paddle::experimental::Tensor>, std::vector<paddle::experimental::Tensor>> einsum_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, std::string equation);

paddle::experimental::Tensor elementwise_pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor elu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha);

paddle::experimental::Tensor embedding_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& weight, int64_t padding_idx = -1, bool sparse = false);

paddle::experimental::Tensor erfinv_final_state_dygraph_function(const paddle::experimental::Tensor& x);
paddle::experimental::Tensor& erfinv__final_state_dygraph_function(paddle::experimental::Tensor& x);

paddle::experimental::Tensor exp_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor expand_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shape);

paddle::experimental::Tensor expand_as_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& y, std::vector<int> target_shape);

paddle::experimental::Tensor expm1_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor flatten_final_state_dygraph_function(const paddle::experimental::Tensor& x, int start_axis, int stop_axis);
paddle::experimental::Tensor& flatten__final_state_dygraph_function(paddle::experimental::Tensor& x, int start_axis, int stop_axis);

paddle::experimental::Tensor flip_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axis);

paddle::experimental::Tensor floor_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor fmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis);

paddle::experimental::Tensor fmin_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, int axis);

paddle::experimental::Tensor frobenius_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> axis, bool keep_dim, bool reduce_all);

paddle::experimental::Tensor gather_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, paddle::experimental::Scalar axis = 0);

paddle::experimental::Tensor gather_nd_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index);

paddle::experimental::Tensor gelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, bool approximate);

paddle::experimental::Tensor graph_send_recv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& src_index, const paddle::experimental::Tensor& dst_index, std::string pool_type = "SUM", int64_t out_size = 0);

paddle::experimental::Tensor group_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon, int groups, std::string data_layout);

paddle::experimental::Tensor gumbel_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, float temperature, bool hard, int axis);

paddle::experimental::Tensor hard_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold);

paddle::experimental::Tensor hard_sigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x, float slope, float offset);

paddle::experimental::Tensor hard_swish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold = 6.0, float scale = 6.0, float offset = 3.0);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> huber_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, float delta);

paddle::experimental::Tensor imag_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor index_sample_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index);

paddle::experimental::Tensor index_select_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, int dim);

paddle::experimental::Tensor instance_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon);

paddle::experimental::Tensor kldiv_loss_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& label, std::string reduction);

paddle::experimental::Tensor kron_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> kthvalue_final_state_dygraph_function(const paddle::experimental::Tensor& x, int k, int axis, bool keepdim);

paddle::experimental::Tensor label_smooth_final_state_dygraph_function(const paddle::experimental::Tensor& label, const paddle::optional<paddle::experimental::Tensor>& prior_dist, float epsilon);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor, paddle::experimental::Tensor> layer_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::optional<paddle::experimental::Tensor>& scale, const paddle::optional<paddle::experimental::Tensor>& bias, float epsilon, int begin_norm_axis, bool is_test);

paddle::experimental::Tensor leaky_relu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float alpha);

paddle::experimental::Tensor lerp_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, const paddle::experimental::Tensor& weight);

paddle::experimental::Tensor lgamma_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor log_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor log10_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor log1p_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor log2_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor log_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, float epsilon);

paddle::experimental::Tensor log_softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis);

paddle::experimental::Tensor logcumsumexp_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool flatten, bool exclusive, bool reverse);

paddle::experimental::Tensor logit_final_state_dygraph_function(const paddle::experimental::Tensor& x, float eps = 1e-6f);

paddle::experimental::Tensor logsigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor logsumexp_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> axis, bool keepdim, bool reduce_all);

paddle::experimental::Tensor masked_select_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& mask);

paddle::experimental::Tensor matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool transpose_x = false, bool transpose_y = false);

paddle::experimental::Tensor matrix_power_final_state_dygraph_function(const paddle::experimental::Tensor& x, int n);

paddle::experimental::Tensor max_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims = {}, bool keep_dim = false);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> max_pool2d_with_index_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool global_pooling, bool adaptive);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> max_pool3d_with_index_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool global_pooling, bool adaptive);

paddle::experimental::Tensor maximum_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor maxout_final_state_dygraph_function(const paddle::experimental::Tensor& x, int groups, int axis);

paddle::experimental::Tensor mean_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims = {}, bool keep_dim = false);

paddle::experimental::Tensor mean_all_final_state_dygraph_function(const paddle::experimental::Tensor& x);

std::vector<paddle::experimental::Tensor> meshgrid_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& inputs);

paddle::experimental::Tensor min_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims = {}, bool keep_dim = false);

paddle::experimental::Tensor minimum_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor mish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> mode_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, bool keepdim);

paddle::experimental::Tensor modulo_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor multi_dot_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x);

paddle::experimental::Tensor multiplex_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& ins, const paddle::experimental::Tensor& ids);

paddle::experimental::Tensor multiply_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> nll_loss_final_state_dygraph_function(const paddle::experimental::Tensor& input, const paddle::experimental::Tensor& label, const paddle::optional<paddle::experimental::Tensor>& weight, int64_t ignore_index, std::string reduction);

paddle::experimental::Tensor norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis, float epsilon, bool is_test);

paddle::experimental::Tensor p_norm_final_state_dygraph_function(const paddle::experimental::Tensor& x, float porder, int axis, float epsilon, bool keepdim, bool asvector = false);

paddle::experimental::Tensor pad_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> paddings, float pad_value);

paddle::experimental::Tensor pad3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray paddings, std::string mode, float pad_value, std::string data_format);

paddle::experimental::Tensor pixel_shuffle_final_state_dygraph_function(const paddle::experimental::Tensor& x, int upscale_factor, std::string data_format);

paddle::experimental::Tensor pool2d_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm);

paddle::experimental::Tensor pool2d_gpudnn_unused_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm);

paddle::experimental::Tensor pool3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_size, std::vector<int> strides, std::vector<int> paddings, bool ceil_mode, bool exclusive, std::string data_format, std::string pooling_type, bool global_pooling, bool adaptive, std::string padding_algorithm);

paddle::experimental::Tensor pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar s);

paddle::experimental::Tensor prelu_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& alpha, std::string data_format, std::string mode);

paddle::experimental::Tensor psroi_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, int output_channels, float spatial_scale);

paddle::experimental::Tensor put_along_axis_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& value, int axis, std::string reduce);

paddle::experimental::Tensor real_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor reciprocal_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor reduce_prod_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims, bool keep_dim, bool reduce_all);

paddle::experimental::Tensor relu_final_state_dygraph_function(const paddle::experimental::Tensor& x);
paddle::experimental::Tensor& relu__final_state_dygraph_function(paddle::experimental::Tensor& x);

paddle::experimental::Tensor relu6_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold);

paddle::experimental::Tensor reshape_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shape);
paddle::experimental::Tensor& reshape__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::IntArray shape);

paddle::experimental::Tensor roi_align_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, float spatial_scale, int sampling_ratio, bool aligned);

paddle::experimental::Tensor roi_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& boxes, const paddle::optional<paddle::experimental::Tensor>& boxes_num, int pooled_height, int pooled_width, float spatial_scale);

paddle::experimental::Tensor roll_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray shifts, std::vector<int64_t> axis);

paddle::experimental::Tensor round_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor rsqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x);
paddle::experimental::Tensor& rsqrt__final_state_dygraph_function(paddle::experimental::Tensor& x);

paddle::experimental::Tensor scale_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar scale, float bias, bool bias_after_scale);
paddle::experimental::Tensor& scale__final_state_dygraph_function(paddle::experimental::Tensor& x, paddle::experimental::Scalar scale, float bias, bool bias_after_scale);

paddle::experimental::Tensor scatter_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& updates, bool overwrite);

paddle::experimental::Tensor scatter_nd_add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, const paddle::experimental::Tensor& updates);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> segment_pool_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& segment_ids, std::string pooltype);

paddle::experimental::Tensor selu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scale, float alpha);

paddle::experimental::Tensor sigmoid_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor sigmoid_cross_entropy_with_logits_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& label, bool normalize, int ignore_index);

paddle::experimental::Tensor silu_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor sin_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor sinh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor slice_final_state_dygraph_function(const paddle::experimental::Tensor& input, std::vector<int64_t> axes, paddle::experimental::IntArray starts, paddle::experimental::IntArray ends, std::vector<int64_t> infer_flags, std::vector<int64_t> decrease_axis);

paddle::experimental::Tensor soft_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x, float lambda);

paddle::experimental::Tensor softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis);

std::vector<paddle::experimental::Tensor> split_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray num_or_sections, paddle::experimental::Scalar axis);

paddle::experimental::Tensor sqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor square_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor squeeze_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axes);

paddle::experimental::Tensor stack_final_state_dygraph_function(const std::vector<paddle::experimental::Tensor>& x, int axis);

paddle::experimental::Tensor strided_slice_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axes, paddle::experimental::IntArray starts, paddle::experimental::IntArray ends, paddle::experimental::IntArray strides);

paddle::experimental::Tensor subtract_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor sum_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int64_t> dims = {}, paddle::experimental::DataType out_dtype = paddle::experimental::DataType::UNDEFINED, bool keep_dim = false);

paddle::experimental::Tensor swish_final_state_dygraph_function(const paddle::experimental::Tensor& x, float beta = 1.0);

paddle::experimental::Tensor take_along_axis_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& index, int axis);

paddle::experimental::Tensor tan_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor tanh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor tanh_shrink_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor thresholded_relu_final_state_dygraph_function(const paddle::experimental::Tensor& x, float threshold);

paddle::experimental::Tensor tile_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray repeat_times);

std::tuple<paddle::experimental::Tensor, paddle::experimental::Tensor> top_k_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::Scalar k, int axis = -1, bool largest = true, bool sorted = true);

paddle::experimental::Tensor transpose_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> axis);

paddle::experimental::Tensor triangular_solve_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, bool upper, bool tranpose, bool unitriangular);

paddle::experimental::Tensor tril_triu_final_state_dygraph_function(const paddle::experimental::Tensor& x, int diagonal, bool lower);

std::vector<paddle::experimental::Tensor> unbind_final_state_dygraph_function(const paddle::experimental::Tensor& input, int axis);

paddle::experimental::Tensor unfold_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_sizes, std::vector<int> strides, std::vector<int> paddings, std::vector<int> dilations);

paddle::experimental::Tensor unsqueeze_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::IntArray axes);

paddle::experimental::Tensor where_final_state_dygraph_function(const paddle::experimental::Tensor& condition, const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);



namespace sparse {
    paddle::experimental::Tensor abs_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor acos_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor acosh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor add_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor asin_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor asinh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor atan_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor atanh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor cast_final_state_dygraph_function(const paddle::experimental::Tensor& x, paddle::experimental::DataType index_dtype, paddle::experimental::DataType value_dtype);

paddle::experimental::Tensor conv3d_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& kernel, std::vector<int> paddings, std::vector<int> dilations, std::vector<int> strides, int groups, bool subm);

paddle::experimental::Tensor coo_to_dense_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor create_sparse_coo_tensor_final_state_dygraph_function(const paddle::experimental::Tensor& values, const paddle::experimental::Tensor& indices, paddle::experimental::IntArray dense_shape);

paddle::experimental::Tensor dense_to_coo_final_state_dygraph_function(const paddle::experimental::Tensor& x, int64_t sparse_dim);

paddle::experimental::Tensor divide_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor divide_scalar_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scalar);

paddle::experimental::Tensor log1p_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor multiply_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor pow_final_state_dygraph_function(const paddle::experimental::Tensor& x, float factor);

paddle::experimental::Tensor relu_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor scale_final_state_dygraph_function(const paddle::experimental::Tensor& x, float scale, float bias, bool bias_after_scale);

paddle::experimental::Tensor sin_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor sinh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor softmax_final_state_dygraph_function(const paddle::experimental::Tensor& x, int axis = -1);

paddle::experimental::Tensor sqrt_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor square_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor subtract_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor tan_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor tanh_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor values_final_state_dygraph_function(const paddle::experimental::Tensor& x);

paddle::experimental::Tensor fused_attention_final_state_dygraph_function(const paddle::experimental::Tensor& query, const paddle::experimental::Tensor& key, const paddle::experimental::Tensor& value, const paddle::experimental::Tensor& sparse_mask, const paddle::optional<paddle::experimental::Tensor>& key_padding_mask, const paddle::optional<paddle::experimental::Tensor>& attn_mask);

paddle::experimental::Tensor masked_matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y, const paddle::experimental::Tensor& mask);

paddle::experimental::Tensor matmul_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& y);

paddle::experimental::Tensor maxpool_final_state_dygraph_function(const paddle::experimental::Tensor& x, std::vector<int> kernel_sizes, std::vector<int> paddings, std::vector<int> dilations, std::vector<int> strides);

paddle::experimental::Tensor mv_final_state_dygraph_function(const paddle::experimental::Tensor& x, const paddle::experimental::Tensor& vec);


}


