// Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/framework/operator.h"

namespace paddle {
namespace framework {
class InferShapeContext;
class VarDesc;
}  // namespace framework
}  // namespace paddle

namespace paddle {
namespace operators {
class UniformRandomPrimOp : public framework::OperatorBase {
 public:
  UniformRandomPrimOp(const std::string &type,
                      const framework::VariableNameMap &inputs,
                      const framework::VariableNameMap &outputs,
                      const framework::AttributeMap &attrs)
      : framework::OperatorBase(type, inputs, outputs, attrs) {}
  void RunImpl(const framework::Scope &scope,
               const platform::Place &dev_place) const override {
    PADDLE_THROW(platform::errors::Unimplemented(
        "Prim operator uniform_randrom_p should not be excuted directly"));
  }
};

class UniformRandomPrimOpMaker : public framework::OpProtoAndCheckerMaker {
 public:
  void Make() override {
    AddOutput("Out", "(Tensor), The output tensor of uniform_random_p op.");
    AddAttr<std::vector<int64_t>>("shape", "The shape of the output tensor")
        .SetDefault({});
    AddAttr<float>("min", "Minimum value of uniform_random_p. [default -1.0].");
    AddAttr<float>("max", "Maximun value of uniform_random_p. [default 1.0].");
    AddAttr<int>("seed",
                 "Random seed used for generating samples. "
                 "0 means use a seed generated by the system."
                 "Note that if seed is not 0, this operator will always "
                 "generate the same random numbers every time. ");
    AddAttr<int>("dtype", "Output tensor data type. ");
    AddComment(R"DOC(
Autograd primitive uniform_random_p operator.
)DOC");
  }
};

class UniformRandomPrimOpShapeInference : public framework::InferShapeBase {
 public:
  void operator()(framework::InferShapeContext *ctx) const override {
    framework::InferShapeVarPtr y_var_ptr = ctx->GetOutputVarPtrs("Out")[0];
    auto shape = ctx->Attrs().Get<std::vector<int64_t>>("shape");
    PADDLE_GET(framework::VarDesc *, y_var_ptr)->SetShape(shape);
  }
};

class UniformRandomPrimOpVarTypeInference
    : public framework::StaticGraphVarTypeInference {
 public:
  void operator()(framework::InferVarTypeContext *ctx) const override {
    auto y_name = Output(ctx, "Out")[0];
    auto data_type = static_cast<framework::proto::VarType::Type>(
        PADDLE_GET_CONST(int, ctx->GetAttr("dtype")));
    SetDataType(ctx, y_name, data_type);
  }
};

}  // namespace operators
}  // namespace paddle

REGISTER_OPERATOR(uniform_random_p,
                  paddle::operators::UniformRandomPrimOp,
                  paddle::operators::UniformRandomPrimOpMaker,
                  paddle::operators::UniformRandomPrimOpShapeInference,
                  paddle::operators::UniformRandomPrimOpVarTypeInference);
