#include "glog/logging.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"

paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> kldiv_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: kldiv_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = kldiv_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Target", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Target_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("kldiv_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cumsumGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: cumsumGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cumsumGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cumsum", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sumGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    for(size_t i = 0; i < this->OutputMeta()[0].size(); i++) {
      VLOG(3) << "Running Eager Backward Node: sumGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sumGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(X) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("X") && outs0.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["X"][0], outs0["Out"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  attrs_map0["scale"] = float(1.0);
  attrs_map0["bias"] = float(0.0f);
  attrs_map0["bias_after_scale"] = bool(true);
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("scale", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
  if (outs0.find("Out") != outs0.end()) { outputs[0].emplace_back(egr::EagerUtils::GetOutputs(outs0["Out"])[0]); }


  }

  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> seluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: seluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = seluGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("selu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> gumbel_softmaxGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: gumbel_softmaxGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = gumbel_softmaxGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gumbel_softmax_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> meanGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: meanGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = meanGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mean_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sequence_padGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: sequence_padGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sequence_padGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_pad_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> tree_convGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: tree_convGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = tree_convGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "EdgeSet", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->EdgeSet_)) },{ "Filter", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Filter_)) },{ "NodesVector", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->NodesVector_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Filter@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "NodesVector@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tree_conv_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Filter@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Filter@GRAD"]); }
 if (outs0.find("NodesVector@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["NodesVector@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> assignGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: assignGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = assignGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(X) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("X") && outs0.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["X"][0], outs0["Out"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("assign", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> flatten_contiguous_rangeGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: flatten_contiguous_rangeGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = flatten_contiguous_rangeGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "XShape", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->XShape_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten_contiguous_range_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> tril_triuGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: tril_triuGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = tril_triuGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tril_triu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> celuGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: celuGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = celuGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("celu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reduce_meanGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reduce_meanGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reduce_meanGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_mean_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> breluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: breluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = breluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("brelu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sinhGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: sinhGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sinhGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sinh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> rank_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: rank_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = rank_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "Left", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Left_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Right", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Right_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Left@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Right@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("rank_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Left@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Left@GRAD"]); }
 if (outs0.find("Right@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Right@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reduce_maxGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reduce_maxGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reduce_maxGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_max_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> expm1GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: expm1GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = expm1GradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expm1_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> squared_l2_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: squared_l2_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = squared_l2_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squared_l2_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_subGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_subGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_subGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_sub_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> margin_rank_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: margin_rank_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = margin_rank_lossGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Activated", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Activated_)) },{ "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X1@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "X2@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("margin_rank_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X1@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X1@GRAD"]); }
 if (outs0.find("X2@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["X2@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> c_identityGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: c_identityGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = c_identityGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(X) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("X") && outs0.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["X"][0], outs0["Out"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_allreduce_sum", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> reluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: reluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = reluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("relu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> bmmGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: bmmGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = bmmGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bmm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> soft_reluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: soft_reluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = soft_reluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("soft_relu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> swishGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: swishGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = swishGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("swish_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cross_entropyGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: cross_entropyGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cross_entropyGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Label", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Label_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cross_entropy_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> identity_lossGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: identity_lossGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = identity_lossGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("identity_loss_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> choleskyGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: choleskyGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = choleskyGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cholesky_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> batch_fcGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: batch_fcGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = batch_fcGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Bias", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Bias_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "W", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->W_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Bias@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "W@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("batch_fc_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }
 if (outs0.find("W@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["W@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> nearest_interpGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: nearest_interpGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = nearest_interpGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto OutSize = egr::EagerUtils::RecoverTensorWrapper(&this->OutSize_);
  if(OutSize.defined()) ins0["OutSize"] =      egr::EagerUtils::TrySyncToVars(OutSize);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nearest_interp_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> gatherGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: gatherGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = gatherGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Index", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Index_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto Axis = egr::EagerUtils::RecoverTensorWrapper(&this->Axis_);
  if(Axis.defined()) ins0["Axis"] =      egr::EagerUtils::TrySyncToVars(Axis);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gather_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> trilinear_interp_v2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: trilinear_interp_v2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = trilinear_interp_v2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("trilinear_interp_v2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> c_allgatherGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: c_allgatherGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = c_allgatherGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_reducescatter", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> luGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: luGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = luGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Pivots", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Pivots_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> softmaxGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: softmaxGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = softmaxGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softmax_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> index_sampleGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: index_sampleGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = index_sampleGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Index", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Index_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("index_sample_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_minGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_minGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_minGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_min_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> erfinvGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: erfinvGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = erfinvGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("erfinv_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pixel_shuffleGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pixel_shuffleGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pixel_shuffleGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pixel_shuffle_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> thresholded_reluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: thresholded_reluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = thresholded_reluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("thresholded_relu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> warpctcGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: warpctcGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = warpctcGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Logits", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Logits_)) },{ "Loss@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "WarpCTCGrad", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->WarpCTCGrad_)) } };
  auto LogitsLength = egr::EagerUtils::RecoverTensorWrapper(&this->LogitsLength_);
  if(LogitsLength.defined()) ins0["LogitsLength"] =      egr::EagerUtils::TrySyncToVars(LogitsLength);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Logits@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("warpctc_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Logits@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Logits@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_heavisideGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_heavisideGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_heavisideGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_heaviside_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> svdGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: svdGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = svdGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "S", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->S_)) },{ "S@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) },{ "U", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->U_)) },{ "U@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "VH", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->VH_)) },{ "VH@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[2]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("svd_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> flipGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: flipGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = flipGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flip", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
