#pragma once
#include "paddle/fluid/eager/tensor_wrapper.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/eager/grad_node_info.h"
#include "paddle/fluid/eager/api/manual/fluid_manual/nodes/nodes.h"

class rsqrtGradNodeCompat : public egr::GradNodeBase {
 public:
  rsqrtGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rsqrtGradNodeCompat "; }
  rsqrtGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rsqrtGradNodeCompat "; }
  ~rsqrtGradNodeCompat() override { VLOG(6) << " Destruct rsqrtGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rsqrtGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rsqrtGradNodeCompat>(new rsqrtGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class addmmGradNodeCompat : public egr::GradNodeBase {
 public:
  addmmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct addmmGradNodeCompat "; }
  addmmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct addmmGradNodeCompat "; }
  ~addmmGradNodeCompat() override { VLOG(6) << " Destruct addmmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "addmmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<addmmGradNodeCompat>(new addmmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class gruGradNodeCompat : public egr::GradNodeBase {
 public:
  gruGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct gruGradNodeCompat "; }
  gruGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct gruGradNodeCompat "; }
  ~gruGradNodeCompat() override { VLOG(6) << " Destruct gruGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   BatchGate_.clear();
   BatchHidden_.clear();
   BatchResetHiddenPrev_.clear();
   Hidden_.clear();
   Input_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "gruGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<gruGradNodeCompat>(new gruGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBatchGate(const paddle::experimental::Tensor& BatchGate) {
     BatchGate_ = egr::TensorWrapper(BatchGate, false);

   }
   void SetTensorWrapperBatchHidden(const paddle::experimental::Tensor& BatchHidden) {
     BatchHidden_ = egr::TensorWrapper(BatchHidden, false);

   }
   void SetTensorWrapperBatchResetHiddenPrev(const paddle::experimental::Tensor& BatchResetHiddenPrev) {
     BatchResetHiddenPrev_ = egr::TensorWrapper(BatchResetHiddenPrev, false);

   }
   void SetTensorWrapperHidden(const paddle::experimental::Tensor& Hidden) {
     Hidden_ = egr::TensorWrapper(Hidden, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, true);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper BatchGate_;
   egr::TensorWrapper BatchHidden_;
   egr::TensorWrapper BatchResetHiddenPrev_;
   egr::TensorWrapper Hidden_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class roundGradNodeCompat : public egr::GradNodeBase {
 public:
  roundGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct roundGradNodeCompat "; }
  roundGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct roundGradNodeCompat "; }
  ~roundGradNodeCompat() override { VLOG(6) << " Destruct roundGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "roundGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<roundGradNodeCompat>(new roundGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class rank_attentionGradNodeCompat : public egr::GradNodeBase {
 public:
  rank_attentionGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rank_attentionGradNodeCompat "; }
  rank_attentionGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rank_attentionGradNodeCompat "; }
  ~rank_attentionGradNodeCompat() override { VLOG(6) << " Destruct rank_attentionGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   RankOffset_.clear();
   RankParam_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rank_attentionGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rank_attentionGradNodeCompat>(new rank_attentionGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperRankOffset(const paddle::experimental::Tensor& RankOffset) {
     RankOffset_ = egr::TensorWrapper(RankOffset, true);

   }
   void SetTensorWrapperRankParam(const paddle::experimental::Tensor& RankParam) {
     RankParam_ = egr::TensorWrapper(RankParam, true);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper RankOffset_;
   egr::TensorWrapper RankParam_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bicubic_interpGradNodeCompat : public egr::GradNodeBase {
 public:
  bicubic_interpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bicubic_interpGradNodeCompat "; }
  bicubic_interpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bicubic_interpGradNodeCompat "; }
  ~bicubic_interpGradNodeCompat() override { VLOG(6) << " Destruct bicubic_interpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   OutSize_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bicubic_interpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bicubic_interpGradNodeCompat>(new bicubic_interpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutSize(const paddle::experimental::Tensor& OutSize) {
     OutSize_ = egr::TensorWrapper(OutSize, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper OutSize_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tileGradNodeCompat : public egr::GradNodeBase {
 public:
  tileGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tileGradNodeCompat "; }
  tileGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tileGradNodeCompat "; }
  ~tileGradNodeCompat() override { VLOG(6) << " Destruct tileGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tileGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tileGradNodeCompat>(new tileGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bilinear_tensor_productGradNodeCompat : public egr::GradNodeBase {
 public:
  bilinear_tensor_productGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bilinear_tensor_productGradNodeCompat "; }
  bilinear_tensor_productGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bilinear_tensor_productGradNodeCompat "; }
  ~bilinear_tensor_productGradNodeCompat() override { VLOG(6) << " Destruct bilinear_tensor_productGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Weight_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bilinear_tensor_productGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bilinear_tensor_productGradNodeCompat>(new bilinear_tensor_productGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Weight_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_aminGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_aminGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_aminGradNodeCompat "; }
  reduce_aminGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_aminGradNodeCompat "; }
  ~reduce_aminGradNodeCompat() override { VLOG(6) << " Destruct reduce_aminGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_aminGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_aminGradNodeCompat>(new reduce_aminGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class splitGradNodeCompat : public egr::GradNodeBase {
 public:
  splitGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct splitGradNodeCompat "; }
  splitGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct splitGradNodeCompat "; }
  ~splitGradNodeCompat() override { VLOG(6) << " Destruct splitGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "splitGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<splitGradNodeCompat>(new splitGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class matmul_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  matmul_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct matmul_v2GradNodeCompat "; }
  matmul_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct matmul_v2GradNodeCompat "; }
  ~matmul_v2GradNodeCompat() override { VLOG(6) << " Destruct matmul_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "matmul_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<matmul_v2GradNodeCompat>(new matmul_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_maxGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_maxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_maxGradNodeCompat "; }
  elementwise_maxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_maxGradNodeCompat "; }
  ~elementwise_maxGradNodeCompat() override { VLOG(6) << " Destruct elementwise_maxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_maxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_maxGradNodeCompat>(new elementwise_maxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_embeddingGradNodeCompat : public egr::GradNodeBase {
 public:
  c_embeddingGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_embeddingGradNodeCompat "; }
  c_embeddingGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_embeddingGradNodeCompat "; }
  ~c_embeddingGradNodeCompat() override { VLOG(6) << " Destruct c_embeddingGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   W_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_embeddingGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_embeddingGradNodeCompat>(new c_embeddingGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class complexGradNodeCompat : public egr::GradNodeBase {
 public:
  complexGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct complexGradNodeCompat "; }
  complexGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct complexGradNodeCompat "; }
  ~complexGradNodeCompat() override { VLOG(6) << " Destruct complexGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "complexGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<complexGradNodeCompat>(new complexGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tanGradNodeCompat : public egr::GradNodeBase {
 public:
  tanGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tanGradNodeCompat "; }
  tanGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tanGradNodeCompat "; }
  ~tanGradNodeCompat() override { VLOG(6) << " Destruct tanGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tanGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tanGradNodeCompat>(new tanGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fspGradNodeCompat : public egr::GradNodeBase {
 public:
  fspGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fspGradNodeCompat "; }
  fspGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fspGradNodeCompat "; }
  ~fspGradNodeCompat() override { VLOG(6) << " Destruct fspGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fspGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fspGradNodeCompat>(new fspGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class whereGradNodeCompat : public egr::GradNodeBase {
 public:
  whereGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct whereGradNodeCompat "; }
  whereGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct whereGradNodeCompat "; }
  ~whereGradNodeCompat() override { VLOG(6) << " Destruct whereGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Condition_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "whereGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<whereGradNodeCompat>(new whereGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperCondition(const paddle::experimental::Tensor& Condition) {
     Condition_ = egr::TensorWrapper(Condition, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Condition_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_softmaxGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_softmaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_softmaxGradNodeCompat "; }
  sequence_softmaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_softmaxGradNodeCompat "; }
  ~sequence_softmaxGradNodeCompat() override { VLOG(6) << " Destruct sequence_softmaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_softmaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_softmaxGradNodeCompat>(new sequence_softmaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class affine_channelGradNodeCompat : public egr::GradNodeBase {
 public:
  affine_channelGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct affine_channelGradNodeCompat "; }
  affine_channelGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct affine_channelGradNodeCompat "; }
  ~affine_channelGradNodeCompat() override { VLOG(6) << " Destruct affine_channelGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Scale_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "affine_channelGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<affine_channelGradNodeCompat>(new affine_channelGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Scale_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class triangular_solveGradNodeCompat : public egr::GradNodeBase {
 public:
  triangular_solveGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct triangular_solveGradNodeCompat "; }
  triangular_solveGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct triangular_solveGradNodeCompat "; }
  ~triangular_solveGradNodeCompat() override { VLOG(6) << " Destruct triangular_solveGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "triangular_solveGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<triangular_solveGradNodeCompat>(new triangular_solveGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_topk_avg_poolingGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_topk_avg_poolingGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_topk_avg_poolingGradNodeCompat "; }
  sequence_topk_avg_poolingGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_topk_avg_poolingGradNodeCompat "; }
  ~sequence_topk_avg_poolingGradNodeCompat() override { VLOG(6) << " Destruct sequence_topk_avg_poolingGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   COLUMN_.clear();
   ROW_.clear();
   X_.clear();
   pos_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_topk_avg_poolingGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_topk_avg_poolingGradNodeCompat>(new sequence_topk_avg_poolingGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperCOLUMN(const paddle::experimental::Tensor& COLUMN) {
     COLUMN_ = egr::TensorWrapper(COLUMN, false);

   }
   void SetTensorWrapperROW(const paddle::experimental::Tensor& ROW) {
     ROW_ = egr::TensorWrapper(ROW, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperpos(const paddle::experimental::Tensor& pos) {
     pos_ = egr::TensorWrapper(pos, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper COLUMN_;
   egr::TensorWrapper ROW_;
   egr::TensorWrapper X_;
   egr::TensorWrapper pos_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class space_to_depthGradNodeCompat : public egr::GradNodeBase {
 public:
  space_to_depthGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct space_to_depthGradNodeCompat "; }
  space_to_depthGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct space_to_depthGradNodeCompat "; }
  ~space_to_depthGradNodeCompat() override { VLOG(6) << " Destruct space_to_depthGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "space_to_depthGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<space_to_depthGradNodeCompat>(new space_to_depthGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reverseGradNodeCompat : public egr::GradNodeBase {
 public:
  reverseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reverseGradNodeCompat "; }
  reverseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reverseGradNodeCompat "; }
  ~reverseGradNodeCompat() override { VLOG(6) << " Destruct reverseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reverseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reverseGradNodeCompat>(new reverseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expand_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  expand_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expand_v2GradNodeCompat "; }
  expand_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expand_v2GradNodeCompat "; }
  ~expand_v2GradNodeCompat() override { VLOG(6) << " Destruct expand_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expand_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expand_v2GradNodeCompat>(new expand_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class repeat_interleaveGradNodeCompat : public egr::GradNodeBase {
 public:
  repeat_interleaveGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct repeat_interleaveGradNodeCompat "; }
  repeat_interleaveGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct repeat_interleaveGradNodeCompat "; }
  ~repeat_interleaveGradNodeCompat() override { VLOG(6) << " Destruct repeat_interleaveGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   RepeatsTensor_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "repeat_interleaveGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<repeat_interleaveGradNodeCompat>(new repeat_interleaveGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperRepeatsTensor(const paddle::experimental::Tensor& RepeatsTensor) {
     RepeatsTensor_ = egr::TensorWrapper(RepeatsTensor, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper RepeatsTensor_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lgammaGradNodeCompat : public egr::GradNodeBase {
 public:
  lgammaGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lgammaGradNodeCompat "; }
  lgammaGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lgammaGradNodeCompat "; }
  ~lgammaGradNodeCompat() override { VLOG(6) << " Destruct lgammaGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lgammaGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lgammaGradNodeCompat>(new lgammaGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class solveGradNodeCompat : public egr::GradNodeBase {
 public:
  solveGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct solveGradNodeCompat "; }
  solveGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct solveGradNodeCompat "; }
  ~solveGradNodeCompat() override { VLOG(6) << " Destruct solveGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "solveGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<solveGradNodeCompat>(new solveGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class deformable_psroi_poolingGradNodeCompat : public egr::GradNodeBase {
 public:
  deformable_psroi_poolingGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct deformable_psroi_poolingGradNodeCompat "; }
  deformable_psroi_poolingGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct deformable_psroi_poolingGradNodeCompat "; }
  ~deformable_psroi_poolingGradNodeCompat() override { VLOG(6) << " Destruct deformable_psroi_poolingGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();
   ROIs_.clear();
   TopCount_.clear();
   Trans_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "deformable_psroi_poolingGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<deformable_psroi_poolingGradNodeCompat>(new deformable_psroi_poolingGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperTopCount(const paddle::experimental::Tensor& TopCount) {
     TopCount_ = egr::TensorWrapper(TopCount, false);

   }
   void SetTensorWrapperTrans(const paddle::experimental::Tensor& Trans) {
     Trans_ = egr::TensorWrapper(Trans, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper TopCount_;
   egr::TensorWrapper Trans_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class instance_normGradNodeCompat : public egr::GradNodeBase {
 public:
  instance_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct instance_normGradNodeCompat "; }
  instance_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct instance_normGradNodeCompat "; }
  ~instance_normGradNodeCompat() override { VLOG(6) << " Destruct instance_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   SavedMean_.clear();
   SavedVariance_.clear();
   Scale_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "instance_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<instance_normGradNodeCompat>(new instance_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperSavedMean(const paddle::experimental::Tensor& SavedMean) {
     SavedMean_ = egr::TensorWrapper(SavedMean, false);

   }
   void SetTensorWrapperSavedVariance(const paddle::experimental::Tensor& SavedVariance) {
     SavedVariance_ = egr::TensorWrapper(SavedVariance, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper SavedMean_;
   egr::TensorWrapper SavedVariance_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class gather_ndGradNodeCompat : public egr::GradNodeBase {
 public:
  gather_ndGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct gather_ndGradNodeCompat "; }
  gather_ndGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct gather_ndGradNodeCompat "; }
  ~gather_ndGradNodeCompat() override { VLOG(6) << " Destruct gather_ndGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "gather_ndGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<gather_ndGradNodeCompat>(new gather_ndGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_prodGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_prodGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_prodGradNodeCompat "; }
  reduce_prodGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_prodGradNodeCompat "; }
  ~reduce_prodGradNodeCompat() override { VLOG(6) << " Destruct reduce_prodGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_prodGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_prodGradNodeCompat>(new reduce_prodGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class asinGradNodeCompat : public egr::GradNodeBase {
 public:
  asinGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct asinGradNodeCompat "; }
  asinGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct asinGradNodeCompat "; }
  ~asinGradNodeCompat() override { VLOG(6) << " Destruct asinGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "asinGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<asinGradNodeCompat>(new asinGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lstmpGradNodeCompat : public egr::GradNodeBase {
 public:
  lstmpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lstmpGradNodeCompat "; }
  lstmpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lstmpGradNodeCompat "; }
  ~lstmpGradNodeCompat() override { VLOG(6) << " Destruct lstmpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   BatchCellPreAct_.clear();
   BatchGate_.clear();
   BatchHidden_.clear();
   Bias_.clear();
   Cell_.clear();
   ProjWeight_.clear();
   Projection_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lstmpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lstmpGradNodeCompat>(new lstmpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBatchCellPreAct(const paddle::experimental::Tensor& BatchCellPreAct) {
     BatchCellPreAct_ = egr::TensorWrapper(BatchCellPreAct, false);

   }
   void SetTensorWrapperBatchGate(const paddle::experimental::Tensor& BatchGate) {
     BatchGate_ = egr::TensorWrapper(BatchGate, false);

   }
   void SetTensorWrapperBatchHidden(const paddle::experimental::Tensor& BatchHidden) {
     BatchHidden_ = egr::TensorWrapper(BatchHidden, false);

   }
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperCell(const paddle::experimental::Tensor& Cell) {
     Cell_ = egr::TensorWrapper(Cell, false);

   }
   void SetTensorWrapperProjWeight(const paddle::experimental::Tensor& ProjWeight) {
     ProjWeight_ = egr::TensorWrapper(ProjWeight, false);

   }
   void SetTensorWrapperProjection(const paddle::experimental::Tensor& Projection) {
     Projection_ = egr::TensorWrapper(Projection, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper BatchCellPreAct_;
   egr::TensorWrapper BatchGate_;
   egr::TensorWrapper BatchHidden_;
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Cell_;
   egr::TensorWrapper ProjWeight_;
   egr::TensorWrapper Projection_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class huber_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  huber_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct huber_lossGradNodeCompat "; }
  huber_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct huber_lossGradNodeCompat "; }
  ~huber_lossGradNodeCompat() override { VLOG(6) << " Destruct huber_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Residual_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "huber_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<huber_lossGradNodeCompat>(new huber_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperResidual(const paddle::experimental::Tensor& Residual) {
     Residual_ = egr::TensorWrapper(Residual, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Residual_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_sliceGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_sliceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_sliceGradNodeCompat "; }
  sequence_sliceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_sliceGradNodeCompat "; }
  ~sequence_sliceGradNodeCompat() override { VLOG(6) << " Destruct sequence_sliceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Length_.clear();
   Offset_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_sliceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_sliceGradNodeCompat>(new sequence_sliceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLength(const paddle::experimental::Tensor& Length) {
     Length_ = egr::TensorWrapper(Length, false);

   }
   void SetTensorWrapperOffset(const paddle::experimental::Tensor& Offset) {
     Offset_ = egr::TensorWrapper(Offset, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Length_;
   egr::TensorWrapper Offset_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lookup_tableGradNodeCompat : public egr::GradNodeBase {
 public:
  lookup_tableGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lookup_tableGradNodeCompat "; }
  lookup_tableGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lookup_tableGradNodeCompat "; }
  ~lookup_tableGradNodeCompat() override { VLOG(6) << " Destruct lookup_tableGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   W_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lookup_tableGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lookup_tableGradNodeCompat>(new lookup_tableGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class softplusGradNodeCompat : public egr::GradNodeBase {
 public:
  softplusGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct softplusGradNodeCompat "; }
  softplusGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct softplusGradNodeCompat "; }
  ~softplusGradNodeCompat() override { VLOG(6) << " Destruct softplusGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "softplusGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<softplusGradNodeCompat>(new softplusGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class depthwise_conv2dGradNodeCompat : public egr::GradNodeBase {
 public:
  depthwise_conv2dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct depthwise_conv2dGradNodeCompat "; }
  depthwise_conv2dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct depthwise_conv2dGradNodeCompat "; }
  ~depthwise_conv2dGradNodeCompat() override { VLOG(6) << " Destruct depthwise_conv2dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "depthwise_conv2dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<depthwise_conv2dGradNodeCompat>(new depthwise_conv2dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_allreduce_sumGradNodeCompat : public egr::GradNodeBase {
 public:
  c_allreduce_sumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_allreduce_sumGradNodeCompat "; }
  c_allreduce_sumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_allreduce_sumGradNodeCompat "; }
  ~c_allreduce_sumGradNodeCompat() override { VLOG(6) << " Destruct c_allreduce_sumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_allreduce_sumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_allreduce_sumGradNodeCompat>(new c_allreduce_sumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sigmoid_cross_entropy_with_logitsGradNodeCompat : public egr::GradNodeBase {
 public:
  sigmoid_cross_entropy_with_logitsGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sigmoid_cross_entropy_with_logitsGradNodeCompat "; }
  sigmoid_cross_entropy_with_logitsGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sigmoid_cross_entropy_with_logitsGradNodeCompat "; }
  ~sigmoid_cross_entropy_with_logitsGradNodeCompat() override { VLOG(6) << " Destruct sigmoid_cross_entropy_with_logitsGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sigmoid_cross_entropy_with_logitsGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sigmoid_cross_entropy_with_logitsGradNodeCompat>(new sigmoid_cross_entropy_with_logitsGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expGradNodeCompat : public egr::GradNodeBase {
 public:
  expGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expGradNodeCompat "; }
  expGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expGradNodeCompat "; }
  ~expGradNodeCompat() override { VLOG(6) << " Destruct expGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expGradNodeCompat>(new expGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class scatterGradNodeCompat : public egr::GradNodeBase {
 public:
  scatterGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct scatterGradNodeCompat "; }
  scatterGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct scatterGradNodeCompat "; }
  ~scatterGradNodeCompat() override { VLOG(6) << " Destruct scatterGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   Updates_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "scatterGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<scatterGradNodeCompat>(new scatterGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperUpdates(const paddle::experimental::Tensor& Updates) {
     Updates_ = egr::TensorWrapper(Updates, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper Updates_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class logGradNodeCompat : public egr::GradNodeBase {
 public:
  logGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct logGradNodeCompat "; }
  logGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct logGradNodeCompat "; }
  ~logGradNodeCompat() override { VLOG(6) << " Destruct logGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "logGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<logGradNodeCompat>(new logGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conv_shiftGradNodeCompat : public egr::GradNodeBase {
 public:
  conv_shiftGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conv_shiftGradNodeCompat "; }
  conv_shiftGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conv_shiftGradNodeCompat "; }
  ~conv_shiftGradNodeCompat() override { VLOG(6) << " Destruct conv_shiftGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conv_shiftGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conv_shiftGradNodeCompat>(new conv_shiftGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class as_complexGradNodeCompat : public egr::GradNodeBase {
 public:
  as_complexGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct as_complexGradNodeCompat "; }
  as_complexGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct as_complexGradNodeCompat "; }
  ~as_complexGradNodeCompat() override { VLOG(6) << " Destruct as_complexGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "as_complexGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<as_complexGradNodeCompat>(new as_complexGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class smooth_l1_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  smooth_l1_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct smooth_l1_lossGradNodeCompat "; }
  smooth_l1_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct smooth_l1_lossGradNodeCompat "; }
  ~smooth_l1_lossGradNodeCompat() override { VLOG(6) << " Destruct smooth_l1_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Diff_.clear();
   InsideWeight_.clear();
   OutsideWeight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "smooth_l1_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<smooth_l1_lossGradNodeCompat>(new smooth_l1_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperDiff(const paddle::experimental::Tensor& Diff) {
     Diff_ = egr::TensorWrapper(Diff, false);

   }
   void SetTensorWrapperInsideWeight(const paddle::experimental::Tensor& InsideWeight) {
     InsideWeight_ = egr::TensorWrapper(InsideWeight, false);

   }
   void SetTensorWrapperOutsideWeight(const paddle::experimental::Tensor& OutsideWeight) {
     OutsideWeight_ = egr::TensorWrapper(OutsideWeight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Diff_;
   egr::TensorWrapper InsideWeight_;
   egr::TensorWrapper OutsideWeight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class linear_interp_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  linear_interp_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct linear_interp_v2GradNodeCompat "; }
  linear_interp_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct linear_interp_v2GradNodeCompat "; }
  ~linear_interp_v2GradNodeCompat() override { VLOG(6) << " Destruct linear_interp_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "linear_interp_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<linear_interp_v2GradNodeCompat>(new linear_interp_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class temporal_shiftGradNodeCompat : public egr::GradNodeBase {
 public:
  temporal_shiftGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct temporal_shiftGradNodeCompat "; }
  temporal_shiftGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct temporal_shiftGradNodeCompat "; }
  ~temporal_shiftGradNodeCompat() override { VLOG(6) << " Destruct temporal_shiftGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "temporal_shiftGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<temporal_shiftGradNodeCompat>(new temporal_shiftGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class nceGradNodeCompat : public egr::GradNodeBase {
 public:
  nceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct nceGradNodeCompat "; }
  nceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct nceGradNodeCompat "; }
  ~nceGradNodeCompat() override { VLOG(6) << " Destruct nceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   CustomDistAlias_.clear();
   CustomDistAliasProbs_.clear();
   CustomDistProbs_.clear();
   Input_.clear();
   Label_.clear();
   SampleLabels_.clear();
   SampleLogits_.clear();
   SampleWeight_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "nceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<nceGradNodeCompat>(new nceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, true);

   }
   void SetTensorWrapperCustomDistAlias(const paddle::experimental::Tensor& CustomDistAlias) {
     CustomDistAlias_ = egr::TensorWrapper(CustomDistAlias, false);

   }
   void SetTensorWrapperCustomDistAliasProbs(const paddle::experimental::Tensor& CustomDistAliasProbs) {
     CustomDistAliasProbs_ = egr::TensorWrapper(CustomDistAliasProbs, false);

   }
   void SetTensorWrapperCustomDistProbs(const paddle::experimental::Tensor& CustomDistProbs) {
     CustomDistProbs_ = egr::TensorWrapper(CustomDistProbs, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperSampleLabels(const paddle::experimental::Tensor& SampleLabels) {
     SampleLabels_ = egr::TensorWrapper(SampleLabels, false);

   }
   void SetTensorWrapperSampleLogits(const paddle::experimental::Tensor& SampleLogits) {
     SampleLogits_ = egr::TensorWrapper(SampleLogits, false);

   }
   void SetTensorWrapperSampleWeight(const paddle::experimental::Tensor& SampleWeight) {
     SampleWeight_ = egr::TensorWrapper(SampleWeight, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper CustomDistAlias_;
   egr::TensorWrapper CustomDistAliasProbs_;
   egr::TensorWrapper CustomDistProbs_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Label_;
   egr::TensorWrapper SampleLabels_;
   egr::TensorWrapper SampleLogits_;
   egr::TensorWrapper SampleWeight_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class mvGradNodeCompat : public egr::GradNodeBase {
 public:
  mvGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct mvGradNodeCompat "; }
  mvGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct mvGradNodeCompat "; }
  ~mvGradNodeCompat() override { VLOG(6) << " Destruct mvGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Vec_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "mvGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<mvGradNodeCompat>(new mvGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperVec(const paddle::experimental::Tensor& Vec) {
     Vec_ = egr::TensorWrapper(Vec, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Vec_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class global_scatterGradNodeCompat : public egr::GradNodeBase {
 public:
  global_scatterGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct global_scatterGradNodeCompat "; }
  global_scatterGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct global_scatterGradNodeCompat "; }
  ~global_scatterGradNodeCompat() override { VLOG(6) << " Destruct global_scatterGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   global_count_.clear();
   local_count_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "global_scatterGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<global_scatterGradNodeCompat>(new global_scatterGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperglobal_count(const paddle::experimental::Tensor& global_count) {
     global_count_ = egr::TensorWrapper(global_count, false);

   }
   void SetTensorWrapperlocal_count(const paddle::experimental::Tensor& local_count) {
     local_count_ = egr::TensorWrapper(local_count, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper global_count_;
   egr::TensorWrapper local_count_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class dropout_ndGradNodeCompat : public egr::GradNodeBase {
 public:
  dropout_ndGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct dropout_ndGradNodeCompat "; }
  dropout_ndGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct dropout_ndGradNodeCompat "; }
  ~dropout_ndGradNodeCompat() override { VLOG(6) << " Destruct dropout_ndGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Mask_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "dropout_ndGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<dropout_ndGradNodeCompat>(new dropout_ndGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Mask_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class add_position_encodingGradNodeCompat : public egr::GradNodeBase {
 public:
  add_position_encodingGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct add_position_encodingGradNodeCompat "; }
  add_position_encodingGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct add_position_encodingGradNodeCompat "; }
  ~add_position_encodingGradNodeCompat() override { VLOG(6) << " Destruct add_position_encodingGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "add_position_encodingGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<add_position_encodingGradNodeCompat>(new add_position_encodingGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class coshGradNodeCompat : public egr::GradNodeBase {
 public:
  coshGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct coshGradNodeCompat "; }
  coshGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct coshGradNodeCompat "; }
  ~coshGradNodeCompat() override { VLOG(6) << " Destruct coshGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "coshGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<coshGradNodeCompat>(new coshGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class signGradNodeCompat : public egr::GradNodeBase {
 public:
  signGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct signGradNodeCompat "; }
  signGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct signGradNodeCompat "; }
  ~signGradNodeCompat() override { VLOG(6) << " Destruct signGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "signGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<signGradNodeCompat>(new signGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class preluGradNodeCompat : public egr::GradNodeBase {
 public:
  preluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct preluGradNodeCompat "; }
  preluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct preluGradNodeCompat "; }
  ~preluGradNodeCompat() override { VLOG(6) << " Destruct preluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Alpha_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "preluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<preluGradNodeCompat>(new preluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperAlpha(const paddle::experimental::Tensor& Alpha) {
     Alpha_ = egr::TensorWrapper(Alpha, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Alpha_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fill_diagonalGradNodeCompat : public egr::GradNodeBase {
 public:
  fill_diagonalGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fill_diagonalGradNodeCompat "; }
  fill_diagonalGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fill_diagonalGradNodeCompat "; }
  ~fill_diagonalGradNodeCompat() override { VLOG(6) << " Destruct fill_diagonalGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fill_diagonalGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fill_diagonalGradNodeCompat>(new fill_diagonalGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class logsigmoidGradNodeCompat : public egr::GradNodeBase {
 public:
  logsigmoidGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct logsigmoidGradNodeCompat "; }
  logsigmoidGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct logsigmoidGradNodeCompat "; }
  ~logsigmoidGradNodeCompat() override { VLOG(6) << " Destruct logsigmoidGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "logsigmoidGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<logsigmoidGradNodeCompat>(new logsigmoidGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_scatterGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_scatterGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_scatterGradNodeCompat "; }
  sequence_scatterGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_scatterGradNodeCompat "; }
  ~sequence_scatterGradNodeCompat() override { VLOG(6) << " Destruct sequence_scatterGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   Updates_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_scatterGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_scatterGradNodeCompat>(new sequence_scatterGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperUpdates(const paddle::experimental::Tensor& Updates) {
     Updates_ = egr::TensorWrapper(Updates, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper Updates_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class relu6GradNodeCompat : public egr::GradNodeBase {
 public:
  relu6GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct relu6GradNodeCompat "; }
  relu6GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct relu6GradNodeCompat "; }
  ~relu6GradNodeCompat() override { VLOG(6) << " Destruct relu6GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "relu6GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<relu6GradNodeCompat>(new relu6GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class partial_sumGradNodeCompat : public egr::GradNodeBase {
 public:
  partial_sumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct partial_sumGradNodeCompat "; }
  partial_sumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct partial_sumGradNodeCompat "; }
  ~partial_sumGradNodeCompat() override { VLOG(6) << " Destruct partial_sumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "partial_sumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<partial_sumGradNodeCompat>(new partial_sumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class alltoallGradNodeCompat : public egr::GradNodeBase {
 public:
  alltoallGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct alltoallGradNodeCompat "; }
  alltoallGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct alltoallGradNodeCompat "; }
  ~alltoallGradNodeCompat() override { VLOG(6) << " Destruct alltoallGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "alltoallGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<alltoallGradNodeCompat>(new alltoallGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conv3dGradNodeCompat : public egr::GradNodeBase {
 public:
  conv3dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conv3dGradNodeCompat "; }
  conv3dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conv3dGradNodeCompat "; }
  ~conv3dGradNodeCompat() override { VLOG(6) << " Destruct conv3dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conv3dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conv3dGradNodeCompat>(new conv3dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lu_unpackGradNodeCompat : public egr::GradNodeBase {
 public:
  lu_unpackGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lu_unpackGradNodeCompat "; }
  lu_unpackGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lu_unpackGradNodeCompat "; }
  ~lu_unpackGradNodeCompat() override { VLOG(6) << " Destruct lu_unpackGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   L_.clear();
   Pivots_.clear();
   Pmat_.clear();
   U_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lu_unpackGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lu_unpackGradNodeCompat>(new lu_unpackGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperL(const paddle::experimental::Tensor& L) {
     L_ = egr::TensorWrapper(L, false);

   }
   void SetTensorWrapperPivots(const paddle::experimental::Tensor& Pivots) {
     Pivots_ = egr::TensorWrapper(Pivots, false);

   }
   void SetTensorWrapperPmat(const paddle::experimental::Tensor& Pmat) {
     Pmat_ = egr::TensorWrapper(Pmat, false);

   }
   void SetTensorWrapperU(const paddle::experimental::Tensor& U) {
     U_ = egr::TensorWrapper(U, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper L_;
   egr::TensorWrapper Pivots_;
   egr::TensorWrapper Pmat_;
   egr::TensorWrapper U_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lstm_unitGradNodeCompat : public egr::GradNodeBase {
 public:
  lstm_unitGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lstm_unitGradNodeCompat "; }
  lstm_unitGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lstm_unitGradNodeCompat "; }
  ~lstm_unitGradNodeCompat() override { VLOG(6) << " Destruct lstm_unitGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   C_.clear();
   C_prev_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lstm_unitGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lstm_unitGradNodeCompat>(new lstm_unitGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperC(const paddle::experimental::Tensor& C) {
     C_ = egr::TensorWrapper(C, false);

   }
   void SetTensorWrapperC_prev(const paddle::experimental::Tensor& C_prev) {
     C_prev_ = egr::TensorWrapper(C_prev, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper C_;
   egr::TensorWrapper C_prev_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class transpose2GradNodeCompat : public egr::GradNodeBase {
 public:
  transpose2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct transpose2GradNodeCompat "; }
  transpose2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct transpose2GradNodeCompat "; }
  ~transpose2GradNodeCompat() override { VLOG(6) << " Destruct transpose2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "transpose2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<transpose2GradNodeCompat>(new transpose2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unfoldGradNodeCompat : public egr::GradNodeBase {
 public:
  unfoldGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unfoldGradNodeCompat "; }
  unfoldGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unfoldGradNodeCompat "; }
  ~unfoldGradNodeCompat() override { VLOG(6) << " Destruct unfoldGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unfoldGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unfoldGradNodeCompat>(new unfoldGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lrnGradNodeCompat : public egr::GradNodeBase {
 public:
  lrnGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lrnGradNodeCompat "; }
  lrnGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lrnGradNodeCompat "; }
  ~lrnGradNodeCompat() override { VLOG(6) << " Destruct lrnGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   MidOut_.clear();
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lrnGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lrnGradNodeCompat>(new lrnGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMidOut(const paddle::experimental::Tensor& MidOut) {
     MidOut_ = egr::TensorWrapper(MidOut, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper MidOut_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class softmax_with_cross_entropyGradNodeCompat : public egr::GradNodeBase {
 public:
  softmax_with_cross_entropyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct softmax_with_cross_entropyGradNodeCompat "; }
  softmax_with_cross_entropyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct softmax_with_cross_entropyGradNodeCompat "; }
  ~softmax_with_cross_entropyGradNodeCompat() override { VLOG(6) << " Destruct softmax_with_cross_entropyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   Softmax_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "softmax_with_cross_entropyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<softmax_with_cross_entropyGradNodeCompat>(new softmax_with_cross_entropyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperSoftmax(const paddle::experimental::Tensor& Softmax) {
     Softmax_ = egr::TensorWrapper(Softmax, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper Softmax_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class max_pool3d_with_indexGradNodeCompat : public egr::GradNodeBase {
 public:
  max_pool3d_with_indexGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct max_pool3d_with_indexGradNodeCompat "; }
  max_pool3d_with_indexGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct max_pool3d_with_indexGradNodeCompat "; }
  ~max_pool3d_with_indexGradNodeCompat() override { VLOG(6) << " Destruct max_pool3d_with_indexGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Mask_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "max_pool3d_with_indexGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<max_pool3d_with_indexGradNodeCompat>(new max_pool3d_with_indexGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Mask_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_seqpool_cvmGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_seqpool_cvmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_seqpool_cvmGradNodeCompat "; }
  fused_seqpool_cvmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_seqpool_cvmGradNodeCompat "; }
  ~fused_seqpool_cvmGradNodeCompat() override { VLOG(6) << " Destruct fused_seqpool_cvmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   CVM_.clear();
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_seqpool_cvmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_seqpool_cvmGradNodeCompat>(new fused_seqpool_cvmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperCVM(const paddle::experimental::Tensor& CVM) {
     CVM_ = egr::TensorWrapper(CVM, false);

   }
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper CVM_;
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class flatten2GradNodeCompat : public egr::GradNodeBase {
 public:
  flatten2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct flatten2GradNodeCompat "; }
  flatten2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct flatten2GradNodeCompat "; }
  ~flatten2GradNodeCompat() override { VLOG(6) << " Destruct flatten2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "flatten2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<flatten2GradNodeCompat>(new flatten2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class matmulGradNodeCompat : public egr::GradNodeBase {
 public:
  matmulGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct matmulGradNodeCompat "; }
  matmulGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct matmulGradNodeCompat "; }
  ~matmulGradNodeCompat() override { VLOG(6) << " Destruct matmulGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "matmulGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<matmulGradNodeCompat>(new matmulGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cvmGradNodeCompat : public egr::GradNodeBase {
 public:
  cvmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cvmGradNodeCompat "; }
  cvmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cvmGradNodeCompat "; }
  ~cvmGradNodeCompat() override { VLOG(6) << " Destruct cvmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   CVM_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cvmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cvmGradNodeCompat>(new cvmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperCVM(const paddle::experimental::Tensor& CVM) {
     CVM_ = egr::TensorWrapper(CVM, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper CVM_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class masked_selectGradNodeCompat : public egr::GradNodeBase {
 public:
  masked_selectGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct masked_selectGradNodeCompat "; }
  masked_selectGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct masked_selectGradNodeCompat "; }
  ~masked_selectGradNodeCompat() override { VLOG(6) << " Destruct masked_selectGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Mask_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "masked_selectGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<masked_selectGradNodeCompat>(new masked_selectGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Mask_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class traceGradNodeCompat : public egr::GradNodeBase {
 public:
  traceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct traceGradNodeCompat "; }
  traceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct traceGradNodeCompat "; }
  ~traceGradNodeCompat() override { VLOG(6) << " Destruct traceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "traceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<traceGradNodeCompat>(new traceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class modified_huber_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  modified_huber_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct modified_huber_lossGradNodeCompat "; }
  modified_huber_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct modified_huber_lossGradNodeCompat "; }
  ~modified_huber_lossGradNodeCompat() override { VLOG(6) << " Destruct modified_huber_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   IntermediateVal_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "modified_huber_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<modified_huber_lossGradNodeCompat>(new modified_huber_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIntermediateVal(const paddle::experimental::Tensor& IntermediateVal) {
     IntermediateVal_ = egr::TensorWrapper(IntermediateVal, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper IntermediateVal_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class rollGradNodeCompat : public egr::GradNodeBase {
 public:
  rollGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rollGradNodeCompat "; }
  rollGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rollGradNodeCompat "; }
  ~rollGradNodeCompat() override { VLOG(6) << " Destruct rollGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rollGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rollGradNodeCompat>(new rollGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class squared_l2_distanceGradNodeCompat : public egr::GradNodeBase {
 public:
  squared_l2_distanceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct squared_l2_distanceGradNodeCompat "; }
  squared_l2_distanceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct squared_l2_distanceGradNodeCompat "; }
  ~squared_l2_distanceGradNodeCompat() override { VLOG(6) << " Destruct squared_l2_distanceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();
   sub_result_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "squared_l2_distanceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<squared_l2_distanceGradNodeCompat>(new squared_l2_distanceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }
   void SetTensorWrappersub_result(const paddle::experimental::Tensor& sub_result) {
     sub_result_ = egr::TensorWrapper(sub_result, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;
   egr::TensorWrapper sub_result_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conv3d_transposeGradNodeCompat : public egr::GradNodeBase {
 public:
  conv3d_transposeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conv3d_transposeGradNodeCompat "; }
  conv3d_transposeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conv3d_transposeGradNodeCompat "; }
  ~conv3d_transposeGradNodeCompat() override { VLOG(6) << " Destruct conv3d_transposeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conv3d_transposeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conv3d_transposeGradNodeCompat>(new conv3d_transposeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class rreluGradNodeCompat : public egr::GradNodeBase {
 public:
  rreluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rreluGradNodeCompat "; }
  rreluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rreluGradNodeCompat "; }
  ~rreluGradNodeCompat() override { VLOG(6) << " Destruct rreluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Noise_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rreluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rreluGradNodeCompat>(new rreluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperNoise(const paddle::experimental::Tensor& Noise) {
     Noise_ = egr::TensorWrapper(Noise, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Noise_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class concatGradNodeCompat : public egr::GradNodeBase {
 public:
  concatGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct concatGradNodeCompat "; }
  concatGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct concatGradNodeCompat "; }
  ~concatGradNodeCompat() override { VLOG(6) << " Destruct concatGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "concatGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<concatGradNodeCompat>(new concatGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , true) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class hierarchical_sigmoidGradNodeCompat : public egr::GradNodeBase {
 public:
  hierarchical_sigmoidGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct hierarchical_sigmoidGradNodeCompat "; }
  hierarchical_sigmoidGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct hierarchical_sigmoidGradNodeCompat "; }
  ~hierarchical_sigmoidGradNodeCompat() override { VLOG(6) << " Destruct hierarchical_sigmoidGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   Label_.clear();
   PathCode_.clear();
   PathTable_.clear();
   PreOut_.clear();
   W_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "hierarchical_sigmoidGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<hierarchical_sigmoidGradNodeCompat>(new hierarchical_sigmoidGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, true);

   }
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperPathCode(const paddle::experimental::Tensor& PathCode) {
     PathCode_ = egr::TensorWrapper(PathCode, false);

   }
   void SetTensorWrapperPathTable(const paddle::experimental::Tensor& PathTable) {
     PathTable_ = egr::TensorWrapper(PathTable, false);

   }
   void SetTensorWrapperPreOut(const paddle::experimental::Tensor& PreOut) {
     PreOut_ = egr::TensorWrapper(PreOut, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Label_;
   egr::TensorWrapper PathCode_;
   egr::TensorWrapper PathTable_;
   egr::TensorWrapper PreOut_;
   egr::TensorWrapper W_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class squeezeGradNodeCompat : public egr::GradNodeBase {
 public:
  squeezeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct squeezeGradNodeCompat "; }
  squeezeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct squeezeGradNodeCompat "; }
  ~squeezeGradNodeCompat() override { VLOG(6) << " Destruct squeezeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "squeezeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<squeezeGradNodeCompat>(new squeezeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bpr_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  bpr_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bpr_lossGradNodeCompat "; }
  bpr_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bpr_lossGradNodeCompat "; }
  ~bpr_lossGradNodeCompat() override { VLOG(6) << " Destruct bpr_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bpr_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bpr_lossGradNodeCompat>(new bpr_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fft_c2cGradNodeCompat : public egr::GradNodeBase {
 public:
  fft_c2cGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fft_c2cGradNodeCompat "; }
  fft_c2cGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fft_c2cGradNodeCompat "; }
  ~fft_c2cGradNodeCompat() override { VLOG(6) << " Destruct fft_c2cGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fft_c2cGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fft_c2cGradNodeCompat>(new fft_c2cGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bicubic_interp_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  bicubic_interp_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bicubic_interp_v2GradNodeCompat "; }
  bicubic_interp_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bicubic_interp_v2GradNodeCompat "; }
  ~bicubic_interp_v2GradNodeCompat() override { VLOG(6) << " Destruct bicubic_interp_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bicubic_interp_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bicubic_interp_v2GradNodeCompat>(new bicubic_interp_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class angleGradNodeCompat : public egr::GradNodeBase {
 public:
  angleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct angleGradNodeCompat "; }
  angleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct angleGradNodeCompat "; }
  ~angleGradNodeCompat() override { VLOG(6) << " Destruct angleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "angleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<angleGradNodeCompat>(new angleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reshapeGradNodeCompat : public egr::GradNodeBase {
 public:
  reshapeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reshapeGradNodeCompat "; }
  reshapeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reshapeGradNodeCompat "; }
  ~reshapeGradNodeCompat() override { VLOG(6) << " Destruct reshapeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reshapeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reshapeGradNodeCompat>(new reshapeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class roi_alignGradNodeCompat : public egr::GradNodeBase {
 public:
  roi_alignGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct roi_alignGradNodeCompat "; }
  roi_alignGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct roi_alignGradNodeCompat "; }
  ~roi_alignGradNodeCompat() override { VLOG(6) << " Destruct roi_alignGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   ROIs_.clear();
   RoisNum_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "roi_alignGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<roi_alignGradNodeCompat>(new roi_alignGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperRoisNum(const paddle::experimental::Tensor& RoisNum) {
     RoisNum_ = egr::TensorWrapper(RoisNum, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper RoisNum_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reshape2GradNodeCompat : public egr::GradNodeBase {
 public:
  reshape2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reshape2GradNodeCompat "; }
  reshape2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reshape2GradNodeCompat "; }
  ~reshape2GradNodeCompat() override { VLOG(6) << " Destruct reshape2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reshape2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reshape2GradNodeCompat>(new reshape2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unstackGradNodeCompat : public egr::GradNodeBase {
 public:
  unstackGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unstackGradNodeCompat "; }
  unstackGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unstackGradNodeCompat "; }
  ~unstackGradNodeCompat() override { VLOG(6) << " Destruct unstackGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unstackGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unstackGradNodeCompat>(new unstackGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class scatter_nd_addGradNodeCompat : public egr::GradNodeBase {
 public:
  scatter_nd_addGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct scatter_nd_addGradNodeCompat "; }
  scatter_nd_addGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct scatter_nd_addGradNodeCompat "; }
  ~scatter_nd_addGradNodeCompat() override { VLOG(6) << " Destruct scatter_nd_addGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   Updates_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "scatter_nd_addGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<scatter_nd_addGradNodeCompat>(new scatter_nd_addGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperUpdates(const paddle::experimental::Tensor& Updates) {
     Updates_ = egr::TensorWrapper(Updates, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper Updates_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_reshapeGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_reshapeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_reshapeGradNodeCompat "; }
  sequence_reshapeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_reshapeGradNodeCompat "; }
  ~sequence_reshapeGradNodeCompat() override { VLOG(6) << " Destruct sequence_reshapeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_reshapeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_reshapeGradNodeCompat>(new sequence_reshapeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bilateral_sliceGradNodeCompat : public egr::GradNodeBase {
 public:
  bilateral_sliceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bilateral_sliceGradNodeCompat "; }
  bilateral_sliceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bilateral_sliceGradNodeCompat "; }
  ~bilateral_sliceGradNodeCompat() override { VLOG(6) << " Destruct bilateral_sliceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Grid_.clear();
   Guide_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bilateral_sliceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bilateral_sliceGradNodeCompat>(new bilateral_sliceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperGrid(const paddle::experimental::Tensor& Grid) {
     Grid_ = egr::TensorWrapper(Grid, false);

   }
   void SetTensorWrapperGuide(const paddle::experimental::Tensor& Guide) {
     Guide_ = egr::TensorWrapper(Guide, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Grid_;
   egr::TensorWrapper Guide_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pad_constant_likeGradNodeCompat : public egr::GradNodeBase {
 public:
  pad_constant_likeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pad_constant_likeGradNodeCompat "; }
  pad_constant_likeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pad_constant_likeGradNodeCompat "; }
  ~pad_constant_likeGradNodeCompat() override { VLOG(6) << " Destruct pad_constant_likeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pad_constant_likeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pad_constant_likeGradNodeCompat>(new pad_constant_likeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pool2dGradNodeCompat : public egr::GradNodeBase {
 public:
  pool2dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pool2dGradNodeCompat "; }
  pool2dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pool2dGradNodeCompat "; }
  ~pool2dGradNodeCompat() override { VLOG(6) << " Destruct pool2dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pool2dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pool2dGradNodeCompat>(new pool2dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class imagGradNodeCompat : public egr::GradNodeBase {
 public:
  imagGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct imagGradNodeCompat "; }
  imagGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct imagGradNodeCompat "; }
  ~imagGradNodeCompat() override { VLOG(6) << " Destruct imagGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "imagGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<imagGradNodeCompat>(new imagGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pull_gpups_sparseGradNodeCompat : public egr::GradNodeBase {
 public:
  pull_gpups_sparseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pull_gpups_sparseGradNodeCompat "; }
  pull_gpups_sparseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pull_gpups_sparseGradNodeCompat "; }
  ~pull_gpups_sparseGradNodeCompat() override { VLOG(6) << " Destruct pull_gpups_sparseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: Ids_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pull_gpups_sparseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pull_gpups_sparseGradNodeCompat>(new pull_gpups_sparseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const std::vector<paddle::experimental::Tensor>& Ids) {
     for(const auto& eager_tensor : Ids) {
          Ids_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> Ids_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class eighGradNodeCompat : public egr::GradNodeBase {
 public:
  eighGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct eighGradNodeCompat "; }
  eighGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct eighGradNodeCompat "; }
  ~eighGradNodeCompat() override { VLOG(6) << " Destruct eighGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Eigenvalues_.clear();
   Eigenvectors_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "eighGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<eighGradNodeCompat>(new eighGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEigenvalues(const paddle::experimental::Tensor& Eigenvalues) {
     Eigenvalues_ = egr::TensorWrapper(Eigenvalues, false);

   }
   void SetTensorWrapperEigenvectors(const paddle::experimental::Tensor& Eigenvectors) {
     Eigenvectors_ = egr::TensorWrapper(Eigenvectors, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Eigenvalues_;
   egr::TensorWrapper Eigenvectors_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class stackGradNodeCompat : public egr::GradNodeBase {
 public:
  stackGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct stackGradNodeCompat "; }
  stackGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct stackGradNodeCompat "; }
  ~stackGradNodeCompat() override { VLOG(6) << " Destruct stackGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "stackGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<stackGradNodeCompat>(new stackGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class gru_unitGradNodeCompat : public egr::GradNodeBase {
 public:
  gru_unitGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct gru_unitGradNodeCompat "; }
  gru_unitGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct gru_unitGradNodeCompat "; }
  ~gru_unitGradNodeCompat() override { VLOG(6) << " Destruct gru_unitGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   Gate_.clear();
   HiddenPrev_.clear();
   Input_.clear();
   ResetHiddenPrev_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "gru_unitGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<gru_unitGradNodeCompat>(new gru_unitGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, true);

   }
   void SetTensorWrapperGate(const paddle::experimental::Tensor& Gate) {
     Gate_ = egr::TensorWrapper(Gate, false);

   }
   void SetTensorWrapperHiddenPrev(const paddle::experimental::Tensor& HiddenPrev) {
     HiddenPrev_ = egr::TensorWrapper(HiddenPrev, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperResetHiddenPrev(const paddle::experimental::Tensor& ResetHiddenPrev) {
     ResetHiddenPrev_ = egr::TensorWrapper(ResetHiddenPrev, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Gate_;
   egr::TensorWrapper HiddenPrev_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper ResetHiddenPrev_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat : public egr::GradNodeBase {
 public:
  fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat "; }
  fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat "; }
  ~fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat() override { VLOG(6) << " Destruct fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat>(new fake_channel_wise_quantize_dequantize_abs_maxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unsqueeze2GradNodeCompat : public egr::GradNodeBase {
 public:
  unsqueeze2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unsqueeze2GradNodeCompat "; }
  unsqueeze2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unsqueeze2GradNodeCompat "; }
  ~unsqueeze2GradNodeCompat() override { VLOG(6) << " Destruct unsqueeze2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unsqueeze2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unsqueeze2GradNodeCompat>(new unsqueeze2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class transfer_dtypeGradNodeCompat : public egr::GradNodeBase {
 public:
  transfer_dtypeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct transfer_dtypeGradNodeCompat "; }
  transfer_dtypeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct transfer_dtypeGradNodeCompat "; }
  ~transfer_dtypeGradNodeCompat() override { VLOG(6) << " Destruct transfer_dtypeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "transfer_dtypeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<transfer_dtypeGradNodeCompat>(new transfer_dtypeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bce_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  bce_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bce_lossGradNodeCompat "; }
  bce_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bce_lossGradNodeCompat "; }
  ~bce_lossGradNodeCompat() override { VLOG(6) << " Destruct bce_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bce_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bce_lossGradNodeCompat>(new bce_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class im2sequenceGradNodeCompat : public egr::GradNodeBase {
 public:
  im2sequenceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct im2sequenceGradNodeCompat "; }
  im2sequenceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct im2sequenceGradNodeCompat "; }
  ~im2sequenceGradNodeCompat() override { VLOG(6) << " Destruct im2sequenceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "im2sequenceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<im2sequenceGradNodeCompat>(new im2sequenceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class logcumsumexpGradNodeCompat : public egr::GradNodeBase {
 public:
  logcumsumexpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct logcumsumexpGradNodeCompat "; }
  logcumsumexpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct logcumsumexpGradNodeCompat "; }
  ~logcumsumexpGradNodeCompat() override { VLOG(6) << " Destruct logcumsumexpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "logcumsumexpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<logcumsumexpGradNodeCompat>(new logcumsumexpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class linear_chain_crfGradNodeCompat : public egr::GradNodeBase {
 public:
  linear_chain_crfGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct linear_chain_crfGradNodeCompat "; }
  linear_chain_crfGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct linear_chain_crfGradNodeCompat "; }
  ~linear_chain_crfGradNodeCompat() override { VLOG(6) << " Destruct linear_chain_crfGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Alpha_.clear();
   Emission_.clear();
   EmissionExps_.clear();
   Label_.clear();
   Length_.clear();
   Transition_.clear();
   TransitionExps_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "linear_chain_crfGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<linear_chain_crfGradNodeCompat>(new linear_chain_crfGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperAlpha(const paddle::experimental::Tensor& Alpha) {
     Alpha_ = egr::TensorWrapper(Alpha, false);

   }
   void SetTensorWrapperEmission(const paddle::experimental::Tensor& Emission) {
     Emission_ = egr::TensorWrapper(Emission, true);

   }
   void SetTensorWrapperEmissionExps(const paddle::experimental::Tensor& EmissionExps) {
     EmissionExps_ = egr::TensorWrapper(EmissionExps, false);

   }
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperLength(const paddle::experimental::Tensor& Length) {
     Length_ = egr::TensorWrapper(Length, false);

   }
   void SetTensorWrapperTransition(const paddle::experimental::Tensor& Transition) {
     Transition_ = egr::TensorWrapper(Transition, true);

   }
   void SetTensorWrapperTransitionExps(const paddle::experimental::Tensor& TransitionExps) {
     TransitionExps_ = egr::TensorWrapper(TransitionExps, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Alpha_;
   egr::TensorWrapper Emission_;
   egr::TensorWrapper EmissionExps_;
   egr::TensorWrapper Label_;
   egr::TensorWrapper Length_;
   egr::TensorWrapper Transition_;
   egr::TensorWrapper TransitionExps_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class teacher_student_sigmoid_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  teacher_student_sigmoid_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct teacher_student_sigmoid_lossGradNodeCompat "; }
  teacher_student_sigmoid_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct teacher_student_sigmoid_lossGradNodeCompat "; }
  ~teacher_student_sigmoid_lossGradNodeCompat() override { VLOG(6) << " Destruct teacher_student_sigmoid_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "teacher_student_sigmoid_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<teacher_student_sigmoid_lossGradNodeCompat>(new teacher_student_sigmoid_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lookup_table_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  lookup_table_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lookup_table_v2GradNodeCompat "; }
  lookup_table_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lookup_table_v2GradNodeCompat "; }
  ~lookup_table_v2GradNodeCompat() override { VLOG(6) << " Destruct lookup_table_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   W_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lookup_table_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lookup_table_v2GradNodeCompat>(new lookup_table_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_fmaxGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_fmaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_fmaxGradNodeCompat "; }
  elementwise_fmaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_fmaxGradNodeCompat "; }
  ~elementwise_fmaxGradNodeCompat() override { VLOG(6) << " Destruct elementwise_fmaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_fmaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_fmaxGradNodeCompat>(new elementwise_fmaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class l1_normGradNodeCompat : public egr::GradNodeBase {
 public:
  l1_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct l1_normGradNodeCompat "; }
  l1_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct l1_normGradNodeCompat "; }
  ~l1_normGradNodeCompat() override { VLOG(6) << " Destruct l1_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "l1_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<l1_normGradNodeCompat>(new l1_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sqrtGradNodeCompat : public egr::GradNodeBase {
 public:
  sqrtGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sqrtGradNodeCompat "; }
  sqrtGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sqrtGradNodeCompat "; }
  ~sqrtGradNodeCompat() override { VLOG(6) << " Destruct sqrtGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sqrtGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sqrtGradNodeCompat>(new sqrtGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_elemwise_activationGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_elemwise_activationGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_elemwise_activationGradNodeCompat "; }
  fused_elemwise_activationGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_elemwise_activationGradNodeCompat "; }
  ~fused_elemwise_activationGradNodeCompat() override { VLOG(6) << " Destruct fused_elemwise_activationGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_elemwise_activationGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_elemwise_activationGradNodeCompat>(new fused_elemwise_activationGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class slogdeterminantGradNodeCompat : public egr::GradNodeBase {
 public:
  slogdeterminantGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct slogdeterminantGradNodeCompat "; }
  slogdeterminantGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct slogdeterminantGradNodeCompat "; }
  ~slogdeterminantGradNodeCompat() override { VLOG(6) << " Destruct slogdeterminantGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "slogdeterminantGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<slogdeterminantGradNodeCompat>(new slogdeterminantGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class poissonGradNodeCompat : public egr::GradNodeBase {
 public:
  poissonGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct poissonGradNodeCompat "; }
  poissonGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct poissonGradNodeCompat "; }
  ~poissonGradNodeCompat() override { VLOG(6) << " Destruct poissonGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "poissonGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<poissonGradNodeCompat>(new poissonGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unbindGradNodeCompat : public egr::GradNodeBase {
 public:
  unbindGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unbindGradNodeCompat "; }
  unbindGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unbindGradNodeCompat "; }
  ~unbindGradNodeCompat() override { VLOG(6) << " Destruct unbindGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unbindGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unbindGradNodeCompat>(new unbindGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class dropoutGradNodeCompat : public egr::GradNodeBase {
 public:
  dropoutGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct dropoutGradNodeCompat "; }
  dropoutGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct dropoutGradNodeCompat "; }
  ~dropoutGradNodeCompat() override { VLOG(6) << " Destruct dropoutGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Mask_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "dropoutGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<dropoutGradNodeCompat>(new dropoutGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Mask_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class moving_average_abs_max_scaleGradNodeCompat : public egr::GradNodeBase {
 public:
  moving_average_abs_max_scaleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct moving_average_abs_max_scaleGradNodeCompat "; }
  moving_average_abs_max_scaleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct moving_average_abs_max_scaleGradNodeCompat "; }
  ~moving_average_abs_max_scaleGradNodeCompat() override { VLOG(6) << " Destruct moving_average_abs_max_scaleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "moving_average_abs_max_scaleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<moving_average_abs_max_scaleGradNodeCompat>(new moving_average_abs_max_scaleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class log_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  log_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct log_lossGradNodeCompat "; }
  log_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct log_lossGradNodeCompat "; }
  ~log_lossGradNodeCompat() override { VLOG(6) << " Destruct log_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Labels_.clear();
   Predicted_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "log_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<log_lossGradNodeCompat>(new log_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabels(const paddle::experimental::Tensor& Labels) {
     Labels_ = egr::TensorWrapper(Labels, false);

   }
   void SetTensorWrapperPredicted(const paddle::experimental::Tensor& Predicted) {
     Predicted_ = egr::TensorWrapper(Predicted, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Labels_;
   egr::TensorWrapper Predicted_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class kronGradNodeCompat : public egr::GradNodeBase {
 public:
  kronGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct kronGradNodeCompat "; }
  kronGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct kronGradNodeCompat "; }
  ~kronGradNodeCompat() override { VLOG(6) << " Destruct kronGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "kronGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<kronGradNodeCompat>(new kronGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sigmoid_focal_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  sigmoid_focal_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sigmoid_focal_lossGradNodeCompat "; }
  sigmoid_focal_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sigmoid_focal_lossGradNodeCompat "; }
  ~sigmoid_focal_lossGradNodeCompat() override { VLOG(6) << " Destruct sigmoid_focal_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   FgNum_.clear();
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sigmoid_focal_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sigmoid_focal_lossGradNodeCompat>(new sigmoid_focal_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFgNum(const paddle::experimental::Tensor& FgNum) {
     FgNum_ = egr::TensorWrapper(FgNum, false);

   }
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper FgNum_;
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conv2dGradNodeCompat : public egr::GradNodeBase {
 public:
  conv2dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conv2dGradNodeCompat "; }
  conv2dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conv2dGradNodeCompat "; }
  ~conv2dGradNodeCompat() override { VLOG(6) << " Destruct conv2dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conv2dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conv2dGradNodeCompat>(new conv2dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class uniform_random_inplaceGradNodeCompat : public egr::GradNodeBase {
 public:
  uniform_random_inplaceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct uniform_random_inplaceGradNodeCompat "; }
  uniform_random_inplaceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct uniform_random_inplaceGradNodeCompat "; }
  ~uniform_random_inplaceGradNodeCompat() override { VLOG(6) << " Destruct uniform_random_inplaceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "uniform_random_inplaceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<uniform_random_inplaceGradNodeCompat>(new uniform_random_inplaceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class maxoutGradNodeCompat : public egr::GradNodeBase {
 public:
  maxoutGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct maxoutGradNodeCompat "; }
  maxoutGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct maxoutGradNodeCompat "; }
  ~maxoutGradNodeCompat() override { VLOG(6) << " Destruct maxoutGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "maxoutGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<maxoutGradNodeCompat>(new maxoutGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class linear_interpGradNodeCompat : public egr::GradNodeBase {
 public:
  linear_interpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct linear_interpGradNodeCompat "; }
  linear_interpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct linear_interpGradNodeCompat "; }
  ~linear_interpGradNodeCompat() override { VLOG(6) << " Destruct linear_interpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   OutSize_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "linear_interpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<linear_interpGradNodeCompat>(new linear_interpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutSize(const paddle::experimental::Tensor& OutSize) {
     OutSize_ = egr::TensorWrapper(OutSize, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper OutSize_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class put_along_axisGradNodeCompat : public egr::GradNodeBase {
 public:
  put_along_axisGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct put_along_axisGradNodeCompat "; }
  put_along_axisGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct put_along_axisGradNodeCompat "; }
  ~put_along_axisGradNodeCompat() override { VLOG(6) << " Destruct put_along_axisGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "put_along_axisGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<put_along_axisGradNodeCompat>(new put_along_axisGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class batch_normGradNodeCompat : public egr::GradNodeBase {
 public:
  batch_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct batch_normGradNodeCompat "; }
  batch_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct batch_normGradNodeCompat "; }
  ~batch_normGradNodeCompat() override { VLOG(6) << " Destruct batch_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   ReserveSpace_.clear();
   SavedMean_.clear();
   SavedVariance_.clear();
   Scale_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "batch_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<batch_normGradNodeCompat>(new batch_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperReserveSpace(const paddle::experimental::Tensor& ReserveSpace) {
     ReserveSpace_ = egr::TensorWrapper(ReserveSpace, false);

   }
   void SetTensorWrapperSavedMean(const paddle::experimental::Tensor& SavedMean) {
     SavedMean_ = egr::TensorWrapper(SavedMean, false);

   }
   void SetTensorWrapperSavedVariance(const paddle::experimental::Tensor& SavedVariance) {
     SavedVariance_ = egr::TensorWrapper(SavedVariance, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper ReserveSpace_;
   egr::TensorWrapper SavedMean_;
   egr::TensorWrapper SavedVariance_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_addGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_addGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_addGradNodeCompat "; }
  elementwise_addGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_addGradNodeCompat "; }
  ~elementwise_addGradNodeCompat() override { VLOG(6) << " Destruct elementwise_addGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_addGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_addGradNodeCompat>(new elementwise_addGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class acosGradNodeCompat : public egr::GradNodeBase {
 public:
  acosGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct acosGradNodeCompat "; }
  acosGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct acosGradNodeCompat "; }
  ~acosGradNodeCompat() override { VLOG(6) << " Destruct acosGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "acosGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<acosGradNodeCompat>(new acosGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unpoolGradNodeCompat : public egr::GradNodeBase {
 public:
  unpoolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unpoolGradNodeCompat "; }
  unpoolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unpoolGradNodeCompat "; }
  ~unpoolGradNodeCompat() override { VLOG(6) << " Destruct unpoolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unpoolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unpoolGradNodeCompat>(new unpoolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cumprodGradNodeCompat : public egr::GradNodeBase {
 public:
  cumprodGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cumprodGradNodeCompat "; }
  cumprodGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cumprodGradNodeCompat "; }
  ~cumprodGradNodeCompat() override { VLOG(6) << " Destruct cumprodGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cumprodGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cumprodGradNodeCompat>(new cumprodGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sample_logitsGradNodeCompat : public egr::GradNodeBase {
 public:
  sample_logitsGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sample_logitsGradNodeCompat "; }
  sample_logitsGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sample_logitsGradNodeCompat "; }
  ~sample_logitsGradNodeCompat() override { VLOG(6) << " Destruct sample_logitsGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   LabelsDim_.clear();
   LogitsDim_.clear();
   Samples_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sample_logitsGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sample_logitsGradNodeCompat>(new sample_logitsGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabelsDim(const paddle::experimental::Tensor& LabelsDim) {
     LabelsDim_ = egr::TensorWrapper(LabelsDim, false);

   }
   void SetTensorWrapperLogitsDim(const paddle::experimental::Tensor& LogitsDim) {
     LogitsDim_ = egr::TensorWrapper(LogitsDim, false);

   }
   void SetTensorWrapperSamples(const paddle::experimental::Tensor& Samples) {
     Samples_ = egr::TensorWrapper(Samples, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper LabelsDim_;
   egr::TensorWrapper LogitsDim_;
   egr::TensorWrapper Samples_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pull_box_extended_sparseGradNodeCompat : public egr::GradNodeBase {
 public:
  pull_box_extended_sparseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pull_box_extended_sparseGradNodeCompat "; }
  pull_box_extended_sparseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pull_box_extended_sparseGradNodeCompat "; }
  ~pull_box_extended_sparseGradNodeCompat() override { VLOG(6) << " Destruct pull_box_extended_sparseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: Ids_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pull_box_extended_sparseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pull_box_extended_sparseGradNodeCompat>(new pull_box_extended_sparseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const std::vector<paddle::experimental::Tensor>& Ids) {
     for(const auto& eager_tensor : Ids) {
          Ids_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> Ids_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class crop_tensorGradNodeCompat : public egr::GradNodeBase {
 public:
  crop_tensorGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct crop_tensorGradNodeCompat "; }
  crop_tensorGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct crop_tensorGradNodeCompat "; }
  ~crop_tensorGradNodeCompat() override { VLOG(6) << " Destruct crop_tensorGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Offsets_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "crop_tensorGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<crop_tensorGradNodeCompat>(new crop_tensorGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOffsets(const paddle::experimental::Tensor& Offsets) {
     Offsets_ = egr::TensorWrapper(Offsets, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Offsets_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class deformable_convGradNodeCompat : public egr::GradNodeBase {
 public:
  deformable_convGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct deformable_convGradNodeCompat "; }
  deformable_convGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct deformable_convGradNodeCompat "; }
  ~deformable_convGradNodeCompat() override { VLOG(6) << " Destruct deformable_convGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();
   Mask_.clear();
   Offset_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "deformable_convGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<deformable_convGradNodeCompat>(new deformable_convGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }
   void SetTensorWrapperOffset(const paddle::experimental::Tensor& Offset) {
     Offset_ = egr::TensorWrapper(Offset, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Mask_;
   egr::TensorWrapper Offset_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expand_asGradNodeCompat : public egr::GradNodeBase {
 public:
  expand_asGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expand_asGradNodeCompat "; }
  expand_asGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expand_asGradNodeCompat "; }
  ~expand_asGradNodeCompat() override { VLOG(6) << " Destruct expand_asGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   target_tensor_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expand_asGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expand_asGradNodeCompat>(new expand_asGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrappertarget_tensor(const paddle::experimental::Tensor& target_tensor) {
     target_tensor_ = egr::TensorWrapper(target_tensor, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper target_tensor_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class matrix_powerGradNodeCompat : public egr::GradNodeBase {
 public:
  matrix_powerGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct matrix_powerGradNodeCompat "; }
  matrix_powerGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct matrix_powerGradNodeCompat "; }
  ~matrix_powerGradNodeCompat() override { VLOG(6) << " Destruct matrix_powerGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "matrix_powerGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<matrix_powerGradNodeCompat>(new matrix_powerGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bilinear_interpGradNodeCompat : public egr::GradNodeBase {
 public:
  bilinear_interpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bilinear_interpGradNodeCompat "; }
  bilinear_interpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bilinear_interpGradNodeCompat "; }
  ~bilinear_interpGradNodeCompat() override { VLOG(6) << " Destruct bilinear_interpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   OutSize_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bilinear_interpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bilinear_interpGradNodeCompat>(new bilinear_interpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutSize(const paddle::experimental::Tensor& OutSize) {
     OutSize_ = egr::TensorWrapper(OutSize, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper OutSize_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sigmoidGradNodeCompat : public egr::GradNodeBase {
 public:
  sigmoidGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sigmoidGradNodeCompat "; }
  sigmoidGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sigmoidGradNodeCompat "; }
  ~sigmoidGradNodeCompat() override { VLOG(6) << " Destruct sigmoidGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sigmoidGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sigmoidGradNodeCompat>(new sigmoidGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class inplace_abnGradNodeCompat : public egr::GradNodeBase {
 public:
  inplace_abnGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct inplace_abnGradNodeCompat "; }
  inplace_abnGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct inplace_abnGradNodeCompat "; }
  ~inplace_abnGradNodeCompat() override { VLOG(6) << " Destruct inplace_abnGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   ReserveSpace_.clear();
   SavedMean_.clear();
   SavedVariance_.clear();
   Scale_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "inplace_abnGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<inplace_abnGradNodeCompat>(new inplace_abnGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperReserveSpace(const paddle::experimental::Tensor& ReserveSpace) {
     ReserveSpace_ = egr::TensorWrapper(ReserveSpace, false);

   }
   void SetTensorWrapperSavedMean(const paddle::experimental::Tensor& SavedMean) {
     SavedMean_ = egr::TensorWrapper(SavedMean, false);

   }
   void SetTensorWrapperSavedVariance(const paddle::experimental::Tensor& SavedVariance) {
     SavedVariance_ = egr::TensorWrapper(SavedVariance, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper ReserveSpace_;
   egr::TensorWrapper SavedMean_;
   egr::TensorWrapper SavedVariance_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class softshrinkGradNodeCompat : public egr::GradNodeBase {
 public:
  softshrinkGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct softshrinkGradNodeCompat "; }
  softshrinkGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct softshrinkGradNodeCompat "; }
  ~softshrinkGradNodeCompat() override { VLOG(6) << " Destruct softshrinkGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "softshrinkGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<softshrinkGradNodeCompat>(new softshrinkGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class mulGradNodeCompat : public egr::GradNodeBase {
 public:
  mulGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct mulGradNodeCompat "; }
  mulGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct mulGradNodeCompat "; }
  ~mulGradNodeCompat() override { VLOG(6) << " Destruct mulGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "mulGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<mulGradNodeCompat>(new mulGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class data_normGradNodeCompat : public egr::GradNodeBase {
 public:
  data_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct data_normGradNodeCompat "; }
  data_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct data_normGradNodeCompat "; }
  ~data_normGradNodeCompat() override { VLOG(6) << " Destruct data_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Means_.clear();
   Scales_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "data_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<data_normGradNodeCompat>(new data_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMeans(const paddle::experimental::Tensor& Means) {
     Means_ = egr::TensorWrapper(Means, false);

   }
   void SetTensorWrapperScales(const paddle::experimental::Tensor& Scales) {
     Scales_ = egr::TensorWrapper(Scales, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Means_;
   egr::TensorWrapper Scales_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class asinhGradNodeCompat : public egr::GradNodeBase {
 public:
  asinhGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct asinhGradNodeCompat "; }
  asinhGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct asinhGradNodeCompat "; }
  ~asinhGradNodeCompat() override { VLOG(6) << " Destruct asinhGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "asinhGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<asinhGradNodeCompat>(new asinhGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sppGradNodeCompat : public egr::GradNodeBase {
 public:
  sppGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sppGradNodeCompat "; }
  sppGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sppGradNodeCompat "; }
  ~sppGradNodeCompat() override { VLOG(6) << " Destruct sppGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sppGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sppGradNodeCompat>(new sppGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class floorGradNodeCompat : public egr::GradNodeBase {
 public:
  floorGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct floorGradNodeCompat "; }
  floorGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct floorGradNodeCompat "; }
  ~floorGradNodeCompat() override { VLOG(6) << " Destruct floorGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "floorGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<floorGradNodeCompat>(new floorGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class as_realGradNodeCompat : public egr::GradNodeBase {
 public:
  as_realGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct as_realGradNodeCompat "; }
  as_realGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct as_realGradNodeCompat "; }
  ~as_realGradNodeCompat() override { VLOG(6) << " Destruct as_realGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "as_realGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<as_realGradNodeCompat>(new as_realGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class geluGradNodeCompat : public egr::GradNodeBase {
 public:
  geluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct geluGradNodeCompat "; }
  geluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct geluGradNodeCompat "; }
  ~geluGradNodeCompat() override { VLOG(6) << " Destruct geluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "geluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<geluGradNodeCompat>(new geluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class minusGradNodeCompat : public egr::GradNodeBase {
 public:
  minusGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct minusGradNodeCompat "; }
  minusGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct minusGradNodeCompat "; }
  ~minusGradNodeCompat() override { VLOG(6) << " Destruct minusGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "minusGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<minusGradNodeCompat>(new minusGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class siluGradNodeCompat : public egr::GradNodeBase {
 public:
  siluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct siluGradNodeCompat "; }
  siluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct siluGradNodeCompat "; }
  ~siluGradNodeCompat() override { VLOG(6) << " Destruct siluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "siluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<siluGradNodeCompat>(new siluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class realGradNodeCompat : public egr::GradNodeBase {
 public:
  realGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct realGradNodeCompat "; }
  realGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct realGradNodeCompat "; }
  ~realGradNodeCompat() override { VLOG(6) << " Destruct realGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "realGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<realGradNodeCompat>(new realGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class nearest_interp_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  nearest_interp_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct nearest_interp_v2GradNodeCompat "; }
  nearest_interp_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct nearest_interp_v2GradNodeCompat "; }
  ~nearest_interp_v2GradNodeCompat() override { VLOG(6) << " Destruct nearest_interp_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "nearest_interp_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<nearest_interp_v2GradNodeCompat>(new nearest_interp_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class squeeze2GradNodeCompat : public egr::GradNodeBase {
 public:
  squeeze2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct squeeze2GradNodeCompat "; }
  squeeze2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct squeeze2GradNodeCompat "; }
  ~squeeze2GradNodeCompat() override { VLOG(6) << " Destruct squeeze2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "squeeze2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<squeeze2GradNodeCompat>(new squeeze2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conjGradNodeCompat : public egr::GradNodeBase {
 public:
  conjGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conjGradNodeCompat "; }
  conjGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conjGradNodeCompat "; }
  ~conjGradNodeCompat() override { VLOG(6) << " Destruct conjGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conjGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conjGradNodeCompat>(new conjGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class strided_sliceGradNodeCompat : public egr::GradNodeBase {
 public:
  strided_sliceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct strided_sliceGradNodeCompat "; }
  strided_sliceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct strided_sliceGradNodeCompat "; }
  ~strided_sliceGradNodeCompat() override { VLOG(6) << " Destruct strided_sliceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   EndsTensor_.clear();
for (auto tw: EndsTensorList_)   {
       tw.clear();
     }
   Input_.clear();
   StartsTensor_.clear();
for (auto tw: StartsTensorList_)   {
       tw.clear();
     }
   StridesTensor_.clear();
for (auto tw: StridesTensorList_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "strided_sliceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<strided_sliceGradNodeCompat>(new strided_sliceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEndsTensor(const paddle::experimental::Tensor& EndsTensor) {
     EndsTensor_ = egr::TensorWrapper(EndsTensor, false);

   }
   void SetTensorWrapperEndsTensorList(const std::vector<paddle::experimental::Tensor>& EndsTensorList) {
     for(const auto& eager_tensor : EndsTensorList) {
          EndsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, true);

   }
   void SetTensorWrapperStartsTensor(const paddle::experimental::Tensor& StartsTensor) {
     StartsTensor_ = egr::TensorWrapper(StartsTensor, false);

   }
   void SetTensorWrapperStartsTensorList(const std::vector<paddle::experimental::Tensor>& StartsTensorList) {
     for(const auto& eager_tensor : StartsTensorList) {
          StartsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperStridesTensor(const paddle::experimental::Tensor& StridesTensor) {
     StridesTensor_ = egr::TensorWrapper(StridesTensor, false);

   }
   void SetTensorWrapperStridesTensorList(const std::vector<paddle::experimental::Tensor>& StridesTensorList) {
     for(const auto& eager_tensor : StridesTensorList) {
          StridesTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper EndsTensor_;
   std::vector<egr::TensorWrapper> EndsTensorList_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper StartsTensor_;
   std::vector<egr::TensorWrapper> StartsTensorList_;
   egr::TensorWrapper StridesTensor_;
   std::vector<egr::TensorWrapper> StridesTensorList_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class depthwise_conv2d_transposeGradNodeCompat : public egr::GradNodeBase {
 public:
  depthwise_conv2d_transposeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct depthwise_conv2d_transposeGradNodeCompat "; }
  depthwise_conv2d_transposeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct depthwise_conv2d_transposeGradNodeCompat "; }
  ~depthwise_conv2d_transposeGradNodeCompat() override { VLOG(6) << " Destruct depthwise_conv2d_transposeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "depthwise_conv2d_transposeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<depthwise_conv2d_transposeGradNodeCompat>(new depthwise_conv2d_transposeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class squareGradNodeCompat : public egr::GradNodeBase {
 public:
  squareGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct squareGradNodeCompat "; }
  squareGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct squareGradNodeCompat "; }
  ~squareGradNodeCompat() override { VLOG(6) << " Destruct squareGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "squareGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<squareGradNodeCompat>(new squareGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class var_conv_2dGradNodeCompat : public egr::GradNodeBase {
 public:
  var_conv_2dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct var_conv_2dGradNodeCompat "; }
  var_conv_2dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct var_conv_2dGradNodeCompat "; }
  ~var_conv_2dGradNodeCompat() override { VLOG(6) << " Destruct var_conv_2dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   COLUMN_.clear();
   Col_.clear();
   Out_.clear();
   ROW_.clear();
   W_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "var_conv_2dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<var_conv_2dGradNodeCompat>(new var_conv_2dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperCOLUMN(const paddle::experimental::Tensor& COLUMN) {
     COLUMN_ = egr::TensorWrapper(COLUMN, false);

   }
   void SetTensorWrapperCol(const paddle::experimental::Tensor& Col) {
     Col_ = egr::TensorWrapper(Col, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperROW(const paddle::experimental::Tensor& ROW) {
     ROW_ = egr::TensorWrapper(ROW, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper COLUMN_;
   egr::TensorWrapper Col_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper ROW_;
   egr::TensorWrapper W_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class log1pGradNodeCompat : public egr::GradNodeBase {
 public:
  log1pGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct log1pGradNodeCompat "; }
  log1pGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct log1pGradNodeCompat "; }
  ~log1pGradNodeCompat() override { VLOG(6) << " Destruct log1pGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "log1pGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<log1pGradNodeCompat>(new log1pGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class channel_shuffleGradNodeCompat : public egr::GradNodeBase {
 public:
  channel_shuffleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct channel_shuffleGradNodeCompat "; }
  channel_shuffleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct channel_shuffleGradNodeCompat "; }
  ~channel_shuffleGradNodeCompat() override { VLOG(6) << " Destruct channel_shuffleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "channel_shuffleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<channel_shuffleGradNodeCompat>(new channel_shuffleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class atan2GradNodeCompat : public egr::GradNodeBase {
 public:
  atan2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct atan2GradNodeCompat "; }
  atan2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct atan2GradNodeCompat "; }
  ~atan2GradNodeCompat() override { VLOG(6) << " Destruct atan2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X1_.clear();
   X2_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "atan2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<atan2GradNodeCompat>(new atan2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX1(const paddle::experimental::Tensor& X1) {
     X1_ = egr::TensorWrapper(X1, false);

   }
   void SetTensorWrapperX2(const paddle::experimental::Tensor& X2) {
     X2_ = egr::TensorWrapper(X2, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X1_;
   egr::TensorWrapper X2_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_softmax_mask_upper_triangleGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_softmax_mask_upper_triangleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_softmax_mask_upper_triangleGradNodeCompat "; }
  fused_softmax_mask_upper_triangleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_softmax_mask_upper_triangleGradNodeCompat "; }
  ~fused_softmax_mask_upper_triangleGradNodeCompat() override { VLOG(6) << " Destruct fused_softmax_mask_upper_triangleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_softmax_mask_upper_triangleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_softmax_mask_upper_triangleGradNodeCompat>(new fused_softmax_mask_upper_triangleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class roi_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  roi_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct roi_poolGradNodeCompat "; }
  roi_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct roi_poolGradNodeCompat "; }
  ~roi_poolGradNodeCompat() override { VLOG(6) << " Destruct roi_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Argmax_.clear();
   ROIs_.clear();
   RoisNum_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "roi_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<roi_poolGradNodeCompat>(new roi_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperArgmax(const paddle::experimental::Tensor& Argmax) {
     Argmax_ = egr::TensorWrapper(Argmax, false);

   }
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperRoisNum(const paddle::experimental::Tensor& RoisNum) {
     RoisNum_ = egr::TensorWrapper(RoisNum, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Argmax_;
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper RoisNum_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fft_r2cGradNodeCompat : public egr::GradNodeBase {
 public:
  fft_r2cGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fft_r2cGradNodeCompat "; }
  fft_r2cGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fft_r2cGradNodeCompat "; }
  ~fft_r2cGradNodeCompat() override { VLOG(6) << " Destruct fft_r2cGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fft_r2cGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fft_r2cGradNodeCompat>(new fft_r2cGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class overlap_addGradNodeCompat : public egr::GradNodeBase {
 public:
  overlap_addGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct overlap_addGradNodeCompat "; }
  overlap_addGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct overlap_addGradNodeCompat "; }
  ~overlap_addGradNodeCompat() override { VLOG(6) << " Destruct overlap_addGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "overlap_addGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<overlap_addGradNodeCompat>(new overlap_addGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fill_anyGradNodeCompat : public egr::GradNodeBase {
 public:
  fill_anyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fill_anyGradNodeCompat "; }
  fill_anyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fill_anyGradNodeCompat "; }
  ~fill_anyGradNodeCompat() override { VLOG(6) << " Destruct fill_anyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fill_anyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fill_anyGradNodeCompat>(new fill_anyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_splitGradNodeCompat : public egr::GradNodeBase {
 public:
  c_splitGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_splitGradNodeCompat "; }
  c_splitGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_splitGradNodeCompat "; }
  ~c_splitGradNodeCompat() override { VLOG(6) << " Destruct c_splitGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_splitGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_splitGradNodeCompat>(new c_splitGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class max_pool2d_with_indexGradNodeCompat : public egr::GradNodeBase {
 public:
  max_pool2d_with_indexGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct max_pool2d_with_indexGradNodeCompat "; }
  max_pool2d_with_indexGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct max_pool2d_with_indexGradNodeCompat "; }
  ~max_pool2d_with_indexGradNodeCompat() override { VLOG(6) << " Destruct max_pool2d_with_indexGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Mask_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "max_pool2d_with_indexGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<max_pool2d_with_indexGradNodeCompat>(new max_pool2d_with_indexGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMask(const paddle::experimental::Tensor& Mask) {
     Mask_ = egr::TensorWrapper(Mask, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Mask_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pad3dGradNodeCompat : public egr::GradNodeBase {
 public:
  pad3dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pad3dGradNodeCompat "; }
  pad3dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pad3dGradNodeCompat "; }
  ~pad3dGradNodeCompat() override { VLOG(6) << " Destruct pad3dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pad3dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pad3dGradNodeCompat>(new pad3dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class normGradNodeCompat : public egr::GradNodeBase {
 public:
  normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct normGradNodeCompat "; }
  normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct normGradNodeCompat "; }
  ~normGradNodeCompat() override { VLOG(6) << " Destruct normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Norm_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<normGradNodeCompat>(new normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperNorm(const paddle::experimental::Tensor& Norm) {
     Norm_ = egr::TensorWrapper(Norm, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Norm_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class mishGradNodeCompat : public egr::GradNodeBase {
 public:
  mishGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct mishGradNodeCompat "; }
  mishGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct mishGradNodeCompat "; }
  ~mishGradNodeCompat() override { VLOG(6) << " Destruct mishGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "mishGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<mishGradNodeCompat>(new mishGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class flattenGradNodeCompat : public egr::GradNodeBase {
 public:
  flattenGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct flattenGradNodeCompat "; }
  flattenGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct flattenGradNodeCompat "; }
  ~flattenGradNodeCompat() override { VLOG(6) << " Destruct flattenGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "flattenGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<flattenGradNodeCompat>(new flattenGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class margin_cross_entropyGradNodeCompat : public egr::GradNodeBase {
 public:
  margin_cross_entropyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct margin_cross_entropyGradNodeCompat "; }
  margin_cross_entropyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct margin_cross_entropyGradNodeCompat "; }
  ~margin_cross_entropyGradNodeCompat() override { VLOG(6) << " Destruct margin_cross_entropyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   Logits_.clear();
   Softmax_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "margin_cross_entropyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<margin_cross_entropyGradNodeCompat>(new margin_cross_entropyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperLogits(const paddle::experimental::Tensor& Logits) {
     Logits_ = egr::TensorWrapper(Logits, false);

   }
   void SetTensorWrapperSoftmax(const paddle::experimental::Tensor& Softmax) {
     Softmax_ = egr::TensorWrapper(Softmax, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper Logits_;
   egr::TensorWrapper Softmax_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pull_sparseGradNodeCompat : public egr::GradNodeBase {
 public:
  pull_sparseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pull_sparseGradNodeCompat "; }
  pull_sparseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pull_sparseGradNodeCompat "; }
  ~pull_sparseGradNodeCompat() override { VLOG(6) << " Destruct pull_sparseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: Ids_)   {
       tw.clear();
     }
for (auto tw: W_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pull_sparseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pull_sparseGradNodeCompat>(new pull_sparseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const std::vector<paddle::experimental::Tensor>& Ids) {
     for(const auto& eager_tensor : Ids) {
          Ids_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperW(const std::vector<paddle::experimental::Tensor>& W) {
     for(const auto& eager_tensor : W) {
          W_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> Ids_;
   std::vector<egr::TensorWrapper> W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class powGradNodeCompat : public egr::GradNodeBase {
 public:
  powGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct powGradNodeCompat "; }
  powGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct powGradNodeCompat "; }
  ~powGradNodeCompat() override { VLOG(6) << " Destruct powGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "powGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<powGradNodeCompat>(new powGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class stanhGradNodeCompat : public egr::GradNodeBase {
 public:
  stanhGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct stanhGradNodeCompat "; }
  stanhGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct stanhGradNodeCompat "; }
  ~stanhGradNodeCompat() override { VLOG(6) << " Destruct stanhGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "stanhGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<stanhGradNodeCompat>(new stanhGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class label_smoothGradNodeCompat : public egr::GradNodeBase {
 public:
  label_smoothGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct label_smoothGradNodeCompat "; }
  label_smoothGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct label_smoothGradNodeCompat "; }
  ~label_smoothGradNodeCompat() override { VLOG(6) << " Destruct label_smoothGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "label_smoothGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<label_smoothGradNodeCompat>(new label_smoothGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class foldGradNodeCompat : public egr::GradNodeBase {
 public:
  foldGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct foldGradNodeCompat "; }
  foldGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct foldGradNodeCompat "; }
  ~foldGradNodeCompat() override { VLOG(6) << " Destruct foldGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "foldGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<foldGradNodeCompat>(new foldGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class roi_perspective_transformGradNodeCompat : public egr::GradNodeBase {
 public:
  roi_perspective_transformGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct roi_perspective_transformGradNodeCompat "; }
  roi_perspective_transformGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct roi_perspective_transformGradNodeCompat "; }
  ~roi_perspective_transformGradNodeCompat() override { VLOG(6) << " Destruct roi_perspective_transformGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out2InIdx_.clear();
   Out2InWeights_.clear();
   ROIs_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "roi_perspective_transformGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<roi_perspective_transformGradNodeCompat>(new roi_perspective_transformGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut2InIdx(const paddle::experimental::Tensor& Out2InIdx) {
     Out2InIdx_ = egr::TensorWrapper(Out2InIdx, false);

   }
   void SetTensorWrapperOut2InWeights(const paddle::experimental::Tensor& Out2InWeights) {
     Out2InWeights_ = egr::TensorWrapper(Out2InWeights, false);

   }
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out2InIdx_;
   egr::TensorWrapper Out2InWeights_;
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expandGradNodeCompat : public egr::GradNodeBase {
 public:
  expandGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expandGradNodeCompat "; }
  expandGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expandGradNodeCompat "; }
  ~expandGradNodeCompat() override { VLOG(6) << " Destruct expandGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   ExpandTimes_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expandGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expandGradNodeCompat>(new expandGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperExpandTimes(const paddle::experimental::Tensor& ExpandTimes) {
     ExpandTimes_ = egr::TensorWrapper(ExpandTimes, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper ExpandTimes_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class prroi_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  prroi_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct prroi_poolGradNodeCompat "; }
  prroi_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct prroi_poolGradNodeCompat "; }
  ~prroi_poolGradNodeCompat() override { VLOG(6) << " Destruct prroi_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   BatchRoINums_.clear();
   Out_.clear();
   ROIs_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "prroi_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<prroi_poolGradNodeCompat>(new prroi_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBatchRoINums(const paddle::experimental::Tensor& BatchRoINums) {
     BatchRoINums_ = egr::TensorWrapper(BatchRoINums, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper BatchRoINums_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pool3dGradNodeCompat : public egr::GradNodeBase {
 public:
  pool3dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pool3dGradNodeCompat "; }
  pool3dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pool3dGradNodeCompat "; }
  ~pool3dGradNodeCompat() override { VLOG(6) << " Destruct pool3dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pool3dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pool3dGradNodeCompat>(new pool3dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class frameGradNodeCompat : public egr::GradNodeBase {
 public:
  frameGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct frameGradNodeCompat "; }
  frameGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct frameGradNodeCompat "; }
  ~frameGradNodeCompat() override { VLOG(6) << " Destruct frameGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "frameGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<frameGradNodeCompat>(new frameGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class modeGradNodeCompat : public egr::GradNodeBase {
 public:
  modeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct modeGradNodeCompat "; }
  modeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct modeGradNodeCompat "; }
  ~modeGradNodeCompat() override { VLOG(6) << " Destruct modeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "modeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<modeGradNodeCompat>(new modeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class group_normGradNodeCompat : public egr::GradNodeBase {
 public:
  group_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct group_normGradNodeCompat "; }
  group_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct group_normGradNodeCompat "; }
  ~group_normGradNodeCompat() override { VLOG(6) << " Destruct group_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   Mean_.clear();
   Scale_.clear();
   Variance_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "group_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<group_normGradNodeCompat>(new group_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperMean(const paddle::experimental::Tensor& Mean) {
     Mean_ = egr::TensorWrapper(Mean, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperVariance(const paddle::experimental::Tensor& Variance) {
     Variance_ = egr::TensorWrapper(Variance, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Mean_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper Variance_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_softmax_with_cross_entropyGradNodeCompat : public egr::GradNodeBase {
 public:
  c_softmax_with_cross_entropyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_softmax_with_cross_entropyGradNodeCompat "; }
  c_softmax_with_cross_entropyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_softmax_with_cross_entropyGradNodeCompat "; }
  ~c_softmax_with_cross_entropyGradNodeCompat() override { VLOG(6) << " Destruct c_softmax_with_cross_entropyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   Softmax_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_softmax_with_cross_entropyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_softmax_with_cross_entropyGradNodeCompat>(new c_softmax_with_cross_entropyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperSoftmax(const paddle::experimental::Tensor& Softmax) {
     Softmax_ = egr::TensorWrapper(Softmax, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper Softmax_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_expand_asGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_expand_asGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_expand_asGradNodeCompat "; }
  sequence_expand_asGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_expand_asGradNodeCompat "; }
  ~sequence_expand_asGradNodeCompat() override { VLOG(6) << " Destruct sequence_expand_asGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_expand_asGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_expand_asGradNodeCompat>(new sequence_expand_asGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cos_simGradNodeCompat : public egr::GradNodeBase {
 public:
  cos_simGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cos_simGradNodeCompat "; }
  cos_simGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cos_simGradNodeCompat "; }
  ~cos_simGradNodeCompat() override { VLOG(6) << " Destruct cos_simGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   XNorm_.clear();
   Y_.clear();
   YNorm_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cos_simGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cos_simGradNodeCompat>(new cos_simGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperXNorm(const paddle::experimental::Tensor& XNorm) {
     XNorm_ = egr::TensorWrapper(XNorm, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }
   void SetTensorWrapperYNorm(const paddle::experimental::Tensor& YNorm) {
     YNorm_ = egr::TensorWrapper(YNorm, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper XNorm_;
   egr::TensorWrapper Y_;
   egr::TensorWrapper YNorm_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_fminGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_fminGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_fminGradNodeCompat "; }
  elementwise_fminGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_fminGradNodeCompat "; }
  ~elementwise_fminGradNodeCompat() override { VLOG(6) << " Destruct elementwise_fminGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_fminGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_fminGradNodeCompat>(new elementwise_fminGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class qrGradNodeCompat : public egr::GradNodeBase {
 public:
  qrGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct qrGradNodeCompat "; }
  qrGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct qrGradNodeCompat "; }
  ~qrGradNodeCompat() override { VLOG(6) << " Destruct qrGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Q_.clear();
   R_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "qrGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<qrGradNodeCompat>(new qrGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperQ(const paddle::experimental::Tensor& Q) {
     Q_ = egr::TensorWrapper(Q, false);

   }
   void SetTensorWrapperR(const paddle::experimental::Tensor& R) {
     R_ = egr::TensorWrapper(R, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Q_;
   egr::TensorWrapper R_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class layer_normGradNodeCompat : public egr::GradNodeBase {
 public:
  layer_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct layer_normGradNodeCompat "; }
  layer_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct layer_normGradNodeCompat "; }
  ~layer_normGradNodeCompat() override { VLOG(6) << " Destruct layer_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   Mean_.clear();
   Scale_.clear();
   Variance_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "layer_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<layer_normGradNodeCompat>(new layer_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, true);

   }
   void SetTensorWrapperMean(const paddle::experimental::Tensor& Mean) {
     Mean_ = egr::TensorWrapper(Mean, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperVariance(const paddle::experimental::Tensor& Variance) {
     Variance_ = egr::TensorWrapper(Variance, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Mean_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper Variance_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class acoshGradNodeCompat : public egr::GradNodeBase {
 public:
  acoshGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct acoshGradNodeCompat "; }
  acoshGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct acoshGradNodeCompat "; }
  ~acoshGradNodeCompat() override { VLOG(6) << " Destruct acoshGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "acoshGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<acoshGradNodeCompat>(new acoshGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class stftGradNodeCompat : public egr::GradNodeBase {
 public:
  stftGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct stftGradNodeCompat "; }
  stftGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct stftGradNodeCompat "; }
  ~stftGradNodeCompat() override { VLOG(6) << " Destruct stftGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Window_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "stftGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<stftGradNodeCompat>(new stftGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperWindow(const paddle::experimental::Tensor& Window) {
     Window_ = egr::TensorWrapper(Window, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Window_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class rnnGradNodeCompat : public egr::GradNodeBase {
 public:
  rnnGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rnnGradNodeCompat "; }
  rnnGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rnnGradNodeCompat "; }
  ~rnnGradNodeCompat() override { VLOG(6) << " Destruct rnnGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   DropoutState_.clear();
   Input_.clear();
   Out_.clear();
for (auto tw: PreState_)   {
       tw.clear();
     }
   Reserve_.clear();
   SequenceLength_.clear();
for (auto tw: WeightList_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rnnGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rnnGradNodeCompat>(new rnnGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperDropoutState(const paddle::experimental::Tensor& DropoutState) {
     DropoutState_ = egr::TensorWrapper(DropoutState, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperPreState(const std::vector<paddle::experimental::Tensor>& PreState) {
     for(const auto& eager_tensor : PreState) {
          PreState_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperReserve(const paddle::experimental::Tensor& Reserve) {
     Reserve_ = egr::TensorWrapper(Reserve, false);

   }
   void SetTensorWrapperSequenceLength(const paddle::experimental::Tensor& SequenceLength) {
     SequenceLength_ = egr::TensorWrapper(SequenceLength, false);

   }
   void SetTensorWrapperWeightList(const std::vector<paddle::experimental::Tensor>& WeightList) {
     for(const auto& eager_tensor : WeightList) {
          WeightList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper DropoutState_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Out_;
   std::vector<egr::TensorWrapper> PreState_;
   egr::TensorWrapper Reserve_;
   egr::TensorWrapper SequenceLength_;
   std::vector<egr::TensorWrapper> WeightList_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class hard_sigmoidGradNodeCompat : public egr::GradNodeBase {
 public:
  hard_sigmoidGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct hard_sigmoidGradNodeCompat "; }
  hard_sigmoidGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct hard_sigmoidGradNodeCompat "; }
  ~hard_sigmoidGradNodeCompat() override { VLOG(6) << " Destruct hard_sigmoidGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "hard_sigmoidGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<hard_sigmoidGradNodeCompat>(new hard_sigmoidGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class correlationGradNodeCompat : public egr::GradNodeBase {
 public:
  correlationGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct correlationGradNodeCompat "; }
  correlationGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct correlationGradNodeCompat "; }
  ~correlationGradNodeCompat() override { VLOG(6) << " Destruct correlationGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input1_.clear();
   Input2_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "correlationGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<correlationGradNodeCompat>(new correlationGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput1(const paddle::experimental::Tensor& Input1) {
     Input1_ = egr::TensorWrapper(Input1, false);

   }
   void SetTensorWrapperInput2(const paddle::experimental::Tensor& Input2) {
     Input2_ = egr::TensorWrapper(Input2, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input1_;
   egr::TensorWrapper Input2_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class nanmedianGradNodeCompat : public egr::GradNodeBase {
 public:
  nanmedianGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct nanmedianGradNodeCompat "; }
  nanmedianGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct nanmedianGradNodeCompat "; }
  ~nanmedianGradNodeCompat() override { VLOG(6) << " Destruct nanmedianGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   MedianIndex_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "nanmedianGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<nanmedianGradNodeCompat>(new nanmedianGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperMedianIndex(const paddle::experimental::Tensor& MedianIndex) {
     MedianIndex_ = egr::TensorWrapper(MedianIndex, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper MedianIndex_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class segment_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  segment_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct segment_poolGradNodeCompat "; }
  segment_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct segment_poolGradNodeCompat "; }
  ~segment_poolGradNodeCompat() override { VLOG(6) << " Destruct segment_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   SegmentIds_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "segment_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<segment_poolGradNodeCompat>(new segment_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperSegmentIds(const paddle::experimental::Tensor& SegmentIds) {
     SegmentIds_ = egr::TensorWrapper(SegmentIds, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper SegmentIds_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sync_batch_normGradNodeCompat : public egr::GradNodeBase {
 public:
  sync_batch_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sync_batch_normGradNodeCompat "; }
  sync_batch_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sync_batch_normGradNodeCompat "; }
  ~sync_batch_normGradNodeCompat() override { VLOG(6) << " Destruct sync_batch_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   SavedMean_.clear();
   SavedVariance_.clear();
   Scale_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sync_batch_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sync_batch_normGradNodeCompat>(new sync_batch_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperSavedMean(const paddle::experimental::Tensor& SavedMean) {
     SavedMean_ = egr::TensorWrapper(SavedMean, false);

   }
   void SetTensorWrapperSavedVariance(const paddle::experimental::Tensor& SavedVariance) {
     SavedVariance_ = egr::TensorWrapper(SavedVariance, false);

   }
   void SetTensorWrapperScale(const paddle::experimental::Tensor& Scale) {
     Scale_ = egr::TensorWrapper(Scale, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper SavedMean_;
   egr::TensorWrapper SavedVariance_;
   egr::TensorWrapper Scale_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class filter_by_instagGradNodeCompat : public egr::GradNodeBase {
 public:
  filter_by_instagGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct filter_by_instagGradNodeCompat "; }
  filter_by_instagGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct filter_by_instagGradNodeCompat "; }
  ~filter_by_instagGradNodeCompat() override { VLOG(6) << " Destruct filter_by_instagGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   IndexMap_.clear();
   Ins_.clear();
   LossWeight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "filter_by_instagGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<filter_by_instagGradNodeCompat>(new filter_by_instagGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndexMap(const paddle::experimental::Tensor& IndexMap) {
     IndexMap_ = egr::TensorWrapper(IndexMap, false);

   }
   void SetTensorWrapperIns(const paddle::experimental::Tensor& Ins) {
     Ins_ = egr::TensorWrapper(Ins, false);

   }
   void SetTensorWrapperLossWeight(const paddle::experimental::Tensor& LossWeight) {
     LossWeight_ = egr::TensorWrapper(LossWeight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper IndexMap_;
   egr::TensorWrapper Ins_;
   egr::TensorWrapper LossWeight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expand_as_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  expand_as_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expand_as_v2GradNodeCompat "; }
  expand_as_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expand_as_v2GradNodeCompat "; }
  ~expand_as_v2GradNodeCompat() override { VLOG(6) << " Destruct expand_as_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expand_as_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expand_as_v2GradNodeCompat>(new expand_as_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class diag_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  diag_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct diag_v2GradNodeCompat "; }
  diag_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct diag_v2GradNodeCompat "; }
  ~diag_v2GradNodeCompat() override { VLOG(6) << " Destruct diag_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "diag_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<diag_v2GradNodeCompat>(new diag_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pull_box_sparseGradNodeCompat : public egr::GradNodeBase {
 public:
  pull_box_sparseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pull_box_sparseGradNodeCompat "; }
  pull_box_sparseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pull_box_sparseGradNodeCompat "; }
  ~pull_box_sparseGradNodeCompat() override { VLOG(6) << " Destruct pull_box_sparseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: Ids_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pull_box_sparseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pull_box_sparseGradNodeCompat>(new pull_box_sparseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const std::vector<paddle::experimental::Tensor>& Ids) {
     for(const auto& eager_tensor : Ids) {
          Ids_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> Ids_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class nll_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  nll_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct nll_lossGradNodeCompat "; }
  nll_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct nll_lossGradNodeCompat "; }
  ~nll_lossGradNodeCompat() override { VLOG(6) << " Destruct nll_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   Total_weight_.clear();
   Weight_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "nll_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<nll_lossGradNodeCompat>(new nll_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperTotal_weight(const paddle::experimental::Tensor& Total_weight) {
     Total_weight_ = egr::TensorWrapper(Total_weight, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper Total_weight_;
   egr::TensorWrapper Weight_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class dotGradNodeCompat : public egr::GradNodeBase {
 public:
  dotGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct dotGradNodeCompat "; }
  dotGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct dotGradNodeCompat "; }
  ~dotGradNodeCompat() override { VLOG(6) << " Destruct dotGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "dotGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<dotGradNodeCompat>(new dotGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class scaleGradNodeCompat : public egr::GradNodeBase {
 public:
  scaleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct scaleGradNodeCompat "; }
  scaleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct scaleGradNodeCompat "; }
  ~scaleGradNodeCompat() override { VLOG(6) << " Destruct scaleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "scaleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<scaleGradNodeCompat>(new scaleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class shuffle_batchGradNodeCompat : public egr::GradNodeBase {
 public:
  shuffle_batchGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct shuffle_batchGradNodeCompat "; }
  shuffle_batchGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct shuffle_batchGradNodeCompat "; }
  ~shuffle_batchGradNodeCompat() override { VLOG(6) << " Destruct shuffle_batchGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   ShuffleIdx_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "shuffle_batchGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<shuffle_batchGradNodeCompat>(new shuffle_batchGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperShuffleIdx(const paddle::experimental::Tensor& ShuffleIdx) {
     ShuffleIdx_ = egr::TensorWrapper(ShuffleIdx, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper ShuffleIdx_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class multiplexGradNodeCompat : public egr::GradNodeBase {
 public:
  multiplexGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct multiplexGradNodeCompat "; }
  multiplexGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct multiplexGradNodeCompat "; }
  ~multiplexGradNodeCompat() override { VLOG(6) << " Destruct multiplexGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "multiplexGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<multiplexGradNodeCompat>(new multiplexGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class leaky_reluGradNodeCompat : public egr::GradNodeBase {
 public:
  leaky_reluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct leaky_reluGradNodeCompat "; }
  leaky_reluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct leaky_reluGradNodeCompat "; }
  ~leaky_reluGradNodeCompat() override { VLOG(6) << " Destruct leaky_reluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "leaky_reluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<leaky_reluGradNodeCompat>(new leaky_reluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_powGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_powGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_powGradNodeCompat "; }
  elementwise_powGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_powGradNodeCompat "; }
  ~elementwise_powGradNodeCompat() override { VLOG(6) << " Destruct elementwise_powGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_powGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_powGradNodeCompat>(new elementwise_powGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class p_normGradNodeCompat : public egr::GradNodeBase {
 public:
  p_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct p_normGradNodeCompat "; }
  p_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct p_normGradNodeCompat "; }
  ~p_normGradNodeCompat() override { VLOG(6) << " Destruct p_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "p_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<p_normGradNodeCompat>(new p_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_concatGradNodeCompat : public egr::GradNodeBase {
 public:
  c_concatGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_concatGradNodeCompat "; }
  c_concatGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_concatGradNodeCompat "; }
  ~c_concatGradNodeCompat() override { VLOG(6) << " Destruct c_concatGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_concatGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_concatGradNodeCompat>(new c_concatGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lod_resetGradNodeCompat : public egr::GradNodeBase {
 public:
  lod_resetGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lod_resetGradNodeCompat "; }
  lod_resetGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lod_resetGradNodeCompat "; }
  ~lod_resetGradNodeCompat() override { VLOG(6) << " Destruct lod_resetGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lod_resetGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lod_resetGradNodeCompat>(new lod_resetGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class padGradNodeCompat : public egr::GradNodeBase {
 public:
  padGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct padGradNodeCompat "; }
  padGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct padGradNodeCompat "; }
  ~padGradNodeCompat() override { VLOG(6) << " Destruct padGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "padGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<padGradNodeCompat>(new padGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_convGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_convGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_convGradNodeCompat "; }
  sequence_convGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_convGradNodeCompat "; }
  ~sequence_convGradNodeCompat() override { VLOG(6) << " Destruct sequence_convGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_convGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_convGradNodeCompat>(new sequence_convGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class set_valueGradNodeCompat : public egr::GradNodeBase {
 public:
  set_valueGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct set_valueGradNodeCompat "; }
  set_valueGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct set_valueGradNodeCompat "; }
  ~set_valueGradNodeCompat() override { VLOG(6) << " Destruct set_valueGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: EndsTensorList_)   {
       tw.clear();
     }
for (auto tw: StartsTensorList_)   {
       tw.clear();
     }
for (auto tw: StepsTensorList_)   {
       tw.clear();
     }
   ValueTensor_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "set_valueGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<set_valueGradNodeCompat>(new set_valueGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEndsTensorList(const std::vector<paddle::experimental::Tensor>& EndsTensorList) {
     for(const auto& eager_tensor : EndsTensorList) {
          EndsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperStartsTensorList(const std::vector<paddle::experimental::Tensor>& StartsTensorList) {
     for(const auto& eager_tensor : StartsTensorList) {
          StartsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperStepsTensorList(const std::vector<paddle::experimental::Tensor>& StepsTensorList) {
     for(const auto& eager_tensor : StepsTensorList) {
          StepsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperValueTensor(const paddle::experimental::Tensor& ValueTensor) {
     ValueTensor_ = egr::TensorWrapper(ValueTensor, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> EndsTensorList_;
   std::vector<egr::TensorWrapper> StartsTensorList_;
   std::vector<egr::TensorWrapper> StepsTensorList_;
   egr::TensorWrapper ValueTensor_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class log10GradNodeCompat : public egr::GradNodeBase {
 public:
  log10GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct log10GradNodeCompat "; }
  log10GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct log10GradNodeCompat "; }
  ~log10GradNodeCompat() override { VLOG(6) << " Destruct log10GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "log10GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<log10GradNodeCompat>(new log10GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class center_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  center_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct center_lossGradNodeCompat "; }
  center_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct center_lossGradNodeCompat "; }
  ~center_lossGradNodeCompat() override { VLOG(6) << " Destruct center_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   SampleCenterDiff_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "center_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<center_lossGradNodeCompat>(new center_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperSampleCenterDiff(const paddle::experimental::Tensor& SampleCenterDiff) {
     SampleCenterDiff_ = egr::TensorWrapper(SampleCenterDiff, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper SampleCenterDiff_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sliceGradNodeCompat : public egr::GradNodeBase {
 public:
  sliceGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sliceGradNodeCompat "; }
  sliceGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sliceGradNodeCompat "; }
  ~sliceGradNodeCompat() override { VLOG(6) << " Destruct sliceGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   EndsTensor_.clear();
for (auto tw: EndsTensorList_)   {
       tw.clear();
     }
   Input_.clear();
   StartsTensor_.clear();
for (auto tw: StartsTensorList_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sliceGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sliceGradNodeCompat>(new sliceGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEndsTensor(const paddle::experimental::Tensor& EndsTensor) {
     EndsTensor_ = egr::TensorWrapper(EndsTensor, false);

   }
   void SetTensorWrapperEndsTensorList(const std::vector<paddle::experimental::Tensor>& EndsTensorList) {
     for(const auto& eager_tensor : EndsTensorList) {
          EndsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, true);

   }
   void SetTensorWrapperStartsTensor(const paddle::experimental::Tensor& StartsTensor) {
     StartsTensor_ = egr::TensorWrapper(StartsTensor, false);

   }
   void SetTensorWrapperStartsTensorList(const std::vector<paddle::experimental::Tensor>& StartsTensorList) {
     for(const auto& eager_tensor : StartsTensorList) {
          StartsTensorList_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper EndsTensor_;
   std::vector<egr::TensorWrapper> EndsTensorList_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper StartsTensor_;
   std::vector<egr::TensorWrapper> StartsTensorList_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class meshgridGradNodeCompat : public egr::GradNodeBase {
 public:
  meshgridGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct meshgridGradNodeCompat "; }
  meshgridGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct meshgridGradNodeCompat "; }
  ~meshgridGradNodeCompat() override { VLOG(6) << " Destruct meshgridGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "meshgridGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<meshgridGradNodeCompat>(new meshgridGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class hard_swishGradNodeCompat : public egr::GradNodeBase {
 public:
  hard_swishGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct hard_swishGradNodeCompat "; }
  hard_swishGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct hard_swishGradNodeCompat "; }
  ~hard_swishGradNodeCompat() override { VLOG(6) << " Destruct hard_swishGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "hard_swishGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<hard_swishGradNodeCompat>(new hard_swishGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sinGradNodeCompat : public egr::GradNodeBase {
 public:
  sinGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sinGradNodeCompat "; }
  sinGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sinGradNodeCompat "; }
  ~sinGradNodeCompat() override { VLOG(6) << " Destruct sinGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sinGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sinGradNodeCompat>(new sinGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pad2dGradNodeCompat : public egr::GradNodeBase {
 public:
  pad2dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pad2dGradNodeCompat "; }
  pad2dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pad2dGradNodeCompat "; }
  ~pad2dGradNodeCompat() override { VLOG(6) << " Destruct pad2dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pad2dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pad2dGradNodeCompat>(new pad2dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class inverseGradNodeCompat : public egr::GradNodeBase {
 public:
  inverseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct inverseGradNodeCompat "; }
  inverseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct inverseGradNodeCompat "; }
  ~inverseGradNodeCompat() override { VLOG(6) << " Destruct inverseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Output_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "inverseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<inverseGradNodeCompat>(new inverseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutput(const paddle::experimental::Tensor& Output) {
     Output_ = egr::TensorWrapper(Output, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Output_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class spectral_normGradNodeCompat : public egr::GradNodeBase {
 public:
  spectral_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct spectral_normGradNodeCompat "; }
  spectral_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct spectral_normGradNodeCompat "; }
  ~spectral_normGradNodeCompat() override { VLOG(6) << " Destruct spectral_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   U_.clear();
   V_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "spectral_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<spectral_normGradNodeCompat>(new spectral_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperU(const paddle::experimental::Tensor& U) {
     U_ = egr::TensorWrapper(U, false);

   }
   void SetTensorWrapperV(const paddle::experimental::Tensor& V) {
     V_ = egr::TensorWrapper(V, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper U_;
   egr::TensorWrapper V_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class shuffle_channelGradNodeCompat : public egr::GradNodeBase {
 public:
  shuffle_channelGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct shuffle_channelGradNodeCompat "; }
  shuffle_channelGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct shuffle_channelGradNodeCompat "; }
  ~shuffle_channelGradNodeCompat() override { VLOG(6) << " Destruct shuffle_channelGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "shuffle_channelGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<shuffle_channelGradNodeCompat>(new shuffle_channelGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class psroi_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  psroi_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct psroi_poolGradNodeCompat "; }
  psroi_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct psroi_poolGradNodeCompat "; }
  ~psroi_poolGradNodeCompat() override { VLOG(6) << " Destruct psroi_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   ROIs_.clear();
   RoisNum_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "psroi_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<psroi_poolGradNodeCompat>(new psroi_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperROIs(const paddle::experimental::Tensor& ROIs) {
     ROIs_ = egr::TensorWrapper(ROIs, false);

   }
   void SetTensorWrapperRoisNum(const paddle::experimental::Tensor& RoisNum) {
     RoisNum_ = egr::TensorWrapper(RoisNum, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper ROIs_;
   egr::TensorWrapper RoisNum_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class ceilGradNodeCompat : public egr::GradNodeBase {
 public:
  ceilGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct ceilGradNodeCompat "; }
  ceilGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct ceilGradNodeCompat "; }
  ~ceilGradNodeCompat() override { VLOG(6) << " Destruct ceilGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "ceilGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<ceilGradNodeCompat>(new ceilGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class eigGradNodeCompat : public egr::GradNodeBase {
 public:
  eigGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct eigGradNodeCompat "; }
  eigGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct eigGradNodeCompat "; }
  ~eigGradNodeCompat() override { VLOG(6) << " Destruct eigGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Eigenvalues_.clear();
   Eigenvectors_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "eigGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<eigGradNodeCompat>(new eigGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEigenvalues(const paddle::experimental::Tensor& Eigenvalues) {
     Eigenvalues_ = egr::TensorWrapper(Eigenvalues, false);

   }
   void SetTensorWrapperEigenvectors(const paddle::experimental::Tensor& Eigenvectors) {
     Eigenvectors_ = egr::TensorWrapper(Eigenvectors, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Eigenvalues_;
   egr::TensorWrapper Eigenvectors_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_minGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_minGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_minGradNodeCompat "; }
  reduce_minGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_minGradNodeCompat "; }
  ~reduce_minGradNodeCompat() override { VLOG(6) << " Destruct reduce_minGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_minGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_minGradNodeCompat>(new reduce_minGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cosGradNodeCompat : public egr::GradNodeBase {
 public:
  cosGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cosGradNodeCompat "; }
  cosGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cosGradNodeCompat "; }
  ~cosGradNodeCompat() override { VLOG(6) << " Destruct cosGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cosGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cosGradNodeCompat>(new cosGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cudnn_lstmGradNodeCompat : public egr::GradNodeBase {
 public:
  cudnn_lstmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cudnn_lstmGradNodeCompat "; }
  cudnn_lstmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cudnn_lstmGradNodeCompat "; }
  ~cudnn_lstmGradNodeCompat() override { VLOG(6) << " Destruct cudnn_lstmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   InitC_.clear();
   InitH_.clear();
   Input_.clear();
   Out_.clear();
   Reserve_.clear();
   StateOut_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cudnn_lstmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cudnn_lstmGradNodeCompat>(new cudnn_lstmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInitC(const paddle::experimental::Tensor& InitC) {
     InitC_ = egr::TensorWrapper(InitC, false);

   }
   void SetTensorWrapperInitH(const paddle::experimental::Tensor& InitH) {
     InitH_ = egr::TensorWrapper(InitH, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperReserve(const paddle::experimental::Tensor& Reserve) {
     Reserve_ = egr::TensorWrapper(Reserve, false);

   }
   void SetTensorWrapperStateOut(const paddle::experimental::Tensor& StateOut) {
     StateOut_ = egr::TensorWrapper(StateOut, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper InitC_;
   egr::TensorWrapper InitH_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper Reserve_;
   egr::TensorWrapper StateOut_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_sumGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_sumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_sumGradNodeCompat "; }
  reduce_sumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_sumGradNodeCompat "; }
  ~reduce_sumGradNodeCompat() override { VLOG(6) << " Destruct reduce_sumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_sumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_sumGradNodeCompat>(new reduce_sumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class digammaGradNodeCompat : public egr::GradNodeBase {
 public:
  digammaGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct digammaGradNodeCompat "; }
  digammaGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct digammaGradNodeCompat "; }
  ~digammaGradNodeCompat() override { VLOG(6) << " Destruct digammaGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "digammaGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<digammaGradNodeCompat>(new digammaGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class incrementGradNodeCompat : public egr::GradNodeBase {
 public:
  incrementGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct incrementGradNodeCompat "; }
  incrementGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct incrementGradNodeCompat "; }
  ~incrementGradNodeCompat() override { VLOG(6) << " Destruct incrementGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "incrementGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<incrementGradNodeCompat>(new incrementGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_softmax_maskGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_softmax_maskGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_softmax_maskGradNodeCompat "; }
  fused_softmax_maskGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_softmax_maskGradNodeCompat "; }
  ~fused_softmax_maskGradNodeCompat() override { VLOG(6) << " Destruct fused_softmax_maskGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_softmax_maskGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_softmax_maskGradNodeCompat>(new fused_softmax_maskGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_reverseGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_reverseGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_reverseGradNodeCompat "; }
  sequence_reverseGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_reverseGradNodeCompat "; }
  ~sequence_reverseGradNodeCompat() override { VLOG(6) << " Destruct sequence_reverseGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_reverseGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_reverseGradNodeCompat>(new sequence_reverseGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class eigvalshGradNodeCompat : public egr::GradNodeBase {
 public:
  eigvalshGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct eigvalshGradNodeCompat "; }
  eigvalshGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct eigvalshGradNodeCompat "; }
  ~eigvalshGradNodeCompat() override { VLOG(6) << " Destruct eigvalshGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Eigenvectors_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "eigvalshGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<eigvalshGradNodeCompat>(new eigvalshGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEigenvectors(const paddle::experimental::Tensor& Eigenvectors) {
     Eigenvectors_ = egr::TensorWrapper(Eigenvectors, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Eigenvectors_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class diagonalGradNodeCompat : public egr::GradNodeBase {
 public:
  diagonalGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct diagonalGradNodeCompat "; }
  diagonalGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct diagonalGradNodeCompat "; }
  ~diagonalGradNodeCompat() override { VLOG(6) << " Destruct diagonalGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "diagonalGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<diagonalGradNodeCompat>(new diagonalGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class truncGradNodeCompat : public egr::GradNodeBase {
 public:
  truncGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct truncGradNodeCompat "; }
  truncGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct truncGradNodeCompat "; }
  ~truncGradNodeCompat() override { VLOG(6) << " Destruct truncGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "truncGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<truncGradNodeCompat>(new truncGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class log2GradNodeCompat : public egr::GradNodeBase {
 public:
  log2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct log2GradNodeCompat "; }
  log2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct log2GradNodeCompat "; }
  ~log2GradNodeCompat() override { VLOG(6) << " Destruct log2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "log2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<log2GradNodeCompat>(new log2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tanhGradNodeCompat : public egr::GradNodeBase {
 public:
  tanhGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tanhGradNodeCompat "; }
  tanhGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tanhGradNodeCompat "; }
  ~tanhGradNodeCompat() override { VLOG(6) << " Destruct tanhGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tanhGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tanhGradNodeCompat>(new tanhGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class yolov3_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  yolov3_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct yolov3_lossGradNodeCompat "; }
  yolov3_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct yolov3_lossGradNodeCompat "; }
  ~yolov3_lossGradNodeCompat() override { VLOG(6) << " Destruct yolov3_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   GTBox_.clear();
   GTLabel_.clear();
   GTMatchMask_.clear();
   GTScore_.clear();
   ObjectnessMask_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "yolov3_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<yolov3_lossGradNodeCompat>(new yolov3_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperGTBox(const paddle::experimental::Tensor& GTBox) {
     GTBox_ = egr::TensorWrapper(GTBox, false);

   }
   void SetTensorWrapperGTLabel(const paddle::experimental::Tensor& GTLabel) {
     GTLabel_ = egr::TensorWrapper(GTLabel, false);

   }
   void SetTensorWrapperGTMatchMask(const paddle::experimental::Tensor& GTMatchMask) {
     GTMatchMask_ = egr::TensorWrapper(GTMatchMask, false);

   }
   void SetTensorWrapperGTScore(const paddle::experimental::Tensor& GTScore) {
     GTScore_ = egr::TensorWrapper(GTScore, false);

   }
   void SetTensorWrapperObjectnessMask(const paddle::experimental::Tensor& ObjectnessMask) {
     ObjectnessMask_ = egr::TensorWrapper(ObjectnessMask, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper GTBox_;
   egr::TensorWrapper GTLabel_;
   egr::TensorWrapper GTMatchMask_;
   egr::TensorWrapper GTScore_;
   egr::TensorWrapper ObjectnessMask_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class graph_send_recvGradNodeCompat : public egr::GradNodeBase {
 public:
  graph_send_recvGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct graph_send_recvGradNodeCompat "; }
  graph_send_recvGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct graph_send_recvGradNodeCompat "; }
  ~graph_send_recvGradNodeCompat() override { VLOG(6) << " Destruct graph_send_recvGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Dst_index_.clear();
   Src_index_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "graph_send_recvGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<graph_send_recvGradNodeCompat>(new graph_send_recvGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperDst_index(const paddle::experimental::Tensor& Dst_index) {
     Dst_index_ = egr::TensorWrapper(Dst_index, false);

   }
   void SetTensorWrapperSrc_index(const paddle::experimental::Tensor& Src_index) {
     Src_index_ = egr::TensorWrapper(Src_index, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Dst_index_;
   egr::TensorWrapper Src_index_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class atanGradNodeCompat : public egr::GradNodeBase {
 public:
  atanGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct atanGradNodeCompat "; }
  atanGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct atanGradNodeCompat "; }
  ~atanGradNodeCompat() override { VLOG(6) << " Destruct atanGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "atanGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<atanGradNodeCompat>(new atanGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_amaxGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_amaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_amaxGradNodeCompat "; }
  reduce_amaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_amaxGradNodeCompat "; }
  ~reduce_amaxGradNodeCompat() override { VLOG(6) << " Destruct reduce_amaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_amaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_amaxGradNodeCompat>(new reduce_amaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unsqueezeGradNodeCompat : public egr::GradNodeBase {
 public:
  unsqueezeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unsqueezeGradNodeCompat "; }
  unsqueezeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unsqueezeGradNodeCompat "; }
  ~unsqueezeGradNodeCompat() override { VLOG(6) << " Destruct unsqueezeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unsqueezeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unsqueezeGradNodeCompat>(new unsqueezeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class global_gatherGradNodeCompat : public egr::GradNodeBase {
 public:
  global_gatherGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct global_gatherGradNodeCompat "; }
  global_gatherGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct global_gatherGradNodeCompat "; }
  ~global_gatherGradNodeCompat() override { VLOG(6) << " Destruct global_gatherGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   global_count_.clear();
   local_count_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "global_gatherGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<global_gatherGradNodeCompat>(new global_gatherGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperglobal_count(const paddle::experimental::Tensor& global_count) {
     global_count_ = egr::TensorWrapper(global_count, false);

   }
   void SetTensorWrapperlocal_count(const paddle::experimental::Tensor& local_count) {
     local_count_ = egr::TensorWrapper(local_count, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper global_count_;
   egr::TensorWrapper local_count_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lerpGradNodeCompat : public egr::GradNodeBase {
 public:
  lerpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lerpGradNodeCompat "; }
  lerpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lerpGradNodeCompat "; }
  ~lerpGradNodeCompat() override { VLOG(6) << " Destruct lerpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   Weight_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lerpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lerpGradNodeCompat>(new lerpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper Weight_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class log_softmaxGradNodeCompat : public egr::GradNodeBase {
 public:
  log_softmaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct log_softmaxGradNodeCompat "; }
  log_softmaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct log_softmaxGradNodeCompat "; }
  ~log_softmaxGradNodeCompat() override { VLOG(6) << " Destruct log_softmaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "log_softmaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<log_softmaxGradNodeCompat>(new log_softmaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class top_k_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  top_k_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct top_k_v2GradNodeCompat "; }
  top_k_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct top_k_v2GradNodeCompat "; }
  ~top_k_v2GradNodeCompat() override { VLOG(6) << " Destruct top_k_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "top_k_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<top_k_v2GradNodeCompat>(new top_k_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class castGradNodeCompat : public egr::GradNodeBase {
 public:
  castGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct castGradNodeCompat "; }
  castGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct castGradNodeCompat "; }
  ~castGradNodeCompat() override { VLOG(6) << " Destruct castGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "castGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<castGradNodeCompat>(new castGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tanh_shrinkGradNodeCompat : public egr::GradNodeBase {
 public:
  tanh_shrinkGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tanh_shrinkGradNodeCompat "; }
  tanh_shrinkGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tanh_shrinkGradNodeCompat "; }
  ~tanh_shrinkGradNodeCompat() override { VLOG(6) << " Destruct tanh_shrinkGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tanh_shrinkGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tanh_shrinkGradNodeCompat>(new tanh_shrinkGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class hard_shrinkGradNodeCompat : public egr::GradNodeBase {
 public:
  hard_shrinkGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct hard_shrinkGradNodeCompat "; }
  hard_shrinkGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct hard_shrinkGradNodeCompat "; }
  ~hard_shrinkGradNodeCompat() override { VLOG(6) << " Destruct hard_shrinkGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "hard_shrinkGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<hard_shrinkGradNodeCompat>(new hard_shrinkGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class logitGradNodeCompat : public egr::GradNodeBase {
 public:
  logitGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct logitGradNodeCompat "; }
  logitGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct logitGradNodeCompat "; }
  ~logitGradNodeCompat() override { VLOG(6) << " Destruct logitGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "logitGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<logitGradNodeCompat>(new logitGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_unpadGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_unpadGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_unpadGradNodeCompat "; }
  sequence_unpadGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_unpadGradNodeCompat "; }
  ~sequence_unpadGradNodeCompat() override { VLOG(6) << " Destruct sequence_unpadGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_unpadGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_unpadGradNodeCompat>(new sequence_unpadGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_elemwise_add_activationGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_elemwise_add_activationGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_elemwise_add_activationGradNodeCompat "; }
  fused_elemwise_add_activationGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_elemwise_add_activationGradNodeCompat "; }
  ~fused_elemwise_add_activationGradNodeCompat() override { VLOG(6) << " Destruct fused_elemwise_add_activationGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_elemwise_add_activationGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_elemwise_add_activationGradNodeCompat>(new fused_elemwise_add_activationGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pull_sparse_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  pull_sparse_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pull_sparse_v2GradNodeCompat "; }
  pull_sparse_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pull_sparse_v2GradNodeCompat "; }
  ~pull_sparse_v2GradNodeCompat() override { VLOG(6) << " Destruct pull_sparse_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: Ids_)   {
       tw.clear();
     }
for (auto tw: W_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pull_sparse_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pull_sparse_v2GradNodeCompat>(new pull_sparse_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const std::vector<paddle::experimental::Tensor>& Ids) {
     for(const auto& eager_tensor : Ids) {
          Ids_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperW(const std::vector<paddle::experimental::Tensor>& W) {
     for(const auto& eager_tensor : W) {
          W_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> Ids_;
   std::vector<egr::TensorWrapper> W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class einsumGradNodeCompat : public egr::GradNodeBase {
 public:
  einsumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct einsumGradNodeCompat "; }
  einsumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct einsumGradNodeCompat "; }
  ~einsumGradNodeCompat() override { VLOG(6) << " Destruct einsumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: InnerCache_)   {
       tw.clear();
     }
for (auto tw: XShape_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "einsumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<einsumGradNodeCompat>(new einsumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInnerCache(const std::vector<paddle::experimental::Tensor>& InnerCache) {
     for(const auto& eager_tensor : InnerCache) {
          InnerCache_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }
   void SetTensorWrapperXShape(const std::vector<paddle::experimental::Tensor>& XShape) {
     for(const auto& eager_tensor : XShape) {
          XShape_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> InnerCache_;
   std::vector<egr::TensorWrapper> XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class frobenius_normGradNodeCompat : public egr::GradNodeBase {
 public:
  frobenius_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct frobenius_normGradNodeCompat "; }
  frobenius_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct frobenius_normGradNodeCompat "; }
  ~frobenius_normGradNodeCompat() override { VLOG(6) << " Destruct frobenius_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "frobenius_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<frobenius_normGradNodeCompat>(new frobenius_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cropGradNodeCompat : public egr::GradNodeBase {
 public:
  cropGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cropGradNodeCompat "; }
  cropGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cropGradNodeCompat "; }
  ~cropGradNodeCompat() override { VLOG(6) << " Destruct cropGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Offsets_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cropGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cropGradNodeCompat>(new cropGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOffsets(const paddle::experimental::Tensor& Offsets) {
     Offsets_ = egr::TensorWrapper(Offsets, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Offsets_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cross_entropy2GradNodeCompat : public egr::GradNodeBase {
 public:
  cross_entropy2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cross_entropy2GradNodeCompat "; }
  cross_entropy2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cross_entropy2GradNodeCompat "; }
  ~cross_entropy2GradNodeCompat() override { VLOG(6) << " Destruct cross_entropy2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   MatchX_.clear();
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cross_entropy2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cross_entropy2GradNodeCompat>(new cross_entropy2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperMatchX(const paddle::experimental::Tensor& MatchX) {
     MatchX_ = egr::TensorWrapper(MatchX, false);

   }
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper MatchX_;
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fused_embedding_seq_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  fused_embedding_seq_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fused_embedding_seq_poolGradNodeCompat "; }
  fused_embedding_seq_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fused_embedding_seq_poolGradNodeCompat "; }
  ~fused_embedding_seq_poolGradNodeCompat() override { VLOG(6) << " Destruct fused_embedding_seq_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Ids_.clear();
   W_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fused_embedding_seq_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fused_embedding_seq_poolGradNodeCompat>(new fused_embedding_seq_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIds(const paddle::experimental::Tensor& Ids) {
     Ids_ = egr::TensorWrapper(Ids, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Ids_;
   egr::TensorWrapper W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class kthvalueGradNodeCompat : public egr::GradNodeBase {
 public:
  kthvalueGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct kthvalueGradNodeCompat "; }
  kthvalueGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct kthvalueGradNodeCompat "; }
  ~kthvalueGradNodeCompat() override { VLOG(6) << " Destruct kthvalueGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "kthvalueGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<kthvalueGradNodeCompat>(new kthvalueGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class erfGradNodeCompat : public egr::GradNodeBase {
 public:
  erfGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct erfGradNodeCompat "; }
  erfGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct erfGradNodeCompat "; }
  ~erfGradNodeCompat() override { VLOG(6) << " Destruct erfGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "erfGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<erfGradNodeCompat>(new erfGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class logsumexpGradNodeCompat : public egr::GradNodeBase {
 public:
  logsumexpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct logsumexpGradNodeCompat "; }
  logsumexpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct logsumexpGradNodeCompat "; }
  ~logsumexpGradNodeCompat() override { VLOG(6) << " Destruct logsumexpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "logsumexpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<logsumexpGradNodeCompat>(new logsumexpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class trilinear_interpGradNodeCompat : public egr::GradNodeBase {
 public:
  trilinear_interpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct trilinear_interpGradNodeCompat "; }
  trilinear_interpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct trilinear_interpGradNodeCompat "; }
  ~trilinear_interpGradNodeCompat() override { VLOG(6) << " Destruct trilinear_interpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   OutSize_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "trilinear_interpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<trilinear_interpGradNodeCompat>(new trilinear_interpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutSize(const paddle::experimental::Tensor& OutSize) {
     OutSize_ = egr::TensorWrapper(OutSize, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper OutSize_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_concatGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_concatGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_concatGradNodeCompat "; }
  sequence_concatGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_concatGradNodeCompat "; }
  ~sequence_concatGradNodeCompat() override { VLOG(6) << " Destruct sequence_concatGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_concatGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_concatGradNodeCompat>(new sequence_concatGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , true) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class unpool3dGradNodeCompat : public egr::GradNodeBase {
 public:
  unpool3dGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct unpool3dGradNodeCompat "; }
  unpool3dGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct unpool3dGradNodeCompat "; }
  ~unpool3dGradNodeCompat() override { VLOG(6) << " Destruct unpool3dGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "unpool3dGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<unpool3dGradNodeCompat>(new unpool3dGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class argsortGradNodeCompat : public egr::GradNodeBase {
 public:
  argsortGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct argsortGradNodeCompat "; }
  argsortGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct argsortGradNodeCompat "; }
  ~argsortGradNodeCompat() override { VLOG(6) << " Destruct argsortGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "argsortGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<argsortGradNodeCompat>(new argsortGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_expandGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_expandGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_expandGradNodeCompat "; }
  sequence_expandGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_expandGradNodeCompat "; }
  ~sequence_expandGradNodeCompat() override { VLOG(6) << " Destruct sequence_expandGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_expandGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_expandGradNodeCompat>(new sequence_expandGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class exponentialGradNodeCompat : public egr::GradNodeBase {
 public:
  exponentialGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct exponentialGradNodeCompat "; }
  exponentialGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct exponentialGradNodeCompat "; }
  ~exponentialGradNodeCompat() override { VLOG(6) << " Destruct exponentialGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "exponentialGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<exponentialGradNodeCompat>(new exponentialGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bilinear_interp_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  bilinear_interp_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bilinear_interp_v2GradNodeCompat "; }
  bilinear_interp_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bilinear_interp_v2GradNodeCompat "; }
  ~bilinear_interp_v2GradNodeCompat() override { VLOG(6) << " Destruct bilinear_interp_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bilinear_interp_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bilinear_interp_v2GradNodeCompat>(new bilinear_interp_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class atanhGradNodeCompat : public egr::GradNodeBase {
 public:
  atanhGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct atanhGradNodeCompat "; }
  atanhGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct atanhGradNodeCompat "; }
  ~atanhGradNodeCompat() override { VLOG(6) << " Destruct atanhGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "atanhGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<atanhGradNodeCompat>(new atanhGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class clipGradNodeCompat : public egr::GradNodeBase {
 public:
  clipGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct clipGradNodeCompat "; }
  clipGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct clipGradNodeCompat "; }
  ~clipGradNodeCompat() override { VLOG(6) << " Destruct clipGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "clipGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<clipGradNodeCompat>(new clipGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class deformable_conv_v1GradNodeCompat : public egr::GradNodeBase {
 public:
  deformable_conv_v1GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct deformable_conv_v1GradNodeCompat "; }
  deformable_conv_v1GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct deformable_conv_v1GradNodeCompat "; }
  ~deformable_conv_v1GradNodeCompat() override { VLOG(6) << " Destruct deformable_conv_v1GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();
   Offset_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "deformable_conv_v1GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<deformable_conv_v1GradNodeCompat>(new deformable_conv_v1GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperOffset(const paddle::experimental::Tensor& Offset) {
     Offset_ = egr::TensorWrapper(Offset, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Offset_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class hinge_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  hinge_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct hinge_lossGradNodeCompat "; }
  hinge_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct hinge_lossGradNodeCompat "; }
  ~hinge_lossGradNodeCompat() override { VLOG(6) << " Destruct hinge_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Labels_.clear();
   Logits_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "hinge_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<hinge_lossGradNodeCompat>(new hinge_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabels(const paddle::experimental::Tensor& Labels) {
     Labels_ = egr::TensorWrapper(Labels, false);

   }
   void SetTensorWrapperLogits(const paddle::experimental::Tensor& Logits) {
     Logits_ = egr::TensorWrapper(Logits, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Labels_;
   egr::TensorWrapper Logits_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class determinantGradNodeCompat : public egr::GradNodeBase {
 public:
  determinantGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct determinantGradNodeCompat "; }
  determinantGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct determinantGradNodeCompat "; }
  ~determinantGradNodeCompat() override { VLOG(6) << " Destruct determinantGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Input_.clear();
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "determinantGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<determinantGradNodeCompat>(new determinantGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Input_;
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class conv2d_transposeGradNodeCompat : public egr::GradNodeBase {
 public:
  conv2d_transposeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct conv2d_transposeGradNodeCompat "; }
  conv2d_transposeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct conv2d_transposeGradNodeCompat "; }
  ~conv2d_transposeGradNodeCompat() override { VLOG(6) << " Destruct conv2d_transposeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "conv2d_transposeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<conv2d_transposeGradNodeCompat>(new conv2d_transposeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class softsignGradNodeCompat : public egr::GradNodeBase {
 public:
  softsignGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct softsignGradNodeCompat "; }
  softsignGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct softsignGradNodeCompat "; }
  ~softsignGradNodeCompat() override { VLOG(6) << " Destruct softsignGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "softsignGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<softsignGradNodeCompat>(new softsignGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fake_quantize_dequantize_abs_maxGradNodeCompat : public egr::GradNodeBase {
 public:
  fake_quantize_dequantize_abs_maxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fake_quantize_dequantize_abs_maxGradNodeCompat "; }
  fake_quantize_dequantize_abs_maxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fake_quantize_dequantize_abs_maxGradNodeCompat "; }
  ~fake_quantize_dequantize_abs_maxGradNodeCompat() override { VLOG(6) << " Destruct fake_quantize_dequantize_abs_maxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fake_quantize_dequantize_abs_maxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fake_quantize_dequantize_abs_maxGradNodeCompat>(new fake_quantize_dequantize_abs_maxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class broadcast_tensorsGradNodeCompat : public egr::GradNodeBase {
 public:
  broadcast_tensorsGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct broadcast_tensorsGradNodeCompat "; }
  broadcast_tensorsGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct broadcast_tensorsGradNodeCompat "; }
  ~broadcast_tensorsGradNodeCompat() override { VLOG(6) << " Destruct broadcast_tensorsGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "broadcast_tensorsGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<broadcast_tensorsGradNodeCompat>(new broadcast_tensorsGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , true) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cholesky_solveGradNodeCompat : public egr::GradNodeBase {
 public:
  cholesky_solveGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cholesky_solveGradNodeCompat "; }
  cholesky_solveGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cholesky_solveGradNodeCompat "; }
  ~cholesky_solveGradNodeCompat() override { VLOG(6) << " Destruct cholesky_solveGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cholesky_solveGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cholesky_solveGradNodeCompat>(new cholesky_solveGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class grid_samplerGradNodeCompat : public egr::GradNodeBase {
 public:
  grid_samplerGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct grid_samplerGradNodeCompat "; }
  grid_samplerGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct grid_samplerGradNodeCompat "; }
  ~grid_samplerGradNodeCompat() override { VLOG(6) << " Destruct grid_samplerGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Grid_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "grid_samplerGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<grid_samplerGradNodeCompat>(new grid_samplerGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperGrid(const paddle::experimental::Tensor& Grid) {
     Grid_ = egr::TensorWrapper(Grid, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Grid_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fft_c2rGradNodeCompat : public egr::GradNodeBase {
 public:
  fft_c2rGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fft_c2rGradNodeCompat "; }
  fft_c2rGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fft_c2rGradNodeCompat "; }
  ~fft_c2rGradNodeCompat() override { VLOG(6) << " Destruct fft_c2rGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fft_c2rGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fft_c2rGradNodeCompat>(new fft_c2rGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pyramid_hashGradNodeCompat : public egr::GradNodeBase {
 public:
  pyramid_hashGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pyramid_hashGradNodeCompat "; }
  pyramid_hashGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pyramid_hashGradNodeCompat "; }
  ~pyramid_hashGradNodeCompat() override { VLOG(6) << " Destruct pyramid_hashGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   DropPos_.clear();
   W_.clear();
   X_.clear();
   X_Temp_Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pyramid_hashGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pyramid_hashGradNodeCompat>(new pyramid_hashGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperDropPos(const paddle::experimental::Tensor& DropPos) {
     DropPos_ = egr::TensorWrapper(DropPos, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperX_Temp_Out(const paddle::experimental::Tensor& X_Temp_Out) {
     X_Temp_Out_ = egr::TensorWrapper(X_Temp_Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper DropPos_;
   egr::TensorWrapper W_;
   egr::TensorWrapper X_;
   egr::TensorWrapper X_Temp_Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat : public egr::GradNodeBase {
 public:
  fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat "; }
  fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat "; }
  ~fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat() override { VLOG(6) << " Destruct fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat>(new fake_quantize_dequantize_moving_average_abs_maxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class multi_dotGradNodeCompat : public egr::GradNodeBase {
 public:
  multi_dotGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct multi_dotGradNodeCompat "; }
  multi_dotGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct multi_dotGradNodeCompat "; }
  ~multi_dotGradNodeCompat() override { VLOG(6) << " Destruct multi_dotGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "multi_dotGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<multi_dotGradNodeCompat>(new multi_dotGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_poolGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_poolGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_poolGradNodeCompat "; }
  sequence_poolGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_poolGradNodeCompat "; }
  ~sequence_poolGradNodeCompat() override { VLOG(6) << " Destruct sequence_poolGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_poolGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_poolGradNodeCompat>(new sequence_poolGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class transposeGradNodeCompat : public egr::GradNodeBase {
 public:
  transposeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct transposeGradNodeCompat "; }
  transposeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct transposeGradNodeCompat "; }
  ~transposeGradNodeCompat() override { VLOG(6) << " Destruct transposeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "transposeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<transposeGradNodeCompat>(new transposeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class top_kGradNodeCompat : public egr::GradNodeBase {
 public:
  top_kGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct top_kGradNodeCompat "; }
  top_kGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct top_kGradNodeCompat "; }
  ~top_kGradNodeCompat() override { VLOG(6) << " Destruct top_kGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Indices_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "top_kGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<top_kGradNodeCompat>(new top_kGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndices(const paddle::experimental::Tensor& Indices) {
     Indices_ = egr::TensorWrapper(Indices, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Indices_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class renormGradNodeCompat : public egr::GradNodeBase {
 public:
  renormGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct renormGradNodeCompat "; }
  renormGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct renormGradNodeCompat "; }
  ~renormGradNodeCompat() override { VLOG(6) << " Destruct renormGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "renormGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<renormGradNodeCompat>(new renormGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pixel_unshuffleGradNodeCompat : public egr::GradNodeBase {
 public:
  pixel_unshuffleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pixel_unshuffleGradNodeCompat "; }
  pixel_unshuffleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pixel_unshuffleGradNodeCompat "; }
  ~pixel_unshuffleGradNodeCompat() override { VLOG(6) << " Destruct pixel_unshuffleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pixel_unshuffleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pixel_unshuffleGradNodeCompat>(new pixel_unshuffleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class take_along_axisGradNodeCompat : public egr::GradNodeBase {
 public:
  take_along_axisGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct take_along_axisGradNodeCompat "; }
  take_along_axisGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct take_along_axisGradNodeCompat "; }
  ~take_along_axisGradNodeCompat() override { VLOG(6) << " Destruct take_along_axisGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   Input_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "take_along_axisGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<take_along_axisGradNodeCompat>(new take_along_axisGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper Input_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class distGradNodeCompat : public egr::GradNodeBase {
 public:
  distGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct distGradNodeCompat "; }
  distGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct distGradNodeCompat "; }
  ~distGradNodeCompat() override { VLOG(6) << " Destruct distGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "distGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<distGradNodeCompat>(new distGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class affine_gridGradNodeCompat : public egr::GradNodeBase {
 public:
  affine_gridGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct affine_gridGradNodeCompat "; }
  affine_gridGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct affine_gridGradNodeCompat "; }
  ~affine_gridGradNodeCompat() override { VLOG(6) << " Destruct affine_gridGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "affine_gridGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<affine_gridGradNodeCompat>(new affine_gridGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reciprocalGradNodeCompat : public egr::GradNodeBase {
 public:
  reciprocalGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reciprocalGradNodeCompat "; }
  reciprocalGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reciprocalGradNodeCompat "; }
  ~reciprocalGradNodeCompat() override { VLOG(6) << " Destruct reciprocalGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reciprocalGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reciprocalGradNodeCompat>(new reciprocalGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class fill_diagonal_tensorGradNodeCompat : public egr::GradNodeBase {
 public:
  fill_diagonal_tensorGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct fill_diagonal_tensorGradNodeCompat "; }
  fill_diagonal_tensorGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct fill_diagonal_tensorGradNodeCompat "; }
  ~fill_diagonal_tensorGradNodeCompat() override { VLOG(6) << " Destruct fill_diagonal_tensorGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "fill_diagonal_tensorGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<fill_diagonal_tensorGradNodeCompat>(new fill_diagonal_tensorGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class absGradNodeCompat : public egr::GradNodeBase {
 public:
  absGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct absGradNodeCompat "; }
  absGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct absGradNodeCompat "; }
  ~absGradNodeCompat() override { VLOG(6) << " Destruct absGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "absGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<absGradNodeCompat>(new absGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class partial_concatGradNodeCompat : public egr::GradNodeBase {
 public:
  partial_concatGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct partial_concatGradNodeCompat "; }
  partial_concatGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct partial_concatGradNodeCompat "; }
  ~partial_concatGradNodeCompat() override { VLOG(6) << " Destruct partial_concatGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
for (auto tw: X_)   {
       tw.clear();
     }

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "partial_concatGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<partial_concatGradNodeCompat>(new partial_concatGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const std::vector<paddle::experimental::Tensor>& X) {
     for(const auto& eager_tensor : X) {
          X_.emplace_back( egr::TensorWrapper(eager_tensor , false) );
      }

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   std::vector<egr::TensorWrapper> X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class eluGradNodeCompat : public egr::GradNodeBase {
 public:
  eluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct eluGradNodeCompat "; }
  eluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct eluGradNodeCompat "; }
  ~eluGradNodeCompat() override { VLOG(6) << " Destruct eluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "eluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<eluGradNodeCompat>(new eluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class index_selectGradNodeCompat : public egr::GradNodeBase {
 public:
  index_selectGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct index_selectGradNodeCompat "; }
  index_selectGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct index_selectGradNodeCompat "; }
  ~index_selectGradNodeCompat() override { VLOG(6) << " Destruct index_selectGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "index_selectGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<index_selectGradNodeCompat>(new index_selectGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class row_convGradNodeCompat : public egr::GradNodeBase {
 public:
  row_convGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct row_convGradNodeCompat "; }
  row_convGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct row_convGradNodeCompat "; }
  ~row_convGradNodeCompat() override { VLOG(6) << " Destruct row_convGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Filter_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "row_convGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<row_convGradNodeCompat>(new row_convGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Filter_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class crossGradNodeCompat : public egr::GradNodeBase {
 public:
  crossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct crossGradNodeCompat "; }
  crossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct crossGradNodeCompat "; }
  ~crossGradNodeCompat() override { VLOG(6) << " Destruct crossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "crossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<crossGradNodeCompat>(new crossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_mulGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_mulGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_mulGradNodeCompat "; }
  elementwise_mulGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_mulGradNodeCompat "; }
  ~elementwise_mulGradNodeCompat() override { VLOG(6) << " Destruct elementwise_mulGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_mulGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_mulGradNodeCompat>(new elementwise_mulGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class lstmGradNodeCompat : public egr::GradNodeBase {
 public:
  lstmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct lstmGradNodeCompat "; }
  lstmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct lstmGradNodeCompat "; }
  ~lstmGradNodeCompat() override { VLOG(6) << " Destruct lstmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   BatchCellPreAct_.clear();
   BatchGate_.clear();
   Bias_.clear();
   Cell_.clear();
   Hidden_.clear();
   Input_.clear();
   Weight_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "lstmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<lstmGradNodeCompat>(new lstmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBatchCellPreAct(const paddle::experimental::Tensor& BatchCellPreAct) {
     BatchCellPreAct_ = egr::TensorWrapper(BatchCellPreAct, false);

   }
   void SetTensorWrapperBatchGate(const paddle::experimental::Tensor& BatchGate) {
     BatchGate_ = egr::TensorWrapper(BatchGate, false);

   }
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, false);

   }
   void SetTensorWrapperCell(const paddle::experimental::Tensor& Cell) {
     Cell_ = egr::TensorWrapper(Cell, false);

   }
   void SetTensorWrapperHidden(const paddle::experimental::Tensor& Hidden) {
     Hidden_ = egr::TensorWrapper(Hidden, false);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperWeight(const paddle::experimental::Tensor& Weight) {
     Weight_ = egr::TensorWrapper(Weight, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper BatchCellPreAct_;
   egr::TensorWrapper BatchGate_;
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Cell_;
   egr::TensorWrapper Hidden_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper Weight_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class match_matrix_tensorGradNodeCompat : public egr::GradNodeBase {
 public:
  match_matrix_tensorGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct match_matrix_tensorGradNodeCompat "; }
  match_matrix_tensorGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct match_matrix_tensorGradNodeCompat "; }
  ~match_matrix_tensorGradNodeCompat() override { VLOG(6) << " Destruct match_matrix_tensorGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Tmp_.clear();
   W_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "match_matrix_tensorGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<match_matrix_tensorGradNodeCompat>(new match_matrix_tensorGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperTmp(const paddle::experimental::Tensor& Tmp) {
     Tmp_ = egr::TensorWrapper(Tmp, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Tmp_;
   egr::TensorWrapper W_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_divGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_divGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_divGradNodeCompat "; }
  elementwise_divGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_divGradNodeCompat "; }
  ~elementwise_divGradNodeCompat() override { VLOG(6) << " Destruct elementwise_divGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_divGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_divGradNodeCompat>(new elementwise_divGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class kldiv_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  kldiv_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct kldiv_lossGradNodeCompat "; }
  kldiv_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct kldiv_lossGradNodeCompat "; }
  ~kldiv_lossGradNodeCompat() override { VLOG(6) << " Destruct kldiv_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Target_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "kldiv_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<kldiv_lossGradNodeCompat>(new kldiv_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperTarget(const paddle::experimental::Tensor& Target) {
     Target_ = egr::TensorWrapper(Target, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Target_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cumsumGradNodeCompat : public egr::GradNodeBase {
 public:
  cumsumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cumsumGradNodeCompat "; }
  cumsumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cumsumGradNodeCompat "; }
  ~cumsumGradNodeCompat() override { VLOG(6) << " Destruct cumsumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cumsumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cumsumGradNodeCompat>(new cumsumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sumGradNodeCompat : public egr::GradNodeBase {
 public:
  sumGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sumGradNodeCompat "; }
  sumGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sumGradNodeCompat "; }
  ~sumGradNodeCompat() override { VLOG(6) << " Destruct sumGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sumGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sumGradNodeCompat>(new sumGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class seluGradNodeCompat : public egr::GradNodeBase {
 public:
  seluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct seluGradNodeCompat "; }
  seluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct seluGradNodeCompat "; }
  ~seluGradNodeCompat() override { VLOG(6) << " Destruct seluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "seluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<seluGradNodeCompat>(new seluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class gumbel_softmaxGradNodeCompat : public egr::GradNodeBase {
 public:
  gumbel_softmaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct gumbel_softmaxGradNodeCompat "; }
  gumbel_softmaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct gumbel_softmaxGradNodeCompat "; }
  ~gumbel_softmaxGradNodeCompat() override { VLOG(6) << " Destruct gumbel_softmaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "gumbel_softmaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<gumbel_softmaxGradNodeCompat>(new gumbel_softmaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class meanGradNodeCompat : public egr::GradNodeBase {
 public:
  meanGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct meanGradNodeCompat "; }
  meanGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct meanGradNodeCompat "; }
  ~meanGradNodeCompat() override { VLOG(6) << " Destruct meanGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "meanGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<meanGradNodeCompat>(new meanGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sequence_padGradNodeCompat : public egr::GradNodeBase {
 public:
  sequence_padGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sequence_padGradNodeCompat "; }
  sequence_padGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sequence_padGradNodeCompat "; }
  ~sequence_padGradNodeCompat() override { VLOG(6) << " Destruct sequence_padGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sequence_padGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sequence_padGradNodeCompat>(new sequence_padGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tree_convGradNodeCompat : public egr::GradNodeBase {
 public:
  tree_convGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tree_convGradNodeCompat "; }
  tree_convGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tree_convGradNodeCompat "; }
  ~tree_convGradNodeCompat() override { VLOG(6) << " Destruct tree_convGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   EdgeSet_.clear();
   Filter_.clear();
   NodesVector_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tree_convGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tree_convGradNodeCompat>(new tree_convGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperEdgeSet(const paddle::experimental::Tensor& EdgeSet) {
     EdgeSet_ = egr::TensorWrapper(EdgeSet, false);

   }
   void SetTensorWrapperFilter(const paddle::experimental::Tensor& Filter) {
     Filter_ = egr::TensorWrapper(Filter, false);

   }
   void SetTensorWrapperNodesVector(const paddle::experimental::Tensor& NodesVector) {
     NodesVector_ = egr::TensorWrapper(NodesVector, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper EdgeSet_;
   egr::TensorWrapper Filter_;
   egr::TensorWrapper NodesVector_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class assignGradNodeCompat : public egr::GradNodeBase {
 public:
  assignGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct assignGradNodeCompat "; }
  assignGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct assignGradNodeCompat "; }
  ~assignGradNodeCompat() override { VLOG(6) << " Destruct assignGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "assignGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<assignGradNodeCompat>(new assignGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class flatten_contiguous_rangeGradNodeCompat : public egr::GradNodeBase {
 public:
  flatten_contiguous_rangeGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct flatten_contiguous_rangeGradNodeCompat "; }
  flatten_contiguous_rangeGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct flatten_contiguous_rangeGradNodeCompat "; }
  ~flatten_contiguous_rangeGradNodeCompat() override { VLOG(6) << " Destruct flatten_contiguous_rangeGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   XShape_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "flatten_contiguous_rangeGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<flatten_contiguous_rangeGradNodeCompat>(new flatten_contiguous_rangeGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperXShape(const paddle::experimental::Tensor& XShape) {
     XShape_ = egr::TensorWrapper(XShape, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper XShape_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class tril_triuGradNodeCompat : public egr::GradNodeBase {
 public:
  tril_triuGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct tril_triuGradNodeCompat "; }
  tril_triuGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct tril_triuGradNodeCompat "; }
  ~tril_triuGradNodeCompat() override { VLOG(6) << " Destruct tril_triuGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "tril_triuGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<tril_triuGradNodeCompat>(new tril_triuGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class celuGradNodeCompat : public egr::GradNodeBase {
 public:
  celuGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct celuGradNodeCompat "; }
  celuGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct celuGradNodeCompat "; }
  ~celuGradNodeCompat() override { VLOG(6) << " Destruct celuGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "celuGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<celuGradNodeCompat>(new celuGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_meanGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_meanGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_meanGradNodeCompat "; }
  reduce_meanGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_meanGradNodeCompat "; }
  ~reduce_meanGradNodeCompat() override { VLOG(6) << " Destruct reduce_meanGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_meanGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_meanGradNodeCompat>(new reduce_meanGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class breluGradNodeCompat : public egr::GradNodeBase {
 public:
  breluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct breluGradNodeCompat "; }
  breluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct breluGradNodeCompat "; }
  ~breluGradNodeCompat() override { VLOG(6) << " Destruct breluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "breluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<breluGradNodeCompat>(new breluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class sinhGradNodeCompat : public egr::GradNodeBase {
 public:
  sinhGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct sinhGradNodeCompat "; }
  sinhGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct sinhGradNodeCompat "; }
  ~sinhGradNodeCompat() override { VLOG(6) << " Destruct sinhGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "sinhGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<sinhGradNodeCompat>(new sinhGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class rank_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  rank_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct rank_lossGradNodeCompat "; }
  rank_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct rank_lossGradNodeCompat "; }
  ~rank_lossGradNodeCompat() override { VLOG(6) << " Destruct rank_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   Left_.clear();
   Right_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "rank_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<rank_lossGradNodeCompat>(new rank_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperLeft(const paddle::experimental::Tensor& Left) {
     Left_ = egr::TensorWrapper(Left, false);

   }
   void SetTensorWrapperRight(const paddle::experimental::Tensor& Right) {
     Right_ = egr::TensorWrapper(Right, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper Left_;
   egr::TensorWrapper Right_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reduce_maxGradNodeCompat : public egr::GradNodeBase {
 public:
  reduce_maxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reduce_maxGradNodeCompat "; }
  reduce_maxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reduce_maxGradNodeCompat "; }
  ~reduce_maxGradNodeCompat() override { VLOG(6) << " Destruct reduce_maxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reduce_maxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reduce_maxGradNodeCompat>(new reduce_maxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class expm1GradNodeCompat : public egr::GradNodeBase {
 public:
  expm1GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct expm1GradNodeCompat "; }
  expm1GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct expm1GradNodeCompat "; }
  ~expm1GradNodeCompat() override { VLOG(6) << " Destruct expm1GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "expm1GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<expm1GradNodeCompat>(new expm1GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class squared_l2_normGradNodeCompat : public egr::GradNodeBase {
 public:
  squared_l2_normGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct squared_l2_normGradNodeCompat "; }
  squared_l2_normGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct squared_l2_normGradNodeCompat "; }
  ~squared_l2_normGradNodeCompat() override { VLOG(6) << " Destruct squared_l2_normGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "squared_l2_normGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<squared_l2_normGradNodeCompat>(new squared_l2_normGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_subGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_subGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_subGradNodeCompat "; }
  elementwise_subGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_subGradNodeCompat "; }
  ~elementwise_subGradNodeCompat() override { VLOG(6) << " Destruct elementwise_subGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_subGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_subGradNodeCompat>(new elementwise_subGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class margin_rank_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  margin_rank_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct margin_rank_lossGradNodeCompat "; }
  margin_rank_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct margin_rank_lossGradNodeCompat "; }
  ~margin_rank_lossGradNodeCompat() override { VLOG(6) << " Destruct margin_rank_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Activated_.clear();
   Label_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "margin_rank_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<margin_rank_lossGradNodeCompat>(new margin_rank_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperActivated(const paddle::experimental::Tensor& Activated) {
     Activated_ = egr::TensorWrapper(Activated, false);

   }
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Activated_;
   egr::TensorWrapper Label_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_identityGradNodeCompat : public egr::GradNodeBase {
 public:
  c_identityGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_identityGradNodeCompat "; }
  c_identityGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_identityGradNodeCompat "; }
  ~c_identityGradNodeCompat() override { VLOG(6) << " Destruct c_identityGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_identityGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_identityGradNodeCompat>(new c_identityGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class reluGradNodeCompat : public egr::GradNodeBase {
 public:
  reluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct reluGradNodeCompat "; }
  reluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct reluGradNodeCompat "; }
  ~reluGradNodeCompat() override { VLOG(6) << " Destruct reluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "reluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<reluGradNodeCompat>(new reluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class bmmGradNodeCompat : public egr::GradNodeBase {
 public:
  bmmGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct bmmGradNodeCompat "; }
  bmmGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct bmmGradNodeCompat "; }
  ~bmmGradNodeCompat() override { VLOG(6) << " Destruct bmmGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "bmmGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<bmmGradNodeCompat>(new bmmGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class soft_reluGradNodeCompat : public egr::GradNodeBase {
 public:
  soft_reluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct soft_reluGradNodeCompat "; }
  soft_reluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct soft_reluGradNodeCompat "; }
  ~soft_reluGradNodeCompat() override { VLOG(6) << " Destruct soft_reluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "soft_reluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<soft_reluGradNodeCompat>(new soft_reluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class swishGradNodeCompat : public egr::GradNodeBase {
 public:
  swishGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct swishGradNodeCompat "; }
  swishGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct swishGradNodeCompat "; }
  ~swishGradNodeCompat() override { VLOG(6) << " Destruct swishGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "swishGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<swishGradNodeCompat>(new swishGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class cross_entropyGradNodeCompat : public egr::GradNodeBase {
 public:
  cross_entropyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct cross_entropyGradNodeCompat "; }
  cross_entropyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct cross_entropyGradNodeCompat "; }
  ~cross_entropyGradNodeCompat() override { VLOG(6) << " Destruct cross_entropyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Label_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "cross_entropyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<cross_entropyGradNodeCompat>(new cross_entropyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLabel(const paddle::experimental::Tensor& Label) {
     Label_ = egr::TensorWrapper(Label, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Label_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class identity_lossGradNodeCompat : public egr::GradNodeBase {
 public:
  identity_lossGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct identity_lossGradNodeCompat "; }
  identity_lossGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct identity_lossGradNodeCompat "; }
  ~identity_lossGradNodeCompat() override { VLOG(6) << " Destruct identity_lossGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "identity_lossGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<identity_lossGradNodeCompat>(new identity_lossGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class choleskyGradNodeCompat : public egr::GradNodeBase {
 public:
  choleskyGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct choleskyGradNodeCompat "; }
  choleskyGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct choleskyGradNodeCompat "; }
  ~choleskyGradNodeCompat() override { VLOG(6) << " Destruct choleskyGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "choleskyGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<choleskyGradNodeCompat>(new choleskyGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class batch_fcGradNodeCompat : public egr::GradNodeBase {
 public:
  batch_fcGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct batch_fcGradNodeCompat "; }
  batch_fcGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct batch_fcGradNodeCompat "; }
  ~batch_fcGradNodeCompat() override { VLOG(6) << " Destruct batch_fcGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Bias_.clear();
   Input_.clear();
   W_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "batch_fcGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<batch_fcGradNodeCompat>(new batch_fcGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperBias(const paddle::experimental::Tensor& Bias) {
     Bias_ = egr::TensorWrapper(Bias, true);

   }
   void SetTensorWrapperInput(const paddle::experimental::Tensor& Input) {
     Input_ = egr::TensorWrapper(Input, false);

   }
   void SetTensorWrapperW(const paddle::experimental::Tensor& W) {
     W_ = egr::TensorWrapper(W, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Bias_;
   egr::TensorWrapper Input_;
   egr::TensorWrapper W_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class nearest_interpGradNodeCompat : public egr::GradNodeBase {
 public:
  nearest_interpGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct nearest_interpGradNodeCompat "; }
  nearest_interpGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct nearest_interpGradNodeCompat "; }
  ~nearest_interpGradNodeCompat() override { VLOG(6) << " Destruct nearest_interpGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   OutSize_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "nearest_interpGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<nearest_interpGradNodeCompat>(new nearest_interpGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOutSize(const paddle::experimental::Tensor& OutSize) {
     OutSize_ = egr::TensorWrapper(OutSize, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper OutSize_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class gatherGradNodeCompat : public egr::GradNodeBase {
 public:
  gatherGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct gatherGradNodeCompat "; }
  gatherGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct gatherGradNodeCompat "; }
  ~gatherGradNodeCompat() override { VLOG(6) << " Destruct gatherGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Axis_.clear();
   Index_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "gatherGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<gatherGradNodeCompat>(new gatherGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperAxis(const paddle::experimental::Tensor& Axis) {
     Axis_ = egr::TensorWrapper(Axis, false);

   }
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Axis_;
   egr::TensorWrapper Index_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class trilinear_interp_v2GradNodeCompat : public egr::GradNodeBase {
 public:
  trilinear_interp_v2GradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct trilinear_interp_v2GradNodeCompat "; }
  trilinear_interp_v2GradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct trilinear_interp_v2GradNodeCompat "; }
  ~trilinear_interp_v2GradNodeCompat() override { VLOG(6) << " Destruct trilinear_interp_v2GradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "trilinear_interp_v2GradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<trilinear_interp_v2GradNodeCompat>(new trilinear_interp_v2GradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class c_allgatherGradNodeCompat : public egr::GradNodeBase {
 public:
  c_allgatherGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct c_allgatherGradNodeCompat "; }
  c_allgatherGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct c_allgatherGradNodeCompat "; }
  ~c_allgatherGradNodeCompat() override { VLOG(6) << " Destruct c_allgatherGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "c_allgatherGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<c_allgatherGradNodeCompat>(new c_allgatherGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class luGradNodeCompat : public egr::GradNodeBase {
 public:
  luGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct luGradNodeCompat "; }
  luGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct luGradNodeCompat "; }
  ~luGradNodeCompat() override { VLOG(6) << " Destruct luGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();
   Pivots_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "luGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<luGradNodeCompat>(new luGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }
   void SetTensorWrapperPivots(const paddle::experimental::Tensor& Pivots) {
     Pivots_ = egr::TensorWrapper(Pivots, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;
   egr::TensorWrapper Pivots_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class softmaxGradNodeCompat : public egr::GradNodeBase {
 public:
  softmaxGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct softmaxGradNodeCompat "; }
  softmaxGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct softmaxGradNodeCompat "; }
  ~softmaxGradNodeCompat() override { VLOG(6) << " Destruct softmaxGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "softmaxGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<softmaxGradNodeCompat>(new softmaxGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class index_sampleGradNodeCompat : public egr::GradNodeBase {
 public:
  index_sampleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct index_sampleGradNodeCompat "; }
  index_sampleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct index_sampleGradNodeCompat "; }
  ~index_sampleGradNodeCompat() override { VLOG(6) << " Destruct index_sampleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Index_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "index_sampleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<index_sampleGradNodeCompat>(new index_sampleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperIndex(const paddle::experimental::Tensor& Index) {
     Index_ = egr::TensorWrapper(Index, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, true);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Index_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_minGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_minGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_minGradNodeCompat "; }
  elementwise_minGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_minGradNodeCompat "; }
  ~elementwise_minGradNodeCompat() override { VLOG(6) << " Destruct elementwise_minGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_minGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_minGradNodeCompat>(new elementwise_minGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class erfinvGradNodeCompat : public egr::GradNodeBase {
 public:
  erfinvGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct erfinvGradNodeCompat "; }
  erfinvGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct erfinvGradNodeCompat "; }
  ~erfinvGradNodeCompat() override { VLOG(6) << " Destruct erfinvGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Out_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "erfinvGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<erfinvGradNodeCompat>(new erfinvGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperOut(const paddle::experimental::Tensor& Out) {
     Out_ = egr::TensorWrapper(Out, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Out_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class pixel_shuffleGradNodeCompat : public egr::GradNodeBase {
 public:
  pixel_shuffleGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct pixel_shuffleGradNodeCompat "; }
  pixel_shuffleGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct pixel_shuffleGradNodeCompat "; }
  ~pixel_shuffleGradNodeCompat() override { VLOG(6) << " Destruct pixel_shuffleGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "pixel_shuffleGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<pixel_shuffleGradNodeCompat>(new pixel_shuffleGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class thresholded_reluGradNodeCompat : public egr::GradNodeBase {
 public:
  thresholded_reluGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct thresholded_reluGradNodeCompat "; }
  thresholded_reluGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct thresholded_reluGradNodeCompat "; }
  ~thresholded_reluGradNodeCompat() override { VLOG(6) << " Destruct thresholded_reluGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "thresholded_reluGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<thresholded_reluGradNodeCompat>(new thresholded_reluGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class warpctcGradNodeCompat : public egr::GradNodeBase {
 public:
  warpctcGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct warpctcGradNodeCompat "; }
  warpctcGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct warpctcGradNodeCompat "; }
  ~warpctcGradNodeCompat() override { VLOG(6) << " Destruct warpctcGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   Logits_.clear();
   LogitsLength_.clear();
   WarpCTCGrad_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "warpctcGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<warpctcGradNodeCompat>(new warpctcGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperLogits(const paddle::experimental::Tensor& Logits) {
     Logits_ = egr::TensorWrapper(Logits, true);

   }
   void SetTensorWrapperLogitsLength(const paddle::experimental::Tensor& LogitsLength) {
     LogitsLength_ = egr::TensorWrapper(LogitsLength, false);

   }
   void SetTensorWrapperWarpCTCGrad(const paddle::experimental::Tensor& WarpCTCGrad) {
     WarpCTCGrad_ = egr::TensorWrapper(WarpCTCGrad, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper Logits_;
   egr::TensorWrapper LogitsLength_;
   egr::TensorWrapper WarpCTCGrad_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class elementwise_heavisideGradNodeCompat : public egr::GradNodeBase {
 public:
  elementwise_heavisideGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct elementwise_heavisideGradNodeCompat "; }
  elementwise_heavisideGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct elementwise_heavisideGradNodeCompat "; }
  ~elementwise_heavisideGradNodeCompat() override { VLOG(6) << " Destruct elementwise_heavisideGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   X_.clear();
   Y_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "elementwise_heavisideGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<elementwise_heavisideGradNodeCompat>(new elementwise_heavisideGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }
   void SetTensorWrapperY(const paddle::experimental::Tensor& Y) {
     Y_ = egr::TensorWrapper(Y, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper X_;
   egr::TensorWrapper Y_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class svdGradNodeCompat : public egr::GradNodeBase {
 public:
  svdGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct svdGradNodeCompat "; }
  svdGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct svdGradNodeCompat "; }
  ~svdGradNodeCompat() override { VLOG(6) << " Destruct svdGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 
   S_.clear();
   U_.clear();
   VH_.clear();
   X_.clear();

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "svdGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<svdGradNodeCompat>(new svdGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...
   void SetTensorWrapperS(const paddle::experimental::Tensor& S) {
     S_ = egr::TensorWrapper(S, false);

   }
   void SetTensorWrapperU(const paddle::experimental::Tensor& U) {
     U_ = egr::TensorWrapper(U, false);

   }
   void SetTensorWrapperVH(const paddle::experimental::Tensor& VH) {
     VH_ = egr::TensorWrapper(VH, false);

   }
   void SetTensorWrapperX(const paddle::experimental::Tensor& X) {
     X_ = egr::TensorWrapper(X, false);

   }

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers
   egr::TensorWrapper S_;
   egr::TensorWrapper U_;
   egr::TensorWrapper VH_;
   egr::TensorWrapper X_;

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
class flipGradNodeCompat : public egr::GradNodeBase {
 public:
  flipGradNodeCompat() : egr::GradNodeBase() { VLOG(7) << " Construct flipGradNodeCompat "; }
  flipGradNodeCompat(size_t bwd_in_slot_num, size_t bwd_out_slot_num) : egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) { VLOG(7) << " Construct flipGradNodeCompat "; }
  ~flipGradNodeCompat() override { VLOG(6) << " Destruct flipGradNodeCompat "; }

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;

  void ClearTensorWrappers() override { 

    SetIsTensorWrappersCleared(true);
  }
  std::string name() override { return "flipGradNodeCompat"; } 
 
std::shared_ptr<GradNodeBase> Copy() const override {{
     auto copied_node = std::shared_ptr<flipGradNodeCompat>(new flipGradNodeCompat(*this));
     return copied_node;
 }}
 
  // SetX, SetY, ...

  // SetAttrMap
   void SetAttrMap(paddle::framework::AttributeMap&& attr_map) {
     attr_map_ = std::move(attr_map);
   }
   void SetDefaultAttrMap(paddle::framework::AttributeMap&& default_attr_map) {
     default_attr_map_ = std::move(default_attr_map);
   }

 private:
   // TensorWrappers

   // Attribute Map
   paddle::framework::AttributeMap attr_map_;
   paddle::framework::AttributeMap default_attr_map_;
};
