#include "paddle/fluid/eager/api/generated/fluid_generated/dygraph_forward_api.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/amp_utils.h"
#include "paddle/fluid/eager/amp_auto_cast.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"
#pragma GCC diagnostic ignored "-Wunused-variable"

paddle::experimental::Tensor kldiv_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Target, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("kldiv_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: kldiv_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Target} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("kldiv_loss", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "kldiv_loss");
    auto NEW_Target = egr::AmpAutoCast("Target", Target, amp_dst_dtype, "kldiv_loss");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return kldiv_loss_dygraph_function( NEW_X, NEW_Target, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Target", egr::EagerUtils::TrySyncToVars(Target) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Loss", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Target = egr::EagerUtils::nullable_autograd_meta(Target);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Target);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("kldiv_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Loss;
  egr::EagerUtils::GetOutput(outs["Loss"][0], &Loss);

  {
    paddle::platform::RecordEvent node_creation_record_event("kldiv_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Loss = egr::EagerUtils::autograd_meta(&Loss);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for kldiv_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Loss);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<kldiv_lossGradNodeCompat>(new kldiv_lossGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperTarget(Target);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Loss, 0);
      egr::EagerUtils::SetHistory(p_autograd_Loss, grad_node);
      grad_node->SetGradInMeta(Loss, 0);
      egr::EagerUtils::CheckAndRetainGrad(Loss);

    }
  }

  return Loss;

}


paddle::experimental::Tensor cumsum_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cumsum dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cumsum";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cumsum", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cumsum");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cumsum_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cumsum", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("cumsum node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cumsum "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<cumsumGradNodeCompat>(new cumsumGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor sum_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sum dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sum";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sum", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "sum");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sum_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  std::vector<egr::AutogradMeta*> p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, &p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sum", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("sum node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sum "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sumGradNodeCompat>(new sumGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> proximal_adagrad_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("proximal_adagrad dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: proximal_adagrad";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Param},{Moment},{Grad},{LearningRate} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("proximal_adagrad", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCast("Param", Param, amp_dst_dtype, "proximal_adagrad");
    auto NEW_Moment = egr::AmpAutoCast("Moment", Moment, amp_dst_dtype, "proximal_adagrad");
    auto NEW_Grad = egr::AmpAutoCast("Grad", Grad, amp_dst_dtype, "proximal_adagrad");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "proximal_adagrad");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return proximal_adagrad_dygraph_function( NEW_Param, NEW_Moment, NEW_Grad, NEW_LearningRate, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Moment", egr::EagerUtils::TrySyncToVars(Moment) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ParamOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "MomentOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("proximal_adagrad", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor ParamOut;
  egr::EagerUtils::GetOutput(outs["ParamOut"][0], &ParamOut);
  paddle::experimental::Tensor MomentOut;
  egr::EagerUtils::GetOutput(outs["MomentOut"][0], &MomentOut);


  return std::make_tuple(ParamOut,MomentOut);

}


std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> update_loss_scaling_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& FoundInfinite,const paddle::experimental::Tensor& PrevLossScaling,const paddle::experimental::Tensor& InGoodSteps,const paddle::experimental::Tensor& InBadSteps, std::vector<paddle::experimental::Tensor*>& OutVar, paddle::experimental::Tensor* LossScalingVar, paddle::experimental::Tensor* OutGoodStepsVar, paddle::experimental::Tensor* OutBadStepsVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("update_loss_scaling dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: update_loss_scaling";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X,{FoundInfinite},{PrevLossScaling},{InGoodSteps},{InBadSteps} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("update_loss_scaling", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "update_loss_scaling");
    auto NEW_FoundInfinite = egr::AmpAutoCast("FoundInfinite", FoundInfinite, amp_dst_dtype, "update_loss_scaling");
    auto NEW_PrevLossScaling = egr::AmpAutoCast("PrevLossScaling", PrevLossScaling, amp_dst_dtype, "update_loss_scaling");
    auto NEW_InGoodSteps = egr::AmpAutoCast("InGoodSteps", InGoodSteps, amp_dst_dtype, "update_loss_scaling");
    auto NEW_InBadSteps = egr::AmpAutoCast("InBadSteps", InBadSteps, amp_dst_dtype, "update_loss_scaling");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return update_loss_scaling_dygraph_function( NEW_X, NEW_FoundInfinite, NEW_PrevLossScaling, NEW_InGoodSteps, NEW_InBadSteps, OutVar, LossScalingVar, OutGoodStepsVar, OutBadStepsVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "FoundInfinite", egr::EagerUtils::TrySyncToVars(FoundInfinite) },{ "PrevLossScaling", egr::EagerUtils::TrySyncToVars(PrevLossScaling) },{ "InGoodSteps", egr::EagerUtils::TrySyncToVars(InGoodSteps) },{ "InBadSteps", egr::EagerUtils::TrySyncToVars(InBadSteps) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) },{ "LossScaling", egr::EagerUtils::TrySyncToVars(LossScalingVar) },{ "OutGoodSteps", egr::EagerUtils::TrySyncToVars(OutGoodStepsVar) },{ "OutBadSteps", egr::EagerUtils::TrySyncToVars(OutBadStepsVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("update_loss_scaling", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], OutVar);
  egr::EagerUtils::Output2Result(OutVar, &Out);
  egr::EagerUtils::GetOutput(outs["LossScaling"][0], LossScalingVar);
  paddle::experimental::Tensor& LossScaling = *LossScalingVar;
  egr::EagerUtils::GetOutput(outs["OutGoodSteps"][0], OutGoodStepsVar);
  paddle::experimental::Tensor& OutGoodSteps = *OutGoodStepsVar;
  egr::EagerUtils::GetOutput(outs["OutBadSteps"][0], OutBadStepsVar);
  paddle::experimental::Tensor& OutBadSteps = *OutBadStepsVar;


  return std::make_tuple(Out,LossScaling,OutGoodSteps,OutBadSteps);

}


paddle::experimental::Tensor shard_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("shard_index dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: shard_index";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("shard_index", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "shard_index");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return shard_index_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("shard_index", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor selu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("selu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: selu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("selu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "selu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return selu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("selu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("selu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for selu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<seluGradNodeCompat>(new seluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor gumbel_softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("gumbel_softmax dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: gumbel_softmax";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("gumbel_softmax", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "gumbel_softmax");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gumbel_softmax_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gumbel_softmax", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("gumbel_softmax node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for gumbel_softmax "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<gumbel_softmaxGradNodeCompat>(new gumbel_softmaxGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor mean_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("mean dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: mean";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("mean", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "mean");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mean_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mean", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("mean node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for mean "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<meanGradNodeCompat>(new meanGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> sequence_pad_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& PadValue, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sequence_pad dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sequence_pad";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{PadValue} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sequence_pad", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sequence_pad");
    auto NEW_PadValue = egr::AmpAutoCast("PadValue", PadValue, amp_dst_dtype, "sequence_pad");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sequence_pad_dygraph_function( NEW_X, NEW_PadValue, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "PadValue", egr::EagerUtils::TrySyncToVars(PadValue) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Length", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_PadValue = egr::EagerUtils::nullable_autograd_meta(PadValue);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_PadValue);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_pad", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Length;
  egr::EagerUtils::GetOutput(outs["Length"][0], &Length);

  {
    paddle::platform::RecordEvent node_creation_record_event("sequence_pad node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Length = egr::EagerUtils::autograd_meta(&Length);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sequence_pad "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Length);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sequence_padGradNodeCompat>(new sequence_padGradNodeCompat(2, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Length, 1);
      egr::EagerUtils::SetHistory(p_autograd_Length, grad_node);
      grad_node->SetGradInMeta(Length, 1);
      egr::EagerUtils::CheckAndRetainGrad(Length);

    }
  }

  return std::make_tuple(Out,Length);

}


paddle::experimental::Tensor tree_conv_dygraph_function(const paddle::experimental::Tensor& NodesVector,const paddle::experimental::Tensor& EdgeSet,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("tree_conv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: tree_conv";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {NodesVector},{EdgeSet},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("tree_conv", amp_tensors_vector);

    auto NEW_NodesVector = egr::AmpAutoCast("NodesVector", NodesVector, amp_dst_dtype, "tree_conv");
    auto NEW_EdgeSet = egr::AmpAutoCast("EdgeSet", EdgeSet, amp_dst_dtype, "tree_conv");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "tree_conv");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tree_conv_dygraph_function( NEW_NodesVector, NEW_EdgeSet, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "NodesVector", egr::EagerUtils::TrySyncToVars(NodesVector) },{ "EdgeSet", egr::EagerUtils::TrySyncToVars(EdgeSet) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_NodesVector = egr::EagerUtils::nullable_autograd_meta(NodesVector);
  egr::AutogradMeta* p_autograd_EdgeSet = egr::EagerUtils::nullable_autograd_meta(EdgeSet);
  egr::AutogradMeta* p_autograd_Filter = egr::EagerUtils::nullable_autograd_meta(Filter);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_NodesVector, p_autograd_EdgeSet, p_autograd_Filter);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tree_conv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("tree_conv node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for tree_conv "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<tree_convGradNodeCompat>(new tree_convGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperEdgeSet(EdgeSet);
      grad_node->SetTensorWrapperFilter(Filter);
      grad_node->SetTensorWrapperNodesVector(NodesVector);

      grad_node->SetGradOutMeta(NodesVector, 0);
      grad_node->SetGradOutMeta(Filter, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor assign_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("assign dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: assign";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = {  };
    if(X.initialized()) amp_tensors_vector.push_back({ X });

    auto amp_dst_dtype = egr::GetAmpDestDtype("assign", amp_tensors_vector);

    auto NEW_X = ((X.initialized()) ? egr::AmpAutoCast("X", X, amp_dst_dtype, "assign") : X);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return assign_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };
  if(X.initialized()) ins["X"] = egr::EagerUtils::TrySyncToVars(X);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("assign", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;

  {
    paddle::platform::RecordEvent node_creation_record_event("assign node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for assign "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<assignGradNodeCompat>(new assignGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten_contiguous_range_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten_contiguous_range dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: flatten_contiguous_range";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("flatten_contiguous_range", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "flatten_contiguous_range");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return flatten_contiguous_range_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };

  if (ins.count("X") && outs.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins["X"][0], outs["Out"][0]);
  };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten_contiguous_range", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("flatten_contiguous_range node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for flatten_contiguous_range "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<flatten_contiguous_rangeGradNodeCompat>(new flatten_contiguous_rangeGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(Out,XShape);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten_contiguous_range__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("flatten_contiguous_range dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: flatten_contiguous_range";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] },{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flatten_contiguous_range", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("flatten_contiguous_range node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for flatten_contiguous_range "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<flatten_contiguous_rangeGradNodeCompat>(new flatten_contiguous_rangeGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(X,XShape);

}


paddle::experimental::Tensor tril_triu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("tril_triu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: tril_triu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("tril_triu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "tril_triu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tril_triu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tril_triu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("tril_triu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for tril_triu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<tril_triuGradNodeCompat>(new tril_triuGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor celu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("celu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: celu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("celu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "celu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return celu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("celu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("celu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for celu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<celuGradNodeCompat>(new celuGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor celu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("celu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: celu";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("celu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("celu node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for celu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<celuGradNodeCompat>(new celuGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor reduce_mean_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("reduce_mean dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: reduce_mean";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("reduce_mean", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "reduce_mean");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reduce_mean_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_mean", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("reduce_mean node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for reduce_mean "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<reduce_meanGradNodeCompat>(new reduce_meanGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor brelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("brelu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: brelu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("brelu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "brelu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return brelu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("brelu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("brelu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for brelu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<breluGradNodeCompat>(new breluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor sinh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sinh dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sinh";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sinh", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sinh");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sinh_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sinh", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("sinh node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sinh "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sinhGradNodeCompat>(new sinhGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor rank_loss_dygraph_function(const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Left,const paddle::experimental::Tensor& Right, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("rank_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: rank_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Label},{Left},{Right} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("rank_loss", amp_tensors_vector);

    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "rank_loss");
    auto NEW_Left = egr::AmpAutoCast("Left", Left, amp_dst_dtype, "rank_loss");
    auto NEW_Right = egr::AmpAutoCast("Right", Right, amp_dst_dtype, "rank_loss");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return rank_loss_dygraph_function( NEW_Label, NEW_Left, NEW_Right, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Label", egr::EagerUtils::TrySyncToVars(Label) },{ "Left", egr::EagerUtils::TrySyncToVars(Left) },{ "Right", egr::EagerUtils::TrySyncToVars(Right) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);
  egr::AutogradMeta* p_autograd_Left = egr::EagerUtils::nullable_autograd_meta(Left);
  egr::AutogradMeta* p_autograd_Right = egr::EagerUtils::nullable_autograd_meta(Right);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Label, p_autograd_Left, p_autograd_Right);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("rank_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("rank_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for rank_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<rank_lossGradNodeCompat>(new rank_lossGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperLeft(Left);
      grad_node->SetTensorWrapperRight(Right);

      grad_node->SetGradOutMeta(Left, 1);
      grad_node->SetGradOutMeta(Right, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor reduce_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("reduce_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: reduce_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("reduce_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "reduce_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reduce_max_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("reduce_max node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for reduce_max "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<reduce_maxGradNodeCompat>(new reduce_maxGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_gru_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& WeightX,const paddle::experimental::Tensor& WeightH, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fusion_gru dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fusion_gru";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{WeightX},{WeightH} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fusion_gru", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fusion_gru");
    auto NEW_WeightX = egr::AmpAutoCast("WeightX", WeightX, amp_dst_dtype, "fusion_gru");
    auto NEW_WeightH = egr::AmpAutoCast("WeightH", WeightH, amp_dst_dtype, "fusion_gru");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fusion_gru_dygraph_function( NEW_X, NEW_WeightX, NEW_WeightH, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "WeightX", egr::EagerUtils::TrySyncToVars(WeightX) },{ "WeightH", egr::EagerUtils::TrySyncToVars(WeightH) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ReorderedH0", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "XX", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "BatchedInput", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "BatchedOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Hidden", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fusion_gru", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor ReorderedH0;
  egr::EagerUtils::GetOutput(outs["ReorderedH0"][0], &ReorderedH0);
  paddle::experimental::Tensor XX;
  egr::EagerUtils::GetOutput(outs["XX"][0], &XX);
  paddle::experimental::Tensor BatchedInput;
  egr::EagerUtils::GetOutput(outs["BatchedInput"][0], &BatchedInput);
  paddle::experimental::Tensor BatchedOut;
  egr::EagerUtils::GetOutput(outs["BatchedOut"][0], &BatchedOut);
  paddle::experimental::Tensor Hidden;
  egr::EagerUtils::GetOutput(outs["Hidden"][0], &Hidden);


  return std::make_tuple(ReorderedH0,XX,BatchedInput,BatchedOut,Hidden);

}


paddle::experimental::Tensor fill_zeros_like2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_zeros_like2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_zeros_like2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fill_zeros_like2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fill_zeros_like2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_zeros_like2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_zeros_like2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor expm1_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("expm1 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: expm1";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("expm1", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "expm1");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return expm1_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expm1", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("expm1 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for expm1 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<expm1GradNodeCompat>(new expm1GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor expm1__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("expm1 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: expm1";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expm1", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("expm1 node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for expm1 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<expm1GradNodeCompat>(new expm1GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor squared_l2_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("squared_l2_norm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: squared_l2_norm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("squared_l2_norm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "squared_l2_norm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return squared_l2_norm_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squared_l2_norm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("squared_l2_norm node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for squared_l2_norm "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squared_l2_normGradNodeCompat>(new squared_l2_normGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor elementwise_sub_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_sub dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_sub";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("elementwise_sub", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "elementwise_sub");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "elementwise_sub");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elementwise_sub_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_sub", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_sub node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_sub "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_subGradNodeCompat>(new elementwise_subGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor elementwise_sub__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_sub dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_sub";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_sub", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_sub node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_sub "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_subGradNodeCompat>(new elementwise_subGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> margin_rank_loss_dygraph_function(const paddle::experimental::Tensor& X1,const paddle::experimental::Tensor& X2,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("margin_rank_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: margin_rank_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X1},{X2},{Label} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("margin_rank_loss", amp_tensors_vector);

    auto NEW_X1 = egr::AmpAutoCast("X1", X1, amp_dst_dtype, "margin_rank_loss");
    auto NEW_X2 = egr::AmpAutoCast("X2", X2, amp_dst_dtype, "margin_rank_loss");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "margin_rank_loss");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return margin_rank_loss_dygraph_function( NEW_X1, NEW_X2, NEW_Label, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X1", egr::EagerUtils::TrySyncToVars(X1) },{ "X2", egr::EagerUtils::TrySyncToVars(X2) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Activated", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X1 = egr::EagerUtils::nullable_autograd_meta(X1);
  egr::AutogradMeta* p_autograd_X2 = egr::EagerUtils::nullable_autograd_meta(X2);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X1, p_autograd_X2, p_autograd_Label);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("margin_rank_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Activated;
  egr::EagerUtils::GetOutput(outs["Activated"][0], &Activated);
  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("margin_rank_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Activated = egr::EagerUtils::autograd_meta(&Activated);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for margin_rank_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Activated, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<margin_rank_lossGradNodeCompat>(new margin_rank_lossGradNodeCompat(2, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperActivated(Activated);
      grad_node->SetTensorWrapperLabel(Label);

      grad_node->SetGradOutMeta(X1, 0);
      grad_node->SetGradOutMeta(X2, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Activated, 0);
      grad_node->SetGradInMeta(Activated, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 1);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 1);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return std::make_tuple(Activated,Out);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> faster_tokenizer_dygraph_function(const paddle::experimental::Tensor& Vocab,const paddle::experimental::Tensor& Text,const paddle::experimental::Tensor& TextPair, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("faster_tokenizer dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: faster_tokenizer";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Vocab},{Text} };
    if(TextPair.initialized()) amp_tensors_vector.push_back({ TextPair });

    auto amp_dst_dtype = egr::GetAmpDestDtype("faster_tokenizer", amp_tensors_vector);

    auto NEW_Vocab = egr::AmpAutoCast("Vocab", Vocab, amp_dst_dtype, "faster_tokenizer");
    auto NEW_Text = egr::AmpAutoCast("Text", Text, amp_dst_dtype, "faster_tokenizer");
    auto NEW_TextPair = ((TextPair.initialized()) ? egr::AmpAutoCast("TextPair", TextPair, amp_dst_dtype, "faster_tokenizer") : TextPair);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return faster_tokenizer_dygraph_function( NEW_Vocab, NEW_Text, NEW_TextPair, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Vocab", egr::EagerUtils::TrySyncToVars(Vocab) },{ "Text", egr::EagerUtils::TrySyncToVars(Text) } };
  if(TextPair.initialized()) ins["TextPair"] = egr::EagerUtils::TrySyncToVars(TextPair);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "InputIds", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SegmentIds", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("faster_tokenizer", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor InputIds;
  egr::EagerUtils::GetOutput(outs["InputIds"][0], &InputIds);
  paddle::experimental::Tensor SegmentIds;
  egr::EagerUtils::GetOutput(outs["SegmentIds"][0], &SegmentIds);


  return std::make_tuple(InputIds,SegmentIds);

}


paddle::experimental::Tensor c_reduce_max_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_reduce_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_reduce_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_reduce_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_reduce_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_reduce_max_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_reduce_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor c_identity_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_identity dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_identity";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_identity", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_identity");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_identity_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_identity", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("c_identity node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for c_identity "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<c_identityGradNodeCompat>(new c_identityGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("relu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: relu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("relu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "relu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return relu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("relu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("relu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for relu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<reluGradNodeCompat>(new reluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor relu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("relu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: relu";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("relu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("relu node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for relu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<reluGradNodeCompat>(new reluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor is_empty_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("is_empty dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: is_empty";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("is_empty", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "is_empty");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return is_empty_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("is_empty", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor reduce_all_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("reduce_all dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: reduce_all";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("reduce_all", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "reduce_all");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return reduce_all_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("reduce_all", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> edit_distance_dygraph_function(const paddle::experimental::Tensor& Hyps,const paddle::experimental::Tensor& Refs, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("edit_distance dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: edit_distance";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Hyps},{Refs} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("edit_distance", amp_tensors_vector);

    auto NEW_Hyps = egr::AmpAutoCast("Hyps", Hyps, amp_dst_dtype, "edit_distance");
    auto NEW_Refs = egr::AmpAutoCast("Refs", Refs, amp_dst_dtype, "edit_distance");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return edit_distance_dygraph_function( NEW_Hyps, NEW_Refs, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Hyps", egr::EagerUtils::TrySyncToVars(Hyps) },{ "Refs", egr::EagerUtils::TrySyncToVars(Refs) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "SequenceNum", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("edit_distance", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor SequenceNum;
  egr::EagerUtils::GetOutput(outs["SequenceNum"][0], &SequenceNum);
  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return std::make_tuple(SequenceNum,Out);

}


std::vector<paddle::experimental::Tensor> distributed_lookup_table_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const paddle::experimental::Tensor& W, size_t OutputsNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("distributed_lookup_table dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: distributed_lookup_table";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { Ids,{W} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("distributed_lookup_table", amp_tensors_vector);

    auto NEW_Ids = egr::AmpAutoCasts("Ids", Ids, amp_dst_dtype, "distributed_lookup_table");
    auto NEW_W = egr::AmpAutoCast("W", W, amp_dst_dtype, "distributed_lookup_table");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return distributed_lookup_table_dygraph_function( NEW_Ids, NEW_W, OutputsNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Ids", egr::EagerUtils::TrySyncToVars(Ids) },{ "W", egr::EagerUtils::TrySyncToVars(W) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Outputs", egr::EagerUtils::CreateVars(OutputsNum) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("distributed_lookup_table", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Outputs;
  egr::EagerUtils::GetOutputs(outs["Outputs"], &Outputs);


  return Outputs;

}


paddle::experimental::Tensor tril_indices_dygraph_function( const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("tril_indices dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: tril_indices";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return tril_indices_dygraph_function( attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("tril_indices", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor out;
  egr::EagerUtils::GetOutput(outs["out"][0], &out);


  return out;

}


paddle::experimental::Tensor bmm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("bmm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: bmm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("bmm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "bmm");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "bmm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return bmm_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bmm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("bmm node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for bmm "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<bmmGradNodeCompat>(new bmmGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> yolo_box_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ImgSize, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("yolo_box dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: yolo_box";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{ImgSize} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("yolo_box", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "yolo_box");
    auto NEW_ImgSize = egr::AmpAutoCast("ImgSize", ImgSize, amp_dst_dtype, "yolo_box");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return yolo_box_dygraph_function( NEW_X, NEW_ImgSize, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "ImgSize", egr::EagerUtils::TrySyncToVars(ImgSize) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Boxes", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Scores", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("yolo_box", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Boxes;
  egr::EagerUtils::GetOutput(outs["Boxes"][0], &Boxes);
  paddle::experimental::Tensor Scores;
  egr::EagerUtils::GetOutput(outs["Scores"][0], &Scores);


  return std::make_tuple(Boxes,Scores);

}


paddle::experimental::Tensor soft_relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("soft_relu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: soft_relu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("soft_relu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "soft_relu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return soft_relu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("soft_relu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("soft_relu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for soft_relu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<soft_reluGradNodeCompat>(new soft_reluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor soft_relu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("soft_relu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: soft_relu";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("soft_relu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("soft_relu node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for soft_relu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<soft_reluGradNodeCompat>(new soft_reluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> density_prior_box_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Image, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("density_prior_box dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: density_prior_box";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Image} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("density_prior_box", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "density_prior_box");
    auto NEW_Image = egr::AmpAutoCast("Image", Image, amp_dst_dtype, "density_prior_box");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return density_prior_box_dygraph_function( NEW_Input, NEW_Image, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Image", egr::EagerUtils::TrySyncToVars(Image) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Boxes", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Variances", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("density_prior_box", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Boxes;
  egr::EagerUtils::GetOutput(outs["Boxes"][0], &Boxes);
  paddle::experimental::Tensor Variances;
  egr::EagerUtils::GetOutput(outs["Variances"][0], &Variances);


  return std::make_tuple(Boxes,Variances);

}


paddle::experimental::Tensor swish_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("swish dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: swish";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("swish", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "swish");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return swish_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("swish", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("swish node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for swish "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<swishGradNodeCompat>(new swishGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor eye_dygraph_function( const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("eye dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: eye";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return eye_dygraph_function( attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("eye", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor cross_entropy_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cross_entropy dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cross_entropy";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Label} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cross_entropy", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cross_entropy");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "cross_entropy");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cross_entropy_dygraph_function( NEW_X, NEW_Label, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Label);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cross_entropy", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);

  {
    paddle::platform::RecordEvent node_creation_record_event("cross_entropy node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cross_entropy "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<cross_entropyGradNodeCompat>(new cross_entropyGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLabel(Label);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);

    }
  }

  return Y;

}


paddle::experimental::Tensor dpsgd_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, paddle::experimental::Tensor* ParamOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("dpsgd dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: dpsgd";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Param},{Grad},{LearningRate} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("dpsgd", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCast("Param", Param, amp_dst_dtype, "dpsgd");
    auto NEW_Grad = egr::AmpAutoCast("Grad", Grad, amp_dst_dtype, "dpsgd");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "dpsgd");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dpsgd_dygraph_function( NEW_Param, NEW_Grad, NEW_LearningRate, ParamOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "ParamOut", ins["Param"] } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dpsgd", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["ParamOut"][0], ParamOutVar);
  paddle::experimental::Tensor& ParamOut = *ParamOutVar;


  return ParamOut;

}


paddle::experimental::Tensor identity_loss_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("identity_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: identity_loss";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("identity_loss", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "identity_loss");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return identity_loss_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("identity_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("identity_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for identity_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<identity_lossGradNodeCompat>(new identity_lossGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor identity_loss__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("identity_loss dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: identity_loss";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("identity_loss", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("identity_loss node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for identity_loss "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<identity_lossGradNodeCompat>(new identity_lossGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor cholesky_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cholesky dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cholesky";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cholesky", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cholesky");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cholesky_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cholesky", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("cholesky node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cholesky "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<choleskyGradNodeCompat>(new choleskyGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor batch_fc_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("batch_fc dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: batch_fc";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{W},{Bias} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("batch_fc", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "batch_fc");
    auto NEW_W = egr::AmpAutoCast("W", W, amp_dst_dtype, "batch_fc");
    auto NEW_Bias = egr::AmpAutoCast("Bias", Bias, amp_dst_dtype, "batch_fc");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return batch_fc_dygraph_function( NEW_Input, NEW_W, NEW_Bias, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "W", egr::EagerUtils::TrySyncToVars(W) },{ "Bias", egr::EagerUtils::TrySyncToVars(Bias) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_W = egr::EagerUtils::nullable_autograd_meta(W);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_W, p_autograd_Bias);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("batch_fc", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("batch_fc node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for batch_fc "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<batch_fcGradNodeCompat>(new batch_fcGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperInput(Input);
      grad_node->SetTensorWrapperW(W);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(W, 1);
      grad_node->SetGradOutMeta(Bias, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor nearest_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("nearest_interp dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: nearest_interp";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };
    if(OutSize.initialized()) amp_tensors_vector.push_back({ OutSize });

    auto amp_dst_dtype = egr::GetAmpDestDtype("nearest_interp", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "nearest_interp");
    auto NEW_OutSize = ((OutSize.initialized()) ? egr::AmpAutoCast("OutSize", OutSize, amp_dst_dtype, "nearest_interp") : OutSize);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return nearest_interp_dygraph_function( NEW_X, NEW_OutSize, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };
  if(OutSize.initialized()) ins["OutSize"] = egr::EagerUtils::TrySyncToVars(OutSize);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_OutSize = egr::EagerUtils::nullable_autograd_meta(OutSize);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_OutSize);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nearest_interp", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("nearest_interp node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for nearest_interp "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<nearest_interpGradNodeCompat>(new nearest_interpGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOutSize(OutSize);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor gather_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Axis, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("gather dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: gather";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Index} };
    if(Axis.initialized()) amp_tensors_vector.push_back({ Axis });

    auto amp_dst_dtype = egr::GetAmpDestDtype("gather", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "gather");
    auto NEW_Index = egr::AmpAutoCast("Index", Index, amp_dst_dtype, "gather");
    auto NEW_Axis = ((Axis.initialized()) ? egr::AmpAutoCast("Axis", Axis, amp_dst_dtype, "gather") : Axis);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gather_dygraph_function( NEW_X, NEW_Index, NEW_Axis, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Index", egr::EagerUtils::TrySyncToVars(Index) } };
  if(Axis.initialized()) ins["Axis"] = egr::EagerUtils::TrySyncToVars(Axis);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Index = egr::EagerUtils::nullable_autograd_meta(Index);
  egr::AutogradMeta* p_autograd_Axis = egr::EagerUtils::nullable_autograd_meta(Axis);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Index, p_autograd_Axis);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gather", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("gather node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for gather "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<gatherGradNodeCompat>(new gatherGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperAxis(Axis);
      grad_node->SetTensorWrapperIndex(Index);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor trilinear_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("trilinear_interp_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: trilinear_interp_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("trilinear_interp_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "trilinear_interp_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return trilinear_interp_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("trilinear_interp_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("trilinear_interp_v2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for trilinear_interp_v2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<trilinear_interp_v2GradNodeCompat>(new trilinear_interp_v2GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor box_clip_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("box_clip dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: box_clip";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{ImInfo} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("box_clip", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "box_clip");
    auto NEW_ImInfo = egr::AmpAutoCast("ImInfo", ImInfo, amp_dst_dtype, "box_clip");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return box_clip_dygraph_function( NEW_Input, NEW_ImInfo, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "ImInfo", egr::EagerUtils::TrySyncToVars(ImInfo) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("box_clip", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);


  return Output;

}


paddle::experimental::Tensor c_allgather_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_allgather dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_allgather";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_allgather", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_allgather");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_allgather_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_allgather", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("c_allgather node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for c_allgather "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<c_allgatherGradNodeCompat>(new c_allgatherGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor isnan_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("isnan_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: isnan_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("isnan_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "isnan_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return isnan_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("isnan_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "lu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Pivots", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Infos", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Pivots;
  egr::EagerUtils::GetOutput(outs["Pivots"][0], &Pivots);
  paddle::experimental::Tensor Infos;
  egr::EagerUtils::GetOutput(outs["Infos"][0], &Infos);

  {
    paddle::platform::RecordEvent node_creation_record_event("lu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Pivots = egr::EagerUtils::autograd_meta(&Pivots);
    egr::AutogradMeta* p_autograd_Infos = egr::EagerUtils::autograd_meta(&Infos);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for lu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Pivots, p_autograd_Infos);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<luGradNodeCompat>(new luGradNodeCompat(3, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperPivots(Pivots);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Pivots, 1);
      egr::EagerUtils::SetHistory(p_autograd_Pivots, grad_node);
      grad_node->SetGradInMeta(Pivots, 1);
      egr::EagerUtils::CheckAndRetainGrad(Pivots);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Infos, 2);
      egr::EagerUtils::SetHistory(p_autograd_Infos, grad_node);
      grad_node->SetGradInMeta(Infos, 2);
      egr::EagerUtils::CheckAndRetainGrad(Infos);

    }
  }

  return std::make_tuple(Out,Pivots,Infos);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lu";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] },{ "Pivots", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Infos", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";
  paddle::experimental::Tensor Pivots;
  egr::EagerUtils::GetOutput(outs["Pivots"][0], &Pivots);
  paddle::experimental::Tensor Infos;
  egr::EagerUtils::GetOutput(outs["Infos"][0], &Infos);

  {
    paddle::platform::RecordEvent node_creation_record_event("lu node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    egr::AutogradMeta* p_autograd_Pivots = egr::EagerUtils::autograd_meta(&Pivots);
    egr::AutogradMeta* p_autograd_Infos = egr::EagerUtils::autograd_meta(&Infos);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for lu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X, p_autograd_Pivots, p_autograd_Infos);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<luGradNodeCompat>(new luGradNodeCompat(3, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);
      grad_node->SetTensorWrapperPivots(Pivots);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Pivots, 1);
      egr::EagerUtils::SetHistory(p_autograd_Pivots, grad_node);
      grad_node->SetGradInMeta(Pivots, 1);
      egr::EagerUtils::CheckAndRetainGrad(Pivots);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Infos, 2);
      egr::EagerUtils::SetHistory(p_autograd_Infos, grad_node);
      grad_node->SetGradInMeta(Infos, 2);
      egr::EagerUtils::CheckAndRetainGrad(Infos);

    }
  }

  return std::make_tuple(X,Pivots,Infos);

}


paddle::experimental::Tensor softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: softmax";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("softmax", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "softmax");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return softmax_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softmax", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("softmax node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for softmax "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<softmaxGradNodeCompat>(new softmaxGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor softmax__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("softmax dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: softmax";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softmax", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("softmax node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for softmax "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<softmaxGradNodeCompat>(new softmaxGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor conv2d_fusion_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("conv2d_fusion dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: conv2d_fusion";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("conv2d_fusion", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "conv2d_fusion");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "conv2d_fusion");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conv2d_fusion_dygraph_function( NEW_Input, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conv2d_fusion", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);


  return Output;

}


paddle::experimental::Tensor get_float_status_dygraph_function(const paddle::experimental::Tensor& FloatStatus, paddle::experimental::Tensor* FloatStatusOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("get_float_status dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: get_float_status";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {FloatStatus} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("get_float_status", amp_tensors_vector);

    auto NEW_FloatStatus = egr::AmpAutoCast("FloatStatus", FloatStatus, amp_dst_dtype, "get_float_status");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return get_float_status_dygraph_function( NEW_FloatStatus, FloatStatusOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "FloatStatus", egr::EagerUtils::TrySyncToVars(FloatStatus) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "FloatStatusOut", ins["FloatStatus"] } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("get_float_status", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["FloatStatusOut"][0], FloatStatusOutVar);
  paddle::experimental::Tensor& FloatStatusOut = *FloatStatusOutVar;


  return FloatStatusOut;

}


paddle::experimental::Tensor index_sample_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("index_sample dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: index_sample";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Index} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("index_sample", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "index_sample");
    auto NEW_Index = egr::AmpAutoCast("Index", Index, amp_dst_dtype, "index_sample");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return index_sample_dygraph_function( NEW_X, NEW_Index, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Index", egr::EagerUtils::TrySyncToVars(Index) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Index = egr::EagerUtils::nullable_autograd_meta(Index);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Index);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("index_sample", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("index_sample node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for index_sample "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<index_sampleGradNodeCompat>(new index_sampleGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIndex(Index);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor elementwise_min_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_min dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_min";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("elementwise_min", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "elementwise_min");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "elementwise_min");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elementwise_min_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_min", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_min node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_min "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_minGradNodeCompat>(new elementwise_minGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor logical_not_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("logical_not dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: logical_not";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("logical_not", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "logical_not");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logical_not_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("logical_not", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> collect_fpn_proposals_dygraph_function(const std::vector<paddle::experimental::Tensor>& MultiLevelRois,const std::vector<paddle::experimental::Tensor>& MultiLevelScores,const std::vector<paddle::experimental::Tensor>& MultiLevelRoIsNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("collect_fpn_proposals dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: collect_fpn_proposals";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { MultiLevelRois,MultiLevelScores };
    if(MultiLevelRoIsNum.size() > 0) amp_tensors_vector.push_back(MultiLevelRoIsNum);

    auto amp_dst_dtype = egr::GetAmpDestDtype("collect_fpn_proposals", amp_tensors_vector);

    auto NEW_MultiLevelRois = egr::AmpAutoCasts("MultiLevelRois", MultiLevelRois, amp_dst_dtype, "collect_fpn_proposals");
    auto NEW_MultiLevelScores = egr::AmpAutoCasts("MultiLevelScores", MultiLevelScores, amp_dst_dtype, "collect_fpn_proposals");
    auto NEW_MultiLevelRoIsNum = ((MultiLevelRoIsNum.size() > 0) ? egr::AmpAutoCasts("MultiLevelRoIsNum", MultiLevelRoIsNum, amp_dst_dtype, "collect_fpn_proposals") : MultiLevelRoIsNum);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return collect_fpn_proposals_dygraph_function( NEW_MultiLevelRois, NEW_MultiLevelScores, NEW_MultiLevelRoIsNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "MultiLevelRois", egr::EagerUtils::TrySyncToVars(MultiLevelRois) },{ "MultiLevelScores", egr::EagerUtils::TrySyncToVars(MultiLevelScores) } };
  if(MultiLevelRoIsNum.size() > 0) ins["MultiLevelRoIsNum"] = egr::EagerUtils::TrySyncToVars(MultiLevelRoIsNum);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "FpnRois", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "RoisNum", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("collect_fpn_proposals", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor FpnRois;
  egr::EagerUtils::GetOutput(outs["FpnRois"][0], &FpnRois);
  paddle::experimental::Tensor RoisNum;
  egr::EagerUtils::GetOutput(outs["RoisNum"][0], &RoisNum);


  return std::make_tuple(FpnRois,RoisNum);

}


paddle::experimental::Tensor erfinv_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("erfinv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: erfinv";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("erfinv", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "erfinv");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return erfinv_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("erfinv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("erfinv node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for erfinv "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<erfinvGradNodeCompat>(new erfinvGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor erfinv__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("erfinv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: erfinv";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("erfinv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("erfinv node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for erfinv "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<erfinvGradNodeCompat>(new erfinvGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor pixel_shuffle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("pixel_shuffle dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: pixel_shuffle";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("pixel_shuffle", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "pixel_shuffle");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pixel_shuffle_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pixel_shuffle", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("pixel_shuffle node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for pixel_shuffle "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<pixel_shuffleGradNodeCompat>(new pixel_shuffleGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor thresholded_relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("thresholded_relu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: thresholded_relu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("thresholded_relu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "thresholded_relu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return thresholded_relu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("thresholded_relu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("thresholded_relu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for thresholded_relu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<thresholded_reluGradNodeCompat>(new thresholded_reluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor polygon_box_transform_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("polygon_box_transform dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: polygon_box_transform";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("polygon_box_transform", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "polygon_box_transform");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return polygon_box_transform_dygraph_function( NEW_Input, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("polygon_box_transform", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);


  return Output;

}


paddle::experimental::Tensor lookup_table_dequant_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lookup_table_dequant dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lookup_table_dequant";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {W},{Ids} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lookup_table_dequant", amp_tensors_vector);

    auto NEW_W = egr::AmpAutoCast("W", W, amp_dst_dtype, "lookup_table_dequant");
    auto NEW_Ids = egr::AmpAutoCast("Ids", Ids, amp_dst_dtype, "lookup_table_dequant");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lookup_table_dequant_dygraph_function( NEW_W, NEW_Ids, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "W", egr::EagerUtils::TrySyncToVars(W) },{ "Ids", egr::EagerUtils::TrySyncToVars(Ids) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lookup_table_dequant", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> warpctc_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& LogitsLength,const paddle::experimental::Tensor& LabelLength, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("warpctc dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: warpctc";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Logits},{Label} };
    if(LogitsLength.initialized()) amp_tensors_vector.push_back({ LogitsLength });
    if(LabelLength.initialized()) amp_tensors_vector.push_back({ LabelLength });

    auto amp_dst_dtype = egr::GetAmpDestDtype("warpctc", amp_tensors_vector);

    auto NEW_Logits = egr::AmpAutoCast("Logits", Logits, amp_dst_dtype, "warpctc");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "warpctc");
    auto NEW_LogitsLength = ((LogitsLength.initialized()) ? egr::AmpAutoCast("LogitsLength", LogitsLength, amp_dst_dtype, "warpctc") : LogitsLength);
    auto NEW_LabelLength = ((LabelLength.initialized()) ? egr::AmpAutoCast("LabelLength", LabelLength, amp_dst_dtype, "warpctc") : LabelLength);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return warpctc_dygraph_function( NEW_Logits, NEW_Label, NEW_LogitsLength, NEW_LabelLength, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Logits", egr::EagerUtils::TrySyncToVars(Logits) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) } };
  if(LogitsLength.initialized()) ins["LogitsLength"] = egr::EagerUtils::TrySyncToVars(LogitsLength);
  if(LabelLength.initialized()) ins["LabelLength"] = egr::EagerUtils::TrySyncToVars(LabelLength);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "WarpCTCGrad", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Loss", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Logits = egr::EagerUtils::nullable_autograd_meta(Logits);
  egr::AutogradMeta* p_autograd_Label = egr::EagerUtils::nullable_autograd_meta(Label);
  egr::AutogradMeta* p_autograd_LogitsLength = egr::EagerUtils::nullable_autograd_meta(LogitsLength);
  egr::AutogradMeta* p_autograd_LabelLength = egr::EagerUtils::nullable_autograd_meta(LabelLength);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Logits, p_autograd_Label, p_autograd_LogitsLength, p_autograd_LabelLength);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("warpctc", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor WarpCTCGrad;
  egr::EagerUtils::GetOutput(outs["WarpCTCGrad"][0], &WarpCTCGrad);
  paddle::experimental::Tensor Loss;
  egr::EagerUtils::GetOutput(outs["Loss"][0], &Loss);

  {
    paddle::platform::RecordEvent node_creation_record_event("warpctc node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_WarpCTCGrad = egr::EagerUtils::autograd_meta(&WarpCTCGrad);
    egr::AutogradMeta* p_autograd_Loss = egr::EagerUtils::autograd_meta(&Loss);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for warpctc "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_WarpCTCGrad, p_autograd_Loss);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<warpctcGradNodeCompat>(new warpctcGradNodeCompat(2, 4));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLogits(Logits);
      grad_node->SetTensorWrapperLogitsLength(LogitsLength);
      grad_node->SetTensorWrapperWarpCTCGrad(WarpCTCGrad);

      grad_node->SetGradOutMeta(Logits, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_WarpCTCGrad, 0);
      grad_node->SetGradInMeta(WarpCTCGrad, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Loss, 1);
      egr::EagerUtils::SetHistory(p_autograd_Loss, grad_node);
      grad_node->SetGradInMeta(Loss, 1);
      egr::EagerUtils::CheckAndRetainGrad(Loss);

    }
  }

  return std::make_tuple(WarpCTCGrad,Loss);

}


paddle::experimental::Tensor elementwise_heaviside_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_heaviside dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_heaviside";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("elementwise_heaviside", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "elementwise_heaviside");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "elementwise_heaviside");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elementwise_heaviside_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_heaviside", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_heaviside node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_heaviside "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_heavisideGradNodeCompat>(new elementwise_heavisideGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_channel_wise_quantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fake_channel_wise_quantize_abs_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fake_channel_wise_quantize_abs_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fake_channel_wise_quantize_abs_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fake_channel_wise_quantize_abs_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fake_channel_wise_quantize_abs_max_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "OutScale", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fake_channel_wise_quantize_abs_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor OutScale;
  egr::EagerUtils::GetOutput(outs["OutScale"][0], &OutScale);


  return std::make_tuple(Out,OutScale);

}


paddle::experimental::Tensor dequantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("dequantize_abs_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: dequantize_abs_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Scale} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("dequantize_abs_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "dequantize_abs_max");
    auto NEW_Scale = egr::AmpAutoCast("Scale", Scale, amp_dst_dtype, "dequantize_abs_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dequantize_abs_max_dygraph_function( NEW_X, NEW_Scale, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Scale", egr::EagerUtils::TrySyncToVars(Scale) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dequantize_abs_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> svd_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("svd dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: svd";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("svd", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "svd");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return svd_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "U", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "S", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "VH", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("svd", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor U;
  egr::EagerUtils::GetOutput(outs["U"][0], &U);
  paddle::experimental::Tensor S;
  egr::EagerUtils::GetOutput(outs["S"][0], &S);
  paddle::experimental::Tensor VH;
  egr::EagerUtils::GetOutput(outs["VH"][0], &VH);

  {
    paddle::platform::RecordEvent node_creation_record_event("svd node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_U = egr::EagerUtils::autograd_meta(&U);
    egr::AutogradMeta* p_autograd_S = egr::EagerUtils::autograd_meta(&S);
    egr::AutogradMeta* p_autograd_VH = egr::EagerUtils::autograd_meta(&VH);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for svd "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_U, p_autograd_S, p_autograd_VH);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<svdGradNodeCompat>(new svdGradNodeCompat(3, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperS(S);
      grad_node->SetTensorWrapperU(U);
      grad_node->SetTensorWrapperVH(VH);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_U, 0);
      egr::EagerUtils::SetHistory(p_autograd_U, grad_node);
      grad_node->SetGradInMeta(U, 0);
      egr::EagerUtils::CheckAndRetainGrad(U);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_S, 1);
      egr::EagerUtils::SetHistory(p_autograd_S, grad_node);
      grad_node->SetGradInMeta(S, 1);
      egr::EagerUtils::CheckAndRetainGrad(S);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_VH, 2);
      egr::EagerUtils::SetHistory(p_autograd_VH, grad_node);
      grad_node->SetGradInMeta(VH, 2);
      egr::EagerUtils::CheckAndRetainGrad(VH);

    }
  }

  return std::make_tuple(U,S,VH);

}


paddle::experimental::Tensor flip_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("flip dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: flip";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("flip", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "flip");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return flip_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("flip", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("flip node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for flip "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<flipGradNodeCompat>(new flipGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


