#include "paddle/fluid/eager/api/generated/fluid_generated/dygraph_forward_api.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/amp_utils.h"
#include "paddle/fluid/eager/amp_auto_cast.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"
#pragma GCC diagnostic ignored "-Wunused-variable"

paddle::experimental::Tensor uniform_random_inplace_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("uniform_random_inplace dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: uniform_random_inplace";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("uniform_random_inplace", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "uniform_random_inplace");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return uniform_random_inplace_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("uniform_random_inplace", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("uniform_random_inplace node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for uniform_random_inplace "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<uniform_random_inplaceGradNodeCompat>(new uniform_random_inplaceGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor uniform_random_inplace__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("uniform_random_inplace dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: uniform_random_inplace";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("uniform_random_inplace", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("uniform_random_inplace node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for uniform_random_inplace "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<uniform_random_inplaceGradNodeCompat>(new uniform_random_inplaceGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor maxout_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("maxout dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: maxout";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("maxout", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "maxout");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return maxout_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("maxout", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("maxout node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for maxout "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<maxoutGradNodeCompat>(new maxoutGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lstsq_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("lstsq dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: lstsq";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("lstsq", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "lstsq");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "lstsq");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return lstsq_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Solution", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Rank", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SingularValues", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("lstsq", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Solution;
  egr::EagerUtils::GetOutput(outs["Solution"][0], &Solution);
  paddle::experimental::Tensor Rank;
  egr::EagerUtils::GetOutput(outs["Rank"][0], &Rank);
  paddle::experimental::Tensor SingularValues;
  egr::EagerUtils::GetOutput(outs["SingularValues"][0], &SingularValues);


  return std::make_tuple(Solution,Rank,SingularValues);

}


paddle::experimental::Tensor linear_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("linear_interp dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: linear_interp";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };
    if(OutSize.initialized()) amp_tensors_vector.push_back({ OutSize });

    auto amp_dst_dtype = egr::GetAmpDestDtype("linear_interp", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "linear_interp");
    auto NEW_OutSize = ((OutSize.initialized()) ? egr::AmpAutoCast("OutSize", OutSize, amp_dst_dtype, "linear_interp") : OutSize);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return linear_interp_dygraph_function( NEW_X, NEW_OutSize, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };
  if(OutSize.initialized()) ins["OutSize"] = egr::EagerUtils::TrySyncToVars(OutSize);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_OutSize = egr::EagerUtils::nullable_autograd_meta(OutSize);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_OutSize);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("linear_interp", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("linear_interp node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for linear_interp "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<linear_interpGradNodeCompat>(new linear_interpGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOutSize(OutSize);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> graph_khop_sampler_dygraph_function(const paddle::experimental::Tensor& Row,const paddle::experimental::Tensor& Eids,const paddle::experimental::Tensor& Col_Ptr,const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("graph_khop_sampler dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: graph_khop_sampler";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Row},{Col_Ptr},{X} };
    if(Eids.initialized()) amp_tensors_vector.push_back({ Eids });

    auto amp_dst_dtype = egr::GetAmpDestDtype("graph_khop_sampler", amp_tensors_vector);

    auto NEW_Row = egr::AmpAutoCast("Row", Row, amp_dst_dtype, "graph_khop_sampler");
    auto NEW_Col_Ptr = egr::AmpAutoCast("Col_Ptr", Col_Ptr, amp_dst_dtype, "graph_khop_sampler");
    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "graph_khop_sampler");
    auto NEW_Eids = ((Eids.initialized()) ? egr::AmpAutoCast("Eids", Eids, amp_dst_dtype, "graph_khop_sampler") : Eids);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return graph_khop_sampler_dygraph_function( NEW_Row, NEW_Eids, NEW_Col_Ptr, NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Row", egr::EagerUtils::TrySyncToVars(Row) },{ "Col_Ptr", egr::EagerUtils::TrySyncToVars(Col_Ptr) },{ "X", egr::EagerUtils::TrySyncToVars(X) } };
  if(Eids.initialized()) ins["Eids"] = egr::EagerUtils::TrySyncToVars(Eids);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out_Src", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out_Dst", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Sample_Index", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Reindex_X", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Out_Eids", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("graph_khop_sampler", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out_Src;
  egr::EagerUtils::GetOutput(outs["Out_Src"][0], &Out_Src);
  paddle::experimental::Tensor Out_Dst;
  egr::EagerUtils::GetOutput(outs["Out_Dst"][0], &Out_Dst);
  paddle::experimental::Tensor Sample_Index;
  egr::EagerUtils::GetOutput(outs["Sample_Index"][0], &Sample_Index);
  paddle::experimental::Tensor Reindex_X;
  egr::EagerUtils::GetOutput(outs["Reindex_X"][0], &Reindex_X);
  paddle::experimental::Tensor Out_Eids;
  egr::EagerUtils::GetOutput(outs["Out_Eids"][0], &Out_Eids);


  return std::make_tuple(Out_Src,Out_Dst,Sample_Index,Reindex_X,Out_Eids);

}


paddle::experimental::Tensor put_along_axis_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Value, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("put_along_axis dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: put_along_axis";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Index},{Value} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("put_along_axis", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "put_along_axis");
    auto NEW_Index = egr::AmpAutoCast("Index", Index, amp_dst_dtype, "put_along_axis");
    auto NEW_Value = egr::AmpAutoCast("Value", Value, amp_dst_dtype, "put_along_axis");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return put_along_axis_dygraph_function( NEW_Input, NEW_Index, NEW_Value, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Index", egr::EagerUtils::TrySyncToVars(Index) },{ "Value", egr::EagerUtils::TrySyncToVars(Value) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Result", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Index = egr::EagerUtils::nullable_autograd_meta(Index);
  egr::AutogradMeta* p_autograd_Value = egr::EagerUtils::nullable_autograd_meta(Value);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Index, p_autograd_Value);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("put_along_axis", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Result;
  egr::EagerUtils::GetOutput(outs["Result"][0], &Result);

  {
    paddle::platform::RecordEvent node_creation_record_event("put_along_axis node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Result = egr::EagerUtils::autograd_meta(&Result);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for put_along_axis "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Result);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<put_along_axisGradNodeCompat>(new put_along_axisGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIndex(Index);
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Value, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Result, 0);
      egr::EagerUtils::SetHistory(p_autograd_Result, grad_node);
      grad_node->SetGradInMeta(Result, 0);
      egr::EagerUtils::CheckAndRetainGrad(Result);

    }
  }

  return Result;

}


paddle::experimental::Tensor put_along_axis__dygraph_function(paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Value, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("put_along_axis dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: put_along_axis";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Index", egr::EagerUtils::TrySyncToVars(Index) },{ "Value", egr::EagerUtils::TrySyncToVars(Value) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Result", ins["Input"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Index = egr::EagerUtils::nullable_autograd_meta(Index);
  egr::AutogradMeta* p_autograd_Value = egr::EagerUtils::nullable_autograd_meta(Value);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Index, p_autograd_Value);
  // Check Inplace
  egr::EagerUtils::CheckInplace(Input, p_autograd_Input, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("put_along_axis", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"Input", "Result"}});

  egr::EagerUtils::GetOutput(outs["Result"][0], &Input);
  Input.bump_inplace_version();
  VLOG(3) << "Tensor(" << Input.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("put_along_axis node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_Input = egr::EagerUtils::autograd_meta(&Input);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for put_along_axis "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Input);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<put_along_axisGradNodeCompat>(new put_along_axisGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIndex(Index);
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Value, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Input, 0);
      egr::EagerUtils::SetHistory(p_autograd_Input, grad_node);
      grad_node->SetGradInMeta(Input, 0);
      egr::EagerUtils::CheckAndRetainGrad(Input);

    }
  }

  return Input;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> auc_dygraph_function(const paddle::experimental::Tensor& Predict,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& StatPos,const paddle::experimental::Tensor& StatNeg, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("auc dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: auc";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Predict},{Label},{StatPos},{StatNeg} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("auc", amp_tensors_vector);

    auto NEW_Predict = egr::AmpAutoCast("Predict", Predict, amp_dst_dtype, "auc");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "auc");
    auto NEW_StatPos = egr::AmpAutoCast("StatPos", StatPos, amp_dst_dtype, "auc");
    auto NEW_StatNeg = egr::AmpAutoCast("StatNeg", StatNeg, amp_dst_dtype, "auc");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return auc_dygraph_function( NEW_Predict, NEW_Label, NEW_StatPos, NEW_StatNeg, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Predict", egr::EagerUtils::TrySyncToVars(Predict) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) },{ "StatPos", egr::EagerUtils::TrySyncToVars(StatPos) },{ "StatNeg", egr::EagerUtils::TrySyncToVars(StatNeg) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "AUC", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "StatPosOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "StatNegOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("auc", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor AUC;
  egr::EagerUtils::GetOutput(outs["AUC"][0], &AUC);
  paddle::experimental::Tensor StatPosOut;
  egr::EagerUtils::GetOutput(outs["StatPosOut"][0], &StatPosOut);
  paddle::experimental::Tensor StatNegOut;
  egr::EagerUtils::GetOutput(outs["StatNegOut"][0], &StatNegOut);


  return std::make_tuple(AUC,StatPosOut,StatNegOut);

}


paddle::experimental::Tensor logical_or_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("logical_or dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: logical_or";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("logical_or", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "logical_or");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "logical_or");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return logical_or_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("logical_or", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> batch_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("batch_norm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: batch_norm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Scale},{Bias},{Mean},{Variance} };
    if(MomentumTensor.initialized()) amp_tensors_vector.push_back({ MomentumTensor });

    auto amp_dst_dtype = egr::GetAmpDestDtype("batch_norm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "batch_norm");
    auto NEW_Scale = egr::AmpAutoCast("Scale", Scale, amp_dst_dtype, "batch_norm");
    auto NEW_Bias = egr::AmpAutoCast("Bias", Bias, amp_dst_dtype, "batch_norm");
    auto NEW_Mean = egr::AmpAutoCast("Mean", Mean, amp_dst_dtype, "batch_norm");
    auto NEW_Variance = egr::AmpAutoCast("Variance", Variance, amp_dst_dtype, "batch_norm");
    auto NEW_MomentumTensor = ((MomentumTensor.initialized()) ? egr::AmpAutoCast("MomentumTensor", MomentumTensor, amp_dst_dtype, "batch_norm") : MomentumTensor);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return batch_norm_dygraph_function( NEW_X, NEW_Scale, NEW_Bias, NEW_Mean, NEW_Variance, NEW_MomentumTensor, MeanOutVar, VarianceOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Scale", egr::EagerUtils::TrySyncToVars(Scale) },{ "Bias", egr::EagerUtils::TrySyncToVars(Bias) },{ "Mean", egr::EagerUtils::TrySyncToVars(Mean) },{ "Variance", egr::EagerUtils::TrySyncToVars(Variance) } };
  if(MomentumTensor.initialized()) ins["MomentumTensor"] = egr::EagerUtils::TrySyncToVars(MomentumTensor);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "MeanOut", ins["Mean"] },{ "VarianceOut", ins["Variance"] },{ "SavedMean", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SavedVariance", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "ReserveSpace", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Scale = egr::EagerUtils::nullable_autograd_meta(Scale);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);
  egr::AutogradMeta* p_autograd_Mean = egr::EagerUtils::nullable_autograd_meta(Mean);
  egr::AutogradMeta* p_autograd_Variance = egr::EagerUtils::nullable_autograd_meta(Variance);
  egr::AutogradMeta* p_autograd_MomentumTensor = egr::EagerUtils::nullable_autograd_meta(MomentumTensor);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Scale, p_autograd_Bias, p_autograd_Mean, p_autograd_Variance, p_autograd_MomentumTensor);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("batch_norm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);
  egr::EagerUtils::GetOutput(outs["MeanOut"][0], MeanOutVar);
  paddle::experimental::Tensor& MeanOut = *MeanOutVar;
  egr::EagerUtils::GetOutput(outs["VarianceOut"][0], VarianceOutVar);
  paddle::experimental::Tensor& VarianceOut = *VarianceOutVar;
  paddle::experimental::Tensor SavedMean;
  egr::EagerUtils::GetOutput(outs["SavedMean"][0], &SavedMean);
  paddle::experimental::Tensor SavedVariance;
  egr::EagerUtils::GetOutput(outs["SavedVariance"][0], &SavedVariance);
  paddle::experimental::Tensor ReserveSpace;
  egr::EagerUtils::GetOutput(outs["ReserveSpace"][0], &ReserveSpace);

  {
    paddle::platform::RecordEvent node_creation_record_event("batch_norm node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    egr::AutogradMeta* p_autograd_MeanOut = egr::EagerUtils::autograd_meta(&MeanOut);
    egr::AutogradMeta* p_autograd_VarianceOut = egr::EagerUtils::autograd_meta(&VarianceOut);
    egr::AutogradMeta* p_autograd_SavedMean = egr::EagerUtils::autograd_meta(&SavedMean);
    egr::AutogradMeta* p_autograd_SavedVariance = egr::EagerUtils::autograd_meta(&SavedVariance);
    egr::AutogradMeta* p_autograd_ReserveSpace = egr::EagerUtils::autograd_meta(&ReserveSpace);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for batch_norm "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y, p_autograd_MeanOut, p_autograd_VarianceOut, p_autograd_SavedMean, p_autograd_SavedVariance, p_autograd_ReserveSpace);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<batch_normGradNodeCompat>(new batch_normGradNodeCompat(6, 6));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperReserveSpace(ReserveSpace);
      grad_node->SetTensorWrapperSavedMean(SavedMean);
      grad_node->SetTensorWrapperSavedVariance(SavedVariance);
      grad_node->SetTensorWrapperScale(Scale);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Scale, 1);
      grad_node->SetGradOutMeta(Bias, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_MeanOut, 1);
      egr::EagerUtils::SetHistory(p_autograd_MeanOut, grad_node);
      grad_node->SetGradInMeta(MeanOut, 1);
      egr::EagerUtils::CheckAndRetainGrad(MeanOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_VarianceOut, 2);
      egr::EagerUtils::SetHistory(p_autograd_VarianceOut, grad_node);
      grad_node->SetGradInMeta(VarianceOut, 2);
      egr::EagerUtils::CheckAndRetainGrad(VarianceOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedMean, 3);
      grad_node->SetGradInMeta(SavedMean, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedVariance, 4);
      grad_node->SetGradInMeta(SavedVariance, 4);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_ReserveSpace, 5);
      egr::EagerUtils::SetHistory(p_autograd_ReserveSpace, grad_node);
      grad_node->SetGradInMeta(ReserveSpace, 5);
      egr::EagerUtils::CheckAndRetainGrad(ReserveSpace);

    }
  }

  return std::make_tuple(Y,MeanOut,VarianceOut,SavedMean,SavedVariance,ReserveSpace);

}


paddle::experimental::Tensor c_reduce_sum_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_reduce_sum dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_reduce_sum";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_reduce_sum", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_reduce_sum");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_reduce_sum_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_reduce_sum", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor elementwise_add_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_add dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_add";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("elementwise_add", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "elementwise_add");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "elementwise_add");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return elementwise_add_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_add", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_add node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_add "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_addGradNodeCompat>(new elementwise_addGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor elementwise_add__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("elementwise_add dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: elementwise_add";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_add", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("elementwise_add node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for elementwise_add "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<elementwise_addGradNodeCompat>(new elementwise_addGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor acos_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("acos dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: acos";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("acos", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "acos");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return acos_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("acos", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("acos node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for acos "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<acosGradNodeCompat>(new acosGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::vector<paddle::experimental::Tensor> send_and_recv_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("send_and_recv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: send_and_recv";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X };

    auto amp_dst_dtype = egr::GetAmpDestDtype("send_and_recv", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "send_and_recv");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return send_and_recv_dygraph_function( NEW_X, OutNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::CreateVars(OutNum) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("send_and_recv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], &Out);


  return Out;

}


paddle::experimental::Tensor unpool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Indices, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("unpool dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: unpool";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Indices} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("unpool", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "unpool");
    auto NEW_Indices = egr::AmpAutoCast("Indices", Indices, amp_dst_dtype, "unpool");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return unpool_dygraph_function( NEW_X, NEW_Indices, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Indices", egr::EagerUtils::TrySyncToVars(Indices) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Indices = egr::EagerUtils::nullable_autograd_meta(Indices);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Indices);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("unpool", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("unpool node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for unpool "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<unpoolGradNodeCompat>(new unpoolGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIndices(Indices);
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor cumprod_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("cumprod dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: cumprod";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("cumprod", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "cumprod");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return cumprod_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cumprod", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("cumprod node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for cumprod "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<cumprodGradNodeCompat>(new cumprodGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> sample_logits_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sample_logits dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sample_logits";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Logits},{Labels} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sample_logits", amp_tensors_vector);

    auto NEW_Logits = egr::AmpAutoCast("Logits", Logits, amp_dst_dtype, "sample_logits");
    auto NEW_Labels = egr::AmpAutoCast("Labels", Labels, amp_dst_dtype, "sample_logits");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sample_logits_dygraph_function( NEW_Logits, NEW_Labels, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Logits", egr::EagerUtils::TrySyncToVars(Logits) },{ "Labels", egr::EagerUtils::TrySyncToVars(Labels) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Samples", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Probabilities", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "LogitsDim", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "LabelsDim", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SampledLogits", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SampledLabels", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Logits = egr::EagerUtils::nullable_autograd_meta(Logits);
  egr::AutogradMeta* p_autograd_Labels = egr::EagerUtils::nullable_autograd_meta(Labels);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Logits, p_autograd_Labels);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sample_logits", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Samples;
  egr::EagerUtils::GetOutput(outs["Samples"][0], &Samples);
  paddle::experimental::Tensor Probabilities;
  egr::EagerUtils::GetOutput(outs["Probabilities"][0], &Probabilities);
  paddle::experimental::Tensor LogitsDim;
  egr::EagerUtils::GetOutput(outs["LogitsDim"][0], &LogitsDim);
  paddle::experimental::Tensor LabelsDim;
  egr::EagerUtils::GetOutput(outs["LabelsDim"][0], &LabelsDim);
  paddle::experimental::Tensor SampledLogits;
  egr::EagerUtils::GetOutput(outs["SampledLogits"][0], &SampledLogits);
  paddle::experimental::Tensor SampledLabels;
  egr::EagerUtils::GetOutput(outs["SampledLabels"][0], &SampledLabels);

  {
    paddle::platform::RecordEvent node_creation_record_event("sample_logits node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Samples = egr::EagerUtils::autograd_meta(&Samples);
    egr::AutogradMeta* p_autograd_Probabilities = egr::EagerUtils::autograd_meta(&Probabilities);
    egr::AutogradMeta* p_autograd_LogitsDim = egr::EagerUtils::autograd_meta(&LogitsDim);
    egr::AutogradMeta* p_autograd_LabelsDim = egr::EagerUtils::autograd_meta(&LabelsDim);
    egr::AutogradMeta* p_autograd_SampledLogits = egr::EagerUtils::autograd_meta(&SampledLogits);
    egr::AutogradMeta* p_autograd_SampledLabels = egr::EagerUtils::autograd_meta(&SampledLabels);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sample_logits "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Samples, p_autograd_Probabilities, p_autograd_LogitsDim, p_autograd_LabelsDim, p_autograd_SampledLogits, p_autograd_SampledLabels);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sample_logitsGradNodeCompat>(new sample_logitsGradNodeCompat(6, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperLabelsDim(LabelsDim);
      grad_node->SetTensorWrapperLogitsDim(LogitsDim);
      grad_node->SetTensorWrapperSamples(Samples);

      grad_node->SetGradOutMeta(Logits, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Samples, 0);
      grad_node->SetGradInMeta(Samples, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Probabilities, 1);
      grad_node->SetGradInMeta(Probabilities, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_LogitsDim, 2);
      grad_node->SetGradInMeta(LogitsDim, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_LabelsDim, 3);
      grad_node->SetGradInMeta(LabelsDim, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SampledLogits, 4);
      grad_node->SetGradInMeta(SampledLogits, 4);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SampledLabels, 5);
      egr::EagerUtils::SetHistory(p_autograd_SampledLabels, grad_node);
      grad_node->SetGradInMeta(SampledLabels, 5);
      egr::EagerUtils::CheckAndRetainGrad(SampledLabels);

    }
  }

  return std::make_tuple(Samples,Probabilities,LogitsDim,LabelsDim,SampledLogits,SampledLabels);

}


std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> pull_box_extended_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, size_t OutNum, size_t OutExtendNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("pull_box_extended_sparse dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: pull_box_extended_sparse";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { Ids };

    auto amp_dst_dtype = egr::GetAmpDestDtype("pull_box_extended_sparse", amp_tensors_vector);

    auto NEW_Ids = egr::AmpAutoCasts("Ids", Ids, amp_dst_dtype, "pull_box_extended_sparse");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return pull_box_extended_sparse_dygraph_function( NEW_Ids, OutNum, OutExtendNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Ids", egr::EagerUtils::TrySyncToVars(Ids) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::CreateVars(OutNum) },{ "OutExtend", egr::EagerUtils::CreateVars(OutExtendNum) } };


  // Prepare Autograd Meta 
  std::vector<egr::AutogradMeta*> p_autograd_Ids = egr::EagerUtils::nullable_autograd_meta(Ids);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, &p_autograd_Ids);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("pull_box_extended_sparse", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  std::vector<paddle::experimental::Tensor> Out;
  egr::EagerUtils::GetOutputs(outs["Out"], &Out);
  std::vector<paddle::experimental::Tensor> OutExtend;
  egr::EagerUtils::GetOutputs(outs["OutExtend"], &OutExtend);

  {
    paddle::platform::RecordEvent node_creation_record_event("pull_box_extended_sparse node_creation", paddle::platform::TracerEventType::Operator, 1);
    std::vector<egr::AutogradMeta*> p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    std::vector<egr::AutogradMeta*> p_autograd_OutExtend = egr::EagerUtils::autograd_meta(&OutExtend);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for pull_box_extended_sparse "; 
      egr::EagerUtils::PassStopGradient(false, &p_autograd_Out, &p_autograd_OutExtend);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<pull_box_extended_sparseGradNodeCompat>(new pull_box_extended_sparseGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperIds(Ids);

      egr::EagerUtils::SetOutRankWithSlot(&p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(&p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(&p_autograd_OutExtend, 1);
      egr::EagerUtils::SetHistory(&p_autograd_OutExtend, grad_node);
      grad_node->SetGradInMeta(OutExtend, 1);
      egr::EagerUtils::CheckAndRetainGrad(OutExtend);

    }
  }

  return std::make_tuple(Out,OutExtend);

}


paddle::experimental::Tensor crop_tensor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Shape,const paddle::experimental::Tensor& Offsets, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("crop_tensor dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: crop_tensor";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };
    if(Shape.initialized()) amp_tensors_vector.push_back({ Shape });
    if(Offsets.initialized()) amp_tensors_vector.push_back({ Offsets });

    auto amp_dst_dtype = egr::GetAmpDestDtype("crop_tensor", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "crop_tensor");
    auto NEW_Shape = ((Shape.initialized()) ? egr::AmpAutoCast("Shape", Shape, amp_dst_dtype, "crop_tensor") : Shape);
    auto NEW_Offsets = ((Offsets.initialized()) ? egr::AmpAutoCast("Offsets", Offsets, amp_dst_dtype, "crop_tensor") : Offsets);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return crop_tensor_dygraph_function( NEW_X, NEW_Shape, NEW_Offsets, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };
  if(Shape.initialized()) ins["Shape"] = egr::EagerUtils::TrySyncToVars(Shape);
  if(Offsets.initialized()) ins["Offsets"] = egr::EagerUtils::TrySyncToVars(Offsets);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Shape = egr::EagerUtils::nullable_autograd_meta(Shape);
  egr::AutogradMeta* p_autograd_Offsets = egr::EagerUtils::nullable_autograd_meta(Offsets);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Shape, p_autograd_Offsets);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("crop_tensor", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("crop_tensor node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for crop_tensor "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<crop_tensorGradNodeCompat>(new crop_tensorGradNodeCompat(1, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOffsets(Offsets);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fill_constant_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_constant dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_constant";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_constant_dygraph_function( OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = {  };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_constant", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


paddle::experimental::Tensor deformable_conv_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Offset,const paddle::experimental::Tensor& Mask,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("deformable_conv dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: deformable_conv";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Offset},{Mask},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("deformable_conv", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "deformable_conv");
    auto NEW_Offset = egr::AmpAutoCast("Offset", Offset, amp_dst_dtype, "deformable_conv");
    auto NEW_Mask = egr::AmpAutoCast("Mask", Mask, amp_dst_dtype, "deformable_conv");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "deformable_conv");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return deformable_conv_dygraph_function( NEW_Input, NEW_Offset, NEW_Mask, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Offset", egr::EagerUtils::TrySyncToVars(Offset) },{ "Mask", egr::EagerUtils::TrySyncToVars(Mask) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Offset = egr::EagerUtils::nullable_autograd_meta(Offset);
  egr::AutogradMeta* p_autograd_Mask = egr::EagerUtils::nullable_autograd_meta(Mask);
  egr::AutogradMeta* p_autograd_Filter = egr::EagerUtils::nullable_autograd_meta(Filter);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Offset, p_autograd_Mask, p_autograd_Filter);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("deformable_conv", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);

  {
    paddle::platform::RecordEvent node_creation_record_event("deformable_conv node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Output = egr::EagerUtils::autograd_meta(&Output);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for deformable_conv "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Output);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<deformable_convGradNodeCompat>(new deformable_convGradNodeCompat(1, 4));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperFilter(Filter);
      grad_node->SetTensorWrapperInput(Input);
      grad_node->SetTensorWrapperMask(Mask);
      grad_node->SetTensorWrapperOffset(Offset);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Offset, 1);
      grad_node->SetGradOutMeta(Mask, 2);
      grad_node->SetGradOutMeta(Filter, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Output, 0);
      egr::EagerUtils::SetHistory(p_autograd_Output, grad_node);
      grad_node->SetGradInMeta(Output, 0);
      egr::EagerUtils::CheckAndRetainGrad(Output);

    }
  }

  return Output;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_mask_labels_dygraph_function(const paddle::experimental::Tensor& ImInfo,const paddle::experimental::Tensor& GtClasses,const paddle::experimental::Tensor& IsCrowd,const paddle::experimental::Tensor& GtSegms,const paddle::experimental::Tensor& Rois,const paddle::experimental::Tensor& LabelsInt32, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("generate_mask_labels dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: generate_mask_labels";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {ImInfo},{GtClasses},{IsCrowd},{GtSegms},{Rois},{LabelsInt32} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("generate_mask_labels", amp_tensors_vector);

    auto NEW_ImInfo = egr::AmpAutoCast("ImInfo", ImInfo, amp_dst_dtype, "generate_mask_labels");
    auto NEW_GtClasses = egr::AmpAutoCast("GtClasses", GtClasses, amp_dst_dtype, "generate_mask_labels");
    auto NEW_IsCrowd = egr::AmpAutoCast("IsCrowd", IsCrowd, amp_dst_dtype, "generate_mask_labels");
    auto NEW_GtSegms = egr::AmpAutoCast("GtSegms", GtSegms, amp_dst_dtype, "generate_mask_labels");
    auto NEW_Rois = egr::AmpAutoCast("Rois", Rois, amp_dst_dtype, "generate_mask_labels");
    auto NEW_LabelsInt32 = egr::AmpAutoCast("LabelsInt32", LabelsInt32, amp_dst_dtype, "generate_mask_labels");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return generate_mask_labels_dygraph_function( NEW_ImInfo, NEW_GtClasses, NEW_IsCrowd, NEW_GtSegms, NEW_Rois, NEW_LabelsInt32, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "ImInfo", egr::EagerUtils::TrySyncToVars(ImInfo) },{ "GtClasses", egr::EagerUtils::TrySyncToVars(GtClasses) },{ "IsCrowd", egr::EagerUtils::TrySyncToVars(IsCrowd) },{ "GtSegms", egr::EagerUtils::TrySyncToVars(GtSegms) },{ "Rois", egr::EagerUtils::TrySyncToVars(Rois) },{ "LabelsInt32", egr::EagerUtils::TrySyncToVars(LabelsInt32) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "MaskRois", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "RoiHasMaskInt32", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "MaskInt32", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("generate_mask_labels", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor MaskRois;
  egr::EagerUtils::GetOutput(outs["MaskRois"][0], &MaskRois);
  paddle::experimental::Tensor RoiHasMaskInt32;
  egr::EagerUtils::GetOutput(outs["RoiHasMaskInt32"][0], &RoiHasMaskInt32);
  paddle::experimental::Tensor MaskInt32;
  egr::EagerUtils::GetOutput(outs["MaskInt32"][0], &MaskInt32);


  return std::make_tuple(MaskRois,RoiHasMaskInt32,MaskInt32);

}


paddle::experimental::Tensor locality_aware_nms_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("locality_aware_nms dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: locality_aware_nms";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {BBoxes},{Scores} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("locality_aware_nms", amp_tensors_vector);

    auto NEW_BBoxes = egr::AmpAutoCast("BBoxes", BBoxes, amp_dst_dtype, "locality_aware_nms");
    auto NEW_Scores = egr::AmpAutoCast("Scores", Scores, amp_dst_dtype, "locality_aware_nms");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return locality_aware_nms_dygraph_function( NEW_BBoxes, NEW_Scores, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "BBoxes", egr::EagerUtils::TrySyncToVars(BBoxes) },{ "Scores", egr::EagerUtils::TrySyncToVars(Scores) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("locality_aware_nms", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor expand_as_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& target_tensor, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("expand_as dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: expand_as";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{target_tensor} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("expand_as", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "expand_as");
    auto NEW_target_tensor = egr::AmpAutoCast("target_tensor", target_tensor, amp_dst_dtype, "expand_as");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return expand_as_dygraph_function( NEW_X, NEW_target_tensor, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "target_tensor", egr::EagerUtils::TrySyncToVars(target_tensor) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_target_tensor = egr::EagerUtils::nullable_autograd_meta(target_tensor);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_target_tensor);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expand_as", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("expand_as node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for expand_as "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<expand_asGradNodeCompat>(new expand_asGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrappertarget_tensor(target_tensor);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor matrix_power_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("matrix_power dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: matrix_power";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("matrix_power", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "matrix_power");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return matrix_power_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("matrix_power", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("matrix_power node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for matrix_power "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<matrix_powerGradNodeCompat>(new matrix_powerGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor greater_equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("greater_equal dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: greater_equal";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("greater_equal", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "greater_equal");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "greater_equal");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return greater_equal_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("greater_equal", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_proposals_dygraph_function(const paddle::experimental::Tensor& Scores,const paddle::experimental::Tensor& BboxDeltas,const paddle::experimental::Tensor& ImInfo,const paddle::experimental::Tensor& Anchors,const paddle::experimental::Tensor& Variances, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("generate_proposals dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: generate_proposals";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Scores},{BboxDeltas},{ImInfo},{Anchors},{Variances} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("generate_proposals", amp_tensors_vector);

    auto NEW_Scores = egr::AmpAutoCast("Scores", Scores, amp_dst_dtype, "generate_proposals");
    auto NEW_BboxDeltas = egr::AmpAutoCast("BboxDeltas", BboxDeltas, amp_dst_dtype, "generate_proposals");
    auto NEW_ImInfo = egr::AmpAutoCast("ImInfo", ImInfo, amp_dst_dtype, "generate_proposals");
    auto NEW_Anchors = egr::AmpAutoCast("Anchors", Anchors, amp_dst_dtype, "generate_proposals");
    auto NEW_Variances = egr::AmpAutoCast("Variances", Variances, amp_dst_dtype, "generate_proposals");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return generate_proposals_dygraph_function( NEW_Scores, NEW_BboxDeltas, NEW_ImInfo, NEW_Anchors, NEW_Variances, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Scores", egr::EagerUtils::TrySyncToVars(Scores) },{ "BboxDeltas", egr::EagerUtils::TrySyncToVars(BboxDeltas) },{ "ImInfo", egr::EagerUtils::TrySyncToVars(ImInfo) },{ "Anchors", egr::EagerUtils::TrySyncToVars(Anchors) },{ "Variances", egr::EagerUtils::TrySyncToVars(Variances) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "RpnRois", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "RpnRoiProbs", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "RpnRoisNum", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("generate_proposals", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor RpnRois;
  egr::EagerUtils::GetOutput(outs["RpnRois"][0], &RpnRois);
  paddle::experimental::Tensor RpnRoiProbs;
  egr::EagerUtils::GetOutput(outs["RpnRoiProbs"][0], &RpnRoiProbs);
  paddle::experimental::Tensor RpnRoisNum;
  egr::EagerUtils::GetOutput(outs["RpnRoisNum"][0], &RpnRoisNum);


  return std::make_tuple(RpnRois,RpnRoiProbs,RpnRoisNum);

}


paddle::experimental::Tensor number_count_dygraph_function(const paddle::experimental::Tensor& numbers, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("number_count dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: number_count";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {numbers} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("number_count", amp_tensors_vector);

    auto NEW_numbers = egr::AmpAutoCast("numbers", numbers, amp_dst_dtype, "number_count");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return number_count_dygraph_function( NEW_numbers, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "numbers", egr::EagerUtils::TrySyncToVars(numbers) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("number_count", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor bilinear_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("bilinear_interp dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: bilinear_interp";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };
    if(OutSize.initialized()) amp_tensors_vector.push_back({ OutSize });

    auto amp_dst_dtype = egr::GetAmpDestDtype("bilinear_interp", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "bilinear_interp");
    auto NEW_OutSize = ((OutSize.initialized()) ? egr::AmpAutoCast("OutSize", OutSize, amp_dst_dtype, "bilinear_interp") : OutSize);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return bilinear_interp_dygraph_function( NEW_X, NEW_OutSize, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };
  if(OutSize.initialized()) ins["OutSize"] = egr::EagerUtils::TrySyncToVars(OutSize);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_OutSize = egr::EagerUtils::nullable_autograd_meta(OutSize);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_OutSize);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bilinear_interp", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("bilinear_interp node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for bilinear_interp "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<bilinear_interpGradNodeCompat>(new bilinear_interpGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOutSize(OutSize);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,paddle::experimental::Tensor> distributed_fused_lamb_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad,const paddle::experimental::Tensor& Moment1,const paddle::experimental::Tensor& Moment2,const paddle::experimental::Tensor& Beta1Pow,const paddle::experimental::Tensor& Beta2Pow,const paddle::experimental::Tensor& FusedParamOffsets,const paddle::experimental::Tensor& FP32ShardFusedParamOffsets,const paddle::experimental::Tensor& FP16ShardFusedParamOffsets,const paddle::experimental::Tensor& ParamInfo,const paddle::experimental::Tensor& ParamOrder,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& GlobalScale, size_t ParamOutNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("distributed_fused_lamb dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: distributed_fused_lamb";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { Param,Grad,{Moment1},{Moment2},{Beta1Pow},{Beta2Pow},{FusedParamOffsets},{FP32ShardFusedParamOffsets},{FP16ShardFusedParamOffsets},{ParamInfo},{ParamOrder},{LearningRate},{GlobalScale} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("distributed_fused_lamb", amp_tensors_vector);

    auto NEW_Param = egr::AmpAutoCasts("Param", Param, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_Grad = egr::AmpAutoCasts("Grad", Grad, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_Moment1 = egr::AmpAutoCast("Moment1", Moment1, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_Moment2 = egr::AmpAutoCast("Moment2", Moment2, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_Beta1Pow = egr::AmpAutoCast("Beta1Pow", Beta1Pow, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_Beta2Pow = egr::AmpAutoCast("Beta2Pow", Beta2Pow, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_FusedParamOffsets = egr::AmpAutoCast("FusedParamOffsets", FusedParamOffsets, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_FP32ShardFusedParamOffsets = egr::AmpAutoCast("FP32ShardFusedParamOffsets", FP32ShardFusedParamOffsets, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_FP16ShardFusedParamOffsets = egr::AmpAutoCast("FP16ShardFusedParamOffsets", FP16ShardFusedParamOffsets, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_ParamInfo = egr::AmpAutoCast("ParamInfo", ParamInfo, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_ParamOrder = egr::AmpAutoCast("ParamOrder", ParamOrder, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_LearningRate = egr::AmpAutoCast("LearningRate", LearningRate, amp_dst_dtype, "distributed_fused_lamb");
    auto NEW_GlobalScale = egr::AmpAutoCast("GlobalScale", GlobalScale, amp_dst_dtype, "distributed_fused_lamb");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return distributed_fused_lamb_dygraph_function( NEW_Param, NEW_Grad, NEW_Moment1, NEW_Moment2, NEW_Beta1Pow, NEW_Beta2Pow, NEW_FusedParamOffsets, NEW_FP32ShardFusedParamOffsets, NEW_FP16ShardFusedParamOffsets, NEW_ParamInfo, NEW_ParamOrder, NEW_LearningRate, NEW_GlobalScale, ParamOutNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Param", egr::EagerUtils::TrySyncToVars(Param) },{ "Grad", egr::EagerUtils::TrySyncToVars(Grad) },{ "Moment1", egr::EagerUtils::TrySyncToVars(Moment1) },{ "Moment2", egr::EagerUtils::TrySyncToVars(Moment2) },{ "Beta1Pow", egr::EagerUtils::TrySyncToVars(Beta1Pow) },{ "Beta2Pow", egr::EagerUtils::TrySyncToVars(Beta2Pow) },{ "FusedParamOffsets", egr::EagerUtils::TrySyncToVars(FusedParamOffsets) },{ "FP32ShardFusedParamOffsets", egr::EagerUtils::TrySyncToVars(FP32ShardFusedParamOffsets) },{ "FP16ShardFusedParamOffsets", egr::EagerUtils::TrySyncToVars(FP16ShardFusedParamOffsets) },{ "ParamInfo", egr::EagerUtils::TrySyncToVars(ParamInfo) },{ "ParamOrder", egr::EagerUtils::TrySyncToVars(ParamOrder) },{ "LearningRate", egr::EagerUtils::TrySyncToVars(LearningRate) },{ "GlobalScale", egr::EagerUtils::TrySyncToVars(GlobalScale) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Moment1Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Moment2Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Beta1PowOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Beta2PowOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "ParamOut", egr::EagerUtils::CreateVars(ParamOutNum) },{ "FoundInf", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Step", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("distributed_fused_lamb", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Moment1Out;
  egr::EagerUtils::GetOutput(outs["Moment1Out"][0], &Moment1Out);
  paddle::experimental::Tensor Moment2Out;
  egr::EagerUtils::GetOutput(outs["Moment2Out"][0], &Moment2Out);
  paddle::experimental::Tensor Beta1PowOut;
  egr::EagerUtils::GetOutput(outs["Beta1PowOut"][0], &Beta1PowOut);
  paddle::experimental::Tensor Beta2PowOut;
  egr::EagerUtils::GetOutput(outs["Beta2PowOut"][0], &Beta2PowOut);
  std::vector<paddle::experimental::Tensor> ParamOut;
  egr::EagerUtils::GetOutputs(outs["ParamOut"], &ParamOut);
  paddle::experimental::Tensor FoundInf;
  egr::EagerUtils::GetOutput(outs["FoundInf"][0], &FoundInf);
  paddle::experimental::Tensor Step;
  egr::EagerUtils::GetOutput(outs["Step"][0], &Step);


  return std::make_tuple(Moment1Out,Moment2Out,Beta1PowOut,Beta2PowOut,ParamOut,FoundInf,Step);

}


paddle::experimental::Tensor sigmoid_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sigmoid";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sigmoid", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sigmoid");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sigmoid_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sigmoid", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sigmoid "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sigmoidGradNodeCompat>(new sigmoidGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor sigmoid__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sigmoid dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sigmoid";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sigmoid", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for sigmoid "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sigmoidGradNodeCompat>(new sigmoidGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> inplace_abn_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("inplace_abn dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: inplace_abn";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Scale},{Bias},{Mean},{Variance} };
    if(MomentumTensor.initialized()) amp_tensors_vector.push_back({ MomentumTensor });

    auto amp_dst_dtype = egr::GetAmpDestDtype("inplace_abn", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "inplace_abn");
    auto NEW_Scale = egr::AmpAutoCast("Scale", Scale, amp_dst_dtype, "inplace_abn");
    auto NEW_Bias = egr::AmpAutoCast("Bias", Bias, amp_dst_dtype, "inplace_abn");
    auto NEW_Mean = egr::AmpAutoCast("Mean", Mean, amp_dst_dtype, "inplace_abn");
    auto NEW_Variance = egr::AmpAutoCast("Variance", Variance, amp_dst_dtype, "inplace_abn");
    auto NEW_MomentumTensor = ((MomentumTensor.initialized()) ? egr::AmpAutoCast("MomentumTensor", MomentumTensor, amp_dst_dtype, "inplace_abn") : MomentumTensor);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return inplace_abn_dygraph_function( NEW_X, NEW_Scale, NEW_Bias, NEW_Mean, NEW_Variance, NEW_MomentumTensor, MeanOutVar, VarianceOutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Scale", egr::EagerUtils::TrySyncToVars(Scale) },{ "Bias", egr::EagerUtils::TrySyncToVars(Bias) },{ "Mean", egr::EagerUtils::TrySyncToVars(Mean) },{ "Variance", egr::EagerUtils::TrySyncToVars(Variance) } };
  if(MomentumTensor.initialized()) ins["MomentumTensor"] = egr::EagerUtils::TrySyncToVars(MomentumTensor);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "MeanOut", ins["Mean"] },{ "VarianceOut", ins["Variance"] },{ "SavedMean", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SavedVariance", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "ReserveSpace", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Scale = egr::EagerUtils::nullable_autograd_meta(Scale);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);
  egr::AutogradMeta* p_autograd_Mean = egr::EagerUtils::nullable_autograd_meta(Mean);
  egr::AutogradMeta* p_autograd_Variance = egr::EagerUtils::nullable_autograd_meta(Variance);
  egr::AutogradMeta* p_autograd_MomentumTensor = egr::EagerUtils::nullable_autograd_meta(MomentumTensor);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Scale, p_autograd_Bias, p_autograd_Mean, p_autograd_Variance, p_autograd_MomentumTensor);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("inplace_abn", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);
  egr::EagerUtils::GetOutput(outs["MeanOut"][0], MeanOutVar);
  paddle::experimental::Tensor& MeanOut = *MeanOutVar;
  egr::EagerUtils::GetOutput(outs["VarianceOut"][0], VarianceOutVar);
  paddle::experimental::Tensor& VarianceOut = *VarianceOutVar;
  paddle::experimental::Tensor SavedMean;
  egr::EagerUtils::GetOutput(outs["SavedMean"][0], &SavedMean);
  paddle::experimental::Tensor SavedVariance;
  egr::EagerUtils::GetOutput(outs["SavedVariance"][0], &SavedVariance);
  paddle::experimental::Tensor ReserveSpace;
  egr::EagerUtils::GetOutput(outs["ReserveSpace"][0], &ReserveSpace);

  {
    paddle::platform::RecordEvent node_creation_record_event("inplace_abn node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    egr::AutogradMeta* p_autograd_MeanOut = egr::EagerUtils::autograd_meta(&MeanOut);
    egr::AutogradMeta* p_autograd_VarianceOut = egr::EagerUtils::autograd_meta(&VarianceOut);
    egr::AutogradMeta* p_autograd_SavedMean = egr::EagerUtils::autograd_meta(&SavedMean);
    egr::AutogradMeta* p_autograd_SavedVariance = egr::EagerUtils::autograd_meta(&SavedVariance);
    egr::AutogradMeta* p_autograd_ReserveSpace = egr::EagerUtils::autograd_meta(&ReserveSpace);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for inplace_abn "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y, p_autograd_MeanOut, p_autograd_VarianceOut, p_autograd_SavedMean, p_autograd_SavedVariance, p_autograd_ReserveSpace);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<inplace_abnGradNodeCompat>(new inplace_abnGradNodeCompat(6, 6));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperReserveSpace(ReserveSpace);
      grad_node->SetTensorWrapperSavedMean(SavedMean);
      grad_node->SetTensorWrapperSavedVariance(SavedVariance);
      grad_node->SetTensorWrapperScale(Scale);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Scale, 1);
      grad_node->SetGradOutMeta(Bias, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_MeanOut, 1);
      egr::EagerUtils::SetHistory(p_autograd_MeanOut, grad_node);
      grad_node->SetGradInMeta(MeanOut, 1);
      egr::EagerUtils::CheckAndRetainGrad(MeanOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_VarianceOut, 2);
      egr::EagerUtils::SetHistory(p_autograd_VarianceOut, grad_node);
      grad_node->SetGradInMeta(VarianceOut, 2);
      egr::EagerUtils::CheckAndRetainGrad(VarianceOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedMean, 3);
      grad_node->SetGradInMeta(SavedMean, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedVariance, 4);
      grad_node->SetGradInMeta(SavedVariance, 4);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_ReserveSpace, 5);
      egr::EagerUtils::SetHistory(p_autograd_ReserveSpace, grad_node);
      grad_node->SetGradInMeta(ReserveSpace, 5);
      egr::EagerUtils::CheckAndRetainGrad(ReserveSpace);

    }
  }

  return std::make_tuple(Y,MeanOut,VarianceOut,SavedMean,SavedVariance,ReserveSpace);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> inplace_abn__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("inplace_abn dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: inplace_abn";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Scale", egr::EagerUtils::TrySyncToVars(Scale) },{ "Bias", egr::EagerUtils::TrySyncToVars(Bias) },{ "Mean", egr::EagerUtils::TrySyncToVars(Mean) },{ "Variance", egr::EagerUtils::TrySyncToVars(Variance) } };
  if(MomentumTensor.initialized()) ins["MomentumTensor"] = egr::EagerUtils::TrySyncToVars(MomentumTensor);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", ins["X"] },{ "MeanOut", ins["Mean"] },{ "VarianceOut", ins["Variance"] },{ "SavedMean", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "SavedVariance", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "ReserveSpace", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Scale = egr::EagerUtils::nullable_autograd_meta(Scale);
  egr::AutogradMeta* p_autograd_Bias = egr::EagerUtils::nullable_autograd_meta(Bias);
  egr::AutogradMeta* p_autograd_Mean = egr::EagerUtils::nullable_autograd_meta(Mean);
  egr::AutogradMeta* p_autograd_Variance = egr::EagerUtils::nullable_autograd_meta(Variance);
  egr::AutogradMeta* p_autograd_MomentumTensor = egr::EagerUtils::nullable_autograd_meta(MomentumTensor);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Scale, p_autograd_Bias, p_autograd_Mean, p_autograd_Variance, p_autograd_MomentumTensor);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("inplace_abn", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Y"}});

  egr::EagerUtils::GetOutput(outs["Y"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";
  egr::EagerUtils::GetOutput(outs["MeanOut"][0], MeanOutVar);
  paddle::experimental::Tensor& MeanOut = *MeanOutVar;
  egr::EagerUtils::GetOutput(outs["VarianceOut"][0], VarianceOutVar);
  paddle::experimental::Tensor& VarianceOut = *VarianceOutVar;
  paddle::experimental::Tensor SavedMean;
  egr::EagerUtils::GetOutput(outs["SavedMean"][0], &SavedMean);
  paddle::experimental::Tensor SavedVariance;
  egr::EagerUtils::GetOutput(outs["SavedVariance"][0], &SavedVariance);
  paddle::experimental::Tensor ReserveSpace;
  egr::EagerUtils::GetOutput(outs["ReserveSpace"][0], &ReserveSpace);

  {
    paddle::platform::RecordEvent node_creation_record_event("inplace_abn node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    egr::AutogradMeta* p_autograd_MeanOut = egr::EagerUtils::autograd_meta(&MeanOut);
    egr::AutogradMeta* p_autograd_VarianceOut = egr::EagerUtils::autograd_meta(&VarianceOut);
    egr::AutogradMeta* p_autograd_SavedMean = egr::EagerUtils::autograd_meta(&SavedMean);
    egr::AutogradMeta* p_autograd_SavedVariance = egr::EagerUtils::autograd_meta(&SavedVariance);
    egr::AutogradMeta* p_autograd_ReserveSpace = egr::EagerUtils::autograd_meta(&ReserveSpace);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for inplace_abn "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X, p_autograd_MeanOut, p_autograd_VarianceOut, p_autograd_SavedMean, p_autograd_SavedVariance, p_autograd_ReserveSpace);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<inplace_abnGradNodeCompat>(new inplace_abnGradNodeCompat(6, 6));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperBias(Bias);
      grad_node->SetTensorWrapperReserveSpace(ReserveSpace);
      grad_node->SetTensorWrapperSavedMean(SavedMean);
      grad_node->SetTensorWrapperSavedVariance(SavedVariance);
      grad_node->SetTensorWrapperScale(Scale);
      grad_node->SetTensorWrapperY(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Scale, 1);
      grad_node->SetGradOutMeta(Bias, 2);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_MeanOut, 1);
      egr::EagerUtils::SetHistory(p_autograd_MeanOut, grad_node);
      grad_node->SetGradInMeta(MeanOut, 1);
      egr::EagerUtils::CheckAndRetainGrad(MeanOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_VarianceOut, 2);
      egr::EagerUtils::SetHistory(p_autograd_VarianceOut, grad_node);
      grad_node->SetGradInMeta(VarianceOut, 2);
      egr::EagerUtils::CheckAndRetainGrad(VarianceOut);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedMean, 3);
      grad_node->SetGradInMeta(SavedMean, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_SavedVariance, 4);
      grad_node->SetGradInMeta(SavedVariance, 4);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_ReserveSpace, 5);
      egr::EagerUtils::SetHistory(p_autograd_ReserveSpace, grad_node);
      grad_node->SetGradInMeta(ReserveSpace, 5);
      egr::EagerUtils::CheckAndRetainGrad(ReserveSpace);

    }
  }

  return std::make_tuple(X,MeanOut,VarianceOut,SavedMean,SavedVariance,ReserveSpace);

}


paddle::experimental::Tensor softshrink_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("softshrink dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: softshrink";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("softshrink", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "softshrink");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return softshrink_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softshrink", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("softshrink node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for softshrink "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<softshrinkGradNodeCompat>(new softshrinkGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor mul_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("mul dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: mul";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("mul", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "mul");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "mul");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return mul_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mul", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("mul node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for mul "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<mulGradNodeCompat>(new mulGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);
      grad_node->SetTensorWrapperY(Y);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> data_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& BatchSize,const paddle::experimental::Tensor& BatchSum,const paddle::experimental::Tensor& BatchSquareSum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("data_norm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: data_norm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{BatchSize},{BatchSum},{BatchSquareSum} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("data_norm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "data_norm");
    auto NEW_BatchSize = egr::AmpAutoCast("BatchSize", BatchSize, amp_dst_dtype, "data_norm");
    auto NEW_BatchSum = egr::AmpAutoCast("BatchSum", BatchSum, amp_dst_dtype, "data_norm");
    auto NEW_BatchSquareSum = egr::AmpAutoCast("BatchSquareSum", BatchSquareSum, amp_dst_dtype, "data_norm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return data_norm_dygraph_function( NEW_X, NEW_BatchSize, NEW_BatchSum, NEW_BatchSquareSum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "BatchSize", egr::EagerUtils::TrySyncToVars(BatchSize) },{ "BatchSum", egr::EagerUtils::TrySyncToVars(BatchSum) },{ "BatchSquareSum", egr::EagerUtils::TrySyncToVars(BatchSquareSum) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Y", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Means", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Scales", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_BatchSize = egr::EagerUtils::nullable_autograd_meta(BatchSize);
  egr::AutogradMeta* p_autograd_BatchSum = egr::EagerUtils::nullable_autograd_meta(BatchSum);
  egr::AutogradMeta* p_autograd_BatchSquareSum = egr::EagerUtils::nullable_autograd_meta(BatchSquareSum);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_BatchSize, p_autograd_BatchSum, p_autograd_BatchSquareSum);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("data_norm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Y;
  egr::EagerUtils::GetOutput(outs["Y"][0], &Y);
  paddle::experimental::Tensor Means;
  egr::EagerUtils::GetOutput(outs["Means"][0], &Means);
  paddle::experimental::Tensor Scales;
  egr::EagerUtils::GetOutput(outs["Scales"][0], &Scales);

  {
    paddle::platform::RecordEvent node_creation_record_event("data_norm node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::autograd_meta(&Y);
    egr::AutogradMeta* p_autograd_Means = egr::EagerUtils::autograd_meta(&Means);
    egr::AutogradMeta* p_autograd_Scales = egr::EagerUtils::autograd_meta(&Scales);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for data_norm "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Y, p_autograd_Means, p_autograd_Scales);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<data_normGradNodeCompat>(new data_normGradNodeCompat(3, 4));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMeans(Means);
      grad_node->SetTensorWrapperScales(Scales);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(BatchSize, 1);
      grad_node->SetGradOutMeta(BatchSum, 2);
      grad_node->SetGradOutMeta(BatchSquareSum, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Y, 0);
      egr::EagerUtils::SetHistory(p_autograd_Y, grad_node);
      grad_node->SetGradInMeta(Y, 0);
      egr::EagerUtils::CheckAndRetainGrad(Y);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Means, 1);
      grad_node->SetGradInMeta(Means, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Scales, 2);
      grad_node->SetGradInMeta(Scales, 2);

    }
  }

  return std::make_tuple(Y,Means,Scales);

}


paddle::experimental::Tensor asinh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("asinh dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: asinh";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("asinh", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "asinh");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return asinh_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("asinh", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("asinh node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for asinh "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<asinhGradNodeCompat>(new asinhGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor get_tensor_from_selected_rows_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("get_tensor_from_selected_rows dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: get_tensor_from_selected_rows";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("get_tensor_from_selected_rows", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "get_tensor_from_selected_rows");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return get_tensor_from_selected_rows_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("get_tensor_from_selected_rows", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor spp_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("spp dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: spp";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("spp", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "spp");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return spp_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("spp", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("spp node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for spp "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<sppGradNodeCompat>(new sppGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor floor_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("floor dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: floor";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("floor", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "floor");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return floor_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("floor", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("floor node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for floor "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<floorGradNodeCompat>(new floorGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor floor__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("floor dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: floor";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("floor", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("floor node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for floor "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<floorGradNodeCompat>(new floorGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor as_real_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("as_real dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: as_real";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("as_real", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "as_real");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return as_real_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("as_real", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("as_real node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for as_real "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<as_realGradNodeCompat>(new as_realGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor gelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("gelu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: gelu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("gelu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "gelu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return gelu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gelu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("gelu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for gelu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<geluGradNodeCompat>(new geluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor retinanet_detection_output_dygraph_function(const std::vector<paddle::experimental::Tensor>& BBoxes,const std::vector<paddle::experimental::Tensor>& Scores,const std::vector<paddle::experimental::Tensor>& Anchors,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("retinanet_detection_output dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: retinanet_detection_output";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { BBoxes,Scores,Anchors,{ImInfo} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("retinanet_detection_output", amp_tensors_vector);

    auto NEW_BBoxes = egr::AmpAutoCasts("BBoxes", BBoxes, amp_dst_dtype, "retinanet_detection_output");
    auto NEW_Scores = egr::AmpAutoCasts("Scores", Scores, amp_dst_dtype, "retinanet_detection_output");
    auto NEW_Anchors = egr::AmpAutoCasts("Anchors", Anchors, amp_dst_dtype, "retinanet_detection_output");
    auto NEW_ImInfo = egr::AmpAutoCast("ImInfo", ImInfo, amp_dst_dtype, "retinanet_detection_output");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return retinanet_detection_output_dygraph_function( NEW_BBoxes, NEW_Scores, NEW_Anchors, NEW_ImInfo, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "BBoxes", egr::EagerUtils::TrySyncToVars(BBoxes) },{ "Scores", egr::EagerUtils::TrySyncToVars(Scores) },{ "Anchors", egr::EagerUtils::TrySyncToVars(Anchors) },{ "ImInfo", egr::EagerUtils::TrySyncToVars(ImInfo) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("retinanet_detection_output", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor minus_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("minus dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: minus";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Y} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("minus", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "minus");
    auto NEW_Y = egr::AmpAutoCast("Y", Y, amp_dst_dtype, "minus");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return minus_dygraph_function( NEW_X, NEW_Y, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Y", egr::EagerUtils::TrySyncToVars(Y) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_Y = egr::EagerUtils::nullable_autograd_meta(Y);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_Y);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("minus", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("minus node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for minus "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<minusGradNodeCompat>(new minusGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(Y, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


void* push_dense_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("push_dense dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: push_dense";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { Ids };

    auto amp_dst_dtype = egr::GetAmpDestDtype("push_dense", amp_tensors_vector);

    auto NEW_Ids = egr::AmpAutoCasts("Ids", Ids, amp_dst_dtype, "push_dense");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return push_dense_dygraph_function( NEW_Ids, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Ids", egr::EagerUtils::TrySyncToVars(Ids) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = {  };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("push_dense", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});



return nullptr;

}


paddle::experimental::Tensor silu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("silu dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: silu";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("silu", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "silu");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return silu_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("silu", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("silu node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for silu "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<siluGradNodeCompat>(new siluGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor sequence_erase_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("sequence_erase dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: sequence_erase";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("sequence_erase", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "sequence_erase");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return sequence_erase_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sequence_erase", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor real_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("real dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: real";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("real", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "real");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return real_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("real", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("real node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for real "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<realGradNodeCompat>(new realGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor nearest_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("nearest_interp_v2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: nearest_interp_v2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("nearest_interp_v2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "nearest_interp_v2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return nearest_interp_v2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nearest_interp_v2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("nearest_interp_v2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for nearest_interp_v2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<nearest_interp_v2GradNodeCompat>(new nearest_interp_v2GradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor dgc_clip_by_norm_dygraph_function(const paddle::experimental::Tensor& current_step,const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("dgc_clip_by_norm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: dgc_clip_by_norm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {current_step},{X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("dgc_clip_by_norm", amp_tensors_vector);

    auto NEW_current_step = egr::AmpAutoCast("current_step", current_step, amp_dst_dtype, "dgc_clip_by_norm");
    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "dgc_clip_by_norm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dgc_clip_by_norm_dygraph_function( NEW_current_step, NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "current_step", egr::EagerUtils::TrySyncToVars(current_step) },{ "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dgc_clip_by_norm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squeeze2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("squeeze2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: squeeze2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("squeeze2", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "squeeze2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return squeeze2_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };

  if (ins.count("X") && outs.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins["X"][0], outs["Out"][0]);
  };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squeeze2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("squeeze2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for squeeze2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squeeze2GradNodeCompat>(new squeeze2GradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(Out,XShape);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squeeze2__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("squeeze2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: squeeze2";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] },{ "XShape", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squeeze2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";
  paddle::experimental::Tensor XShape;
  egr::EagerUtils::GetOutput(outs["XShape"][0], &XShape);

  {
    paddle::platform::RecordEvent node_creation_record_event("squeeze2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    egr::AutogradMeta* p_autograd_XShape = egr::EagerUtils::autograd_meta(&XShape);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for squeeze2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X, p_autograd_XShape);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squeeze2GradNodeCompat>(new squeeze2GradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperXShape(XShape);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_XShape, 1);
      grad_node->SetGradInMeta(XShape, 1);

    }
  }

  return std::make_tuple(X,XShape);

}


paddle::experimental::Tensor conj_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("conj dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: conj";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("conj", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "conj");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return conj_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conj", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("conj node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for conj "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<conjGradNodeCompat>(new conjGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor strided_slice_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& StartsTensor,const paddle::experimental::Tensor& EndsTensor,const paddle::experimental::Tensor& StridesTensor,const std::vector<paddle::experimental::Tensor>& StartsTensorList,const std::vector<paddle::experimental::Tensor>& EndsTensorList,const std::vector<paddle::experimental::Tensor>& StridesTensorList, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("strided_slice dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: strided_slice";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input} };
    if(StartsTensor.initialized()) amp_tensors_vector.push_back({ StartsTensor });
    if(EndsTensor.initialized()) amp_tensors_vector.push_back({ EndsTensor });
    if(StridesTensor.initialized()) amp_tensors_vector.push_back({ StridesTensor });
    if(StartsTensorList.size() > 0) amp_tensors_vector.push_back(StartsTensorList);
    if(EndsTensorList.size() > 0) amp_tensors_vector.push_back(EndsTensorList);
    if(StridesTensorList.size() > 0) amp_tensors_vector.push_back(StridesTensorList);

    auto amp_dst_dtype = egr::GetAmpDestDtype("strided_slice", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "strided_slice");
    auto NEW_StartsTensor = ((StartsTensor.initialized()) ? egr::AmpAutoCast("StartsTensor", StartsTensor, amp_dst_dtype, "strided_slice") : StartsTensor);
    auto NEW_EndsTensor = ((EndsTensor.initialized()) ? egr::AmpAutoCast("EndsTensor", EndsTensor, amp_dst_dtype, "strided_slice") : EndsTensor);
    auto NEW_StridesTensor = ((StridesTensor.initialized()) ? egr::AmpAutoCast("StridesTensor", StridesTensor, amp_dst_dtype, "strided_slice") : StridesTensor);
    auto NEW_StartsTensorList = ((StartsTensorList.size() > 0) ? egr::AmpAutoCasts("StartsTensorList", StartsTensorList, amp_dst_dtype, "strided_slice") : StartsTensorList);
    auto NEW_EndsTensorList = ((EndsTensorList.size() > 0) ? egr::AmpAutoCasts("EndsTensorList", EndsTensorList, amp_dst_dtype, "strided_slice") : EndsTensorList);
    auto NEW_StridesTensorList = ((StridesTensorList.size() > 0) ? egr::AmpAutoCasts("StridesTensorList", StridesTensorList, amp_dst_dtype, "strided_slice") : StridesTensorList);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return strided_slice_dygraph_function( NEW_Input, NEW_StartsTensor, NEW_EndsTensor, NEW_StridesTensor, NEW_StartsTensorList, NEW_EndsTensorList, NEW_StridesTensorList, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) } };
  if(StartsTensor.initialized()) ins["StartsTensor"] = egr::EagerUtils::TrySyncToVars(StartsTensor);
  if(EndsTensor.initialized()) ins["EndsTensor"] = egr::EagerUtils::TrySyncToVars(EndsTensor);
  if(StridesTensor.initialized()) ins["StridesTensor"] = egr::EagerUtils::TrySyncToVars(StridesTensor);
  if(StartsTensorList.size() > 0) ins["StartsTensorList"] = egr::EagerUtils::TrySyncToVars(StartsTensorList);
  if(EndsTensorList.size() > 0) ins["EndsTensorList"] = egr::EagerUtils::TrySyncToVars(EndsTensorList);
  if(StridesTensorList.size() > 0) ins["StridesTensorList"] = egr::EagerUtils::TrySyncToVars(StridesTensorList);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_StartsTensor = egr::EagerUtils::nullable_autograd_meta(StartsTensor);
  egr::AutogradMeta* p_autograd_EndsTensor = egr::EagerUtils::nullable_autograd_meta(EndsTensor);
  egr::AutogradMeta* p_autograd_StridesTensor = egr::EagerUtils::nullable_autograd_meta(StridesTensor);
  std::vector<egr::AutogradMeta*> p_autograd_StartsTensorList = egr::EagerUtils::nullable_autograd_meta(StartsTensorList);
  std::vector<egr::AutogradMeta*> p_autograd_EndsTensorList = egr::EagerUtils::nullable_autograd_meta(EndsTensorList);
  std::vector<egr::AutogradMeta*> p_autograd_StridesTensorList = egr::EagerUtils::nullable_autograd_meta(StridesTensorList);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_StartsTensor, p_autograd_EndsTensor, p_autograd_StridesTensor, &p_autograd_StartsTensorList, &p_autograd_EndsTensorList, &p_autograd_StridesTensorList);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("strided_slice", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("strided_slice node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for strided_slice "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<strided_sliceGradNodeCompat>(new strided_sliceGradNodeCompat(1, 7));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperEndsTensor(EndsTensor);
      grad_node->SetTensorWrapperEndsTensorList(EndsTensorList);
      grad_node->SetTensorWrapperInput(Input);
      grad_node->SetTensorWrapperStartsTensor(StartsTensor);
      grad_node->SetTensorWrapperStartsTensorList(StartsTensorList);
      grad_node->SetTensorWrapperStridesTensor(StridesTensor);
      grad_node->SetTensorWrapperStridesTensorList(StridesTensorList);

      grad_node->SetGradOutMeta(Input, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> precision_recall_dygraph_function(const paddle::experimental::Tensor& MaxProbs,const paddle::experimental::Tensor& Indices,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("precision_recall dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: precision_recall";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {MaxProbs},{Indices},{Labels} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("precision_recall", amp_tensors_vector);

    auto NEW_MaxProbs = egr::AmpAutoCast("MaxProbs", MaxProbs, amp_dst_dtype, "precision_recall");
    auto NEW_Indices = egr::AmpAutoCast("Indices", Indices, amp_dst_dtype, "precision_recall");
    auto NEW_Labels = egr::AmpAutoCast("Labels", Labels, amp_dst_dtype, "precision_recall");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return precision_recall_dygraph_function( NEW_MaxProbs, NEW_Indices, NEW_Labels, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "MaxProbs", egr::EagerUtils::TrySyncToVars(MaxProbs) },{ "Indices", egr::EagerUtils::TrySyncToVars(Indices) },{ "Labels", egr::EagerUtils::TrySyncToVars(Labels) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "BatchMetrics", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "AccumMetrics", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "AccumStatesInfo", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("precision_recall", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor BatchMetrics;
  egr::EagerUtils::GetOutput(outs["BatchMetrics"][0], &BatchMetrics);
  paddle::experimental::Tensor AccumMetrics;
  egr::EagerUtils::GetOutput(outs["AccumMetrics"][0], &AccumMetrics);
  paddle::experimental::Tensor AccumStatesInfo;
  egr::EagerUtils::GetOutput(outs["AccumStatesInfo"][0], &AccumStatesInfo);


  return std::make_tuple(BatchMetrics,AccumMetrics,AccumStatesInfo);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_seqexpand_concat_fc_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& FCWeight, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fusion_seqexpand_concat_fc dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fusion_seqexpand_concat_fc";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { X,{FCWeight} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fusion_seqexpand_concat_fc", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCasts("X", X, amp_dst_dtype, "fusion_seqexpand_concat_fc");
    auto NEW_FCWeight = egr::AmpAutoCast("FCWeight", FCWeight, amp_dst_dtype, "fusion_seqexpand_concat_fc");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fusion_seqexpand_concat_fc_dygraph_function( NEW_X, NEW_FCWeight, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "FCWeight", egr::EagerUtils::TrySyncToVars(FCWeight) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "FCOut", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fusion_seqexpand_concat_fc", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor FCOut;
  egr::EagerUtils::GetOutput(outs["FCOut"][0], &FCOut);


  return std::make_tuple(Out,FCOut);

}


void* save_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("save dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: save";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("save", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "save");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return save_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = {  };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("save", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});



return nullptr;

}


paddle::experimental::Tensor depthwise_conv2d_transpose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("depthwise_conv2d_transpose dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: depthwise_conv2d_transpose";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input},{Filter} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("depthwise_conv2d_transpose", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "depthwise_conv2d_transpose");
    auto NEW_Filter = egr::AmpAutoCast("Filter", Filter, amp_dst_dtype, "depthwise_conv2d_transpose");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return depthwise_conv2d_transpose_dygraph_function( NEW_Input, NEW_Filter, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) },{ "Filter", egr::EagerUtils::TrySyncToVars(Filter) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Output", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_Input = egr::EagerUtils::nullable_autograd_meta(Input);
  egr::AutogradMeta* p_autograd_Filter = egr::EagerUtils::nullable_autograd_meta(Filter);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_Input, p_autograd_Filter);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("depthwise_conv2d_transpose", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Output;
  egr::EagerUtils::GetOutput(outs["Output"][0], &Output);

  {
    paddle::platform::RecordEvent node_creation_record_event("depthwise_conv2d_transpose node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Output = egr::EagerUtils::autograd_meta(&Output);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for depthwise_conv2d_transpose "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Output);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<depthwise_conv2d_transposeGradNodeCompat>(new depthwise_conv2d_transposeGradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperFilter(Filter);
      grad_node->SetTensorWrapperInput(Input);

      grad_node->SetGradOutMeta(Input, 0);
      grad_node->SetGradOutMeta(Filter, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Output, 0);
      egr::EagerUtils::SetHistory(p_autograd_Output, grad_node);
      grad_node->SetGradInMeta(Output, 0);
      egr::EagerUtils::CheckAndRetainGrad(Output);

    }
  }

  return Output;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_range_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& InScale, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fake_quantize_range_abs_max dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fake_quantize_range_abs_max";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{InScale} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fake_quantize_range_abs_max", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fake_quantize_range_abs_max");
    auto NEW_InScale = egr::AmpAutoCast("InScale", InScale, amp_dst_dtype, "fake_quantize_range_abs_max");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fake_quantize_range_abs_max_dygraph_function( NEW_X, NEW_InScale, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "InScale", egr::EagerUtils::TrySyncToVars(InScale) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "OutScale", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fake_quantize_range_abs_max", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor OutScale;
  egr::EagerUtils::GetOutput(outs["OutScale"][0], &OutScale);


  return std::make_tuple(Out,OutScale);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> positive_negative_pair_dygraph_function(const paddle::experimental::Tensor& Score,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& QueryID, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("positive_negative_pair dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: positive_negative_pair";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Score},{Label},{QueryID} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("positive_negative_pair", amp_tensors_vector);

    auto NEW_Score = egr::AmpAutoCast("Score", Score, amp_dst_dtype, "positive_negative_pair");
    auto NEW_Label = egr::AmpAutoCast("Label", Label, amp_dst_dtype, "positive_negative_pair");
    auto NEW_QueryID = egr::AmpAutoCast("QueryID", QueryID, amp_dst_dtype, "positive_negative_pair");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return positive_negative_pair_dygraph_function( NEW_Score, NEW_Label, NEW_QueryID, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Score", egr::EagerUtils::TrySyncToVars(Score) },{ "Label", egr::EagerUtils::TrySyncToVars(Label) },{ "QueryID", egr::EagerUtils::TrySyncToVars(QueryID) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "PositivePair", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "NegativePair", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("positive_negative_pair", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor PositivePair;
  egr::EagerUtils::GetOutput(outs["PositivePair"][0], &PositivePair);
  paddle::experimental::Tensor NegativePair;
  egr::EagerUtils::GetOutput(outs["NegativePair"][0], &NegativePair);


  return std::make_tuple(PositivePair,NegativePair);

}


paddle::experimental::Tensor square_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("square dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: square";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("square", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "square");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return square_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("square", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("square node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for square "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squareGradNodeCompat>(new squareGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor square__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("square dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: square";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("square", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("square node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for square "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<squareGradNodeCompat>(new squareGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> var_conv_2d_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROW,const paddle::experimental::Tensor& COLUMN,const paddle::experimental::Tensor& W, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("var_conv_2d dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: var_conv_2d";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{ROW},{COLUMN},{W} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("var_conv_2d", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "var_conv_2d");
    auto NEW_ROW = egr::AmpAutoCast("ROW", ROW, amp_dst_dtype, "var_conv_2d");
    auto NEW_COLUMN = egr::AmpAutoCast("COLUMN", COLUMN, amp_dst_dtype, "var_conv_2d");
    auto NEW_W = egr::AmpAutoCast("W", W, amp_dst_dtype, "var_conv_2d");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return var_conv_2d_dygraph_function( NEW_X, NEW_ROW, NEW_COLUMN, NEW_W, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "ROW", egr::EagerUtils::TrySyncToVars(ROW) },{ "COLUMN", egr::EagerUtils::TrySyncToVars(COLUMN) },{ "W", egr::EagerUtils::TrySyncToVars(W) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Col", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_ROW = egr::EagerUtils::nullable_autograd_meta(ROW);
  egr::AutogradMeta* p_autograd_COLUMN = egr::EagerUtils::nullable_autograd_meta(COLUMN);
  egr::AutogradMeta* p_autograd_W = egr::EagerUtils::nullable_autograd_meta(W);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_ROW, p_autograd_COLUMN, p_autograd_W);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("var_conv_2d", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Col;
  egr::EagerUtils::GetOutput(outs["Col"][0], &Col);

  {
    paddle::platform::RecordEvent node_creation_record_event("var_conv_2d node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Col = egr::EagerUtils::autograd_meta(&Col);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for var_conv_2d "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Col);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<var_conv_2dGradNodeCompat>(new var_conv_2dGradNodeCompat(2, 4));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperCOLUMN(COLUMN);
      grad_node->SetTensorWrapperCol(Col);
      grad_node->SetTensorWrapperOut(Out);
      grad_node->SetTensorWrapperROW(ROW);
      grad_node->SetTensorWrapperW(W);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      grad_node->SetGradOutMeta(W, 3);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Col, 1);
      egr::EagerUtils::SetHistory(p_autograd_Col, grad_node);
      grad_node->SetGradInMeta(Col, 1);
      egr::EagerUtils::CheckAndRetainGrad(Col);

    }
  }

  return std::make_tuple(Out,Col);

}


paddle::experimental::Tensor log1p_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("log1p dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: log1p";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("log1p", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "log1p");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return log1p_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log1p", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("log1p node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for log1p "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<log1pGradNodeCompat>(new log1pGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor channel_shuffle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("channel_shuffle dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: channel_shuffle";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("channel_shuffle", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "channel_shuffle");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return channel_shuffle_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("channel_shuffle", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("channel_shuffle node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for channel_shuffle "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<channel_shuffleGradNodeCompat>(new channel_shuffleGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor atan2_dygraph_function(const paddle::experimental::Tensor& X1,const paddle::experimental::Tensor& X2, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("atan2 dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: atan2";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X1},{X2} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("atan2", amp_tensors_vector);

    auto NEW_X1 = egr::AmpAutoCast("X1", X1, amp_dst_dtype, "atan2");
    auto NEW_X2 = egr::AmpAutoCast("X2", X2, amp_dst_dtype, "atan2");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return atan2_dygraph_function( NEW_X1, NEW_X2, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X1", egr::EagerUtils::TrySyncToVars(X1) },{ "X2", egr::EagerUtils::TrySyncToVars(X2) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X1 = egr::EagerUtils::nullable_autograd_meta(X1);
  egr::AutogradMeta* p_autograd_X2 = egr::EagerUtils::nullable_autograd_meta(X2);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X1, p_autograd_X2);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("atan2", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("atan2 node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for atan2 "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<atan2GradNodeCompat>(new atan2GradNodeCompat(1, 2));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX1(X1);
      grad_node->SetTensorWrapperX2(X2);

      grad_node->SetGradOutMeta(X1, 0);
      grad_node->SetGradOutMeta(X2, 1);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fused_softmax_mask_upper_triangle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fused_softmax_mask_upper_triangle dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fused_softmax_mask_upper_triangle";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fused_softmax_mask_upper_triangle", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fused_softmax_mask_upper_triangle");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fused_softmax_mask_upper_triangle_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fused_softmax_mask_upper_triangle", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("fused_softmax_mask_upper_triangle node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fused_softmax_mask_upper_triangle "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fused_softmax_mask_upper_triangleGradNodeCompat>(new fused_softmax_mask_upper_triangleGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperOut(Out);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor clip_by_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("clip_by_norm dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: clip_by_norm";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("clip_by_norm", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "clip_by_norm");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return clip_by_norm_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("clip_by_norm", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> box_decoder_and_assign_dygraph_function(const paddle::experimental::Tensor& PriorBox,const paddle::experimental::Tensor& TargetBox,const paddle::experimental::Tensor& BoxScore, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("box_decoder_and_assign dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: box_decoder_and_assign";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {PriorBox},{TargetBox},{BoxScore} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("box_decoder_and_assign", amp_tensors_vector);

    auto NEW_PriorBox = egr::AmpAutoCast("PriorBox", PriorBox, amp_dst_dtype, "box_decoder_and_assign");
    auto NEW_TargetBox = egr::AmpAutoCast("TargetBox", TargetBox, amp_dst_dtype, "box_decoder_and_assign");
    auto NEW_BoxScore = egr::AmpAutoCast("BoxScore", BoxScore, amp_dst_dtype, "box_decoder_and_assign");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return box_decoder_and_assign_dygraph_function( NEW_PriorBox, NEW_TargetBox, NEW_BoxScore, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "PriorBox", egr::EagerUtils::TrySyncToVars(PriorBox) },{ "TargetBox", egr::EagerUtils::TrySyncToVars(TargetBox) },{ "BoxScore", egr::EagerUtils::TrySyncToVars(BoxScore) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "DecodeBox", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "OutputAssignBox", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("box_decoder_and_assign", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor DecodeBox;
  egr::EagerUtils::GetOutput(outs["DecodeBox"][0], &DecodeBox);
  paddle::experimental::Tensor OutputAssignBox;
  egr::EagerUtils::GetOutput(outs["OutputAssignBox"][0], &OutputAssignBox);


  return std::make_tuple(DecodeBox,OutputAssignBox);

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> roi_pool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& RoisNum, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("roi_pool dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: roi_pool";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{ROIs} };
    if(RoisNum.initialized()) amp_tensors_vector.push_back({ RoisNum });

    auto amp_dst_dtype = egr::GetAmpDestDtype("roi_pool", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "roi_pool");
    auto NEW_ROIs = egr::AmpAutoCast("ROIs", ROIs, amp_dst_dtype, "roi_pool");
    auto NEW_RoisNum = ((RoisNum.initialized()) ? egr::AmpAutoCast("RoisNum", RoisNum, amp_dst_dtype, "roi_pool") : RoisNum);

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return roi_pool_dygraph_function( NEW_X, NEW_ROIs, NEW_RoisNum, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "ROIs", egr::EagerUtils::TrySyncToVars(ROIs) } };
  if(RoisNum.initialized()) ins["RoisNum"] = egr::EagerUtils::TrySyncToVars(RoisNum);

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Argmax", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);
  egr::AutogradMeta* p_autograd_ROIs = egr::EagerUtils::nullable_autograd_meta(ROIs);
  egr::AutogradMeta* p_autograd_RoisNum = egr::EagerUtils::nullable_autograd_meta(RoisNum);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X, p_autograd_ROIs, p_autograd_RoisNum);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("roi_pool", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Argmax;
  egr::EagerUtils::GetOutput(outs["Argmax"][0], &Argmax);

  {
    paddle::platform::RecordEvent node_creation_record_event("roi_pool node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Argmax = egr::EagerUtils::autograd_meta(&Argmax);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for roi_pool "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Argmax);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<roi_poolGradNodeCompat>(new roi_poolGradNodeCompat(2, 3));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperArgmax(Argmax);
      grad_node->SetTensorWrapperROIs(ROIs);
      grad_node->SetTensorWrapperRoisNum(RoisNum);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Argmax, 1);
      grad_node->SetGradInMeta(Argmax, 1);

    }
  }

  return std::make_tuple(Out,Argmax);

}


paddle::experimental::Tensor fft_r2c_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fft_r2c dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fft_r2c";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fft_r2c", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fft_r2c");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fft_r2c_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fft_r2c", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("fft_r2c node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fft_r2c "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fft_r2cGradNodeCompat>(new fft_r2cGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor overlap_add_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("overlap_add dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: overlap_add";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("overlap_add", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "overlap_add");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return overlap_add_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("overlap_add", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("overlap_add node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for overlap_add "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<overlap_addGradNodeCompat>(new overlap_addGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fill_constant_batch_size_like_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_constant_batch_size_like dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_constant_batch_size_like";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {Input} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fill_constant_batch_size_like", amp_tensors_vector);

    auto NEW_Input = egr::AmpAutoCast("Input", Input, amp_dst_dtype, "fill_constant_batch_size_like");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_constant_batch_size_like_dygraph_function( NEW_Input, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "Input", egr::EagerUtils::TrySyncToVars(Input) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_constant_batch_size_like", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor fill_any_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_any dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_any";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("fill_any", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "fill_any");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return fill_any_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_any", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("fill_any node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fill_any "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fill_anyGradNodeCompat>(new fill_anyGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor fill_any__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("fill_any dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: fill_any";
  // Dygraph Forward Pass

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", ins["X"] } };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);
  // Check Inplace
  egr::EagerUtils::CheckInplace(X, p_autograd_X, require_any_grad);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_any", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {{"X", "Out"}});

  egr::EagerUtils::GetOutput(outs["Out"][0], &X);
  X.bump_inplace_version();
  VLOG(3) << "Tensor(" << X.name() << ") uses Inplace Strategy.";

  {
    paddle::platform::RecordEvent node_creation_record_event("fill_any node_creation", paddle::platform::TracerEventType::Operator, 1);
    p_autograd_X = egr::EagerUtils::autograd_meta(&X);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for fill_any "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_X);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<fill_anyGradNodeCompat>(new fill_anyGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_X, 0);
      egr::EagerUtils::SetHistory(p_autograd_X, grad_node);
      grad_node->SetGradInMeta(X, 0);
      egr::EagerUtils::CheckAndRetainGrad(X);

    }
  }

  return X;

}


paddle::experimental::Tensor dequantize_log_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Dict, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("dequantize_log dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: dequantize_log";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X},{Dict} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("dequantize_log", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "dequantize_log");
    auto NEW_Dict = egr::AmpAutoCast("Dict", Dict, amp_dst_dtype, "dequantize_log");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return dequantize_log_dygraph_function( NEW_X, NEW_Dict, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) },{ "Dict", egr::EagerUtils::TrySyncToVars(Dict) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("dequantize_log", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);


  return Out;

}


paddle::experimental::Tensor c_split_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("c_split dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: c_split";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("c_split", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "c_split");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return c_split_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_split", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);

  {
    paddle::platform::RecordEvent node_creation_record_event("c_split node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for c_split "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<c_splitGradNodeCompat>(new c_splitGradNodeCompat(1, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);

    }
  }

  return Out;

}


paddle::experimental::Tensor barrier_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("barrier dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: barrier";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("barrier", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "barrier");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return barrier_dygraph_function( NEW_X, OutVar, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", egr::EagerUtils::TrySyncToVars(OutVar) } };


  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("barrier", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  egr::EagerUtils::GetOutput(outs["Out"][0], OutVar);
  paddle::experimental::Tensor& Out = *OutVar;


  return Out;

}


std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> max_pool2d_with_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map) {

  paddle::platform::RecordEvent dygraph_entrance_record_event("max_pool2d_with_index dygraph", paddle::platform::TracerEventType::Operator, 1);
  VLOG(3) << "Running Eager Forward Op: max_pool2d_with_index";
  // Dygraph Forward Pass

  if (egr::Controller::Instance().GetAMPLevel() != paddle::imperative::AmpLevel::O0) {
    VLOG(5) << "Check and Prepare For AMP";
  
    paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> amp_tensors_vector = { {X} };

    auto amp_dst_dtype = egr::GetAmpDestDtype("max_pool2d_with_index", amp_tensors_vector);

    auto NEW_X = egr::AmpAutoCast("X", X, amp_dst_dtype, "max_pool2d_with_index");

    {
      paddle::imperative::AutoCastGuard guard(egr::Controller::Instance().GetCurrentTracer(), paddle::imperative::AmpLevel::O0);
      return max_pool2d_with_index_dygraph_function( NEW_X, attr_map );
    }

  }

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins = { { "X", egr::EagerUtils::TrySyncToVars(X) } };

  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs = { { "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}},{ "Mask", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}} };


  // Prepare Autograd Meta 
  egr::AutogradMeta* p_autograd_X = egr::EagerUtils::nullable_autograd_meta(X);

  bool trace_backward = egr::Controller::Instance().HasGrad();

  bool require_any_grad = egr::EagerUtils::ComputeRequireGrad(trace_backward, p_autograd_X);

  paddle::framework::AttributeMap attrs = attr_map;
  paddle::framework::AttributeMap default_attrs;
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("max_pool2d_with_index", ins, outs, attrs, 
     egr::Controller::Instance().GetExpectedPlace(),
     &default_attrs, true, {});

  paddle::experimental::Tensor Out;
  egr::EagerUtils::GetOutput(outs["Out"][0], &Out);
  paddle::experimental::Tensor Mask;
  egr::EagerUtils::GetOutput(outs["Mask"][0], &Mask);

  {
    paddle::platform::RecordEvent node_creation_record_event("max_pool2d_with_index node_creation", paddle::platform::TracerEventType::Operator, 1);
    egr::AutogradMeta* p_autograd_Out = egr::EagerUtils::autograd_meta(&Out);
    egr::AutogradMeta* p_autograd_Mask = egr::EagerUtils::autograd_meta(&Mask);
    if(require_any_grad) {
      VLOG(6) << " Construct Grad for max_pool2d_with_index "; 
      egr::EagerUtils::PassStopGradient(false, p_autograd_Out, p_autograd_Mask);
      // Create GradOpNode
      auto grad_node = std::shared_ptr<max_pool2d_with_indexGradNodeCompat>(new max_pool2d_with_indexGradNodeCompat(2, 1));

      // Set Attributes
      grad_node->SetAttrMap(std::move(attrs));
      grad_node->SetDefaultAttrMap(std::move(default_attrs));

      // Set Tensor Wrappers
      grad_node->SetTensorWrapperMask(Mask);
      grad_node->SetTensorWrapperX(X);

      grad_node->SetGradOutMeta(X, 0);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Out, 0);
      egr::EagerUtils::SetHistory(p_autograd_Out, grad_node);
      grad_node->SetGradInMeta(Out, 0);
      egr::EagerUtils::CheckAndRetainGrad(Out);
      egr::EagerUtils::SetOutRankWithSlot(p_autograd_Mask, 1);
      egr::EagerUtils::SetHistory(p_autograd_Mask, grad_node);
      grad_node->SetGradInMeta(Mask, 1);
      egr::EagerUtils::CheckAndRetainGrad(Mask);

    }
  }

  return std::make_tuple(Out,Mask);

}



