# PaddlePaddle を安全に使用する

このドキュメントでは、PaddlePaddle のモデルセキュリティとコードセキュリティについて説明します。また、PaddlePaddle の脆弱性を報告する方法のガイドラインも提供します。

## PaddlePaddle モデルのセキュリティ

PaddlePaddle はモデルのセキュリティとプライバシーを重要視しています。これには、モデルがセキュリティ関連やセーフティクリティカルなシナリオで使用される際に、干渉下で誤った判断結果を出力することを防ぐ方法や、モデル自身、モデルの勾配、モデルの推論結果からデータやプライバシー情報が漏れることを避ける方法が含まれます。



[PaddleSleeve](https://github.com/PaddlePaddle/PaddleSleeve) は、一連のセキュリティとプライバシーのツールを提供します。これは、モデルの開発者とユーザが、開発と展開の両方の段階で、モデルのセキュリティとプライバシーを体系的に評価し、改善するのに役立ちます。



これらのツールには、敵対的事例評価テスト、擬似自然環境頑健性評価テスト、モデル反転評価テスト、メンバー推論評価テスト、サンプルノイズ除去、敵対的トレーニング、プライバシー強化オプティマイザなどが含まれます。

### 信頼できないモデルの実行

信頼されていないモデルを常にサンドボックスの中にロードして実行し、セキュリティへの影響を必ず知っておいてください。
モデルが信頼されなくなる方法はいくつかあります。PaddlePaddle はシステムに影響を与えるのに十分な機能を持っています。(例えば、`paddle.load` は暗黙的に [pickle](https://docs.python.org/3/library/pickle.html) を使用します。これは、不正なモデルが任意のコードを実行する原因となるかもしれません)。そのため、信頼できないモデルを使用する場合は、慎重に監査し、サンドボックス内で PaddlePaddle を実行することを推奨します。

## PaddlePaddle コードセキュリティ

PaddlePaddle は常にコードセキュリティに真剣に取り組んでいます。しかし、フレームワークの複雑さと他のサードパーティのオープンソースライブラリへの依存のため、まだ発見されていないセキュリティ問題があるかもしれません。そのため、より多くのセキュリティ研究者と PaddlePaddle 開発者がコードセキュリティプログラムに参加することを望みます。PaddlePaddle をより安全なものにするために、セキュリティ問題の責任ある開示と、脆弱性発見ツールの改善のためのコード貢献を奨励します。

### コードセキュリティツール

PaddlePaddle セキュリティチームはフレームワークのセキュリティを非常に重視しています。できるだけ早くセキュリティ問題を発見し修正するために、我々は継続的にコードセキュリティ監査を行い、自動脆弱性発見ツールを開発しています。我々はすでにその一部をコミュニティにオープンソース化しており、これにより人々がコントリビュートし、PaddlePaddle の安全性と堅牢性が向上することを期待しています。[このツール](https://github.com/PaddlePaddle/PaddleSleeve/tree/main/CodeSecurity)には 2 つの部分があります。動的な部分には、いくつかのopファザーサンプルが含まれています。そして静的な部分には CodeQL のサンプルが含まれています。これらは両方とも、PaddlePaddle フレームワークのコードベースの脆弱性を発見することを目的としています。サンプルを参照することで、セキュリティ研究者は、より多くの PaddlePaddle モジュールをテストし、より多くのコードセキュリティ問題を発見するために、独自のファザーや QL を書くことができます。

### 脆弱性の報告

私たちは、PaddlePaddle にセキュリティ問題を責任を持って開示することを推奨します。あなたが見つけたセキュリティ問題については、paddle-security@baidu.com までメールで報告してください。



セキュリティチームがメールを受信した後、時間内にご連絡を差し上げます。セキュリティーチームは、問題の修正についてお知らせするよう努めます。



問題を再現して特定するために、以下の情報を電子メールに添付してください:

- 再現方法を含む脆弱性の詳細。PoC を添付してください。
- 攻撃シナリオと、攻撃者がこの問題で達成できるかもしれないこと。
- この脆弱性が公表されているかどうか。公表されている場合は、その詳細を添付してください。
- あなたの名前と所属。

バグフィックスは PaddlePaddle のリリースに記載し、脆弱性の詳細と報告者をセキュリティ勧告で公表します（匿名を選択した場合、あなたの名前は公表されません）。

### 脆弱性とは？

PaddlePaddle の計算グラフの過程で、モデルはファイルの読み書き、ネットワークとの通信などを含む任意の計算を行うことができます。これはメモリ枯渇やデッドロックなどを引き起こす可能性があり、PaddlePaddle の予期せぬ動作につながります。私たちは、これらの振る舞いが、関係する操作の意図から外れている場合にのみ、セキュリティの脆弱性とみなします。



いくつかの予期しないパラメータや動作は、Pythonでは例外を投げることで、C++ではエラー状態を返すことで、PaddlePaddle でチェックされています。このような場合でもサービス拒否の可能性はありますが、PaddlePaddle の終了はクリーンです。PaddlePaddle のエラー処理は予期されたものであり正しいので、これらのケースはセキュリティ脆弱性ではありません。



悪意のある入力がメモリ破壊やクリーンでない終了の引き金となる場合、そのようなバグはセキュリティ上の問題とみなされます。



[セキュリティ勧告](./security/README_ja.md)
