

#include "paddle/fluid/pybind/static_op_function.h"
#include "paddle/fluid/pir/dialect/operator/ir/pd_api.h"
#include "paddle/fluid/pybind/eager_utils.h"
#include "paddle/fluid/pybind/exception.h"
#include "paddle/fluid/pybind/op_function_common.h"
#include "paddle/phi/common/int_array.h"
#include "paddle/phi/core/enforce.h"



namespace paddle {

namespace pybind {

PyObject *static_api_abs(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add abs op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "abs", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::abs(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_abs_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add abs_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "abs_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::abs_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_accuracy(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add accuracy op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "accuracy", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "accuracy", 1);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 2);
        auto label = CastPyArg2Value(label_obj, "accuracy", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::accuracy(x, indices, label);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acos(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acos op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acos", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acos(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acos_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acos_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acos_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acos_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acosh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acosh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acosh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acosh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acosh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acosh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acosh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acosh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_adagrad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add adagrad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "adagrad_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "adagrad_", 1);
        PyObject *moment_obj = PyTuple_GET_ITEM(args, 2);
        auto moment = CastPyArg2Value(moment_obj, "adagrad_", 2);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 3);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "adagrad_", 3);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 4);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "adagrad_", 4);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 5);
        float epsilon = CastPyArg2Float(epsilon_obj, "adagrad_", 5);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 6);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "adagrad_", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::adagrad_(param, grad, moment, learning_rate, master_param, epsilon, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_adam_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add adam_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "adam_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "adam_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "adam_", 2);
        PyObject *moment1_obj = PyTuple_GET_ITEM(args, 3);
        auto moment1 = CastPyArg2Value(moment1_obj, "adam_", 3);
        PyObject *moment2_obj = PyTuple_GET_ITEM(args, 4);
        auto moment2 = CastPyArg2Value(moment2_obj, "adam_", 4);
        PyObject *beta1_pow_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pow = CastPyArg2Value(beta1_pow_obj, "adam_", 5);
        PyObject *beta2_pow_obj = PyTuple_GET_ITEM(args, 6);
        auto beta2_pow = CastPyArg2Value(beta2_pow_obj, "adam_", 6);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 7);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "adam_", 7);
        PyObject *skip_update_obj = PyTuple_GET_ITEM(args, 8);
        auto skip_update = CastPyArg2OptionalValue(skip_update_obj, "adam_", 8);

        // Parse Attributes
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 11);
        PyObject *lazy_mode_obj = PyTuple_GET_ITEM(args, 12);
        PyObject *min_row_size_to_use_multithread_obj = PyTuple_GET_ITEM(args, 13);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 14);
        PyObject *use_global_beta_pow_obj = PyTuple_GET_ITEM(args, 15);

        // Check for mutable attrs
       pir::Value beta1;

       pir::Value beta2;

       pir::Value epsilon;

        if (PyObject_CheckIROpResult(beta1_obj)){
             beta1 = CastPyArg2Value(beta1_obj, "adam_", 9);
        }else{
            float beta1_tmp = CastPyArg2Float(beta1_obj, "adam_", 9);
            beta1 = paddle::dialect::full(std::vector<int64_t>{1}, beta1_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(beta2_obj)){
             beta2 = CastPyArg2Value(beta2_obj, "adam_", 10);
        }else{
            float beta2_tmp = CastPyArg2Float(beta2_obj, "adam_", 10);
            beta2 = paddle::dialect::full(std::vector<int64_t>{1}, beta2_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(epsilon_obj)){
             epsilon = CastPyArg2Value(epsilon_obj, "adam_", 11);
        }else{
            float epsilon_tmp = CastPyArg2Float(epsilon_obj, "adam_", 11);
            epsilon = paddle::dialect::full(std::vector<int64_t>{1}, epsilon_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            bool lazy_mode = CastPyArg2Boolean(lazy_mode_obj, "adam_", 12);
            int64_t min_row_size_to_use_multithread = CastPyArg2Long(min_row_size_to_use_multithread_obj, "adam_", 13);
            bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "adam_", 14);
            bool use_global_beta_pow = CastPyArg2Boolean(use_global_beta_pow_obj, "adam_", 15);

        // Call ir static api
        auto static_api_out = paddle::dialect::adam_(param, grad, learning_rate, moment1, moment2, beta1_pow, beta2_pow, master_param, skip_update, beta1, beta2, epsilon, lazy_mode, min_row_size_to_use_multithread, multi_precision, use_global_beta_pow);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_adamax_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add adamax_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "adamax_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "adamax_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "adamax_", 2);
        PyObject *moment_obj = PyTuple_GET_ITEM(args, 3);
        auto moment = CastPyArg2Value(moment_obj, "adamax_", 3);
        PyObject *inf_norm_obj = PyTuple_GET_ITEM(args, 4);
        auto inf_norm = CastPyArg2Value(inf_norm_obj, "adamax_", 4);
        PyObject *beta1_pow_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pow = CastPyArg2Value(beta1_pow_obj, "adamax_", 5);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 6);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "adamax_", 6);

        // Parse Attributes
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 7);
        float beta1 = CastPyArg2Float(beta1_obj, "adamax_", 7);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 8);
        float beta2 = CastPyArg2Float(beta2_obj, "adamax_", 8);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 9);
        float epsilon = CastPyArg2Float(epsilon_obj, "adamax_", 9);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 10);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "adamax_", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::adamax_(param, grad, learning_rate, moment, inf_norm, beta1_pow, master_param, beta1, beta2, epsilon, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_adamw_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add adamw_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "adamw_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "adamw_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "adamw_", 2);
        PyObject *moment1_obj = PyTuple_GET_ITEM(args, 3);
        auto moment1 = CastPyArg2Value(moment1_obj, "adamw_", 3);
        PyObject *moment2_obj = PyTuple_GET_ITEM(args, 4);
        auto moment2 = CastPyArg2Value(moment2_obj, "adamw_", 4);
        PyObject *beta1_pow_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pow = CastPyArg2Value(beta1_pow_obj, "adamw_", 5);
        PyObject *beta2_pow_obj = PyTuple_GET_ITEM(args, 6);
        auto beta2_pow = CastPyArg2Value(beta2_pow_obj, "adamw_", 6);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 7);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "adamw_", 7);
        PyObject *skip_update_obj = PyTuple_GET_ITEM(args, 8);
        auto skip_update = CastPyArg2OptionalValue(skip_update_obj, "adamw_", 8);

        // Parse Attributes
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 11);
        PyObject *lr_ratio_obj = PyTuple_GET_ITEM(args, 12);
        PyObject *coeff_obj = PyTuple_GET_ITEM(args, 13);
        PyObject *with_decay_obj = PyTuple_GET_ITEM(args, 14);
        PyObject *lazy_mode_obj = PyTuple_GET_ITEM(args, 15);
        PyObject *min_row_size_to_use_multithread_obj = PyTuple_GET_ITEM(args, 16);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 17);
        PyObject *use_global_beta_pow_obj = PyTuple_GET_ITEM(args, 18);

        // Check for mutable attrs
       pir::Value beta1;

       pir::Value beta2;

       pir::Value epsilon;

        if (PyObject_CheckIROpResult(beta1_obj)){
             beta1 = CastPyArg2Value(beta1_obj, "adamw_", 9);
        }else{
            float beta1_tmp = CastPyArg2Float(beta1_obj, "adamw_", 9);
            beta1 = paddle::dialect::full(std::vector<int64_t>{1}, beta1_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(beta2_obj)){
             beta2 = CastPyArg2Value(beta2_obj, "adamw_", 10);
        }else{
            float beta2_tmp = CastPyArg2Float(beta2_obj, "adamw_", 10);
            beta2 = paddle::dialect::full(std::vector<int64_t>{1}, beta2_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(epsilon_obj)){
             epsilon = CastPyArg2Value(epsilon_obj, "adamw_", 11);
        }else{
            float epsilon_tmp = CastPyArg2Float(epsilon_obj, "adamw_", 11);
            epsilon = paddle::dialect::full(std::vector<int64_t>{1}, epsilon_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            float lr_ratio = CastPyArg2Float(lr_ratio_obj, "adamw_", 12);
            float coeff = CastPyArg2Float(coeff_obj, "adamw_", 13);
            bool with_decay = CastPyArg2Boolean(with_decay_obj, "adamw_", 14);
            bool lazy_mode = CastPyArg2Boolean(lazy_mode_obj, "adamw_", 15);
            int64_t min_row_size_to_use_multithread = CastPyArg2Long(min_row_size_to_use_multithread_obj, "adamw_", 16);
            bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "adamw_", 17);
            bool use_global_beta_pow = CastPyArg2Boolean(use_global_beta_pow_obj, "adamw_", 18);

        // Call ir static api
        auto static_api_out = paddle::dialect::adamw_(param, grad, learning_rate, moment1, moment2, beta1_pow, beta2_pow, master_param, skip_update, beta1, beta2, epsilon, lr_ratio, coeff, with_decay, lazy_mode, min_row_size_to_use_multithread, multi_precision, use_global_beta_pow);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_addmm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add addmm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "addmm", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "addmm", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "addmm", 2);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 3);
        float beta = CastPyArg2Float(beta_obj, "addmm", 3);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 4);
        float alpha = CastPyArg2Float(alpha_obj, "addmm", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::addmm(input, x, y, beta, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_addmm_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add addmm_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "addmm_", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "addmm_", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "addmm_", 2);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 3);
        float beta = CastPyArg2Float(beta_obj, "addmm_", 3);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 4);
        float alpha = CastPyArg2Float(alpha_obj, "addmm_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::addmm_(input, x, y, beta, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_affine_grid(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add affine_grid op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "affine_grid", 0);

        // Parse Attributes
        PyObject *output_shape_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value output_shape;

        if (PyObject_CheckIROpResult(output_shape_obj)){
             output_shape = CastPyArg2Value(output_shape_obj, "affine_grid", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(output_shape_obj)){
            std::vector<pir::Value> output_shape_tmp = CastPyArg2VectorOfValue(output_shape_obj, "affine_grid", 1);
            output_shape = paddle::dialect::stack(output_shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_shape_tmp = CastPyArg2Longs(output_shape_obj, "affine_grid", 1);
            output_shape = paddle::dialect::full_int_array(output_shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool align_corners = CastPyArg2Boolean(align_corners_obj, "affine_grid", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::affine_grid(input, output_shape, align_corners);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_allclose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add allclose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "allclose", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "allclose", 1);

        // Parse Attributes
        PyObject *rtol_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *atol_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *equal_nan_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value rtol;

       pir::Value atol;

        if (PyObject_CheckIROpResult(rtol_obj)){
             rtol = CastPyArg2Value(rtol_obj, "allclose", 2);
        }else{
            float rtol_tmp = CastPyArg2Float(rtol_obj, "allclose", 2);
            rtol = paddle::dialect::full(std::vector<int64_t>{1}, rtol_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(atol_obj)){
             atol = CastPyArg2Value(atol_obj, "allclose", 3);
        }else{
            float atol_tmp = CastPyArg2Float(atol_obj, "allclose", 3);
            atol = paddle::dialect::full(std::vector<int64_t>{1}, atol_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            bool equal_nan = CastPyArg2Boolean(equal_nan_obj, "allclose", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::allclose(x, y, rtol, atol, equal_nan);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_angle(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add angle op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "angle", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::angle(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_argmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add argmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "argmax", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keepdims_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "argmax", 1);
        }else{
            int64_t axis_tmp = CastPyArg2Long(axis_obj, "argmax", 1);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdims = CastPyArg2Boolean(keepdims_obj, "argmax", 2);
            bool flatten = CastPyArg2Boolean(flatten_obj, "argmax", 3);
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "argmax", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::argmax(x, axis, keepdims, flatten, dtype);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_argmin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add argmin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "argmin", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keepdims_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "argmin", 1);
        }else{
            int64_t axis_tmp = CastPyArg2Long(axis_obj, "argmin", 1);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdims = CastPyArg2Boolean(keepdims_obj, "argmin", 2);
            bool flatten = CastPyArg2Boolean(flatten_obj, "argmin", 3);
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "argmin", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::argmin(x, axis, keepdims, flatten, dtype);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_argsort(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add argsort op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "argsort", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "argsort", 1);
        PyObject *descending_obj = PyTuple_GET_ITEM(args, 2);
        bool descending = CastPyArg2Boolean(descending_obj, "argsort", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::argsort(x, axis, descending);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_as_complex(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add as_complex op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "as_complex", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::as_complex(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_as_real(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add as_real op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "as_real", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::as_real(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_as_strided(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add as_strided op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "as_strided", 0);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> dims = CastPyArg2Longs(dims_obj, "as_strided", 1);
        PyObject *stride_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int64_t> stride = CastPyArg2Longs(stride_obj, "as_strided", 2);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 3);
        int64_t offset = CastPyArg2Long(offset_obj, "as_strided", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::as_strided(input, dims, stride, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asin", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asin(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asin_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asin_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asin_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asin_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asinh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asinh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asinh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asinh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asinh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asinh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asinh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asinh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan2(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan2 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan2", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "atan2", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan2(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atanh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atanh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atanh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atanh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atanh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atanh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atanh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atanh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_auc(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add auc op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "auc", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "auc", 1);
        PyObject *stat_pos_obj = PyTuple_GET_ITEM(args, 2);
        auto stat_pos = CastPyArg2Value(stat_pos_obj, "auc", 2);
        PyObject *stat_neg_obj = PyTuple_GET_ITEM(args, 3);
        auto stat_neg = CastPyArg2Value(stat_neg_obj, "auc", 3);
        PyObject *ins_tag_weight_obj = PyTuple_GET_ITEM(args, 4);
        auto ins_tag_weight = CastPyArg2OptionalValue(ins_tag_weight_obj, "auc", 4);

        // Parse Attributes
        PyObject *curve_obj = PyTuple_GET_ITEM(args, 5);
        std::string curve = CastPyArg2String(curve_obj, "auc", 5);
        PyObject *num_thresholds_obj = PyTuple_GET_ITEM(args, 6);
        int num_thresholds = CastPyArg2Int(num_thresholds_obj, "auc", 6);
        PyObject *slide_steps_obj = PyTuple_GET_ITEM(args, 7);
        int slide_steps = CastPyArg2Int(slide_steps_obj, "auc", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::auc(x, label, stat_pos, stat_neg, ins_tag_weight, curve, num_thresholds, slide_steps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_average_accumulates_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add average_accumulates_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "average_accumulates_", 0);
        PyObject *in_sum_1_obj = PyTuple_GET_ITEM(args, 1);
        auto in_sum_1 = CastPyArg2Value(in_sum_1_obj, "average_accumulates_", 1);
        PyObject *in_sum_2_obj = PyTuple_GET_ITEM(args, 2);
        auto in_sum_2 = CastPyArg2Value(in_sum_2_obj, "average_accumulates_", 2);
        PyObject *in_sum_3_obj = PyTuple_GET_ITEM(args, 3);
        auto in_sum_3 = CastPyArg2Value(in_sum_3_obj, "average_accumulates_", 3);
        PyObject *in_num_accumulates_obj = PyTuple_GET_ITEM(args, 4);
        auto in_num_accumulates = CastPyArg2Value(in_num_accumulates_obj, "average_accumulates_", 4);
        PyObject *in_old_num_accumulates_obj = PyTuple_GET_ITEM(args, 5);
        auto in_old_num_accumulates = CastPyArg2Value(in_old_num_accumulates_obj, "average_accumulates_", 5);
        PyObject *in_num_updates_obj = PyTuple_GET_ITEM(args, 6);
        auto in_num_updates = CastPyArg2Value(in_num_updates_obj, "average_accumulates_", 6);

        // Parse Attributes
        PyObject *average_window_obj = PyTuple_GET_ITEM(args, 7);
        float average_window = CastPyArg2Float(average_window_obj, "average_accumulates_", 7);
        PyObject *max_average_window_obj = PyTuple_GET_ITEM(args, 8);
        int64_t max_average_window = CastPyArg2Long(max_average_window_obj, "average_accumulates_", 8);
        PyObject *min_average_window_obj = PyTuple_GET_ITEM(args, 9);
        int64_t min_average_window = CastPyArg2Long(min_average_window_obj, "average_accumulates_", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::average_accumulates_(param, in_sum_1, in_sum_2, in_sum_3, in_num_accumulates, in_old_num_accumulates, in_num_updates, average_window, max_average_window, min_average_window);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bce_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bce_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "bce_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "bce_loss", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bce_loss(input, label);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bce_loss_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bce_loss_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "bce_loss_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "bce_loss_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bce_loss_(input, label);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bernoulli(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bernoulli op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bernoulli", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bernoulli(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bicubic_interp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bicubic_interp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bicubic_interp", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "bicubic_interp", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "bicubic_interp", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "bicubic_interp", 3);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 4);
        std::string data_layout = CastPyArg2String(data_layout_obj, "bicubic_interp", 4);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 5);
        int out_d = CastPyArg2Int(out_d_obj, "bicubic_interp", 5);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 6);
        int out_h = CastPyArg2Int(out_h_obj, "bicubic_interp", 6);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 7);
        int out_w = CastPyArg2Int(out_w_obj, "bicubic_interp", 7);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "bicubic_interp", 8);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 9);
        std::string interp_method = CastPyArg2String(interp_method_obj, "bicubic_interp", 9);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 10);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "bicubic_interp", 10);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 11);
        int align_mode = CastPyArg2Int(align_mode_obj, "bicubic_interp", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::bicubic_interp(x, out_size, size_tensor, scale_tensor, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bilinear(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bilinear op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bilinear", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bilinear", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2Value(weight_obj, "bilinear", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2OptionalValue(bias_obj, "bilinear", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bilinear(x, y, weight, bias);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bilinear_interp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bilinear_interp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bilinear_interp", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "bilinear_interp", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "bilinear_interp", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "bilinear_interp", 3);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 4);
        std::string data_layout = CastPyArg2String(data_layout_obj, "bilinear_interp", 4);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 5);
        int out_d = CastPyArg2Int(out_d_obj, "bilinear_interp", 5);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 6);
        int out_h = CastPyArg2Int(out_h_obj, "bilinear_interp", 6);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 7);
        int out_w = CastPyArg2Int(out_w_obj, "bilinear_interp", 7);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "bilinear_interp", 8);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 9);
        std::string interp_method = CastPyArg2String(interp_method_obj, "bilinear_interp", 9);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 10);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "bilinear_interp", 10);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 11);
        int align_mode = CastPyArg2Int(align_mode_obj, "bilinear_interp", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::bilinear_interp(x, out_size, size_tensor, scale_tensor, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bincount(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bincount op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bincount", 0);
        PyObject *weights_obj = PyTuple_GET_ITEM(args, 1);
        auto weights = CastPyArg2OptionalValue(weights_obj, "bincount", 1);

        // Parse Attributes
        PyObject *minlength_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value minlength;

        if (PyObject_CheckIROpResult(minlength_obj)){
             minlength = CastPyArg2Value(minlength_obj, "bincount", 2);
        }else{
            int minlength_tmp = CastPyArg2Int(minlength_obj, "bincount", 2);
            minlength = paddle::dialect::full(std::vector<int64_t>{1}, minlength_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::bincount(x, weights, minlength);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_and(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_and op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_and", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_and", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_and(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_and_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_and_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_and_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_and_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_and_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_not(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_not op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_not", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_not(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_not_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_not_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_not_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_not_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_or(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_or op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_or", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_or", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_or(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_or_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_or_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_or_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_or_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_or_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_xor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_xor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_xor", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_xor", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_xor(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bitwise_xor_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bitwise_xor_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bitwise_xor_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bitwise_xor_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bitwise_xor_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bmm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bmm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bmm", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bmm", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bmm(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_box_coder(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add box_coder op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *prior_box_obj = PyTuple_GET_ITEM(args, 0);
        auto prior_box = CastPyArg2Value(prior_box_obj, "box_coder", 0);
        PyObject *prior_box_var_obj = PyTuple_GET_ITEM(args, 1);
        auto prior_box_var = CastPyArg2OptionalValue(prior_box_var_obj, "box_coder", 1);
        PyObject *target_box_obj = PyTuple_GET_ITEM(args, 2);
        auto target_box = CastPyArg2Value(target_box_obj, "box_coder", 2);

        // Parse Attributes
        PyObject *code_type_obj = PyTuple_GET_ITEM(args, 3);
        std::string code_type = CastPyArg2String(code_type_obj, "box_coder", 3);
        PyObject *box_normalized_obj = PyTuple_GET_ITEM(args, 4);
        bool box_normalized = CastPyArg2Boolean(box_normalized_obj, "box_coder", 4);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 5);
        int axis = CastPyArg2Int(axis_obj, "box_coder", 5);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<float> variance = CastPyArg2Floats(variance_obj, "box_coder", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::box_coder(prior_box, prior_box_var, target_box, code_type, box_normalized, axis, variance);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_broadcast_tensors(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add broadcast_tensors op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2VectorOfValue(input_obj, "broadcast_tensors", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::broadcast_tensors(input);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_ceil(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add ceil op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "ceil", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::ceil(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_ceil_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add ceil_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "ceil_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::ceil_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_celu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add celu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "celu", 0);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 1);
        float alpha = CastPyArg2Float(alpha_obj, "celu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::celu(x, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_check_finite_and_unscale_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add check_finite_and_unscale_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "check_finite_and_unscale_", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "check_finite_and_unscale_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::check_finite_and_unscale_(x, scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_check_numerics(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add check_numerics op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *tensor_obj = PyTuple_GET_ITEM(args, 0);
        auto tensor = CastPyArg2Value(tensor_obj, "check_numerics", 0);

        // Parse Attributes
        PyObject *op_type_obj = PyTuple_GET_ITEM(args, 1);
        std::string op_type = CastPyArg2String(op_type_obj, "check_numerics", 1);
        PyObject *var_name_obj = PyTuple_GET_ITEM(args, 2);
        std::string var_name = CastPyArg2String(var_name_obj, "check_numerics", 2);
        PyObject *check_nan_inf_level_obj = PyTuple_GET_ITEM(args, 3);
        int check_nan_inf_level = CastPyArg2Int(check_nan_inf_level_obj, "check_numerics", 3);
        PyObject *stack_height_limit_obj = PyTuple_GET_ITEM(args, 4);
        int stack_height_limit = CastPyArg2Int(stack_height_limit_obj, "check_numerics", 4);
        PyObject *output_dir_obj = PyTuple_GET_ITEM(args, 5);
        std::string output_dir = CastPyArg2String(output_dir_obj, "check_numerics", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::check_numerics(tensor, op_type, var_name, check_nan_inf_level, stack_height_limit, output_dir);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cholesky(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cholesky op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cholesky", 0);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 1);
        bool upper = CastPyArg2Boolean(upper_obj, "cholesky", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::cholesky(x, upper);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cholesky_solve(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cholesky_solve op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cholesky_solve", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "cholesky_solve", 1);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 2);
        bool upper = CastPyArg2Boolean(upper_obj, "cholesky_solve", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::cholesky_solve(x, y, upper);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_class_center_sample(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add class_center_sample op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *label_obj = PyTuple_GET_ITEM(args, 0);
        auto label = CastPyArg2Value(label_obj, "class_center_sample", 0);

        // Parse Attributes
        PyObject *num_classes_obj = PyTuple_GET_ITEM(args, 1);
        int num_classes = CastPyArg2Int(num_classes_obj, "class_center_sample", 1);
        PyObject *num_samples_obj = PyTuple_GET_ITEM(args, 2);
        int num_samples = CastPyArg2Int(num_samples_obj, "class_center_sample", 2);
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 3);
        int ring_id = CastPyArg2Int(ring_id_obj, "class_center_sample", 3);
        PyObject *rank_obj = PyTuple_GET_ITEM(args, 4);
        int rank = CastPyArg2Int(rank_obj, "class_center_sample", 4);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 5);
        int nranks = CastPyArg2Int(nranks_obj, "class_center_sample", 5);
        PyObject *fix_seed_obj = PyTuple_GET_ITEM(args, 6);
        bool fix_seed = CastPyArg2Boolean(fix_seed_obj, "class_center_sample", 6);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 7);
        int seed = CastPyArg2Int(seed_obj, "class_center_sample", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::class_center_sample(label, num_classes, num_samples, ring_id, rank, nranks, fix_seed, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "clip", 1);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "clip", 1);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "clip", 2);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "clip", 2);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::clip(x, min, max);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip_", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "clip_", 1);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "clip_", 1);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "clip_", 2);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "clip_", 2);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::clip_(x, min, max);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip_by_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip_by_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip_by_norm", 0);

        // Parse Attributes
        PyObject *max_norm_obj = PyTuple_GET_ITEM(args, 1);
        float max_norm = CastPyArg2Float(max_norm_obj, "clip_by_norm", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::clip_by_norm(x, max_norm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_coalesce_tensor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add coalesce_tensor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2VectorOfValue(input_obj, "coalesce_tensor", 0);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "coalesce_tensor", 1);
        PyObject *copy_data_obj = PyTuple_GET_ITEM(args, 2);
        bool copy_data = CastPyArg2Boolean(copy_data_obj, "coalesce_tensor", 2);
        PyObject *set_constant_obj = PyTuple_GET_ITEM(args, 3);
        bool set_constant = CastPyArg2Boolean(set_constant_obj, "coalesce_tensor", 3);
        PyObject *persist_output_obj = PyTuple_GET_ITEM(args, 4);
        bool persist_output = CastPyArg2Boolean(persist_output_obj, "coalesce_tensor", 4);
        PyObject *constant_obj = PyTuple_GET_ITEM(args, 5);
        float constant = CastPyArg2Float(constant_obj, "coalesce_tensor", 5);
        PyObject *use_align_obj = PyTuple_GET_ITEM(args, 6);
        bool use_align = CastPyArg2Boolean(use_align_obj, "coalesce_tensor", 6);
        PyObject *align_size_obj = PyTuple_GET_ITEM(args, 7);
        int align_size = CastPyArg2Int(align_size_obj, "coalesce_tensor", 7);
        PyObject *size_of_dtype_obj = PyTuple_GET_ITEM(args, 8);
        int size_of_dtype = CastPyArg2Int(size_of_dtype_obj, "coalesce_tensor", 8);
        PyObject *concated_shapes_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<int64_t> concated_shapes = CastPyArg2Longs(concated_shapes_obj, "coalesce_tensor", 9);
        PyObject *concated_ranks_obj = PyTuple_GET_ITEM(args, 10);
        std::vector<int64_t> concated_ranks = CastPyArg2Longs(concated_ranks_obj, "coalesce_tensor", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::coalesce_tensor(input, dtype, copy_data, set_constant, persist_output, constant, use_align, align_size, size_of_dtype, concated_shapes, concated_ranks);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_complex(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add complex op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *real_obj = PyTuple_GET_ITEM(args, 0);
        auto real = CastPyArg2Value(real_obj, "complex", 0);
        PyObject *imag_obj = PyTuple_GET_ITEM(args, 1);
        auto imag = CastPyArg2Value(imag_obj, "complex", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::complex(real, imag);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_concat(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add concat op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "concat", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "concat", 1);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "concat", 1);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::concat(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conj(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conj op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conj", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::conj(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv2d", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d", 3);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 4);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d", 4);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d", 5);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 6);
        int groups = CastPyArg2Int(groups_obj, "conv2d", 6);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 7);
        std::string data_format = CastPyArg2String(data_format_obj, "conv2d", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d(input, filter, strides, paddings, padding_algorithm, dilations, groups, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv3d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv3d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv3d", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv3d", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv3d", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv3d", 3);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 4);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv3d", 4);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 5);
        int groups = CastPyArg2Int(groups_obj, "conv3d", 5);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv3d", 6);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 7);
        std::string data_format = CastPyArg2String(data_format_obj, "conv3d", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv3d(input, filter, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv3d_transpose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv3d_transpose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conv3d_transpose", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv3d_transpose", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv3d_transpose", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv3d_transpose", 3);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "conv3d_transpose", 4);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> output_size = CastPyArg2Ints(output_size_obj, "conv3d_transpose", 5);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 6);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv3d_transpose", 6);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 7);
        int groups = CastPyArg2Int(groups_obj, "conv3d_transpose", 7);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv3d_transpose", 8);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 9);
        std::string data_format = CastPyArg2String(data_format_obj, "conv3d_transpose", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv3d_transpose(x, filter, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cosh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cosh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cosh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cosh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cosh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cosh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cosh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cosh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_crop(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add crop op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "crop", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *offsets_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value shape;

       pir::Value offsets;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "crop", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "crop", 1);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "crop", 1);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(offsets_obj)){
             offsets = CastPyArg2Value(offsets_obj, "crop", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(offsets_obj)){
            std::vector<pir::Value> offsets_tmp = CastPyArg2VectorOfValue(offsets_obj, "crop", 2);
            offsets = paddle::dialect::stack(offsets_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> offsets_tmp = CastPyArg2Longs(offsets_obj, "crop", 2);
            offsets = paddle::dialect::full_int_array(offsets_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::crop(x, shape, offsets);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cross", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "cross", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "cross", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross(x, y, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross_entropy_with_softmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross_entropy_with_softmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "cross_entropy_with_softmax", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "cross_entropy_with_softmax", 1);

        // Parse Attributes
        PyObject *soft_label_obj = PyTuple_GET_ITEM(args, 2);
        bool soft_label = CastPyArg2Boolean(soft_label_obj, "cross_entropy_with_softmax", 2);
        PyObject *use_softmax_obj = PyTuple_GET_ITEM(args, 3);
        bool use_softmax = CastPyArg2Boolean(use_softmax_obj, "cross_entropy_with_softmax", 3);
        PyObject *numeric_stable_mode_obj = PyTuple_GET_ITEM(args, 4);
        bool numeric_stable_mode = CastPyArg2Boolean(numeric_stable_mode_obj, "cross_entropy_with_softmax", 4);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 5);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "cross_entropy_with_softmax", 5);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 6);
        int axis = CastPyArg2Int(axis_obj, "cross_entropy_with_softmax", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross_entropy_with_softmax(input, label, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross_entropy_with_softmax_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross_entropy_with_softmax_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "cross_entropy_with_softmax_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "cross_entropy_with_softmax_", 1);

        // Parse Attributes
        PyObject *soft_label_obj = PyTuple_GET_ITEM(args, 2);
        bool soft_label = CastPyArg2Boolean(soft_label_obj, "cross_entropy_with_softmax_", 2);
        PyObject *use_softmax_obj = PyTuple_GET_ITEM(args, 3);
        bool use_softmax = CastPyArg2Boolean(use_softmax_obj, "cross_entropy_with_softmax_", 3);
        PyObject *numeric_stable_mode_obj = PyTuple_GET_ITEM(args, 4);
        bool numeric_stable_mode = CastPyArg2Boolean(numeric_stable_mode_obj, "cross_entropy_with_softmax_", 4);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 5);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "cross_entropy_with_softmax_", 5);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 6);
        int axis = CastPyArg2Int(axis_obj, "cross_entropy_with_softmax_", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross_entropy_with_softmax_(input, label, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cummax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cummax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cummax", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "cummax", 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cummax", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::cummax(x, axis, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cummin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cummin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cummin", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "cummin", 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cummin", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::cummin(x, axis, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumprod(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumprod op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumprod", 0);

        // Parse Attributes
        PyObject *dim_obj = PyTuple_GET_ITEM(args, 1);
        int dim = CastPyArg2Int(dim_obj, "cumprod", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumprod(x, dim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumprod_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumprod_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumprod_", 0);

        // Parse Attributes
        PyObject *dim_obj = PyTuple_GET_ITEM(args, 1);
        int dim = CastPyArg2Int(dim_obj, "cumprod_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumprod_(x, dim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumsum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumsum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumsum", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *reverse_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "cumsum", 1);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "cumsum", 1);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            bool flatten = CastPyArg2Boolean(flatten_obj, "cumsum", 2);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "cumsum", 3);
            bool reverse = CastPyArg2Boolean(reverse_obj, "cumsum", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumsum(x, axis, flatten, exclusive, reverse);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumsum_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumsum_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumsum_", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *reverse_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "cumsum_", 1);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "cumsum_", 1);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            bool flatten = CastPyArg2Boolean(flatten_obj, "cumsum_", 2);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "cumsum_", 3);
            bool reverse = CastPyArg2Boolean(reverse_obj, "cumsum_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumsum_(x, axis, flatten, exclusive, reverse);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_data(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add data op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *name_obj = PyTuple_GET_ITEM(args, 0);
        std::string name = CastPyArg2String(name_obj, "data", 0);
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> shape = CastPyArg2Longs(shape_obj, "data", 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "data", 2);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 3);
        Place place = CastPyArg2Place(place_obj, "data", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::data(name, shape, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_depthwise_conv2d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add depthwise_conv2d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "depthwise_conv2d", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "depthwise_conv2d", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "depthwise_conv2d", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "depthwise_conv2d", 3);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 4);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "depthwise_conv2d", 4);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 5);
        int groups = CastPyArg2Int(groups_obj, "depthwise_conv2d", 5);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "depthwise_conv2d", 6);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 7);
        std::string data_format = CastPyArg2String(data_format_obj, "depthwise_conv2d", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::depthwise_conv2d(input, filter, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_det(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add det op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "det", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::det(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_diag(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add diag op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "diag", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int offset = CastPyArg2Int(offset_obj, "diag", 1);
        PyObject *padding_value_obj = PyTuple_GET_ITEM(args, 2);
        float padding_value = CastPyArg2Float(padding_value_obj, "diag", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::diag(x, offset, padding_value);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_diag_embed(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add diag_embed op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "diag_embed", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int offset = CastPyArg2Int(offset_obj, "diag_embed", 1);
        PyObject *dim1_obj = PyTuple_GET_ITEM(args, 2);
        int dim1 = CastPyArg2Int(dim1_obj, "diag_embed", 2);
        PyObject *dim2_obj = PyTuple_GET_ITEM(args, 3);
        int dim2 = CastPyArg2Int(dim2_obj, "diag_embed", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::diag_embed(input, offset, dim1, dim2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_diagonal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add diagonal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "diagonal", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int offset = CastPyArg2Int(offset_obj, "diagonal", 1);
        PyObject *axis1_obj = PyTuple_GET_ITEM(args, 2);
        int axis1 = CastPyArg2Int(axis1_obj, "diagonal", 2);
        PyObject *axis2_obj = PyTuple_GET_ITEM(args, 3);
        int axis2 = CastPyArg2Int(axis2_obj, "diagonal", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::diagonal(x, offset, axis1, axis2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_digamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add digamma op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "digamma", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::digamma(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_digamma_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add digamma_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "digamma_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::digamma_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dirichlet(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dirichlet op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 0);
        auto alpha = CastPyArg2Value(alpha_obj, "dirichlet", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::dirichlet(alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dist(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dist op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "dist", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "dist", 1);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 2);
        float p = CastPyArg2Float(p_obj, "dist", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::dist(x, y, p);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dot(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dot op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "dot", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "dot", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::dot(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_edit_distance(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add edit_distance op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *hyps_obj = PyTuple_GET_ITEM(args, 0);
        auto hyps = CastPyArg2Value(hyps_obj, "edit_distance", 0);
        PyObject *refs_obj = PyTuple_GET_ITEM(args, 1);
        auto refs = CastPyArg2Value(refs_obj, "edit_distance", 1);
        PyObject *hypslength_obj = PyTuple_GET_ITEM(args, 2);
        auto hypslength = CastPyArg2OptionalValue(hypslength_obj, "edit_distance", 2);
        PyObject *refslength_obj = PyTuple_GET_ITEM(args, 3);
        auto refslength = CastPyArg2OptionalValue(refslength_obj, "edit_distance", 3);

        // Parse Attributes
        PyObject *normalized_obj = PyTuple_GET_ITEM(args, 4);
        bool normalized = CastPyArg2Boolean(normalized_obj, "edit_distance", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::edit_distance(hyps, refs, hypslength, refslength, normalized);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eig(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eig op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "eig", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::eig(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eigh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eigh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "eigh", 0);

        // Parse Attributes
        PyObject *UPLO_obj = PyTuple_GET_ITEM(args, 1);
        std::string UPLO = CastPyArg2String(UPLO_obj, "eigh", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::eigh(x, UPLO);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eigvals(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eigvals op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "eigvals", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::eigvals(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eigvalsh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eigvalsh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "eigvalsh", 0);

        // Parse Attributes
        PyObject *uplo_obj = PyTuple_GET_ITEM(args, 1);
        std::string uplo = CastPyArg2String(uplo_obj, "eigvalsh", 1);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 2);
        bool is_test = CastPyArg2Boolean(is_test_obj, "eigvalsh", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::eigvalsh(x, uplo, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu", 0);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 1);
        float alpha = CastPyArg2Float(alpha_obj, "elu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu(x, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu_", 0);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 1);
        float alpha = CastPyArg2Float(alpha_obj, "elu_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu_(x, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_equal_all(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add equal_all op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "equal_all", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "equal_all", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::equal_all(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erf(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erf op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "erf", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erf(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erf_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erf_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "erf_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erf_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erfinv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erfinv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "erfinv", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erfinv(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erfinv_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erfinv_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "erfinv_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erfinv_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_exp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add exp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "exp", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::exp(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_exp_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add exp_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "exp_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::exp_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expand(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expand op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expand", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "expand", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "expand", 1);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "expand", 1);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::expand(x, shape);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expand_as(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expand_as op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expand_as", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2OptionalValue(y_obj, "expand_as", 1);

        // Parse Attributes
        PyObject *target_shape_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> target_shape = CastPyArg2Ints(target_shape_obj, "expand_as", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::expand_as(x, y, target_shape);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expm1(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expm1 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expm1", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::expm1(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expm1_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expm1_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expm1_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::expm1_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_c2c(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_c2c op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fft_c2c", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_c2c", 1);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 2);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_c2c", 2);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 3);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_c2c", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_c2c(x, axes, normalization, forward);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_c2r(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_c2r op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fft_c2r", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_c2r", 1);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 2);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_c2r", 2);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 3);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_c2r", 3);
        PyObject *last_dim_size_obj = PyTuple_GET_ITEM(args, 4);
        int64_t last_dim_size = CastPyArg2Long(last_dim_size_obj, "fft_c2r", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_c2r(x, axes, normalization, forward, last_dim_size);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_r2c(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_r2c op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fft_r2c", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_r2c", 1);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 2);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_r2c", 2);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 3);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_r2c", 3);
        PyObject *onesided_obj = PyTuple_GET_ITEM(args, 4);
        bool onesided = CastPyArg2Boolean(onesided_obj, "fft_r2c", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_r2c(x, axes, normalization, forward, onesided);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value value;

        if (PyObject_CheckIROpResult(value_obj)){
             value = CastPyArg2Value(value_obj, "fill", 1);
        }else{
            float value_tmp = CastPyArg2Float(value_obj, "fill", 1);
            value = paddle::dialect::full(std::vector<int64_t>{1}, value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::fill(x, value);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill_", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value value;

        if (PyObject_CheckIROpResult(value_obj)){
             value = CastPyArg2Value(value_obj, "fill_", 1);
        }else{
            float value_tmp = CastPyArg2Float(value_obj, "fill_", 1);
            value = paddle::dialect::full(std::vector<int64_t>{1}, value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_(x, value);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill_diagonal", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        float value = CastPyArg2Float(value_obj, "fill_diagonal", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "fill_diagonal", 2);
        PyObject *wrap_obj = PyTuple_GET_ITEM(args, 3);
        bool wrap = CastPyArg2Boolean(wrap_obj, "fill_diagonal", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal(x, value, offset, wrap);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill_diagonal_", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        float value = CastPyArg2Float(value_obj, "fill_diagonal_", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "fill_diagonal_", 2);
        PyObject *wrap_obj = PyTuple_GET_ITEM(args, 3);
        bool wrap = CastPyArg2Boolean(wrap_obj, "fill_diagonal_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_(x, value, offset, wrap);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_tensor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_tensor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill_diagonal_tensor", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fill_diagonal_tensor", 1);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int64_t offset = CastPyArg2Long(offset_obj, "fill_diagonal_tensor", 2);
        PyObject *dim1_obj = PyTuple_GET_ITEM(args, 3);
        int dim1 = CastPyArg2Int(dim1_obj, "fill_diagonal_tensor", 3);
        PyObject *dim2_obj = PyTuple_GET_ITEM(args, 4);
        int dim2 = CastPyArg2Int(dim2_obj, "fill_diagonal_tensor", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_tensor(x, y, offset, dim1, dim2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_tensor_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_tensor_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fill_diagonal_tensor_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fill_diagonal_tensor_", 1);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int64_t offset = CastPyArg2Long(offset_obj, "fill_diagonal_tensor_", 2);
        PyObject *dim1_obj = PyTuple_GET_ITEM(args, 3);
        int dim1 = CastPyArg2Int(dim1_obj, "fill_diagonal_tensor_", 3);
        PyObject *dim2_obj = PyTuple_GET_ITEM(args, 4);
        int dim2 = CastPyArg2Int(dim2_obj, "fill_diagonal_tensor_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_tensor_(x, y, offset, dim1, dim2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flash_attn(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flash_attn op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *q_obj = PyTuple_GET_ITEM(args, 0);
        auto q = CastPyArg2Value(q_obj, "flash_attn", 0);
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        auto k = CastPyArg2Value(k_obj, "flash_attn", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "flash_attn", 2);
        PyObject *fixed_seed_offset_obj = PyTuple_GET_ITEM(args, 3);
        auto fixed_seed_offset = CastPyArg2OptionalValue(fixed_seed_offset_obj, "flash_attn", 3);
        PyObject *attn_mask_obj = PyTuple_GET_ITEM(args, 4);
        auto attn_mask = CastPyArg2OptionalValue(attn_mask_obj, "flash_attn", 4);

        // Parse Attributes
        PyObject *dropout_obj = PyTuple_GET_ITEM(args, 5);
        float dropout = CastPyArg2Float(dropout_obj, "flash_attn", 5);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 6);
        bool causal = CastPyArg2Boolean(causal_obj, "flash_attn", 6);
        PyObject *return_softmax_obj = PyTuple_GET_ITEM(args, 7);
        bool return_softmax = CastPyArg2Boolean(return_softmax_obj, "flash_attn", 7);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 8);
        bool is_test = CastPyArg2Boolean(is_test_obj, "flash_attn", 8);
        PyObject *rng_name_obj = PyTuple_GET_ITEM(args, 9);
        std::string rng_name = CastPyArg2String(rng_name_obj, "flash_attn", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::flash_attn(q, k, v, fixed_seed_offset, attn_mask, dropout, causal, return_softmax, is_test, rng_name);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flash_attn_unpadded(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flash_attn_unpadded op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *q_obj = PyTuple_GET_ITEM(args, 0);
        auto q = CastPyArg2Value(q_obj, "flash_attn_unpadded", 0);
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        auto k = CastPyArg2Value(k_obj, "flash_attn_unpadded", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "flash_attn_unpadded", 2);
        PyObject *cu_seqlens_q_obj = PyTuple_GET_ITEM(args, 3);
        auto cu_seqlens_q = CastPyArg2Value(cu_seqlens_q_obj, "flash_attn_unpadded", 3);
        PyObject *cu_seqlens_k_obj = PyTuple_GET_ITEM(args, 4);
        auto cu_seqlens_k = CastPyArg2Value(cu_seqlens_k_obj, "flash_attn_unpadded", 4);
        PyObject *fixed_seed_offset_obj = PyTuple_GET_ITEM(args, 5);
        auto fixed_seed_offset = CastPyArg2OptionalValue(fixed_seed_offset_obj, "flash_attn_unpadded", 5);
        PyObject *attn_mask_obj = PyTuple_GET_ITEM(args, 6);
        auto attn_mask = CastPyArg2OptionalValue(attn_mask_obj, "flash_attn_unpadded", 6);

        // Parse Attributes
        PyObject *max_seqlen_q_obj = PyTuple_GET_ITEM(args, 7);
        int64_t max_seqlen_q = CastPyArg2Long(max_seqlen_q_obj, "flash_attn_unpadded", 7);
        PyObject *max_seqlen_k_obj = PyTuple_GET_ITEM(args, 8);
        int64_t max_seqlen_k = CastPyArg2Long(max_seqlen_k_obj, "flash_attn_unpadded", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        float scale = CastPyArg2Float(scale_obj, "flash_attn_unpadded", 9);
        PyObject *dropout_obj = PyTuple_GET_ITEM(args, 10);
        float dropout = CastPyArg2Float(dropout_obj, "flash_attn_unpadded", 10);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 11);
        bool causal = CastPyArg2Boolean(causal_obj, "flash_attn_unpadded", 11);
        PyObject *return_softmax_obj = PyTuple_GET_ITEM(args, 12);
        bool return_softmax = CastPyArg2Boolean(return_softmax_obj, "flash_attn_unpadded", 12);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 13);
        bool is_test = CastPyArg2Boolean(is_test_obj, "flash_attn_unpadded", 13);
        PyObject *rng_name_obj = PyTuple_GET_ITEM(args, 14);
        std::string rng_name = CastPyArg2String(rng_name_obj, "flash_attn_unpadded", 14);

        // Call ir static api
        auto static_api_out = paddle::dialect::flash_attn_unpadded(q, k, v, cu_seqlens_q, cu_seqlens_k, fixed_seed_offset, attn_mask, max_seqlen_q, max_seqlen_k, scale, dropout, causal, return_softmax, is_test, rng_name);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flatten(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flatten op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "flatten", 0);

        // Parse Attributes
        PyObject *start_axis_obj = PyTuple_GET_ITEM(args, 1);
        int start_axis = CastPyArg2Int(start_axis_obj, "flatten", 1);
        PyObject *stop_axis_obj = PyTuple_GET_ITEM(args, 2);
        int stop_axis = CastPyArg2Int(stop_axis_obj, "flatten", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::flatten(x, start_axis, stop_axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flatten_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flatten_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "flatten_", 0);

        // Parse Attributes
        PyObject *start_axis_obj = PyTuple_GET_ITEM(args, 1);
        int start_axis = CastPyArg2Int(start_axis_obj, "flatten_", 1);
        PyObject *stop_axis_obj = PyTuple_GET_ITEM(args, 2);
        int stop_axis = CastPyArg2Int(stop_axis_obj, "flatten_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::flatten_(x, start_axis, stop_axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flip(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flip op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "flip", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> axis = CastPyArg2Ints(axis_obj, "flip", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::flip(x, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "floor", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "floor_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fmax", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fmax", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fmax(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fmin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fmin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fmin", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fmin", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fmin(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fold(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fold op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fold", 0);

        // Parse Attributes
        PyObject *output_sizes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> output_sizes = CastPyArg2Ints(output_sizes_obj, "fold", 1);
        PyObject *kernel_sizes_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> kernel_sizes = CastPyArg2Ints(kernel_sizes_obj, "fold", 2);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "fold", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "fold", 4);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "fold", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::fold(x, output_sizes, kernel_sizes, strides, paddings, dilations);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_frame(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add frame op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "frame", 0);

        // Parse Attributes
        PyObject *frame_length_obj = PyTuple_GET_ITEM(args, 1);
        int frame_length = CastPyArg2Int(frame_length_obj, "frame", 1);
        PyObject *hop_length_obj = PyTuple_GET_ITEM(args, 2);
        int hop_length = CastPyArg2Int(hop_length_obj, "frame", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "frame", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::frame(x, frame_length, hop_length, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_full_int_array(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add full_int_array op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 0);
        std::vector<int64_t> value = CastPyArg2Longs(value_obj, "full_int_array", 0);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "full_int_array", 1);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 2);
        Place place = CastPyArg2Place(place_obj, "full_int_array", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::full_int_array(value, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gather(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gather op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gather", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "gather", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "gather", 2);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "gather", 2);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::gather(x, index, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gather_nd(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gather_nd op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gather_nd", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "gather_nd", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::gather_nd(x, index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gather_tree(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gather_tree op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *ids_obj = PyTuple_GET_ITEM(args, 0);
        auto ids = CastPyArg2Value(ids_obj, "gather_tree", 0);
        PyObject *parents_obj = PyTuple_GET_ITEM(args, 1);
        auto parents = CastPyArg2Value(parents_obj, "gather_tree", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::gather_tree(ids, parents);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gaussian_inplace(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gaussian_inplace op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gaussian_inplace", 0);

        // Parse Attributes
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        float mean = CastPyArg2Float(mean_obj, "gaussian_inplace", 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        float std = CastPyArg2Float(std_obj, "gaussian_inplace", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "gaussian_inplace", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::gaussian_inplace(x, mean, std, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gaussian_inplace_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gaussian_inplace_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gaussian_inplace_", 0);

        // Parse Attributes
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        float mean = CastPyArg2Float(mean_obj, "gaussian_inplace_", 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        float std = CastPyArg2Float(std_obj, "gaussian_inplace_", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "gaussian_inplace_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::gaussian_inplace_(x, mean, std, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gelu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gelu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gelu", 0);

        // Parse Attributes
        PyObject *approximate_obj = PyTuple_GET_ITEM(args, 1);
        bool approximate = CastPyArg2Boolean(approximate_obj, "gelu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::gelu(x, approximate);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_generate_proposals(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add generate_proposals op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *scores_obj = PyTuple_GET_ITEM(args, 0);
        auto scores = CastPyArg2Value(scores_obj, "generate_proposals", 0);
        PyObject *bbox_deltas_obj = PyTuple_GET_ITEM(args, 1);
        auto bbox_deltas = CastPyArg2Value(bbox_deltas_obj, "generate_proposals", 1);
        PyObject *im_shape_obj = PyTuple_GET_ITEM(args, 2);
        auto im_shape = CastPyArg2Value(im_shape_obj, "generate_proposals", 2);
        PyObject *anchors_obj = PyTuple_GET_ITEM(args, 3);
        auto anchors = CastPyArg2Value(anchors_obj, "generate_proposals", 3);
        PyObject *variances_obj = PyTuple_GET_ITEM(args, 4);
        auto variances = CastPyArg2Value(variances_obj, "generate_proposals", 4);

        // Parse Attributes
        PyObject *pre_nms_top_n_obj = PyTuple_GET_ITEM(args, 5);
        int pre_nms_top_n = CastPyArg2Int(pre_nms_top_n_obj, "generate_proposals", 5);
        PyObject *post_nms_top_n_obj = PyTuple_GET_ITEM(args, 6);
        int post_nms_top_n = CastPyArg2Int(post_nms_top_n_obj, "generate_proposals", 6);
        PyObject *nms_thresh_obj = PyTuple_GET_ITEM(args, 7);
        float nms_thresh = CastPyArg2Float(nms_thresh_obj, "generate_proposals", 7);
        PyObject *min_size_obj = PyTuple_GET_ITEM(args, 8);
        float min_size = CastPyArg2Float(min_size_obj, "generate_proposals", 8);
        PyObject *eta_obj = PyTuple_GET_ITEM(args, 9);
        float eta = CastPyArg2Float(eta_obj, "generate_proposals", 9);
        PyObject *pixel_offset_obj = PyTuple_GET_ITEM(args, 10);
        bool pixel_offset = CastPyArg2Boolean(pixel_offset_obj, "generate_proposals", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::generate_proposals(scores, bbox_deltas, im_shape, anchors, variances, pre_nms_top_n, post_nms_top_n, nms_thresh, min_size, eta, pixel_offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_grid_sample(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add grid_sample op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "grid_sample", 0);
        PyObject *grid_obj = PyTuple_GET_ITEM(args, 1);
        auto grid = CastPyArg2Value(grid_obj, "grid_sample", 1);

        // Parse Attributes
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 2);
        std::string mode = CastPyArg2String(mode_obj, "grid_sample", 2);
        PyObject *padding_mode_obj = PyTuple_GET_ITEM(args, 3);
        std::string padding_mode = CastPyArg2String(padding_mode_obj, "grid_sample", 3);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 4);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "grid_sample", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::grid_sample(x, grid, mode, padding_mode, align_corners);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_group_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add group_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "group_norm", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "group_norm", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "group_norm", 2);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 3);
        float epsilon = CastPyArg2Float(epsilon_obj, "group_norm", 3);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 4);
        int groups = CastPyArg2Int(groups_obj, "group_norm", 4);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "group_norm", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::group_norm(x, scale, bias, epsilon, groups, data_layout);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gumbel_softmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gumbel_softmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gumbel_softmax", 0);

        // Parse Attributes
        PyObject *temperature_obj = PyTuple_GET_ITEM(args, 1);
        float temperature = CastPyArg2Float(temperature_obj, "gumbel_softmax", 1);
        PyObject *hard_obj = PyTuple_GET_ITEM(args, 2);
        bool hard = CastPyArg2Boolean(hard_obj, "gumbel_softmax", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "gumbel_softmax", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::gumbel_softmax(x, temperature, hard, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardshrink(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardshrink op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardshrink", 0);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 1);
        float threshold = CastPyArg2Float(threshold_obj, "hardshrink", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardshrink(x, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardsigmoid(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardsigmoid op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardsigmoid", 0);

        // Parse Attributes
        PyObject *slope_obj = PyTuple_GET_ITEM(args, 1);
        float slope = CastPyArg2Float(slope_obj, "hardsigmoid", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        float offset = CastPyArg2Float(offset_obj, "hardsigmoid", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardsigmoid(x, slope, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardtanh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardtanh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardtanh", 0);

        // Parse Attributes
        PyObject *t_min_obj = PyTuple_GET_ITEM(args, 1);
        float t_min = CastPyArg2Float(t_min_obj, "hardtanh", 1);
        PyObject *t_max_obj = PyTuple_GET_ITEM(args, 2);
        float t_max = CastPyArg2Float(t_max_obj, "hardtanh", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardtanh(x, t_min, t_max);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardtanh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardtanh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardtanh_", 0);

        // Parse Attributes
        PyObject *t_min_obj = PyTuple_GET_ITEM(args, 1);
        float t_min = CastPyArg2Float(t_min_obj, "hardtanh_", 1);
        PyObject *t_max_obj = PyTuple_GET_ITEM(args, 2);
        float t_max = CastPyArg2Float(t_max_obj, "hardtanh_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardtanh_(x, t_min, t_max);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_heaviside(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add heaviside op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "heaviside", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "heaviside", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::heaviside(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_histogram(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add histogram op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "histogram", 0);

        // Parse Attributes
        PyObject *bins_obj = PyTuple_GET_ITEM(args, 1);
        int64_t bins = CastPyArg2Long(bins_obj, "histogram", 1);
        PyObject *min_obj = PyTuple_GET_ITEM(args, 2);
        int min = CastPyArg2Int(min_obj, "histogram", 2);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 3);
        int max = CastPyArg2Int(max_obj, "histogram", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::histogram(input, bins, min, max);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_huber_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add huber_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "huber_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "huber_loss", 1);

        // Parse Attributes
        PyObject *delta_obj = PyTuple_GET_ITEM(args, 2);
        float delta = CastPyArg2Float(delta_obj, "huber_loss", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::huber_loss(input, label, delta);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i0(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i0 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i0", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i0(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i0_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i0_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i0_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i0_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i0e(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i0e op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i0e", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i0e(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i1(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i1 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i1", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i1(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i1e(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i1e op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i1e", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i1e(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_imag(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add imag op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "imag", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::imag(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_add(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_add op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_add", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_add", 1);
        PyObject *add_value_obj = PyTuple_GET_ITEM(args, 2);
        auto add_value = CastPyArg2Value(add_value_obj, "index_add", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_add", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_add(x, index, add_value, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_add_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_add_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_add_", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_add_", 1);
        PyObject *add_value_obj = PyTuple_GET_ITEM(args, 2);
        auto add_value = CastPyArg2Value(add_value_obj, "index_add_", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_add_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_add_(x, index, add_value, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_put(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_put op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_put", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2VectorOfValue(indices_obj, "index_put", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "index_put", 2);

        // Parse Attributes
        PyObject *accumulate_obj = PyTuple_GET_ITEM(args, 3);
        bool accumulate = CastPyArg2Boolean(accumulate_obj, "index_put", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_put(x, indices, value, accumulate);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_put_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_put_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_put_", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2VectorOfValue(indices_obj, "index_put_", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "index_put_", 2);

        // Parse Attributes
        PyObject *accumulate_obj = PyTuple_GET_ITEM(args, 3);
        bool accumulate = CastPyArg2Boolean(accumulate_obj, "index_put_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_put_(x, indices, value, accumulate);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_sample(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_sample op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_sample", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_sample", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::index_sample(x, index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_select(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_select op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_select", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_select", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "index_select", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_select(x, index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_select_strided(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_select_strided op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_select_strided", 0);

        // Parse Attributes
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        int64_t index = CastPyArg2Long(index_obj, "index_select_strided", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "index_select_strided", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_select_strided(x, index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_instance_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add instance_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "instance_norm", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "instance_norm", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "instance_norm", 2);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 3);
        float epsilon = CastPyArg2Float(epsilon_obj, "instance_norm", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::instance_norm(x, scale, bias, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_inverse(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add inverse op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "inverse", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::inverse(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_is_empty(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add is_empty op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "is_empty", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::is_empty(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_isclose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add isclose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "isclose", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "isclose", 1);

        // Parse Attributes
        PyObject *rtol_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *atol_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *equal_nan_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value rtol;

       pir::Value atol;

        if (PyObject_CheckIROpResult(rtol_obj)){
             rtol = CastPyArg2Value(rtol_obj, "isclose", 2);
        }else{
            double rtol_tmp = CastPyArg2Double(rtol_obj, "isclose", 2);
            rtol = paddle::dialect::full(std::vector<int64_t>{1}, rtol_tmp, phi::DataType::FLOAT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(atol_obj)){
             atol = CastPyArg2Value(atol_obj, "isclose", 3);
        }else{
            double atol_tmp = CastPyArg2Double(atol_obj, "isclose", 3);
            atol = paddle::dialect::full(std::vector<int64_t>{1}, atol_tmp, phi::DataType::FLOAT64, phi::CPUPlace());

        }
            bool equal_nan = CastPyArg2Boolean(equal_nan_obj, "isclose", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::isclose(x, y, rtol, atol, equal_nan);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_isfinite(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add isfinite op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "isfinite", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::isfinite(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_isinf(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add isinf op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "isinf", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::isinf(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_isnan(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add isnan op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "isnan", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::isnan(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kldiv_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kldiv_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kldiv_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "kldiv_loss", 1);

        // Parse Attributes
        PyObject *reduction_obj = PyTuple_GET_ITEM(args, 2);
        std::string reduction = CastPyArg2String(reduction_obj, "kldiv_loss", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::kldiv_loss(x, label, reduction);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kron(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kron op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kron", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "kron", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::kron(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kthvalue(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kthvalue op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kthvalue", 0);

        // Parse Attributes
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        int k = CastPyArg2Int(k_obj, "kthvalue", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "kthvalue", 2);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 3);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "kthvalue", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::kthvalue(x, k, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_label_smooth(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add label_smooth op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *label_obj = PyTuple_GET_ITEM(args, 0);
        auto label = CastPyArg2Value(label_obj, "label_smooth", 0);
        PyObject *prior_dist_obj = PyTuple_GET_ITEM(args, 1);
        auto prior_dist = CastPyArg2OptionalValue(prior_dist_obj, "label_smooth", 1);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 2);
        float epsilon = CastPyArg2Float(epsilon_obj, "label_smooth", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::label_smooth(label, prior_dist, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lamb_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lamb_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "lamb_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "lamb_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "lamb_", 2);
        PyObject *moment1_obj = PyTuple_GET_ITEM(args, 3);
        auto moment1 = CastPyArg2Value(moment1_obj, "lamb_", 3);
        PyObject *moment2_obj = PyTuple_GET_ITEM(args, 4);
        auto moment2 = CastPyArg2Value(moment2_obj, "lamb_", 4);
        PyObject *beta1_pow_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pow = CastPyArg2Value(beta1_pow_obj, "lamb_", 5);
        PyObject *beta2_pow_obj = PyTuple_GET_ITEM(args, 6);
        auto beta2_pow = CastPyArg2Value(beta2_pow_obj, "lamb_", 6);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 7);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "lamb_", 7);
        PyObject *skip_update_obj = PyTuple_GET_ITEM(args, 8);
        auto skip_update = CastPyArg2OptionalValue(skip_update_obj, "lamb_", 8);

        // Parse Attributes
        PyObject *weight_decay_obj = PyTuple_GET_ITEM(args, 9);
        float weight_decay = CastPyArg2Float(weight_decay_obj, "lamb_", 9);
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 10);
        float beta1 = CastPyArg2Float(beta1_obj, "lamb_", 10);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 11);
        float beta2 = CastPyArg2Float(beta2_obj, "lamb_", 11);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 12);
        float epsilon = CastPyArg2Float(epsilon_obj, "lamb_", 12);
        PyObject *always_adapt_obj = PyTuple_GET_ITEM(args, 13);
        bool always_adapt = CastPyArg2Boolean(always_adapt_obj, "lamb_", 13);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 14);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "lamb_", 14);

        // Call ir static api
        auto static_api_out = paddle::dialect::lamb_(param, grad, learning_rate, moment1, moment2, beta1_pow, beta2_pow, master_param, skip_update, weight_decay, beta1, beta2, epsilon, always_adapt, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_layer_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add layer_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "layer_norm", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "layer_norm", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "layer_norm", 2);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 3);
        float epsilon = CastPyArg2Float(epsilon_obj, "layer_norm", 3);
        PyObject *begin_norm_axis_obj = PyTuple_GET_ITEM(args, 4);
        int begin_norm_axis = CastPyArg2Int(begin_norm_axis_obj, "layer_norm", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::layer_norm(x, scale, bias, epsilon, begin_norm_axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu", 0);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 1);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu(x, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu_", 0);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 1);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu_(x, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lerp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lerp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lerp", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lerp", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2Value(weight_obj, "lerp", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lerp(x, y, weight);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lerp_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lerp_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lerp_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lerp_", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2Value(weight_obj, "lerp_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lerp_(x, y, weight);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lgamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lgamma op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lgamma", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lgamma(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lgamma_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lgamma_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lgamma_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lgamma_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_linear_interp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add linear_interp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "linear_interp", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "linear_interp", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "linear_interp", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "linear_interp", 3);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 4);
        std::string data_layout = CastPyArg2String(data_layout_obj, "linear_interp", 4);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 5);
        int out_d = CastPyArg2Int(out_d_obj, "linear_interp", 5);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 6);
        int out_h = CastPyArg2Int(out_h_obj, "linear_interp", 6);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 7);
        int out_w = CastPyArg2Int(out_w_obj, "linear_interp", 7);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "linear_interp", 8);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 9);
        std::string interp_method = CastPyArg2String(interp_method_obj, "linear_interp", 9);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 10);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "linear_interp", 10);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 11);
        int align_mode = CastPyArg2Int(align_mode_obj, "linear_interp", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::linear_interp(x, out_size, size_tensor, scale_tensor, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_llm_int8_linear(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add llm_int8_linear op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "llm_int8_linear", 0);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 1);
        auto weight = CastPyArg2Value(weight_obj, "llm_int8_linear", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "llm_int8_linear", 2);
        PyObject *weight_scale_obj = PyTuple_GET_ITEM(args, 3);
        auto weight_scale = CastPyArg2Value(weight_scale_obj, "llm_int8_linear", 3);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 4);
        float threshold = CastPyArg2Float(threshold_obj, "llm_int8_linear", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::llm_int8_linear(x, weight, bias, weight_scale, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log10(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log10 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log10", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log10(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log10_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log10_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log10_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log10_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log1p(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log1p op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log1p", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log1p(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log1p_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log1p_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log1p_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log1p_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log2(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log2 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log2", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log2(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log2_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log2_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log2_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log2_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "log_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "log_loss", 1);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 2);
        float epsilon = CastPyArg2Float(epsilon_obj, "log_loss", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::log_loss(input, label, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_softmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_softmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_softmax", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "log_softmax", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::log_softmax(x, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logcumsumexp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logcumsumexp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logcumsumexp", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "logcumsumexp", 1);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 2);
        bool flatten = CastPyArg2Boolean(flatten_obj, "logcumsumexp", 2);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 3);
        bool exclusive = CastPyArg2Boolean(exclusive_obj, "logcumsumexp", 3);
        PyObject *reverse_obj = PyTuple_GET_ITEM(args, 4);
        bool reverse = CastPyArg2Boolean(reverse_obj, "logcumsumexp", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::logcumsumexp(x, axis, flatten, exclusive, reverse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_and(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_and op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_and", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_and", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_and(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_and_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_and_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_and_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_and_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_and_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_not(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_not op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_not", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_not(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_not_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_not_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_not_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_not_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_or(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_or op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_or", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_or", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_or(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_or_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_or_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_or_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_or_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_or_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_xor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_xor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_xor", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_xor", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_xor(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logical_xor_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logical_xor_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logical_xor_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "logical_xor_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logical_xor_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logit(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logit op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logit", 0);

        // Parse Attributes
        PyObject *eps_obj = PyTuple_GET_ITEM(args, 1);
        float eps = CastPyArg2Float(eps_obj, "logit", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::logit(x, eps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logit_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logit_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logit_", 0);

        // Parse Attributes
        PyObject *eps_obj = PyTuple_GET_ITEM(args, 1);
        float eps = CastPyArg2Float(eps_obj, "logit_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::logit_(x, eps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logsigmoid(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logsigmoid op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logsigmoid", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logsigmoid(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lstsq(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lstsq op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lstsq", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lstsq", 1);

        // Parse Attributes
        PyObject *rcond_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *driver_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value rcond;

        if (PyObject_CheckIROpResult(rcond_obj)){
             rcond = CastPyArg2Value(rcond_obj, "lstsq", 2);
        }else{
            float rcond_tmp = CastPyArg2Float(rcond_obj, "lstsq", 2);
            rcond = paddle::dialect::full(std::vector<int64_t>{1}, rcond_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            std::string driver = CastPyArg2String(driver_obj, "lstsq", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::lstsq(x, y, rcond, driver);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu", 0);

        // Parse Attributes
        PyObject *pivot_obj = PyTuple_GET_ITEM(args, 1);
        bool pivot = CastPyArg2Boolean(pivot_obj, "lu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu(x, pivot);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu_", 0);

        // Parse Attributes
        PyObject *pivot_obj = PyTuple_GET_ITEM(args, 1);
        bool pivot = CastPyArg2Boolean(pivot_obj, "lu_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu_(x, pivot);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu_unpack(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu_unpack op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu_unpack", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lu_unpack", 1);

        // Parse Attributes
        PyObject *unpack_ludata_obj = PyTuple_GET_ITEM(args, 2);
        bool unpack_ludata = CastPyArg2Boolean(unpack_ludata_obj, "lu_unpack", 2);
        PyObject *unpack_pivots_obj = PyTuple_GET_ITEM(args, 3);
        bool unpack_pivots = CastPyArg2Boolean(unpack_pivots_obj, "lu_unpack", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu_unpack(x, y, unpack_ludata, unpack_pivots);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_margin_cross_entropy(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add margin_cross_entropy op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *logits_obj = PyTuple_GET_ITEM(args, 0);
        auto logits = CastPyArg2Value(logits_obj, "margin_cross_entropy", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "margin_cross_entropy", 1);

        // Parse Attributes
        PyObject *return_softmax_obj = PyTuple_GET_ITEM(args, 2);
        bool return_softmax = CastPyArg2Boolean(return_softmax_obj, "margin_cross_entropy", 2);
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 3);
        int ring_id = CastPyArg2Int(ring_id_obj, "margin_cross_entropy", 3);
        PyObject *rank_obj = PyTuple_GET_ITEM(args, 4);
        int rank = CastPyArg2Int(rank_obj, "margin_cross_entropy", 4);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 5);
        int nranks = CastPyArg2Int(nranks_obj, "margin_cross_entropy", 5);
        PyObject *margin1_obj = PyTuple_GET_ITEM(args, 6);
        float margin1 = CastPyArg2Float(margin1_obj, "margin_cross_entropy", 6);
        PyObject *margin2_obj = PyTuple_GET_ITEM(args, 7);
        float margin2 = CastPyArg2Float(margin2_obj, "margin_cross_entropy", 7);
        PyObject *margin3_obj = PyTuple_GET_ITEM(args, 8);
        float margin3 = CastPyArg2Float(margin3_obj, "margin_cross_entropy", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        float scale = CastPyArg2Float(scale_obj, "margin_cross_entropy", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::margin_cross_entropy(logits, label, return_softmax, ring_id, rank, nranks, margin1, margin2, margin3, scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_masked_multihead_attention_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add masked_multihead_attention_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "masked_multihead_attention_", 0);
        PyObject *cache_kv_obj = PyTuple_GET_ITEM(args, 1);
        auto cache_kv = CastPyArg2Value(cache_kv_obj, "masked_multihead_attention_", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "masked_multihead_attention_", 2);
        PyObject *src_mask_obj = PyTuple_GET_ITEM(args, 3);
        auto src_mask = CastPyArg2OptionalValue(src_mask_obj, "masked_multihead_attention_", 3);
        PyObject *cum_offsets_obj = PyTuple_GET_ITEM(args, 4);
        auto cum_offsets = CastPyArg2OptionalValue(cum_offsets_obj, "masked_multihead_attention_", 4);
        PyObject *sequence_lengths_obj = PyTuple_GET_ITEM(args, 5);
        auto sequence_lengths = CastPyArg2OptionalValue(sequence_lengths_obj, "masked_multihead_attention_", 5);
        PyObject *rotary_tensor_obj = PyTuple_GET_ITEM(args, 6);
        auto rotary_tensor = CastPyArg2OptionalValue(rotary_tensor_obj, "masked_multihead_attention_", 6);
        PyObject *beam_cache_offset_obj = PyTuple_GET_ITEM(args, 7);
        auto beam_cache_offset = CastPyArg2OptionalValue(beam_cache_offset_obj, "masked_multihead_attention_", 7);
        PyObject *qkv_out_scale_obj = PyTuple_GET_ITEM(args, 8);
        auto qkv_out_scale = CastPyArg2OptionalValue(qkv_out_scale_obj, "masked_multihead_attention_", 8);
        PyObject *out_shift_obj = PyTuple_GET_ITEM(args, 9);
        auto out_shift = CastPyArg2OptionalValue(out_shift_obj, "masked_multihead_attention_", 9);
        PyObject *out_smooth_obj = PyTuple_GET_ITEM(args, 10);
        auto out_smooth = CastPyArg2OptionalValue(out_smooth_obj, "masked_multihead_attention_", 10);

        // Parse Attributes
        PyObject *seq_len_obj = PyTuple_GET_ITEM(args, 11);
        int seq_len = CastPyArg2Int(seq_len_obj, "masked_multihead_attention_", 11);
        PyObject *rotary_emb_dims_obj = PyTuple_GET_ITEM(args, 12);
        int rotary_emb_dims = CastPyArg2Int(rotary_emb_dims_obj, "masked_multihead_attention_", 12);
        PyObject *use_neox_rotary_style_obj = PyTuple_GET_ITEM(args, 13);
        bool use_neox_rotary_style = CastPyArg2Boolean(use_neox_rotary_style_obj, "masked_multihead_attention_", 13);
        PyObject *compute_dtype_obj = PyTuple_GET_ITEM(args, 14);
        std::string compute_dtype = CastPyArg2String(compute_dtype_obj, "masked_multihead_attention_", 14);
        PyObject *out_scale_obj = PyTuple_GET_ITEM(args, 15);
        float out_scale = CastPyArg2Float(out_scale_obj, "masked_multihead_attention_", 15);
        PyObject *quant_round_type_obj = PyTuple_GET_ITEM(args, 16);
        int quant_round_type = CastPyArg2Int(quant_round_type_obj, "masked_multihead_attention_", 16);
        PyObject *quant_max_bound_obj = PyTuple_GET_ITEM(args, 17);
        float quant_max_bound = CastPyArg2Float(quant_max_bound_obj, "masked_multihead_attention_", 17);
        PyObject *quant_min_bound_obj = PyTuple_GET_ITEM(args, 18);
        float quant_min_bound = CastPyArg2Float(quant_min_bound_obj, "masked_multihead_attention_", 18);

        // Call ir static api
        auto static_api_out = paddle::dialect::masked_multihead_attention_(x, cache_kv, bias, src_mask, cum_offsets, sequence_lengths, rotary_tensor, beam_cache_offset, qkv_out_scale, out_shift, out_smooth, seq_len, rotary_emb_dims, use_neox_rotary_style, compute_dtype, out_scale, quant_round_type, quant_max_bound, quant_min_bound);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_masked_select(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add masked_select op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "masked_select", 0);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 1);
        auto mask = CastPyArg2Value(mask_obj, "masked_select", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::masked_select(x, mask);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matrix_nms(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matrix_nms op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *bboxes_obj = PyTuple_GET_ITEM(args, 0);
        auto bboxes = CastPyArg2Value(bboxes_obj, "matrix_nms", 0);
        PyObject *scores_obj = PyTuple_GET_ITEM(args, 1);
        auto scores = CastPyArg2Value(scores_obj, "matrix_nms", 1);

        // Parse Attributes
        PyObject *score_threshold_obj = PyTuple_GET_ITEM(args, 2);
        float score_threshold = CastPyArg2Float(score_threshold_obj, "matrix_nms", 2);
        PyObject *nms_top_k_obj = PyTuple_GET_ITEM(args, 3);
        int nms_top_k = CastPyArg2Int(nms_top_k_obj, "matrix_nms", 3);
        PyObject *keep_top_k_obj = PyTuple_GET_ITEM(args, 4);
        int keep_top_k = CastPyArg2Int(keep_top_k_obj, "matrix_nms", 4);
        PyObject *post_threshold_obj = PyTuple_GET_ITEM(args, 5);
        float post_threshold = CastPyArg2Float(post_threshold_obj, "matrix_nms", 5);
        PyObject *use_gaussian_obj = PyTuple_GET_ITEM(args, 6);
        bool use_gaussian = CastPyArg2Boolean(use_gaussian_obj, "matrix_nms", 6);
        PyObject *gaussian_sigma_obj = PyTuple_GET_ITEM(args, 7);
        float gaussian_sigma = CastPyArg2Float(gaussian_sigma_obj, "matrix_nms", 7);
        PyObject *background_label_obj = PyTuple_GET_ITEM(args, 8);
        int background_label = CastPyArg2Int(background_label_obj, "matrix_nms", 8);
        PyObject *normalized_obj = PyTuple_GET_ITEM(args, 9);
        bool normalized = CastPyArg2Boolean(normalized_obj, "matrix_nms", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::matrix_nms(bboxes, scores, score_threshold, nms_top_k, keep_top_k, post_threshold, use_gaussian, gaussian_sigma, background_label, normalized);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matrix_power(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matrix_power op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matrix_power", 0);

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 1);
        int n = CastPyArg2Int(n_obj, "matrix_power", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::matrix_power(x, n);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max_pool2d_with_index(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max_pool2d_with_index op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max_pool2d_with_index", 0);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "max_pool2d_with_index", 1);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "max_pool2d_with_index", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "max_pool2d_with_index", 3);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 4);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "max_pool2d_with_index", 4);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 5);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "max_pool2d_with_index", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::max_pool2d_with_index(x, kernel_size, strides, paddings, global_pooling, adaptive);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max_pool3d_with_index(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max_pool3d_with_index op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max_pool3d_with_index", 0);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "max_pool3d_with_index", 1);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "max_pool3d_with_index", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "max_pool3d_with_index", 3);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 4);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "max_pool3d_with_index", 4);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 5);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "max_pool3d_with_index", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::max_pool3d_with_index(x, kernel_size, strides, paddings, global_pooling, adaptive);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_maxout(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add maxout op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "maxout", 0);

        // Parse Attributes
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 1);
        int groups = CastPyArg2Int(groups_obj, "maxout", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "maxout", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::maxout(x, groups, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mean_all(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mean_all op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mean_all", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::mean_all(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_memory_efficient_attention(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add memory_efficient_attention op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *query_obj = PyTuple_GET_ITEM(args, 0);
        auto query = CastPyArg2Value(query_obj, "memory_efficient_attention", 0);
        PyObject *key_obj = PyTuple_GET_ITEM(args, 1);
        auto key = CastPyArg2Value(key_obj, "memory_efficient_attention", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "memory_efficient_attention", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2OptionalValue(bias_obj, "memory_efficient_attention", 3);
        PyObject *cu_seqlens_q_obj = PyTuple_GET_ITEM(args, 4);
        auto cu_seqlens_q = CastPyArg2OptionalValue(cu_seqlens_q_obj, "memory_efficient_attention", 4);
        PyObject *cu_seqlens_k_obj = PyTuple_GET_ITEM(args, 5);
        auto cu_seqlens_k = CastPyArg2OptionalValue(cu_seqlens_k_obj, "memory_efficient_attention", 5);
        PyObject *causal_diagonal_obj = PyTuple_GET_ITEM(args, 6);
        auto causal_diagonal = CastPyArg2OptionalValue(causal_diagonal_obj, "memory_efficient_attention", 6);
        PyObject *seqlen_k_obj = PyTuple_GET_ITEM(args, 7);
        auto seqlen_k = CastPyArg2OptionalValue(seqlen_k_obj, "memory_efficient_attention", 7);

        // Parse Attributes
        PyObject *max_seqlen_q_obj = PyTuple_GET_ITEM(args, 8);
        float max_seqlen_q = CastPyArg2Float(max_seqlen_q_obj, "memory_efficient_attention", 8);
        PyObject *max_seqlen_k_obj = PyTuple_GET_ITEM(args, 9);
        float max_seqlen_k = CastPyArg2Float(max_seqlen_k_obj, "memory_efficient_attention", 9);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 10);
        bool causal = CastPyArg2Boolean(causal_obj, "memory_efficient_attention", 10);
        PyObject *dropout_p_obj = PyTuple_GET_ITEM(args, 11);
        double dropout_p = CastPyArg2Double(dropout_p_obj, "memory_efficient_attention", 11);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 12);
        float scale = CastPyArg2Float(scale_obj, "memory_efficient_attention", 12);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 13);
        bool is_test = CastPyArg2Boolean(is_test_obj, "memory_efficient_attention", 13);

        // Call ir static api
        auto static_api_out = paddle::dialect::memory_efficient_attention(query, key, value, bias, cu_seqlens_q, cu_seqlens_k, causal_diagonal, seqlen_k, max_seqlen_q, max_seqlen_k, causal, dropout_p, scale, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_merge_selected_rows(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add merge_selected_rows op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "merge_selected_rows", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::merge_selected_rows(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_merged_adam_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add merged_adam_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2VectorOfValue(param_obj, "merged_adam_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2VectorOfValue(grad_obj, "merged_adam_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2VectorOfValue(learning_rate_obj, "merged_adam_", 2);
        PyObject *moment1_obj = PyTuple_GET_ITEM(args, 3);
        auto moment1 = CastPyArg2VectorOfValue(moment1_obj, "merged_adam_", 3);
        PyObject *moment2_obj = PyTuple_GET_ITEM(args, 4);
        auto moment2 = CastPyArg2VectorOfValue(moment2_obj, "merged_adam_", 4);
        PyObject *beta1_pow_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pow = CastPyArg2VectorOfValue(beta1_pow_obj, "merged_adam_", 5);
        PyObject *beta2_pow_obj = PyTuple_GET_ITEM(args, 6);
        auto beta2_pow = CastPyArg2VectorOfValue(beta2_pow_obj, "merged_adam_", 6);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 7);
        auto master_param = CastPyArg2OptionalVectorOfValue(master_param_obj, "merged_adam_", 7);

        // Parse Attributes
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 11);
        PyObject *use_global_beta_pow_obj = PyTuple_GET_ITEM(args, 12);

        // Check for mutable attrs
       pir::Value beta1;

       pir::Value beta2;

       pir::Value epsilon;

        if (PyObject_CheckIROpResult(beta1_obj)){
             beta1 = CastPyArg2Value(beta1_obj, "merged_adam_", 8);
        }else{
            float beta1_tmp = CastPyArg2Float(beta1_obj, "merged_adam_", 8);
            beta1 = paddle::dialect::full(std::vector<int64_t>{1}, beta1_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(beta2_obj)){
             beta2 = CastPyArg2Value(beta2_obj, "merged_adam_", 9);
        }else{
            float beta2_tmp = CastPyArg2Float(beta2_obj, "merged_adam_", 9);
            beta2 = paddle::dialect::full(std::vector<int64_t>{1}, beta2_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(epsilon_obj)){
             epsilon = CastPyArg2Value(epsilon_obj, "merged_adam_", 10);
        }else{
            float epsilon_tmp = CastPyArg2Float(epsilon_obj, "merged_adam_", 10);
            epsilon = paddle::dialect::full(std::vector<int64_t>{1}, epsilon_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "merged_adam_", 11);
            bool use_global_beta_pow = CastPyArg2Boolean(use_global_beta_pow_obj, "merged_adam_", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::merged_adam_(param, grad, learning_rate, moment1, moment2, beta1_pow, beta2_pow, master_param, beta1, beta2, epsilon, multi_precision, use_global_beta_pow);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_merged_momentum_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add merged_momentum_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2VectorOfValue(param_obj, "merged_momentum_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2VectorOfValue(grad_obj, "merged_momentum_", 1);
        PyObject *velocity_obj = PyTuple_GET_ITEM(args, 2);
        auto velocity = CastPyArg2VectorOfValue(velocity_obj, "merged_momentum_", 2);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 3);
        auto learning_rate = CastPyArg2VectorOfValue(learning_rate_obj, "merged_momentum_", 3);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 4);
        auto master_param = CastPyArg2OptionalVectorOfValue(master_param_obj, "merged_momentum_", 4);

        // Parse Attributes
        PyObject *mu_obj = PyTuple_GET_ITEM(args, 5);
        float mu = CastPyArg2Float(mu_obj, "merged_momentum_", 5);
        PyObject *use_nesterov_obj = PyTuple_GET_ITEM(args, 6);
        bool use_nesterov = CastPyArg2Boolean(use_nesterov_obj, "merged_momentum_", 6);
        PyObject *regularization_method_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<std::string> regularization_method = CastPyArg2Strings(regularization_method_obj, "merged_momentum_", 7);
        PyObject *regularization_coeff_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> regularization_coeff = CastPyArg2Floats(regularization_coeff_obj, "merged_momentum_", 8);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 9);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "merged_momentum_", 9);
        PyObject *rescale_grad_obj = PyTuple_GET_ITEM(args, 10);
        float rescale_grad = CastPyArg2Float(rescale_grad_obj, "merged_momentum_", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::merged_momentum_(param, grad, velocity, learning_rate, master_param, mu, use_nesterov, regularization_method, regularization_coeff, multi_precision, rescale_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_meshgrid(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add meshgrid op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *inputs_obj = PyTuple_GET_ITEM(args, 0);
        auto inputs = CastPyArg2VectorOfValue(inputs_obj, "meshgrid", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::meshgrid(inputs);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mode(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mode op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mode", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "mode", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "mode", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::mode(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_momentum_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add momentum_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "momentum_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "momentum_", 1);
        PyObject *velocity_obj = PyTuple_GET_ITEM(args, 2);
        auto velocity = CastPyArg2Value(velocity_obj, "momentum_", 2);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 3);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "momentum_", 3);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 4);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "momentum_", 4);

        // Parse Attributes
        PyObject *mu_obj = PyTuple_GET_ITEM(args, 5);
        float mu = CastPyArg2Float(mu_obj, "momentum_", 5);
        PyObject *use_nesterov_obj = PyTuple_GET_ITEM(args, 6);
        bool use_nesterov = CastPyArg2Boolean(use_nesterov_obj, "momentum_", 6);
        PyObject *regularization_method_obj = PyTuple_GET_ITEM(args, 7);
        std::string regularization_method = CastPyArg2String(regularization_method_obj, "momentum_", 7);
        PyObject *regularization_coeff_obj = PyTuple_GET_ITEM(args, 8);
        float regularization_coeff = CastPyArg2Float(regularization_coeff_obj, "momentum_", 8);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 9);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "momentum_", 9);
        PyObject *rescale_grad_obj = PyTuple_GET_ITEM(args, 10);
        float rescale_grad = CastPyArg2Float(rescale_grad_obj, "momentum_", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::momentum_(param, grad, velocity, learning_rate, master_param, mu, use_nesterov, regularization_method, regularization_coeff, multi_precision, rescale_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multi_dot(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multi_dot op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "multi_dot", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multi_dot(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiclass_nms3(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiclass_nms3 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *bboxes_obj = PyTuple_GET_ITEM(args, 0);
        auto bboxes = CastPyArg2Value(bboxes_obj, "multiclass_nms3", 0);
        PyObject *scores_obj = PyTuple_GET_ITEM(args, 1);
        auto scores = CastPyArg2Value(scores_obj, "multiclass_nms3", 1);
        PyObject *rois_num_obj = PyTuple_GET_ITEM(args, 2);
        auto rois_num = CastPyArg2OptionalValue(rois_num_obj, "multiclass_nms3", 2);

        // Parse Attributes
        PyObject *score_threshold_obj = PyTuple_GET_ITEM(args, 3);
        float score_threshold = CastPyArg2Float(score_threshold_obj, "multiclass_nms3", 3);
        PyObject *nms_top_k_obj = PyTuple_GET_ITEM(args, 4);
        int nms_top_k = CastPyArg2Int(nms_top_k_obj, "multiclass_nms3", 4);
        PyObject *keep_top_k_obj = PyTuple_GET_ITEM(args, 5);
        int keep_top_k = CastPyArg2Int(keep_top_k_obj, "multiclass_nms3", 5);
        PyObject *nms_threshold_obj = PyTuple_GET_ITEM(args, 6);
        float nms_threshold = CastPyArg2Float(nms_threshold_obj, "multiclass_nms3", 6);
        PyObject *normalized_obj = PyTuple_GET_ITEM(args, 7);
        bool normalized = CastPyArg2Boolean(normalized_obj, "multiclass_nms3", 7);
        PyObject *nms_eta_obj = PyTuple_GET_ITEM(args, 8);
        float nms_eta = CastPyArg2Float(nms_eta_obj, "multiclass_nms3", 8);
        PyObject *background_label_obj = PyTuple_GET_ITEM(args, 9);
        int background_label = CastPyArg2Int(background_label_obj, "multiclass_nms3", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::multiclass_nms3(bboxes, scores, rois_num, score_threshold, nms_top_k, keep_top_k, nms_threshold, normalized, nms_eta, background_label);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multinomial(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multinomial op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multinomial", 0);

        // Parse Attributes
        PyObject *num_samples_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *replacement_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value num_samples;

        if (PyObject_CheckIROpResult(num_samples_obj)){
             num_samples = CastPyArg2Value(num_samples_obj, "multinomial", 1);
        }else{
            int num_samples_tmp = CastPyArg2Int(num_samples_obj, "multinomial", 1);
            num_samples = paddle::dialect::full(std::vector<int64_t>{1}, num_samples_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            bool replacement = CastPyArg2Boolean(replacement_obj, "multinomial", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::multinomial(x, num_samples, replacement);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiplex(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiplex op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *inputs_obj = PyTuple_GET_ITEM(args, 0);
        auto inputs = CastPyArg2VectorOfValue(inputs_obj, "multiplex", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "multiplex", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multiplex(inputs, index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mv", 0);
        PyObject *vec_obj = PyTuple_GET_ITEM(args, 1);
        auto vec = CastPyArg2Value(vec_obj, "mv", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::mv(x, vec);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nanmedian(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nanmedian op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nanmedian", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "nanmedian", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "nanmedian", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::nanmedian(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nearest_interp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nearest_interp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nearest_interp", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "nearest_interp", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "nearest_interp", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "nearest_interp", 3);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 4);
        std::string data_layout = CastPyArg2String(data_layout_obj, "nearest_interp", 4);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 5);
        int out_d = CastPyArg2Int(out_d_obj, "nearest_interp", 5);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 6);
        int out_h = CastPyArg2Int(out_h_obj, "nearest_interp", 6);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 7);
        int out_w = CastPyArg2Int(out_w_obj, "nearest_interp", 7);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "nearest_interp", 8);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 9);
        std::string interp_method = CastPyArg2String(interp_method_obj, "nearest_interp", 9);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 10);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "nearest_interp", 10);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 11);
        int align_mode = CastPyArg2Int(align_mode_obj, "nearest_interp", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::nearest_interp(x, out_size, size_tensor, scale_tensor, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nextafter(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nextafter op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nextafter", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "nextafter", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::nextafter(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nll_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nll_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "nll_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "nll_loss", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2OptionalValue(weight_obj, "nll_loss", 2);

        // Parse Attributes
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 3);
        int64_t ignore_index = CastPyArg2Long(ignore_index_obj, "nll_loss", 3);
        PyObject *reduction_obj = PyTuple_GET_ITEM(args, 4);
        std::string reduction = CastPyArg2String(reduction_obj, "nll_loss", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::nll_loss(input, label, weight, ignore_index, reduction);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nms(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nms op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nms", 0);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 1);
        float threshold = CastPyArg2Float(threshold_obj, "nms", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::nms(x, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nonzero(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nonzero op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *condition_obj = PyTuple_GET_ITEM(args, 0);
        auto condition = CastPyArg2Value(condition_obj, "nonzero", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::nonzero(condition);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_npu_identity(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add npu_identity op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "npu_identity", 0);

        // Parse Attributes
        PyObject *format_obj = PyTuple_GET_ITEM(args, 1);
        int format = CastPyArg2Int(format_obj, "npu_identity", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::npu_identity(x, format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_numel(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add numel op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "numel", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::numel(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_overlap_add(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add overlap_add op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "overlap_add", 0);

        // Parse Attributes
        PyObject *hop_length_obj = PyTuple_GET_ITEM(args, 1);
        int hop_length = CastPyArg2Int(hop_length_obj, "overlap_add", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "overlap_add", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::overlap_add(x, hop_length, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_p_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add p_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "p_norm", 0);

        // Parse Attributes
        PyObject *porder_obj = PyTuple_GET_ITEM(args, 1);
        float porder = CastPyArg2Float(porder_obj, "p_norm", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "p_norm", 2);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 3);
        float epsilon = CastPyArg2Float(epsilon_obj, "p_norm", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "p_norm", 4);
        PyObject *asvector_obj = PyTuple_GET_ITEM(args, 5);
        bool asvector = CastPyArg2Boolean(asvector_obj, "p_norm", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::p_norm(x, porder, axis, epsilon, keepdim, asvector);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad3d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad3d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pad3d", 0);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value paddings;

        if (PyObject_CheckIROpResult(paddings_obj)){
             paddings = CastPyArg2Value(paddings_obj, "pad3d", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(paddings_obj)){
            std::vector<pir::Value> paddings_tmp = CastPyArg2VectorOfValue(paddings_obj, "pad3d", 1);
            paddings = paddle::dialect::stack(paddings_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> paddings_tmp = CastPyArg2Longs(paddings_obj, "pad3d", 1);
            paddings = paddle::dialect::full_int_array(paddings_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string mode = CastPyArg2String(mode_obj, "pad3d", 2);
            float pad_value = CastPyArg2Float(pad_value_obj, "pad3d", 3);
            std::string data_format = CastPyArg2String(data_format_obj, "pad3d", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::pad3d(x, paddings, mode, pad_value, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pixel_shuffle(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pixel_shuffle op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pixel_shuffle", 0);

        // Parse Attributes
        PyObject *upscale_factor_obj = PyTuple_GET_ITEM(args, 1);
        int upscale_factor = CastPyArg2Int(upscale_factor_obj, "pixel_shuffle", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "pixel_shuffle", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pixel_shuffle(x, upscale_factor, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pixel_unshuffle(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pixel_unshuffle op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pixel_unshuffle", 0);

        // Parse Attributes
        PyObject *downscale_factor_obj = PyTuple_GET_ITEM(args, 1);
        int downscale_factor = CastPyArg2Int(downscale_factor_obj, "pixel_unshuffle", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "pixel_unshuffle", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pixel_unshuffle(x, downscale_factor, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_poisson(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add poisson op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "poisson", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::poisson(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_polygamma(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add polygamma op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "polygamma", 0);

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 1);
        int n = CastPyArg2Int(n_obj, "polygamma", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::polygamma(x, n);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_polygamma_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add polygamma_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "polygamma_", 0);

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 1);
        int n = CastPyArg2Int(n_obj, "polygamma_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::polygamma_(x, n);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow", 0);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        float y = CastPyArg2Float(y_obj, "pow", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_", 0);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        float y = CastPyArg2Float(y_obj, "pow_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_prelu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add prelu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "prelu", 0);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 1);
        auto alpha = CastPyArg2Value(alpha_obj, "prelu", 1);

        // Parse Attributes
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "prelu", 2);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 3);
        std::string mode = CastPyArg2String(mode_obj, "prelu", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::prelu(x, alpha, data_format, mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_prior_box(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add prior_box op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "prior_box", 0);
        PyObject *image_obj = PyTuple_GET_ITEM(args, 1);
        auto image = CastPyArg2Value(image_obj, "prior_box", 1);

        // Parse Attributes
        PyObject *min_sizes_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<float> min_sizes = CastPyArg2Floats(min_sizes_obj, "prior_box", 2);
        PyObject *max_sizes_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<float> max_sizes = CastPyArg2Floats(max_sizes_obj, "prior_box", 3);
        PyObject *aspect_ratios_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<float> aspect_ratios = CastPyArg2Floats(aspect_ratios_obj, "prior_box", 4);
        PyObject *variances_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<float> variances = CastPyArg2Floats(variances_obj, "prior_box", 5);
        PyObject *flip_obj = PyTuple_GET_ITEM(args, 6);
        bool flip = CastPyArg2Boolean(flip_obj, "prior_box", 6);
        PyObject *clip_obj = PyTuple_GET_ITEM(args, 7);
        bool clip = CastPyArg2Boolean(clip_obj, "prior_box", 7);
        PyObject *step_w_obj = PyTuple_GET_ITEM(args, 8);
        float step_w = CastPyArg2Float(step_w_obj, "prior_box", 8);
        PyObject *step_h_obj = PyTuple_GET_ITEM(args, 9);
        float step_h = CastPyArg2Float(step_h_obj, "prior_box", 9);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 10);
        float offset = CastPyArg2Float(offset_obj, "prior_box", 10);
        PyObject *min_max_aspect_ratios_order_obj = PyTuple_GET_ITEM(args, 11);
        bool min_max_aspect_ratios_order = CastPyArg2Boolean(min_max_aspect_ratios_order_obj, "prior_box", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::prior_box(input, image, min_sizes, max_sizes, aspect_ratios, variances, flip, clip, step_w, step_h, offset, min_max_aspect_ratios_order);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_psroi_pool(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add psroi_pool op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "psroi_pool", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "psroi_pool", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "psroi_pool", 2);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 3);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "psroi_pool", 3);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 4);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "psroi_pool", 4);
        PyObject *output_channels_obj = PyTuple_GET_ITEM(args, 5);
        int output_channels = CastPyArg2Int(output_channels_obj, "psroi_pool", 5);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 6);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "psroi_pool", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::psroi_pool(x, boxes, boxes_num, pooled_height, pooled_width, output_channels, spatial_scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_put_along_axis(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add put_along_axis op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *arr_obj = PyTuple_GET_ITEM(args, 0);
        auto arr = CastPyArg2Value(arr_obj, "put_along_axis", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "put_along_axis", 1);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 2);
        auto values = CastPyArg2Value(values_obj, "put_along_axis", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "put_along_axis", 3);
        PyObject *reduce_obj = PyTuple_GET_ITEM(args, 4);
        std::string reduce = CastPyArg2String(reduce_obj, "put_along_axis", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::put_along_axis(arr, indices, values, axis, reduce);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_put_along_axis_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add put_along_axis_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *arr_obj = PyTuple_GET_ITEM(args, 0);
        auto arr = CastPyArg2Value(arr_obj, "put_along_axis_", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "put_along_axis_", 1);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 2);
        auto values = CastPyArg2Value(values_obj, "put_along_axis_", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "put_along_axis_", 3);
        PyObject *reduce_obj = PyTuple_GET_ITEM(args, 4);
        std::string reduce = CastPyArg2String(reduce_obj, "put_along_axis_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::put_along_axis_(arr, indices, values, axis, reduce);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_qr(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add qr op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "qr", 0);

        // Parse Attributes
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 1);
        std::string mode = CastPyArg2String(mode_obj, "qr", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::qr(x, mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_real(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add real op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "real", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::real(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reciprocal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reciprocal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reciprocal", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reciprocal(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reciprocal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reciprocal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reciprocal_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reciprocal_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reindex_graph(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reindex_graph op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reindex_graph", 0);
        PyObject *neighbors_obj = PyTuple_GET_ITEM(args, 1);
        auto neighbors = CastPyArg2Value(neighbors_obj, "reindex_graph", 1);
        PyObject *count_obj = PyTuple_GET_ITEM(args, 2);
        auto count = CastPyArg2Value(count_obj, "reindex_graph", 2);
        PyObject *hashtable_value_obj = PyTuple_GET_ITEM(args, 3);
        auto hashtable_value = CastPyArg2OptionalValue(hashtable_value_obj, "reindex_graph", 3);
        PyObject *hashtable_index_obj = PyTuple_GET_ITEM(args, 4);
        auto hashtable_index = CastPyArg2OptionalValue(hashtable_index_obj, "reindex_graph", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reindex_graph(x, neighbors, count, hashtable_value, hashtable_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "relu", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "relu_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu6(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu6 op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "relu6", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu6(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_renorm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add renorm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "renorm", 0);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 1);
        float p = CastPyArg2Float(p_obj, "renorm", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "renorm", 2);
        PyObject *max_norm_obj = PyTuple_GET_ITEM(args, 3);
        float max_norm = CastPyArg2Float(max_norm_obj, "renorm", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::renorm(x, p, axis, max_norm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_renorm_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add renorm_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "renorm_", 0);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 1);
        float p = CastPyArg2Float(p_obj, "renorm_", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "renorm_", 2);
        PyObject *max_norm_obj = PyTuple_GET_ITEM(args, 3);
        float max_norm = CastPyArg2Float(max_norm_obj, "renorm_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::renorm_(x, p, axis, max_norm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reverse(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reverse op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reverse", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "reverse", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "reverse", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "reverse", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::reverse(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rms_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rms_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rms_norm", 0);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 1);
        auto bias = CastPyArg2OptionalValue(bias_obj, "rms_norm", 1);
        PyObject *residual_obj = PyTuple_GET_ITEM(args, 2);
        auto residual = CastPyArg2OptionalValue(residual_obj, "rms_norm", 2);
        PyObject *norm_weight_obj = PyTuple_GET_ITEM(args, 3);
        auto norm_weight = CastPyArg2Value(norm_weight_obj, "rms_norm", 3);
        PyObject *norm_bias_obj = PyTuple_GET_ITEM(args, 4);
        auto norm_bias = CastPyArg2OptionalValue(norm_bias_obj, "rms_norm", 4);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 5);
        float epsilon = CastPyArg2Float(epsilon_obj, "rms_norm", 5);
        PyObject *begin_norm_axis_obj = PyTuple_GET_ITEM(args, 6);
        int begin_norm_axis = CastPyArg2Int(begin_norm_axis_obj, "rms_norm", 6);
        PyObject *quant_scale_obj = PyTuple_GET_ITEM(args, 7);
        float quant_scale = CastPyArg2Float(quant_scale_obj, "rms_norm", 7);
        PyObject *quant_round_type_obj = PyTuple_GET_ITEM(args, 8);
        int quant_round_type = CastPyArg2Int(quant_round_type_obj, "rms_norm", 8);
        PyObject *quant_max_bound_obj = PyTuple_GET_ITEM(args, 9);
        float quant_max_bound = CastPyArg2Float(quant_max_bound_obj, "rms_norm", 9);
        PyObject *quant_min_bound_obj = PyTuple_GET_ITEM(args, 10);
        float quant_min_bound = CastPyArg2Float(quant_min_bound_obj, "rms_norm", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::rms_norm(x, bias, residual, norm_weight, norm_bias, epsilon, begin_norm_axis, quant_scale, quant_round_type, quant_max_bound, quant_min_bound);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rmsprop_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rmsprop_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "rmsprop_", 0);
        PyObject *mean_square_obj = PyTuple_GET_ITEM(args, 1);
        auto mean_square = CastPyArg2Value(mean_square_obj, "rmsprop_", 1);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad = CastPyArg2Value(grad_obj, "rmsprop_", 2);
        PyObject *moment_obj = PyTuple_GET_ITEM(args, 3);
        auto moment = CastPyArg2Value(moment_obj, "rmsprop_", 3);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 4);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "rmsprop_", 4);
        PyObject *mean_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto mean_grad = CastPyArg2OptionalValue(mean_grad_obj, "rmsprop_", 5);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 6);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "rmsprop_", 6);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "rmsprop_", 7);
        PyObject *decay_obj = PyTuple_GET_ITEM(args, 8);
        float decay = CastPyArg2Float(decay_obj, "rmsprop_", 8);
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 9);
        float momentum = CastPyArg2Float(momentum_obj, "rmsprop_", 9);
        PyObject *centered_obj = PyTuple_GET_ITEM(args, 10);
        bool centered = CastPyArg2Boolean(centered_obj, "rmsprop_", 10);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 11);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "rmsprop_", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::rmsprop_(param, mean_square, grad, moment, learning_rate, mean_grad, master_param, epsilon, decay, momentum, centered, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roi_align(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roi_align op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roi_align", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "roi_align", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "roi_align", 2);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 3);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "roi_align", 3);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 4);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "roi_align", 4);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 5);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "roi_align", 5);
        PyObject *sampling_ratio_obj = PyTuple_GET_ITEM(args, 6);
        int sampling_ratio = CastPyArg2Int(sampling_ratio_obj, "roi_align", 6);
        PyObject *aligned_obj = PyTuple_GET_ITEM(args, 7);
        bool aligned = CastPyArg2Boolean(aligned_obj, "roi_align", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::roi_align(x, boxes, boxes_num, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roi_pool(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roi_pool op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roi_pool", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "roi_pool", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "roi_pool", 2);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 3);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "roi_pool", 3);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 4);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "roi_pool", 4);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 5);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "roi_pool", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::roi_pool(x, boxes, boxes_num, pooled_height, pooled_width, spatial_scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roll(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roll op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roll", 0);

        // Parse Attributes
        PyObject *shifts_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value shifts;

        if (PyObject_CheckIROpResult(shifts_obj)){
             shifts = CastPyArg2Value(shifts_obj, "roll", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(shifts_obj)){
            std::vector<pir::Value> shifts_tmp = CastPyArg2VectorOfValue(shifts_obj, "roll", 1);
            shifts = paddle::dialect::stack(shifts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shifts_tmp = CastPyArg2Longs(shifts_obj, "roll", 1);
            shifts = paddle::dialect::full_int_array(shifts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "roll", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::roll(x, shifts, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_round(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add round op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "round", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::round(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_round_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add round_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "round_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::round_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rsqrt", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rsqrt_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scale(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scale op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "scale", 0);

        // Parse Attributes
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *bias_after_scale_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value scale;

        if (PyObject_CheckIROpResult(scale_obj)){
             scale = CastPyArg2Value(scale_obj, "scale", 1);
        }else{
            float scale_tmp = CastPyArg2Float(scale_obj, "scale", 1);
            scale = paddle::dialect::full(std::vector<int64_t>{1}, scale_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            float bias = CastPyArg2Float(bias_obj, "scale", 2);
            bool bias_after_scale = CastPyArg2Boolean(bias_after_scale_obj, "scale", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::scale(x, scale, bias, bias_after_scale);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scale_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scale_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "scale_", 0);

        // Parse Attributes
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *bias_after_scale_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value scale;

        if (PyObject_CheckIROpResult(scale_obj)){
             scale = CastPyArg2Value(scale_obj, "scale_", 1);
        }else{
            float scale_tmp = CastPyArg2Float(scale_obj, "scale_", 1);
            scale = paddle::dialect::full(std::vector<int64_t>{1}, scale_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            float bias = CastPyArg2Float(bias_obj, "scale_", 2);
            bool bias_after_scale = CastPyArg2Boolean(bias_after_scale_obj, "scale_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::scale_(x, scale, bias, bias_after_scale);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scatter(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scatter op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "scatter", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "scatter", 1);
        PyObject *updates_obj = PyTuple_GET_ITEM(args, 2);
        auto updates = CastPyArg2Value(updates_obj, "scatter", 2);

        // Parse Attributes
        PyObject *overwrite_obj = PyTuple_GET_ITEM(args, 3);
        bool overwrite = CastPyArg2Boolean(overwrite_obj, "scatter", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::scatter(x, index, updates, overwrite);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scatter_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scatter_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "scatter_", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "scatter_", 1);
        PyObject *updates_obj = PyTuple_GET_ITEM(args, 2);
        auto updates = CastPyArg2Value(updates_obj, "scatter_", 2);

        // Parse Attributes
        PyObject *overwrite_obj = PyTuple_GET_ITEM(args, 3);
        bool overwrite = CastPyArg2Boolean(overwrite_obj, "scatter_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::scatter_(x, index, updates, overwrite);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scatter_nd_add(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scatter_nd_add op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "scatter_nd_add", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "scatter_nd_add", 1);
        PyObject *updates_obj = PyTuple_GET_ITEM(args, 2);
        auto updates = CastPyArg2Value(updates_obj, "scatter_nd_add", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::scatter_nd_add(x, index, updates);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_searchsorted(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add searchsorted op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *sorted_sequence_obj = PyTuple_GET_ITEM(args, 0);
        auto sorted_sequence = CastPyArg2Value(sorted_sequence_obj, "searchsorted", 0);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 1);
        auto values = CastPyArg2Value(values_obj, "searchsorted", 1);

        // Parse Attributes
        PyObject *out_int32_obj = PyTuple_GET_ITEM(args, 2);
        bool out_int32 = CastPyArg2Boolean(out_int32_obj, "searchsorted", 2);
        PyObject *right_obj = PyTuple_GET_ITEM(args, 3);
        bool right = CastPyArg2Boolean(right_obj, "searchsorted", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::searchsorted(sorted_sequence, values, out_int32, right);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_segment_pool(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add segment_pool op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "segment_pool", 0);
        PyObject *segment_ids_obj = PyTuple_GET_ITEM(args, 1);
        auto segment_ids = CastPyArg2Value(segment_ids_obj, "segment_pool", 1);

        // Parse Attributes
        PyObject *pooltype_obj = PyTuple_GET_ITEM(args, 2);
        std::string pooltype = CastPyArg2String(pooltype_obj, "segment_pool", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::segment_pool(x, segment_ids, pooltype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_selu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add selu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "selu", 0);

        // Parse Attributes
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        float scale = CastPyArg2Float(scale_obj, "selu", 1);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 2);
        float alpha = CastPyArg2Float(alpha_obj, "selu", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::selu(x, scale, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_u_recv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_u_recv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_u_recv", 0);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 1);
        auto src_index = CastPyArg2Value(src_index_obj, "send_u_recv", 1);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 2);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_u_recv", 2);

        // Parse Attributes
        PyObject *reduce_op_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value out_size;

            std::string reduce_op = CastPyArg2String(reduce_op_obj, "send_u_recv", 3);
        if (PyObject_CheckIROpResult(out_size_obj)){
             out_size = CastPyArg2Value(out_size_obj, "send_u_recv", 4);
        }else if (PyObject_CheckIRVectorOfOpResult(out_size_obj)){
            std::vector<pir::Value> out_size_tmp = CastPyArg2VectorOfValue(out_size_obj, "send_u_recv", 4);
            out_size = paddle::dialect::stack(out_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> out_size_tmp = CastPyArg2Longs(out_size_obj, "send_u_recv", 4);
            out_size = paddle::dialect::full_int_array(out_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::send_u_recv(x, src_index, dst_index, out_size, reduce_op);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_ue_recv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_ue_recv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_ue_recv", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "send_ue_recv", 1);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 2);
        auto src_index = CastPyArg2Value(src_index_obj, "send_ue_recv", 2);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 3);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_ue_recv", 3);

        // Parse Attributes
        PyObject *message_op_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reduce_op_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 6);

        // Check for mutable attrs
       pir::Value out_size;

            std::string message_op = CastPyArg2String(message_op_obj, "send_ue_recv", 4);
            std::string reduce_op = CastPyArg2String(reduce_op_obj, "send_ue_recv", 5);
        if (PyObject_CheckIROpResult(out_size_obj)){
             out_size = CastPyArg2Value(out_size_obj, "send_ue_recv", 6);
        }else if (PyObject_CheckIRVectorOfOpResult(out_size_obj)){
            std::vector<pir::Value> out_size_tmp = CastPyArg2VectorOfValue(out_size_obj, "send_ue_recv", 6);
            out_size = paddle::dialect::stack(out_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> out_size_tmp = CastPyArg2Longs(out_size_obj, "send_ue_recv", 6);
            out_size = paddle::dialect::full_int_array(out_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::send_ue_recv(x, y, src_index, dst_index, out_size, message_op, reduce_op);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_uv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_uv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_uv", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "send_uv", 1);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 2);
        auto src_index = CastPyArg2Value(src_index_obj, "send_uv", 2);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 3);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_uv", 3);

        // Parse Attributes
        PyObject *message_op_obj = PyTuple_GET_ITEM(args, 4);
        std::string message_op = CastPyArg2String(message_op_obj, "send_uv", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::send_uv(x, y, src_index, dst_index, message_op);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sgd_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sgd_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "sgd_", 0);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 1);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "sgd_", 1);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad = CastPyArg2Value(grad_obj, "sgd_", 2);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 3);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "sgd_", 3);

        // Parse Attributes
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 4);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "sgd_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::sgd_(param, learning_rate, grad, master_param, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_shape(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add shape op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "shape", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::shape(input);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_shard_index(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add shard_index op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "shard_index", 0);

        // Parse Attributes
        PyObject *index_num_obj = PyTuple_GET_ITEM(args, 1);
        int index_num = CastPyArg2Int(index_num_obj, "shard_index", 1);
        PyObject *nshards_obj = PyTuple_GET_ITEM(args, 2);
        int nshards = CastPyArg2Int(nshards_obj, "shard_index", 2);
        PyObject *shard_id_obj = PyTuple_GET_ITEM(args, 3);
        int shard_id = CastPyArg2Int(shard_id_obj, "shard_index", 3);
        PyObject *ignore_value_obj = PyTuple_GET_ITEM(args, 4);
        int ignore_value = CastPyArg2Int(ignore_value_obj, "shard_index", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::shard_index(input, index_num, nshards, shard_id, ignore_value);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_cross_entropy_with_logits(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_cross_entropy_with_logits op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid_cross_entropy_with_logits", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "sigmoid_cross_entropy_with_logits", 1);
        PyObject *pos_weight_obj = PyTuple_GET_ITEM(args, 2);
        auto pos_weight = CastPyArg2OptionalValue(pos_weight_obj, "sigmoid_cross_entropy_with_logits", 2);

        // Parse Attributes
        PyObject *normalize_obj = PyTuple_GET_ITEM(args, 3);
        bool normalize = CastPyArg2Boolean(normalize_obj, "sigmoid_cross_entropy_with_logits", 3);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 4);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "sigmoid_cross_entropy_with_logits", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_cross_entropy_with_logits(x, label, pos_weight, normalize, ignore_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_cross_entropy_with_logits_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_cross_entropy_with_logits_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid_cross_entropy_with_logits_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "sigmoid_cross_entropy_with_logits_", 1);
        PyObject *pos_weight_obj = PyTuple_GET_ITEM(args, 2);
        auto pos_weight = CastPyArg2OptionalValue(pos_weight_obj, "sigmoid_cross_entropy_with_logits_", 2);

        // Parse Attributes
        PyObject *normalize_obj = PyTuple_GET_ITEM(args, 3);
        bool normalize = CastPyArg2Boolean(normalize_obj, "sigmoid_cross_entropy_with_logits_", 3);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 4);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "sigmoid_cross_entropy_with_logits_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_cross_entropy_with_logits_(x, label, pos_weight, normalize, ignore_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sign(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sign op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sign", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sign(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_silu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add silu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "silu", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::silu(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sinh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sinh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sinh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sinh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sinh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sinh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sinh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sinh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_slogdet(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add slogdet op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "slogdet", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::slogdet(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softplus(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softplus op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softplus", 0);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 1);
        float beta = CastPyArg2Float(beta_obj, "softplus", 1);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "softplus", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::softplus(x, beta, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softshrink(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softshrink op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softshrink", 0);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 1);
        float threshold = CastPyArg2Float(threshold_obj, "softshrink", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::softshrink(x, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softsign(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softsign op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softsign", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::softsign(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_solve(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add solve op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "solve", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "solve", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::solve(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_spectral_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add spectral_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 0);
        auto weight = CastPyArg2Value(weight_obj, "spectral_norm", 0);
        PyObject *u_obj = PyTuple_GET_ITEM(args, 1);
        auto u = CastPyArg2Value(u_obj, "spectral_norm", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "spectral_norm", 2);

        // Parse Attributes
        PyObject *dim_obj = PyTuple_GET_ITEM(args, 3);
        int dim = CastPyArg2Int(dim_obj, "spectral_norm", 3);
        PyObject *power_iters_obj = PyTuple_GET_ITEM(args, 4);
        int power_iters = CastPyArg2Int(power_iters_obj, "spectral_norm", 4);
        PyObject *eps_obj = PyTuple_GET_ITEM(args, 5);
        float eps = CastPyArg2Float(eps_obj, "spectral_norm", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::spectral_norm(weight, u, v, dim, power_iters, eps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sqrt", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sqrt_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_square(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add square op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "square", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::square(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squared_l2_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squared_l2_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "squared_l2_norm", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::squared_l2_norm(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squeeze(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squeeze op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "squeeze", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "squeeze", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "squeeze", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "squeeze", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::squeeze(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squeeze_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squeeze_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "squeeze_", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "squeeze_", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "squeeze_", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "squeeze_", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::squeeze_(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_stack(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add stack op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "stack", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "stack", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::stack(x, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_stanh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add stanh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "stanh", 0);

        // Parse Attributes
        PyObject *scale_a_obj = PyTuple_GET_ITEM(args, 1);
        float scale_a = CastPyArg2Float(scale_a_obj, "stanh", 1);
        PyObject *scale_b_obj = PyTuple_GET_ITEM(args, 2);
        float scale_b = CastPyArg2Float(scale_b_obj, "stanh", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::stanh(x, scale_a, scale_b);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_svd(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add svd op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "svd", 0);

        // Parse Attributes
        PyObject *full_matrices_obj = PyTuple_GET_ITEM(args, 1);
        bool full_matrices = CastPyArg2Boolean(full_matrices_obj, "svd", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::svd(x, full_matrices);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_take_along_axis(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add take_along_axis op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *arr_obj = PyTuple_GET_ITEM(args, 0);
        auto arr = CastPyArg2Value(arr_obj, "take_along_axis", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "take_along_axis", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "take_along_axis", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::take_along_axis(arr, indices, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tan(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tan op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tan", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tan(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tan_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tan_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tan_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tan_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tanh", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tanh_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_shrink(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_shrink op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tanh_shrink", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_shrink(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_temporal_shift(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add temporal_shift op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "temporal_shift", 0);

        // Parse Attributes
        PyObject *seg_num_obj = PyTuple_GET_ITEM(args, 1);
        int seg_num = CastPyArg2Int(seg_num_obj, "temporal_shift", 1);
        PyObject *shift_ratio_obj = PyTuple_GET_ITEM(args, 2);
        float shift_ratio = CastPyArg2Float(shift_ratio_obj, "temporal_shift", 2);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 3);
        std::string data_format = CastPyArg2String(data_format_obj, "temporal_shift", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::temporal_shift(x, seg_num, shift_ratio, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tensor_unfold(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tensor_unfold op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "tensor_unfold", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int64_t axis = CastPyArg2Long(axis_obj, "tensor_unfold", 1);
        PyObject *size_obj = PyTuple_GET_ITEM(args, 2);
        int64_t size = CastPyArg2Long(size_obj, "tensor_unfold", 2);
        PyObject *step_obj = PyTuple_GET_ITEM(args, 3);
        int64_t step = CastPyArg2Long(step_obj, "tensor_unfold", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::tensor_unfold(input, axis, size, step);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_thresholded_relu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add thresholded_relu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "thresholded_relu", 0);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 1);
        float threshold = CastPyArg2Float(threshold_obj, "thresholded_relu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::thresholded_relu(x, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_thresholded_relu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add thresholded_relu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "thresholded_relu_", 0);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 1);
        float threshold = CastPyArg2Float(threshold_obj, "thresholded_relu_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::thresholded_relu_(x, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_top_p_sampling(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add top_p_sampling op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "top_p_sampling", 0);
        PyObject *ps_obj = PyTuple_GET_ITEM(args, 1);
        auto ps = CastPyArg2Value(ps_obj, "top_p_sampling", 1);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        auto threshold = CastPyArg2OptionalValue(threshold_obj, "top_p_sampling", 2);

        // Parse Attributes
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "top_p_sampling", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::top_p_sampling(x, ps, threshold, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_topk(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add topk op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "topk", 0);

        // Parse Attributes
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *largest_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *sorted_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value k;

        if (PyObject_CheckIROpResult(k_obj)){
             k = CastPyArg2Value(k_obj, "topk", 1);
        }else{
            int k_tmp = CastPyArg2Int(k_obj, "topk", 1);
            k = paddle::dialect::full(std::vector<int64_t>{1}, k_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            int axis = CastPyArg2Int(axis_obj, "topk", 2);
            bool largest = CastPyArg2Boolean(largest_obj, "topk", 3);
            bool sorted = CastPyArg2Boolean(sorted_obj, "topk", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::topk(x, k, axis, largest, sorted);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trace(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trace op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "trace", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int offset = CastPyArg2Int(offset_obj, "trace", 1);
        PyObject *axis1_obj = PyTuple_GET_ITEM(args, 2);
        int axis1 = CastPyArg2Int(axis1_obj, "trace", 2);
        PyObject *axis2_obj = PyTuple_GET_ITEM(args, 3);
        int axis2 = CastPyArg2Int(axis2_obj, "trace", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::trace(x, offset, axis1, axis2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_triangular_solve(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add triangular_solve op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "triangular_solve", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "triangular_solve", 1);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 2);
        bool upper = CastPyArg2Boolean(upper_obj, "triangular_solve", 2);
        PyObject *transpose_obj = PyTuple_GET_ITEM(args, 3);
        bool transpose = CastPyArg2Boolean(transpose_obj, "triangular_solve", 3);
        PyObject *unitriangular_obj = PyTuple_GET_ITEM(args, 4);
        bool unitriangular = CastPyArg2Boolean(unitriangular_obj, "triangular_solve", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::triangular_solve(x, y, upper, transpose, unitriangular);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trilinear_interp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trilinear_interp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "trilinear_interp", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "trilinear_interp", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "trilinear_interp", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "trilinear_interp", 3);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 4);
        std::string data_layout = CastPyArg2String(data_layout_obj, "trilinear_interp", 4);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 5);
        int out_d = CastPyArg2Int(out_d_obj, "trilinear_interp", 5);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 6);
        int out_h = CastPyArg2Int(out_h_obj, "trilinear_interp", 6);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 7);
        int out_w = CastPyArg2Int(out_w_obj, "trilinear_interp", 7);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "trilinear_interp", 8);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 9);
        std::string interp_method = CastPyArg2String(interp_method_obj, "trilinear_interp", 9);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 10);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "trilinear_interp", 10);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 11);
        int align_mode = CastPyArg2Int(align_mode_obj, "trilinear_interp", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::trilinear_interp(x, out_size, size_tensor, scale_tensor, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trunc(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trunc op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "trunc", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::trunc(input);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trunc_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trunc_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "trunc_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::trunc_(input);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unbind(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unbind op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "unbind", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "unbind", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::unbind(input, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unfold(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unfold op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unfold", 0);

        // Parse Attributes
        PyObject *kernel_sizes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> kernel_sizes = CastPyArg2Ints(kernel_sizes_obj, "unfold", 1);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "unfold", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "unfold", 3);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "unfold", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::unfold(x, kernel_sizes, strides, paddings, dilations);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_uniform_inplace(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add uniform_inplace op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "uniform_inplace", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        float min = CastPyArg2Float(min_obj, "uniform_inplace", 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);
        float max = CastPyArg2Float(max_obj, "uniform_inplace", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "uniform_inplace", 3);
        PyObject *diag_num_obj = PyTuple_GET_ITEM(args, 4);
        int diag_num = CastPyArg2Int(diag_num_obj, "uniform_inplace", 4);
        PyObject *diag_step_obj = PyTuple_GET_ITEM(args, 5);
        int diag_step = CastPyArg2Int(diag_step_obj, "uniform_inplace", 5);
        PyObject *diag_val_obj = PyTuple_GET_ITEM(args, 6);
        float diag_val = CastPyArg2Float(diag_val_obj, "uniform_inplace", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::uniform_inplace(x, min, max, seed, diag_num, diag_step, diag_val);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_uniform_inplace_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add uniform_inplace_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "uniform_inplace_", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        float min = CastPyArg2Float(min_obj, "uniform_inplace_", 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);
        float max = CastPyArg2Float(max_obj, "uniform_inplace_", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "uniform_inplace_", 3);
        PyObject *diag_num_obj = PyTuple_GET_ITEM(args, 4);
        int diag_num = CastPyArg2Int(diag_num_obj, "uniform_inplace_", 4);
        PyObject *diag_step_obj = PyTuple_GET_ITEM(args, 5);
        int diag_step = CastPyArg2Int(diag_step_obj, "uniform_inplace_", 5);
        PyObject *diag_val_obj = PyTuple_GET_ITEM(args, 6);
        float diag_val = CastPyArg2Float(diag_val_obj, "uniform_inplace_", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::uniform_inplace_(x, min, max, seed, diag_num, diag_step, diag_val);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unique_consecutive(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unique_consecutive op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unique_consecutive", 0);

        // Parse Attributes
        PyObject *return_inverse_obj = PyTuple_GET_ITEM(args, 1);
        bool return_inverse = CastPyArg2Boolean(return_inverse_obj, "unique_consecutive", 1);
        PyObject *return_counts_obj = PyTuple_GET_ITEM(args, 2);
        bool return_counts = CastPyArg2Boolean(return_counts_obj, "unique_consecutive", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> axis = CastPyArg2Ints(axis_obj, "unique_consecutive", 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "unique_consecutive", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::unique_consecutive(x, return_inverse, return_counts, axis, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unpool3d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unpool3d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unpool3d", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "unpool3d", 1);

        // Parse Attributes
        PyObject *ksize_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> ksize = CastPyArg2Ints(ksize_obj, "unpool3d", 2);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "unpool3d", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "unpool3d", 4);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> output_size = CastPyArg2Ints(output_size_obj, "unpool3d", 5);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 6);
        std::string data_format = CastPyArg2String(data_format_obj, "unpool3d", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::unpool3d(x, indices, ksize, strides, paddings, output_size, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unsqueeze(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unsqueeze op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unsqueeze", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "unsqueeze", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "unsqueeze", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "unsqueeze", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::unsqueeze(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unsqueeze_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unsqueeze_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unsqueeze_", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "unsqueeze_", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "unsqueeze_", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "unsqueeze_", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::unsqueeze_(x, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unstack(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unstack op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unstack", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "unstack", 1);
        PyObject *num_obj = PyTuple_GET_ITEM(args, 2);
        int num = CastPyArg2Int(num_obj, "unstack", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::unstack(x, axis, num);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_update_loss_scaling_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add update_loss_scaling_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "update_loss_scaling_", 0);
        PyObject *found_infinite_obj = PyTuple_GET_ITEM(args, 1);
        auto found_infinite = CastPyArg2Value(found_infinite_obj, "update_loss_scaling_", 1);
        PyObject *prev_loss_scaling_obj = PyTuple_GET_ITEM(args, 2);
        auto prev_loss_scaling = CastPyArg2Value(prev_loss_scaling_obj, "update_loss_scaling_", 2);
        PyObject *in_good_steps_obj = PyTuple_GET_ITEM(args, 3);
        auto in_good_steps = CastPyArg2Value(in_good_steps_obj, "update_loss_scaling_", 3);
        PyObject *in_bad_steps_obj = PyTuple_GET_ITEM(args, 4);
        auto in_bad_steps = CastPyArg2Value(in_bad_steps_obj, "update_loss_scaling_", 4);

        // Parse Attributes
        PyObject *incr_every_n_steps_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *decr_every_n_nan_or_inf_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *incr_ratio_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *decr_ratio_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *stop_update_obj = PyTuple_GET_ITEM(args, 9);

        // Check for mutable attrs
       pir::Value stop_update;

            int incr_every_n_steps = CastPyArg2Int(incr_every_n_steps_obj, "update_loss_scaling_", 5);
            int decr_every_n_nan_or_inf = CastPyArg2Int(decr_every_n_nan_or_inf_obj, "update_loss_scaling_", 6);
            float incr_ratio = CastPyArg2Float(incr_ratio_obj, "update_loss_scaling_", 7);
            float decr_ratio = CastPyArg2Float(decr_ratio_obj, "update_loss_scaling_", 8);
        if (PyObject_CheckIROpResult(stop_update_obj)){
             stop_update = CastPyArg2Value(stop_update_obj, "update_loss_scaling_", 9);
        }else{
            bool stop_update_tmp = CastPyArg2Boolean(stop_update_obj, "update_loss_scaling_", 9);
            stop_update = paddle::dialect::full(std::vector<int64_t>{1}, stop_update_tmp, phi::DataType::BOOL, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::update_loss_scaling_(x, found_infinite, prev_loss_scaling, in_good_steps, in_bad_steps, stop_update, incr_every_n_steps, decr_every_n_nan_or_inf, incr_ratio, decr_ratio);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_variable_length_memory_efficient_attention(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add variable_length_memory_efficient_attention op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *query_obj = PyTuple_GET_ITEM(args, 0);
        auto query = CastPyArg2Value(query_obj, "variable_length_memory_efficient_attention", 0);
        PyObject *key_obj = PyTuple_GET_ITEM(args, 1);
        auto key = CastPyArg2Value(key_obj, "variable_length_memory_efficient_attention", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "variable_length_memory_efficient_attention", 2);
        PyObject *seq_lens_obj = PyTuple_GET_ITEM(args, 3);
        auto seq_lens = CastPyArg2Value(seq_lens_obj, "variable_length_memory_efficient_attention", 3);
        PyObject *kv_seq_lens_obj = PyTuple_GET_ITEM(args, 4);
        auto kv_seq_lens = CastPyArg2Value(kv_seq_lens_obj, "variable_length_memory_efficient_attention", 4);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 5);
        auto mask = CastPyArg2OptionalValue(mask_obj, "variable_length_memory_efficient_attention", 5);

        // Parse Attributes
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 6);
        float scale = CastPyArg2Float(scale_obj, "variable_length_memory_efficient_attention", 6);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 7);
        bool causal = CastPyArg2Boolean(causal_obj, "variable_length_memory_efficient_attention", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::variable_length_memory_efficient_attention(query, key, value, seq_lens, kv_seq_lens, mask, scale, causal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_view_dtype(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add view_dtype op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "view_dtype", 0);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "view_dtype", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::view_dtype(input, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_view_shape(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add view_shape op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "view_shape", 0);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> dims = CastPyArg2Longs(dims_obj, "view_shape", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::view_shape(input, dims);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_viterbi_decode(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add viterbi_decode op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *potentials_obj = PyTuple_GET_ITEM(args, 0);
        auto potentials = CastPyArg2Value(potentials_obj, "viterbi_decode", 0);
        PyObject *transition_params_obj = PyTuple_GET_ITEM(args, 1);
        auto transition_params = CastPyArg2Value(transition_params_obj, "viterbi_decode", 1);
        PyObject *lengths_obj = PyTuple_GET_ITEM(args, 2);
        auto lengths = CastPyArg2Value(lengths_obj, "viterbi_decode", 2);

        // Parse Attributes
        PyObject *include_bos_eos_tag_obj = PyTuple_GET_ITEM(args, 3);
        bool include_bos_eos_tag = CastPyArg2Boolean(include_bos_eos_tag_obj, "viterbi_decode", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::viterbi_decode(potentials, transition_params, lengths, include_bos_eos_tag);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_warpctc(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add warpctc op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *logits_obj = PyTuple_GET_ITEM(args, 0);
        auto logits = CastPyArg2Value(logits_obj, "warpctc", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "warpctc", 1);
        PyObject *logits_length_obj = PyTuple_GET_ITEM(args, 2);
        auto logits_length = CastPyArg2OptionalValue(logits_length_obj, "warpctc", 2);
        PyObject *labels_length_obj = PyTuple_GET_ITEM(args, 3);
        auto labels_length = CastPyArg2OptionalValue(labels_length_obj, "warpctc", 3);

        // Parse Attributes
        PyObject *blank_obj = PyTuple_GET_ITEM(args, 4);
        int blank = CastPyArg2Int(blank_obj, "warpctc", 4);
        PyObject *norm_by_times_obj = PyTuple_GET_ITEM(args, 5);
        bool norm_by_times = CastPyArg2Boolean(norm_by_times_obj, "warpctc", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::warpctc(logits, label, logits_length, labels_length, blank, norm_by_times);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_warprnnt(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add warprnnt op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "warprnnt", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "warprnnt", 1);
        PyObject *input_lengths_obj = PyTuple_GET_ITEM(args, 2);
        auto input_lengths = CastPyArg2Value(input_lengths_obj, "warprnnt", 2);
        PyObject *label_lengths_obj = PyTuple_GET_ITEM(args, 3);
        auto label_lengths = CastPyArg2Value(label_lengths_obj, "warprnnt", 3);

        // Parse Attributes
        PyObject *blank_obj = PyTuple_GET_ITEM(args, 4);
        int blank = CastPyArg2Int(blank_obj, "warprnnt", 4);
        PyObject *fastemit_lambda_obj = PyTuple_GET_ITEM(args, 5);
        float fastemit_lambda = CastPyArg2Float(fastemit_lambda_obj, "warprnnt", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::warprnnt(input, label, input_lengths, label_lengths, blank, fastemit_lambda);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_weight_dequantize(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add weight_dequantize op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "weight_dequantize", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "weight_dequantize", 1);

        // Parse Attributes
        PyObject *algo_obj = PyTuple_GET_ITEM(args, 2);
        std::string algo = CastPyArg2String(algo_obj, "weight_dequantize", 2);
        PyObject *out_dtype_obj = PyTuple_GET_ITEM(args, 3);
        phi::DataType out_dtype = CastPyArg2DataTypeDirectly(out_dtype_obj, "weight_dequantize", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::weight_dequantize(x, scale, algo, out_dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_weight_only_linear(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add weight_only_linear op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "weight_only_linear", 0);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 1);
        auto weight = CastPyArg2Value(weight_obj, "weight_only_linear", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "weight_only_linear", 2);
        PyObject *weight_scale_obj = PyTuple_GET_ITEM(args, 3);
        auto weight_scale = CastPyArg2Value(weight_scale_obj, "weight_only_linear", 3);

        // Parse Attributes
        PyObject *weight_dtype_obj = PyTuple_GET_ITEM(args, 4);
        std::string weight_dtype = CastPyArg2String(weight_dtype_obj, "weight_only_linear", 4);
        PyObject *arch_obj = PyTuple_GET_ITEM(args, 5);
        int arch = CastPyArg2Int(arch_obj, "weight_only_linear", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::weight_only_linear(x, weight, bias, weight_scale, weight_dtype, arch);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_weight_quantize(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add weight_quantize op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "weight_quantize", 0);

        // Parse Attributes
        PyObject *algo_obj = PyTuple_GET_ITEM(args, 1);
        std::string algo = CastPyArg2String(algo_obj, "weight_quantize", 1);
        PyObject *arch_obj = PyTuple_GET_ITEM(args, 2);
        int arch = CastPyArg2Int(arch_obj, "weight_quantize", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::weight_quantize(x, algo, arch);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_weighted_sample_neighbors(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add weighted_sample_neighbors op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *row_obj = PyTuple_GET_ITEM(args, 0);
        auto row = CastPyArg2Value(row_obj, "weighted_sample_neighbors", 0);
        PyObject *colptr_obj = PyTuple_GET_ITEM(args, 1);
        auto colptr = CastPyArg2Value(colptr_obj, "weighted_sample_neighbors", 1);
        PyObject *edge_weight_obj = PyTuple_GET_ITEM(args, 2);
        auto edge_weight = CastPyArg2Value(edge_weight_obj, "weighted_sample_neighbors", 2);
        PyObject *input_nodes_obj = PyTuple_GET_ITEM(args, 3);
        auto input_nodes = CastPyArg2Value(input_nodes_obj, "weighted_sample_neighbors", 3);
        PyObject *eids_obj = PyTuple_GET_ITEM(args, 4);
        auto eids = CastPyArg2OptionalValue(eids_obj, "weighted_sample_neighbors", 4);

        // Parse Attributes
        PyObject *sample_size_obj = PyTuple_GET_ITEM(args, 5);
        int sample_size = CastPyArg2Int(sample_size_obj, "weighted_sample_neighbors", 5);
        PyObject *return_eids_obj = PyTuple_GET_ITEM(args, 6);
        bool return_eids = CastPyArg2Boolean(return_eids_obj, "weighted_sample_neighbors", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::weighted_sample_neighbors(row, colptr, edge_weight, input_nodes, eids, sample_size, return_eids);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_where(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add where op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *condition_obj = PyTuple_GET_ITEM(args, 0);
        auto condition = CastPyArg2Value(condition_obj, "where", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "where", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "where", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::where(condition, x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_where_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add where_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *condition_obj = PyTuple_GET_ITEM(args, 0);
        auto condition = CastPyArg2Value(condition_obj, "where_", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "where_", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "where_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::where_(condition, x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_yolo_box(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add yolo_box op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "yolo_box", 0);
        PyObject *img_size_obj = PyTuple_GET_ITEM(args, 1);
        auto img_size = CastPyArg2Value(img_size_obj, "yolo_box", 1);

        // Parse Attributes
        PyObject *anchors_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> anchors = CastPyArg2Ints(anchors_obj, "yolo_box", 2);
        PyObject *class_num_obj = PyTuple_GET_ITEM(args, 3);
        int class_num = CastPyArg2Int(class_num_obj, "yolo_box", 3);
        PyObject *conf_thresh_obj = PyTuple_GET_ITEM(args, 4);
        float conf_thresh = CastPyArg2Float(conf_thresh_obj, "yolo_box", 4);
        PyObject *downsample_ratio_obj = PyTuple_GET_ITEM(args, 5);
        int downsample_ratio = CastPyArg2Int(downsample_ratio_obj, "yolo_box", 5);
        PyObject *clip_bbox_obj = PyTuple_GET_ITEM(args, 6);
        bool clip_bbox = CastPyArg2Boolean(clip_bbox_obj, "yolo_box", 6);
        PyObject *scale_x_y_obj = PyTuple_GET_ITEM(args, 7);
        float scale_x_y = CastPyArg2Float(scale_x_y_obj, "yolo_box", 7);
        PyObject *iou_aware_obj = PyTuple_GET_ITEM(args, 8);
        bool iou_aware = CastPyArg2Boolean(iou_aware_obj, "yolo_box", 8);
        PyObject *iou_aware_factor_obj = PyTuple_GET_ITEM(args, 9);
        float iou_aware_factor = CastPyArg2Float(iou_aware_factor_obj, "yolo_box", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::yolo_box(x, img_size, anchors, class_num, conf_thresh, downsample_ratio, clip_bbox, scale_x_y, iou_aware, iou_aware_factor);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_yolo_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add yolo_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "yolo_loss", 0);
        PyObject *gt_box_obj = PyTuple_GET_ITEM(args, 1);
        auto gt_box = CastPyArg2Value(gt_box_obj, "yolo_loss", 1);
        PyObject *gt_label_obj = PyTuple_GET_ITEM(args, 2);
        auto gt_label = CastPyArg2Value(gt_label_obj, "yolo_loss", 2);
        PyObject *gt_score_obj = PyTuple_GET_ITEM(args, 3);
        auto gt_score = CastPyArg2OptionalValue(gt_score_obj, "yolo_loss", 3);

        // Parse Attributes
        PyObject *anchors_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> anchors = CastPyArg2Ints(anchors_obj, "yolo_loss", 4);
        PyObject *anchor_mask_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> anchor_mask = CastPyArg2Ints(anchor_mask_obj, "yolo_loss", 5);
        PyObject *class_num_obj = PyTuple_GET_ITEM(args, 6);
        int class_num = CastPyArg2Int(class_num_obj, "yolo_loss", 6);
        PyObject *ignore_thresh_obj = PyTuple_GET_ITEM(args, 7);
        float ignore_thresh = CastPyArg2Float(ignore_thresh_obj, "yolo_loss", 7);
        PyObject *downsample_ratio_obj = PyTuple_GET_ITEM(args, 8);
        int downsample_ratio = CastPyArg2Int(downsample_ratio_obj, "yolo_loss", 8);
        PyObject *use_label_smooth_obj = PyTuple_GET_ITEM(args, 9);
        bool use_label_smooth = CastPyArg2Boolean(use_label_smooth_obj, "yolo_loss", 9);
        PyObject *scale_x_y_obj = PyTuple_GET_ITEM(args, 10);
        float scale_x_y = CastPyArg2Float(scale_x_y_obj, "yolo_loss", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::yolo_loss(x, gt_box, gt_label, gt_score, anchors, anchor_mask, class_num, ignore_thresh, downsample_ratio, use_label_smooth, scale_x_y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_adadelta_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add adadelta_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *param_obj = PyTuple_GET_ITEM(args, 0);
        auto param = CastPyArg2Value(param_obj, "adadelta_", 0);
        PyObject *grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad = CastPyArg2Value(grad_obj, "adadelta_", 1);
        PyObject *avg_squared_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto avg_squared_grad = CastPyArg2Value(avg_squared_grad_obj, "adadelta_", 2);
        PyObject *avg_squared_update_obj = PyTuple_GET_ITEM(args, 3);
        auto avg_squared_update = CastPyArg2Value(avg_squared_update_obj, "adadelta_", 3);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 4);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "adadelta_", 4);
        PyObject *master_param_obj = PyTuple_GET_ITEM(args, 5);
        auto master_param = CastPyArg2OptionalValue(master_param_obj, "adadelta_", 5);

        // Parse Attributes
        PyObject *rho_obj = PyTuple_GET_ITEM(args, 6);
        float rho = CastPyArg2Float(rho_obj, "adadelta_", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "adadelta_", 7);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 8);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "adadelta_", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::adadelta_(param, grad, avg_squared_grad, avg_squared_update, learning_rate, master_param, rho, epsilon, multi_precision);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "add", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "add", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::add(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "add_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "add_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::add_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_n(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_n op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *inputs_obj = PyTuple_GET_ITEM(args, 0);
        auto inputs = CastPyArg2VectorOfValue(inputs_obj, "add_n", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::add_n(inputs);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_all(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add all op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "all", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "all", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "all", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::all(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_amax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add amax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "amax", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "amax", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "amax", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::amax(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_amin(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add amin op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "amin", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "amin", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "amin", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::amin(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_any(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add any op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "any", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "any", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "any", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::any(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_arange(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add arange op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *start_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *end_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *step_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value start;

       pir::Value end;

       pir::Value step;

        if (PyObject_CheckIROpResult(start_obj)){
             start = CastPyArg2Value(start_obj, "arange", 0);
        }else{
            float start_tmp = CastPyArg2Float(start_obj, "arange", 0);
            start = paddle::dialect::full(std::vector<int64_t>{1}, start_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(end_obj)){
             end = CastPyArg2Value(end_obj, "arange", 1);
        }else{
            float end_tmp = CastPyArg2Float(end_obj, "arange", 1);
            end = paddle::dialect::full(std::vector<int64_t>{1}, end_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(step_obj)){
             step = CastPyArg2Value(step_obj, "arange", 2);
        }else{
            float step_tmp = CastPyArg2Float(step_obj, "arange", 2);
            step = paddle::dialect::full(std::vector<int64_t>{1}, step_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "arange", 3);
            Place place = CastPyArg2Place(place_obj, "arange", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::arange(start, end, step, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "assign", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::assign(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "assign_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::assign_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign_out_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign_out_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "assign_out_", 0);
        PyObject *output_obj = PyTuple_GET_ITEM(args, 1);
        auto output = CastPyArg2Value(output_obj, "assign_out_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::assign_out_(x, output);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign_value_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign_value_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *output_obj = PyTuple_GET_ITEM(args, 0);
        auto output = CastPyArg2Value(output_obj, "assign_value_", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> shape = CastPyArg2Ints(shape_obj, "assign_value_", 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "assign_value_", 2);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<phi::Scalar> values = CastPyArg2ScalarArray(values_obj, "assign_value_", 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);
        Place place = CastPyArg2Place(place_obj, "assign_value_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::assign_value_(output, shape, dtype, values, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_batch_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add batch_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "batch_norm", 0);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        auto mean = CastPyArg2Value(mean_obj, "batch_norm", 1);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 2);
        auto variance = CastPyArg2Value(variance_obj, "batch_norm", 2);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 3);
        auto scale = CastPyArg2OptionalValue(scale_obj, "batch_norm", 3);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 4);
        auto bias = CastPyArg2OptionalValue(bias_obj, "batch_norm", 4);

        // Parse Attributes
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 5);
        bool is_test = CastPyArg2Boolean(is_test_obj, "batch_norm", 5);
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 6);
        float momentum = CastPyArg2Float(momentum_obj, "batch_norm", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "batch_norm", 7);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_layout = CastPyArg2String(data_layout_obj, "batch_norm", 8);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 9);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "batch_norm", 9);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 10);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "batch_norm", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::batch_norm(x, mean, variance, scale, bias, is_test, momentum, epsilon, data_layout, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_batch_norm_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add batch_norm_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "batch_norm_", 0);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        auto mean = CastPyArg2Value(mean_obj, "batch_norm_", 1);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 2);
        auto variance = CastPyArg2Value(variance_obj, "batch_norm_", 2);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 3);
        auto scale = CastPyArg2OptionalValue(scale_obj, "batch_norm_", 3);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 4);
        auto bias = CastPyArg2OptionalValue(bias_obj, "batch_norm_", 4);

        // Parse Attributes
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 5);
        bool is_test = CastPyArg2Boolean(is_test_obj, "batch_norm_", 5);
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 6);
        float momentum = CastPyArg2Float(momentum_obj, "batch_norm_", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "batch_norm_", 7);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_layout = CastPyArg2String(data_layout_obj, "batch_norm_", 8);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 9);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "batch_norm_", 9);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 10);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "batch_norm_", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::batch_norm_(x, mean, variance, scale, bias, is_test, momentum, epsilon, data_layout, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_allgather(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_allgather op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_allgather", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_allgather", 1);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 2);
        int nranks = CastPyArg2Int(nranks_obj, "c_allgather", 2);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 3);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_allgather", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_allgather(x, ring_id, nranks, use_calc_stream);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_allreduce_max(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_allreduce_max op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_allreduce_max", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_allreduce_max", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_allreduce_max", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_allreduce_max", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_allreduce_max(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_allreduce_max_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_allreduce_max_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_allreduce_max_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_allreduce_max_", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_allreduce_max_", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_allreduce_max_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_allreduce_max_(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_allreduce_sum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_allreduce_sum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_allreduce_sum", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_allreduce_sum", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_allreduce_sum", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_allreduce_sum", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_allreduce_sum(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_allreduce_sum_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_allreduce_sum_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_allreduce_sum_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_allreduce_sum_", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_allreduce_sum_", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_allreduce_sum_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_allreduce_sum_(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_broadcast(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_broadcast op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_broadcast", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_broadcast", 1);
        PyObject *root_obj = PyTuple_GET_ITEM(args, 2);
        int root = CastPyArg2Int(root_obj, "c_broadcast", 2);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 3);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_broadcast", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_broadcast(x, ring_id, root, use_calc_stream);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_broadcast_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_broadcast_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_broadcast_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_broadcast_", 1);
        PyObject *root_obj = PyTuple_GET_ITEM(args, 2);
        int root = CastPyArg2Int(root_obj, "c_broadcast_", 2);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 3);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_broadcast_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_broadcast_(x, ring_id, root, use_calc_stream);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_concat(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_concat op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_concat", 0);

        // Parse Attributes
        PyObject *rank_obj = PyTuple_GET_ITEM(args, 1);
        int rank = CastPyArg2Int(rank_obj, "c_concat", 1);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 2);
        int nranks = CastPyArg2Int(nranks_obj, "c_concat", 2);
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 3);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_concat", 3);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 4);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_concat", 4);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 5);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_concat", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_concat(x, rank, nranks, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_embedding(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_embedding op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 0);
        auto weight = CastPyArg2Value(weight_obj, "c_embedding", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "c_embedding", 1);

        // Parse Attributes
        PyObject *start_index_obj = PyTuple_GET_ITEM(args, 2);
        int64_t start_index = CastPyArg2Long(start_index_obj, "c_embedding", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_embedding(weight, x, start_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_identity(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_identity op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_identity", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_identity", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_identity", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_identity", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_identity(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_identity_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_identity_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_identity_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_identity_", 1);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 2);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_identity_", 2);
        PyObject *use_model_parallel_obj = PyTuple_GET_ITEM(args, 3);
        bool use_model_parallel = CastPyArg2Boolean(use_model_parallel_obj, "c_identity_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_identity_(x, ring_id, use_calc_stream, use_model_parallel);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_reduce_sum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_reduce_sum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_reduce_sum", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_reduce_sum", 1);
        PyObject *root_id_obj = PyTuple_GET_ITEM(args, 2);
        int root_id = CastPyArg2Int(root_id_obj, "c_reduce_sum", 2);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 3);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_reduce_sum", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_reduce_sum(x, ring_id, root_id, use_calc_stream);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_reduce_sum_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_reduce_sum_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_reduce_sum_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_reduce_sum_", 1);
        PyObject *root_id_obj = PyTuple_GET_ITEM(args, 2);
        int root_id = CastPyArg2Int(root_id_obj, "c_reduce_sum_", 2);
        PyObject *use_calc_stream_obj = PyTuple_GET_ITEM(args, 3);
        bool use_calc_stream = CastPyArg2Boolean(use_calc_stream_obj, "c_reduce_sum_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_reduce_sum_(x, ring_id, root_id, use_calc_stream);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_sync_calc_stream(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_sync_calc_stream op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_sync_calc_stream", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::c_sync_calc_stream(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_sync_calc_stream_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_sync_calc_stream_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_sync_calc_stream_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::c_sync_calc_stream_(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_sync_comm_stream(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_sync_comm_stream op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_sync_comm_stream", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_sync_comm_stream", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_sync_comm_stream(x, ring_id);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_sync_comm_stream_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_sync_comm_stream_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "c_sync_comm_stream_", 0);

        // Parse Attributes
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 1);
        int ring_id = CastPyArg2Int(ring_id_obj, "c_sync_comm_stream_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_sync_comm_stream_(x, ring_id);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cast(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cast op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cast", 0);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cast", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::cast(x, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cast_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cast_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cast_", 0);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cast_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::cast_(x, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_channel_shuffle(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add channel_shuffle op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "channel_shuffle", 0);

        // Parse Attributes
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 1);
        int groups = CastPyArg2Int(groups_obj, "channel_shuffle", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "channel_shuffle", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::channel_shuffle(x, groups, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d_transpose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d_transpose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conv2d_transpose", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d_transpose", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 9);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d_transpose", 2);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d_transpose", 3);
            std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "conv2d_transpose", 4);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "conv2d_transpose", 5);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "conv2d_transpose", 5);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "conv2d_transpose", 5);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d_transpose", 6);
            int groups = CastPyArg2Int(groups_obj, "conv2d_transpose", 7);
            std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d_transpose", 8);
            std::string data_format = CastPyArg2String(data_format_obj, "conv2d_transpose", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d_transpose(x, filter, output_size, strides, paddings, output_padding, padding_algorithm, groups, dilations, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_decode_jpeg(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add decode_jpeg op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "decode_jpeg", 0);

        // Parse Attributes
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 1);
        std::string mode = CastPyArg2String(mode_obj, "decode_jpeg", 1);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 2);
        Place place = CastPyArg2Place(place_obj, "decode_jpeg", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::decode_jpeg(x, mode, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_deformable_conv(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add deformable_conv op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "deformable_conv", 0);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        auto offset = CastPyArg2Value(offset_obj, "deformable_conv", 1);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 2);
        auto filter = CastPyArg2Value(filter_obj, "deformable_conv", 2);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 3);
        auto mask = CastPyArg2OptionalValue(mask_obj, "deformable_conv", 3);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "deformable_conv", 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "deformable_conv", 5);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "deformable_conv", 6);
        PyObject *deformable_groups_obj = PyTuple_GET_ITEM(args, 7);
        int deformable_groups = CastPyArg2Int(deformable_groups_obj, "deformable_conv", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "deformable_conv", 8);
        PyObject *im2col_step_obj = PyTuple_GET_ITEM(args, 9);
        int im2col_step = CastPyArg2Int(im2col_step_obj, "deformable_conv", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::deformable_conv(x, offset, filter, mask, strides, paddings, dilations, deformable_groups, groups, im2col_step);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_depthwise_conv2d_transpose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add depthwise_conv2d_transpose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "depthwise_conv2d_transpose", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "depthwise_conv2d_transpose", 1);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 9);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> strides = CastPyArg2Ints(strides_obj, "depthwise_conv2d_transpose", 2);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "depthwise_conv2d_transpose", 3);
            std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "depthwise_conv2d_transpose", 4);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "depthwise_conv2d_transpose", 5);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "depthwise_conv2d_transpose", 5);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "depthwise_conv2d_transpose", 5);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "depthwise_conv2d_transpose", 6);
            int groups = CastPyArg2Int(groups_obj, "depthwise_conv2d_transpose", 7);
            std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "depthwise_conv2d_transpose", 8);
            std::string data_format = CastPyArg2String(data_format_obj, "depthwise_conv2d_transpose", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::depthwise_conv2d_transpose(x, filter, output_size, strides, paddings, output_padding, padding_algorithm, groups, dilations, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_disable_check_model_nan_inf(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add disable_check_model_nan_inf op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "disable_check_model_nan_inf", 0);

        // Parse Attributes
        PyObject *flag_obj = PyTuple_GET_ITEM(args, 1);
        int flag = CastPyArg2Int(flag_obj, "disable_check_model_nan_inf", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::disable_check_model_nan_inf(x, flag);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_distribute_fpn_proposals(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add distribute_fpn_proposals op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *fpn_rois_obj = PyTuple_GET_ITEM(args, 0);
        auto fpn_rois = CastPyArg2Value(fpn_rois_obj, "distribute_fpn_proposals", 0);
        PyObject *rois_num_obj = PyTuple_GET_ITEM(args, 1);
        auto rois_num = CastPyArg2OptionalValue(rois_num_obj, "distribute_fpn_proposals", 1);

        // Parse Attributes
        PyObject *min_level_obj = PyTuple_GET_ITEM(args, 2);
        int min_level = CastPyArg2Int(min_level_obj, "distribute_fpn_proposals", 2);
        PyObject *max_level_obj = PyTuple_GET_ITEM(args, 3);
        int max_level = CastPyArg2Int(max_level_obj, "distribute_fpn_proposals", 3);
        PyObject *refer_level_obj = PyTuple_GET_ITEM(args, 4);
        int refer_level = CastPyArg2Int(refer_level_obj, "distribute_fpn_proposals", 4);
        PyObject *refer_scale_obj = PyTuple_GET_ITEM(args, 5);
        int refer_scale = CastPyArg2Int(refer_scale_obj, "distribute_fpn_proposals", 5);
        PyObject *pixel_offset_obj = PyTuple_GET_ITEM(args, 6);
        bool pixel_offset = CastPyArg2Boolean(pixel_offset_obj, "distribute_fpn_proposals", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::distribute_fpn_proposals(fpn_rois, rois_num, min_level, max_level, refer_level, refer_scale, pixel_offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_divide(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add divide op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "divide", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "divide", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::divide(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_divide_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add divide_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "divide_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "divide_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::divide_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dropout(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dropout op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "dropout", 0);
        PyObject *seed_tensor_obj = PyTuple_GET_ITEM(args, 1);
        auto seed_tensor = CastPyArg2OptionalValue(seed_tensor_obj, "dropout", 1);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 2);
        float p = CastPyArg2Float(p_obj, "dropout", 2);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 3);
        bool is_test = CastPyArg2Boolean(is_test_obj, "dropout", 3);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 4);
        std::string mode = CastPyArg2String(mode_obj, "dropout", 4);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 5);
        int seed = CastPyArg2Int(seed_obj, "dropout", 5);
        PyObject *fix_seed_obj = PyTuple_GET_ITEM(args, 6);
        bool fix_seed = CastPyArg2Boolean(fix_seed_obj, "dropout", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::dropout(x, seed_tensor, p, is_test, mode, seed, fix_seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_einsum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add einsum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "einsum", 0);

        // Parse Attributes
        PyObject *equation_obj = PyTuple_GET_ITEM(args, 1);
        std::string equation = CastPyArg2String(equation_obj, "einsum", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::einsum(x, equation);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elementwise_pow(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elementwise_pow op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elementwise_pow", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "elementwise_pow", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::elementwise_pow(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_embedding(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add embedding op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "embedding", 0);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 1);
        auto weight = CastPyArg2Value(weight_obj, "embedding", 1);

        // Parse Attributes
        PyObject *padding_idx_obj = PyTuple_GET_ITEM(args, 2);
        int64_t padding_idx = CastPyArg2Long(padding_idx_obj, "embedding", 2);
        PyObject *sparse_obj = PyTuple_GET_ITEM(args, 3);
        bool sparse = CastPyArg2Boolean(sparse_obj, "embedding", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::embedding(x, weight, padding_idx, sparse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_embedding_grad_dense(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add embedding_grad_dense op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "embedding_grad_dense", 0);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 1);
        auto weight = CastPyArg2Value(weight_obj, "embedding_grad_dense", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "embedding_grad_dense", 2);

        // Parse Attributes
        PyObject *padding_idx_obj = PyTuple_GET_ITEM(args, 3);
        int64_t padding_idx = CastPyArg2Long(padding_idx_obj, "embedding_grad_dense", 3);
        PyObject *sparse_obj = PyTuple_GET_ITEM(args, 4);
        bool sparse = CastPyArg2Boolean(sparse_obj, "embedding_grad_dense", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::embedding_grad_dense(x, weight, out_grad, padding_idx, sparse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_empty(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add empty op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "empty", 0);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "empty", 0);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "empty", 0);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "empty", 1);
            Place place = CastPyArg2Place(place_obj, "empty", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::empty(shape, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_empty_like(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add empty_like op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "empty_like", 0);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "empty_like", 1);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 2);
        Place place = CastPyArg2Place(place_obj, "empty_like", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::empty_like(x, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_enable_check_model_nan_inf(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add enable_check_model_nan_inf op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "enable_check_model_nan_inf", 0);

        // Parse Attributes
        PyObject *flag_obj = PyTuple_GET_ITEM(args, 1);
        int flag = CastPyArg2Int(flag_obj, "enable_check_model_nan_inf", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::enable_check_model_nan_inf(x, flag);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_equal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add equal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "equal", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "equal", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::equal(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_equal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add equal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "equal_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "equal_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::equal_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_exponential_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add exponential_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "exponential_", 0);

        // Parse Attributes
        PyObject *lam_obj = PyTuple_GET_ITEM(args, 1);
        float lam = CastPyArg2Float(lam_obj, "exponential_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::exponential_(x, lam);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eye(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eye op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *num_rows_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *num_columns_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value num_rows;

       pir::Value num_columns;

        if (PyObject_CheckIROpResult(num_rows_obj)){
             num_rows = CastPyArg2Value(num_rows_obj, "eye", 0);
        }else{
            float num_rows_tmp = CastPyArg2Float(num_rows_obj, "eye", 0);
            num_rows = paddle::dialect::full(std::vector<int64_t>{1}, num_rows_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(num_columns_obj)){
             num_columns = CastPyArg2Value(num_columns_obj, "eye", 1);
        }else{
            float num_columns_tmp = CastPyArg2Float(num_columns_obj, "eye", 1);
            num_columns = paddle::dialect::full(std::vector<int64_t>{1}, num_columns_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "eye", 2);
            Place place = CastPyArg2Place(place_obj, "eye", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::eye(num_rows, num_columns, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor_divide(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor_divide op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "floor_divide", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "floor_divide", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor_divide(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor_divide_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor_divide_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "floor_divide_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "floor_divide_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor_divide_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_frobenius_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add frobenius_norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "frobenius_norm", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keep_dim_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "frobenius_norm", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "frobenius_norm", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "frobenius_norm", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keep_dim = CastPyArg2Boolean(keep_dim_obj, "frobenius_norm", 2);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "frobenius_norm", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::frobenius_norm(x, axis, keep_dim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_full_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add full_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *output_obj = PyTuple_GET_ITEM(args, 0);
        auto output = CastPyArg2Value(output_obj, "full_", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> shape = CastPyArg2Longs(shape_obj, "full_", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        float value = CastPyArg2Float(value_obj, "full_", 2);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "full_", 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);
        Place place = CastPyArg2Place(place_obj, "full_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::full_(output, shape, value, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_full_batch_size_like(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add full_batch_size_like op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "full_batch_size_like", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> shape = CastPyArg2Ints(shape_obj, "full_batch_size_like", 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "full_batch_size_like", 2);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 3);
        float value = CastPyArg2Float(value_obj, "full_batch_size_like", 3);
        PyObject *input_dim_idx_obj = PyTuple_GET_ITEM(args, 4);
        int input_dim_idx = CastPyArg2Int(input_dim_idx_obj, "full_batch_size_like", 4);
        PyObject *output_dim_idx_obj = PyTuple_GET_ITEM(args, 5);
        int output_dim_idx = CastPyArg2Int(output_dim_idx_obj, "full_batch_size_like", 5);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 6);
        Place place = CastPyArg2Place(place_obj, "full_batch_size_like", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::full_batch_size_like(input, shape, dtype, value, input_dim_idx, output_dim_idx, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_full_like(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add full_like op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "full_like", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value value;

        if (PyObject_CheckIROpResult(value_obj)){
             value = CastPyArg2Value(value_obj, "full_like", 1);
        }else{
            float value_tmp = CastPyArg2Float(value_obj, "full_like", 1);
            value = paddle::dialect::full(std::vector<int64_t>{1}, value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "full_like", 2);
            Place place = CastPyArg2Place(place_obj, "full_like", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::full_like(x, value, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_full_with_tensor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add full_with_tensor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 0);
        auto shape = CastPyArg2Value(shape_obj, "full_with_tensor", 0);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        auto value = CastPyArg2Value(value_obj, "full_with_tensor", 1);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "full_with_tensor", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::full_with_tensor(shape, value, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_adam_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_adam_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *params_obj = PyTuple_GET_ITEM(args, 0);
        auto params = CastPyArg2VectorOfValue(params_obj, "fused_adam_", 0);
        PyObject *grads_obj = PyTuple_GET_ITEM(args, 1);
        auto grads = CastPyArg2VectorOfValue(grads_obj, "fused_adam_", 1);
        PyObject *learning_rate_obj = PyTuple_GET_ITEM(args, 2);
        auto learning_rate = CastPyArg2Value(learning_rate_obj, "fused_adam_", 2);
        PyObject *moments1_obj = PyTuple_GET_ITEM(args, 3);
        auto moments1 = CastPyArg2VectorOfValue(moments1_obj, "fused_adam_", 3);
        PyObject *moments2_obj = PyTuple_GET_ITEM(args, 4);
        auto moments2 = CastPyArg2VectorOfValue(moments2_obj, "fused_adam_", 4);
        PyObject *beta1_pows_obj = PyTuple_GET_ITEM(args, 5);
        auto beta1_pows = CastPyArg2VectorOfValue(beta1_pows_obj, "fused_adam_", 5);
        PyObject *beta2_pows_obj = PyTuple_GET_ITEM(args, 6);
        auto beta2_pows = CastPyArg2VectorOfValue(beta2_pows_obj, "fused_adam_", 6);
        PyObject *master_params_obj = PyTuple_GET_ITEM(args, 7);
        auto master_params = CastPyArg2OptionalVectorOfValue(master_params_obj, "fused_adam_", 7);
        PyObject *skip_update_obj = PyTuple_GET_ITEM(args, 8);
        auto skip_update = CastPyArg2OptionalValue(skip_update_obj, "fused_adam_", 8);

        // Parse Attributes
        PyObject *beta1_obj = PyTuple_GET_ITEM(args, 9);
        float beta1 = CastPyArg2Float(beta1_obj, "fused_adam_", 9);
        PyObject *beta2_obj = PyTuple_GET_ITEM(args, 10);
        float beta2 = CastPyArg2Float(beta2_obj, "fused_adam_", 10);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 11);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_adam_", 11);
        PyObject *chunk_size_obj = PyTuple_GET_ITEM(args, 12);
        int chunk_size = CastPyArg2Int(chunk_size_obj, "fused_adam_", 12);
        PyObject *weight_decay_obj = PyTuple_GET_ITEM(args, 13);
        float weight_decay = CastPyArg2Float(weight_decay_obj, "fused_adam_", 13);
        PyObject *use_adamw_obj = PyTuple_GET_ITEM(args, 14);
        bool use_adamw = CastPyArg2Boolean(use_adamw_obj, "fused_adam_", 14);
        PyObject *multi_precision_obj = PyTuple_GET_ITEM(args, 15);
        bool multi_precision = CastPyArg2Boolean(multi_precision_obj, "fused_adam_", 15);
        PyObject *use_global_beta_pow_obj = PyTuple_GET_ITEM(args, 16);
        bool use_global_beta_pow = CastPyArg2Boolean(use_global_beta_pow_obj, "fused_adam_", 16);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_adam_(params, grads, learning_rate, moments1, moments2, beta1_pows, beta2_pows, master_params, skip_update, beta1, beta2, epsilon, chunk_size, weight_decay, use_adamw, multi_precision, use_global_beta_pow);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_batch_norm_act(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_batch_norm_act op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_batch_norm_act", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "fused_batch_norm_act", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2Value(bias_obj, "fused_batch_norm_act", 2);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 3);
        auto mean = CastPyArg2Value(mean_obj, "fused_batch_norm_act", 3);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 4);
        auto variance = CastPyArg2Value(variance_obj, "fused_batch_norm_act", 4);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 5);
        float momentum = CastPyArg2Float(momentum_obj, "fused_batch_norm_act", 5);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 6);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_batch_norm_act", 6);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 7);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_batch_norm_act", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_batch_norm_act(x, scale, bias, mean, variance, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_batch_norm_act_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_batch_norm_act_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_batch_norm_act_", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "fused_batch_norm_act_", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2Value(bias_obj, "fused_batch_norm_act_", 2);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 3);
        auto mean = CastPyArg2Value(mean_obj, "fused_batch_norm_act_", 3);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 4);
        auto variance = CastPyArg2Value(variance_obj, "fused_batch_norm_act_", 4);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 5);
        float momentum = CastPyArg2Float(momentum_obj, "fused_batch_norm_act_", 5);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 6);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_batch_norm_act_", 6);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 7);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_batch_norm_act_", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_batch_norm_act_(x, scale, bias, mean, variance, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_bn_add_activation(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_bn_add_activation op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_bn_add_activation", 0);
        PyObject *z_obj = PyTuple_GET_ITEM(args, 1);
        auto z = CastPyArg2Value(z_obj, "fused_bn_add_activation", 1);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 2);
        auto scale = CastPyArg2Value(scale_obj, "fused_bn_add_activation", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2Value(bias_obj, "fused_bn_add_activation", 3);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 4);
        auto mean = CastPyArg2Value(mean_obj, "fused_bn_add_activation", 4);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 5);
        auto variance = CastPyArg2Value(variance_obj, "fused_bn_add_activation", 5);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 6);
        float momentum = CastPyArg2Float(momentum_obj, "fused_bn_add_activation", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_bn_add_activation", 7);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 8);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_bn_add_activation", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_bn_add_activation(x, z, scale, bias, mean, variance, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_bn_add_activation_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_bn_add_activation_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_bn_add_activation_", 0);
        PyObject *z_obj = PyTuple_GET_ITEM(args, 1);
        auto z = CastPyArg2Value(z_obj, "fused_bn_add_activation_", 1);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 2);
        auto scale = CastPyArg2Value(scale_obj, "fused_bn_add_activation_", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2Value(bias_obj, "fused_bn_add_activation_", 3);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 4);
        auto mean = CastPyArg2Value(mean_obj, "fused_bn_add_activation_", 4);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 5);
        auto variance = CastPyArg2Value(variance_obj, "fused_bn_add_activation_", 5);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 6);
        float momentum = CastPyArg2Float(momentum_obj, "fused_bn_add_activation_", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_bn_add_activation_", 7);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 8);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_bn_add_activation_", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_bn_add_activation_(x, z, scale, bias, mean, variance, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_softmax_mask_upper_triangle(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_softmax_mask_upper_triangle op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *X_obj = PyTuple_GET_ITEM(args, 0);
        auto X = CastPyArg2Value(X_obj, "fused_softmax_mask_upper_triangle", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_softmax_mask_upper_triangle(X);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gaussian(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gaussian op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "gaussian", 0);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "gaussian", 0);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "gaussian", 0);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            float mean = CastPyArg2Float(mean_obj, "gaussian", 1);
            float std = CastPyArg2Float(std_obj, "gaussian", 2);
            int seed = CastPyArg2Int(seed_obj, "gaussian", 3);
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "gaussian", 4);
            Place place = CastPyArg2Place(place_obj, "gaussian", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::gaussian(shape, mean, std, seed, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_greater_equal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add greater_equal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "greater_equal", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "greater_equal", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::greater_equal(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_greater_equal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add greater_equal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "greater_equal_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "greater_equal_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::greater_equal_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_greater_than(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add greater_than op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "greater_than", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "greater_than", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::greater_than(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_greater_than_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add greater_than_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "greater_than_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "greater_than_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::greater_than_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardswish(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardswish op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardswish", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::hardswish(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hsigmoid_loss(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hsigmoid_loss op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hsigmoid_loss", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "hsigmoid_loss", 1);
        PyObject *w_obj = PyTuple_GET_ITEM(args, 2);
        auto w = CastPyArg2Value(w_obj, "hsigmoid_loss", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2OptionalValue(bias_obj, "hsigmoid_loss", 3);
        PyObject *path_obj = PyTuple_GET_ITEM(args, 4);
        auto path = CastPyArg2OptionalValue(path_obj, "hsigmoid_loss", 4);
        PyObject *code_obj = PyTuple_GET_ITEM(args, 5);
        auto code = CastPyArg2OptionalValue(code_obj, "hsigmoid_loss", 5);

        // Parse Attributes
        PyObject *num_classes_obj = PyTuple_GET_ITEM(args, 6);
        int num_classes = CastPyArg2Int(num_classes_obj, "hsigmoid_loss", 6);
        PyObject *is_sparse_obj = PyTuple_GET_ITEM(args, 7);
        bool is_sparse = CastPyArg2Boolean(is_sparse_obj, "hsigmoid_loss", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::hsigmoid_loss(x, label, w, bias, path, code, num_classes, is_sparse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_increment(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add increment op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "increment", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        float value = CastPyArg2Float(value_obj, "increment", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::increment(x, value);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_increment_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add increment_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "increment_", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        float value = CastPyArg2Float(value_obj, "increment_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::increment_(x, value);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_less_equal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add less_equal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "less_equal", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "less_equal", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::less_equal(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_less_equal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add less_equal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "less_equal_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "less_equal_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::less_equal_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_less_than(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add less_than op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "less_than", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "less_than", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::less_than(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_less_than_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add less_than_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "less_than_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "less_than_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::less_than_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_linspace(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add linspace op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *start_obj = PyTuple_GET_ITEM(args, 0);
        auto start = CastPyArg2Value(start_obj, "linspace", 0);
        PyObject *stop_obj = PyTuple_GET_ITEM(args, 1);
        auto stop = CastPyArg2Value(stop_obj, "linspace", 1);
        PyObject *number_obj = PyTuple_GET_ITEM(args, 2);
        auto number = CastPyArg2Value(number_obj, "linspace", 2);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "linspace", 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);
        Place place = CastPyArg2Place(place_obj, "linspace", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::linspace(start, stop, number, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logspace(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logspace op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *start_obj = PyTuple_GET_ITEM(args, 0);
        auto start = CastPyArg2Value(start_obj, "logspace", 0);
        PyObject *stop_obj = PyTuple_GET_ITEM(args, 1);
        auto stop = CastPyArg2Value(stop_obj, "logspace", 1);
        PyObject *num_obj = PyTuple_GET_ITEM(args, 2);
        auto num = CastPyArg2Value(num_obj, "logspace", 2);
        PyObject *base_obj = PyTuple_GET_ITEM(args, 3);
        auto base = CastPyArg2Value(base_obj, "logspace", 3);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "logspace", 4);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 5);
        Place place = CastPyArg2Place(place_obj, "logspace", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::logspace(start, stop, num, base, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logsumexp(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logsumexp op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logsumexp", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "logsumexp", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "logsumexp", 2);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 3);
        bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "logsumexp", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::logsumexp(x, axis, keepdim, reduce_all);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matmul(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matmul op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matmul", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "matmul", 1);

        // Parse Attributes
        PyObject *transpose_x_obj = PyTuple_GET_ITEM(args, 2);
        bool transpose_x = CastPyArg2Boolean(transpose_x_obj, "matmul", 2);
        PyObject *transpose_y_obj = PyTuple_GET_ITEM(args, 3);
        bool transpose_y = CastPyArg2Boolean(transpose_y_obj, "matmul", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::matmul(x, y, transpose_x, transpose_y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matrix_rank(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matrix_rank op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matrix_rank", 0);

        // Parse Attributes
        PyObject *tol_obj = PyTuple_GET_ITEM(args, 1);
        float tol = CastPyArg2Float(tol_obj, "matrix_rank", 1);
        PyObject *use_default_tol_obj = PyTuple_GET_ITEM(args, 2);
        bool use_default_tol = CastPyArg2Boolean(use_default_tol_obj, "matrix_rank", 2);
        PyObject *hermitian_obj = PyTuple_GET_ITEM(args, 3);
        bool hermitian = CastPyArg2Boolean(hermitian_obj, "matrix_rank", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::matrix_rank(x, tol, use_default_tol, hermitian);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matrix_rank_tol(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matrix_rank_tol op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matrix_rank_tol", 0);
        PyObject *atol_tensor_obj = PyTuple_GET_ITEM(args, 1);
        auto atol_tensor = CastPyArg2Value(atol_tensor_obj, "matrix_rank_tol", 1);

        // Parse Attributes
        PyObject *use_default_tol_obj = PyTuple_GET_ITEM(args, 2);
        bool use_default_tol = CastPyArg2Boolean(use_default_tol_obj, "matrix_rank_tol", 2);
        PyObject *hermitian_obj = PyTuple_GET_ITEM(args, 3);
        bool hermitian = CastPyArg2Boolean(hermitian_obj, "matrix_rank_tol", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::matrix_rank_tol(x, atol_tensor, use_default_tol, hermitian);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "max", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "max", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "max", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdim = CastPyArg2Boolean(keepdim_obj, "max", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::max(x, axis, keepdim);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_maximum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add maximum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "maximum", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "maximum", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::maximum(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mean(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mean op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mean", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "mean", 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "mean", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::mean(x, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_memcpy_d2h(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add memcpy_d2h op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "memcpy_d2h", 0);

        // Parse Attributes
        PyObject *dst_place_type_obj = PyTuple_GET_ITEM(args, 1);
        int dst_place_type = CastPyArg2Int(dst_place_type_obj, "memcpy_d2h", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::memcpy_d2h(x, dst_place_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_memcpy_h2d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add memcpy_h2d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "memcpy_h2d", 0);

        // Parse Attributes
        PyObject *dst_place_type_obj = PyTuple_GET_ITEM(args, 1);
        int dst_place_type = CastPyArg2Int(dst_place_type_obj, "memcpy_h2d", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::memcpy_h2d(x, dst_place_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_min(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add min op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "min", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "min", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "min", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "min", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdim = CastPyArg2Boolean(keepdim_obj, "min", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::min(x, axis, keepdim);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_minimum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add minimum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "minimum", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "minimum", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::minimum(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mish(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mish op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mish", 0);

        // Parse Attributes
        PyObject *lambda_obj = PyTuple_GET_ITEM(args, 1);
        float lambda = CastPyArg2Float(lambda_obj, "mish", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::mish(x, lambda);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_norm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add norm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "norm", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "norm", 1);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 2);
        float epsilon = CastPyArg2Float(epsilon_obj, "norm", 2);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 3);
        bool is_test = CastPyArg2Boolean(is_test_obj, "norm", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::norm(x, axis, epsilon, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_not_equal(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add not_equal op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "not_equal", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "not_equal", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::not_equal(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_not_equal_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add not_equal_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "not_equal_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "not_equal_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::not_equal_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_one_hot(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add one_hot op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "one_hot", 0);

        // Parse Attributes
        PyObject *num_classes_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value num_classes;

        if (PyObject_CheckIROpResult(num_classes_obj)){
             num_classes = CastPyArg2Value(num_classes_obj, "one_hot", 1);
        }else{
            int num_classes_tmp = CastPyArg2Int(num_classes_obj, "one_hot", 1);
            num_classes = paddle::dialect::full(std::vector<int64_t>{1}, num_classes_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::one_hot(x, num_classes);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pad", 0);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value pad_value;

            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pad", 1);
        if (PyObject_CheckIROpResult(pad_value_obj)){
             pad_value = CastPyArg2Value(pad_value_obj, "pad", 2);
        }else{
            float pad_value_tmp = CastPyArg2Float(pad_value_obj, "pad", 2);
            pad_value = paddle::dialect::full(std::vector<int64_t>{1}, pad_value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::pad(x, pad_value, paddings);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pool2d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pool2d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pool2d", 0);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *ceil_mode_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *pooling_type_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 10);

        // Check for mutable attrs
       pir::Value kernel_size;

        if (PyObject_CheckIROpResult(kernel_size_obj)){
             kernel_size = CastPyArg2Value(kernel_size_obj, "pool2d", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(kernel_size_obj)){
            std::vector<pir::Value> kernel_size_tmp = CastPyArg2VectorOfValue(kernel_size_obj, "pool2d", 1);
            kernel_size = paddle::dialect::stack(kernel_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> kernel_size_tmp = CastPyArg2Longs(kernel_size_obj, "pool2d", 1);
            kernel_size = paddle::dialect::full_int_array(kernel_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int> strides = CastPyArg2Ints(strides_obj, "pool2d", 2);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pool2d", 3);
            bool ceil_mode = CastPyArg2Boolean(ceil_mode_obj, "pool2d", 4);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "pool2d", 5);
            std::string data_format = CastPyArg2String(data_format_obj, "pool2d", 6);
            std::string pooling_type = CastPyArg2String(pooling_type_obj, "pool2d", 7);
            bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "pool2d", 8);
            bool adaptive = CastPyArg2Boolean(adaptive_obj, "pool2d", 9);
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "pool2d", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::pool2d(x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pool3d(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pool3d op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pool3d", 0);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "pool3d", 1);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "pool3d", 2);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pool3d", 3);
        PyObject *ceil_mode_obj = PyTuple_GET_ITEM(args, 4);
        bool ceil_mode = CastPyArg2Boolean(ceil_mode_obj, "pool3d", 4);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 5);
        bool exclusive = CastPyArg2Boolean(exclusive_obj, "pool3d", 5);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 6);
        std::string data_format = CastPyArg2String(data_format_obj, "pool3d", 6);
        PyObject *pooling_type_obj = PyTuple_GET_ITEM(args, 7);
        std::string pooling_type = CastPyArg2String(pooling_type_obj, "pool3d", 7);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 8);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "pool3d", 8);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 9);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "pool3d", 9);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 10);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "pool3d", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::pool3d(x, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_prod(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add prod op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "prod", 0);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *keep_dim_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value dims;

        if (PyObject_CheckIROpResult(dims_obj)){
             dims = CastPyArg2Value(dims_obj, "prod", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(dims_obj)){
            std::vector<pir::Value> dims_tmp = CastPyArg2VectorOfValue(dims_obj, "prod", 1);
            dims = paddle::dialect::stack(dims_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> dims_tmp = CastPyArg2Longs(dims_obj, "prod", 1);
            dims = paddle::dialect::full_int_array(dims_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keep_dim = CastPyArg2Boolean(keep_dim_obj, "prod", 2);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "prod", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::prod(x, dims, keep_dim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_randint(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add randint op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *low_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *high_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value shape;

            int low = CastPyArg2Int(low_obj, "randint", 0);
            int high = CastPyArg2Int(high_obj, "randint", 1);
        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "randint", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "randint", 2);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "randint", 2);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "randint", 3);
            Place place = CastPyArg2Place(place_obj, "randint", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::randint(shape, low, high, dtype, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_randperm(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add randperm op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 0);
        int n = CastPyArg2Int(n_obj, "randperm", 0);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "randperm", 1);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 2);
        Place place = CastPyArg2Place(place_obj, "randperm", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::randperm(n, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_remainder(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add remainder op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "remainder", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "remainder", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::remainder(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_remainder_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add remainder_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "remainder_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "remainder_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::remainder_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_repeat_interleave(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add repeat_interleave op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "repeat_interleave", 0);

        // Parse Attributes
        PyObject *repeats_obj = PyTuple_GET_ITEM(args, 1);
        int repeats = CastPyArg2Int(repeats_obj, "repeat_interleave", 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "repeat_interleave", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::repeat_interleave(x, repeats, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_repeat_interleave_with_tensor_index(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add repeat_interleave_with_tensor_index op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "repeat_interleave_with_tensor_index", 0);
        PyObject *repeats_obj = PyTuple_GET_ITEM(args, 1);
        auto repeats = CastPyArg2Value(repeats_obj, "repeat_interleave_with_tensor_index", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "repeat_interleave_with_tensor_index", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::repeat_interleave_with_tensor_index(x, repeats, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reshape", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "reshape", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "reshape", 1);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "reshape", 1);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape(x, shape);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "reshape_", 0);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "reshape_", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "reshape_", 1);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "reshape_", 1);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape_(x, shape);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rnn(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rnn op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rnn", 0);
        PyObject *pre_state_obj = PyTuple_GET_ITEM(args, 1);
        auto pre_state = CastPyArg2VectorOfValue(pre_state_obj, "rnn", 1);
        PyObject *weight_list_obj = PyTuple_GET_ITEM(args, 2);
        auto weight_list = CastPyArg2VectorOfValue(weight_list_obj, "rnn", 2);
        PyObject *sequence_length_obj = PyTuple_GET_ITEM(args, 3);
        auto sequence_length = CastPyArg2OptionalValue(sequence_length_obj, "rnn", 3);
        PyObject *dropout_state_in_obj = PyTuple_GET_ITEM(args, 4);
        auto dropout_state_in = CastPyArg2Value(dropout_state_in_obj, "rnn", 4);

        // Parse Attributes
        PyObject *dropout_prob_obj = PyTuple_GET_ITEM(args, 5);
        float dropout_prob = CastPyArg2Float(dropout_prob_obj, "rnn", 5);
        PyObject *is_bidirec_obj = PyTuple_GET_ITEM(args, 6);
        bool is_bidirec = CastPyArg2Boolean(is_bidirec_obj, "rnn", 6);
        PyObject *input_size_obj = PyTuple_GET_ITEM(args, 7);
        int input_size = CastPyArg2Int(input_size_obj, "rnn", 7);
        PyObject *hidden_size_obj = PyTuple_GET_ITEM(args, 8);
        int hidden_size = CastPyArg2Int(hidden_size_obj, "rnn", 8);
        PyObject *num_layers_obj = PyTuple_GET_ITEM(args, 9);
        int num_layers = CastPyArg2Int(num_layers_obj, "rnn", 9);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 10);
        std::string mode = CastPyArg2String(mode_obj, "rnn", 10);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 11);
        int seed = CastPyArg2Int(seed_obj, "rnn", 11);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 12);
        bool is_test = CastPyArg2Boolean(is_test_obj, "rnn", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::rnn(x, pre_state, weight_list, sequence_length, dropout_state_in, dropout_prob, is_bidirec, input_size, hidden_size, num_layers, mode, seed, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rnn_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rnn_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rnn_", 0);
        PyObject *pre_state_obj = PyTuple_GET_ITEM(args, 1);
        auto pre_state = CastPyArg2VectorOfValue(pre_state_obj, "rnn_", 1);
        PyObject *weight_list_obj = PyTuple_GET_ITEM(args, 2);
        auto weight_list = CastPyArg2VectorOfValue(weight_list_obj, "rnn_", 2);
        PyObject *sequence_length_obj = PyTuple_GET_ITEM(args, 3);
        auto sequence_length = CastPyArg2OptionalValue(sequence_length_obj, "rnn_", 3);
        PyObject *dropout_state_in_obj = PyTuple_GET_ITEM(args, 4);
        auto dropout_state_in = CastPyArg2Value(dropout_state_in_obj, "rnn_", 4);

        // Parse Attributes
        PyObject *dropout_prob_obj = PyTuple_GET_ITEM(args, 5);
        float dropout_prob = CastPyArg2Float(dropout_prob_obj, "rnn_", 5);
        PyObject *is_bidirec_obj = PyTuple_GET_ITEM(args, 6);
        bool is_bidirec = CastPyArg2Boolean(is_bidirec_obj, "rnn_", 6);
        PyObject *input_size_obj = PyTuple_GET_ITEM(args, 7);
        int input_size = CastPyArg2Int(input_size_obj, "rnn_", 7);
        PyObject *hidden_size_obj = PyTuple_GET_ITEM(args, 8);
        int hidden_size = CastPyArg2Int(hidden_size_obj, "rnn_", 8);
        PyObject *num_layers_obj = PyTuple_GET_ITEM(args, 9);
        int num_layers = CastPyArg2Int(num_layers_obj, "rnn_", 9);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 10);
        std::string mode = CastPyArg2String(mode_obj, "rnn_", 10);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 11);
        int seed = CastPyArg2Int(seed_obj, "rnn_", 11);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 12);
        bool is_test = CastPyArg2Boolean(is_test_obj, "rnn_", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::rnn_(x, pre_state, weight_list, sequence_length, dropout_state_in, dropout_prob, is_bidirec, input_size, hidden_size, num_layers, mode, seed, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rrelu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rrelu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rrelu", 0);

        // Parse Attributes
        PyObject *lower_obj = PyTuple_GET_ITEM(args, 1);
        float lower = CastPyArg2Float(lower_obj, "rrelu", 1);
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 2);
        float upper = CastPyArg2Float(upper_obj, "rrelu", 2);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 3);
        bool is_test = CastPyArg2Boolean(is_test_obj, "rrelu", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::rrelu(x, lower, upper, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "set_value", 0);

        // Parse Attributes
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *steps_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *decrease_axes_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *none_axes_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 8);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value steps;

        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "set_value", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "set_value", 1);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "set_value", 1);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "set_value", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "set_value", 2);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "set_value", 2);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(steps_obj)){
             steps = CastPyArg2Value(steps_obj, "set_value", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(steps_obj)){
            std::vector<pir::Value> steps_tmp = CastPyArg2VectorOfValue(steps_obj, "set_value", 3);
            steps = paddle::dialect::stack(steps_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> steps_tmp = CastPyArg2Longs(steps_obj, "set_value", 3);
            steps = paddle::dialect::full_int_array(steps_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "set_value", 4);
            std::vector<int64_t> decrease_axes = CastPyArg2Longs(decrease_axes_obj, "set_value", 5);
            std::vector<int64_t> none_axes = CastPyArg2Longs(none_axes_obj, "set_value", 6);
            std::vector<int64_t> shape = CastPyArg2Longs(shape_obj, "set_value", 7);
            std::vector<phi::Scalar> values = CastPyArg2ScalarArray(values_obj, "set_value", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value(x, starts, ends, steps, axes, decrease_axes, none_axes, shape, values);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "set_value_", 0);

        // Parse Attributes
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *steps_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *decrease_axes_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *none_axes_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 8);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value steps;

        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "set_value_", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "set_value_", 1);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "set_value_", 1);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "set_value_", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "set_value_", 2);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "set_value_", 2);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(steps_obj)){
             steps = CastPyArg2Value(steps_obj, "set_value_", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(steps_obj)){
            std::vector<pir::Value> steps_tmp = CastPyArg2VectorOfValue(steps_obj, "set_value_", 3);
            steps = paddle::dialect::stack(steps_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> steps_tmp = CastPyArg2Longs(steps_obj, "set_value_", 3);
            steps = paddle::dialect::full_int_array(steps_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "set_value_", 4);
            std::vector<int64_t> decrease_axes = CastPyArg2Longs(decrease_axes_obj, "set_value_", 5);
            std::vector<int64_t> none_axes = CastPyArg2Longs(none_axes_obj, "set_value_", 6);
            std::vector<int64_t> shape = CastPyArg2Longs(shape_obj, "set_value_", 7);
            std::vector<phi::Scalar> values = CastPyArg2ScalarArray(values_obj, "set_value_", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value_(x, starts, ends, steps, axes, decrease_axes, none_axes, shape, values);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value_with_tensor(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value_with_tensor op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "set_value_with_tensor", 0);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 1);
        auto values = CastPyArg2Value(values_obj, "set_value_with_tensor", 1);

        // Parse Attributes
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *steps_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *decrease_axes_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *none_axes_obj = PyTuple_GET_ITEM(args, 7);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value steps;

        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "set_value_with_tensor", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "set_value_with_tensor", 2);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "set_value_with_tensor", 2);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "set_value_with_tensor", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "set_value_with_tensor", 3);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "set_value_with_tensor", 3);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(steps_obj)){
             steps = CastPyArg2Value(steps_obj, "set_value_with_tensor", 4);
        }else if (PyObject_CheckIRVectorOfOpResult(steps_obj)){
            std::vector<pir::Value> steps_tmp = CastPyArg2VectorOfValue(steps_obj, "set_value_with_tensor", 4);
            steps = paddle::dialect::stack(steps_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> steps_tmp = CastPyArg2Longs(steps_obj, "set_value_with_tensor", 4);
            steps = paddle::dialect::full_int_array(steps_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "set_value_with_tensor", 5);
            std::vector<int64_t> decrease_axes = CastPyArg2Longs(decrease_axes_obj, "set_value_with_tensor", 6);
            std::vector<int64_t> none_axes = CastPyArg2Longs(none_axes_obj, "set_value_with_tensor", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value_with_tensor(x, values, starts, ends, steps, axes, decrease_axes, none_axes);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value_with_tensor_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value_with_tensor_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "set_value_with_tensor_", 0);
        PyObject *values_obj = PyTuple_GET_ITEM(args, 1);
        auto values = CastPyArg2Value(values_obj, "set_value_with_tensor_", 1);

        // Parse Attributes
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *steps_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *decrease_axes_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *none_axes_obj = PyTuple_GET_ITEM(args, 7);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value steps;

        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "set_value_with_tensor_", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "set_value_with_tensor_", 2);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "set_value_with_tensor_", 2);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "set_value_with_tensor_", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "set_value_with_tensor_", 3);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "set_value_with_tensor_", 3);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(steps_obj)){
             steps = CastPyArg2Value(steps_obj, "set_value_with_tensor_", 4);
        }else if (PyObject_CheckIRVectorOfOpResult(steps_obj)){
            std::vector<pir::Value> steps_tmp = CastPyArg2VectorOfValue(steps_obj, "set_value_with_tensor_", 4);
            steps = paddle::dialect::stack(steps_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> steps_tmp = CastPyArg2Longs(steps_obj, "set_value_with_tensor_", 4);
            steps = paddle::dialect::full_int_array(steps_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "set_value_with_tensor_", 5);
            std::vector<int64_t> decrease_axes = CastPyArg2Longs(decrease_axes_obj, "set_value_with_tensor_", 6);
            std::vector<int64_t> none_axes = CastPyArg2Longs(none_axes_obj, "set_value_with_tensor_", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value_with_tensor_(x, values, starts, ends, steps, axes, decrease_axes, none_axes);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_slice(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add slice op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "slice", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *infer_flags_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *decrease_axis_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "slice", 1);
        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "slice", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "slice", 2);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "slice", 2);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "slice", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "slice", 3);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "slice", 3);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> infer_flags = CastPyArg2Longs(infer_flags_obj, "slice", 4);
            std::vector<int64_t> decrease_axis = CastPyArg2Longs(decrease_axis_obj, "slice", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::slice(input, starts, ends, axes, infer_flags, decrease_axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softmax(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softmax op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softmax", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "softmax", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::softmax(x, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softmax_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softmax_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softmax_", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "softmax_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::softmax_(x, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_split(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add split op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "split", 0);

        // Parse Attributes
        PyObject *sections_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value sections;

       pir::Value axis;

        if (PyObject_CheckIROpResult(sections_obj)){
             sections = CastPyArg2Value(sections_obj, "split", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(sections_obj)){
            std::vector<pir::Value> sections_tmp = CastPyArg2VectorOfValue(sections_obj, "split", 1);
            sections = paddle::dialect::stack(sections_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> sections_tmp = CastPyArg2Longs(sections_obj, "split", 1);
            sections = paddle::dialect::full_int_array(sections_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "split", 2);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "split", 2);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::split(x, sections, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_split_with_num(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add split_with_num op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "split_with_num", 0);

        // Parse Attributes
        PyObject *num_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

            int num = CastPyArg2Int(num_obj, "split_with_num", 1);
        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "split_with_num", 2);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "split_with_num", 2);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::split_with_num(x, axis, num);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_strided_slice(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add strided_slice op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "strided_slice", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value strides;

            std::vector<int> axes = CastPyArg2Ints(axes_obj, "strided_slice", 1);
        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "strided_slice", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "strided_slice", 2);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "strided_slice", 2);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "strided_slice", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "strided_slice", 3);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "strided_slice", 3);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(strides_obj)){
             strides = CastPyArg2Value(strides_obj, "strided_slice", 4);
        }else if (PyObject_CheckIRVectorOfOpResult(strides_obj)){
            std::vector<pir::Value> strides_tmp = CastPyArg2VectorOfValue(strides_obj, "strided_slice", 4);
            strides = paddle::dialect::stack(strides_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> strides_tmp = CastPyArg2Longs(strides_obj, "strided_slice", 4);
            strides = paddle::dialect::full_int_array(strides_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::strided_slice(x, starts, ends, strides, axes);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_subtract(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add subtract op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "subtract", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "subtract", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::subtract(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_subtract_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add subtract_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "subtract_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "subtract_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::subtract_(x, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sum(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sum op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sum", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "sum", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "sum", 1);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "sum", 1);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "sum", 2);
            bool keepdim = CastPyArg2Boolean(keepdim_obj, "sum", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::sum(x, axis, dtype, keepdim);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_swish(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add swish op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "swish", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::swish(x);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sync_batch_norm_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sync_batch_norm_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sync_batch_norm_", 0);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        auto mean = CastPyArg2Value(mean_obj, "sync_batch_norm_", 1);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 2);
        auto variance = CastPyArg2Value(variance_obj, "sync_batch_norm_", 2);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 3);
        auto scale = CastPyArg2Value(scale_obj, "sync_batch_norm_", 3);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 4);
        auto bias = CastPyArg2Value(bias_obj, "sync_batch_norm_", 4);

        // Parse Attributes
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 5);
        bool is_test = CastPyArg2Boolean(is_test_obj, "sync_batch_norm_", 5);
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 6);
        float momentum = CastPyArg2Float(momentum_obj, "sync_batch_norm_", 6);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "sync_batch_norm_", 7);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_layout = CastPyArg2String(data_layout_obj, "sync_batch_norm_", 8);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 9);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "sync_batch_norm_", 9);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 10);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "sync_batch_norm_", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::sync_batch_norm_(x, mean, variance, scale, bias, is_test, momentum, epsilon, data_layout, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tile(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tile op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tile", 0);

        // Parse Attributes
        PyObject *repeat_times_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value repeat_times;

        if (PyObject_CheckIROpResult(repeat_times_obj)){
             repeat_times = CastPyArg2Value(repeat_times_obj, "tile", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(repeat_times_obj)){
            std::vector<pir::Value> repeat_times_tmp = CastPyArg2VectorOfValue(repeat_times_obj, "tile", 1);
            repeat_times = paddle::dialect::stack(repeat_times_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> repeat_times_tmp = CastPyArg2Longs(repeat_times_obj, "tile", 1);
            repeat_times = paddle::dialect::full_int_array(repeat_times_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::tile(x, repeat_times);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trans_layout(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trans_layout op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "trans_layout", 0);

        // Parse Attributes
        PyObject *perm_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> perm = CastPyArg2Ints(perm_obj, "trans_layout", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::trans_layout(x, perm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_transpose(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add transpose op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "transpose", 0);

        // Parse Attributes
        PyObject *perm_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> perm = CastPyArg2Ints(perm_obj, "transpose", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::transpose(x, perm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_transpose_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add transpose_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "transpose_", 0);

        // Parse Attributes
        PyObject *perm_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int> perm = CastPyArg2Ints(perm_obj, "transpose_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::transpose_(x, perm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tril(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tril op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tril", 0);

        // Parse Attributes
        PyObject *diagonal_obj = PyTuple_GET_ITEM(args, 1);
        int diagonal = CastPyArg2Int(diagonal_obj, "tril", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::tril(x, diagonal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tril_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tril_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tril_", 0);

        // Parse Attributes
        PyObject *diagonal_obj = PyTuple_GET_ITEM(args, 1);
        int diagonal = CastPyArg2Int(diagonal_obj, "tril_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::tril_(x, diagonal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tril_indices(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tril_indices op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *rows_obj = PyTuple_GET_ITEM(args, 0);
        int rows = CastPyArg2Int(rows_obj, "tril_indices", 0);
        PyObject *cols_obj = PyTuple_GET_ITEM(args, 1);
        int cols = CastPyArg2Int(cols_obj, "tril_indices", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "tril_indices", 2);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "tril_indices", 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);
        Place place = CastPyArg2Place(place_obj, "tril_indices", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::tril_indices(rows, cols, offset, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_triu(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add triu op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "triu", 0);

        // Parse Attributes
        PyObject *diagonal_obj = PyTuple_GET_ITEM(args, 1);
        int diagonal = CastPyArg2Int(diagonal_obj, "triu", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::triu(x, diagonal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_triu_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add triu_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "triu_", 0);

        // Parse Attributes
        PyObject *diagonal_obj = PyTuple_GET_ITEM(args, 1);
        int diagonal = CastPyArg2Int(diagonal_obj, "triu_", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::triu_(x, diagonal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_triu_indices(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add triu_indices op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *row_obj = PyTuple_GET_ITEM(args, 0);
        int row = CastPyArg2Int(row_obj, "triu_indices", 0);
        PyObject *col_obj = PyTuple_GET_ITEM(args, 1);
        int col = CastPyArg2Int(col_obj, "triu_indices", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "triu_indices", 2);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 3);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "triu_indices", 3);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 4);
        Place place = CastPyArg2Place(place_obj, "triu_indices", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::triu_indices(row, col, offset, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_truncated_gaussian_random(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add truncated_gaussian_random op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 0);
        std::vector<int> shape = CastPyArg2Ints(shape_obj, "truncated_gaussian_random", 0);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        float mean = CastPyArg2Float(mean_obj, "truncated_gaussian_random", 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        float std = CastPyArg2Float(std_obj, "truncated_gaussian_random", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "truncated_gaussian_random", 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "truncated_gaussian_random", 4);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 5);
        Place place = CastPyArg2Place(place_obj, "truncated_gaussian_random", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::truncated_gaussian_random(shape, mean, std, seed, dtype, place);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_uniform(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add uniform op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 0);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *min_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *place_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value shape;

       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "uniform", 0);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "uniform", 0);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "uniform", 0);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "uniform", 1);
        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "uniform", 2);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "uniform", 2);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "uniform", 3);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "uniform", 3);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
            int seed = CastPyArg2Int(seed_obj, "uniform", 4);
            Place place = CastPyArg2Place(place_obj, "uniform", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::uniform(shape, min, max, dtype, seed, place);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unique(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unique op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unique", 0);

        // Parse Attributes
        PyObject *return_index_obj = PyTuple_GET_ITEM(args, 1);
        bool return_index = CastPyArg2Boolean(return_index_obj, "unique", 1);
        PyObject *return_inverse_obj = PyTuple_GET_ITEM(args, 2);
        bool return_inverse = CastPyArg2Boolean(return_inverse_obj, "unique", 2);
        PyObject *return_counts_obj = PyTuple_GET_ITEM(args, 3);
        bool return_counts = CastPyArg2Boolean(return_counts_obj, "unique", 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> axis = CastPyArg2Ints(axis_obj, "unique", 4);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 5);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "unique", 5);
        PyObject *is_sorted_obj = PyTuple_GET_ITEM(args, 6);
        bool is_sorted = CastPyArg2Boolean(is_sorted_obj, "unique", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::unique(x, return_index, return_inverse, return_counts, axis, dtype, is_sorted);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unpool(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unpool op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unpool", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "unpool", 1);

        // Parse Attributes
        PyObject *ksize_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *padding_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 6);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> ksize = CastPyArg2Ints(ksize_obj, "unpool", 2);
            std::vector<int> strides = CastPyArg2Ints(strides_obj, "unpool", 3);
            std::vector<int> padding = CastPyArg2Ints(padding_obj, "unpool", 4);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "unpool", 5);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "unpool", 5);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "unpool", 5);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string data_format = CastPyArg2String(data_format_obj, "unpool", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::unpool(x, indices, output_size, ksize, strides, padding, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_abs_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add abs_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "abs_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "abs_double_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::abs_double_grad(x, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_abs_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add abs_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "abs_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "abs_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::abs_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acos_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acos_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acos_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "acos_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acos_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acos_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acos_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acos_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "acos_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acos_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acosh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acosh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acosh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "acosh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acosh_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_acosh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add acosh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "acosh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "acosh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::acosh_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_addmm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add addmm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "addmm_grad", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "addmm_grad", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "addmm_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "addmm_grad", 3);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 4);
        float alpha = CastPyArg2Float(alpha_obj, "addmm_grad", 4);
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 5);
        float beta = CastPyArg2Float(beta_obj, "addmm_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::addmm_grad(input, x, y, out_grad, alpha, beta);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_affine_grid_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add affine_grid_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "affine_grid_grad", 0);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto output_grad = CastPyArg2Value(output_grad_obj, "affine_grid_grad", 1);

        // Parse Attributes
        PyObject *output_shape_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value output_shape;

        if (PyObject_CheckIROpResult(output_shape_obj)){
             output_shape = CastPyArg2Value(output_shape_obj, "affine_grid_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(output_shape_obj)){
            std::vector<pir::Value> output_shape_tmp = CastPyArg2VectorOfValue(output_shape_obj, "affine_grid_grad", 2);
            output_shape = paddle::dialect::stack(output_shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_shape_tmp = CastPyArg2Longs(output_shape_obj, "affine_grid_grad", 2);
            output_shape = paddle::dialect::full_int_array(output_shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool align_corners = CastPyArg2Boolean(align_corners_obj, "affine_grid_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::affine_grid_grad(input, output_grad, output_shape, align_corners);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_angle_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add angle_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "angle_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "angle_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::angle_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_argsort_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add argsort_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 0);
        auto indices = CastPyArg2Value(indices_obj, "argsort_grad", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "argsort_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "argsort_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "argsort_grad", 3);
        PyObject *descending_obj = PyTuple_GET_ITEM(args, 4);
        bool descending = CastPyArg2Boolean(descending_obj, "argsort_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::argsort_grad(indices, x, out_grad, axis, descending);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_as_strided_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add as_strided_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "as_strided_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "as_strided_grad", 1);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int64_t> dims = CastPyArg2Longs(dims_obj, "as_strided_grad", 2);
        PyObject *stride_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int64_t> stride = CastPyArg2Longs(stride_obj, "as_strided_grad", 3);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 4);
        int64_t offset = CastPyArg2Long(offset_obj, "as_strided_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::as_strided_grad(input, out_grad, dims, stride, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asin_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asin_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asin_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "asin_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asin_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asin_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asin_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asin_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "asin_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asin_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asinh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asinh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asinh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "asinh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asinh_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_asinh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add asinh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "asinh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "asinh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::asinh_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan2_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan2_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan2_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "atan2_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "atan2_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan2_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "atan_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atan_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atan_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atan_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "atan_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atan_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atanh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atanh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atanh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "atanh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atanh_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_atanh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add atanh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "atanh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "atanh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::atanh_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bce_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bce_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "bce_loss_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "bce_loss_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "bce_loss_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bce_loss_grad(input, label, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bce_loss_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bce_loss_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "bce_loss_grad_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "bce_loss_grad_", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "bce_loss_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bce_loss_grad_(input, label, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bicubic_interp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bicubic_interp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bicubic_interp_grad", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "bicubic_interp_grad", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "bicubic_interp_grad", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "bicubic_interp_grad", 3);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto output_grad = CastPyArg2Value(output_grad_obj, "bicubic_interp_grad", 4);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "bicubic_interp_grad", 5);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 6);
        int out_d = CastPyArg2Int(out_d_obj, "bicubic_interp_grad", 6);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 7);
        int out_h = CastPyArg2Int(out_h_obj, "bicubic_interp_grad", 7);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 8);
        int out_w = CastPyArg2Int(out_w_obj, "bicubic_interp_grad", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "bicubic_interp_grad", 9);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 10);
        std::string interp_method = CastPyArg2String(interp_method_obj, "bicubic_interp_grad", 10);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 11);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "bicubic_interp_grad", 11);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 12);
        int align_mode = CastPyArg2Int(align_mode_obj, "bicubic_interp_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::bicubic_interp_grad(x, out_size, size_tensor, scale_tensor, output_grad, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bilinear_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bilinear_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bilinear_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bilinear_grad", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2Value(weight_obj, "bilinear_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "bilinear_grad", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bilinear_grad(x, y, weight, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bilinear_interp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bilinear_interp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bilinear_interp_grad", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "bilinear_interp_grad", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "bilinear_interp_grad", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "bilinear_interp_grad", 3);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto output_grad = CastPyArg2Value(output_grad_obj, "bilinear_interp_grad", 4);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "bilinear_interp_grad", 5);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 6);
        int out_d = CastPyArg2Int(out_d_obj, "bilinear_interp_grad", 6);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 7);
        int out_h = CastPyArg2Int(out_h_obj, "bilinear_interp_grad", 7);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 8);
        int out_w = CastPyArg2Int(out_w_obj, "bilinear_interp_grad", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "bilinear_interp_grad", 9);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 10);
        std::string interp_method = CastPyArg2String(interp_method_obj, "bilinear_interp_grad", 10);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 11);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "bilinear_interp_grad", 11);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 12);
        int align_mode = CastPyArg2Int(align_mode_obj, "bilinear_interp_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::bilinear_interp_grad(x, out_size, size_tensor, scale_tensor, output_grad, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_bmm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add bmm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "bmm_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "bmm_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "bmm_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::bmm_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_broadcast_tensors_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add broadcast_tensors_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2VectorOfValue(input_obj, "broadcast_tensors_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2VectorOfValue(out_grad_obj, "broadcast_tensors_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::broadcast_tensors_grad(input, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_ceil_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add ceil_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "ceil_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::ceil_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_ceil_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add ceil_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "ceil_grad_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::ceil_grad_(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_celu_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add celu_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "celu_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "celu_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "celu_double_grad", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "celu_double_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::celu_double_grad(x, grad_out, grad_x_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_celu_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add celu_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "celu_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "celu_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "celu_double_grad_", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "celu_double_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::celu_double_grad_(x, grad_out, grad_x_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_celu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add celu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "celu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "celu_grad", 1);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 2);
        float alpha = CastPyArg2Float(alpha_obj, "celu_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::celu_grad(x, out_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_celu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add celu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "celu_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "celu_grad_", 1);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 2);
        float alpha = CastPyArg2Float(alpha_obj, "celu_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::celu_grad_(x, out_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cholesky_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cholesky_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "cholesky_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cholesky_grad", 1);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 2);
        bool upper = CastPyArg2Boolean(upper_obj, "cholesky_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::cholesky_grad(out, out_grad, upper);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cholesky_solve_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cholesky_solve_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cholesky_solve_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "cholesky_solve_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "cholesky_solve_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cholesky_solve_grad", 3);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 4);
        bool upper = CastPyArg2Boolean(upper_obj, "cholesky_solve_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::cholesky_solve_grad(x, y, out, out_grad, upper);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "clip_double_grad", 1);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "clip_double_grad", 2);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "clip_double_grad", 2);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "clip_double_grad", 3);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "clip_double_grad", 3);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::clip_double_grad(x, grad_x_grad, min, max);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "clip_grad", 1);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "clip_grad", 2);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "clip_grad", 2);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "clip_grad", 3);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "clip_grad", 3);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::clip_grad(x, out_grad, min, max);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_clip_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add clip_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "clip_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "clip_grad_", 1);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value min;

       pir::Value max;

        if (PyObject_CheckIROpResult(min_obj)){
             min = CastPyArg2Value(min_obj, "clip_grad_", 2);
        }else{
            float min_tmp = CastPyArg2Float(min_obj, "clip_grad_", 2);
            min = paddle::dialect::full(std::vector<int64_t>{1}, min_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(max_obj)){
             max = CastPyArg2Value(max_obj, "clip_grad_", 3);
        }else{
            float max_tmp = CastPyArg2Float(max_obj, "clip_grad_", 3);
            max = paddle::dialect::full(std::vector<int64_t>{1}, max_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::clip_grad_(x, out_grad, min, max);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_complex_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add complex_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *real_obj = PyTuple_GET_ITEM(args, 0);
        auto real = CastPyArg2Value(real_obj, "complex_grad", 0);
        PyObject *imag_obj = PyTuple_GET_ITEM(args, 1);
        auto imag = CastPyArg2Value(imag_obj, "complex_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "complex_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::complex_grad(real, imag, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_concat_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add concat_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "concat_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "concat_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "concat_grad", 2);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "concat_grad", 2);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::concat_grad(x, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv2d_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "conv2d_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d_grad", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d_grad", 4);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 5);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d_grad", 5);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d_grad", 6);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 7);
        int groups = CastPyArg2Int(groups_obj, "conv2d_grad", 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_format = CastPyArg2String(data_format_obj, "conv2d_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d_grad(input, filter, out_grad, strides, paddings, padding_algorithm, dilations, groups, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d_grad_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d_grad_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv2d_grad_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d_grad_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "conv2d_grad_grad", 2);
        PyObject *grad_input_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_input_grad = CastPyArg2OptionalValue(grad_input_grad_obj, "conv2d_grad_grad", 3);
        PyObject *grad_filter_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_filter_grad = CastPyArg2OptionalValue(grad_filter_grad_obj, "conv2d_grad_grad", 4);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d_grad_grad", 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d_grad_grad", 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d_grad_grad", 7);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d_grad_grad", 8);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 9);
        int groups = CastPyArg2Int(groups_obj, "conv2d_grad_grad", 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);
        std::string data_format = CastPyArg2String(data_format_obj, "conv2d_grad_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d_grad_grad(input, filter, grad_out, grad_input_grad, grad_filter_grad, strides, paddings, padding_algorithm, dilations, groups, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv3d_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv3d_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv3d_double_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv3d_double_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "conv3d_double_grad", 2);
        PyObject *grad_input_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_input_grad = CastPyArg2OptionalValue(grad_input_grad_obj, "conv3d_double_grad", 3);
        PyObject *grad_filter_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_filter_grad = CastPyArg2OptionalValue(grad_filter_grad_obj, "conv3d_double_grad", 4);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv3d_double_grad", 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv3d_double_grad", 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv3d_double_grad", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "conv3d_double_grad", 8);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv3d_double_grad", 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);
        std::string data_format = CastPyArg2String(data_format_obj, "conv3d_double_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv3d_double_grad(input, filter, grad_out, grad_input_grad, grad_filter_grad, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv3d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv3d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "conv3d_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv3d_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "conv3d_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv3d_grad", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv3d_grad", 4);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 5);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv3d_grad", 5);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 6);
        int groups = CastPyArg2Int(groups_obj, "conv3d_grad", 6);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv3d_grad", 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_format = CastPyArg2String(data_format_obj, "conv3d_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv3d_grad(input, filter, out_grad, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv3d_transpose_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv3d_transpose_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conv3d_transpose_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv3d_transpose_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "conv3d_transpose_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv3d_transpose_grad", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv3d_transpose_grad", 4);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "conv3d_transpose_grad", 5);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> output_size = CastPyArg2Ints(output_size_obj, "conv3d_transpose_grad", 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv3d_transpose_grad", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "conv3d_transpose_grad", 8);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv3d_transpose_grad", 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);
        std::string data_format = CastPyArg2String(data_format_obj, "conv3d_transpose_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv3d_transpose_grad(x, filter, out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2OptionalValue(grad_out_obj, "cos_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "cos_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_double_grad(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2OptionalValue(grad_out_obj, "cos_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "cos_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_double_grad_(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cos_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cos_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_triple_grad", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2OptionalValue(grad_out_forward_obj, "cos_triple_grad", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2OptionalValue(grad_x_grad_forward_obj, "cos_triple_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "cos_triple_grad", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "cos_triple_grad", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_triple_grad(x, grad_out_forward, grad_x_grad_forward, grad_x_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cos_triple_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cos_triple_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cos_triple_grad_", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2OptionalValue(grad_out_forward_obj, "cos_triple_grad_", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2OptionalValue(grad_x_grad_forward_obj, "cos_triple_grad_", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "cos_triple_grad_", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "cos_triple_grad_", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cos_triple_grad_(x, grad_out_forward, grad_x_grad_forward, grad_x_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cosh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cosh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cosh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cosh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cosh_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cosh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cosh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cosh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cosh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::cosh_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_crop_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add crop_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "crop_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "crop_grad", 1);

        // Parse Attributes
        PyObject *offsets_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value offsets;

        if (PyObject_CheckIROpResult(offsets_obj)){
             offsets = CastPyArg2Value(offsets_obj, "crop_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(offsets_obj)){
            std::vector<pir::Value> offsets_tmp = CastPyArg2VectorOfValue(offsets_obj, "crop_grad", 2);
            offsets = paddle::dialect::stack(offsets_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> offsets_tmp = CastPyArg2Longs(offsets_obj, "crop_grad", 2);
            offsets = paddle::dialect::full_int_array(offsets_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::crop_grad(x, out_grad, offsets);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross_entropy_with_softmax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross_entropy_with_softmax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *label_obj = PyTuple_GET_ITEM(args, 0);
        auto label = CastPyArg2Value(label_obj, "cross_entropy_with_softmax_grad", 0);
        PyObject *softmax_obj = PyTuple_GET_ITEM(args, 1);
        auto softmax = CastPyArg2Value(softmax_obj, "cross_entropy_with_softmax_grad", 1);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "cross_entropy_with_softmax_grad", 2);

        // Parse Attributes
        PyObject *soft_label_obj = PyTuple_GET_ITEM(args, 3);
        bool soft_label = CastPyArg2Boolean(soft_label_obj, "cross_entropy_with_softmax_grad", 3);
        PyObject *use_softmax_obj = PyTuple_GET_ITEM(args, 4);
        bool use_softmax = CastPyArg2Boolean(use_softmax_obj, "cross_entropy_with_softmax_grad", 4);
        PyObject *numeric_stable_mode_obj = PyTuple_GET_ITEM(args, 5);
        bool numeric_stable_mode = CastPyArg2Boolean(numeric_stable_mode_obj, "cross_entropy_with_softmax_grad", 5);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 6);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "cross_entropy_with_softmax_grad", 6);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 7);
        int axis = CastPyArg2Int(axis_obj, "cross_entropy_with_softmax_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross_entropy_with_softmax_grad(label, softmax, loss_grad, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross_entropy_with_softmax_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross_entropy_with_softmax_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *label_obj = PyTuple_GET_ITEM(args, 0);
        auto label = CastPyArg2Value(label_obj, "cross_entropy_with_softmax_grad_", 0);
        PyObject *softmax_obj = PyTuple_GET_ITEM(args, 1);
        auto softmax = CastPyArg2Value(softmax_obj, "cross_entropy_with_softmax_grad_", 1);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "cross_entropy_with_softmax_grad_", 2);

        // Parse Attributes
        PyObject *soft_label_obj = PyTuple_GET_ITEM(args, 3);
        bool soft_label = CastPyArg2Boolean(soft_label_obj, "cross_entropy_with_softmax_grad_", 3);
        PyObject *use_softmax_obj = PyTuple_GET_ITEM(args, 4);
        bool use_softmax = CastPyArg2Boolean(use_softmax_obj, "cross_entropy_with_softmax_grad_", 4);
        PyObject *numeric_stable_mode_obj = PyTuple_GET_ITEM(args, 5);
        bool numeric_stable_mode = CastPyArg2Boolean(numeric_stable_mode_obj, "cross_entropy_with_softmax_grad_", 5);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 6);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "cross_entropy_with_softmax_grad_", 6);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 7);
        int axis = CastPyArg2Int(axis_obj, "cross_entropy_with_softmax_grad_", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross_entropy_with_softmax_grad_(label, softmax, loss_grad, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cross_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cross_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cross_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "cross_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cross_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "cross_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::cross_grad(x, y, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cummax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cummax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cummax_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "cummax_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cummax_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "cummax_grad", 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cummax_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::cummax_grad(x, indices, out_grad, axis, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cummin_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cummin_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cummin_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "cummin_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cummin_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "cummin_grad", 3);
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 4);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "cummin_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::cummin_grad(x, indices, out_grad, axis, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumprod_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumprod_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumprod_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "cumprod_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cumprod_grad", 2);

        // Parse Attributes
        PyObject *dim_obj = PyTuple_GET_ITEM(args, 3);
        int dim = CastPyArg2Int(dim_obj, "cumprod_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumprod_grad(x, out, out_grad, dim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_cumsum_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add cumsum_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "cumsum_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "cumsum_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reverse_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "cumsum_grad", 2);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "cumsum_grad", 2);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            bool flatten = CastPyArg2Boolean(flatten_obj, "cumsum_grad", 3);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "cumsum_grad", 4);
            bool reverse = CastPyArg2Boolean(reverse_obj, "cumsum_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::cumsum_grad(x, out_grad, axis, flatten, exclusive, reverse);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_depthwise_conv2d_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add depthwise_conv2d_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "depthwise_conv2d_double_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "depthwise_conv2d_double_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "depthwise_conv2d_double_grad", 2);
        PyObject *grad_input_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_input_grad = CastPyArg2OptionalValue(grad_input_grad_obj, "depthwise_conv2d_double_grad", 3);
        PyObject *grad_filter_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_filter_grad = CastPyArg2OptionalValue(grad_filter_grad_obj, "depthwise_conv2d_double_grad", 4);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "depthwise_conv2d_double_grad", 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "depthwise_conv2d_double_grad", 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "depthwise_conv2d_double_grad", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "depthwise_conv2d_double_grad", 8);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "depthwise_conv2d_double_grad", 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);
        std::string data_format = CastPyArg2String(data_format_obj, "depthwise_conv2d_double_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::depthwise_conv2d_double_grad(input, filter, grad_out, grad_input_grad, grad_filter_grad, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_depthwise_conv2d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add depthwise_conv2d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "depthwise_conv2d_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "depthwise_conv2d_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "depthwise_conv2d_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "depthwise_conv2d_grad", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "depthwise_conv2d_grad", 4);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 5);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "depthwise_conv2d_grad", 5);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 6);
        int groups = CastPyArg2Int(groups_obj, "depthwise_conv2d_grad", 6);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "depthwise_conv2d_grad", 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_format = CastPyArg2String(data_format_obj, "depthwise_conv2d_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::depthwise_conv2d_grad(input, filter, out_grad, strides, paddings, padding_algorithm, groups, dilations, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_det_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add det_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "det_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "det_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "det_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::det_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_diag_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add diag_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "diag_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "diag_grad", 1);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "diag_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::diag_grad(x, out_grad, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_diagonal_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add diagonal_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "diagonal_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "diagonal_grad", 1);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "diagonal_grad", 2);
        PyObject *axis1_obj = PyTuple_GET_ITEM(args, 3);
        int axis1 = CastPyArg2Int(axis1_obj, "diagonal_grad", 3);
        PyObject *axis2_obj = PyTuple_GET_ITEM(args, 4);
        int axis2 = CastPyArg2Int(axis2_obj, "diagonal_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::diagonal_grad(x, out_grad, offset, axis1, axis2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_digamma_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add digamma_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "digamma_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "digamma_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::digamma_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dist_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dist_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "dist_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "dist_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "dist_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "dist_grad", 3);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 4);
        float p = CastPyArg2Float(p_obj, "dist_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::dist_grad(x, y, out, out_grad, p);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dot_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dot_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "dot_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "dot_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "dot_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::dot_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eig_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eig_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 0);
        auto out_w = CastPyArg2Value(out_w_obj, "eig_grad", 0);
        PyObject *out_v_obj = PyTuple_GET_ITEM(args, 1);
        auto out_v = CastPyArg2Value(out_v_obj, "eig_grad", 1);
        PyObject *out_w_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_w_grad = CastPyArg2Value(out_w_grad_obj, "eig_grad", 2);
        PyObject *out_v_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_v_grad = CastPyArg2Value(out_v_grad_obj, "eig_grad", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::eig_grad(out_w, out_v, out_w_grad, out_v_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eigh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eigh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 0);
        auto out_w = CastPyArg2Value(out_w_obj, "eigh_grad", 0);
        PyObject *out_v_obj = PyTuple_GET_ITEM(args, 1);
        auto out_v = CastPyArg2Value(out_v_obj, "eigh_grad", 1);
        PyObject *out_w_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_w_grad = CastPyArg2Value(out_w_grad_obj, "eigh_grad", 2);
        PyObject *out_v_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_v_grad = CastPyArg2Value(out_v_grad_obj, "eigh_grad", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::eigh_grad(out_w, out_v, out_w_grad, out_v_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_eigvalsh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add eigvalsh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *eigenvectors_obj = PyTuple_GET_ITEM(args, 0);
        auto eigenvectors = CastPyArg2Value(eigenvectors_obj, "eigvalsh_grad", 0);
        PyObject *eigenvalues_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto eigenvalues_grad = CastPyArg2Value(eigenvalues_grad_obj, "eigvalsh_grad", 1);

        // Parse Attributes
        PyObject *uplo_obj = PyTuple_GET_ITEM(args, 2);
        std::string uplo = CastPyArg2String(uplo_obj, "eigvalsh_grad", 2);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 3);
        bool is_test = CastPyArg2Boolean(is_test_obj, "eigvalsh_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::eigvalsh_grad(eigenvectors, eigenvalues_grad, uplo, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "elu_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "elu_double_grad", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "elu_double_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu_double_grad(x, grad_out, grad_x_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "elu_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "elu_double_grad_", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "elu_double_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu_double_grad_(x, grad_out, grad_x_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "elu_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "elu_grad", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "elu_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu_grad(x, out, out_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elu_grad_", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "elu_grad_", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "elu_grad_", 2);

        // Parse Attributes
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "elu_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::elu_grad_(x, out, out_grad, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erf_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erf_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "erf_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "erf_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erf_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_erfinv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add erfinv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "erfinv_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "erfinv_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::erfinv_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_exp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add exp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "exp_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "exp_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::exp_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_exp_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add exp_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "exp_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "exp_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::exp_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expand_as_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expand_as_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expand_as_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "expand_as_grad", 1);

        // Parse Attributes
        PyObject *target_shape_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> target_shape = CastPyArg2Ints(target_shape_obj, "expand_as_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::expand_as_grad(x, out_grad, target_shape);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expand_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expand_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "expand_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "expand_grad", 1);

        // Parse Attributes
        PyObject *shape_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value shape;

        if (PyObject_CheckIROpResult(shape_obj)){
             shape = CastPyArg2Value(shape_obj, "expand_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(shape_obj)){
            std::vector<pir::Value> shape_tmp = CastPyArg2VectorOfValue(shape_obj, "expand_grad", 2);
            shape = paddle::dialect::stack(shape_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shape_tmp = CastPyArg2Longs(shape_obj, "expand_grad", 2);
            shape = paddle::dialect::full_int_array(shape_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::expand_grad(x, out_grad, shape);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expm1_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expm1_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "expm1_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "expm1_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::expm1_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_expm1_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add expm1_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "expm1_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "expm1_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::expm1_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_c2c_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_c2c_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fft_c2c_grad", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_c2c_grad", 1);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 2);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_c2c_grad", 2);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 3);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_c2c_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_c2c_grad(out_grad, axes, normalization, forward);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_c2r_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_c2r_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fft_c2r_grad", 0);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 1);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_c2r_grad", 1);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 2);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_c2r_grad", 2);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 3);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_c2r_grad", 3);
        PyObject *last_dim_size_obj = PyTuple_GET_ITEM(args, 4);
        int64_t last_dim_size = CastPyArg2Long(last_dim_size_obj, "fft_c2r_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_c2r_grad(out_grad, axes, normalization, forward, last_dim_size);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fft_r2c_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fft_r2c_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fft_r2c_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fft_r2c_grad", 1);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "fft_r2c_grad", 2);
        PyObject *normalization_obj = PyTuple_GET_ITEM(args, 3);
        std::string normalization = CastPyArg2String(normalization_obj, "fft_r2c_grad", 3);
        PyObject *forward_obj = PyTuple_GET_ITEM(args, 4);
        bool forward = CastPyArg2Boolean(forward_obj, "fft_r2c_grad", 4);
        PyObject *onesided_obj = PyTuple_GET_ITEM(args, 5);
        bool onesided = CastPyArg2Boolean(onesided_obj, "fft_r2c_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::fft_r2c_grad(x, out_grad, axes, normalization, forward, onesided);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fill_diagonal_grad", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);
        float value = CastPyArg2Float(value_obj, "fill_diagonal_grad", 1);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "fill_diagonal_grad", 2);
        PyObject *wrap_obj = PyTuple_GET_ITEM(args, 3);
        bool wrap = CastPyArg2Boolean(wrap_obj, "fill_diagonal_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_grad(out_grad, value, offset, wrap);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_tensor_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_tensor_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fill_diagonal_tensor_grad", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int64_t offset = CastPyArg2Long(offset_obj, "fill_diagonal_tensor_grad", 1);
        PyObject *dim1_obj = PyTuple_GET_ITEM(args, 2);
        int dim1 = CastPyArg2Int(dim1_obj, "fill_diagonal_tensor_grad", 2);
        PyObject *dim2_obj = PyTuple_GET_ITEM(args, 3);
        int dim2 = CastPyArg2Int(dim2_obj, "fill_diagonal_tensor_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_tensor_grad(out_grad, offset, dim1, dim2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_diagonal_tensor_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_diagonal_tensor_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fill_diagonal_tensor_grad_", 0);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        int64_t offset = CastPyArg2Long(offset_obj, "fill_diagonal_tensor_grad_", 1);
        PyObject *dim1_obj = PyTuple_GET_ITEM(args, 2);
        int dim1 = CastPyArg2Int(dim1_obj, "fill_diagonal_tensor_grad_", 2);
        PyObject *dim2_obj = PyTuple_GET_ITEM(args, 3);
        int dim2 = CastPyArg2Int(dim2_obj, "fill_diagonal_tensor_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_diagonal_tensor_grad_(out_grad, offset, dim1, dim2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fill_grad", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value value;

        if (PyObject_CheckIROpResult(value_obj)){
             value = CastPyArg2Value(value_obj, "fill_grad", 1);
        }else{
            float value_tmp = CastPyArg2Float(value_obj, "fill_grad", 1);
            value = paddle::dialect::full(std::vector<int64_t>{1}, value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_grad(out_grad, value);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fill_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fill_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fill_grad_", 0);

        // Parse Attributes
        PyObject *value_obj = PyTuple_GET_ITEM(args, 1);

        // Check for mutable attrs
       pir::Value value;

        if (PyObject_CheckIROpResult(value_obj)){
             value = CastPyArg2Value(value_obj, "fill_grad_", 1);
        }else{
            float value_tmp = CastPyArg2Float(value_obj, "fill_grad_", 1);
            value = paddle::dialect::full(std::vector<int64_t>{1}, value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::fill_grad_(out_grad, value);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flash_attn_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flash_attn_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *q_obj = PyTuple_GET_ITEM(args, 0);
        auto q = CastPyArg2Value(q_obj, "flash_attn_grad", 0);
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        auto k = CastPyArg2Value(k_obj, "flash_attn_grad", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "flash_attn_grad", 2);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 3);
        auto out = CastPyArg2Value(out_obj, "flash_attn_grad", 3);
        PyObject *softmax_lse_obj = PyTuple_GET_ITEM(args, 4);
        auto softmax_lse = CastPyArg2Value(softmax_lse_obj, "flash_attn_grad", 4);
        PyObject *seed_offset_obj = PyTuple_GET_ITEM(args, 5);
        auto seed_offset = CastPyArg2Value(seed_offset_obj, "flash_attn_grad", 5);
        PyObject *attn_mask_obj = PyTuple_GET_ITEM(args, 6);
        auto attn_mask = CastPyArg2OptionalValue(attn_mask_obj, "flash_attn_grad", 6);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto out_grad = CastPyArg2Value(out_grad_obj, "flash_attn_grad", 7);

        // Parse Attributes
        PyObject *dropout_obj = PyTuple_GET_ITEM(args, 8);
        float dropout = CastPyArg2Float(dropout_obj, "flash_attn_grad", 8);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 9);
        bool causal = CastPyArg2Boolean(causal_obj, "flash_attn_grad", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::flash_attn_grad(q, k, v, out, softmax_lse, seed_offset, attn_mask, out_grad, dropout, causal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flash_attn_unpadded_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flash_attn_unpadded_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *q_obj = PyTuple_GET_ITEM(args, 0);
        auto q = CastPyArg2Value(q_obj, "flash_attn_unpadded_grad", 0);
        PyObject *k_obj = PyTuple_GET_ITEM(args, 1);
        auto k = CastPyArg2Value(k_obj, "flash_attn_unpadded_grad", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "flash_attn_unpadded_grad", 2);
        PyObject *cu_seqlens_q_obj = PyTuple_GET_ITEM(args, 3);
        auto cu_seqlens_q = CastPyArg2Value(cu_seqlens_q_obj, "flash_attn_unpadded_grad", 3);
        PyObject *cu_seqlens_k_obj = PyTuple_GET_ITEM(args, 4);
        auto cu_seqlens_k = CastPyArg2Value(cu_seqlens_k_obj, "flash_attn_unpadded_grad", 4);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 5);
        auto out = CastPyArg2Value(out_obj, "flash_attn_unpadded_grad", 5);
        PyObject *softmax_lse_obj = PyTuple_GET_ITEM(args, 6);
        auto softmax_lse = CastPyArg2Value(softmax_lse_obj, "flash_attn_unpadded_grad", 6);
        PyObject *seed_offset_obj = PyTuple_GET_ITEM(args, 7);
        auto seed_offset = CastPyArg2Value(seed_offset_obj, "flash_attn_unpadded_grad", 7);
        PyObject *attn_mask_obj = PyTuple_GET_ITEM(args, 8);
        auto attn_mask = CastPyArg2OptionalValue(attn_mask_obj, "flash_attn_unpadded_grad", 8);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 9);
        auto out_grad = CastPyArg2Value(out_grad_obj, "flash_attn_unpadded_grad", 9);

        // Parse Attributes
        PyObject *max_seqlen_q_obj = PyTuple_GET_ITEM(args, 10);
        int64_t max_seqlen_q = CastPyArg2Long(max_seqlen_q_obj, "flash_attn_unpadded_grad", 10);
        PyObject *max_seqlen_k_obj = PyTuple_GET_ITEM(args, 11);
        int64_t max_seqlen_k = CastPyArg2Long(max_seqlen_k_obj, "flash_attn_unpadded_grad", 11);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 12);
        float scale = CastPyArg2Float(scale_obj, "flash_attn_unpadded_grad", 12);
        PyObject *dropout_obj = PyTuple_GET_ITEM(args, 13);
        float dropout = CastPyArg2Float(dropout_obj, "flash_attn_unpadded_grad", 13);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 14);
        bool causal = CastPyArg2Boolean(causal_obj, "flash_attn_unpadded_grad", 14);

        // Call ir static api
        auto static_api_out = paddle::dialect::flash_attn_unpadded_grad(q, k, v, cu_seqlens_q, cu_seqlens_k, out, softmax_lse, seed_offset, attn_mask, out_grad, max_seqlen_q, max_seqlen_k, scale, dropout, causal);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flatten_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flatten_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "flatten_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "flatten_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::flatten_grad(xshape, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_flatten_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add flatten_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "flatten_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "flatten_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::flatten_grad_(xshape, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "floor_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_floor_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add floor_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "floor_grad_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::floor_grad_(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fmax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fmax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fmax_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fmax_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fmax_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fmax_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fmin_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fmin_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fmin_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "fmin_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fmin_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fmin_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fold_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fold_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fold_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fold_grad", 1);

        // Parse Attributes
        PyObject *output_sizes_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> output_sizes = CastPyArg2Ints(output_sizes_obj, "fold_grad", 2);
        PyObject *kernel_sizes_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> kernel_sizes = CastPyArg2Ints(kernel_sizes_obj, "fold_grad", 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "fold_grad", 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "fold_grad", 5);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "fold_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::fold_grad(x, out_grad, output_sizes, kernel_sizes, strides, paddings, dilations);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_frame_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add frame_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "frame_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "frame_grad", 1);

        // Parse Attributes
        PyObject *frame_length_obj = PyTuple_GET_ITEM(args, 2);
        int frame_length = CastPyArg2Int(frame_length_obj, "frame_grad", 2);
        PyObject *hop_length_obj = PyTuple_GET_ITEM(args, 3);
        int hop_length = CastPyArg2Int(hop_length_obj, "frame_grad", 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "frame_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::frame_grad(x, out_grad, frame_length, hop_length, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gather_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gather_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gather_grad", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "gather_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gather_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "gather_grad", 3);
        }else{
            int axis_tmp = CastPyArg2Int(axis_obj, "gather_grad", 3);
            axis = paddle::dialect::full(std::vector<int64_t>{1}, axis_tmp, phi::DataType::INT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::gather_grad(x, index, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gather_nd_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gather_nd_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gather_nd_grad", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "gather_nd_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gather_nd_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::gather_nd_grad(x, index, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gaussian_inplace_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gaussian_inplace_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gaussian_inplace_grad", 0);

        // Parse Attributes
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        float mean = CastPyArg2Float(mean_obj, "gaussian_inplace_grad", 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        float std = CastPyArg2Float(std_obj, "gaussian_inplace_grad", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "gaussian_inplace_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::gaussian_inplace_grad(out_grad, mean, std, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gaussian_inplace_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gaussian_inplace_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gaussian_inplace_grad_", 0);

        // Parse Attributes
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 1);
        float mean = CastPyArg2Float(mean_obj, "gaussian_inplace_grad_", 1);
        PyObject *std_obj = PyTuple_GET_ITEM(args, 2);
        float std = CastPyArg2Float(std_obj, "gaussian_inplace_grad_", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "gaussian_inplace_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::gaussian_inplace_grad_(out_grad, mean, std, seed);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gelu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gelu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "gelu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gelu_grad", 1);

        // Parse Attributes
        PyObject *approximate_obj = PyTuple_GET_ITEM(args, 2);
        bool approximate = CastPyArg2Boolean(approximate_obj, "gelu_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::gelu_grad(x, out_grad, approximate);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_grid_sample_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add grid_sample_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "grid_sample_grad", 0);
        PyObject *grid_obj = PyTuple_GET_ITEM(args, 1);
        auto grid = CastPyArg2Value(grid_obj, "grid_sample_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "grid_sample_grad", 2);

        // Parse Attributes
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 3);
        std::string mode = CastPyArg2String(mode_obj, "grid_sample_grad", 3);
        PyObject *padding_mode_obj = PyTuple_GET_ITEM(args, 4);
        std::string padding_mode = CastPyArg2String(padding_mode_obj, "grid_sample_grad", 4);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 5);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "grid_sample_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::grid_sample_grad(x, grid, out_grad, mode, padding_mode, align_corners);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_group_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add group_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "group_norm_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "group_norm_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "group_norm_grad", 2);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 3);
        auto y = CastPyArg2Value(y_obj, "group_norm_grad", 3);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 4);
        auto mean = CastPyArg2Value(mean_obj, "group_norm_grad", 4);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 5);
        auto variance = CastPyArg2Value(variance_obj, "group_norm_grad", 5);
        PyObject *y_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto y_grad = CastPyArg2Value(y_grad_obj, "group_norm_grad", 6);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "group_norm_grad", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "group_norm_grad", 8);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 9);
        std::string data_layout = CastPyArg2String(data_layout_obj, "group_norm_grad", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::group_norm_grad(x, scale, bias, y, mean, variance, y_grad, epsilon, groups, data_layout);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_group_norm_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add group_norm_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "group_norm_grad_", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "group_norm_grad_", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "group_norm_grad_", 2);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 3);
        auto y = CastPyArg2Value(y_obj, "group_norm_grad_", 3);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 4);
        auto mean = CastPyArg2Value(mean_obj, "group_norm_grad_", 4);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 5);
        auto variance = CastPyArg2Value(variance_obj, "group_norm_grad_", 5);
        PyObject *y_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto y_grad = CastPyArg2Value(y_grad_obj, "group_norm_grad_", 6);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 7);
        float epsilon = CastPyArg2Float(epsilon_obj, "group_norm_grad_", 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        int groups = CastPyArg2Int(groups_obj, "group_norm_grad_", 8);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 9);
        std::string data_layout = CastPyArg2String(data_layout_obj, "group_norm_grad_", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::group_norm_grad_(x, scale, bias, y, mean, variance, y_grad, epsilon, groups, data_layout);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_gumbel_softmax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add gumbel_softmax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "gumbel_softmax_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "gumbel_softmax_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "gumbel_softmax_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::gumbel_softmax_grad(out, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardshrink_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardshrink_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardshrink_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardshrink_grad", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "hardshrink_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardshrink_grad(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardshrink_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardshrink_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardshrink_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardshrink_grad_", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "hardshrink_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardshrink_grad_(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardsigmoid_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardsigmoid_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "hardsigmoid_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardsigmoid_grad", 1);

        // Parse Attributes
        PyObject *slope_obj = PyTuple_GET_ITEM(args, 2);
        float slope = CastPyArg2Float(slope_obj, "hardsigmoid_grad", 2);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 3);
        float offset = CastPyArg2Float(offset_obj, "hardsigmoid_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardsigmoid_grad(out, out_grad, slope, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardsigmoid_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardsigmoid_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "hardsigmoid_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardsigmoid_grad_", 1);

        // Parse Attributes
        PyObject *slope_obj = PyTuple_GET_ITEM(args, 2);
        float slope = CastPyArg2Float(slope_obj, "hardsigmoid_grad_", 2);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 3);
        float offset = CastPyArg2Float(offset_obj, "hardsigmoid_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardsigmoid_grad_(out, out_grad, slope, offset);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardtanh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardtanh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardtanh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardtanh_grad", 1);

        // Parse Attributes
        PyObject *t_min_obj = PyTuple_GET_ITEM(args, 2);
        float t_min = CastPyArg2Float(t_min_obj, "hardtanh_grad", 2);
        PyObject *t_max_obj = PyTuple_GET_ITEM(args, 3);
        float t_max = CastPyArg2Float(t_max_obj, "hardtanh_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardtanh_grad(x, out_grad, t_min, t_max);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardtanh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardtanh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardtanh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardtanh_grad_", 1);

        // Parse Attributes
        PyObject *t_min_obj = PyTuple_GET_ITEM(args, 2);
        float t_min = CastPyArg2Float(t_min_obj, "hardtanh_grad_", 2);
        PyObject *t_max_obj = PyTuple_GET_ITEM(args, 3);
        float t_max = CastPyArg2Float(t_max_obj, "hardtanh_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::hardtanh_grad_(x, out_grad, t_min, t_max);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_heaviside_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add heaviside_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "heaviside_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "heaviside_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "heaviside_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::heaviside_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_huber_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add huber_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *residual_obj = PyTuple_GET_ITEM(args, 0);
        auto residual = CastPyArg2Value(residual_obj, "huber_loss_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "huber_loss_grad", 1);

        // Parse Attributes
        PyObject *delta_obj = PyTuple_GET_ITEM(args, 2);
        float delta = CastPyArg2Float(delta_obj, "huber_loss_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::huber_loss_grad(residual, out_grad, delta);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i0_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i0_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i0_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "i0_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i0_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i0e_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i0e_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i0e_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "i0e_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "i0e_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i0e_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i1_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i1_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i1_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "i1_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "i1_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i1_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_i1e_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add i1e_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "i1e_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "i1e_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "i1e_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::i1e_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_imag_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add imag_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "imag_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::imag_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_add_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_add_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *index_obj = PyTuple_GET_ITEM(args, 0);
        auto index = CastPyArg2Value(index_obj, "index_add_grad", 0);
        PyObject *add_value_obj = PyTuple_GET_ITEM(args, 1);
        auto add_value = CastPyArg2Value(add_value_obj, "index_add_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_add_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_add_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_add_grad(index, add_value, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_add_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_add_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *index_obj = PyTuple_GET_ITEM(args, 0);
        auto index = CastPyArg2Value(index_obj, "index_add_grad_", 0);
        PyObject *add_value_obj = PyTuple_GET_ITEM(args, 1);
        auto add_value = CastPyArg2Value(add_value_obj, "index_add_grad_", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_add_grad_", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_add_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_add_grad_(index, add_value, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_put_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_put_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_put_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2VectorOfValue(indices_obj, "index_put_grad", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "index_put_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_put_grad", 3);

        // Parse Attributes
        PyObject *accumulate_obj = PyTuple_GET_ITEM(args, 4);
        bool accumulate = CastPyArg2Boolean(accumulate_obj, "index_put_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_put_grad(x, indices, value, out_grad, accumulate);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_sample_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_sample_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_sample_grad", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_sample_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_sample_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::index_sample_grad(x, index, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_select_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_select_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_select_grad", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "index_select_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_select_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_select_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_select_grad(x, index, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_index_select_strided_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add index_select_strided_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "index_select_strided_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "index_select_strided_grad", 1);

        // Parse Attributes
        PyObject *index_obj = PyTuple_GET_ITEM(args, 2);
        int64_t index = CastPyArg2Long(index_obj, "index_select_strided_grad", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "index_select_strided_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::index_select_strided_grad(x, out_grad, index, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_instance_norm_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add instance_norm_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "instance_norm_double_grad", 0);
        PyObject *fwd_scale_obj = PyTuple_GET_ITEM(args, 1);
        auto fwd_scale = CastPyArg2OptionalValue(fwd_scale_obj, "instance_norm_double_grad", 1);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 2);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "instance_norm_double_grad", 2);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 3);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "instance_norm_double_grad", 3);
        PyObject *grad_y_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y = CastPyArg2Value(grad_y_obj, "instance_norm_double_grad", 4);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "instance_norm_double_grad", 5);
        PyObject *grad_scale_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto grad_scale_grad = CastPyArg2OptionalValue(grad_scale_grad_obj, "instance_norm_double_grad", 6);
        PyObject *grad_bias_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto grad_bias_grad = CastPyArg2OptionalValue(grad_bias_grad_obj, "instance_norm_double_grad", 7);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 8);
        float epsilon = CastPyArg2Float(epsilon_obj, "instance_norm_double_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::instance_norm_double_grad(x, fwd_scale, saved_mean, saved_variance, grad_y, grad_x_grad, grad_scale_grad, grad_bias_grad, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_instance_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add instance_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "instance_norm_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "instance_norm_grad", 1);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 2);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "instance_norm_grad", 2);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 3);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "instance_norm_grad", 3);
        PyObject *y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto y_grad = CastPyArg2Value(y_grad_obj, "instance_norm_grad", 4);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 5);
        float epsilon = CastPyArg2Float(epsilon_obj, "instance_norm_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::instance_norm_grad(x, scale, saved_mean, saved_variance, y_grad, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_inverse_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add inverse_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "inverse_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "inverse_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::inverse_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kldiv_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kldiv_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kldiv_loss_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "kldiv_loss_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "kldiv_loss_grad", 2);

        // Parse Attributes
        PyObject *reduction_obj = PyTuple_GET_ITEM(args, 3);
        std::string reduction = CastPyArg2String(reduction_obj, "kldiv_loss_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::kldiv_loss_grad(x, label, out_grad, reduction);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kron_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kron_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kron_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "kron_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "kron_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::kron_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_kthvalue_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add kthvalue_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "kthvalue_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "kthvalue_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "kthvalue_grad", 2);

        // Parse Attributes
        PyObject *k_obj = PyTuple_GET_ITEM(args, 3);
        int k = CastPyArg2Int(k_obj, "kthvalue_grad", 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "kthvalue_grad", 4);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 5);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "kthvalue_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::kthvalue_grad(x, indices, out_grad, k, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_label_smooth_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add label_smooth_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "label_smooth_grad", 0);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 1);
        float epsilon = CastPyArg2Float(epsilon_obj, "label_smooth_grad", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::label_smooth_grad(out_grad, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_layer_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add layer_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "layer_norm_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "layer_norm_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "layer_norm_grad", 2);
        PyObject *mean_obj = PyTuple_GET_ITEM(args, 3);
        auto mean = CastPyArg2Value(mean_obj, "layer_norm_grad", 3);
        PyObject *variance_obj = PyTuple_GET_ITEM(args, 4);
        auto variance = CastPyArg2Value(variance_obj, "layer_norm_grad", 4);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto out_grad = CastPyArg2Value(out_grad_obj, "layer_norm_grad", 5);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 6);
        float epsilon = CastPyArg2Float(epsilon_obj, "layer_norm_grad", 6);
        PyObject *begin_norm_axis_obj = PyTuple_GET_ITEM(args, 7);
        int begin_norm_axis = CastPyArg2Int(begin_norm_axis_obj, "layer_norm_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::layer_norm_grad(x, scale, bias, mean, variance, out_grad, epsilon, begin_norm_axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "leaky_relu_double_grad", 1);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 2);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu_double_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu_double_grad(x, grad_x_grad, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu_double_grad_", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "leaky_relu_double_grad_", 1);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 2);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu_double_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu_double_grad_(x, grad_x_grad, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "leaky_relu_grad", 1);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 2);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu_grad(x, out_grad, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_leaky_relu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add leaky_relu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "leaky_relu_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "leaky_relu_grad_", 1);

        // Parse Attributes
        PyObject *negative_slope_obj = PyTuple_GET_ITEM(args, 2);
        float negative_slope = CastPyArg2Float(negative_slope_obj, "leaky_relu_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::leaky_relu_grad_(x, out_grad, negative_slope);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lerp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lerp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lerp_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lerp_grad", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2Value(weight_obj, "lerp_grad", 2);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 3);
        auto out = CastPyArg2Value(out_obj, "lerp_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "lerp_grad", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lerp_grad(x, y, weight, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lgamma_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lgamma_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lgamma_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "lgamma_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::lgamma_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_linear_interp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add linear_interp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "linear_interp_grad", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "linear_interp_grad", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "linear_interp_grad", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "linear_interp_grad", 3);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto output_grad = CastPyArg2Value(output_grad_obj, "linear_interp_grad", 4);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "linear_interp_grad", 5);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 6);
        int out_d = CastPyArg2Int(out_d_obj, "linear_interp_grad", 6);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 7);
        int out_h = CastPyArg2Int(out_h_obj, "linear_interp_grad", 7);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 8);
        int out_w = CastPyArg2Int(out_w_obj, "linear_interp_grad", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "linear_interp_grad", 9);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 10);
        std::string interp_method = CastPyArg2String(interp_method_obj, "linear_interp_grad", 10);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 11);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "linear_interp_grad", 11);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 12);
        int align_mode = CastPyArg2Int(align_mode_obj, "linear_interp_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::linear_interp_grad(x, out_size, size_tensor, scale_tensor, output_grad, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log10_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log10_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log10_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log10_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log10_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log10_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log10_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log10_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log10_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log10_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log1p_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log1p_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log1p_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log1p_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log1p_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log1p_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log1p_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log1p_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log1p_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log1p_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log2_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log2_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log2_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log2_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log2_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log2_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log2_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log2_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log2_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log2_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "log_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "log_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log_double_grad(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "log_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "log_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log_double_grad_(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "log_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::log_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "log_loss_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "log_loss_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log_loss_grad", 2);

        // Parse Attributes
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 3);
        float epsilon = CastPyArg2Float(epsilon_obj, "log_loss_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::log_loss_grad(input, label, out_grad, epsilon);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_log_softmax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add log_softmax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "log_softmax_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "log_softmax_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "log_softmax_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::log_softmax_grad(out, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logcumsumexp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logcumsumexp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logcumsumexp_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "logcumsumexp_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "logcumsumexp_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "logcumsumexp_grad", 3);
        PyObject *flatten_obj = PyTuple_GET_ITEM(args, 4);
        bool flatten = CastPyArg2Boolean(flatten_obj, "logcumsumexp_grad", 4);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 5);
        bool exclusive = CastPyArg2Boolean(exclusive_obj, "logcumsumexp_grad", 5);
        PyObject *reverse_obj = PyTuple_GET_ITEM(args, 6);
        bool reverse = CastPyArg2Boolean(reverse_obj, "logcumsumexp_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::logcumsumexp_grad(x, out, out_grad, axis, flatten, exclusive, reverse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logit_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logit_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logit_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "logit_grad", 1);

        // Parse Attributes
        PyObject *eps_obj = PyTuple_GET_ITEM(args, 2);
        float eps = CastPyArg2Float(eps_obj, "logit_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::logit_grad(x, out_grad, eps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logsigmoid_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logsigmoid_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logsigmoid_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "logsigmoid_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logsigmoid_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logsigmoid_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logsigmoid_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logsigmoid_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "logsigmoid_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::logsigmoid_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "lu_grad", 1);
        PyObject *pivots_obj = PyTuple_GET_ITEM(args, 2);
        auto pivots = CastPyArg2Value(pivots_obj, "lu_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "lu_grad", 3);

        // Parse Attributes
        PyObject *pivot_obj = PyTuple_GET_ITEM(args, 4);
        bool pivot = CastPyArg2Boolean(pivot_obj, "lu_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu_grad(x, out, pivots, out_grad, pivot);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu_grad_", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "lu_grad_", 1);
        PyObject *pivots_obj = PyTuple_GET_ITEM(args, 2);
        auto pivots = CastPyArg2Value(pivots_obj, "lu_grad_", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "lu_grad_", 3);

        // Parse Attributes
        PyObject *pivot_obj = PyTuple_GET_ITEM(args, 4);
        bool pivot = CastPyArg2Boolean(pivot_obj, "lu_grad_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu_grad_(x, out, pivots, out_grad, pivot);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_lu_unpack_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add lu_unpack_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "lu_unpack_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "lu_unpack_grad", 1);
        PyObject *l_obj = PyTuple_GET_ITEM(args, 2);
        auto l = CastPyArg2Value(l_obj, "lu_unpack_grad", 2);
        PyObject *u_obj = PyTuple_GET_ITEM(args, 3);
        auto u = CastPyArg2Value(u_obj, "lu_unpack_grad", 3);
        PyObject *pmat_obj = PyTuple_GET_ITEM(args, 4);
        auto pmat = CastPyArg2Value(pmat_obj, "lu_unpack_grad", 4);
        PyObject *l_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto l_grad = CastPyArg2Value(l_grad_obj, "lu_unpack_grad", 5);
        PyObject *u_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto u_grad = CastPyArg2Value(u_grad_obj, "lu_unpack_grad", 6);

        // Parse Attributes
        PyObject *unpack_ludata_obj = PyTuple_GET_ITEM(args, 7);
        bool unpack_ludata = CastPyArg2Boolean(unpack_ludata_obj, "lu_unpack_grad", 7);
        PyObject *unpack_pivots_obj = PyTuple_GET_ITEM(args, 8);
        bool unpack_pivots = CastPyArg2Boolean(unpack_pivots_obj, "lu_unpack_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::lu_unpack_grad(x, y, l, u, pmat, l_grad, u_grad, unpack_ludata, unpack_pivots);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_margin_cross_entropy_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add margin_cross_entropy_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *logits_obj = PyTuple_GET_ITEM(args, 0);
        auto logits = CastPyArg2Value(logits_obj, "margin_cross_entropy_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "margin_cross_entropy_grad", 1);
        PyObject *softmax_obj = PyTuple_GET_ITEM(args, 2);
        auto softmax = CastPyArg2Value(softmax_obj, "margin_cross_entropy_grad", 2);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "margin_cross_entropy_grad", 3);

        // Parse Attributes
        PyObject *return_softmax_obj = PyTuple_GET_ITEM(args, 4);
        bool return_softmax = CastPyArg2Boolean(return_softmax_obj, "margin_cross_entropy_grad", 4);
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 5);
        int ring_id = CastPyArg2Int(ring_id_obj, "margin_cross_entropy_grad", 5);
        PyObject *rank_obj = PyTuple_GET_ITEM(args, 6);
        int rank = CastPyArg2Int(rank_obj, "margin_cross_entropy_grad", 6);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 7);
        int nranks = CastPyArg2Int(nranks_obj, "margin_cross_entropy_grad", 7);
        PyObject *margin1_obj = PyTuple_GET_ITEM(args, 8);
        float margin1 = CastPyArg2Float(margin1_obj, "margin_cross_entropy_grad", 8);
        PyObject *margin2_obj = PyTuple_GET_ITEM(args, 9);
        float margin2 = CastPyArg2Float(margin2_obj, "margin_cross_entropy_grad", 9);
        PyObject *margin3_obj = PyTuple_GET_ITEM(args, 10);
        float margin3 = CastPyArg2Float(margin3_obj, "margin_cross_entropy_grad", 10);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 11);
        float scale = CastPyArg2Float(scale_obj, "margin_cross_entropy_grad", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::margin_cross_entropy_grad(logits, label, softmax, loss_grad, return_softmax, ring_id, rank, nranks, margin1, margin2, margin3, scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_margin_cross_entropy_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add margin_cross_entropy_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *logits_obj = PyTuple_GET_ITEM(args, 0);
        auto logits = CastPyArg2Value(logits_obj, "margin_cross_entropy_grad_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "margin_cross_entropy_grad_", 1);
        PyObject *softmax_obj = PyTuple_GET_ITEM(args, 2);
        auto softmax = CastPyArg2Value(softmax_obj, "margin_cross_entropy_grad_", 2);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "margin_cross_entropy_grad_", 3);

        // Parse Attributes
        PyObject *return_softmax_obj = PyTuple_GET_ITEM(args, 4);
        bool return_softmax = CastPyArg2Boolean(return_softmax_obj, "margin_cross_entropy_grad_", 4);
        PyObject *ring_id_obj = PyTuple_GET_ITEM(args, 5);
        int ring_id = CastPyArg2Int(ring_id_obj, "margin_cross_entropy_grad_", 5);
        PyObject *rank_obj = PyTuple_GET_ITEM(args, 6);
        int rank = CastPyArg2Int(rank_obj, "margin_cross_entropy_grad_", 6);
        PyObject *nranks_obj = PyTuple_GET_ITEM(args, 7);
        int nranks = CastPyArg2Int(nranks_obj, "margin_cross_entropy_grad_", 7);
        PyObject *margin1_obj = PyTuple_GET_ITEM(args, 8);
        float margin1 = CastPyArg2Float(margin1_obj, "margin_cross_entropy_grad_", 8);
        PyObject *margin2_obj = PyTuple_GET_ITEM(args, 9);
        float margin2 = CastPyArg2Float(margin2_obj, "margin_cross_entropy_grad_", 9);
        PyObject *margin3_obj = PyTuple_GET_ITEM(args, 10);
        float margin3 = CastPyArg2Float(margin3_obj, "margin_cross_entropy_grad_", 10);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 11);
        float scale = CastPyArg2Float(scale_obj, "margin_cross_entropy_grad_", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::margin_cross_entropy_grad_(logits, label, softmax, loss_grad, return_softmax, ring_id, rank, nranks, margin1, margin2, margin3, scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_masked_select_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add masked_select_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "masked_select_grad", 0);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 1);
        auto mask = CastPyArg2Value(mask_obj, "masked_select_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "masked_select_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::masked_select_grad(x, mask, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matrix_power_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matrix_power_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matrix_power_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "matrix_power_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "matrix_power_grad", 2);

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 3);
        int n = CastPyArg2Int(n_obj, "matrix_power_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::matrix_power_grad(x, out, out_grad, n);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max_pool2d_with_index_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max_pool2d_with_index_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max_pool2d_with_index_grad", 0);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 1);
        auto mask = CastPyArg2Value(mask_obj, "max_pool2d_with_index_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "max_pool2d_with_index_grad", 2);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "max_pool2d_with_index_grad", 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "max_pool2d_with_index_grad", 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "max_pool2d_with_index_grad", 5);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 6);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "max_pool2d_with_index_grad", 6);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 7);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "max_pool2d_with_index_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::max_pool2d_with_index_grad(x, mask, out_grad, kernel_size, strides, paddings, global_pooling, adaptive);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max_pool3d_with_index_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max_pool3d_with_index_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max_pool3d_with_index_grad", 0);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 1);
        auto mask = CastPyArg2Value(mask_obj, "max_pool3d_with_index_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "max_pool3d_with_index_grad", 2);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "max_pool3d_with_index_grad", 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "max_pool3d_with_index_grad", 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "max_pool3d_with_index_grad", 5);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 6);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "max_pool3d_with_index_grad", 6);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 7);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "max_pool3d_with_index_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::max_pool3d_with_index_grad(x, mask, out_grad, kernel_size, strides, paddings, global_pooling, adaptive);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_maxout_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add maxout_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "maxout_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "maxout_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "maxout_grad", 2);

        // Parse Attributes
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 3);
        int groups = CastPyArg2Int(groups_obj, "maxout_grad", 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "maxout_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::maxout_grad(x, out, out_grad, groups, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mean_all_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mean_all_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mean_all_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mean_all_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::mean_all_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_memory_efficient_attention_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add memory_efficient_attention_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *query_obj = PyTuple_GET_ITEM(args, 0);
        auto query = CastPyArg2Value(query_obj, "memory_efficient_attention_grad", 0);
        PyObject *key_obj = PyTuple_GET_ITEM(args, 1);
        auto key = CastPyArg2Value(key_obj, "memory_efficient_attention_grad", 1);
        PyObject *value_obj = PyTuple_GET_ITEM(args, 2);
        auto value = CastPyArg2Value(value_obj, "memory_efficient_attention_grad", 2);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 3);
        auto bias = CastPyArg2OptionalValue(bias_obj, "memory_efficient_attention_grad", 3);
        PyObject *cu_seqlens_q_obj = PyTuple_GET_ITEM(args, 4);
        auto cu_seqlens_q = CastPyArg2OptionalValue(cu_seqlens_q_obj, "memory_efficient_attention_grad", 4);
        PyObject *cu_seqlens_k_obj = PyTuple_GET_ITEM(args, 5);
        auto cu_seqlens_k = CastPyArg2OptionalValue(cu_seqlens_k_obj, "memory_efficient_attention_grad", 5);
        PyObject *output_obj = PyTuple_GET_ITEM(args, 6);
        auto output = CastPyArg2Value(output_obj, "memory_efficient_attention_grad", 6);
        PyObject *logsumexp_obj = PyTuple_GET_ITEM(args, 7);
        auto logsumexp = CastPyArg2Value(logsumexp_obj, "memory_efficient_attention_grad", 7);
        PyObject *seed_and_offset_obj = PyTuple_GET_ITEM(args, 8);
        auto seed_and_offset = CastPyArg2Value(seed_and_offset_obj, "memory_efficient_attention_grad", 8);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 9);
        auto output_grad = CastPyArg2Value(output_grad_obj, "memory_efficient_attention_grad", 9);

        // Parse Attributes
        PyObject *max_seqlen_q_obj = PyTuple_GET_ITEM(args, 10);
        float max_seqlen_q = CastPyArg2Float(max_seqlen_q_obj, "memory_efficient_attention_grad", 10);
        PyObject *max_seqlen_k_obj = PyTuple_GET_ITEM(args, 11);
        float max_seqlen_k = CastPyArg2Float(max_seqlen_k_obj, "memory_efficient_attention_grad", 11);
        PyObject *causal_obj = PyTuple_GET_ITEM(args, 12);
        bool causal = CastPyArg2Boolean(causal_obj, "memory_efficient_attention_grad", 12);
        PyObject *dropout_p_obj = PyTuple_GET_ITEM(args, 13);
        double dropout_p = CastPyArg2Double(dropout_p_obj, "memory_efficient_attention_grad", 13);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 14);
        float scale = CastPyArg2Float(scale_obj, "memory_efficient_attention_grad", 14);

        // Call ir static api
        auto static_api_out = paddle::dialect::memory_efficient_attention_grad(query, key, value, bias, cu_seqlens_q, cu_seqlens_k, output, logsumexp, seed_and_offset, output_grad, max_seqlen_q, max_seqlen_k, causal, dropout_p, scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_meshgrid_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add meshgrid_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *inputs_obj = PyTuple_GET_ITEM(args, 0);
        auto inputs = CastPyArg2VectorOfValue(inputs_obj, "meshgrid_grad", 0);
        PyObject *outputs_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto outputs_grad = CastPyArg2VectorOfValue(outputs_grad_obj, "meshgrid_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::meshgrid_grad(inputs, outputs_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mode_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mode_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mode_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "mode_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mode_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "mode_grad", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "mode_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::mode_grad(x, indices, out_grad, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multi_dot_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multi_dot_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "multi_dot_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "multi_dot_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multi_dot_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiplex_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiplex_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *inputs_obj = PyTuple_GET_ITEM(args, 0);
        auto inputs = CastPyArg2VectorOfValue(inputs_obj, "multiplex_grad", 0);
        PyObject *index_obj = PyTuple_GET_ITEM(args, 1);
        auto index = CastPyArg2Value(index_obj, "multiplex_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "multiplex_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::multiplex_grad(inputs, index, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mv_grad", 0);
        PyObject *vec_obj = PyTuple_GET_ITEM(args, 1);
        auto vec = CastPyArg2Value(vec_obj, "mv_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mv_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::mv_grad(x, vec, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nanmedian_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nanmedian_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nanmedian_grad", 0);
        PyObject *medians_obj = PyTuple_GET_ITEM(args, 1);
        auto medians = CastPyArg2Value(medians_obj, "nanmedian_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "nanmedian_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "nanmedian_grad", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "nanmedian_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::nanmedian_grad(x, medians, out_grad, axis, keepdim);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nearest_interp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nearest_interp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "nearest_interp_grad", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "nearest_interp_grad", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "nearest_interp_grad", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "nearest_interp_grad", 3);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto output_grad = CastPyArg2Value(output_grad_obj, "nearest_interp_grad", 4);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "nearest_interp_grad", 5);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 6);
        int out_d = CastPyArg2Int(out_d_obj, "nearest_interp_grad", 6);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 7);
        int out_h = CastPyArg2Int(out_h_obj, "nearest_interp_grad", 7);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 8);
        int out_w = CastPyArg2Int(out_w_obj, "nearest_interp_grad", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "nearest_interp_grad", 9);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 10);
        std::string interp_method = CastPyArg2String(interp_method_obj, "nearest_interp_grad", 10);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 11);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "nearest_interp_grad", 11);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 12);
        int align_mode = CastPyArg2Int(align_mode_obj, "nearest_interp_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::nearest_interp_grad(x, out_size, size_tensor, scale_tensor, output_grad, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_nll_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add nll_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "nll_loss_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "nll_loss_grad", 1);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 2);
        auto weight = CastPyArg2OptionalValue(weight_obj, "nll_loss_grad", 2);
        PyObject *total_weight_obj = PyTuple_GET_ITEM(args, 3);
        auto total_weight = CastPyArg2Value(total_weight_obj, "nll_loss_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "nll_loss_grad", 4);

        // Parse Attributes
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 5);
        int64_t ignore_index = CastPyArg2Long(ignore_index_obj, "nll_loss_grad", 5);
        PyObject *reduction_obj = PyTuple_GET_ITEM(args, 6);
        std::string reduction = CastPyArg2String(reduction_obj, "nll_loss_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::nll_loss_grad(input, label, weight, total_weight, out_grad, ignore_index, reduction);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_overlap_add_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add overlap_add_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "overlap_add_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "overlap_add_grad", 1);

        // Parse Attributes
        PyObject *hop_length_obj = PyTuple_GET_ITEM(args, 2);
        int hop_length = CastPyArg2Int(hop_length_obj, "overlap_add_grad", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "overlap_add_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::overlap_add_grad(x, out_grad, hop_length, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_p_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add p_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "p_norm_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "p_norm_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "p_norm_grad", 2);

        // Parse Attributes
        PyObject *porder_obj = PyTuple_GET_ITEM(args, 3);
        float porder = CastPyArg2Float(porder_obj, "p_norm_grad", 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "p_norm_grad", 4);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 5);
        float epsilon = CastPyArg2Float(epsilon_obj, "p_norm_grad", 5);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 6);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "p_norm_grad", 6);
        PyObject *asvector_obj = PyTuple_GET_ITEM(args, 7);
        bool asvector = CastPyArg2Boolean(asvector_obj, "p_norm_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::p_norm_grad(x, out, out_grad, porder, axis, epsilon, keepdim, asvector);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad3d_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad3d_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pad3d_double_grad", 0);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 4);

        // Check for mutable attrs
       pir::Value paddings;

        if (PyObject_CheckIROpResult(paddings_obj)){
             paddings = CastPyArg2Value(paddings_obj, "pad3d_double_grad", 1);
        }else if (PyObject_CheckIRVectorOfOpResult(paddings_obj)){
            std::vector<pir::Value> paddings_tmp = CastPyArg2VectorOfValue(paddings_obj, "pad3d_double_grad", 1);
            paddings = paddle::dialect::stack(paddings_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> paddings_tmp = CastPyArg2Longs(paddings_obj, "pad3d_double_grad", 1);
            paddings = paddle::dialect::full_int_array(paddings_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string mode = CastPyArg2String(mode_obj, "pad3d_double_grad", 2);
            float pad_value = CastPyArg2Float(pad_value_obj, "pad3d_double_grad", 3);
            std::string data_format = CastPyArg2String(data_format_obj, "pad3d_double_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::pad3d_double_grad(grad_x_grad, paddings, mode, pad_value, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad3d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad3d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pad3d_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pad3d_grad", 1);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value paddings;

        if (PyObject_CheckIROpResult(paddings_obj)){
             paddings = CastPyArg2Value(paddings_obj, "pad3d_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(paddings_obj)){
            std::vector<pir::Value> paddings_tmp = CastPyArg2VectorOfValue(paddings_obj, "pad3d_grad", 2);
            paddings = paddle::dialect::stack(paddings_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> paddings_tmp = CastPyArg2Longs(paddings_obj, "pad3d_grad", 2);
            paddings = paddle::dialect::full_int_array(paddings_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string mode = CastPyArg2String(mode_obj, "pad3d_grad", 3);
            float pad_value = CastPyArg2Float(pad_value_obj, "pad3d_grad", 4);
            std::string data_format = CastPyArg2String(data_format_obj, "pad3d_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::pad3d_grad(x, out_grad, paddings, mode, pad_value, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pixel_shuffle_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pixel_shuffle_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pixel_shuffle_grad", 0);

        // Parse Attributes
        PyObject *upscale_factor_obj = PyTuple_GET_ITEM(args, 1);
        int upscale_factor = CastPyArg2Int(upscale_factor_obj, "pixel_shuffle_grad", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "pixel_shuffle_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pixel_shuffle_grad(out_grad, upscale_factor, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pixel_unshuffle_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pixel_unshuffle_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pixel_unshuffle_grad", 0);

        // Parse Attributes
        PyObject *downscale_factor_obj = PyTuple_GET_ITEM(args, 1);
        int downscale_factor = CastPyArg2Int(downscale_factor_obj, "pixel_unshuffle_grad", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "pixel_unshuffle_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pixel_unshuffle_grad(out_grad, downscale_factor, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_poisson_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add poisson_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "poisson_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::poisson_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_polygamma_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add polygamma_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "polygamma_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "polygamma_grad", 1);

        // Parse Attributes
        PyObject *n_obj = PyTuple_GET_ITEM(args, 2);
        int n = CastPyArg2Int(n_obj, "polygamma_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::polygamma_grad(x, out_grad, n);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "pow_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pow_double_grad", 2);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 3);
        float y = CastPyArg2Float(y_obj, "pow_double_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_double_grad(x, grad_out, grad_x_grad, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "pow_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pow_double_grad_", 2);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 3);
        float y = CastPyArg2Float(y_obj, "pow_double_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_double_grad_(x, grad_out, grad_x_grad, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pow_grad", 1);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        float y = CastPyArg2Float(y_obj, "pow_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_grad(x, out_grad, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pow_grad_", 1);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        float y = CastPyArg2Float(y_obj, "pow_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_grad_(x, out_grad, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pow_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pow_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pow_triple_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "pow_triple_grad", 1);
        PyObject *grad_grad_x_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_grad_x = CastPyArg2Value(grad_grad_x_obj, "pow_triple_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pow_triple_grad", 3);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_grad_out_grad = CastPyArg2OptionalValue(grad_grad_out_grad_obj, "pow_triple_grad", 4);

        // Parse Attributes
        PyObject *y_obj = PyTuple_GET_ITEM(args, 5);
        float y = CastPyArg2Float(y_obj, "pow_triple_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::pow_triple_grad(x, grad_out, grad_grad_x, grad_x_grad, grad_grad_out_grad, y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_prelu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add prelu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "prelu_grad", 0);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 1);
        auto alpha = CastPyArg2Value(alpha_obj, "prelu_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "prelu_grad", 2);

        // Parse Attributes
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 3);
        std::string data_format = CastPyArg2String(data_format_obj, "prelu_grad", 3);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 4);
        std::string mode = CastPyArg2String(mode_obj, "prelu_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::prelu_grad(x, alpha, out_grad, data_format, mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_psroi_pool_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add psroi_pool_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "psroi_pool_grad", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "psroi_pool_grad", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "psroi_pool_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "psroi_pool_grad", 3);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 4);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "psroi_pool_grad", 4);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 5);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "psroi_pool_grad", 5);
        PyObject *output_channels_obj = PyTuple_GET_ITEM(args, 6);
        int output_channels = CastPyArg2Int(output_channels_obj, "psroi_pool_grad", 6);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 7);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "psroi_pool_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::psroi_pool_grad(x, boxes, boxes_num, out_grad, pooled_height, pooled_width, output_channels, spatial_scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_put_along_axis_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add put_along_axis_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *arr_obj = PyTuple_GET_ITEM(args, 0);
        auto arr = CastPyArg2Value(arr_obj, "put_along_axis_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "put_along_axis_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "put_along_axis_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "put_along_axis_grad", 3);
        PyObject *reduce_obj = PyTuple_GET_ITEM(args, 4);
        std::string reduce = CastPyArg2String(reduce_obj, "put_along_axis_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::put_along_axis_grad(arr, indices, out_grad, axis, reduce);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_qr_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add qr_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "qr_grad", 0);
        PyObject *q_obj = PyTuple_GET_ITEM(args, 1);
        auto q = CastPyArg2Value(q_obj, "qr_grad", 1);
        PyObject *r_obj = PyTuple_GET_ITEM(args, 2);
        auto r = CastPyArg2Value(r_obj, "qr_grad", 2);
        PyObject *q_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto q_grad = CastPyArg2Value(q_grad_obj, "qr_grad", 3);
        PyObject *r_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto r_grad = CastPyArg2Value(r_grad_obj, "qr_grad", 4);

        // Parse Attributes
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 5);
        std::string mode = CastPyArg2String(mode_obj, "qr_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::qr_grad(x, q, r, q_grad, r_grad, mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_real_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add real_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "real_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::real_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reciprocal_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reciprocal_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "reciprocal_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "reciprocal_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reciprocal_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reciprocal_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reciprocal_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "reciprocal_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "reciprocal_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reciprocal_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu6_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu6_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu6_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "relu6_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu6_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu6_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu6_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu6_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "relu6_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu6_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "relu_double_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu_double_grad(out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu_double_grad_", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "relu_double_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu_double_grad_(out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "relu_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_relu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add relu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "relu_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "relu_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::relu_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_renorm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add renorm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "renorm_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "renorm_grad", 1);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 2);
        float p = CastPyArg2Float(p_obj, "renorm_grad", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "renorm_grad", 3);
        PyObject *max_norm_obj = PyTuple_GET_ITEM(args, 4);
        float max_norm = CastPyArg2Float(max_norm_obj, "renorm_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::renorm_grad(x, out_grad, p, axis, max_norm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roi_align_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roi_align_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roi_align_grad", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "roi_align_grad", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "roi_align_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "roi_align_grad", 3);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 4);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "roi_align_grad", 4);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 5);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "roi_align_grad", 5);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 6);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "roi_align_grad", 6);
        PyObject *sampling_ratio_obj = PyTuple_GET_ITEM(args, 7);
        int sampling_ratio = CastPyArg2Int(sampling_ratio_obj, "roi_align_grad", 7);
        PyObject *aligned_obj = PyTuple_GET_ITEM(args, 8);
        bool aligned = CastPyArg2Boolean(aligned_obj, "roi_align_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::roi_align_grad(x, boxes, boxes_num, out_grad, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roi_pool_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roi_pool_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roi_pool_grad", 0);
        PyObject *boxes_obj = PyTuple_GET_ITEM(args, 1);
        auto boxes = CastPyArg2Value(boxes_obj, "roi_pool_grad", 1);
        PyObject *boxes_num_obj = PyTuple_GET_ITEM(args, 2);
        auto boxes_num = CastPyArg2OptionalValue(boxes_num_obj, "roi_pool_grad", 2);
        PyObject *arg_max_obj = PyTuple_GET_ITEM(args, 3);
        auto arg_max = CastPyArg2Value(arg_max_obj, "roi_pool_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "roi_pool_grad", 4);

        // Parse Attributes
        PyObject *pooled_height_obj = PyTuple_GET_ITEM(args, 5);
        int pooled_height = CastPyArg2Int(pooled_height_obj, "roi_pool_grad", 5);
        PyObject *pooled_width_obj = PyTuple_GET_ITEM(args, 6);
        int pooled_width = CastPyArg2Int(pooled_width_obj, "roi_pool_grad", 6);
        PyObject *spatial_scale_obj = PyTuple_GET_ITEM(args, 7);
        float spatial_scale = CastPyArg2Float(spatial_scale_obj, "roi_pool_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::roi_pool_grad(x, boxes, boxes_num, arg_max, out_grad, pooled_height, pooled_width, spatial_scale);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_roll_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add roll_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "roll_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "roll_grad", 1);

        // Parse Attributes
        PyObject *shifts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value shifts;

        if (PyObject_CheckIROpResult(shifts_obj)){
             shifts = CastPyArg2Value(shifts_obj, "roll_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(shifts_obj)){
            std::vector<pir::Value> shifts_tmp = CastPyArg2VectorOfValue(shifts_obj, "roll_grad", 2);
            shifts = paddle::dialect::stack(shifts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> shifts_tmp = CastPyArg2Longs(shifts_obj, "roll_grad", 2);
            shifts = paddle::dialect::full_int_array(shifts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "roll_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::roll_grad(x, out_grad, shifts, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_round_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add round_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "round_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::round_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_round_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add round_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "round_grad_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::round_grad_(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "rsqrt_double_grad", 0);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x = CastPyArg2Value(grad_x_obj, "rsqrt_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "rsqrt_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt_double_grad(out, grad_x, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "rsqrt_double_grad_", 0);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x = CastPyArg2Value(grad_x_obj, "rsqrt_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "rsqrt_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt_double_grad_(out, grad_x, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "rsqrt_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "rsqrt_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rsqrt_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rsqrt_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "rsqrt_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "rsqrt_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rsqrt_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scatter_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scatter_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *index_obj = PyTuple_GET_ITEM(args, 0);
        auto index = CastPyArg2Value(index_obj, "scatter_grad", 0);
        PyObject *updates_obj = PyTuple_GET_ITEM(args, 1);
        auto updates = CastPyArg2Value(updates_obj, "scatter_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "scatter_grad", 2);

        // Parse Attributes
        PyObject *overwrite_obj = PyTuple_GET_ITEM(args, 3);
        bool overwrite = CastPyArg2Boolean(overwrite_obj, "scatter_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::scatter_grad(index, updates, out_grad, overwrite);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_scatter_nd_add_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add scatter_nd_add_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *index_obj = PyTuple_GET_ITEM(args, 0);
        auto index = CastPyArg2Value(index_obj, "scatter_nd_add_grad", 0);
        PyObject *updates_obj = PyTuple_GET_ITEM(args, 1);
        auto updates = CastPyArg2Value(updates_obj, "scatter_nd_add_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "scatter_nd_add_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::scatter_nd_add_grad(index, updates, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_segment_pool_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add segment_pool_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "segment_pool_grad", 0);
        PyObject *segment_ids_obj = PyTuple_GET_ITEM(args, 1);
        auto segment_ids = CastPyArg2Value(segment_ids_obj, "segment_pool_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "segment_pool_grad", 2);
        PyObject *summed_ids_obj = PyTuple_GET_ITEM(args, 3);
        auto summed_ids = CastPyArg2OptionalValue(summed_ids_obj, "segment_pool_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "segment_pool_grad", 4);

        // Parse Attributes
        PyObject *pooltype_obj = PyTuple_GET_ITEM(args, 5);
        std::string pooltype = CastPyArg2String(pooltype_obj, "segment_pool_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::segment_pool_grad(x, segment_ids, out, summed_ids, out_grad, pooltype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_selu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add selu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "selu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "selu_grad", 1);

        // Parse Attributes
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 2);
        float scale = CastPyArg2Float(scale_obj, "selu_grad", 2);
        PyObject *alpha_obj = PyTuple_GET_ITEM(args, 3);
        float alpha = CastPyArg2Float(alpha_obj, "selu_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::selu_grad(out, out_grad, scale, alpha);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_u_recv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_u_recv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_u_recv_grad", 0);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 1);
        auto src_index = CastPyArg2Value(src_index_obj, "send_u_recv_grad", 1);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 2);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_u_recv_grad", 2);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 3);
        auto out = CastPyArg2OptionalValue(out_obj, "send_u_recv_grad", 3);
        PyObject *dst_count_obj = PyTuple_GET_ITEM(args, 4);
        auto dst_count = CastPyArg2OptionalValue(dst_count_obj, "send_u_recv_grad", 4);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto out_grad = CastPyArg2Value(out_grad_obj, "send_u_recv_grad", 5);

        // Parse Attributes
        PyObject *reduce_op_obj = PyTuple_GET_ITEM(args, 6);
        std::string reduce_op = CastPyArg2String(reduce_op_obj, "send_u_recv_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::send_u_recv_grad(x, src_index, dst_index, out, dst_count, out_grad, reduce_op);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_ue_recv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_ue_recv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_ue_recv_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "send_ue_recv_grad", 1);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 2);
        auto src_index = CastPyArg2Value(src_index_obj, "send_ue_recv_grad", 2);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 3);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_ue_recv_grad", 3);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 4);
        auto out = CastPyArg2OptionalValue(out_obj, "send_ue_recv_grad", 4);
        PyObject *dst_count_obj = PyTuple_GET_ITEM(args, 5);
        auto dst_count = CastPyArg2OptionalValue(dst_count_obj, "send_ue_recv_grad", 5);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto out_grad = CastPyArg2Value(out_grad_obj, "send_ue_recv_grad", 6);

        // Parse Attributes
        PyObject *message_op_obj = PyTuple_GET_ITEM(args, 7);
        std::string message_op = CastPyArg2String(message_op_obj, "send_ue_recv_grad", 7);
        PyObject *reduce_op_obj = PyTuple_GET_ITEM(args, 8);
        std::string reduce_op = CastPyArg2String(reduce_op_obj, "send_ue_recv_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::send_ue_recv_grad(x, y, src_index, dst_index, out, dst_count, out_grad, message_op, reduce_op);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_send_uv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add send_uv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "send_uv_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "send_uv_grad", 1);
        PyObject *src_index_obj = PyTuple_GET_ITEM(args, 2);
        auto src_index = CastPyArg2Value(src_index_obj, "send_uv_grad", 2);
        PyObject *dst_index_obj = PyTuple_GET_ITEM(args, 3);
        auto dst_index = CastPyArg2Value(dst_index_obj, "send_uv_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "send_uv_grad", 4);

        // Parse Attributes
        PyObject *message_op_obj = PyTuple_GET_ITEM(args, 5);
        std::string message_op = CastPyArg2String(message_op_obj, "send_uv_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::send_uv_grad(x, y, src_index, dst_index, out_grad, message_op);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_cross_entropy_with_logits_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_cross_entropy_with_logits_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid_cross_entropy_with_logits_grad", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "sigmoid_cross_entropy_with_logits_grad", 1);
        PyObject *pos_weight_obj = PyTuple_GET_ITEM(args, 2);
        auto pos_weight = CastPyArg2OptionalValue(pos_weight_obj, "sigmoid_cross_entropy_with_logits_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sigmoid_cross_entropy_with_logits_grad", 3);

        // Parse Attributes
        PyObject *normalize_obj = PyTuple_GET_ITEM(args, 4);
        bool normalize = CastPyArg2Boolean(normalize_obj, "sigmoid_cross_entropy_with_logits_grad", 4);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 5);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "sigmoid_cross_entropy_with_logits_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_cross_entropy_with_logits_grad(x, label, pos_weight, out_grad, normalize, ignore_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_cross_entropy_with_logits_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_cross_entropy_with_logits_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sigmoid_cross_entropy_with_logits_grad_", 0);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 1);
        auto label = CastPyArg2Value(label_obj, "sigmoid_cross_entropy_with_logits_grad_", 1);
        PyObject *pos_weight_obj = PyTuple_GET_ITEM(args, 2);
        auto pos_weight = CastPyArg2OptionalValue(pos_weight_obj, "sigmoid_cross_entropy_with_logits_grad_", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sigmoid_cross_entropy_with_logits_grad_", 3);

        // Parse Attributes
        PyObject *normalize_obj = PyTuple_GET_ITEM(args, 4);
        bool normalize = CastPyArg2Boolean(normalize_obj, "sigmoid_cross_entropy_with_logits_grad_", 4);
        PyObject *ignore_index_obj = PyTuple_GET_ITEM(args, 5);
        int ignore_index = CastPyArg2Int(ignore_index_obj, "sigmoid_cross_entropy_with_logits_grad_", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_cross_entropy_with_logits_grad_(x, label, pos_weight, out_grad, normalize, ignore_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_double_grad", 0);
        PyObject *fwd_grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto fwd_grad_out = CastPyArg2Value(fwd_grad_out_obj, "sigmoid_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sigmoid_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_double_grad(out, fwd_grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_double_grad_", 0);
        PyObject *fwd_grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto fwd_grad_out = CastPyArg2Value(fwd_grad_out_obj, "sigmoid_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sigmoid_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_double_grad_(out, fwd_grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sigmoid_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sigmoid_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_triple_grad", 0);
        PyObject *fwd_grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto fwd_grad_out = CastPyArg2Value(fwd_grad_out_obj, "sigmoid_triple_grad", 1);
        PyObject *grad_grad_x_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_grad_x = CastPyArg2Value(grad_grad_x_obj, "sigmoid_triple_grad", 2);
        PyObject *grad_out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_out_grad = CastPyArg2Value(grad_out_grad_obj, "sigmoid_triple_grad", 3);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_grad_out_grad = CastPyArg2OptionalValue(grad_grad_out_grad_obj, "sigmoid_triple_grad", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_triple_grad(out, fwd_grad_out, grad_grad_x, grad_out_grad, grad_grad_out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sigmoid_triple_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sigmoid_triple_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sigmoid_triple_grad_", 0);
        PyObject *fwd_grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto fwd_grad_out = CastPyArg2Value(fwd_grad_out_obj, "sigmoid_triple_grad_", 1);
        PyObject *grad_grad_x_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_grad_x = CastPyArg2Value(grad_grad_x_obj, "sigmoid_triple_grad_", 2);
        PyObject *grad_out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_out_grad = CastPyArg2Value(grad_out_grad_obj, "sigmoid_triple_grad_", 3);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_grad_out_grad = CastPyArg2OptionalValue(grad_grad_out_grad_obj, "sigmoid_triple_grad_", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sigmoid_triple_grad_(out, fwd_grad_out, grad_grad_x, grad_out_grad, grad_grad_out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_silu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add silu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "silu_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "silu_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "silu_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::silu_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_silu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add silu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "silu_grad_", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "silu_grad_", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "silu_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::silu_grad_(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2OptionalValue(grad_out_obj, "sin_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sin_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_double_grad(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2OptionalValue(grad_out_obj, "sin_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sin_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_double_grad_(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sin_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sin_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_triple_grad", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2OptionalValue(grad_out_forward_obj, "sin_triple_grad", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2OptionalValue(grad_x_grad_forward_obj, "sin_triple_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sin_triple_grad", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "sin_triple_grad", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_triple_grad(x, grad_out_forward, grad_x_grad_forward, grad_x_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sin_triple_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sin_triple_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sin_triple_grad_", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2OptionalValue(grad_out_forward_obj, "sin_triple_grad_", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2OptionalValue(grad_x_grad_forward_obj, "sin_triple_grad_", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sin_triple_grad_", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "sin_triple_grad_", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sin_triple_grad_(x, grad_out_forward, grad_x_grad_forward, grad_x_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sinh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sinh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sinh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sinh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sinh_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sinh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sinh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "sinh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sinh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sinh_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_slogdet_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add slogdet_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "slogdet_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "slogdet_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "slogdet_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::slogdet_grad(x, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softplus_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softplus_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softplus_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "softplus_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "softplus_double_grad", 2);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 3);
        float beta = CastPyArg2Float(beta_obj, "softplus_double_grad", 3);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 4);
        float threshold = CastPyArg2Float(threshold_obj, "softplus_double_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::softplus_double_grad(x, grad_out, grad_x_grad, beta, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softplus_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softplus_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softplus_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "softplus_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "softplus_double_grad_", 2);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 3);
        float beta = CastPyArg2Float(beta_obj, "softplus_double_grad_", 3);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 4);
        float threshold = CastPyArg2Float(threshold_obj, "softplus_double_grad_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::softplus_double_grad_(x, grad_out, grad_x_grad, beta, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softplus_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softplus_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softplus_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softplus_grad", 1);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 2);
        float beta = CastPyArg2Float(beta_obj, "softplus_grad", 2);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 3);
        float threshold = CastPyArg2Float(threshold_obj, "softplus_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::softplus_grad(x, out_grad, beta, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softplus_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softplus_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softplus_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softplus_grad_", 1);

        // Parse Attributes
        PyObject *beta_obj = PyTuple_GET_ITEM(args, 2);
        float beta = CastPyArg2Float(beta_obj, "softplus_grad_", 2);
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 3);
        float threshold = CastPyArg2Float(threshold_obj, "softplus_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::softplus_grad_(x, out_grad, beta, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softshrink_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softshrink_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softshrink_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softshrink_grad", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "softshrink_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::softshrink_grad(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softshrink_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softshrink_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softshrink_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softshrink_grad_", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "softshrink_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::softshrink_grad_(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softsign_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softsign_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softsign_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softsign_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::softsign_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_softsign_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add softsign_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "softsign_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "softsign_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::softsign_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_solve_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add solve_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "solve_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "solve_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "solve_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "solve_grad", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::solve_grad(x, y, out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_spectral_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add spectral_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 0);
        auto weight = CastPyArg2Value(weight_obj, "spectral_norm_grad", 0);
        PyObject *u_obj = PyTuple_GET_ITEM(args, 1);
        auto u = CastPyArg2Value(u_obj, "spectral_norm_grad", 1);
        PyObject *v_obj = PyTuple_GET_ITEM(args, 2);
        auto v = CastPyArg2Value(v_obj, "spectral_norm_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "spectral_norm_grad", 3);

        // Parse Attributes
        PyObject *dim_obj = PyTuple_GET_ITEM(args, 4);
        int dim = CastPyArg2Int(dim_obj, "spectral_norm_grad", 4);
        PyObject *power_iters_obj = PyTuple_GET_ITEM(args, 5);
        int power_iters = CastPyArg2Int(power_iters_obj, "spectral_norm_grad", 5);
        PyObject *eps_obj = PyTuple_GET_ITEM(args, 6);
        float eps = CastPyArg2Float(eps_obj, "spectral_norm_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::spectral_norm_grad(weight, u, v, out_grad, dim, power_iters, eps);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sqrt_double_grad", 0);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x = CastPyArg2Value(grad_x_obj, "sqrt_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sqrt_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt_double_grad(out, grad_x, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sqrt_double_grad_", 0);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x = CastPyArg2Value(grad_x_obj, "sqrt_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "sqrt_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt_double_grad_(out, grad_x, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sqrt_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sqrt_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_sqrt_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add sqrt_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "sqrt_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "sqrt_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::sqrt_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_square_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add square_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "square_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "square_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "square_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::square_double_grad(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_square_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add square_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "square_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "square_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "square_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::square_double_grad_(x, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_square_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add square_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "square_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "square_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::square_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_square_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add square_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "square_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "square_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::square_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squared_l2_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squared_l2_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "squared_l2_norm_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "squared_l2_norm_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::squared_l2_norm_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squeeze_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squeeze_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "squeeze_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "squeeze_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "squeeze_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "squeeze_grad", 2);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "squeeze_grad", 2);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::squeeze_grad(xshape, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_squeeze_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add squeeze_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "squeeze_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "squeeze_grad_", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "squeeze_grad_", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "squeeze_grad_", 2);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "squeeze_grad_", 2);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::squeeze_grad_(xshape, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_stack_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add stack_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2VectorOfValue(x_obj, "stack_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "stack_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int axis = CastPyArg2Int(axis_obj, "stack_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::stack_grad(x, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_stanh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add stanh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "stanh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "stanh_grad", 1);

        // Parse Attributes
        PyObject *scale_a_obj = PyTuple_GET_ITEM(args, 2);
        float scale_a = CastPyArg2Float(scale_a_obj, "stanh_grad", 2);
        PyObject *scale_b_obj = PyTuple_GET_ITEM(args, 3);
        float scale_b = CastPyArg2Float(scale_b_obj, "stanh_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::stanh_grad(x, out_grad, scale_a, scale_b);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_svd_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add svd_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "svd_grad", 0);
        PyObject *u_obj = PyTuple_GET_ITEM(args, 1);
        auto u = CastPyArg2Value(u_obj, "svd_grad", 1);
        PyObject *vh_obj = PyTuple_GET_ITEM(args, 2);
        auto vh = CastPyArg2Value(vh_obj, "svd_grad", 2);
        PyObject *s_obj = PyTuple_GET_ITEM(args, 3);
        auto s = CastPyArg2Value(s_obj, "svd_grad", 3);
        PyObject *u_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto u_grad = CastPyArg2OptionalValue(u_grad_obj, "svd_grad", 4);
        PyObject *vh_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto vh_grad = CastPyArg2OptionalValue(vh_grad_obj, "svd_grad", 5);
        PyObject *s_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto s_grad = CastPyArg2OptionalValue(s_grad_obj, "svd_grad", 6);

        // Parse Attributes
        PyObject *full_matrices_obj = PyTuple_GET_ITEM(args, 7);
        bool full_matrices = CastPyArg2Boolean(full_matrices_obj, "svd_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::svd_grad(x, u, vh, s, u_grad, vh_grad, s_grad, full_matrices);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_take_along_axis_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add take_along_axis_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *arr_obj = PyTuple_GET_ITEM(args, 0);
        auto arr = CastPyArg2Value(arr_obj, "take_along_axis_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "take_along_axis_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "take_along_axis_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "take_along_axis_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::take_along_axis_grad(arr, indices, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tan_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tan_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tan_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tan_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tan_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tan_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tan_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tan_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tan_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tan_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "tanh_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "tanh_double_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_double_grad(out, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "tanh_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "tanh_double_grad_", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_double_grad_(out, grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tanh_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_grad(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tanh_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_grad_(out, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_shrink_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_shrink_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tanh_shrink_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tanh_shrink_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_shrink_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_shrink_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_shrink_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "tanh_shrink_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tanh_shrink_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_shrink_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_triple_grad", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2Value(grad_out_forward_obj, "tanh_triple_grad", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2Value(grad_x_grad_forward_obj, "tanh_triple_grad", 2);
        PyObject *grad_out_new_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_out_new_grad = CastPyArg2OptionalValue(grad_out_new_grad_obj, "tanh_triple_grad", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "tanh_triple_grad", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_triple_grad(out, grad_out_forward, grad_x_grad_forward, grad_out_new_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tanh_triple_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tanh_triple_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_obj = PyTuple_GET_ITEM(args, 0);
        auto out = CastPyArg2Value(out_obj, "tanh_triple_grad_", 0);
        PyObject *grad_out_forward_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out_forward = CastPyArg2Value(grad_out_forward_obj, "tanh_triple_grad_", 1);
        PyObject *grad_x_grad_forward_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad_forward = CastPyArg2Value(grad_x_grad_forward_obj, "tanh_triple_grad_", 2);
        PyObject *grad_out_new_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_out_new_grad = CastPyArg2OptionalValue(grad_out_new_grad_obj, "tanh_triple_grad_", 3);
        PyObject *grad_out_grad_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_out_grad_grad = CastPyArg2OptionalValue(grad_out_grad_grad_obj, "tanh_triple_grad_", 4);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::tanh_triple_grad_(out, grad_out_forward, grad_x_grad_forward, grad_out_new_grad, grad_out_grad_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_temporal_shift_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add temporal_shift_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "temporal_shift_grad", 0);

        // Parse Attributes
        PyObject *seg_num_obj = PyTuple_GET_ITEM(args, 1);
        int seg_num = CastPyArg2Int(seg_num_obj, "temporal_shift_grad", 1);
        PyObject *shift_ratio_obj = PyTuple_GET_ITEM(args, 2);
        float shift_ratio = CastPyArg2Float(shift_ratio_obj, "temporal_shift_grad", 2);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 3);
        std::string data_format = CastPyArg2String(data_format_obj, "temporal_shift_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::temporal_shift_grad(out_grad, seg_num, shift_ratio, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_tensor_unfold_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add tensor_unfold_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "tensor_unfold_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "tensor_unfold_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        int64_t axis = CastPyArg2Long(axis_obj, "tensor_unfold_grad", 2);
        PyObject *size_obj = PyTuple_GET_ITEM(args, 3);
        int64_t size = CastPyArg2Long(size_obj, "tensor_unfold_grad", 3);
        PyObject *step_obj = PyTuple_GET_ITEM(args, 4);
        int64_t step = CastPyArg2Long(step_obj, "tensor_unfold_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::tensor_unfold_grad(input, out_grad, axis, size, step);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_thresholded_relu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add thresholded_relu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "thresholded_relu_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "thresholded_relu_grad", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "thresholded_relu_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::thresholded_relu_grad(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_thresholded_relu_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add thresholded_relu_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "thresholded_relu_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "thresholded_relu_grad_", 1);

        // Parse Attributes
        PyObject *threshold_obj = PyTuple_GET_ITEM(args, 2);
        float threshold = CastPyArg2Float(threshold_obj, "thresholded_relu_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::thresholded_relu_grad_(x, out_grad, threshold);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_topk_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add topk_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "topk_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "topk_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "topk_grad", 2);

        // Parse Attributes
        PyObject *k_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *largest_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *sorted_obj = PyTuple_GET_ITEM(args, 6);

        // Check for mutable attrs
       pir::Value k;

        if (PyObject_CheckIROpResult(k_obj)){
             k = CastPyArg2Value(k_obj, "topk_grad", 3);
        }else{
            int k_tmp = CastPyArg2Int(k_obj, "topk_grad", 3);
            k = paddle::dialect::full(std::vector<int64_t>{1}, k_tmp, phi::DataType::INT32, phi::CPUPlace());

        }
            int axis = CastPyArg2Int(axis_obj, "topk_grad", 4);
            bool largest = CastPyArg2Boolean(largest_obj, "topk_grad", 5);
            bool sorted = CastPyArg2Boolean(sorted_obj, "topk_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::topk_grad(x, indices, out_grad, k, axis, largest, sorted);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trace_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trace_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "trace_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "trace_grad", 1);

        // Parse Attributes
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 2);
        int offset = CastPyArg2Int(offset_obj, "trace_grad", 2);
        PyObject *axis1_obj = PyTuple_GET_ITEM(args, 3);
        int axis1 = CastPyArg2Int(axis1_obj, "trace_grad", 3);
        PyObject *axis2_obj = PyTuple_GET_ITEM(args, 4);
        int axis2 = CastPyArg2Int(axis2_obj, "trace_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::trace_grad(x, out_grad, offset, axis1, axis2);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_triangular_solve_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add triangular_solve_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "triangular_solve_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "triangular_solve_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "triangular_solve_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "triangular_solve_grad", 3);

        // Parse Attributes
        PyObject *upper_obj = PyTuple_GET_ITEM(args, 4);
        bool upper = CastPyArg2Boolean(upper_obj, "triangular_solve_grad", 4);
        PyObject *transpose_obj = PyTuple_GET_ITEM(args, 5);
        bool transpose = CastPyArg2Boolean(transpose_obj, "triangular_solve_grad", 5);
        PyObject *unitriangular_obj = PyTuple_GET_ITEM(args, 6);
        bool unitriangular = CastPyArg2Boolean(unitriangular_obj, "triangular_solve_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::triangular_solve_grad(x, y, out, out_grad, upper, transpose, unitriangular);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trilinear_interp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trilinear_interp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "trilinear_interp_grad", 0);
        PyObject *out_size_obj = PyTuple_GET_ITEM(args, 1);
        auto out_size = CastPyArg2OptionalValue(out_size_obj, "trilinear_interp_grad", 1);
        PyObject *size_tensor_obj = PyTuple_GET_ITEM(args, 2);
        auto size_tensor = CastPyArg2OptionalVectorOfValue(size_tensor_obj, "trilinear_interp_grad", 2);
        PyObject *scale_tensor_obj = PyTuple_GET_ITEM(args, 3);
        auto scale_tensor = CastPyArg2OptionalValue(scale_tensor_obj, "trilinear_interp_grad", 3);
        PyObject *output_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto output_grad = CastPyArg2Value(output_grad_obj, "trilinear_interp_grad", 4);

        // Parse Attributes
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 5);
        std::string data_layout = CastPyArg2String(data_layout_obj, "trilinear_interp_grad", 5);
        PyObject *out_d_obj = PyTuple_GET_ITEM(args, 6);
        int out_d = CastPyArg2Int(out_d_obj, "trilinear_interp_grad", 6);
        PyObject *out_h_obj = PyTuple_GET_ITEM(args, 7);
        int out_h = CastPyArg2Int(out_h_obj, "trilinear_interp_grad", 7);
        PyObject *out_w_obj = PyTuple_GET_ITEM(args, 8);
        int out_w = CastPyArg2Int(out_w_obj, "trilinear_interp_grad", 8);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 9);
        std::vector<float> scale = CastPyArg2Floats(scale_obj, "trilinear_interp_grad", 9);
        PyObject *interp_method_obj = PyTuple_GET_ITEM(args, 10);
        std::string interp_method = CastPyArg2String(interp_method_obj, "trilinear_interp_grad", 10);
        PyObject *align_corners_obj = PyTuple_GET_ITEM(args, 11);
        bool align_corners = CastPyArg2Boolean(align_corners_obj, "trilinear_interp_grad", 11);
        PyObject *align_mode_obj = PyTuple_GET_ITEM(args, 12);
        int align_mode = CastPyArg2Int(align_mode_obj, "trilinear_interp_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::trilinear_interp_grad(x, out_size, size_tensor, scale_tensor, output_grad, data_layout, out_d, out_h, out_w, scale, interp_method, align_corners, align_mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_trunc_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add trunc_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "trunc_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::trunc_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unfold_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unfold_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unfold_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "unfold_grad", 1);

        // Parse Attributes
        PyObject *kernel_sizes_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int> kernel_sizes = CastPyArg2Ints(kernel_sizes_obj, "unfold_grad", 2);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "unfold_grad", 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "unfold_grad", 4);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "unfold_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::unfold_grad(x, out_grad, kernel_sizes, strides, paddings, dilations);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_uniform_inplace_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add uniform_inplace_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "uniform_inplace_grad", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        float min = CastPyArg2Float(min_obj, "uniform_inplace_grad", 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);
        float max = CastPyArg2Float(max_obj, "uniform_inplace_grad", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "uniform_inplace_grad", 3);
        PyObject *diag_num_obj = PyTuple_GET_ITEM(args, 4);
        int diag_num = CastPyArg2Int(diag_num_obj, "uniform_inplace_grad", 4);
        PyObject *diag_step_obj = PyTuple_GET_ITEM(args, 5);
        int diag_step = CastPyArg2Int(diag_step_obj, "uniform_inplace_grad", 5);
        PyObject *diag_val_obj = PyTuple_GET_ITEM(args, 6);
        float diag_val = CastPyArg2Float(diag_val_obj, "uniform_inplace_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::uniform_inplace_grad(out_grad, min, max, seed, diag_num, diag_step, diag_val);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_uniform_inplace_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add uniform_inplace_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "uniform_inplace_grad_", 0);

        // Parse Attributes
        PyObject *min_obj = PyTuple_GET_ITEM(args, 1);
        float min = CastPyArg2Float(min_obj, "uniform_inplace_grad_", 1);
        PyObject *max_obj = PyTuple_GET_ITEM(args, 2);
        float max = CastPyArg2Float(max_obj, "uniform_inplace_grad_", 2);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 3);
        int seed = CastPyArg2Int(seed_obj, "uniform_inplace_grad_", 3);
        PyObject *diag_num_obj = PyTuple_GET_ITEM(args, 4);
        int diag_num = CastPyArg2Int(diag_num_obj, "uniform_inplace_grad_", 4);
        PyObject *diag_step_obj = PyTuple_GET_ITEM(args, 5);
        int diag_step = CastPyArg2Int(diag_step_obj, "uniform_inplace_grad_", 5);
        PyObject *diag_val_obj = PyTuple_GET_ITEM(args, 6);
        float diag_val = CastPyArg2Float(diag_val_obj, "uniform_inplace_grad_", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::uniform_inplace_grad_(out_grad, min, max, seed, diag_num, diag_step, diag_val);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unsqueeze_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unsqueeze_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "unsqueeze_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "unsqueeze_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "unsqueeze_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "unsqueeze_grad", 2);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "unsqueeze_grad", 2);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::unsqueeze_grad(xshape, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unsqueeze_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unsqueeze_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "unsqueeze_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "unsqueeze_grad_", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "unsqueeze_grad_", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "unsqueeze_grad_", 2);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "unsqueeze_grad_", 2);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::unsqueeze_grad_(xshape, out_grad, axis);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unstack_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unstack_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2VectorOfValue(out_grad_obj, "unstack_grad", 0);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 1);
        int axis = CastPyArg2Int(axis_obj, "unstack_grad", 1);

        // Call ir static api
        auto static_api_out = paddle::dialect::unstack_grad(out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_view_dtype_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add view_dtype_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "view_dtype_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "view_dtype_grad", 1);

        // Parse Attributes
        PyObject *dtype_obj = PyTuple_GET_ITEM(args, 2);
        phi::DataType dtype = CastPyArg2DataTypeDirectly(dtype_obj, "view_dtype_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::view_dtype_grad(input, out_grad, dtype);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_view_shape_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add view_shape_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "view_shape_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "view_shape_grad", 1);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int64_t> dims = CastPyArg2Longs(dims_obj, "view_shape_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::view_shape_grad(input, out_grad, dims);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_warpctc_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add warpctc_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *logits_obj = PyTuple_GET_ITEM(args, 0);
        auto logits = CastPyArg2Value(logits_obj, "warpctc_grad", 0);
        PyObject *logits_length_obj = PyTuple_GET_ITEM(args, 1);
        auto logits_length = CastPyArg2OptionalValue(logits_length_obj, "warpctc_grad", 1);
        PyObject *warpctcgrad_obj = PyTuple_GET_ITEM(args, 2);
        auto warpctcgrad = CastPyArg2Value(warpctcgrad_obj, "warpctc_grad", 2);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "warpctc_grad", 3);

        // Parse Attributes
        PyObject *blank_obj = PyTuple_GET_ITEM(args, 4);
        int blank = CastPyArg2Int(blank_obj, "warpctc_grad", 4);
        PyObject *norm_by_times_obj = PyTuple_GET_ITEM(args, 5);
        bool norm_by_times = CastPyArg2Boolean(norm_by_times_obj, "warpctc_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::warpctc_grad(logits, logits_length, warpctcgrad, loss_grad, blank, norm_by_times);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_warprnnt_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add warprnnt_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "warprnnt_grad", 0);
        PyObject *input_lengths_obj = PyTuple_GET_ITEM(args, 1);
        auto input_lengths = CastPyArg2Value(input_lengths_obj, "warprnnt_grad", 1);
        PyObject *warprnntgrad_obj = PyTuple_GET_ITEM(args, 2);
        auto warprnntgrad = CastPyArg2Value(warprnntgrad_obj, "warprnnt_grad", 2);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "warprnnt_grad", 3);

        // Parse Attributes
        PyObject *blank_obj = PyTuple_GET_ITEM(args, 4);
        int blank = CastPyArg2Int(blank_obj, "warprnnt_grad", 4);
        PyObject *fastemit_lambda_obj = PyTuple_GET_ITEM(args, 5);
        float fastemit_lambda = CastPyArg2Float(fastemit_lambda_obj, "warprnnt_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::warprnnt_grad(input, input_lengths, warprnntgrad, loss_grad, blank, fastemit_lambda);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_weight_only_linear_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add weight_only_linear_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "weight_only_linear_grad", 0);
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 1);
        auto weight = CastPyArg2Value(weight_obj, "weight_only_linear_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "weight_only_linear_grad", 2);
        PyObject *weight_scale_obj = PyTuple_GET_ITEM(args, 3);
        auto weight_scale = CastPyArg2Value(weight_scale_obj, "weight_only_linear_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "weight_only_linear_grad", 4);

        // Parse Attributes
        PyObject *weight_dtype_obj = PyTuple_GET_ITEM(args, 5);
        std::string weight_dtype = CastPyArg2String(weight_dtype_obj, "weight_only_linear_grad", 5);
        PyObject *arch_obj = PyTuple_GET_ITEM(args, 6);
        int arch = CastPyArg2Int(arch_obj, "weight_only_linear_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::weight_only_linear_grad(x, weight, bias, weight_scale, out_grad, weight_dtype, arch);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_where_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add where_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *condition_obj = PyTuple_GET_ITEM(args, 0);
        auto condition = CastPyArg2Value(condition_obj, "where_grad", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "where_grad", 1);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 2);
        auto y = CastPyArg2Value(y_obj, "where_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "where_grad", 3);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::where_grad(condition, x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_yolo_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add yolo_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "yolo_loss_grad", 0);
        PyObject *gt_box_obj = PyTuple_GET_ITEM(args, 1);
        auto gt_box = CastPyArg2Value(gt_box_obj, "yolo_loss_grad", 1);
        PyObject *gt_label_obj = PyTuple_GET_ITEM(args, 2);
        auto gt_label = CastPyArg2Value(gt_label_obj, "yolo_loss_grad", 2);
        PyObject *gt_score_obj = PyTuple_GET_ITEM(args, 3);
        auto gt_score = CastPyArg2OptionalValue(gt_score_obj, "yolo_loss_grad", 3);
        PyObject *objectness_mask_obj = PyTuple_GET_ITEM(args, 4);
        auto objectness_mask = CastPyArg2Value(objectness_mask_obj, "yolo_loss_grad", 4);
        PyObject *gt_match_mask_obj = PyTuple_GET_ITEM(args, 5);
        auto gt_match_mask = CastPyArg2Value(gt_match_mask_obj, "yolo_loss_grad", 5);
        PyObject *loss_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto loss_grad = CastPyArg2Value(loss_grad_obj, "yolo_loss_grad", 6);

        // Parse Attributes
        PyObject *anchors_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<int> anchors = CastPyArg2Ints(anchors_obj, "yolo_loss_grad", 7);
        PyObject *anchor_mask_obj = PyTuple_GET_ITEM(args, 8);
        std::vector<int> anchor_mask = CastPyArg2Ints(anchor_mask_obj, "yolo_loss_grad", 8);
        PyObject *class_num_obj = PyTuple_GET_ITEM(args, 9);
        int class_num = CastPyArg2Int(class_num_obj, "yolo_loss_grad", 9);
        PyObject *ignore_thresh_obj = PyTuple_GET_ITEM(args, 10);
        float ignore_thresh = CastPyArg2Float(ignore_thresh_obj, "yolo_loss_grad", 10);
        PyObject *downsample_ratio_obj = PyTuple_GET_ITEM(args, 11);
        int downsample_ratio = CastPyArg2Int(downsample_ratio_obj, "yolo_loss_grad", 11);
        PyObject *use_label_smooth_obj = PyTuple_GET_ITEM(args, 12);
        bool use_label_smooth = CastPyArg2Boolean(use_label_smooth_obj, "yolo_loss_grad", 12);
        PyObject *scale_x_y_obj = PyTuple_GET_ITEM(args, 13);
        float scale_x_y = CastPyArg2Float(scale_x_y_obj, "yolo_loss_grad", 13);

        // Call ir static api
        auto static_api_out = paddle::dialect::yolo_loss_grad(x, gt_box, gt_label, gt_score, objectness_mask, gt_match_mask, loss_grad, anchors, anchor_mask, class_num, ignore_thresh, downsample_ratio, use_label_smooth, scale_x_y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_unpool3d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add unpool3d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "unpool3d_grad", 0);
        PyObject *indices_obj = PyTuple_GET_ITEM(args, 1);
        auto indices = CastPyArg2Value(indices_obj, "unpool3d_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "unpool3d_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "unpool3d_grad", 3);

        // Parse Attributes
        PyObject *ksize_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> ksize = CastPyArg2Ints(ksize_obj, "unpool3d_grad", 4);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "unpool3d_grad", 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "unpool3d_grad", 6);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<int> output_size = CastPyArg2Ints(output_size_obj, "unpool3d_grad", 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_format = CastPyArg2String(data_format_obj, "unpool3d_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::unpool3d_grad(x, indices, out, out_grad, ksize, strides, paddings, output_size, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *y_obj = PyTuple_GET_ITEM(args, 0);
        auto y = CastPyArg2Value(y_obj, "add_double_grad", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "add_double_grad", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "add_double_grad", 2);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "add_double_grad", 3);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "add_double_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_double_grad(y, grad_out, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *y_obj = PyTuple_GET_ITEM(args, 0);
        auto y = CastPyArg2Value(y_obj, "add_double_grad_", 0);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_out = CastPyArg2Value(grad_out_obj, "add_double_grad_", 1);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "add_double_grad_", 2);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "add_double_grad_", 3);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "add_double_grad_", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_double_grad_(y, grad_out, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "add_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "add_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "add_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "add_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_grad(x, y, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "add_grad_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "add_grad_", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "add_grad_", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "add_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_grad_(x, y, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_grad_x_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_grad_x = CastPyArg2Value(grad_grad_x_obj, "add_triple_grad", 0);
        PyObject *grad_grad_y_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_grad_y = CastPyArg2Value(grad_grad_y_obj, "add_triple_grad", 1);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_grad_out_grad = CastPyArg2Value(grad_grad_out_grad_obj, "add_triple_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "add_triple_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_triple_grad(grad_grad_x, grad_grad_y, grad_grad_out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_add_triple_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add add_triple_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_grad_x_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_grad_x = CastPyArg2Value(grad_grad_x_obj, "add_triple_grad_", 0);
        PyObject *grad_grad_y_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_grad_y = CastPyArg2Value(grad_grad_y_obj, "add_triple_grad_", 1);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_grad_out_grad = CastPyArg2Value(grad_grad_out_grad_obj, "add_triple_grad_", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "add_triple_grad_", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::add_triple_grad_(grad_grad_x, grad_grad_y, grad_grad_out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_amax_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add amax_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "amax_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "amax_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "amax_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "amax_grad", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "amax_grad", 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);
        bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "amax_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::amax_grad(x, out, out_grad, axis, keepdim, reduce_all);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_amin_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add amin_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "amin_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "amin_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "amin_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "amin_grad", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "amin_grad", 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);
        bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "amin_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::amin_grad(x, out, out_grad, axis, keepdim, reduce_all);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign_out__grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign_out__grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "assign_out__grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::assign_out__grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_assign_out__grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add assign_out__grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "assign_out__grad_", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::assign_out__grad_(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_batch_norm_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add batch_norm_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "batch_norm_double_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "batch_norm_double_grad", 1);
        PyObject *out_mean_obj = PyTuple_GET_ITEM(args, 2);
        auto out_mean = CastPyArg2OptionalValue(out_mean_obj, "batch_norm_double_grad", 2);
        PyObject *out_variance_obj = PyTuple_GET_ITEM(args, 3);
        auto out_variance = CastPyArg2OptionalValue(out_variance_obj, "batch_norm_double_grad", 3);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 4);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "batch_norm_double_grad", 4);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 5);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "batch_norm_double_grad", 5);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 6);
        auto grad_out = CastPyArg2Value(grad_out_obj, "batch_norm_double_grad", 6);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "batch_norm_double_grad", 7);
        PyObject *grad_scale_grad_obj = PyTuple_GET_ITEM(args, 8);
        auto grad_scale_grad = CastPyArg2OptionalValue(grad_scale_grad_obj, "batch_norm_double_grad", 8);
        PyObject *grad_bias_grad_obj = PyTuple_GET_ITEM(args, 9);
        auto grad_bias_grad = CastPyArg2OptionalValue(grad_bias_grad_obj, "batch_norm_double_grad", 9);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 10);
        float momentum = CastPyArg2Float(momentum_obj, "batch_norm_double_grad", 10);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 11);
        float epsilon = CastPyArg2Float(epsilon_obj, "batch_norm_double_grad", 11);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 12);
        std::string data_layout = CastPyArg2String(data_layout_obj, "batch_norm_double_grad", 12);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 13);
        bool is_test = CastPyArg2Boolean(is_test_obj, "batch_norm_double_grad", 13);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 14);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "batch_norm_double_grad", 14);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 15);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "batch_norm_double_grad", 15);

        // Call ir static api
        auto static_api_out = paddle::dialect::batch_norm_double_grad(x, scale, out_mean, out_variance, saved_mean, saved_variance, grad_out, grad_x_grad, grad_scale_grad, grad_bias_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_batch_norm_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add batch_norm_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "batch_norm_double_grad_", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "batch_norm_double_grad_", 1);
        PyObject *out_mean_obj = PyTuple_GET_ITEM(args, 2);
        auto out_mean = CastPyArg2OptionalValue(out_mean_obj, "batch_norm_double_grad_", 2);
        PyObject *out_variance_obj = PyTuple_GET_ITEM(args, 3);
        auto out_variance = CastPyArg2OptionalValue(out_variance_obj, "batch_norm_double_grad_", 3);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 4);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "batch_norm_double_grad_", 4);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 5);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "batch_norm_double_grad_", 5);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 6);
        auto grad_out = CastPyArg2Value(grad_out_obj, "batch_norm_double_grad_", 6);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "batch_norm_double_grad_", 7);
        PyObject *grad_scale_grad_obj = PyTuple_GET_ITEM(args, 8);
        auto grad_scale_grad = CastPyArg2OptionalValue(grad_scale_grad_obj, "batch_norm_double_grad_", 8);
        PyObject *grad_bias_grad_obj = PyTuple_GET_ITEM(args, 9);
        auto grad_bias_grad = CastPyArg2OptionalValue(grad_bias_grad_obj, "batch_norm_double_grad_", 9);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 10);
        float momentum = CastPyArg2Float(momentum_obj, "batch_norm_double_grad_", 10);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 11);
        float epsilon = CastPyArg2Float(epsilon_obj, "batch_norm_double_grad_", 11);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 12);
        std::string data_layout = CastPyArg2String(data_layout_obj, "batch_norm_double_grad_", 12);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 13);
        bool is_test = CastPyArg2Boolean(is_test_obj, "batch_norm_double_grad_", 13);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 14);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "batch_norm_double_grad_", 14);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 15);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "batch_norm_double_grad_", 15);

        // Call ir static api
        auto static_api_out = paddle::dialect::batch_norm_double_grad_(x, scale, out_mean, out_variance, saved_mean, saved_variance, grad_out, grad_x_grad, grad_scale_grad, grad_bias_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_batch_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add batch_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "batch_norm_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2OptionalValue(scale_obj, "batch_norm_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2OptionalValue(bias_obj, "batch_norm_grad", 2);
        PyObject *mean_out_obj = PyTuple_GET_ITEM(args, 3);
        auto mean_out = CastPyArg2OptionalValue(mean_out_obj, "batch_norm_grad", 3);
        PyObject *variance_out_obj = PyTuple_GET_ITEM(args, 4);
        auto variance_out = CastPyArg2OptionalValue(variance_out_obj, "batch_norm_grad", 4);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 5);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "batch_norm_grad", 5);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 6);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "batch_norm_grad", 6);
        PyObject *reserve_space_obj = PyTuple_GET_ITEM(args, 7);
        auto reserve_space = CastPyArg2OptionalValue(reserve_space_obj, "batch_norm_grad", 7);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 8);
        auto out_grad = CastPyArg2Value(out_grad_obj, "batch_norm_grad", 8);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 9);
        float momentum = CastPyArg2Float(momentum_obj, "batch_norm_grad", 9);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 10);
        float epsilon = CastPyArg2Float(epsilon_obj, "batch_norm_grad", 10);
        PyObject *data_layout_obj = PyTuple_GET_ITEM(args, 11);
        std::string data_layout = CastPyArg2String(data_layout_obj, "batch_norm_grad", 11);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 12);
        bool is_test = CastPyArg2Boolean(is_test_obj, "batch_norm_grad", 12);
        PyObject *use_global_stats_obj = PyTuple_GET_ITEM(args, 13);
        bool use_global_stats = CastPyArg2Boolean(use_global_stats_obj, "batch_norm_grad", 13);
        PyObject *trainable_statistics_obj = PyTuple_GET_ITEM(args, 14);
        bool trainable_statistics = CastPyArg2Boolean(trainable_statistics_obj, "batch_norm_grad", 14);

        // Call ir static api
        auto static_api_out = paddle::dialect::batch_norm_grad(x, scale, bias, mean_out, variance_out, saved_mean, saved_variance, reserve_space, out_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_c_embedding_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add c_embedding_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *weight_obj = PyTuple_GET_ITEM(args, 0);
        auto weight = CastPyArg2Value(weight_obj, "c_embedding_grad", 0);
        PyObject *x_obj = PyTuple_GET_ITEM(args, 1);
        auto x = CastPyArg2Value(x_obj, "c_embedding_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "c_embedding_grad", 2);

        // Parse Attributes
        PyObject *start_index_obj = PyTuple_GET_ITEM(args, 3);
        int64_t start_index = CastPyArg2Long(start_index_obj, "c_embedding_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::c_embedding_grad(weight, x, out_grad, start_index);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_channel_shuffle_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add channel_shuffle_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "channel_shuffle_grad", 0);

        // Parse Attributes
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 1);
        int groups = CastPyArg2Int(groups_obj, "channel_shuffle_grad", 1);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 2);
        std::string data_format = CastPyArg2String(data_format_obj, "channel_shuffle_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::channel_shuffle_grad(out_grad, groups, data_format);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d_transpose_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d_transpose_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conv2d_transpose_double_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d_transpose_double_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "conv2d_transpose_double_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "conv2d_transpose_double_grad", 3);
        PyObject *grad_filter_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_filter_grad = CastPyArg2Value(grad_filter_grad_obj, "conv2d_transpose_double_grad", 4);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 11);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 12);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d_transpose_double_grad", 5);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d_transpose_double_grad", 6);
            std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "conv2d_transpose_double_grad", 7);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "conv2d_transpose_double_grad", 8);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "conv2d_transpose_double_grad", 8);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "conv2d_transpose_double_grad", 8);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d_transpose_double_grad", 9);
            int groups = CastPyArg2Int(groups_obj, "conv2d_transpose_double_grad", 10);
            std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d_transpose_double_grad", 11);
            std::string data_format = CastPyArg2String(data_format_obj, "conv2d_transpose_double_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d_transpose_double_grad(x, filter, grad_out, grad_x_grad, grad_filter_grad, output_size, strides, paddings, output_padding, padding_algorithm, groups, dilations, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_conv2d_transpose_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add conv2d_transpose_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "conv2d_transpose_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "conv2d_transpose_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "conv2d_transpose_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> strides = CastPyArg2Ints(strides_obj, "conv2d_transpose_grad", 3);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "conv2d_transpose_grad", 4);
            std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "conv2d_transpose_grad", 5);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "conv2d_transpose_grad", 6);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "conv2d_transpose_grad", 6);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "conv2d_transpose_grad", 6);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "conv2d_transpose_grad", 7);
            int groups = CastPyArg2Int(groups_obj, "conv2d_transpose_grad", 8);
            std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "conv2d_transpose_grad", 9);
            std::string data_format = CastPyArg2String(data_format_obj, "conv2d_transpose_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::conv2d_transpose_grad(x, filter, out_grad, output_size, strides, paddings, output_padding, padding_algorithm, groups, dilations, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_deformable_conv_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add deformable_conv_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "deformable_conv_grad", 0);
        PyObject *offset_obj = PyTuple_GET_ITEM(args, 1);
        auto offset = CastPyArg2Value(offset_obj, "deformable_conv_grad", 1);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 2);
        auto filter = CastPyArg2Value(filter_obj, "deformable_conv_grad", 2);
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 3);
        auto mask = CastPyArg2OptionalValue(mask_obj, "deformable_conv_grad", 3);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto out_grad = CastPyArg2Value(out_grad_obj, "deformable_conv_grad", 4);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "deformable_conv_grad", 5);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 6);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "deformable_conv_grad", 6);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 7);
        std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "deformable_conv_grad", 7);
        PyObject *deformable_groups_obj = PyTuple_GET_ITEM(args, 8);
        int deformable_groups = CastPyArg2Int(deformable_groups_obj, "deformable_conv_grad", 8);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 9);
        int groups = CastPyArg2Int(groups_obj, "deformable_conv_grad", 9);
        PyObject *im2col_step_obj = PyTuple_GET_ITEM(args, 10);
        int im2col_step = CastPyArg2Int(im2col_step_obj, "deformable_conv_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::deformable_conv_grad(x, offset, filter, mask, out_grad, strides, paddings, dilations, deformable_groups, groups, im2col_step);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_depthwise_conv2d_transpose_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add depthwise_conv2d_transpose_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "depthwise_conv2d_transpose_grad", 0);
        PyObject *filter_obj = PyTuple_GET_ITEM(args, 1);
        auto filter = CastPyArg2Value(filter_obj, "depthwise_conv2d_transpose_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "depthwise_conv2d_transpose_grad", 2);

        // Parse Attributes
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *output_padding_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *output_size_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *groups_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *dilations_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 10);

        // Check for mutable attrs
       pir::Value output_size;

            std::vector<int> strides = CastPyArg2Ints(strides_obj, "depthwise_conv2d_transpose_grad", 3);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "depthwise_conv2d_transpose_grad", 4);
            std::vector<int> output_padding = CastPyArg2Ints(output_padding_obj, "depthwise_conv2d_transpose_grad", 5);
        if (PyObject_CheckIROpResult(output_size_obj)){
             output_size = CastPyArg2Value(output_size_obj, "depthwise_conv2d_transpose_grad", 6);
        }else if (PyObject_CheckIRVectorOfOpResult(output_size_obj)){
            std::vector<pir::Value> output_size_tmp = CastPyArg2VectorOfValue(output_size_obj, "depthwise_conv2d_transpose_grad", 6);
            output_size = paddle::dialect::stack(output_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> output_size_tmp = CastPyArg2Longs(output_size_obj, "depthwise_conv2d_transpose_grad", 6);
            output_size = paddle::dialect::full_int_array(output_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "depthwise_conv2d_transpose_grad", 7);
            int groups = CastPyArg2Int(groups_obj, "depthwise_conv2d_transpose_grad", 8);
            std::vector<int> dilations = CastPyArg2Ints(dilations_obj, "depthwise_conv2d_transpose_grad", 9);
            std::string data_format = CastPyArg2String(data_format_obj, "depthwise_conv2d_transpose_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::depthwise_conv2d_transpose_grad(x, filter, out_grad, output_size, strides, paddings, output_padding, padding_algorithm, groups, dilations, data_format);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_divide_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add divide_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *y_obj = PyTuple_GET_ITEM(args, 0);
        auto y = CastPyArg2Value(y_obj, "divide_double_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "divide_double_grad", 1);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x = CastPyArg2Value(grad_x_obj, "divide_double_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "divide_double_grad", 3);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "divide_double_grad", 4);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 5);
        int axis = CastPyArg2Int(axis_obj, "divide_double_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::divide_double_grad(y, out, grad_x, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_divide_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add divide_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *y_obj = PyTuple_GET_ITEM(args, 0);
        auto y = CastPyArg2Value(y_obj, "divide_double_grad_", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "divide_double_grad_", 1);
        PyObject *grad_x_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_x = CastPyArg2Value(grad_x_obj, "divide_double_grad_", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "divide_double_grad_", 3);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "divide_double_grad_", 4);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 5);
        int axis = CastPyArg2Int(axis_obj, "divide_double_grad_", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::divide_double_grad_(y, out, grad_x, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_divide_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add divide_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "divide_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "divide_grad", 1);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 2);
        auto out = CastPyArg2Value(out_obj, "divide_grad", 2);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto out_grad = CastPyArg2Value(out_grad_obj, "divide_grad", 3);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 4);
        int axis = CastPyArg2Int(axis_obj, "divide_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::divide_grad(x, y, out, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_dropout_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add dropout_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *mask_obj = PyTuple_GET_ITEM(args, 0);
        auto mask = CastPyArg2Value(mask_obj, "dropout_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "dropout_grad", 1);

        // Parse Attributes
        PyObject *p_obj = PyTuple_GET_ITEM(args, 2);
        float p = CastPyArg2Float(p_obj, "dropout_grad", 2);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 3);
        bool is_test = CastPyArg2Boolean(is_test_obj, "dropout_grad", 3);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 4);
        std::string mode = CastPyArg2String(mode_obj, "dropout_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::dropout_grad(mask, out_grad, p, is_test, mode);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_einsum_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add einsum_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_shape_obj = PyTuple_GET_ITEM(args, 0);
        auto x_shape = CastPyArg2VectorOfValue(x_shape_obj, "einsum_grad", 0);
        PyObject *inner_cache_obj = PyTuple_GET_ITEM(args, 1);
        auto inner_cache = CastPyArg2VectorOfValue(inner_cache_obj, "einsum_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "einsum_grad", 2);

        // Parse Attributes
        PyObject *equation_obj = PyTuple_GET_ITEM(args, 3);
        std::string equation = CastPyArg2String(equation_obj, "einsum_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::einsum_grad(x_shape, inner_cache, out_grad, equation);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_elementwise_pow_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add elementwise_pow_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "elementwise_pow_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "elementwise_pow_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "elementwise_pow_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::elementwise_pow_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_frobenius_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add frobenius_norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "frobenius_norm_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "frobenius_norm_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "frobenius_norm_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *keep_dim_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "frobenius_norm_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "frobenius_norm_grad", 3);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "frobenius_norm_grad", 3);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keep_dim = CastPyArg2Boolean(keep_dim_obj, "frobenius_norm_grad", 4);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "frobenius_norm_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::frobenius_norm_grad(x, out, out_grad, axis, keep_dim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_batch_norm_act_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_batch_norm_act_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_batch_norm_act_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "fused_batch_norm_act_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2Value(bias_obj, "fused_batch_norm_act_grad", 2);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 3);
        auto out = CastPyArg2Value(out_obj, "fused_batch_norm_act_grad", 3);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 4);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "fused_batch_norm_act_grad", 4);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 5);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "fused_batch_norm_act_grad", 5);
        PyObject *reserve_space_obj = PyTuple_GET_ITEM(args, 6);
        auto reserve_space = CastPyArg2OptionalValue(reserve_space_obj, "fused_batch_norm_act_grad", 6);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fused_batch_norm_act_grad", 7);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 8);
        float momentum = CastPyArg2Float(momentum_obj, "fused_batch_norm_act_grad", 8);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 9);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_batch_norm_act_grad", 9);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 10);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_batch_norm_act_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_batch_norm_act_grad(x, scale, bias, out, saved_mean, saved_variance, reserve_space, out_grad, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_bn_add_activation_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_bn_add_activation_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "fused_bn_add_activation_grad", 0);
        PyObject *scale_obj = PyTuple_GET_ITEM(args, 1);
        auto scale = CastPyArg2Value(scale_obj, "fused_bn_add_activation_grad", 1);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 2);
        auto bias = CastPyArg2Value(bias_obj, "fused_bn_add_activation_grad", 2);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 3);
        auto out = CastPyArg2Value(out_obj, "fused_bn_add_activation_grad", 3);
        PyObject *saved_mean_obj = PyTuple_GET_ITEM(args, 4);
        auto saved_mean = CastPyArg2Value(saved_mean_obj, "fused_bn_add_activation_grad", 4);
        PyObject *saved_variance_obj = PyTuple_GET_ITEM(args, 5);
        auto saved_variance = CastPyArg2Value(saved_variance_obj, "fused_bn_add_activation_grad", 5);
        PyObject *reserve_space_obj = PyTuple_GET_ITEM(args, 6);
        auto reserve_space = CastPyArg2OptionalValue(reserve_space_obj, "fused_bn_add_activation_grad", 6);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto out_grad = CastPyArg2Value(out_grad_obj, "fused_bn_add_activation_grad", 7);

        // Parse Attributes
        PyObject *momentum_obj = PyTuple_GET_ITEM(args, 8);
        float momentum = CastPyArg2Float(momentum_obj, "fused_bn_add_activation_grad", 8);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 9);
        float epsilon = CastPyArg2Float(epsilon_obj, "fused_bn_add_activation_grad", 9);
        PyObject *act_type_obj = PyTuple_GET_ITEM(args, 10);
        std::string act_type = CastPyArg2String(act_type_obj, "fused_bn_add_activation_grad", 10);

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_bn_add_activation_grad(x, scale, bias, out, saved_mean, saved_variance, reserve_space, out_grad, momentum, epsilon, act_type);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_fused_softmax_mask_upper_triangle_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add fused_softmax_mask_upper_triangle_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *Out_obj = PyTuple_GET_ITEM(args, 0);
        auto Out = CastPyArg2Value(Out_obj, "fused_softmax_mask_upper_triangle_grad", 0);
        PyObject *Out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto Out_grad = CastPyArg2Value(Out_grad_obj, "fused_softmax_mask_upper_triangle_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::fused_softmax_mask_upper_triangle_grad(Out, Out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardswish_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardswish_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardswish_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardswish_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::hardswish_grad(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hardswish_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hardswish_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hardswish_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hardswish_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::hardswish_grad_(x, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_hsigmoid_loss_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add hsigmoid_loss_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "hsigmoid_loss_grad", 0);
        PyObject *w_obj = PyTuple_GET_ITEM(args, 1);
        auto w = CastPyArg2Value(w_obj, "hsigmoid_loss_grad", 1);
        PyObject *label_obj = PyTuple_GET_ITEM(args, 2);
        auto label = CastPyArg2Value(label_obj, "hsigmoid_loss_grad", 2);
        PyObject *path_obj = PyTuple_GET_ITEM(args, 3);
        auto path = CastPyArg2OptionalValue(path_obj, "hsigmoid_loss_grad", 3);
        PyObject *code_obj = PyTuple_GET_ITEM(args, 4);
        auto code = CastPyArg2OptionalValue(code_obj, "hsigmoid_loss_grad", 4);
        PyObject *bias_obj = PyTuple_GET_ITEM(args, 5);
        auto bias = CastPyArg2OptionalValue(bias_obj, "hsigmoid_loss_grad", 5);
        PyObject *pre_out_obj = PyTuple_GET_ITEM(args, 6);
        auto pre_out = CastPyArg2Value(pre_out_obj, "hsigmoid_loss_grad", 6);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto out_grad = CastPyArg2Value(out_grad_obj, "hsigmoid_loss_grad", 7);

        // Parse Attributes
        PyObject *num_classes_obj = PyTuple_GET_ITEM(args, 8);
        int num_classes = CastPyArg2Int(num_classes_obj, "hsigmoid_loss_grad", 8);
        PyObject *is_sparse_obj = PyTuple_GET_ITEM(args, 9);
        bool is_sparse = CastPyArg2Boolean(is_sparse_obj, "hsigmoid_loss_grad", 9);

        // Call ir static api
        auto static_api_out = paddle::dialect::hsigmoid_loss_grad(x, w, label, path, code, bias, pre_out, out_grad, num_classes, is_sparse);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_logsumexp_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add logsumexp_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "logsumexp_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "logsumexp_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "logsumexp_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "logsumexp_grad", 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "logsumexp_grad", 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);
        bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "logsumexp_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::logsumexp_grad(x, out, out_grad, axis, keepdim, reduce_all);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matmul_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matmul_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matmul_double_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "matmul_double_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "matmul_double_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "matmul_double_grad", 3);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "matmul_double_grad", 4);

        // Parse Attributes
        PyObject *transpose_x_obj = PyTuple_GET_ITEM(args, 5);
        bool transpose_x = CastPyArg2Boolean(transpose_x_obj, "matmul_double_grad", 5);
        PyObject *transpose_y_obj = PyTuple_GET_ITEM(args, 6);
        bool transpose_y = CastPyArg2Boolean(transpose_y_obj, "matmul_double_grad", 6);

        // Call ir static api
        auto static_api_out = paddle::dialect::matmul_double_grad(x, y, grad_out, grad_x_grad, grad_y_grad, transpose_x, transpose_y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_matmul_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add matmul_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "matmul_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "matmul_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "matmul_grad", 2);

        // Parse Attributes
        PyObject *transpose_x_obj = PyTuple_GET_ITEM(args, 3);
        bool transpose_x = CastPyArg2Boolean(transpose_x_obj, "matmul_grad", 3);
        PyObject *transpose_y_obj = PyTuple_GET_ITEM(args, 4);
        bool transpose_y = CastPyArg2Boolean(transpose_y_obj, "matmul_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::matmul_grad(x, y, out_grad, transpose_x, transpose_y);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_max_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add max_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "max_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "max_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "max_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "max_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "max_grad", 3);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "max_grad", 3);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdim = CastPyArg2Boolean(keepdim_obj, "max_grad", 4);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "max_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::max_grad(x, out, out_grad, axis, keepdim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_maximum_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add maximum_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "maximum_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "maximum_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "maximum_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::maximum_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mean_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mean_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mean_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mean_grad", 1);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 2);
        std::vector<int64_t> axis = CastPyArg2Longs(axis_obj, "mean_grad", 2);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 3);
        bool keepdim = CastPyArg2Boolean(keepdim_obj, "mean_grad", 3);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 4);
        bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "mean_grad", 4);

        // Call ir static api
        auto static_api_out = paddle::dialect::mean_grad(x, out_grad, axis, keepdim, reduce_all);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_min_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add min_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "min_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "min_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "min_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *keepdim_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value axis;

        if (PyObject_CheckIROpResult(axis_obj)){
             axis = CastPyArg2Value(axis_obj, "min_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(axis_obj)){
            std::vector<pir::Value> axis_tmp = CastPyArg2VectorOfValue(axis_obj, "min_grad", 3);
            axis = paddle::dialect::stack(axis_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> axis_tmp = CastPyArg2Longs(axis_obj, "min_grad", 3);
            axis = paddle::dialect::full_int_array(axis_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keepdim = CastPyArg2Boolean(keepdim_obj, "min_grad", 4);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "min_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::min_grad(x, out, out_grad, axis, keepdim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_minimum_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add minimum_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "minimum_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "minimum_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "minimum_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::minimum_grad(x, y, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mish_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mish_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mish_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mish_grad", 1);

        // Parse Attributes
        PyObject *lambda_obj = PyTuple_GET_ITEM(args, 2);
        float lambda = CastPyArg2Float(lambda_obj, "mish_grad", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::mish_grad(x, out_grad, lambda);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_mish_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add mish_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "mish_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "mish_grad_", 1);

        // Parse Attributes
        PyObject *lambda_obj = PyTuple_GET_ITEM(args, 2);
        float lambda = CastPyArg2Float(lambda_obj, "mish_grad_", 2);

        // Call ir static api
        auto static_api_out = paddle::dialect::mish_grad_(x, out_grad, lambda);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply_double_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply_double_grad", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "multiply_double_grad", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "multiply_double_grad", 3);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "multiply_double_grad", 4);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 5);
        int axis = CastPyArg2Int(axis_obj, "multiply_double_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply_double_grad(x, y, grad_out, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply_double_grad_", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply_double_grad_", 1);
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto grad_out = CastPyArg2Value(grad_out_obj, "multiply_double_grad_", 2);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 3);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "multiply_double_grad_", 3);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 4);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "multiply_double_grad_", 4);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 5);
        int axis = CastPyArg2Int(axis_obj, "multiply_double_grad_", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply_double_grad_(x, y, grad_out, grad_x_grad, grad_y_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "multiply_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "multiply_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply_grad(x, y, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_multiply_triple_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add multiply_triple_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "multiply_triple_grad", 0);
        PyObject *y_obj = PyTuple_GET_ITEM(args, 1);
        auto y = CastPyArg2Value(y_obj, "multiply_triple_grad", 1);
        PyObject *fwd_grad_out_obj = PyTuple_GET_ITEM(args, 2);
        auto fwd_grad_out = CastPyArg2Value(fwd_grad_out_obj, "multiply_triple_grad", 2);
        PyObject *fwd_grad_grad_x_obj = PyTuple_GET_ITEM(args, 3);
        auto fwd_grad_grad_x = CastPyArg2OptionalValue(fwd_grad_grad_x_obj, "multiply_triple_grad", 3);
        PyObject *fwd_grad_grad_y_obj = PyTuple_GET_ITEM(args, 4);
        auto fwd_grad_grad_y = CastPyArg2OptionalValue(fwd_grad_grad_y_obj, "multiply_triple_grad", 4);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 5);
        auto grad_x_grad = CastPyArg2OptionalValue(grad_x_grad_obj, "multiply_triple_grad", 5);
        PyObject *grad_y_grad_obj = PyTuple_GET_ITEM(args, 6);
        auto grad_y_grad = CastPyArg2OptionalValue(grad_y_grad_obj, "multiply_triple_grad", 6);
        PyObject *grad_grad_out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto grad_grad_out_grad = CastPyArg2OptionalValue(grad_grad_out_grad_obj, "multiply_triple_grad", 7);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 8);
        int axis = CastPyArg2Int(axis_obj, "multiply_triple_grad", 8);

        // Call ir static api
        auto static_api_out = paddle::dialect::multiply_triple_grad(x, y, fwd_grad_out, fwd_grad_grad_x, fwd_grad_grad_y, grad_x_grad, grad_y_grad, grad_grad_out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_norm_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add norm_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "norm_grad", 0);
        PyObject *norm_obj = PyTuple_GET_ITEM(args, 1);
        auto norm = CastPyArg2Value(norm_obj, "norm_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "norm_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "norm_grad", 3);
        PyObject *epsilon_obj = PyTuple_GET_ITEM(args, 4);
        float epsilon = CastPyArg2Float(epsilon_obj, "norm_grad", 4);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 5);
        bool is_test = CastPyArg2Boolean(is_test_obj, "norm_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::norm_grad(x, norm, out_grad, axis, epsilon, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pad_double_grad", 0);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 1);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 2);

        // Check for mutable attrs
       pir::Value pad_value;

            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pad_double_grad", 1);
        if (PyObject_CheckIROpResult(pad_value_obj)){
             pad_value = CastPyArg2Value(pad_value_obj, "pad_double_grad", 2);
        }else{
            float pad_value_tmp = CastPyArg2Float(pad_value_obj, "pad_double_grad", 2);
            pad_value = paddle::dialect::full(std::vector<int64_t>{1}, pad_value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::pad_double_grad(grad_x_grad, pad_value, paddings);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pad_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pad_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pad_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pad_grad", 1);

        // Parse Attributes
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *pad_value_obj = PyTuple_GET_ITEM(args, 3);

        // Check for mutable attrs
       pir::Value pad_value;

            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pad_grad", 2);
        if (PyObject_CheckIROpResult(pad_value_obj)){
             pad_value = CastPyArg2Value(pad_value_obj, "pad_grad", 3);
        }else{
            float pad_value_tmp = CastPyArg2Float(pad_value_obj, "pad_grad", 3);
            pad_value = paddle::dialect::full(std::vector<int64_t>{1}, pad_value_tmp, phi::DataType::FLOAT32, phi::CPUPlace());

        }

        // Call ir static api
        auto static_api_out = paddle::dialect::pad_grad(x, out_grad, pad_value, paddings);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pool2d_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pool2d_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pool2d_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "pool2d_double_grad", 1);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *ceil_mode_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *pooling_type_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 11);

        // Check for mutable attrs
       pir::Value kernel_size;

        if (PyObject_CheckIROpResult(kernel_size_obj)){
             kernel_size = CastPyArg2Value(kernel_size_obj, "pool2d_double_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(kernel_size_obj)){
            std::vector<pir::Value> kernel_size_tmp = CastPyArg2VectorOfValue(kernel_size_obj, "pool2d_double_grad", 2);
            kernel_size = paddle::dialect::stack(kernel_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> kernel_size_tmp = CastPyArg2Longs(kernel_size_obj, "pool2d_double_grad", 2);
            kernel_size = paddle::dialect::full_int_array(kernel_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int> strides = CastPyArg2Ints(strides_obj, "pool2d_double_grad", 3);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pool2d_double_grad", 4);
            bool ceil_mode = CastPyArg2Boolean(ceil_mode_obj, "pool2d_double_grad", 5);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "pool2d_double_grad", 6);
            std::string data_format = CastPyArg2String(data_format_obj, "pool2d_double_grad", 7);
            std::string pooling_type = CastPyArg2String(pooling_type_obj, "pool2d_double_grad", 8);
            bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "pool2d_double_grad", 9);
            bool adaptive = CastPyArg2Boolean(adaptive_obj, "pool2d_double_grad", 10);
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "pool2d_double_grad", 11);

        // Call ir static api
        auto static_api_out = paddle::dialect::pool2d_double_grad(x, grad_x_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pool2d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pool2d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pool2d_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "pool2d_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pool2d_grad", 2);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *ceil_mode_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        PyObject *pooling_type_obj = PyTuple_GET_ITEM(args, 9);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 10);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 11);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 12);

        // Check for mutable attrs
       pir::Value kernel_size;

        if (PyObject_CheckIROpResult(kernel_size_obj)){
             kernel_size = CastPyArg2Value(kernel_size_obj, "pool2d_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(kernel_size_obj)){
            std::vector<pir::Value> kernel_size_tmp = CastPyArg2VectorOfValue(kernel_size_obj, "pool2d_grad", 3);
            kernel_size = paddle::dialect::stack(kernel_size_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> kernel_size_tmp = CastPyArg2Longs(kernel_size_obj, "pool2d_grad", 3);
            kernel_size = paddle::dialect::full_int_array(kernel_size_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int> strides = CastPyArg2Ints(strides_obj, "pool2d_grad", 4);
            std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pool2d_grad", 5);
            bool ceil_mode = CastPyArg2Boolean(ceil_mode_obj, "pool2d_grad", 6);
            bool exclusive = CastPyArg2Boolean(exclusive_obj, "pool2d_grad", 7);
            std::string data_format = CastPyArg2String(data_format_obj, "pool2d_grad", 8);
            std::string pooling_type = CastPyArg2String(pooling_type_obj, "pool2d_grad", 9);
            bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "pool2d_grad", 10);
            bool adaptive = CastPyArg2Boolean(adaptive_obj, "pool2d_grad", 11);
            std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "pool2d_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::pool2d_grad(x, out, out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_pool3d_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add pool3d_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "pool3d_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "pool3d_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "pool3d_grad", 2);

        // Parse Attributes
        PyObject *kernel_size_obj = PyTuple_GET_ITEM(args, 3);
        std::vector<int> kernel_size = CastPyArg2Ints(kernel_size_obj, "pool3d_grad", 3);
        PyObject *strides_obj = PyTuple_GET_ITEM(args, 4);
        std::vector<int> strides = CastPyArg2Ints(strides_obj, "pool3d_grad", 4);
        PyObject *paddings_obj = PyTuple_GET_ITEM(args, 5);
        std::vector<int> paddings = CastPyArg2Ints(paddings_obj, "pool3d_grad", 5);
        PyObject *ceil_mode_obj = PyTuple_GET_ITEM(args, 6);
        bool ceil_mode = CastPyArg2Boolean(ceil_mode_obj, "pool3d_grad", 6);
        PyObject *exclusive_obj = PyTuple_GET_ITEM(args, 7);
        bool exclusive = CastPyArg2Boolean(exclusive_obj, "pool3d_grad", 7);
        PyObject *data_format_obj = PyTuple_GET_ITEM(args, 8);
        std::string data_format = CastPyArg2String(data_format_obj, "pool3d_grad", 8);
        PyObject *pooling_type_obj = PyTuple_GET_ITEM(args, 9);
        std::string pooling_type = CastPyArg2String(pooling_type_obj, "pool3d_grad", 9);
        PyObject *global_pooling_obj = PyTuple_GET_ITEM(args, 10);
        bool global_pooling = CastPyArg2Boolean(global_pooling_obj, "pool3d_grad", 10);
        PyObject *adaptive_obj = PyTuple_GET_ITEM(args, 11);
        bool adaptive = CastPyArg2Boolean(adaptive_obj, "pool3d_grad", 11);
        PyObject *padding_algorithm_obj = PyTuple_GET_ITEM(args, 12);
        std::string padding_algorithm = CastPyArg2String(padding_algorithm_obj, "pool3d_grad", 12);

        // Call ir static api
        auto static_api_out = paddle::dialect::pool3d_grad(x, out, out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_prod_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add prod_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "prod_grad", 0);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 1);
        auto out = CastPyArg2Value(out_obj, "prod_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "prod_grad", 2);

        // Parse Attributes
        PyObject *dims_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *keep_dim_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *reduce_all_obj = PyTuple_GET_ITEM(args, 5);

        // Check for mutable attrs
       pir::Value dims;

        if (PyObject_CheckIROpResult(dims_obj)){
             dims = CastPyArg2Value(dims_obj, "prod_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(dims_obj)){
            std::vector<pir::Value> dims_tmp = CastPyArg2VectorOfValue(dims_obj, "prod_grad", 3);
            dims = paddle::dialect::stack(dims_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> dims_tmp = CastPyArg2Longs(dims_obj, "prod_grad", 3);
            dims = paddle::dialect::full_int_array(dims_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            bool keep_dim = CastPyArg2Boolean(keep_dim_obj, "prod_grad", 4);
            bool reduce_all = CastPyArg2Boolean(reduce_all_obj, "prod_grad", 5);

        // Call ir static api
        auto static_api_out = paddle::dialect::prod_grad(x, out, out_grad, dims, keep_dim, reduce_all);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_repeat_interleave_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add repeat_interleave_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "repeat_interleave_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "repeat_interleave_grad", 1);

        // Parse Attributes
        PyObject *repeats_obj = PyTuple_GET_ITEM(args, 2);
        int repeats = CastPyArg2Int(repeats_obj, "repeat_interleave_grad", 2);
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "repeat_interleave_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::repeat_interleave_grad(x, out_grad, repeats, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_repeat_interleave_with_tensor_index_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add repeat_interleave_with_tensor_index_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "repeat_interleave_with_tensor_index_grad", 0);
        PyObject *repeats_obj = PyTuple_GET_ITEM(args, 1);
        auto repeats = CastPyArg2Value(repeats_obj, "repeat_interleave_with_tensor_index_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "repeat_interleave_with_tensor_index_grad", 2);

        // Parse Attributes
        PyObject *axis_obj = PyTuple_GET_ITEM(args, 3);
        int axis = CastPyArg2Int(axis_obj, "repeat_interleave_with_tensor_index_grad", 3);

        // Call ir static api
        auto static_api_out = paddle::dialect::repeat_interleave_with_tensor_index_grad(x, repeats, out_grad, axis);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape_double_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape_double_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_out = CastPyArg2Value(grad_out_obj, "reshape_double_grad", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "reshape_double_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape_double_grad(grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape_double_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape_double_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *grad_out_obj = PyTuple_GET_ITEM(args, 0);
        auto grad_out = CastPyArg2Value(grad_out_obj, "reshape_double_grad_", 0);
        PyObject *grad_x_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto grad_x_grad = CastPyArg2Value(grad_x_grad_obj, "reshape_double_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape_double_grad_(grad_out, grad_x_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "reshape_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "reshape_grad", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape_grad(xshape, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_reshape_grad_(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add reshape_grad_ op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *xshape_obj = PyTuple_GET_ITEM(args, 0);
        auto xshape = CastPyArg2Value(xshape_obj, "reshape_grad_", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "reshape_grad_", 1);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::reshape_grad_(xshape, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rnn_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rnn_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rnn_grad", 0);
        PyObject *pre_state_obj = PyTuple_GET_ITEM(args, 1);
        auto pre_state = CastPyArg2VectorOfValue(pre_state_obj, "rnn_grad", 1);
        PyObject *weight_list_obj = PyTuple_GET_ITEM(args, 2);
        auto weight_list = CastPyArg2VectorOfValue(weight_list_obj, "rnn_grad", 2);
        PyObject *sequence_length_obj = PyTuple_GET_ITEM(args, 3);
        auto sequence_length = CastPyArg2OptionalValue(sequence_length_obj, "rnn_grad", 3);
        PyObject *out_obj = PyTuple_GET_ITEM(args, 4);
        auto out = CastPyArg2Value(out_obj, "rnn_grad", 4);
        PyObject *dropout_state_out_obj = PyTuple_GET_ITEM(args, 5);
        auto dropout_state_out = CastPyArg2Value(dropout_state_out_obj, "rnn_grad", 5);
        PyObject *reserve_obj = PyTuple_GET_ITEM(args, 6);
        auto reserve = CastPyArg2Value(reserve_obj, "rnn_grad", 6);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 7);
        auto out_grad = CastPyArg2Value(out_grad_obj, "rnn_grad", 7);
        PyObject *state_grad_obj = PyTuple_GET_ITEM(args, 8);
        auto state_grad = CastPyArg2VectorOfValue(state_grad_obj, "rnn_grad", 8);

        // Parse Attributes
        PyObject *dropout_prob_obj = PyTuple_GET_ITEM(args, 9);
        float dropout_prob = CastPyArg2Float(dropout_prob_obj, "rnn_grad", 9);
        PyObject *is_bidirec_obj = PyTuple_GET_ITEM(args, 10);
        bool is_bidirec = CastPyArg2Boolean(is_bidirec_obj, "rnn_grad", 10);
        PyObject *input_size_obj = PyTuple_GET_ITEM(args, 11);
        int input_size = CastPyArg2Int(input_size_obj, "rnn_grad", 11);
        PyObject *hidden_size_obj = PyTuple_GET_ITEM(args, 12);
        int hidden_size = CastPyArg2Int(hidden_size_obj, "rnn_grad", 12);
        PyObject *num_layers_obj = PyTuple_GET_ITEM(args, 13);
        int num_layers = CastPyArg2Int(num_layers_obj, "rnn_grad", 13);
        PyObject *mode_obj = PyTuple_GET_ITEM(args, 14);
        std::string mode = CastPyArg2String(mode_obj, "rnn_grad", 14);
        PyObject *seed_obj = PyTuple_GET_ITEM(args, 15);
        int seed = CastPyArg2Int(seed_obj, "rnn_grad", 15);
        PyObject *is_test_obj = PyTuple_GET_ITEM(args, 16);
        bool is_test = CastPyArg2Boolean(is_test_obj, "rnn_grad", 16);

        // Call ir static api
        auto static_api_out = paddle::dialect::rnn_grad(x, pre_state, weight_list, sequence_length, out, dropout_state_out, reserve, out_grad, state_grad, dropout_prob, is_bidirec, input_size, hidden_size, num_layers, mode, seed, is_test);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_rrelu_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add rrelu_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *x_obj = PyTuple_GET_ITEM(args, 0);
        auto x = CastPyArg2Value(x_obj, "rrelu_grad", 0);
        PyObject *noise_obj = PyTuple_GET_ITEM(args, 1);
        auto noise = CastPyArg2Value(noise_obj, "rrelu_grad", 1);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 2);
        auto out_grad = CastPyArg2Value(out_grad_obj, "rrelu_grad", 2);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::rrelu_grad(x, noise, out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 0);
        auto out_grad = CastPyArg2Value(out_grad_obj, "set_value_grad", 0);

        // Parse Attributes

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value_grad(out_grad);

        return ToPyObject(static_api_out);
    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_set_value_with_tensor_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add set_value_with_tensor_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *values_obj = PyTuple_GET_ITEM(args, 0);
        auto values = CastPyArg2Value(values_obj, "set_value_with_tensor_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "set_value_with_tensor_grad", 1);

        // Parse Attributes
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *steps_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *decrease_axes_obj = PyTuple_GET_ITEM(args, 6);
        PyObject *none_axes_obj = PyTuple_GET_ITEM(args, 7);

        // Check for mutable attrs
       pir::Value starts;

       pir::Value ends;

       pir::Value steps;

        if (PyObject_CheckIROpResult(starts_obj)){
             starts = CastPyArg2Value(starts_obj, "set_value_with_tensor_grad", 2);
        }else if (PyObject_CheckIRVectorOfOpResult(starts_obj)){
            std::vector<pir::Value> starts_tmp = CastPyArg2VectorOfValue(starts_obj, "set_value_with_tensor_grad", 2);
            starts = paddle::dialect::stack(starts_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> starts_tmp = CastPyArg2Longs(starts_obj, "set_value_with_tensor_grad", 2);
            starts = paddle::dialect::full_int_array(starts_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(ends_obj)){
             ends = CastPyArg2Value(ends_obj, "set_value_with_tensor_grad", 3);
        }else if (PyObject_CheckIRVectorOfOpResult(ends_obj)){
            std::vector<pir::Value> ends_tmp = CastPyArg2VectorOfValue(ends_obj, "set_value_with_tensor_grad", 3);
            ends = paddle::dialect::stack(ends_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> ends_tmp = CastPyArg2Longs(ends_obj, "set_value_with_tensor_grad", 3);
            ends = paddle::dialect::full_int_array(ends_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
        if (PyObject_CheckIROpResult(steps_obj)){
             steps = CastPyArg2Value(steps_obj, "set_value_with_tensor_grad", 4);
        }else if (PyObject_CheckIRVectorOfOpResult(steps_obj)){
            std::vector<pir::Value> steps_tmp = CastPyArg2VectorOfValue(steps_obj, "set_value_with_tensor_grad", 4);
            steps = paddle::dialect::stack(steps_tmp, /*axis*/0);

        }else{
            std::vector<int64_t> steps_tmp = CastPyArg2Longs(steps_obj, "set_value_with_tensor_grad", 4);
            steps = paddle::dialect::full_int_array(steps_tmp, phi::DataType::INT64, phi::CPUPlace());

        }
            std::vector<int64_t> axes = CastPyArg2Longs(axes_obj, "set_value_with_tensor_grad", 5);
            std::vector<int64_t> decrease_axes = CastPyArg2Longs(decrease_axes_obj, "set_value_with_tensor_grad", 6);
            std::vector<int64_t> none_axes = CastPyArg2Longs(none_axes_obj, "set_value_with_tensor_grad", 7);

        // Call ir static api
        auto static_api_out = paddle::dialect::set_value_with_tensor_grad(values, out_grad, starts, ends, steps, axes, decrease_axes, none_axes);
        return ToPyObject(static_api_out);


    } catch (...) {
        ThrowExceptionToPython(std::current_exception());
        return nullptr;
    }
}

PyObject *static_api_slice_grad(PyObject *self, PyObject *args, PyObject *kwargs) {
    try {
        VLOG(6) << "Add slice_grad op into program";
        VLOG(8) << "args count: " << (PyTuple_Size(args) / 2);

        // Get Value from args
        PyObject *input_obj = PyTuple_GET_ITEM(args, 0);
        auto input = CastPyArg2Value(input_obj, "slice_grad", 0);
        PyObject *out_grad_obj = PyTuple_GET_ITEM(args, 1);
        auto out_grad = CastPyArg2Value(out_grad_obj, "slice_grad", 1);

        // Parse Attributes
        PyObject *axes_obj = PyTuple_GET_ITEM(args, 2);
        PyObject *starts_obj = PyTuple_GET_ITEM(args, 3);
        PyObject *ends_obj = PyTuple_GET_ITEM(args, 4);
        PyObject *infer_flags_obj = PyTuple_GET_ITEM(args, 5);
        PyObject *decrease_axis_obj = PyTuple_GET_