#include "glog/logging.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/api/generated/fluid_generated/nodes/nodes.h"

paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> uniform_random_inplaceGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: uniform_random_inplaceGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = uniform_random_inplaceGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("uniform_random_inplace_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> maxoutGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: maxoutGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = maxoutGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("maxout_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> linear_interpGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: linear_interpGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = linear_interpGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto OutSize = egr::EagerUtils::RecoverTensorWrapper(&this->OutSize_);
  if(OutSize.defined()) ins0["OutSize"] =      egr::EagerUtils::TrySyncToVars(OutSize);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("linear_interp_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> put_along_axisGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: put_along_axisGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = put_along_axisGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Index", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Index_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Result@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Value@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("put_along_axis_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }
 if (outs0.find("Value@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Value@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> batch_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(6);
    VLOG(3) << "Running Eager Backward Node: batch_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = batch_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Bias", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Bias_)) },{ "ReserveSpace", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ReserveSpace_)) },{ "SavedMean", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedMean_)) },{ "SavedVariance", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedVariance_)) },{ "Scale", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Scale_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Bias@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Scale@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("batch_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Scale@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Scale@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> elementwise_addGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: elementwise_addGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = elementwise_addGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("elementwise_add_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> acosGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: acosGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = acosGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("acos_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> unpoolGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: unpoolGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = unpoolGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Indices", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Indices_)) },{ "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("unpool_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> cumprodGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: cumprodGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = cumprodGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("cumprod_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sample_logitsGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: sample_logitsGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sample_logitsGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "LabelsDim", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->LabelsDim_)) },{ "LogitsDim", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->LogitsDim_)) },{ "SampledLogits@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[4]) },{ "Samples", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Samples_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Logits@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sample_logits_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Logits@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Logits@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> pull_box_extended_sparseGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: pull_box_extended_sparseGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = pull_box_extended_sparseGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Ids", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Ids_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "OutExtend@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[1]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ 
 outs0.insert({ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0])});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("push_box_extended_sparse", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
  if (outs0.find("Out@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> crop_tensorGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: crop_tensorGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = crop_tensorGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto Offsets = egr::EagerUtils::RecoverTensorWrapper(&this->Offsets_);
  if(Offsets.defined()) ins0["Offsets"] =      egr::EagerUtils::TrySyncToVars(Offsets);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("crop_tensor_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> deformable_convGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: deformable_convGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = deformable_convGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Filter", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Filter_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Mask", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Mask_)) },{ "Offset", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Offset_)) },{ "Output@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[3].empty()) && (!(out_metas[3][0].IsStopGradient()))){ outs0.insert({ "Filter@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Mask@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Offset@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("deformable_conv_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Filter@GRAD") != outs0.end()) { outputs[3] = egr::EagerUtils::GetOutputs(outs0["Filter@GRAD"]); }
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }
 if (outs0.find("Mask@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Mask@GRAD"]); }
 if (outs0.find("Offset@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Offset@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> expand_asGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: expand_asGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = expand_asGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "target_tensor", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->target_tensor_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("expand_as_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> matrix_powerGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: matrix_powerGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = matrix_powerGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("matrix_power_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> bilinear_interpGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: bilinear_interpGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = bilinear_interpGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto OutSize = egr::EagerUtils::RecoverTensorWrapper(&this->OutSize_);
  if(OutSize.defined()) ins0["OutSize"] =      egr::EagerUtils::TrySyncToVars(OutSize);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("bilinear_interp_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sigmoidGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: sigmoidGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sigmoidGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("sigmoid_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> inplace_abnGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(6);
    VLOG(3) << "Running Eager Backward Node: inplace_abnGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = inplace_abnGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Bias", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Bias_)) },{ "ReserveSpace", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ReserveSpace_)) },{ "SavedMean", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedMean_)) },{ "SavedVariance", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->SavedVariance_)) },{ "Scale", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Scale_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "Bias@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Scale@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("inplace_abn_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Bias@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["Bias@GRAD"]); }
 if (outs0.find("Scale@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Scale@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> softshrinkGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: softshrinkGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = softshrinkGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("softshrink_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> mulGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: mulGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = mulGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Y_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Y@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("mul_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }
 if (outs0.find("Y@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Y@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> data_normGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: data_normGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = data_normGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Means", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Means_)) },{ "Scales", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Scales_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) },{ "Y@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "BatchSize", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "BatchSize@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[3].empty()) && (!(out_metas[3][0].IsStopGradient()))){ outs0.insert({ "BatchSquareSum", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[3].empty()) && (!(out_metas[3][0].IsStopGradient()))){ outs0.insert({ "BatchSquareSum@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "BatchSum", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[2].empty()) && (!(out_metas[2][0].IsStopGradient()))){ outs0.insert({ "BatchSum@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("data_norm_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("BatchSize") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["BatchSize"]); }
 if (outs0.find("BatchSize@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["BatchSize@GRAD"]); }
 if (outs0.find("BatchSquareSum") != outs0.end()) { outputs[3] = egr::EagerUtils::GetOutputs(outs0["BatchSquareSum"]); }
 if (outs0.find("BatchSquareSum@GRAD") != outs0.end()) { outputs[3] = egr::EagerUtils::GetOutputs(outs0["BatchSquareSum@GRAD"]); }
 if (outs0.find("BatchSum") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["BatchSum"]); }
 if (outs0.find("BatchSum@GRAD") != outs0.end()) { outputs[2] = egr::EagerUtils::GetOutputs(outs0["BatchSum@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> asinhGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: asinhGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = asinhGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("asinh_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> sppGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: sppGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = sppGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("spp_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> floorGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: floorGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = floorGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("floor_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> as_realGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: as_realGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = as_realGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("as_complex", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> geluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: geluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = geluGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("gelu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> minusGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: minusGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = minusGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(X) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("X") && outs0.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["X"][0], outs0["Out"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("scale", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }

  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads1 = minusGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced1 = false;
  auto& backward_inplace_tensor1 = hooked_grads1[0][0];
  if (backward_inplace_tensor1.initialized()) {
    VLOG(10) << backward_inplace_tensor1.name() << "(X) use_count: " << backward_inplace_tensor1.impl().use_count();
    if (backward_inplace_tensor1.impl().use_count() == 1 || (backward_inplace_tensor1.impl().use_count() == 2 && backward_inplace_tensor1.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced1 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins1 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads1[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs1;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs1.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced1 && ins1.count("X") && outs1.count("Out")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins1["X"][0], outs1["Out"][0]);
  };
  auto& attrs_map1 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("scale", ins1, outs1, attrs_map1,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs1.find("Out") != outs1.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs1["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> siluGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: siluGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = siluGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("silu_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> realGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: realGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = realGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("real_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> nearest_interp_v2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: nearest_interp_v2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = nearest_interp_v2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("nearest_interp_v2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> squeeze2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: squeeze2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = squeeze2GradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "XShape", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->XShape_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("squeeze2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> conjGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: conjGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = conjGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("conj", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> strided_sliceGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(7);
    VLOG(3) << "Running Eager Backward Node: strided_sliceGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = strided_sliceGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  auto EndsTensor = egr::EagerUtils::RecoverTensorWrapper(&this->EndsTensor_);
  if(EndsTensor.defined()) ins0["EndsTensor"] =      egr::EagerUtils::TrySyncToVars(EndsTensor);
  if(this->EndsTensorList_.size() > 0) ins0["EndsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->EndsTensorList_));
  auto StartsTensor = egr::EagerUtils::RecoverTensorWrapper(&this->StartsTensor_);
  if(StartsTensor.defined()) ins0["StartsTensor"] =      egr::EagerUtils::TrySyncToVars(StartsTensor);
  if(this->StartsTensorList_.size() > 0) ins0["StartsTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StartsTensorList_));
  auto StridesTensor = egr::EagerUtils::RecoverTensorWrapper(&this->StridesTensor_);
  if(StridesTensor.defined()) ins0["StridesTensor"] =      egr::EagerUtils::TrySyncToVars(StridesTensor);
  if(this->StridesTensorList_.size() > 0) ins0["StridesTensorList"] = egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->StridesTensorList_));
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("strided_slice_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> depthwise_conv2d_transposeGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: depthwise_conv2d_transposeGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = depthwise_conv2d_transposeGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Filter", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Filter_)) },{ "Input", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Input_)) },{ "Output@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "Filter@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Input@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("depthwise_conv2d_transpose_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Filter@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["Filter@GRAD"]); }
 if (outs0.find("Input@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Input@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> squareGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: squareGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = squareGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("square_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> var_conv_2dGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(4);
    VLOG(3) << "Running Eager Backward Node: var_conv_2dGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = var_conv_2dGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "COLUMN", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->COLUMN_)) },{ "Col", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Col_)) },{ "Out", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ROW", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ROW_)) },{ "W", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->W_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[3].empty()) && (!(out_metas[3][0].IsStopGradient()))){ outs0.insert({ "W@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("var_conv_2d_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("W@GRAD") != outs0.end()) { outputs[3] = egr::EagerUtils::GetOutputs(outs0["W@GRAD"]); }
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> log1pGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: log1pGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = log1pGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("log1p_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> channel_shuffleGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: channel_shuffleGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = channel_shuffleGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("channel_shuffle_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> atan2GradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(2);
    VLOG(3) << "Running Eager Backward Node: atan2GradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = atan2GradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X1", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X1_)) },{ "X2", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X2_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X1@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
  if((!out_metas[1].empty()) && (!(out_metas[1][0].IsStopGradient()))){ outs0.insert({ "X2@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("atan2_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X1@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X1@GRAD"]); }
 if (outs0.find("X2@GRAD") != outs0.end()) { outputs[1] = egr::EagerUtils::GetOutputs(outs0["X2@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> fused_softmax_mask_upper_triangleGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: fused_softmax_mask_upper_triangleGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = fused_softmax_mask_upper_triangleGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "Softmax", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Out_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fused_softmax_mask_upper_triangle_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> roi_poolGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(3);
    VLOG(3) << "Running Eager Backward Node: roi_poolGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = roi_poolGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Argmax", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Argmax_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "ROIs", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->ROIs_)) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  auto RoisNum = egr::EagerUtils::RecoverTensorWrapper(&this->RoisNum_);
  if(RoisNum.defined()) ins0["RoisNum"] =      egr::EagerUtils::TrySyncToVars(RoisNum);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("roi_pool_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> fft_r2cGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: fft_r2cGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = fft_r2cGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fft_r2c_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> overlap_addGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: overlap_addGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = overlap_addGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("overlap_add_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> fill_anyGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: fill_anyGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = fill_anyGradNodeCompat::ApplyGradientHooks(grads);
  // Check backward inplace info
  bool can_be_inplaced0 = false;
  auto& backward_inplace_tensor0 = hooked_grads0[0][0];
  if (backward_inplace_tensor0.initialized()) {
    VLOG(10) << backward_inplace_tensor0.name() << "(Out@GRAD) use_count: " << backward_inplace_tensor0.impl().use_count();
    if (backward_inplace_tensor0.impl().use_count() == 1 || (backward_inplace_tensor0.impl().use_count() == 2 && backward_inplace_tensor0.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced0 = true;
    }
  }
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  if (can_be_inplaced0 && ins0.count("Out@GRAD") && outs0.count("X@GRAD")) {
    egr::EagerUtils::HandleViewBetweenInputAndOutput(ins0["Out@GRAD"][0], outs0["X@GRAD"][0]);
  };
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("fill_any_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> c_splitGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: c_splitGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = c_splitGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "X", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "Out", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("c_allgather", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("Out") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["Out"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> max_pool2d_with_indexGradNodeCompat::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> outputs(1);
    VLOG(3) << "Running Eager Backward Node: max_pool2d_with_indexGradNodeCompat";
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> hooked_grads0 = max_pool2d_with_indexGradNodeCompat::ApplyGradientHooks(grads);
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> ins0 = { { "Mask", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->Mask_)) },{ "Out@GRAD", egr::EagerUtils::TrySyncToVars(hooked_grads0[0]) },{ "X", egr::EagerUtils::TrySyncToVars(egr::EagerUtils::RecoverTensorWrapper(&this->X_)) } };
  std::map<std::string, std::vector<std::shared_ptr<egr::EagerVariable>>> outs0;
 if((!out_metas[0].empty()) && (!(out_metas[0][0].IsStopGradient()))){ outs0.insert({ "X@GRAD", {std::make_shared<egr::EagerVariable>(egr::Controller::Instance().GenerateUniqueName())}});} 
 
  auto& attrs_map0 = this->attr_map_;
  // Pass the entire attribute map to TraceOp
  // The underlying kernel will pickup whatever attribute they need at runtime
  egr::Controller::Instance().GetCurrentTracer()->TraceOp("max_pool2d_with_index_grad", ins0, outs0, attrs_map0,
      egr::Controller::Instance().GetExpectedPlace(),
      &this->default_attr_map_, false, {});
 if (outs0.find("X@GRAD") != outs0.end()) { outputs[0] = egr::EagerUtils::GetOutputs(outs0["X@GRAD"]); }


  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&outputs);
  return outputs;

}
