#pragma once
#include "glog/logging.h"
#include "paddle/fluid/eager/autograd_meta.h"
#include "paddle/phi/api/all.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/eager/api/manual/fluid_manual/dygraph_forward_api.h"

extern std::unordered_map<std::string, std::vector<std::string>> core_ops_args_info;
extern std::unordered_map<std::string, std::vector<std::string>> core_ops_args_type_info;
extern std::unordered_map<std::string, std::vector<std::string>> core_ops_returns_info;

paddle::experimental::Tensor rsqrt_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor rsqrt__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor multihead_matmul_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& BiasQK, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor addmm_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> gru_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Weight, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor round_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor round__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor rank_attention_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& RankOffset,const paddle::experimental::Tensor& RankParam, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fused_embedding_fc_lstm_dygraph_function(const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Embeddings,const paddle::experimental::Tensor& WeightH,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor where_index_dygraph_function(const paddle::experimental::Tensor& Condition, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bicubic_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor arg_min_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tile_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,paddle::experimental::Tensor> distributed_fused_lamb_init_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad, size_t ParamOutNum, size_t MasterParamOutNum, size_t GradOutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dequantize_linear_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& ZeroPoint, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bilinear_tensor_product_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor ctc_align_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> pow2_decay_with_linear_warmup_dygraph_function(const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Step, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_amin_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> split_dygraph_function(const paddle::experimental::Tensor& X, std::vector<paddle::experimental::Tensor*>& OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fc_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& W, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor clear_float_status_dygraph_function(const paddle::experimental::Tensor& FloatStatus, paddle::experimental::Tensor* FloatStatusOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor load_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor matmul_v2_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_embedding_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> adadelta_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& AvgSquaredGrad,const paddle::experimental::Tensor& AvgSquaredUpdate, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* AvgSquaredGradOutVar, paddle::experimental::Tensor* AvgSquaredUpdateOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> chunk_eval_dygraph_function(const paddle::experimental::Tensor& Inference,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& SeqLength, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor> check_finite_and_unscale_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& Scale, std::vector<paddle::experimental::Tensor*>& OutVar, paddle::experimental::Tensor* FoundInfiniteVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> sparse_momentum_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Velocity,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* VelocityOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor complex_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tan_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> adam_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Moment1,const paddle::experimental::Tensor& Moment2,const paddle::experimental::Tensor& Beta1Pow,const paddle::experimental::Tensor& Beta2Pow,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* Moment1OutVar, paddle::experimental::Tensor* Moment2OutVar, paddle::experimental::Tensor* Beta1PowOutVar, paddle::experimental::Tensor* Beta2PowOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fsp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor where_dygraph_function(const paddle::experimental::Tensor& Condition,const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logical_xor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> multiclass_nms3_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores,const paddle::experimental::Tensor& RoisNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor one_hot_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor affine_channel_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor affine_channel__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor triangular_solve_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> sequence_topk_avg_pooling_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROW,const paddle::experimental::Tensor& COLUMN, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor space_to_depth_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reverse_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fused_embedding_eltwise_layernorm_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const std::vector<paddle::experimental::Tensor>& Embs,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Scale, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expand_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor repeat_interleave_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& RepeatsTensor, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lgamma_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor solve_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> deformable_psroi_pooling_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& Trans, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor transfer_layout_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> instance_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor decode_jpeg_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> distributed_push_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const std::vector<paddle::experimental::Tensor>& Shows,const std::vector<paddle::experimental::Tensor>& Clicks, size_t OutputsNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gather_nd_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_prod_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor matrix_rank_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& TolTensor, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor asin_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lstmp_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& ProjWeight,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor iou_similarity_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> huber_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor one_hot_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_slice_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Offset,const paddle::experimental::Tensor& Length, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lookup_table_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor softplus_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor depthwise_conv2d_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_sum_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_sum__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fused_fc_elementwise_layernorm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sigmoid_cross_entropy_with_logits_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sigmoid_cross_entropy_with_logits__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor exp_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor exp__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor scatter_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Updates, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor scatter__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Updates, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_min_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_min__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor equal_all_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor searchsorted_dygraph_function(const paddle::experimental::Tensor& SortedSequence,const paddle::experimental::Tensor& Values, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_squared_mat_sub_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> unique_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv_shift_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor as_complex_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> smooth_l1_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& InsideWeight,const paddle::experimental::Tensor& OutsideWeight, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor linear_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> momentum_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Velocity,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* VelocityOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor temporal_shift_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> nce_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& SampleWeight,const paddle::experimental::Tensor& CustomDistProbs,const paddle::experimental::Tensor& CustomDistAlias,const paddle::experimental::Tensor& CustomDistAliasProbs, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor mv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Vec, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor global_scatter_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& local_count,const paddle::experimental::Tensor& global_count, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> dropout_nd_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor proximal_gd_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor memcpy_h2d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor add_position_encoding_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cosh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hash_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor grad_add_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sign_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor prelu_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Alpha, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor linspace_dygraph_function(const paddle::experimental::Tensor& Start,const paddle::experimental::Tensor& Stop,const paddle::experimental::Tensor& Num, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_diagonal_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_diagonal__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logsigmoid_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> load_combine_dygraph_function( size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fetch_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor randperm_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_scatter_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Updates, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor relu6_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor relu6__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor partial_sum_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor partial_allgather_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor partial_allgather__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_scatter_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor alltoall_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor alltoall__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv3d_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu_unpack_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Pivots, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> lstm_unit_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& C_prev, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor not_equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> transpose2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> c_sync_comm_stream_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, std::vector<paddle::experimental::Tensor*>& OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor uniform_random_batch_size_like_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor yolo_box_head_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor unfold_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> lrn_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isclose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Other, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> softmax_with_cross_entropy_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> softmax_with_cross_entropy__dygraph_function(paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isfinite_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bernoulli_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> max_pool3d_with_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> fused_seqpool_cvm_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& CVM, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gaussian_random_dygraph_function( const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten2__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor matmul_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cvm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& CVM, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> adamax_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& InfNorm,const paddle::experimental::Tensor& Beta1Pow, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MomentOutVar, paddle::experimental::Tensor* InfNormOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor recv_v2_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor masked_select_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Mask, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor range_dygraph_function(const paddle::experimental::Tensor& Start,const paddle::experimental::Tensor& End,const paddle::experimental::Tensor& Step, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bitwise_not_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor trace_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor multinomial_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> modified_huber_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_reduce_prod_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor roll_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squared_l2_distance_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv3d_transpose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor share_data_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> rrelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> unique_with_counts_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_zeros_like_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> hierarchical_sigmoid_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& PathTable,const paddle::experimental::Tensor& PathCode,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isinf_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor squeeze_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> multiclass_nms2_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bpr_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fft_c2c_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bicubic_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor angle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reshape_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reshape__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor> coalesce_tensor_dygraph_function(const std::vector<paddle::experimental::Tensor>& Input, std::vector<paddle::experimental::Tensor*>& OutputVar, paddle::experimental::Tensor* FusedOutputVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor roi_align_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& RoisNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> reshape2_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Shape, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> reshape2__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Shape, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_any_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor limit_by_capacity_dygraph_function(const paddle::experimental::Tensor& expert_count,const paddle::experimental::Tensor& capacity, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> unstack_dygraph_function(const paddle::experimental::Tensor& X, size_t YNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor scatter_nd_add_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Updates, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_reshape_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bilateral_slice_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Grid,const paddle::experimental::Tensor& Guide, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_any_like_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor partial_recv_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor empty_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pad_constant_like_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pool2d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor size_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor imag_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> pull_gpups_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> eigh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor stack_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> dgc_momentum_dygraph_function(const paddle::experimental::Tensor& current_step,const paddle::experimental::Tensor& nranks,const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Velocity,const paddle::experimental::Tensor& LearningRate, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lamb_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Moment1,const paddle::experimental::Tensor& Moment2,const paddle::experimental::Tensor& Beta1Pow,const paddle::experimental::Tensor& Beta2Pow,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* Moment1OutVar, paddle::experimental::Tensor* Moment2OutVar, paddle::experimental::Tensor* Beta1PowOutVar, paddle::experimental::Tensor* Beta2PowOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_proposals_v2_dygraph_function(const paddle::experimental::Tensor& Scores,const paddle::experimental::Tensor& BboxDeltas,const paddle::experimental::Tensor& ImShape,const paddle::experimental::Tensor& Anchors,const paddle::experimental::Tensor& Variances, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_sync_calc_stream_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bitwise_or_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> gru_unit_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& HiddenPrev,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_channel_wise_quantize_dequantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, paddle::experimental::Tensor* OutScaleVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sampling_id_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> unsqueeze2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> unsqueeze2__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor transfer_dtype_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor allreduce_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> average_accumulates_dygraph_function(const paddle::experimental::Tensor& param,const paddle::experimental::Tensor& in_sum_1,const paddle::experimental::Tensor& in_sum_2,const paddle::experimental::Tensor& in_sum_3,const paddle::experimental::Tensor& in_num_accumulates,const paddle::experimental::Tensor& in_old_num_accumulates,const paddle::experimental::Tensor& in_num_updates, paddle::experimental::Tensor* out_sum_1Var, paddle::experimental::Tensor* out_sum_2Var, paddle::experimental::Tensor* out_sum_3Var, paddle::experimental::Tensor* out_num_accumulatesVar, paddle::experimental::Tensor* out_old_num_accumulatesVar, paddle::experimental::Tensor* out_num_updatesVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_enumerate_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_seqconv_eltadd_relu_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Filter,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bce_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bce_loss__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_proposal_labels_dygraph_function(const paddle::experimental::Tensor& RpnRois,const paddle::experimental::Tensor& GtClasses,const paddle::experimental::Tensor& IsCrowd,const paddle::experimental::Tensor& GtBoxes,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor im2sequence_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isinf_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_reducescatter_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logcumsumexp_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> adagrad_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& LearningRate, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MomentOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> linear_chain_crf_dygraph_function(const paddle::experimental::Tensor& Emission,const paddle::experimental::Tensor& Transition,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Length, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> retinanet_target_assign_dygraph_function(const paddle::experimental::Tensor& Anchor,const paddle::experimental::Tensor& GtBoxes,const paddle::experimental::Tensor& GtLabels,const paddle::experimental::Tensor& IsCrowd,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> fusion_group_dygraph_function(const std::vector<paddle::experimental::Tensor>& Inputs, size_t OutsNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor teacher_student_sigmoid_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> random_crop_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Seed, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lookup_table_v2_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_fmax_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> graph_sample_neighbors_dygraph_function(const paddle::experimental::Tensor& Row,const paddle::experimental::Tensor& Col_Ptr,const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Eids,const paddle::experimental::Tensor& Perm_Buffer, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> detection_map_dygraph_function(const paddle::experimental::Tensor& DetectRes,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor l1_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sqrt_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sqrt__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
void* partial_send_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fused_elemwise_activation_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor slogdeterminant_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> share_buffer_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, size_t XOutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor poisson_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bitwise_and_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor diag_embed_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> unbind_dygraph_function(const paddle::experimental::Tensor& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> dropout_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> beam_search_dygraph_function(const paddle::experimental::Tensor& pre_ids,const paddle::experimental::Tensor& pre_scores,const paddle::experimental::Tensor& scores, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> moving_average_abs_max_scale_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& InAccum,const paddle::experimental::Tensor& InState, paddle::experimental::Tensor* OutVar, paddle::experimental::Tensor* OutScaleVar, paddle::experimental::Tensor* OutStateVar, paddle::experimental::Tensor* OutAccumVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor greater_than_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log_loss_dygraph_function(const paddle::experimental::Tensor& Predicted,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor kron_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sigmoid_focal_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& FgNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> rmsprop_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& MeanSquare,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Moment, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MomentOutVar, paddle::experimental::Tensor* MeanSquareOutVar, paddle::experimental::Tensor* MeanGradOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv2d_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> graph_reindex_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Neighbors,const paddle::experimental::Tensor& Count,const paddle::experimental::Tensor& HashTable_Value,const paddle::experimental::Tensor& HashTable_Index, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor uniform_random_inplace_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor uniform_random_inplace__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor maxout_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lstsq_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor linear_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> graph_khop_sampler_dygraph_function(const paddle::experimental::Tensor& Row,const paddle::experimental::Tensor& Eids,const paddle::experimental::Tensor& Col_Ptr,const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor put_along_axis_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Value, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor put_along_axis__dygraph_function(paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Value, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> auc_dygraph_function(const paddle::experimental::Tensor& Predict,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& StatPos,const paddle::experimental::Tensor& StatNeg, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logical_or_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> batch_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_reduce_sum_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_add_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_add__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor acos_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> send_and_recv_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor unpool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Indices, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cumprod_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> sample_logits_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> pull_box_extended_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, size_t OutNum, size_t OutExtendNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor crop_tensor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Shape,const paddle::experimental::Tensor& Offsets, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_constant_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor deformable_conv_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Offset,const paddle::experimental::Tensor& Mask,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_mask_labels_dygraph_function(const paddle::experimental::Tensor& ImInfo,const paddle::experimental::Tensor& GtClasses,const paddle::experimental::Tensor& IsCrowd,const paddle::experimental::Tensor& GtSegms,const paddle::experimental::Tensor& Rois,const paddle::experimental::Tensor& LabelsInt32, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor locality_aware_nms_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expand_as_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& target_tensor, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor matrix_power_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor greater_equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> generate_proposals_dygraph_function(const paddle::experimental::Tensor& Scores,const paddle::experimental::Tensor& BboxDeltas,const paddle::experimental::Tensor& ImInfo,const paddle::experimental::Tensor& Anchors,const paddle::experimental::Tensor& Variances, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor number_count_dygraph_function(const paddle::experimental::Tensor& numbers, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bilinear_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,paddle::experimental::Tensor> distributed_fused_lamb_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad,const paddle::experimental::Tensor& Moment1,const paddle::experimental::Tensor& Moment2,const paddle::experimental::Tensor& Beta1Pow,const paddle::experimental::Tensor& Beta2Pow,const paddle::experimental::Tensor& FusedParamOffsets,const paddle::experimental::Tensor& FP32ShardFusedParamOffsets,const paddle::experimental::Tensor& FP16ShardFusedParamOffsets,const paddle::experimental::Tensor& ParamInfo,const paddle::experimental::Tensor& ParamOrder,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& GlobalScale, size_t ParamOutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sigmoid_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sigmoid__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> inplace_abn_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> inplace_abn__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance,const paddle::experimental::Tensor& MomentumTensor, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor softshrink_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor mul_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> data_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& BatchSize,const paddle::experimental::Tensor& BatchSum,const paddle::experimental::Tensor& BatchSquareSum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor asinh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor get_tensor_from_selected_rows_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor spp_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor floor_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor floor__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor as_real_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor retinanet_detection_output_dygraph_function(const std::vector<paddle::experimental::Tensor>& BBoxes,const std::vector<paddle::experimental::Tensor>& Scores,const std::vector<paddle::experimental::Tensor>& Anchors,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor minus_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
void* push_dense_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor silu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_erase_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor real_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor nearest_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dgc_clip_by_norm_dygraph_function(const paddle::experimental::Tensor& current_step,const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squeeze2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> squeeze2__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conj_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor strided_slice_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& StartsTensor,const paddle::experimental::Tensor& EndsTensor,const paddle::experimental::Tensor& StridesTensor,const std::vector<paddle::experimental::Tensor>& StartsTensorList,const std::vector<paddle::experimental::Tensor>& EndsTensorList,const std::vector<paddle::experimental::Tensor>& StridesTensorList, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> precision_recall_dygraph_function(const paddle::experimental::Tensor& MaxProbs,const paddle::experimental::Tensor& Indices,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_seqexpand_concat_fc_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& FCWeight, const paddle::framework::AttributeMap& attr_map);
void* save_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor depthwise_conv2d_transpose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_range_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& InScale, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> positive_negative_pair_dygraph_function(const paddle::experimental::Tensor& Score,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& QueryID, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor square_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor square__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> var_conv_2d_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROW,const paddle::experimental::Tensor& COLUMN,const paddle::experimental::Tensor& W, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log1p_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor channel_shuffle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor atan2_dygraph_function(const paddle::experimental::Tensor& X1,const paddle::experimental::Tensor& X2, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fused_softmax_mask_upper_triangle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor clip_by_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> box_decoder_and_assign_dygraph_function(const paddle::experimental::Tensor& PriorBox,const paddle::experimental::Tensor& TargetBox,const paddle::experimental::Tensor& BoxScore, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> roi_pool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& RoisNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fft_r2c_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor overlap_add_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_constant_batch_size_like_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_any_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_any__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dequantize_log_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Dict, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_split_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor barrier_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> max_pool2d_with_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pad3d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> viterbi_decode_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Transition,const paddle::experimental::Tensor& Length, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor mish_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor box_coder_dygraph_function(const paddle::experimental::Tensor& PriorBox,const paddle::experimental::Tensor& PriorBoxVar,const paddle::experimental::Tensor& TargetBox, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor flatten_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor flatten__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_mod_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> margin_cross_entropy_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> pull_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const std::vector<paddle::experimental::Tensor>& W, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logical_and_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pow_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dirichlet_dygraph_function(const paddle::experimental::Tensor& Alpha, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor stanh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor label_smooth_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& PriorDist, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fold_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> merged_momentum_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad,const std::vector<paddle::experimental::Tensor>& Velocity,const std::vector<paddle::experimental::Tensor>& LearningRate,const std::vector<paddle::experimental::Tensor>& MasterParam, std::vector<paddle::experimental::Tensor*>& ParamOutVar, std::vector<paddle::experimental::Tensor*>& VelocityOutVar, std::vector<paddle::experimental::Tensor*>& MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_reduce_min_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> ascend_trigger_dygraph_function(const std::vector<paddle::experimental::Tensor>& FeedList, size_t FetchListNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> rpn_target_assign_dygraph_function(const paddle::experimental::Tensor& Anchor,const paddle::experimental::Tensor& GtBoxes,const paddle::experimental::Tensor& IsCrowd,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> roi_perspective_transform_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expand_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ExpandTimes, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor prroi_pool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& BatchRoINums, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pool3d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor memcpy_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>> distribute_fpn_proposals_dygraph_function(const paddle::experimental::Tensor& FpnRois,const paddle::experimental::Tensor& RoisNum, size_t MultiFpnRoisNum, size_t MultiLevelRoIsNumNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor frame_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bincount_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Weights, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor shape_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> mode_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> group_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, paddle::experimental::Tensor* MeanVar, paddle::experimental::Tensor* VarianceVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> c_softmax_with_cross_entropy_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> c_softmax_with_cross_entropy__dygraph_function(paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_expand_as_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> cos_sim_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor eigvals_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
void* save_combine_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> class_center_sample_dygraph_function(const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_fmin_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor read_file_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isfinite_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor arg_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fake_dequantize_max_abs_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> qr_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> anchor_generator_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> layer_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor merge_selected_rows_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor acosh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor stft_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Window, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor less_equal_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>> rnn_dygraph_function(const paddle::experimental::Tensor& Input,const std::vector<paddle::experimental::Tensor>& PreState,const std::vector<paddle::experimental::Tensor>& WeightList,const paddle::experimental::Tensor& SequenceLength, paddle::experimental::Tensor* DropoutStateVar, size_t StateNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_lstm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& WeightX,const paddle::experimental::Tensor& WeightH,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> lars_momentum_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad,const std::vector<paddle::experimental::Tensor>& Velocity,const std::vector<paddle::experimental::Tensor>& LearningRate, std::vector<paddle::experimental::Tensor*>& ParamOutVar, std::vector<paddle::experimental::Tensor*>& VelocityOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hard_sigmoid_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hard_sigmoid__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isnan_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_floordiv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor correlation_dygraph_function(const paddle::experimental::Tensor& Input1,const paddle::experimental::Tensor& Input2, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor histogram_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gather_tree_dygraph_function(const paddle::experimental::Tensor& Ids,const paddle::experimental::Tensor& Parents, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> nanmedian_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> segment_pool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& SegmentIds, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor> fusion_repeated_fc_relu_dygraph_function(const paddle::experimental::Tensor& X,const std::vector<paddle::experimental::Tensor>& W,const std::vector<paddle::experimental::Tensor>& Bias, size_t ReluOutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> sync_batch_norm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias,const paddle::experimental::Tensor& Mean,const paddle::experimental::Tensor& Variance, paddle::experimental::Tensor* MeanOutVar, paddle::experimental::Tensor* VarianceOutVar, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> nop_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> filter_by_instag_dygraph_function(const paddle::experimental::Tensor& Ins,const paddle::experimental::Tensor& Ins_tag,const paddle::experimental::Tensor& Filter_tag, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expand_as_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor diag_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> pull_box_sparse_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> nll_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Weight, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dot_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor scale_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor scale__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> shuffle_batch_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Seed, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor diag_dygraph_function(const paddle::experimental::Tensor& Diagonal, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor multiplex_dygraph_function(const paddle::experimental::Tensor& Ids,const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor leaky_relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor leaky_relu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor allclose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Other, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> adamw_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Moment1,const paddle::experimental::Tensor& Moment2,const paddle::experimental::Tensor& Beta1Pow,const paddle::experimental::Tensor& Beta2Pow,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* Moment1OutVar, paddle::experimental::Tensor* Moment2OutVar, paddle::experimental::Tensor* Beta1PowOutVar, paddle::experimental::Tensor* Beta2PowOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_pow_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> prior_box_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Image, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor p_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_concat_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> unique_consecutive_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lod_reset_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lod_reset__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pad_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_conv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor set_value_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& ValueTensor,const std::vector<paddle::experimental::Tensor>& StartsTensorList,const std::vector<paddle::experimental::Tensor>& EndsTensorList,const std::vector<paddle::experimental::Tensor>& StepsTensorList, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor set_value__dygraph_function(paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& ValueTensor,const std::vector<paddle::experimental::Tensor>& StartsTensorList,const std::vector<paddle::experimental::Tensor>& EndsTensorList,const std::vector<paddle::experimental::Tensor>& StepsTensorList, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log10_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor nms_dygraph_function(const paddle::experimental::Tensor& Boxes, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bitwise_xor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> center_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Centers,const paddle::experimental::Tensor& CenterUpdateRate, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor randint_dygraph_function( const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> attention_lstm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& C0,const paddle::experimental::Tensor& AttentionWeight,const paddle::experimental::Tensor& LSTMWeight,const paddle::experimental::Tensor& LSTMBias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor uniform_random_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor slice_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& StartsTensor,const paddle::experimental::Tensor& EndsTensor,const std::vector<paddle::experimental::Tensor>& StartsTensorList,const std::vector<paddle::experimental::Tensor>& EndsTensorList, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> meshgrid_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hard_swish_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sin_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> mean_iou_dygraph_function(const paddle::experimental::Tensor& Predictions,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pad2d_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor inverse_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor spectral_norm_dygraph_function(const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& U,const paddle::experimental::Tensor& V, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor shuffle_channel_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
void* send_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor psroi_pool_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ROIs,const paddle::experimental::Tensor& RoisNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor seed_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor ceil_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor ceil__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> eig_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_min_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cos_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> cudnn_lstm_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& InitH,const paddle::experimental::Tensor& InitC, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor random_routing_dygraph_function(const paddle::experimental::Tensor& Prob,const paddle::experimental::Tensor& TopK_Value,const paddle::experimental::Tensor& TopK_Idx, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor random_routing__dygraph_function(const paddle::experimental::Tensor& Prob,const paddle::experimental::Tensor& TopK_Value,paddle::experimental::Tensor& TopK_Idx, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_sum_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor digamma_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor quantize_linear_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& ZeroPoint, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor assign_value_dygraph_function( paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor increment_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logspace_dygraph_function(const paddle::experimental::Tensor& Start,const paddle::experimental::Tensor& Stop,const paddle::experimental::Tensor& Num,const paddle::experimental::Tensor& Base, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> tdm_sampler_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Travel,const paddle::experimental::Tensor& Layer, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fused_softmax_mask_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Mask, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_reverse_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> eigvalsh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor diagonal_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor trunc_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
void* marker_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tanh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tanh__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> yolov3_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& GTBox,const paddle::experimental::Tensor& GTLabel,const paddle::experimental::Tensor& GTScore, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> graph_send_recv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Src_index,const paddle::experimental::Tensor& Dst_index, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> accuracy_dygraph_function(const paddle::experimental::Tensor& Out,const paddle::experimental::Tensor& Indices,const paddle::experimental::Tensor& Label, paddle::experimental::Tensor* CorrectVar, paddle::experimental::Tensor* TotalVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor atan_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor less_than_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_amax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor unsqueeze_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor crf_decoding_dygraph_function(const paddle::experimental::Tensor& Emission,const paddle::experimental::Tensor& Transition,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Length, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor global_gather_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& local_count,const paddle::experimental::Tensor& global_count, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> merged_adam_dygraph_function(const std::vector<paddle::experimental::Tensor>& Param,const std::vector<paddle::experimental::Tensor>& Grad,const std::vector<paddle::experimental::Tensor>& LearningRate,const std::vector<paddle::experimental::Tensor>& Moment1,const std::vector<paddle::experimental::Tensor>& Moment2,const std::vector<paddle::experimental::Tensor>& Beta1Pow,const std::vector<paddle::experimental::Tensor>& Beta2Pow,const std::vector<paddle::experimental::Tensor>& MasterParam, std::vector<paddle::experimental::Tensor*>& ParamOutVar, std::vector<paddle::experimental::Tensor*>& Moment1OutVar, std::vector<paddle::experimental::Tensor*>& Moment2OutVar, std::vector<paddle::experimental::Tensor*>& Beta1PowOutVar, std::vector<paddle::experimental::Tensor*>& Beta2PowOutVar, std::vector<paddle::experimental::Tensor*>& MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lerp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& Weight, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lerp__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& Weight, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_prod_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_prod__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor log_softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> ftrl_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& SquaredAccumulator,const paddle::experimental::Tensor& LinearAccumulator,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* SquaredAccumOutVar, paddle::experimental::Tensor* LinearAccumOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> matrix_nms_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> top_k_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cast_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tanh_shrink_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hard_shrink_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logit_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor multiclass_nms_dygraph_function(const paddle::experimental::Tensor& BBoxes,const paddle::experimental::Tensor& Scores, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_broadcast_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_unpad_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Length, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fused_elemwise_add_activation_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> pull_sparse_v2_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const std::vector<paddle::experimental::Tensor>& W, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,std::vector<paddle::experimental::Tensor>,std::vector<paddle::experimental::Tensor>> einsum_dygraph_function(const std::vector<paddle::experimental::Tensor>& Operands, size_t InnerCacheNum, size_t XShapeNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor frobenius_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor crop_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& Offsets, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> cross_entropy2_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor skip_layernorm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& Scale,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> tdm_child_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& TreeInfo, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fused_embedding_seq_pool_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> kthvalue_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor erf_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> yolo_box_post_dygraph_function(const paddle::experimental::Tensor& Boxes0,const paddle::experimental::Tensor& Boxes1,const paddle::experimental::Tensor& Boxes2,const paddle::experimental::Tensor& ImageShape,const paddle::experimental::Tensor& ImageScale, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logsumexp_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor trilinear_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fusion_seqpool_concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor alloc_float_status_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fusion_seqpool_cvm_concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& CVM, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor unpool3d_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Indices, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor similarity_focus_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allreduce_max__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> argsort_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_expand_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> sgd_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& LearningRate,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& MasterParam, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MasterParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor exponential_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor exponential__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bilinear_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor atanh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor clip_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor clip__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor deformable_conv_v1_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Offset,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor hinge_loss_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Labels, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor determinant_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv2d_transpose_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor memcpy_d2h_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor softsign_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_dequantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, paddle::experimental::Tensor* OutScaleVar, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> broadcast_tensors_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, size_t OutNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cholesky_solve_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor grid_sampler_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Grid, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fft_c2r_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> pyramid_hash_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& WhiteList,const paddle::experimental::Tensor& BlackList, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_dequantize_moving_average_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& InScale,const paddle::experimental::Tensor& InAccum,const paddle::experimental::Tensor& InState, paddle::experimental::Tensor* OutVar, paddle::experimental::Tensor* OutScaleVar, paddle::experimental::Tensor* OutStateVar, paddle::experimental::Tensor* OutAccumVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor multi_dot_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> sequence_pool_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor broadcast_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor transpose_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> top_k_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor renorm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pixel_unshuffle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor take_along_axis_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Index, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dist_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor affine_grid_dygraph_function(const paddle::experimental::Tensor& Theta, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gaussian_random_batch_size_like_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fake_channel_wise_dequantize_max_abs_dygraph_function(const paddle::experimental::Tensor& X,const std::vector<paddle::experimental::Tensor>& Scales, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reciprocal_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reciprocal__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sequence_mask_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& MaxLenTensor, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor prune_gate_by_capacity_dygraph_function(const paddle::experimental::Tensor& GateIdx,const paddle::experimental::Tensor& ExpertCount, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_diagonal_tensor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_diagonal_tensor__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor abs_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor partial_concat_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor index_select_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor row_conv_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cross_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_mul_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> decayed_adagrad_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& LearningRate, paddle::experimental::Tensor* ParamOutVar, paddle::experimental::Tensor* MomentOutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> bipartite_match_dygraph_function(const paddle::experimental::Tensor& DistMat, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_quantize_moving_average_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& InScale, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> mine_hard_examples_dygraph_function(const paddle::experimental::Tensor& ClsLoss,const paddle::experimental::Tensor& MatchIndices,const paddle::experimental::Tensor& MatchDist, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> target_assign_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& MatchIndices, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lstm_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Weight,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor assign_pos_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& cum_count,const paddle::experimental::Tensor& eff_num_len, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor truncated_gaussian_random_dygraph_function( const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> match_matrix_tensor_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y,const paddle::experimental::Tensor& W, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_div_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor kldiv_loss_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Target, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cumsum_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sum_dygraph_function(const std::vector<paddle::experimental::Tensor>& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> proximal_adagrad_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Moment,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, const paddle::framework::AttributeMap& attr_map);
std::tuple<std::vector<paddle::experimental::Tensor>,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> update_loss_scaling_dygraph_function(const std::vector<paddle::experimental::Tensor>& X,const paddle::experimental::Tensor& FoundInfinite,const paddle::experimental::Tensor& PrevLossScaling,const paddle::experimental::Tensor& InGoodSteps,const paddle::experimental::Tensor& InBadSteps, std::vector<paddle::experimental::Tensor*>& OutVar, paddle::experimental::Tensor* LossScalingVar, paddle::experimental::Tensor* OutGoodStepsVar, paddle::experimental::Tensor* OutBadStepsVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor shard_index_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor selu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gumbel_softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor mean_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> sequence_pad_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& PadValue, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tree_conv_dygraph_function(const paddle::experimental::Tensor& NodesVector,const paddle::experimental::Tensor& EdgeSet,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor assign_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten_contiguous_range_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> flatten_contiguous_range__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tril_triu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor celu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor celu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_mean_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor brelu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor sinh_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor rank_loss_dygraph_function(const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& Left,const paddle::experimental::Tensor& Right, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> fusion_gru_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& WeightX,const paddle::experimental::Tensor& WeightH, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor fill_zeros_like2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expm1_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor expm1__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor squared_l2_norm_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_sub_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_sub__dygraph_function(paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> margin_rank_loss_dygraph_function(const paddle::experimental::Tensor& X1,const paddle::experimental::Tensor& X2,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> faster_tokenizer_dygraph_function(const paddle::experimental::Tensor& Vocab,const paddle::experimental::Tensor& Text,const paddle::experimental::Tensor& TextPair, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_reduce_max_dygraph_function(const paddle::experimental::Tensor& X, paddle::experimental::Tensor* OutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_identity_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor relu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor is_empty_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor reduce_all_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> edit_distance_dygraph_function(const paddle::experimental::Tensor& Hyps,const paddle::experimental::Tensor& Refs, const paddle::framework::AttributeMap& attr_map);
std::vector<paddle::experimental::Tensor> distributed_lookup_table_dygraph_function(const std::vector<paddle::experimental::Tensor>& Ids,const paddle::experimental::Tensor& W, size_t OutputsNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor tril_indices_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor bmm_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> yolo_box_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& ImgSize, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor soft_relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor soft_relu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> density_prior_box_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Image, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor swish_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor eye_dygraph_function( const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cross_entropy_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Label, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dpsgd_dygraph_function(const paddle::experimental::Tensor& Param,const paddle::experimental::Tensor& Grad,const paddle::experimental::Tensor& LearningRate, paddle::experimental::Tensor* ParamOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor identity_loss_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor identity_loss__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor cholesky_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor batch_fc_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Bias, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor nearest_interp_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& OutSize, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor gather_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index,const paddle::experimental::Tensor& Axis, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor trilinear_interp_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor box_clip_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& ImInfo, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor c_allgather_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor isnan_v2_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> lu__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor softmax_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor softmax__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor conv2d_fusion_dygraph_function(const paddle::experimental::Tensor& Input,const paddle::experimental::Tensor& Filter, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor get_float_status_dygraph_function(const paddle::experimental::Tensor& FloatStatus, paddle::experimental::Tensor* FloatStatusOutVar, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor index_sample_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Index, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_min_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor logical_not_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> collect_fpn_proposals_dygraph_function(const std::vector<paddle::experimental::Tensor>& MultiLevelRois,const std::vector<paddle::experimental::Tensor>& MultiLevelScores,const std::vector<paddle::experimental::Tensor>& MultiLevelRoIsNum, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor erfinv_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor erfinv__dygraph_function(paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor pixel_shuffle_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor thresholded_relu_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor polygon_box_transform_dygraph_function(const paddle::experimental::Tensor& Input, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor lookup_table_dequant_dygraph_function(const paddle::experimental::Tensor& W,const paddle::experimental::Tensor& Ids, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> warpctc_dygraph_function(const paddle::experimental::Tensor& Logits,const paddle::experimental::Tensor& Label,const paddle::experimental::Tensor& LogitsLength,const paddle::experimental::Tensor& LabelLength, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor elementwise_heaviside_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Y, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor> fake_channel_wise_quantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor dequantize_abs_max_dygraph_function(const paddle::experimental::Tensor& X,const paddle::experimental::Tensor& Scale, const paddle::framework::AttributeMap& attr_map);
std::tuple<paddle::experimental::Tensor,paddle::experimental::Tensor,paddle::experimental::Tensor> svd_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
paddle::experimental::Tensor flip_dygraph_function(const paddle::experimental::Tensor& X, const paddle::framework::AttributeMap& attr_map);
