
#pragma once
#include "paddle/fluid/eager/tensor_wrapper.h"
#include "paddle/fluid/eager/grad_node_info.h"
#include "paddle/fluid/eager/api/manual/eager_manual/nodes/nodes.h"


class Atan2GradNodeFinal : public egr::GradNodeBase {
 public:
  Atan2GradNodeFinal() : egr::GradNodeBase() {}
  Atan2GradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Atan2GradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Atan2GradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Atan2GradNodeFinal>(new Atan2GradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class CholeskyGradNodeFinal : public egr::GradNodeBase {
 public:
  CholeskyGradNodeFinal() : egr::GradNodeBase() {}
  CholeskyGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CholeskyGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CholeskyGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CholeskyGradNodeFinal>(new CholeskyGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeupper(const bool& upper) {
    upper_ = upper;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  bool upper_;
};


class CholeskySolveGradNodeFinal : public egr::GradNodeBase {
 public:
  CholeskySolveGradNodeFinal() : egr::GradNodeBase() {}
  CholeskySolveGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CholeskySolveGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CholeskySolveGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CholeskySolveGradNodeFinal>(new CholeskySolveGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeupper(const bool& upper) {
    upper_ = upper;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;

  // Attributes
  bool upper_;
};


class CrossGradNodeFinal : public egr::GradNodeBase {
 public:
  CrossGradNodeFinal() : egr::GradNodeBase() {}
  CrossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CrossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CrossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CrossGradNodeFinal>(new CrossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_;
};


class DiagGradNodeFinal : public egr::GradNodeBase {
 public:
  DiagGradNodeFinal() : egr::GradNodeBase() {}
  DiagGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DiagGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DiagGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DiagGradNodeFinal>(new DiagGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeoffset(const int& offset) {
    offset_ = offset;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  int offset_;
};


class DiagonalGradNodeFinal : public egr::GradNodeBase {
 public:
  DiagonalGradNodeFinal() : egr::GradNodeBase() {}
  DiagonalGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DiagonalGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DiagonalGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DiagonalGradNodeFinal>(new DiagonalGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeoffset(const int& offset) {
    offset_ = offset;
  }
  void SetAttributeaxis1(const int& axis1) {
    axis1_ = axis1;
  }
  void SetAttributeaxis2(const int& axis2) {
    axis2_ = axis2;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  int offset_ = 0;
  int axis1_ = 0;
  int axis2_ = 1;
};


class DigammaGradNodeFinal : public egr::GradNodeBase {
 public:
  DigammaGradNodeFinal() : egr::GradNodeBase() {}
  DigammaGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DigammaGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DigammaGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DigammaGradNodeFinal>(new DigammaGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class DistGradNodeFinal : public egr::GradNodeBase {
 public:
  DistGradNodeFinal() : egr::GradNodeBase() {}
  DistGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DistGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DistGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DistGradNodeFinal>(new DistGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributep(const float& p) {
    p_ = p;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;

  // Attributes
  float p_;
};


class DotGradNodeFinal : public egr::GradNodeBase {
 public:
  DotGradNodeFinal() : egr::GradNodeBase() {}
  DotGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DotGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DotGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DotGradNodeFinal>(new DotGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class ErfGradNodeFinal : public egr::GradNodeBase {
 public:
  ErfGradNodeFinal() : egr::GradNodeBase() {}
  ErfGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ErfGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ErfGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ErfGradNodeFinal>(new ErfGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class MvGradNodeFinal : public egr::GradNodeBase {
 public:
  MvGradNodeFinal() : egr::GradNodeBase() {}
  MvGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MvGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MvGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    vec_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MvGradNodeFinal>(new MvGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappervec(const paddle::experimental::Tensor& vec) {
    vec_ = egr::TensorWrapper(vec, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper vec_;

  // Attributes
};


class PoissonGradNodeFinal : public egr::GradNodeBase {
 public:
  PoissonGradNodeFinal() : egr::GradNodeBase() {}
  PoissonGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PoissonGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PoissonGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PoissonGradNodeFinal>(new PoissonGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class TraceGradNodeFinal : public egr::GradNodeBase {
 public:
  TraceGradNodeFinal() : egr::GradNodeBase() {}
  TraceGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TraceGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TraceGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TraceGradNodeFinal>(new TraceGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeoffset(const int& offset) {
    offset_ = offset;
  }
  void SetAttributeaxis1(const int& axis1) {
    axis1_ = axis1;
  }
  void SetAttributeaxis2(const int& axis2) {
    axis2_ = axis2;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  int offset_;
  int axis1_;
  int axis2_;
};


class TruncGradNodeFinal : public egr::GradNodeBase {
 public:
  TruncGradNodeFinal() : egr::GradNodeBase() {}
  TruncGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TruncGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TruncGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TruncGradNodeFinal>(new TruncGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};



class AbsGradNodeFinal : public egr::GradNodeBase {
 public:
  AbsGradNodeFinal() : egr::GradNodeBase() {}
  AbsGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AbsGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AbsGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AbsGradNodeFinal>(new AbsGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AbsDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  AbsDoubleGradNodeFinal() : egr::GradNodeBase() {}
  AbsDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AbsDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AbsDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AbsDoubleGradNodeFinal>(new AbsDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AcosGradNodeFinal : public egr::GradNodeBase {
 public:
  AcosGradNodeFinal() : egr::GradNodeBase() {}
  AcosGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AcosGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AcosGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AcosGradNodeFinal>(new AcosGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AcoshGradNodeFinal : public egr::GradNodeBase {
 public:
  AcoshGradNodeFinal() : egr::GradNodeBase() {}
  AcoshGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AcoshGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AcoshGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AcoshGradNodeFinal>(new AcoshGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AddGradNodeFinal : public egr::GradNodeBase {
 public:
  AddGradNodeFinal() : egr::GradNodeBase() {}
  AddGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AddGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AddGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AddGradNodeFinal>(new AddGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, true);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class AddDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  AddDoubleGradNodeFinal() : egr::GradNodeBase() {}
  AddDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AddDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AddDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    y_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AddDoubleGradNodeFinal>(new AddDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper y_;
  egr::TensorWrapper grad_out_;

  // Attributes
  int axis_ = -1;
};


class AddTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  AddTripleGradNodeFinal() : egr::GradNodeBase() {}
  AddTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AddTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AddTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    grad_grad_x_.clear();
    grad_grad_y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AddTripleGradNodeFinal>(new AddTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappergrad_grad_x(const paddle::experimental::Tensor& grad_grad_x) {
    grad_grad_x_ = egr::TensorWrapper(grad_grad_x, false);
  }
  void SetTensorWrappergrad_grad_y(const paddle::experimental::Tensor& grad_grad_y) {
    grad_grad_y_ = egr::TensorWrapper(grad_grad_y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper grad_grad_x_;
  egr::TensorWrapper grad_grad_y_;

  // Attributes
  int axis_ = -1;
};


class AddmmGradNodeFinal : public egr::GradNodeBase {
 public:
  AddmmGradNodeFinal() : egr::GradNodeBase() {}
  AddmmGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AddmmGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AddmmGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AddmmGradNodeFinal>(new AddmmGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }
  void SetAttributebeta(const float& beta) {
    beta_ = beta;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  float alpha_;
  float beta_;
};


class ArgsortGradNodeFinal : public egr::GradNodeBase {
 public:
  ArgsortGradNodeFinal() : egr::GradNodeBase() {}
  ArgsortGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ArgsortGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ArgsortGradNodeFinal"; }

  void ClearTensorWrappers() override {
    indices_.clear();
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ArgsortGradNodeFinal>(new ArgsortGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperindices(const paddle::experimental::Tensor& indices) {
    indices_ = egr::TensorWrapper(indices, false);
  }
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributedescending(const bool& descending) {
    descending_ = descending;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper indices_;
  egr::TensorWrapper x_;

  // Attributes
  int axis_;
  bool descending_;
};


class AsinGradNodeFinal : public egr::GradNodeBase {
 public:
  AsinGradNodeFinal() : egr::GradNodeBase() {}
  AsinGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AsinGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AsinGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AsinGradNodeFinal>(new AsinGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AsinhGradNodeFinal : public egr::GradNodeBase {
 public:
  AsinhGradNodeFinal() : egr::GradNodeBase() {}
  AsinhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AsinhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AsinhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AsinhGradNodeFinal>(new AsinhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AssignGradNodeFinal : public egr::GradNodeBase {
 public:
  AssignGradNodeFinal() : egr::GradNodeBase() {}
  AssignGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AssignGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AssignGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AssignGradNodeFinal>(new AssignGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class AssignDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  AssignDoubleGradNodeFinal() : egr::GradNodeBase() {}
  AssignDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AssignDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AssignDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AssignDoubleGradNodeFinal>(new AssignDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class AssignTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  AssignTripleGradNodeFinal() : egr::GradNodeBase() {}
  AssignTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AssignTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AssignTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AssignTripleGradNodeFinal>(new AssignTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class AssignOutGradNodeFinal : public egr::GradNodeBase {
 public:
  AssignOutGradNodeFinal() : egr::GradNodeBase() {}
  AssignOutGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AssignOutGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AssignOutGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AssignOutGradNodeFinal>(new AssignOutGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class AtanGradNodeFinal : public egr::GradNodeBase {
 public:
  AtanGradNodeFinal() : egr::GradNodeBase() {}
  AtanGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AtanGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AtanGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AtanGradNodeFinal>(new AtanGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AtanhGradNodeFinal : public egr::GradNodeBase {
 public:
  AtanhGradNodeFinal() : egr::GradNodeBase() {}
  AtanhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AtanhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AtanhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AtanhGradNodeFinal>(new AtanhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class BatchNormGradNodeFinal : public egr::GradNodeBase {
 public:
  BatchNormGradNodeFinal() : egr::GradNodeBase() {}
  BatchNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~BatchNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "BatchNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    scale_.clear();
    bias_.clear();
    mean_out_.clear();
    variance_out_.clear();
    saved_mean_.clear();
    saved_variance_.clear();
    reserve_space_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<BatchNormGradNodeFinal>(new BatchNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperscale(const paddle::experimental::Tensor& scale) {
    scale_ = egr::TensorWrapper(scale, false);
  }
  void SetTensorWrapperbias(const paddle::experimental::Tensor& bias) {
    bias_ = egr::TensorWrapper(bias, false);
  }
  void SetTensorWrappermean_out(const paddle::experimental::Tensor& mean_out) {
    mean_out_ = egr::TensorWrapper(mean_out, false);
  }
  void SetTensorWrappervariance_out(const paddle::experimental::Tensor& variance_out) {
    variance_out_ = egr::TensorWrapper(variance_out, false);
  }
  void SetTensorWrappersaved_mean(const paddle::experimental::Tensor& saved_mean) {
    saved_mean_ = egr::TensorWrapper(saved_mean, false);
  }
  void SetTensorWrappersaved_variance(const paddle::experimental::Tensor& saved_variance) {
    saved_variance_ = egr::TensorWrapper(saved_variance, false);
  }
  void SetTensorWrapperreserve_space(const paddle::experimental::Tensor& reserve_space) {
    reserve_space_ = egr::TensorWrapper(reserve_space, false);
  }

  // SetAttributes
  void SetAttributemomentum(const float& momentum) {
    momentum_ = momentum;
  }
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributedata_layout(const std::string& data_layout) {
    data_layout_ = data_layout;
  }
  void SetAttributeis_test(const bool& is_test) {
    is_test_ = is_test;
  }
  void SetAttributeuse_global_stats(const bool& use_global_stats) {
    use_global_stats_ = use_global_stats;
  }
  void SetAttributetrainable_statistics(const bool& trainable_statistics) {
    trainable_statistics_ = trainable_statistics;
  }
  void SetAttributefuse_with_relu(const bool& fuse_with_relu) {
    fuse_with_relu_ = fuse_with_relu;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper scale_;
  egr::TensorWrapper bias_;
  egr::TensorWrapper mean_out_;
  egr::TensorWrapper variance_out_;
  egr::TensorWrapper saved_mean_;
  egr::TensorWrapper saved_variance_;
  egr::TensorWrapper reserve_space_;

  // Attributes
  float momentum_;
  float epsilon_;
  std::string data_layout_;
  bool is_test_;
  bool use_global_stats_;
  bool trainable_statistics_;
  bool fuse_with_relu_;
};


class BatchNormDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  BatchNormDoubleGradNodeFinal() : egr::GradNodeBase() {}
  BatchNormDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~BatchNormDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "BatchNormDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    scale_.clear();
    out_mean_.clear();
    out_variance_.clear();
    saved_mean_.clear();
    saved_variance_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<BatchNormDoubleGradNodeFinal>(new BatchNormDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperscale(const paddle::experimental::Tensor& scale) {
    scale_ = egr::TensorWrapper(scale, false);
  }
  void SetTensorWrapperout_mean(const paddle::experimental::Tensor& out_mean) {
    out_mean_ = egr::TensorWrapper(out_mean, false);
  }
  void SetTensorWrapperout_variance(const paddle::experimental::Tensor& out_variance) {
    out_variance_ = egr::TensorWrapper(out_variance, false);
  }
  void SetTensorWrappersaved_mean(const paddle::experimental::Tensor& saved_mean) {
    saved_mean_ = egr::TensorWrapper(saved_mean, false);
  }
  void SetTensorWrappersaved_variance(const paddle::experimental::Tensor& saved_variance) {
    saved_variance_ = egr::TensorWrapper(saved_variance, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributemomentum(const float& momentum) {
    momentum_ = momentum;
  }
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributedata_layout(const std::string& data_layout) {
    data_layout_ = data_layout;
  }
  void SetAttributeis_test(const bool& is_test) {
    is_test_ = is_test;
  }
  void SetAttributeuse_global_stats(const bool& use_global_stats) {
    use_global_stats_ = use_global_stats;
  }
  void SetAttributetrainable_statistics(const bool& trainable_statistics) {
    trainable_statistics_ = trainable_statistics;
  }
  void SetAttributefuse_with_relu(const bool& fuse_with_relu) {
    fuse_with_relu_ = fuse_with_relu;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper scale_;
  egr::TensorWrapper out_mean_;
  egr::TensorWrapper out_variance_;
  egr::TensorWrapper saved_mean_;
  egr::TensorWrapper saved_variance_;
  egr::TensorWrapper grad_out_;

  // Attributes
  float momentum_;
  float epsilon_;
  std::string data_layout_;
  bool is_test_;
  bool use_global_stats_;
  bool trainable_statistics_;
  bool fuse_with_relu_;
};


class BceLossGradNodeFinal : public egr::GradNodeBase {
 public:
  BceLossGradNodeFinal() : egr::GradNodeBase() {}
  BceLossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~BceLossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "BceLossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    label_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<BceLossGradNodeFinal>(new BceLossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper label_;

  // Attributes
};


class BreluGradNodeFinal : public egr::GradNodeBase {
 public:
  BreluGradNodeFinal() : egr::GradNodeBase() {}
  BreluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~BreluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "BreluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<BreluGradNodeFinal>(new BreluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributet_min(const float& t_min) {
    t_min_ = t_min;
  }
  void SetAttributet_max(const float& t_max) {
    t_max_ = t_max;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float t_min_;
  float t_max_;
};


class CastGradNodeFinal : public egr::GradNodeBase {
 public:
  CastGradNodeFinal() : egr::GradNodeBase() {}
  CastGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CastGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CastGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CastGradNodeFinal>(new CastGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class CeilGradNodeFinal : public egr::GradNodeBase {
 public:
  CeilGradNodeFinal() : egr::GradNodeBase() {}
  CeilGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CeilGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CeilGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CeilGradNodeFinal>(new CeilGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class CeluGradNodeFinal : public egr::GradNodeBase {
 public:
  CeluGradNodeFinal() : egr::GradNodeBase() {}
  CeluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CeluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CeluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CeluGradNodeFinal>(new CeluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float alpha_;
};


class CeluDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  CeluDoubleGradNodeFinal() : egr::GradNodeBase() {}
  CeluDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CeluDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CeluDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CeluDoubleGradNodeFinal>(new CeluDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper grad_out_;

  // Attributes
  float alpha_;
};


class ClipGradNodeFinal : public egr::GradNodeBase {
 public:
  ClipGradNodeFinal() : egr::GradNodeBase() {}
  ClipGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ClipGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ClipGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ClipGradNodeFinal>(new ClipGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributemin(const paddle::experimental::Scalar& min) {
    min_ = min;
  }
  void SetAttributemax(const paddle::experimental::Scalar& max) {
    max_ = max;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::Scalar min_ = 0.;
  paddle::experimental::Scalar max_ = 0.;
};


class ClipDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ClipDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ClipDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ClipDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ClipDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ClipDoubleGradNodeFinal>(new ClipDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributemin(const paddle::experimental::Scalar& min) {
    min_ = min;
  }
  void SetAttributemax(const paddle::experimental::Scalar& max) {
    max_ = max;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::Scalar min_ = 0.;
  paddle::experimental::Scalar max_ = 0.;
};


class ComplexGradNodeFinal : public egr::GradNodeBase {
 public:
  ComplexGradNodeFinal() : egr::GradNodeBase() {}
  ComplexGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ComplexGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ComplexGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ComplexGradNodeFinal>(new ComplexGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class ConcatGradNodeFinal : public egr::GradNodeBase {
 public:
  ConcatGradNodeFinal() : egr::GradNodeBase() {}
  ConcatGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ConcatGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ConcatGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : x_) {
      tw.clear();
    }

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ConcatGradNodeFinal>(new ConcatGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const std::vector<paddle::experimental::Tensor>& x) {
    for(const auto& eager_tensor : x) {
      x_.emplace_back(egr::TensorWrapper(eager_tensor, true));
    };
  }

  // SetAttributes
  void SetAttributeaxis(const paddle::experimental::Scalar& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> x_;

  // Attributes
  paddle::experimental::Scalar axis_ = 0;
};


class ConcatDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ConcatDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ConcatDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ConcatDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ConcatDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ConcatDoubleGradNodeFinal>(new ConcatDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const paddle::experimental::Scalar& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::Scalar axis_ = 0;
};


class ConjGradNodeFinal : public egr::GradNodeBase {
 public:
  ConjGradNodeFinal() : egr::GradNodeBase() {}
  ConjGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ConjGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ConjGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ConjGradNodeFinal>(new ConjGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class Conv2dTransposeGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv2dTransposeGradNodeFinal() : egr::GradNodeBase() {}
  Conv2dTransposeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv2dTransposeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv2dTransposeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    filter_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv2dTransposeGradNodeFinal>(new Conv2dTransposeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeoutput_padding(const std::vector<int>& output_padding) {
    output_padding_ = output_padding;
  }
  void SetAttributeoutput_size(const std::vector<int>& output_size) {
    output_size_ = output_size;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper filter_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> output_padding_;
  std::vector<int> output_size_;
  std::string padding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
};


class Conv2dTransposeDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv2dTransposeDoubleGradNodeFinal() : egr::GradNodeBase() {}
  Conv2dTransposeDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv2dTransposeDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv2dTransposeDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    filter_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv2dTransposeDoubleGradNodeFinal>(new Conv2dTransposeDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeoutput_padding(const std::vector<int>& output_padding) {
    output_padding_ = output_padding;
  }
  void SetAttributeoutput_size(const std::vector<int>& output_size) {
    output_size_ = output_size;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper filter_;
  egr::TensorWrapper grad_out_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> output_padding_;
  std::vector<int> output_size_;
  std::string padding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
};


class Conv3dGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv3dGradNodeFinal() : egr::GradNodeBase() {}
  Conv3dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv3dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv3dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    filter_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv3dGradNodeFinal>(new Conv3dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepaddding_algorithm(const std::string& paddding_algorithm) {
    paddding_algorithm_ = paddding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributeuse_addto(const bool& use_addto) {
    use_addto_ = use_addto;
  }
  void SetAttributeworkspace_size_MB(const int& workspace_size_MB) {
    workspace_size_MB_ = workspace_size_MB;
  }
  void SetAttributeexhaustive_search(const bool& exhaustive_search) {
    exhaustive_search_ = exhaustive_search;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper filter_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::string paddding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
  bool use_addto_;
  int workspace_size_MB_;
  bool exhaustive_search_;
};


class Conv3dGradGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv3dGradGradNodeFinal() : egr::GradNodeBase() {}
  Conv3dGradGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv3dGradGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv3dGradGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    filter_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv3dGradGradNodeFinal>(new Conv3dGradGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepaddding_algorithm(const std::string& paddding_algorithm) {
    paddding_algorithm_ = paddding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributeuse_addto(const bool& use_addto) {
    use_addto_ = use_addto;
  }
  void SetAttributeworkspace_size_MB(const int& workspace_size_MB) {
    workspace_size_MB_ = workspace_size_MB;
  }
  void SetAttributeexhaustive_search(const bool& exhaustive_search) {
    exhaustive_search_ = exhaustive_search;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper filter_;
  egr::TensorWrapper grad_out_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::string paddding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
  bool use_addto_;
  int workspace_size_MB_;
  bool exhaustive_search_;
};


class Conv3dTransposeGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv3dTransposeGradNodeFinal() : egr::GradNodeBase() {}
  Conv3dTransposeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv3dTransposeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv3dTransposeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    filter_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv3dTransposeGradNodeFinal>(new Conv3dTransposeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeoutput_padding(const std::vector<int>& output_padding) {
    output_padding_ = output_padding;
  }
  void SetAttributeoutput_size(const std::vector<int>& output_size) {
    output_size_ = output_size;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper filter_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> output_padding_;
  std::vector<int> output_size_;
  std::string padding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
};


class CosGradNodeFinal : public egr::GradNodeBase {
 public:
  CosGradNodeFinal() : egr::GradNodeBase() {}
  CosGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CosGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CosGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CosGradNodeFinal>(new CosGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class CoshGradNodeFinal : public egr::GradNodeBase {
 public:
  CoshGradNodeFinal() : egr::GradNodeBase() {}
  CoshGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CoshGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CoshGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CoshGradNodeFinal>(new CoshGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class CrossEntropyWithSoftmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  CrossEntropyWithSoftmaxGradNodeFinal() : egr::GradNodeBase() {}
  CrossEntropyWithSoftmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CrossEntropyWithSoftmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CrossEntropyWithSoftmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    label_.clear();
    softmax_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CrossEntropyWithSoftmaxGradNodeFinal>(new CrossEntropyWithSoftmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }
  void SetTensorWrappersoftmax(const paddle::experimental::Tensor& softmax) {
    softmax_ = egr::TensorWrapper(softmax, false);
  }

  // SetAttributes
  void SetAttributesoft_label(const bool& soft_label) {
    soft_label_ = soft_label;
  }
  void SetAttributeuse_softmax(const bool& use_softmax) {
    use_softmax_ = use_softmax;
  }
  void SetAttributenumeric_stable_mode(const bool& numeric_stable_mode) {
    numeric_stable_mode_ = numeric_stable_mode;
  }
  void SetAttributeignore_index(const int& ignore_index) {
    ignore_index_ = ignore_index;
  }
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper label_;
  egr::TensorWrapper softmax_;

  // Attributes
  bool soft_label_;
  bool use_softmax_;
  bool numeric_stable_mode_;
  int ignore_index_;
  int axis_;
};


class CumprodGradNodeFinal : public egr::GradNodeBase {
 public:
  CumprodGradNodeFinal() : egr::GradNodeBase() {}
  CumprodGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CumprodGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CumprodGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CumprodGradNodeFinal>(new CumprodGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributedim(const int& dim) {
    dim_ = dim;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  int dim_;
};


class CumsumGradNodeFinal : public egr::GradNodeBase {
 public:
  CumsumGradNodeFinal() : egr::GradNodeBase() {}
  CumsumGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CumsumGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CumsumGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CumsumGradNodeFinal>(new CumsumGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributeflatten(const bool& flatten) {
    flatten_ = flatten;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributereverse(const bool& reverse) {
    reverse_ = reverse;
  }

 private:
  // TensorWrappers

  // Attributes
  int axis_;
  bool flatten_;
  bool exclusive_;
  bool reverse_;
};


class DeformableConvGradNodeFinal : public egr::GradNodeBase {
 public:
  DeformableConvGradNodeFinal() : egr::GradNodeBase() {}
  DeformableConvGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DeformableConvGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DeformableConvGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    offset_.clear();
    filter_.clear();
    mask_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DeformableConvGradNodeFinal>(new DeformableConvGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperoffset(const paddle::experimental::Tensor& offset) {
    offset_ = egr::TensorWrapper(offset, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }
  void SetTensorWrappermask(const paddle::experimental::Tensor& mask) {
    mask_ = egr::TensorWrapper(mask, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedeformable_groups(const int& deformable_groups) {
    deformable_groups_ = deformable_groups;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributeim2col_step(const int& im2col_step) {
    im2col_step_ = im2col_step;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper offset_;
  egr::TensorWrapper filter_;
  egr::TensorWrapper mask_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> dilations_;
  int deformable_groups_;
  int groups_;
  int im2col_step_;
};


class DepthwiseConv2dGradNodeFinal : public egr::GradNodeBase {
 public:
  DepthwiseConv2dGradNodeFinal() : egr::GradNodeBase() {}
  DepthwiseConv2dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DepthwiseConv2dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DepthwiseConv2dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    filter_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DepthwiseConv2dGradNodeFinal>(new DepthwiseConv2dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepaddding_algorithm(const std::string& paddding_algorithm) {
    paddding_algorithm_ = paddding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributeuse_addto(const bool& use_addto) {
    use_addto_ = use_addto;
  }
  void SetAttributeworkspace_size_MB(const int& workspace_size_MB) {
    workspace_size_MB_ = workspace_size_MB;
  }
  void SetAttributeexhaustive_search(const bool& exhaustive_search) {
    exhaustive_search_ = exhaustive_search;
  }
  void SetAttributefuse_relu(const bool& fuse_relu) {
    fuse_relu_ = fuse_relu;
  }
  void SetAttributeuse_gpudnn(const bool& use_gpudnn) {
    use_gpudnn_ = use_gpudnn;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper filter_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::string paddding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
  bool use_addto_;
  int workspace_size_MB_;
  bool exhaustive_search_;
  bool fuse_relu_;
  bool use_gpudnn_;
};


class DepthwiseConv2dGradGradNodeFinal : public egr::GradNodeBase {
 public:
  DepthwiseConv2dGradGradNodeFinal() : egr::GradNodeBase() {}
  DepthwiseConv2dGradGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DepthwiseConv2dGradGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DepthwiseConv2dGradGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    filter_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DepthwiseConv2dGradGradNodeFinal>(new DepthwiseConv2dGradGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepaddding_algorithm(const std::string& paddding_algorithm) {
    paddding_algorithm_ = paddding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributeuse_addto(const bool& use_addto) {
    use_addto_ = use_addto;
  }
  void SetAttributeworkspace_size_MB(const int& workspace_size_MB) {
    workspace_size_MB_ = workspace_size_MB;
  }
  void SetAttributeexhaustive_search(const bool& exhaustive_search) {
    exhaustive_search_ = exhaustive_search;
  }
  void SetAttributefuse_relu(const bool& fuse_relu) {
    fuse_relu_ = fuse_relu;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper filter_;
  egr::TensorWrapper grad_out_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::string paddding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
  bool use_addto_;
  int workspace_size_MB_;
  bool exhaustive_search_;
  bool fuse_relu_;
};


class DepthwiseConv2dTransposeGradNodeFinal : public egr::GradNodeBase {
 public:
  DepthwiseConv2dTransposeGradNodeFinal() : egr::GradNodeBase() {}
  DepthwiseConv2dTransposeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DepthwiseConv2dTransposeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DepthwiseConv2dTransposeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    filter_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DepthwiseConv2dTransposeGradNodeFinal>(new DepthwiseConv2dTransposeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperfilter(const paddle::experimental::Tensor& filter) {
    filter_ = egr::TensorWrapper(filter, false);
  }

  // SetAttributes
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeoutput_padding(const std::vector<int>& output_padding) {
    output_padding_ = output_padding;
  }
  void SetAttributeoutput_size(const std::vector<int>& output_size) {
    output_size_ = output_size;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper filter_;

  // Attributes
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> output_padding_;
  std::vector<int> output_size_;
  std::string padding_algorithm_;
  int groups_;
  std::vector<int> dilations_;
  std::string data_format_;
};


class DetGradNodeFinal : public egr::GradNodeBase {
 public:
  DetGradNodeFinal() : egr::GradNodeBase() {}
  DetGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DetGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DetGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DetGradNodeFinal>(new DetGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
};


class DivideGradNodeFinal : public egr::GradNodeBase {
 public:
  DivideGradNodeFinal() : egr::GradNodeBase() {}
  DivideGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DivideGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DivideGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DivideGradNodeFinal>(new DivideGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;

  // Attributes
  int axis_ = -1;
};


class DivideDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  DivideDoubleGradNodeFinal() : egr::GradNodeBase() {}
  DivideDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DivideDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DivideDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    y_.clear();
    out_.clear();
    grad_x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DivideDoubleGradNodeFinal>(new DivideDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappergrad_x(const paddle::experimental::Tensor& grad_x) {
    grad_x_ = egr::TensorWrapper(grad_x, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;
  egr::TensorWrapper grad_x_;

  // Attributes
  int axis_ = -1;
};


class DropoutGradNodeFinal : public egr::GradNodeBase {
 public:
  DropoutGradNodeFinal() : egr::GradNodeBase() {}
  DropoutGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DropoutGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DropoutGradNodeFinal"; }

  void ClearTensorWrappers() override {
    mask_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DropoutGradNodeFinal>(new DropoutGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappermask(const paddle::experimental::Tensor& mask) {
    mask_ = egr::TensorWrapper(mask, false);
  }

  // SetAttributes
  void SetAttributep(const float& p) {
    p_ = p;
  }
  void SetAttributeis_test(const bool& is_test) {
    is_test_ = is_test;
  }
  void SetAttributemode(const std::string& mode) {
    mode_ = mode;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper mask_;

  // Attributes
  float p_;
  bool is_test_;
  std::string mode_;
};


class EighGradNodeFinal : public egr::GradNodeBase {
 public:
  EighGradNodeFinal() : egr::GradNodeBase() {}
  EighGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~EighGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "EighGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_w_.clear();
    out_v_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<EighGradNodeFinal>(new EighGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout_w(const paddle::experimental::Tensor& out_w) {
    out_w_ = egr::TensorWrapper(out_w, false);
  }
  void SetTensorWrapperout_v(const paddle::experimental::Tensor& out_v) {
    out_v_ = egr::TensorWrapper(out_v, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_w_;
  egr::TensorWrapper out_v_;

  // Attributes
};


class EinsumGradNodeFinal : public egr::GradNodeBase {
 public:
  EinsumGradNodeFinal() : egr::GradNodeBase() {}
  EinsumGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~EinsumGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "EinsumGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : x_shape_) {
      tw.clear();
    }
    for (auto& tw : inner_cache_) {
      tw.clear();
    }

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<EinsumGradNodeFinal>(new EinsumGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx_shape(const std::vector<paddle::experimental::Tensor>& x_shape) {
    for(const auto& eager_tensor : x_shape) {
      x_shape_.emplace_back(egr::TensorWrapper(eager_tensor, false));
    };
  }
  void SetTensorWrapperinner_cache(const std::vector<paddle::experimental::Tensor>& inner_cache) {
    for(const auto& eager_tensor : inner_cache) {
      inner_cache_.emplace_back(egr::TensorWrapper(eager_tensor, false));
    };
  }

  // SetAttributes
  void SetAttributeequation(const std::string& equation) {
    equation_ = equation;
  }

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> x_shape_;
  std::vector<egr::TensorWrapper> inner_cache_;

  // Attributes
  std::string equation_;
};


class ElementwisePowGradNodeFinal : public egr::GradNodeBase {
 public:
  ElementwisePowGradNodeFinal() : egr::GradNodeBase() {}
  ElementwisePowGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ElementwisePowGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ElementwisePowGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ElementwisePowGradNodeFinal>(new ElementwisePowGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class EluGradNodeFinal : public egr::GradNodeBase {
 public:
  EluGradNodeFinal() : egr::GradNodeBase() {}
  EluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~EluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "EluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<EluGradNodeFinal>(new EluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  float alpha_;
};


class EluDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  EluDoubleGradNodeFinal() : egr::GradNodeBase() {}
  EluDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~EluDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "EluDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<EluDoubleGradNodeFinal>(new EluDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper grad_out_;

  // Attributes
  float alpha_;
};


class EmbeddingGradNodeFinal : public egr::GradNodeBase {
 public:
  EmbeddingGradNodeFinal() : egr::GradNodeBase() {}
  EmbeddingGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~EmbeddingGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "EmbeddingGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    weight_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<EmbeddingGradNodeFinal>(new EmbeddingGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperweight(const paddle::experimental::Tensor& weight) {
    weight_ = egr::TensorWrapper(weight, false);
  }

  // SetAttributes
  void SetAttributepadding_idx(const int64_t& padding_idx) {
    padding_idx_ = padding_idx;
  }
  void SetAttributesparse(const bool& sparse) {
    sparse_ = sparse;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper weight_;

  // Attributes
  int64_t padding_idx_ = -1;
  bool sparse_ = false;
};


class ErfinvGradNodeFinal : public egr::GradNodeBase {
 public:
  ErfinvGradNodeFinal() : egr::GradNodeBase() {}
  ErfinvGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ErfinvGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ErfinvGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ErfinvGradNodeFinal>(new ErfinvGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ExpGradNodeFinal : public egr::GradNodeBase {
 public:
  ExpGradNodeFinal() : egr::GradNodeBase() {}
  ExpGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ExpGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ExpGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ExpGradNodeFinal>(new ExpGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ExpandGradNodeFinal : public egr::GradNodeBase {
 public:
  ExpandGradNodeFinal() : egr::GradNodeBase() {}
  ExpandGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ExpandGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ExpandGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ExpandGradNodeFinal>(new ExpandGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeshape(const paddle::experimental::IntArray& shape) {
    shape_ = shape;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::IntArray shape_;
};


class ExpandDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ExpandDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ExpandDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ExpandDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ExpandDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ExpandDoubleGradNodeFinal>(new ExpandDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeshape(const paddle::experimental::IntArray& shape) {
    shape_ = shape;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::IntArray shape_;
};


class ExpandAsGradNodeFinal : public egr::GradNodeBase {
 public:
  ExpandAsGradNodeFinal() : egr::GradNodeBase() {}
  ExpandAsGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ExpandAsGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ExpandAsGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ExpandAsGradNodeFinal>(new ExpandAsGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributetarget_shape(const std::vector<int>& target_shape) {
    target_shape_ = target_shape;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int> target_shape_;
};


class Expm1GradNodeFinal : public egr::GradNodeBase {
 public:
  Expm1GradNodeFinal() : egr::GradNodeBase() {}
  Expm1GradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Expm1GradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Expm1GradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Expm1GradNodeFinal>(new Expm1GradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class FlattenGradNodeFinal : public egr::GradNodeBase {
 public:
  FlattenGradNodeFinal() : egr::GradNodeBase() {}
  FlattenGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FlattenGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FlattenGradNodeFinal"; }

  void ClearTensorWrappers() override {
    xshape_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FlattenGradNodeFinal>(new FlattenGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperxshape(const paddle::experimental::Tensor& xshape) {
    xshape_ = egr::TensorWrapper(xshape, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper xshape_;

  // Attributes
};


class FlipGradNodeFinal : public egr::GradNodeBase {
 public:
  FlipGradNodeFinal() : egr::GradNodeBase() {}
  FlipGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FlipGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FlipGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FlipGradNodeFinal>(new FlipGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const std::vector<int>& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> axis_;
};


class FloorGradNodeFinal : public egr::GradNodeBase {
 public:
  FloorGradNodeFinal() : egr::GradNodeBase() {}
  FloorGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FloorGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FloorGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FloorGradNodeFinal>(new FloorGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class FmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  FmaxGradNodeFinal() : egr::GradNodeBase() {}
  FmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FmaxGradNodeFinal>(new FmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_;
};


class FminGradNodeFinal : public egr::GradNodeBase {
 public:
  FminGradNodeFinal() : egr::GradNodeBase() {}
  FminGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FminGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FminGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FminGradNodeFinal>(new FminGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_;
};


class FrobeniusNormGradNodeFinal : public egr::GradNodeBase {
 public:
  FrobeniusNormGradNodeFinal() : egr::GradNodeBase() {}
  FrobeniusNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FrobeniusNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FrobeniusNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FrobeniusNormGradNodeFinal>(new FrobeniusNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const std::vector<int64_t>& axis) {
    axis_ = axis;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int64_t> axis_;
  bool keep_dim_;
  bool reduce_all_;
};


class GatherGradNodeFinal : public egr::GradNodeBase {
 public:
  GatherGradNodeFinal() : egr::GradNodeBase() {}
  GatherGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GatherGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GatherGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GatherGradNodeFinal>(new GatherGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes
  void SetAttributeaxis(const paddle::experimental::Scalar& axis) {
    axis_ = axis;
  }
  void SetAttributeoverwrite(const bool& overwrite) {
    overwrite_ = overwrite;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
  paddle::experimental::Scalar axis_ = 0;
  bool overwrite_ = false;
};


class GatherNdGradNodeFinal : public egr::GradNodeBase {
 public:
  GatherNdGradNodeFinal() : egr::GradNodeBase() {}
  GatherNdGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GatherNdGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GatherNdGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GatherNdGradNodeFinal>(new GatherNdGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
};


class GeluGradNodeFinal : public egr::GradNodeBase {
 public:
  GeluGradNodeFinal() : egr::GradNodeBase() {}
  GeluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GeluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GeluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GeluGradNodeFinal>(new GeluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributeapproximate(const bool& approximate) {
    approximate_ = approximate;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  bool approximate_;
};


class GraphSendRecvGradNodeFinal : public egr::GradNodeBase {
 public:
  GraphSendRecvGradNodeFinal() : egr::GradNodeBase() {}
  GraphSendRecvGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GraphSendRecvGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GraphSendRecvGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    src_index_.clear();
    dst_index_.clear();
    out_.clear();
    dst_count_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GraphSendRecvGradNodeFinal>(new GraphSendRecvGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappersrc_index(const paddle::experimental::Tensor& src_index) {
    src_index_ = egr::TensorWrapper(src_index, false);
  }
  void SetTensorWrapperdst_index(const paddle::experimental::Tensor& dst_index) {
    dst_index_ = egr::TensorWrapper(dst_index, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrapperdst_count(const paddle::experimental::Tensor& dst_count) {
    dst_count_ = egr::TensorWrapper(dst_count, false);
  }

  // SetAttributes
  void SetAttributepool_type(const std::string& pool_type) {
    pool_type_ = pool_type;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper src_index_;
  egr::TensorWrapper dst_index_;
  egr::TensorWrapper out_;
  egr::TensorWrapper dst_count_;

  // Attributes
  std::string pool_type_ = "SUM";
};


class GroupNormGradNodeFinal : public egr::GradNodeBase {
 public:
  GroupNormGradNodeFinal() : egr::GradNodeBase() {}
  GroupNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GroupNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GroupNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    scale_.clear();
    bias_.clear();
    y_.clear();
    mean_.clear();
    variance_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GroupNormGradNodeFinal>(new GroupNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperscale(const paddle::experimental::Tensor& scale) {
    scale_ = egr::TensorWrapper(scale, false);
  }
  void SetTensorWrapperbias(const paddle::experimental::Tensor& bias) {
    bias_ = egr::TensorWrapper(bias, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrappermean(const paddle::experimental::Tensor& mean) {
    mean_ = egr::TensorWrapper(mean, false);
  }
  void SetTensorWrappervariance(const paddle::experimental::Tensor& variance) {
    variance_ = egr::TensorWrapper(variance, false);
  }

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributedata_layout(const std::string& data_layout) {
    data_layout_ = data_layout;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper scale_;
  egr::TensorWrapper bias_;
  egr::TensorWrapper y_;
  egr::TensorWrapper mean_;
  egr::TensorWrapper variance_;

  // Attributes
  float epsilon_;
  int groups_;
  std::string data_layout_;
};


class GumbelSoftmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  GumbelSoftmaxGradNodeFinal() : egr::GradNodeBase() {}
  GumbelSoftmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~GumbelSoftmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "GumbelSoftmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<GumbelSoftmaxGradNodeFinal>(new GumbelSoftmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  int axis_;
};


class HardShrinkGradNodeFinal : public egr::GradNodeBase {
 public:
  HardShrinkGradNodeFinal() : egr::GradNodeBase() {}
  HardShrinkGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~HardShrinkGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "HardShrinkGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<HardShrinkGradNodeFinal>(new HardShrinkGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributethreshold(const float& threshold) {
    threshold_ = threshold;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float threshold_;
};


class HardSigmoidGradNodeFinal : public egr::GradNodeBase {
 public:
  HardSigmoidGradNodeFinal() : egr::GradNodeBase() {}
  HardSigmoidGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~HardSigmoidGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "HardSigmoidGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<HardSigmoidGradNodeFinal>(new HardSigmoidGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeslope(const float& slope) {
    slope_ = slope;
  }
  void SetAttributeoffset(const float& offset) {
    offset_ = offset;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  float slope_;
  float offset_;
};


class HardSwishGradNodeFinal : public egr::GradNodeBase {
 public:
  HardSwishGradNodeFinal() : egr::GradNodeBase() {}
  HardSwishGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~HardSwishGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "HardSwishGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<HardSwishGradNodeFinal>(new HardSwishGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributethreshold(const float& threshold) {
    threshold_ = threshold;
  }
  void SetAttributescale(const float& scale) {
    scale_ = scale;
  }
  void SetAttributeoffset(const float& offset) {
    offset_ = offset;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float threshold_;
  float scale_;
  float offset_;
};


class HuberLossGradNodeFinal : public egr::GradNodeBase {
 public:
  HuberLossGradNodeFinal() : egr::GradNodeBase() {}
  HuberLossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~HuberLossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "HuberLossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    residual_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<HuberLossGradNodeFinal>(new HuberLossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperresidual(const paddle::experimental::Tensor& residual) {
    residual_ = egr::TensorWrapper(residual, false);
  }

  // SetAttributes
  void SetAttributedelta(const float& delta) {
    delta_ = delta;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper residual_;

  // Attributes
  float delta_;
};


class ImagGradNodeFinal : public egr::GradNodeBase {
 public:
  ImagGradNodeFinal() : egr::GradNodeBase() {}
  ImagGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ImagGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ImagGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ImagGradNodeFinal>(new ImagGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class IndexSampleGradNodeFinal : public egr::GradNodeBase {
 public:
  IndexSampleGradNodeFinal() : egr::GradNodeBase() {}
  IndexSampleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~IndexSampleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "IndexSampleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<IndexSampleGradNodeFinal>(new IndexSampleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
};


class IndexSelectGradNodeFinal : public egr::GradNodeBase {
 public:
  IndexSelectGradNodeFinal() : egr::GradNodeBase() {}
  IndexSelectGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~IndexSelectGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "IndexSelectGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<IndexSelectGradNodeFinal>(new IndexSelectGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes
  void SetAttributedim(const int& dim) {
    dim_ = dim;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
  int dim_;
};


class InstanceNormGradNodeFinal : public egr::GradNodeBase {
 public:
  InstanceNormGradNodeFinal() : egr::GradNodeBase() {}
  InstanceNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~InstanceNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "InstanceNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    scale_.clear();
    saved_mean_.clear();
    saved_variance_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<InstanceNormGradNodeFinal>(new InstanceNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperscale(const paddle::experimental::Tensor& scale) {
    scale_ = egr::TensorWrapper(scale, false);
  }
  void SetTensorWrappersaved_mean(const paddle::experimental::Tensor& saved_mean) {
    saved_mean_ = egr::TensorWrapper(saved_mean, false);
  }
  void SetTensorWrappersaved_variance(const paddle::experimental::Tensor& saved_variance) {
    saved_variance_ = egr::TensorWrapper(saved_variance, false);
  }

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper scale_;
  egr::TensorWrapper saved_mean_;
  egr::TensorWrapper saved_variance_;

  // Attributes
  float epsilon_;
};


class InstanceNormDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  InstanceNormDoubleGradNodeFinal() : egr::GradNodeBase() {}
  InstanceNormDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~InstanceNormDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "InstanceNormDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    fwd_scale_.clear();
    saved_mean_.clear();
    saved_variance_.clear();
    grad_y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<InstanceNormDoubleGradNodeFinal>(new InstanceNormDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperfwd_scale(const paddle::experimental::Tensor& fwd_scale) {
    fwd_scale_ = egr::TensorWrapper(fwd_scale, false);
  }
  void SetTensorWrappersaved_mean(const paddle::experimental::Tensor& saved_mean) {
    saved_mean_ = egr::TensorWrapper(saved_mean, false);
  }
  void SetTensorWrappersaved_variance(const paddle::experimental::Tensor& saved_variance) {
    saved_variance_ = egr::TensorWrapper(saved_variance, false);
  }
  void SetTensorWrappergrad_y(const paddle::experimental::Tensor& grad_y) {
    grad_y_ = egr::TensorWrapper(grad_y, false);
  }

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper fwd_scale_;
  egr::TensorWrapper saved_mean_;
  egr::TensorWrapper saved_variance_;
  egr::TensorWrapper grad_y_;

  // Attributes
  float epsilon_;
};


class KldivLossGradNodeFinal : public egr::GradNodeBase {
 public:
  KldivLossGradNodeFinal() : egr::GradNodeBase() {}
  KldivLossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~KldivLossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "KldivLossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    label_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<KldivLossGradNodeFinal>(new KldivLossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }

  // SetAttributes
  void SetAttributereduction(const std::string& reduction) {
    reduction_ = reduction;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper label_;

  // Attributes
  std::string reduction_;
};


class KronGradNodeFinal : public egr::GradNodeBase {
 public:
  KronGradNodeFinal() : egr::GradNodeBase() {}
  KronGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~KronGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "KronGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<KronGradNodeFinal>(new KronGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class KthvalueGradNodeFinal : public egr::GradNodeBase {
 public:
  KthvalueGradNodeFinal() : egr::GradNodeBase() {}
  KthvalueGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~KthvalueGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "KthvalueGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    indices_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<KthvalueGradNodeFinal>(new KthvalueGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperindices(const paddle::experimental::Tensor& indices) {
    indices_ = egr::TensorWrapper(indices, false);
  }

  // SetAttributes
  void SetAttributek(const int& k) {
    k_ = k;
  }
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributekeepdim(const bool& keepdim) {
    keepdim_ = keepdim;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper indices_;

  // Attributes
  int k_;
  int axis_;
  bool keepdim_;
};


class LabelSmoothGradNodeFinal : public egr::GradNodeBase {
 public:
  LabelSmoothGradNodeFinal() : egr::GradNodeBase() {}
  LabelSmoothGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LabelSmoothGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LabelSmoothGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LabelSmoothGradNodeFinal>(new LabelSmoothGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }

 private:
  // TensorWrappers

  // Attributes
  float epsilon_;
};


class LayerNormGradNodeFinal : public egr::GradNodeBase {
 public:
  LayerNormGradNodeFinal() : egr::GradNodeBase() {}
  LayerNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LayerNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LayerNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    scale_.clear();
    bias_.clear();
    mean_.clear();
    variance_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LayerNormGradNodeFinal>(new LayerNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperscale(const paddle::experimental::Tensor& scale) {
    scale_ = egr::TensorWrapper(scale, false);
  }
  void SetTensorWrapperbias(const paddle::experimental::Tensor& bias) {
    bias_ = egr::TensorWrapper(bias, true);
  }
  void SetTensorWrappermean(const paddle::experimental::Tensor& mean) {
    mean_ = egr::TensorWrapper(mean, false);
  }
  void SetTensorWrappervariance(const paddle::experimental::Tensor& variance) {
    variance_ = egr::TensorWrapper(variance, false);
  }

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributebegin_norm_axis(const int& begin_norm_axis) {
    begin_norm_axis_ = begin_norm_axis;
  }
  void SetAttributeis_test(const bool& is_test) {
    is_test_ = is_test;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper scale_;
  egr::TensorWrapper bias_;
  egr::TensorWrapper mean_;
  egr::TensorWrapper variance_;

  // Attributes
  float epsilon_;
  int begin_norm_axis_;
  bool is_test_;
};


class LeakyReluGradNodeFinal : public egr::GradNodeBase {
 public:
  LeakyReluGradNodeFinal() : egr::GradNodeBase() {}
  LeakyReluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LeakyReluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LeakyReluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LeakyReluGradNodeFinal>(new LeakyReluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float alpha_;
};


class LeakyReluDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  LeakyReluDoubleGradNodeFinal() : egr::GradNodeBase() {}
  LeakyReluDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LeakyReluDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LeakyReluDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LeakyReluDoubleGradNodeFinal>(new LeakyReluDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float alpha_;
};


class LerpGradNodeFinal : public egr::GradNodeBase {
 public:
  LerpGradNodeFinal() : egr::GradNodeBase() {}
  LerpGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LerpGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LerpGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    weight_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LerpGradNodeFinal>(new LerpGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperweight(const paddle::experimental::Tensor& weight) {
    weight_ = egr::TensorWrapper(weight, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper weight_;
  egr::TensorWrapper out_;

  // Attributes
};


class LgammaGradNodeFinal : public egr::GradNodeBase {
 public:
  LgammaGradNodeFinal() : egr::GradNodeBase() {}
  LgammaGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LgammaGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LgammaGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LgammaGradNodeFinal>(new LgammaGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class LogGradNodeFinal : public egr::GradNodeBase {
 public:
  LogGradNodeFinal() : egr::GradNodeBase() {}
  LogGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogGradNodeFinal>(new LogGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class LogDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  LogDoubleGradNodeFinal() : egr::GradNodeBase() {}
  LogDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogDoubleGradNodeFinal>(new LogDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper grad_out_;

  // Attributes
};


class Log10GradNodeFinal : public egr::GradNodeBase {
 public:
  Log10GradNodeFinal() : egr::GradNodeBase() {}
  Log10GradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Log10GradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Log10GradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Log10GradNodeFinal>(new Log10GradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class Log1pGradNodeFinal : public egr::GradNodeBase {
 public:
  Log1pGradNodeFinal() : egr::GradNodeBase() {}
  Log1pGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Log1pGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Log1pGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Log1pGradNodeFinal>(new Log1pGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class Log2GradNodeFinal : public egr::GradNodeBase {
 public:
  Log2GradNodeFinal() : egr::GradNodeBase() {}
  Log2GradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Log2GradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Log2GradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Log2GradNodeFinal>(new Log2GradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class LogLossGradNodeFinal : public egr::GradNodeBase {
 public:
  LogLossGradNodeFinal() : egr::GradNodeBase() {}
  LogLossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogLossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogLossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    label_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogLossGradNodeFinal>(new LogLossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }

  // SetAttributes
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper label_;

  // Attributes
  float epsilon_;
};


class LogSoftmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  LogSoftmaxGradNodeFinal() : egr::GradNodeBase() {}
  LogSoftmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogSoftmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogSoftmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogSoftmaxGradNodeFinal>(new LogSoftmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  int axis_;
};


class LogcumsumexpGradNodeFinal : public egr::GradNodeBase {
 public:
  LogcumsumexpGradNodeFinal() : egr::GradNodeBase() {}
  LogcumsumexpGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogcumsumexpGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogcumsumexpGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogcumsumexpGradNodeFinal>(new LogcumsumexpGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributeflatten(const bool& flatten) {
    flatten_ = flatten;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributereverse(const bool& reverse) {
    reverse_ = reverse;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  int axis_;
  bool flatten_;
  bool exclusive_;
  bool reverse_;
};


class LogitGradNodeFinal : public egr::GradNodeBase {
 public:
  LogitGradNodeFinal() : egr::GradNodeBase() {}
  LogitGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogitGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogitGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogitGradNodeFinal>(new LogitGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributeeps(const float& eps) {
    eps_ = eps;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float eps_;
};


class LogsigmoidGradNodeFinal : public egr::GradNodeBase {
 public:
  LogsigmoidGradNodeFinal() : egr::GradNodeBase() {}
  LogsigmoidGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogsigmoidGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogsigmoidGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogsigmoidGradNodeFinal>(new LogsigmoidGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class LogsumexpGradNodeFinal : public egr::GradNodeBase {
 public:
  LogsumexpGradNodeFinal() : egr::GradNodeBase() {}
  LogsumexpGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~LogsumexpGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "LogsumexpGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<LogsumexpGradNodeFinal>(new LogsumexpGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const std::vector<int64_t>& axis) {
    axis_ = axis;
  }
  void SetAttributekeepdim(const bool& keepdim) {
    keepdim_ = keepdim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int64_t> axis_;
  bool keepdim_;
  bool reduce_all_;
};


class MaskedSelectGradNodeFinal : public egr::GradNodeBase {
 public:
  MaskedSelectGradNodeFinal() : egr::GradNodeBase() {}
  MaskedSelectGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaskedSelectGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaskedSelectGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    mask_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaskedSelectGradNodeFinal>(new MaskedSelectGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrappermask(const paddle::experimental::Tensor& mask) {
    mask_ = egr::TensorWrapper(mask, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper mask_;

  // Attributes
};


class MatmulGradNodeFinal : public egr::GradNodeBase {
 public:
  MatmulGradNodeFinal() : egr::GradNodeBase() {}
  MatmulGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MatmulGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MatmulGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MatmulGradNodeFinal>(new MatmulGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributetranspose_x(const bool& transpose_x) {
    transpose_x_ = transpose_x;
  }
  void SetAttributetranspose_y(const bool& transpose_y) {
    transpose_y_ = transpose_y;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  bool transpose_x_ = false;
  bool transpose_y_ = false;
};


class MatmulDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  MatmulDoubleGradNodeFinal() : egr::GradNodeBase() {}
  MatmulDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MatmulDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MatmulDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MatmulDoubleGradNodeFinal>(new MatmulDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributetranspose_x(const bool& transpose_x) {
    transpose_x_ = transpose_x;
  }
  void SetAttributetranspose_y(const bool& transpose_y) {
    transpose_y_ = transpose_y;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper grad_out_;

  // Attributes
  bool transpose_x_ = false;
  bool transpose_y_ = false;
};


class MatmulTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  MatmulTripleGradNodeFinal() : egr::GradNodeBase() {}
  MatmulTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MatmulTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MatmulTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    fwd_grad_out_.clear();
    fwd_grad_grad_x_.clear();
    fwd_grad_grad_y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MatmulTripleGradNodeFinal>(new MatmulTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperfwd_grad_out(const paddle::experimental::Tensor& fwd_grad_out) {
    fwd_grad_out_ = egr::TensorWrapper(fwd_grad_out, false);
  }
  void SetTensorWrapperfwd_grad_grad_x(const paddle::experimental::Tensor& fwd_grad_grad_x) {
    fwd_grad_grad_x_ = egr::TensorWrapper(fwd_grad_grad_x, false);
  }
  void SetTensorWrapperfwd_grad_grad_y(const paddle::experimental::Tensor& fwd_grad_grad_y) {
    fwd_grad_grad_y_ = egr::TensorWrapper(fwd_grad_grad_y, false);
  }

  // SetAttributes
  void SetAttributetranspose_x(const bool& transpose_x) {
    transpose_x_ = transpose_x;
  }
  void SetAttributetranspose_y(const bool& transpose_y) {
    transpose_y_ = transpose_y;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper fwd_grad_out_;
  egr::TensorWrapper fwd_grad_grad_x_;
  egr::TensorWrapper fwd_grad_grad_y_;

  // Attributes
  bool transpose_x_ = false;
  bool transpose_y_ = false;
};


class MatrixPowerGradNodeFinal : public egr::GradNodeBase {
 public:
  MatrixPowerGradNodeFinal() : egr::GradNodeBase() {}
  MatrixPowerGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MatrixPowerGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MatrixPowerGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MatrixPowerGradNodeFinal>(new MatrixPowerGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributen(const int& n) {
    n_ = n;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  int n_;
};


class MaxGradNodeFinal : public egr::GradNodeBase {
 public:
  MaxGradNodeFinal() : egr::GradNodeBase() {}
  MaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaxGradNodeFinal>(new MaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
  bool reduce_all_ = false;
};


class MaxPool2dWithIndexGradNodeFinal : public egr::GradNodeBase {
 public:
  MaxPool2dWithIndexGradNodeFinal() : egr::GradNodeBase() {}
  MaxPool2dWithIndexGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaxPool2dWithIndexGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaxPool2dWithIndexGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    mask_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaxPool2dWithIndexGradNodeFinal>(new MaxPool2dWithIndexGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappermask(const paddle::experimental::Tensor& mask) {
    mask_ = egr::TensorWrapper(mask, false);
  }

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper mask_;

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool global_pooling_;
  bool adaptive_;
};


class MaxPool3dWithIndexGradNodeFinal : public egr::GradNodeBase {
 public:
  MaxPool3dWithIndexGradNodeFinal() : egr::GradNodeBase() {}
  MaxPool3dWithIndexGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaxPool3dWithIndexGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaxPool3dWithIndexGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    mask_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaxPool3dWithIndexGradNodeFinal>(new MaxPool3dWithIndexGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappermask(const paddle::experimental::Tensor& mask) {
    mask_ = egr::TensorWrapper(mask, false);
  }

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper mask_;

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool global_pooling_;
  bool adaptive_;
};


class MaximumGradNodeFinal : public egr::GradNodeBase {
 public:
  MaximumGradNodeFinal() : egr::GradNodeBase() {}
  MaximumGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaximumGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaximumGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaximumGradNodeFinal>(new MaximumGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class MaxoutGradNodeFinal : public egr::GradNodeBase {
 public:
  MaxoutGradNodeFinal() : egr::GradNodeBase() {}
  MaxoutGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaxoutGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaxoutGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaxoutGradNodeFinal>(new MaxoutGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  int groups_;
  int axis_;
};


class MeanGradNodeFinal : public egr::GradNodeBase {
 public:
  MeanGradNodeFinal() : egr::GradNodeBase() {}
  MeanGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MeanGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MeanGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MeanGradNodeFinal>(new MeanGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
  bool reduce_all_ = false;
};


class MeanDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  MeanDoubleGradNodeFinal() : egr::GradNodeBase() {}
  MeanDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MeanDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MeanDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MeanDoubleGradNodeFinal>(new MeanDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
  bool reduce_all_ = false;
};


class MeanAllGradNodeFinal : public egr::GradNodeBase {
 public:
  MeanAllGradNodeFinal() : egr::GradNodeBase() {}
  MeanAllGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MeanAllGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MeanAllGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MeanAllGradNodeFinal>(new MeanAllGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class MeshgridGradNodeFinal : public egr::GradNodeBase {
 public:
  MeshgridGradNodeFinal() : egr::GradNodeBase() {}
  MeshgridGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MeshgridGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MeshgridGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : inputs_) {
      tw.clear();
    }

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MeshgridGradNodeFinal>(new MeshgridGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinputs(const std::vector<paddle::experimental::Tensor>& inputs) {
    for(const auto& eager_tensor : inputs) {
      inputs_.emplace_back(egr::TensorWrapper(eager_tensor, false));
    };
  }

  // SetAttributes

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> inputs_;

  // Attributes
};


class MinGradNodeFinal : public egr::GradNodeBase {
 public:
  MinGradNodeFinal() : egr::GradNodeBase() {}
  MinGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MinGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MinGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MinGradNodeFinal>(new MinGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
  bool reduce_all_ = false;
};


class MinimumGradNodeFinal : public egr::GradNodeBase {
 public:
  MinimumGradNodeFinal() : egr::GradNodeBase() {}
  MinimumGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MinimumGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MinimumGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MinimumGradNodeFinal>(new MinimumGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class MishGradNodeFinal : public egr::GradNodeBase {
 public:
  MishGradNodeFinal() : egr::GradNodeBase() {}
  MishGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MishGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MishGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MishGradNodeFinal>(new MishGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributethreshold(const float& threshold) {
    threshold_ = threshold;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float threshold_;
};


class ModeGradNodeFinal : public egr::GradNodeBase {
 public:
  ModeGradNodeFinal() : egr::GradNodeBase() {}
  ModeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ModeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ModeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    indices_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ModeGradNodeFinal>(new ModeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperindices(const paddle::experimental::Tensor& indices) {
    indices_ = egr::TensorWrapper(indices, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributekeepdim(const bool& keepdim) {
    keepdim_ = keepdim;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper indices_;

  // Attributes
  int axis_;
  bool keepdim_;
};


class ModuloGradNodeFinal : public egr::GradNodeBase {
 public:
  ModuloGradNodeFinal() : egr::GradNodeBase() {}
  ModuloGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ModuloGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ModuloGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ModuloGradNodeFinal>(new ModuloGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, true);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class MultiDotGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiDotGradNodeFinal() : egr::GradNodeBase() {}
  MultiDotGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiDotGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiDotGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : x_) {
      tw.clear();
    }

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiDotGradNodeFinal>(new MultiDotGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const std::vector<paddle::experimental::Tensor>& x) {
    for(const auto& eager_tensor : x) {
      x_.emplace_back(egr::TensorWrapper(eager_tensor, false));
    };
  }

  // SetAttributes

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> x_;

  // Attributes
};


class MultiplexGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiplexGradNodeFinal() : egr::GradNodeBase() {}
  MultiplexGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiplexGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiplexGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : ins_) {
      tw.clear();
    }
    ids_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiplexGradNodeFinal>(new MultiplexGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperins(const std::vector<paddle::experimental::Tensor>& ins) {
    for(const auto& eager_tensor : ins) {
      ins_.emplace_back(egr::TensorWrapper(eager_tensor, false));
    };
  }
  void SetTensorWrapperids(const paddle::experimental::Tensor& ids) {
    ids_ = egr::TensorWrapper(ids, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> ins_;
  egr::TensorWrapper ids_;

  // Attributes
};


class MultiplyGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiplyGradNodeFinal() : egr::GradNodeBase() {}
  MultiplyGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiplyGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiplyGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiplyGradNodeFinal>(new MultiplyGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class MultiplyDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiplyDoubleGradNodeFinal() : egr::GradNodeBase() {}
  MultiplyDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiplyDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiplyDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiplyDoubleGradNodeFinal>(new MultiplyDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper grad_out_;

  // Attributes
  int axis_ = -1;
};


class MultiplyTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiplyTripleGradNodeFinal() : egr::GradNodeBase() {}
  MultiplyTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiplyTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiplyTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    fwd_grad_out_.clear();
    fwd_grad_grad_x_.clear();
    fwd_grad_grad_y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiplyTripleGradNodeFinal>(new MultiplyTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperfwd_grad_out(const paddle::experimental::Tensor& fwd_grad_out) {
    fwd_grad_out_ = egr::TensorWrapper(fwd_grad_out, false);
  }
  void SetTensorWrapperfwd_grad_grad_x(const paddle::experimental::Tensor& fwd_grad_grad_x) {
    fwd_grad_grad_x_ = egr::TensorWrapper(fwd_grad_grad_x, false);
  }
  void SetTensorWrapperfwd_grad_grad_y(const paddle::experimental::Tensor& fwd_grad_grad_y) {
    fwd_grad_grad_y_ = egr::TensorWrapper(fwd_grad_grad_y, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper fwd_grad_out_;
  egr::TensorWrapper fwd_grad_grad_x_;
  egr::TensorWrapper fwd_grad_grad_y_;

  // Attributes
  int axis_ = -1;
};


class NllLossGradNodeFinal : public egr::GradNodeBase {
 public:
  NllLossGradNodeFinal() : egr::GradNodeBase() {}
  NllLossGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~NllLossGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "NllLossGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();
    label_.clear();
    weight_.clear();
    total_weight_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<NllLossGradNodeFinal>(new NllLossGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, false);
  }
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }
  void SetTensorWrapperweight(const paddle::experimental::Tensor& weight) {
    weight_ = egr::TensorWrapper(weight, false);
  }
  void SetTensorWrappertotal_weight(const paddle::experimental::Tensor& total_weight) {
    total_weight_ = egr::TensorWrapper(total_weight, false);
  }

  // SetAttributes
  void SetAttributeignore_index(const int64_t& ignore_index) {
    ignore_index_ = ignore_index;
  }
  void SetAttributereduction(const std::string& reduction) {
    reduction_ = reduction;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;
  egr::TensorWrapper label_;
  egr::TensorWrapper weight_;
  egr::TensorWrapper total_weight_;

  // Attributes
  int64_t ignore_index_;
  std::string reduction_;
};


class NormGradNodeFinal : public egr::GradNodeBase {
 public:
  NormGradNodeFinal() : egr::GradNodeBase() {}
  NormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~NormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "NormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    norm_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<NormGradNodeFinal>(new NormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappernorm(const paddle::experimental::Tensor& norm) {
    norm_ = egr::TensorWrapper(norm, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributeis_test(const bool& is_test) {
    is_test_ = is_test;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper norm_;

  // Attributes
  int axis_;
  float epsilon_;
  bool is_test_;
};


class PNormGradNodeFinal : public egr::GradNodeBase {
 public:
  PNormGradNodeFinal() : egr::GradNodeBase() {}
  PNormGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PNormGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PNormGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PNormGradNodeFinal>(new PNormGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeporder(const float& porder) {
    porder_ = porder;
  }
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributeepsilon(const float& epsilon) {
    epsilon_ = epsilon;
  }
  void SetAttributekeepdim(const bool& keepdim) {
    keepdim_ = keepdim;
  }
  void SetAttributeasvector(const bool& asvector) {
    asvector_ = asvector;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  float porder_;
  int axis_;
  float epsilon_;
  bool keepdim_;
  bool asvector_;
};


class PadGradNodeFinal : public egr::GradNodeBase {
 public:
  PadGradNodeFinal() : egr::GradNodeBase() {}
  PadGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PadGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PadGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PadGradNodeFinal>(new PadGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepad_value(const float& pad_value) {
    pad_value_ = pad_value;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int> paddings_;
  float pad_value_;
};


class PadDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  PadDoubleGradNodeFinal() : egr::GradNodeBase() {}
  PadDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PadDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PadDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PadDoubleGradNodeFinal>(new PadDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributepad_value(const float& pad_value) {
    pad_value_ = pad_value;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> paddings_;
  float pad_value_;
};


class Pad3dGradNodeFinal : public egr::GradNodeBase {
 public:
  Pad3dGradNodeFinal() : egr::GradNodeBase() {}
  Pad3dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pad3dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pad3dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pad3dGradNodeFinal>(new Pad3dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributepaddings(const paddle::experimental::IntArray& paddings) {
    paddings_ = paddings;
  }
  void SetAttributemode(const std::string& mode) {
    mode_ = mode;
  }
  void SetAttributepad_value(const float& pad_value) {
    pad_value_ = pad_value;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::IntArray paddings_;
  std::string mode_;
  float pad_value_;
  std::string data_format_;
};


class Pad3dDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  Pad3dDoubleGradNodeFinal() : egr::GradNodeBase() {}
  Pad3dDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pad3dDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pad3dDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pad3dDoubleGradNodeFinal>(new Pad3dDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributepaddings(const paddle::experimental::IntArray& paddings) {
    paddings_ = paddings;
  }
  void SetAttributemode(const std::string& mode) {
    mode_ = mode;
  }
  void SetAttributepad_value(const float& pad_value) {
    pad_value_ = pad_value;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::IntArray paddings_;
  std::string mode_;
  float pad_value_;
  std::string data_format_;
};


class PixelShuffleGradNodeFinal : public egr::GradNodeBase {
 public:
  PixelShuffleGradNodeFinal() : egr::GradNodeBase() {}
  PixelShuffleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PixelShuffleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PixelShuffleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PixelShuffleGradNodeFinal>(new PixelShuffleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeupscale_factor(const int& upscale_factor) {
    upscale_factor_ = upscale_factor;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }

 private:
  // TensorWrappers

  // Attributes
  int upscale_factor_;
  std::string data_format_;
};


class Pool2dGradNodeFinal : public egr::GradNodeBase {
 public:
  Pool2dGradNodeFinal() : egr::GradNodeBase() {}
  Pool2dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pool2dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pool2dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pool2dGradNodeFinal>(new Pool2dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeceil_mode(const bool& ceil_mode) {
    ceil_mode_ = ceil_mode;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributepooling_type(const std::string& pooling_type) {
    pooling_type_ = pooling_type;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool ceil_mode_;
  bool exclusive_;
  std::string data_format_;
  std::string pooling_type_;
  bool global_pooling_;
  bool adaptive_;
  std::string padding_algorithm_;
};


class Pool2dDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  Pool2dDoubleGradNodeFinal() : egr::GradNodeBase() {}
  Pool2dDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pool2dDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pool2dDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pool2dDoubleGradNodeFinal>(new Pool2dDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeceil_mode(const bool& ceil_mode) {
    ceil_mode_ = ceil_mode;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributepooling_type(const std::string& pooling_type) {
    pooling_type_ = pooling_type;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool ceil_mode_;
  bool exclusive_;
  std::string data_format_;
  std::string pooling_type_;
  bool global_pooling_;
  bool adaptive_;
  std::string padding_algorithm_;
};


class Pool2dGradGpudnnUnusedGradNodeFinal : public egr::GradNodeBase {
 public:
  Pool2dGradGpudnnUnusedGradNodeFinal() : egr::GradNodeBase() {}
  Pool2dGradGpudnnUnusedGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pool2dGradGpudnnUnusedGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pool2dGradGpudnnUnusedGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pool2dGradGpudnnUnusedGradNodeFinal>(new Pool2dGradGpudnnUnusedGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeceil_mode(const bool& ceil_mode) {
    ceil_mode_ = ceil_mode;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributepooling_type(const std::string& pooling_type) {
    pooling_type_ = pooling_type;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool ceil_mode_;
  bool exclusive_;
  std::string data_format_;
  std::string pooling_type_;
  bool global_pooling_;
  bool adaptive_;
  std::string padding_algorithm_;
};


class Pool3dGradNodeFinal : public egr::GradNodeBase {
 public:
  Pool3dGradNodeFinal() : egr::GradNodeBase() {}
  Pool3dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Pool3dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Pool3dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Pool3dGradNodeFinal>(new Pool3dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributekernel_size(const std::vector<int>& kernel_size) {
    kernel_size_ = kernel_size;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributeceil_mode(const bool& ceil_mode) {
    ceil_mode_ = ceil_mode;
  }
  void SetAttributeexclusive(const bool& exclusive) {
    exclusive_ = exclusive;
  }
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributepooling_type(const std::string& pooling_type) {
    pooling_type_ = pooling_type;
  }
  void SetAttributeglobal_pooling(const bool& global_pooling) {
    global_pooling_ = global_pooling;
  }
  void SetAttributeadaptive(const bool& adaptive) {
    adaptive_ = adaptive;
  }
  void SetAttributepadding_algorithm(const std::string& padding_algorithm) {
    padding_algorithm_ = padding_algorithm;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int> kernel_size_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  bool ceil_mode_;
  bool exclusive_;
  std::string data_format_;
  std::string pooling_type_;
  bool global_pooling_;
  bool adaptive_;
  std::string padding_algorithm_;
};


class PowGradNodeFinal : public egr::GradNodeBase {
 public:
  PowGradNodeFinal() : egr::GradNodeBase() {}
  PowGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PowGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PowGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PowGradNodeFinal>(new PowGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributes(const paddle::experimental::Scalar& s) {
    s_ = s;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::Scalar s_ = -1;
};


class PreluGradNodeFinal : public egr::GradNodeBase {
 public:
  PreluGradNodeFinal() : egr::GradNodeBase() {}
  PreluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PreluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PreluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    alpha_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PreluGradNodeFinal>(new PreluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperalpha(const paddle::experimental::Tensor& alpha) {
    alpha_ = egr::TensorWrapper(alpha, false);
  }

  // SetAttributes
  void SetAttributedata_format(const std::string& data_format) {
    data_format_ = data_format;
  }
  void SetAttributemode(const std::string& mode) {
    mode_ = mode;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper alpha_;

  // Attributes
  std::string data_format_;
  std::string mode_;
};


class PsroiPoolGradNodeFinal : public egr::GradNodeBase {
 public:
  PsroiPoolGradNodeFinal() : egr::GradNodeBase() {}
  PsroiPoolGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PsroiPoolGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PsroiPoolGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    boxes_.clear();
    boxes_num_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PsroiPoolGradNodeFinal>(new PsroiPoolGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperboxes(const paddle::experimental::Tensor& boxes) {
    boxes_ = egr::TensorWrapper(boxes, false);
  }
  void SetTensorWrapperboxes_num(const paddle::experimental::Tensor& boxes_num) {
    boxes_num_ = egr::TensorWrapper(boxes_num, false);
  }

  // SetAttributes
  void SetAttributepooled_height(const int& pooled_height) {
    pooled_height_ = pooled_height;
  }
  void SetAttributepooled_width(const int& pooled_width) {
    pooled_width_ = pooled_width;
  }
  void SetAttributeoutput_channels(const int& output_channels) {
    output_channels_ = output_channels;
  }
  void SetAttributespatial_scale(const float& spatial_scale) {
    spatial_scale_ = spatial_scale;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper boxes_;
  egr::TensorWrapper boxes_num_;

  // Attributes
  int pooled_height_;
  int pooled_width_;
  int output_channels_;
  float spatial_scale_;
};


class PutAlongAxisGradNodeFinal : public egr::GradNodeBase {
 public:
  PutAlongAxisGradNodeFinal() : egr::GradNodeBase() {}
  PutAlongAxisGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PutAlongAxisGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PutAlongAxisGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PutAlongAxisGradNodeFinal>(new PutAlongAxisGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributereduce(const std::string& reduce) {
    reduce_ = reduce;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
  int axis_;
  std::string reduce_;
};


class RealGradNodeFinal : public egr::GradNodeBase {
 public:
  RealGradNodeFinal() : egr::GradNodeBase() {}
  RealGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RealGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RealGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RealGradNodeFinal>(new RealGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class ReciprocalGradNodeFinal : public egr::GradNodeBase {
 public:
  ReciprocalGradNodeFinal() : egr::GradNodeBase() {}
  ReciprocalGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReciprocalGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReciprocalGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReciprocalGradNodeFinal>(new ReciprocalGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ReduceProdGradNodeFinal : public egr::GradNodeBase {
 public:
  ReduceProdGradNodeFinal() : egr::GradNodeBase() {}
  ReduceProdGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReduceProdGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReduceProdGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReduceProdGradNodeFinal>(new ReduceProdGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int64_t> dims_;
  bool keep_dim_;
  bool reduce_all_;
};


class ReluGradNodeFinal : public egr::GradNodeBase {
 public:
  ReluGradNodeFinal() : egr::GradNodeBase() {}
  ReluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReluGradNodeFinal>(new ReluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ReluDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ReluDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ReluDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReluDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReluDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReluDoubleGradNodeFinal>(new ReluDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class Relu6GradNodeFinal : public egr::GradNodeBase {
 public:
  Relu6GradNodeFinal() : egr::GradNodeBase() {}
  Relu6GradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Relu6GradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Relu6GradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Relu6GradNodeFinal>(new Relu6GradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributethreshold(const float& threshold) {
    threshold_ = threshold;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  float threshold_;
};


class ReshapeGradNodeFinal : public egr::GradNodeBase {
 public:
  ReshapeGradNodeFinal() : egr::GradNodeBase() {}
  ReshapeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReshapeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReshapeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    xshape_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReshapeGradNodeFinal>(new ReshapeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperxshape(const paddle::experimental::Tensor& xshape) {
    xshape_ = egr::TensorWrapper(xshape, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper xshape_;

  // Attributes
};


class ReshapeDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ReshapeDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ReshapeDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReshapeDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReshapeDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReshapeDoubleGradNodeFinal>(new ReshapeDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, true);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper grad_out_;

  // Attributes
};


class RoiAlignGradNodeFinal : public egr::GradNodeBase {
 public:
  RoiAlignGradNodeFinal() : egr::GradNodeBase() {}
  RoiAlignGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RoiAlignGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RoiAlignGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    boxes_.clear();
    boxes_num_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RoiAlignGradNodeFinal>(new RoiAlignGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrapperboxes(const paddle::experimental::Tensor& boxes) {
    boxes_ = egr::TensorWrapper(boxes, false);
  }
  void SetTensorWrapperboxes_num(const paddle::experimental::Tensor& boxes_num) {
    boxes_num_ = egr::TensorWrapper(boxes_num, false);
  }

  // SetAttributes
  void SetAttributepooled_height(const int& pooled_height) {
    pooled_height_ = pooled_height;
  }
  void SetAttributepooled_width(const int& pooled_width) {
    pooled_width_ = pooled_width;
  }
  void SetAttributespatial_scale(const float& spatial_scale) {
    spatial_scale_ = spatial_scale;
  }
  void SetAttributesampling_ratio(const int& sampling_ratio) {
    sampling_ratio_ = sampling_ratio;
  }
  void SetAttributealigned(const bool& aligned) {
    aligned_ = aligned;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper boxes_;
  egr::TensorWrapper boxes_num_;

  // Attributes
  int pooled_height_;
  int pooled_width_;
  float spatial_scale_;
  int sampling_ratio_;
  bool aligned_;
};


class RoiPoolGradNodeFinal : public egr::GradNodeBase {
 public:
  RoiPoolGradNodeFinal() : egr::GradNodeBase() {}
  RoiPoolGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RoiPoolGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RoiPoolGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    boxes_.clear();
    boxes_num_.clear();
    arg_max_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RoiPoolGradNodeFinal>(new RoiPoolGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperboxes(const paddle::experimental::Tensor& boxes) {
    boxes_ = egr::TensorWrapper(boxes, false);
  }
  void SetTensorWrapperboxes_num(const paddle::experimental::Tensor& boxes_num) {
    boxes_num_ = egr::TensorWrapper(boxes_num, false);
  }
  void SetTensorWrapperarg_max(const paddle::experimental::Tensor& arg_max) {
    arg_max_ = egr::TensorWrapper(arg_max, false);
  }

  // SetAttributes
  void SetAttributepooled_height(const int& pooled_height) {
    pooled_height_ = pooled_height;
  }
  void SetAttributepooled_width(const int& pooled_width) {
    pooled_width_ = pooled_width;
  }
  void SetAttributespatial_scale(const float& spatial_scale) {
    spatial_scale_ = spatial_scale;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper boxes_;
  egr::TensorWrapper boxes_num_;
  egr::TensorWrapper arg_max_;

  // Attributes
  int pooled_height_;
  int pooled_width_;
  float spatial_scale_;
};


class RollGradNodeFinal : public egr::GradNodeBase {
 public:
  RollGradNodeFinal() : egr::GradNodeBase() {}
  RollGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RollGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RollGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RollGradNodeFinal>(new RollGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeshifts(const paddle::experimental::IntArray& shifts) {
    shifts_ = shifts;
  }
  void SetAttributeaxis(const std::vector<int64_t>& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::IntArray shifts_;
  std::vector<int64_t> axis_;
};


class RoundGradNodeFinal : public egr::GradNodeBase {
 public:
  RoundGradNodeFinal() : egr::GradNodeBase() {}
  RoundGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RoundGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RoundGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RoundGradNodeFinal>(new RoundGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class RsqrtGradNodeFinal : public egr::GradNodeBase {
 public:
  RsqrtGradNodeFinal() : egr::GradNodeBase() {}
  RsqrtGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RsqrtGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RsqrtGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RsqrtGradNodeFinal>(new RsqrtGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class RsqrtDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  RsqrtDoubleGradNodeFinal() : egr::GradNodeBase() {}
  RsqrtDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~RsqrtDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "RsqrtDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    grad_x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<RsqrtDoubleGradNodeFinal>(new RsqrtDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappergrad_x(const paddle::experimental::Tensor& grad_x) {
    grad_x_ = egr::TensorWrapper(grad_x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper grad_x_;

  // Attributes
};


class ScaleGradNodeFinal : public egr::GradNodeBase {
 public:
  ScaleGradNodeFinal() : egr::GradNodeBase() {}
  ScaleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScaleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScaleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScaleGradNodeFinal>(new ScaleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributescale(const paddle::experimental::Scalar& scale) {
    scale_ = scale;
  }
  void SetAttributebias(const float& bias) {
    bias_ = bias;
  }
  void SetAttributebias_after_scale(const bool& bias_after_scale) {
    bias_after_scale_ = bias_after_scale;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::Scalar scale_ = 1.0;
  float bias_ = 0.0;
  bool bias_after_scale_ = true;
};


class ScaleDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  ScaleDoubleGradNodeFinal() : egr::GradNodeBase() {}
  ScaleDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScaleDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScaleDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScaleDoubleGradNodeFinal>(new ScaleDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributescale(const paddle::experimental::Scalar& scale) {
    scale_ = scale;
  }
  void SetAttributebias(const float& bias) {
    bias_ = bias;
  }
  void SetAttributebias_after_scale(const bool& bias_after_scale) {
    bias_after_scale_ = bias_after_scale;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::Scalar scale_ = 1.0;
  float bias_ = 0.0;
  bool bias_after_scale_ = true;
};


class ScaleTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  ScaleTripleGradNodeFinal() : egr::GradNodeBase() {}
  ScaleTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScaleTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScaleTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScaleTripleGradNodeFinal>(new ScaleTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributescale(const paddle::experimental::Scalar& scale) {
    scale_ = scale;
  }
  void SetAttributebias(const float& bias) {
    bias_ = bias;
  }
  void SetAttributebias_after_scale(const bool& bias_after_scale) {
    bias_after_scale_ = bias_after_scale;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::Scalar scale_ = 1.0;
  float bias_ = 0.0;
  bool bias_after_scale_ = true;
};


class ScatterGradNodeFinal : public egr::GradNodeBase {
 public:
  ScatterGradNodeFinal() : egr::GradNodeBase() {}
  ScatterGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScatterGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScatterGradNodeFinal"; }

  void ClearTensorWrappers() override {
    index_.clear();
    updates_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScatterGradNodeFinal>(new ScatterGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }
  void SetTensorWrapperupdates(const paddle::experimental::Tensor& updates) {
    updates_ = egr::TensorWrapper(updates, true);
  }

  // SetAttributes
  void SetAttributeoverwrite(const bool& overwrite) {
    overwrite_ = overwrite;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper index_;
  egr::TensorWrapper updates_;

  // Attributes
  bool overwrite_;
};


class ScatterNdAddGradNodeFinal : public egr::GradNodeBase {
 public:
  ScatterNdAddGradNodeFinal() : egr::GradNodeBase() {}
  ScatterNdAddGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScatterNdAddGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScatterNdAddGradNodeFinal"; }

  void ClearTensorWrappers() override {
    index_.clear();
    updates_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScatterNdAddGradNodeFinal>(new ScatterNdAddGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }
  void SetTensorWrapperupdates(const paddle::experimental::Tensor& updates) {
    updates_ = egr::TensorWrapper(updates, true);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper index_;
  egr::TensorWrapper updates_;

  // Attributes
};


class SegmentPoolGradNodeFinal : public egr::GradNodeBase {
 public:
  SegmentPoolGradNodeFinal() : egr::GradNodeBase() {}
  SegmentPoolGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SegmentPoolGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SegmentPoolGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    segment_ids_.clear();
    out_.clear();
    summed_ids_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SegmentPoolGradNodeFinal>(new SegmentPoolGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappersegment_ids(const paddle::experimental::Tensor& segment_ids) {
    segment_ids_ = egr::TensorWrapper(segment_ids, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappersummed_ids(const paddle::experimental::Tensor& summed_ids) {
    summed_ids_ = egr::TensorWrapper(summed_ids, false);
  }

  // SetAttributes
  void SetAttributepooltype(const std::string& pooltype) {
    pooltype_ = pooltype;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper segment_ids_;
  egr::TensorWrapper out_;
  egr::TensorWrapper summed_ids_;

  // Attributes
  std::string pooltype_;
};


class SeluGradNodeFinal : public egr::GradNodeBase {
 public:
  SeluGradNodeFinal() : egr::GradNodeBase() {}
  SeluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SeluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SeluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SeluGradNodeFinal>(new SeluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributescale(const float& scale) {
    scale_ = scale;
  }
  void SetAttributealpha(const float& alpha) {
    alpha_ = alpha;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  float scale_;
  float alpha_;
};


class SigmoidGradNodeFinal : public egr::GradNodeBase {
 public:
  SigmoidGradNodeFinal() : egr::GradNodeBase() {}
  SigmoidGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SigmoidGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SigmoidGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SigmoidGradNodeFinal>(new SigmoidGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class SigmoidDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SigmoidDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SigmoidDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SigmoidDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SigmoidDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    fwd_grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SigmoidDoubleGradNodeFinal>(new SigmoidDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrapperfwd_grad_out(const paddle::experimental::Tensor& fwd_grad_out) {
    fwd_grad_out_ = egr::TensorWrapper(fwd_grad_out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper fwd_grad_out_;

  // Attributes
};


class SigmoidTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  SigmoidTripleGradNodeFinal() : egr::GradNodeBase() {}
  SigmoidTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SigmoidTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SigmoidTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    fwd_grad_out_.clear();
    grad_grad_x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SigmoidTripleGradNodeFinal>(new SigmoidTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrapperfwd_grad_out(const paddle::experimental::Tensor& fwd_grad_out) {
    fwd_grad_out_ = egr::TensorWrapper(fwd_grad_out, false);
  }
  void SetTensorWrappergrad_grad_x(const paddle::experimental::Tensor& grad_grad_x) {
    grad_grad_x_ = egr::TensorWrapper(grad_grad_x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper fwd_grad_out_;
  egr::TensorWrapper grad_grad_x_;

  // Attributes
};


class SigmoidCrossEntropyWithLogitsGradNodeFinal : public egr::GradNodeBase {
 public:
  SigmoidCrossEntropyWithLogitsGradNodeFinal() : egr::GradNodeBase() {}
  SigmoidCrossEntropyWithLogitsGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SigmoidCrossEntropyWithLogitsGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SigmoidCrossEntropyWithLogitsGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    label_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SigmoidCrossEntropyWithLogitsGradNodeFinal>(new SigmoidCrossEntropyWithLogitsGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperlabel(const paddle::experimental::Tensor& label) {
    label_ = egr::TensorWrapper(label, false);
  }

  // SetAttributes
  void SetAttributenormalize(const bool& normalize) {
    normalize_ = normalize;
  }
  void SetAttributeignore_index(const int& ignore_index) {
    ignore_index_ = ignore_index;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper label_;

  // Attributes
  bool normalize_;
  int ignore_index_;
};


class SiluGradNodeFinal : public egr::GradNodeBase {
 public:
  SiluGradNodeFinal() : egr::GradNodeBase() {}
  SiluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SiluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SiluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SiluGradNodeFinal>(new SiluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SinGradNodeFinal : public egr::GradNodeBase {
 public:
  SinGradNodeFinal() : egr::GradNodeBase() {}
  SinGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SinGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SinGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SinGradNodeFinal>(new SinGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SinhGradNodeFinal : public egr::GradNodeBase {
 public:
  SinhGradNodeFinal() : egr::GradNodeBase() {}
  SinhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SinhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SinhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SinhGradNodeFinal>(new SinhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SliceGradNodeFinal : public egr::GradNodeBase {
 public:
  SliceGradNodeFinal() : egr::GradNodeBase() {}
  SliceGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SliceGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SliceGradNodeFinal"; }

  void ClearTensorWrappers() override {
    input_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SliceGradNodeFinal>(new SliceGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperinput(const paddle::experimental::Tensor& input) {
    input_ = egr::TensorWrapper(input, true);
  }

  // SetAttributes
  void SetAttributeaxes(const std::vector<int64_t>& axes) {
    axes_ = axes;
  }
  void SetAttributestarts(const paddle::experimental::IntArray& starts) {
    starts_ = starts;
  }
  void SetAttributeends(const paddle::experimental::IntArray& ends) {
    ends_ = ends;
  }
  void SetAttributeinfer_flags(const std::vector<int64_t>& infer_flags) {
    infer_flags_ = infer_flags;
  }
  void SetAttributedecrease_axis(const std::vector<int64_t>& decrease_axis) {
    decrease_axis_ = decrease_axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper input_;

  // Attributes
  std::vector<int64_t> axes_;
  paddle::experimental::IntArray starts_;
  paddle::experimental::IntArray ends_;
  std::vector<int64_t> infer_flags_;
  std::vector<int64_t> decrease_axis_;
};


class SliceDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SliceDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SliceDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SliceDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SliceDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SliceDoubleGradNodeFinal>(new SliceDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxes(const std::vector<int64_t>& axes) {
    axes_ = axes;
  }
  void SetAttributestarts(const paddle::experimental::IntArray& starts) {
    starts_ = starts;
  }
  void SetAttributeends(const paddle::experimental::IntArray& ends) {
    ends_ = ends;
  }
  void SetAttributeinfer_flags(const std::vector<int64_t>& infer_flags) {
    infer_flags_ = infer_flags;
  }
  void SetAttributedecrease_axis(const std::vector<int64_t>& decrease_axis) {
    decrease_axis_ = decrease_axis;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int64_t> axes_;
  paddle::experimental::IntArray starts_;
  paddle::experimental::IntArray ends_;
  std::vector<int64_t> infer_flags_;
  std::vector<int64_t> decrease_axis_;
};


class SoftShrinkGradNodeFinal : public egr::GradNodeBase {
 public:
  SoftShrinkGradNodeFinal() : egr::GradNodeBase() {}
  SoftShrinkGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SoftShrinkGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SoftShrinkGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SoftShrinkGradNodeFinal>(new SoftShrinkGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributelambda(const float& lambda) {
    lambda_ = lambda;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float lambda_;
};


class SoftmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  SoftmaxGradNodeFinal() : egr::GradNodeBase() {}
  SoftmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SoftmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SoftmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SoftmaxGradNodeFinal>(new SoftmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  int axis_;
};


class SplitGradNodeFinal : public egr::GradNodeBase {
 public:
  SplitGradNodeFinal() : egr::GradNodeBase() {}
  SplitGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SplitGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SplitGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SplitGradNodeFinal>(new SplitGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const paddle::experimental::Scalar& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::Scalar axis_ = -1;
};


class SqrtGradNodeFinal : public egr::GradNodeBase {
 public:
  SqrtGradNodeFinal() : egr::GradNodeBase() {}
  SqrtGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SqrtGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SqrtGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SqrtGradNodeFinal>(new SqrtGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class SqrtDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SqrtDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SqrtDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SqrtDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SqrtDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    grad_x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SqrtDoubleGradNodeFinal>(new SqrtDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappergrad_x(const paddle::experimental::Tensor& grad_x) {
    grad_x_ = egr::TensorWrapper(grad_x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper grad_x_;

  // Attributes
};


class SquareGradNodeFinal : public egr::GradNodeBase {
 public:
  SquareGradNodeFinal() : egr::GradNodeBase() {}
  SquareGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SquareGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SquareGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SquareGradNodeFinal>(new SquareGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SquareDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SquareDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SquareDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SquareDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SquareDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SquareDoubleGradNodeFinal>(new SquareDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper grad_out_;

  // Attributes
};


class SqueezeGradNodeFinal : public egr::GradNodeBase {
 public:
  SqueezeGradNodeFinal() : egr::GradNodeBase() {}
  SqueezeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SqueezeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SqueezeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    xshape_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SqueezeGradNodeFinal>(new SqueezeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperxshape(const paddle::experimental::Tensor& xshape) {
    xshape_ = egr::TensorWrapper(xshape, false);
  }

  // SetAttributes
  void SetAttributeaxes(const std::vector<int>& axes) {
    axes_ = axes;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper xshape_;

  // Attributes
  std::vector<int> axes_;
};


class SqueezeDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SqueezeDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SqueezeDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SqueezeDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SqueezeDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SqueezeDoubleGradNodeFinal>(new SqueezeDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxes(const std::vector<int>& axes) {
    axes_ = axes;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> axes_;
};


class StackGradNodeFinal : public egr::GradNodeBase {
 public:
  StackGradNodeFinal() : egr::GradNodeBase() {}
  StackGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~StackGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "StackGradNodeFinal"; }

  void ClearTensorWrappers() override {
    for (auto& tw : x_) {
      tw.clear();
    }

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<StackGradNodeFinal>(new StackGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const std::vector<paddle::experimental::Tensor>& x) {
    for(const auto& eager_tensor : x) {
      x_.emplace_back(egr::TensorWrapper(eager_tensor, true));
    };
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  std::vector<egr::TensorWrapper> x_;

  // Attributes
  int axis_;
};


class StridedSliceGradNodeFinal : public egr::GradNodeBase {
 public:
  StridedSliceGradNodeFinal() : egr::GradNodeBase() {}
  StridedSliceGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~StridedSliceGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "StridedSliceGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<StridedSliceGradNodeFinal>(new StridedSliceGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributeaxes(const std::vector<int>& axes) {
    axes_ = axes;
  }
  void SetAttributestarts(const paddle::experimental::IntArray& starts) {
    starts_ = starts;
  }
  void SetAttributeends(const paddle::experimental::IntArray& ends) {
    ends_ = ends;
  }
  void SetAttributestrides(const paddle::experimental::IntArray& strides) {
    strides_ = strides;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int> axes_;
  paddle::experimental::IntArray starts_;
  paddle::experimental::IntArray ends_;
  paddle::experimental::IntArray strides_;
};


class SubtractGradNodeFinal : public egr::GradNodeBase {
 public:
  SubtractGradNodeFinal() : egr::GradNodeBase() {}
  SubtractGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SubtractGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SubtractGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SubtractGradNodeFinal>(new SubtractGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, true);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
  int axis_ = -1;
};


class SubtractDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SubtractDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SubtractDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SubtractDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SubtractDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    y_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SubtractDoubleGradNodeFinal>(new SubtractDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, true);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, true);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper y_;
  egr::TensorWrapper grad_out_;

  // Attributes
  int axis_ = -1;
};


class SumGradNodeFinal : public egr::GradNodeBase {
 public:
  SumGradNodeFinal() : egr::GradNodeBase() {}
  SumGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SumGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SumGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SumGradNodeFinal>(new SumGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int64_t> dims_;
  bool keep_dim_;
  bool reduce_all_ = false;
};


class SumDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  SumDoubleGradNodeFinal() : egr::GradNodeBase() {}
  SumDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SumDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SumDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SumDoubleGradNodeFinal>(new SumDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
};


class SumTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  SumTripleGradNodeFinal() : egr::GradNodeBase() {}
  SumTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SumTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SumTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    grad_grad_x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SumTripleGradNodeFinal>(new SumTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappergrad_grad_x(const paddle::experimental::Tensor& grad_grad_x) {
    grad_grad_x_ = egr::TensorWrapper(grad_grad_x, false);
  }

  // SetAttributes
  void SetAttributedims(const std::vector<int64_t>& dims) {
    dims_ = dims;
  }
  void SetAttributekeep_dim(const bool& keep_dim) {
    keep_dim_ = keep_dim;
  }
  void SetAttributereduce_all(const bool& reduce_all) {
    reduce_all_ = reduce_all;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper grad_grad_x_;

  // Attributes
  std::vector<int64_t> dims_ = {};
  bool keep_dim_ = false;
  bool reduce_all_ = false;
};


class SwishGradNodeFinal : public egr::GradNodeBase {
 public:
  SwishGradNodeFinal() : egr::GradNodeBase() {}
  SwishGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SwishGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SwishGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SwishGradNodeFinal>(new SwishGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributebete(const float& bete) {
    bete_ = bete;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float bete_ = 1.0;
};


class TakeAlongAxisGradNodeFinal : public egr::GradNodeBase {
 public:
  TakeAlongAxisGradNodeFinal() : egr::GradNodeBase() {}
  TakeAlongAxisGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TakeAlongAxisGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TakeAlongAxisGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    index_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TakeAlongAxisGradNodeFinal>(new TakeAlongAxisGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperindex(const paddle::experimental::Tensor& index) {
    index_ = egr::TensorWrapper(index, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper index_;

  // Attributes
  int axis_;
};


class TanGradNodeFinal : public egr::GradNodeBase {
 public:
  TanGradNodeFinal() : egr::GradNodeBase() {}
  TanGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanGradNodeFinal>(new TanGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class TanhGradNodeFinal : public egr::GradNodeBase {
 public:
  TanhGradNodeFinal() : egr::GradNodeBase() {}
  TanhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanhGradNodeFinal>(new TanhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class TanhDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  TanhDoubleGradNodeFinal() : egr::GradNodeBase() {}
  TanhDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanhDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanhDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    grad_out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanhDoubleGradNodeFinal>(new TanhDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappergrad_out(const paddle::experimental::Tensor& grad_out) {
    grad_out_ = egr::TensorWrapper(grad_out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper grad_out_;

  // Attributes
};


class TanhTripleGradNodeFinal : public egr::GradNodeBase {
 public:
  TanhTripleGradNodeFinal() : egr::GradNodeBase() {}
  TanhTripleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanhTripleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanhTripleGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();
    grad_out_forward_.clear();
    grad_x_grad_forward_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanhTripleGradNodeFinal>(new TanhTripleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }
  void SetTensorWrappergrad_out_forward(const paddle::experimental::Tensor& grad_out_forward) {
    grad_out_forward_ = egr::TensorWrapper(grad_out_forward, false);
  }
  void SetTensorWrappergrad_x_grad_forward(const paddle::experimental::Tensor& grad_x_grad_forward) {
    grad_x_grad_forward_ = egr::TensorWrapper(grad_x_grad_forward, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;
  egr::TensorWrapper grad_out_forward_;
  egr::TensorWrapper grad_x_grad_forward_;

  // Attributes
};


class TanhShrinkGradNodeFinal : public egr::GradNodeBase {
 public:
  TanhShrinkGradNodeFinal() : egr::GradNodeBase() {}
  TanhShrinkGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanhShrinkGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanhShrinkGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanhShrinkGradNodeFinal>(new TanhShrinkGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class ThresholdedReluGradNodeFinal : public egr::GradNodeBase {
 public:
  ThresholdedReluGradNodeFinal() : egr::GradNodeBase() {}
  ThresholdedReluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ThresholdedReluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ThresholdedReluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ThresholdedReluGradNodeFinal>(new ThresholdedReluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributethreshold(const float& threshold) {
    threshold_ = threshold;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float threshold_;
};


class TileGradNodeFinal : public egr::GradNodeBase {
 public:
  TileGradNodeFinal() : egr::GradNodeBase() {}
  TileGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TileGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TileGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TileGradNodeFinal>(new TileGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributerepeat_times(const paddle::experimental::IntArray& repeat_times) {
    repeat_times_ = repeat_times;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::IntArray repeat_times_;
};


class TileDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  TileDoubleGradNodeFinal() : egr::GradNodeBase() {}
  TileDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TileDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TileDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TileDoubleGradNodeFinal>(new TileDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributerepeat_times(const paddle::experimental::IntArray& repeat_times) {
    repeat_times_ = repeat_times;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::IntArray repeat_times_;
};


class TopKGradNodeFinal : public egr::GradNodeBase {
 public:
  TopKGradNodeFinal() : egr::GradNodeBase() {}
  TopKGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TopKGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TopKGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    indices_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TopKGradNodeFinal>(new TopKGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperindices(const paddle::experimental::Tensor& indices) {
    indices_ = egr::TensorWrapper(indices, false);
  }

  // SetAttributes
  void SetAttributek(const paddle::experimental::Scalar& k) {
    k_ = k;
  }
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }
  void SetAttributelargest(const bool& largest) {
    largest_ = largest;
  }
  void SetAttributesorted(const bool& sorted) {
    sorted_ = sorted;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper indices_;

  // Attributes
  paddle::experimental::Scalar k_ = -1;
  int axis_ = -1;
  bool largest_ = true;
  bool sorted_ = true;
};


class TransposeGradNodeFinal : public egr::GradNodeBase {
 public:
  TransposeGradNodeFinal() : egr::GradNodeBase() {}
  TransposeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TransposeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TransposeGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TransposeGradNodeFinal>(new TransposeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const std::vector<int>& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> axis_;
};


class TransposeDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  TransposeDoubleGradNodeFinal() : egr::GradNodeBase() {}
  TransposeDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TransposeDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TransposeDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TransposeDoubleGradNodeFinal>(new TransposeDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const std::vector<int>& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  std::vector<int> axis_;
};


class TriangularSolveGradNodeFinal : public egr::GradNodeBase {
 public:
  TriangularSolveGradNodeFinal() : egr::GradNodeBase() {}
  TriangularSolveGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TriangularSolveGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TriangularSolveGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TriangularSolveGradNodeFinal>(new TriangularSolveGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeupper(const bool& upper) {
    upper_ = upper;
  }
  void SetAttributetranpose(const bool& tranpose) {
    tranpose_ = tranpose;
  }
  void SetAttributeunitriangular(const bool& unitriangular) {
    unitriangular_ = unitriangular;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;

  // Attributes
  bool upper_;
  bool tranpose_;
  bool unitriangular_;
};


class TrilTriuGradNodeFinal : public egr::GradNodeBase {
 public:
  TrilTriuGradNodeFinal() : egr::GradNodeBase() {}
  TrilTriuGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TrilTriuGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TrilTriuGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TrilTriuGradNodeFinal>(new TrilTriuGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributediagonal(const int& diagonal) {
    diagonal_ = diagonal;
  }
  void SetAttributelower(const bool& lower) {
    lower_ = lower;
  }

 private:
  // TensorWrappers

  // Attributes
  int diagonal_;
  bool lower_;
};


class UnbindGradNodeFinal : public egr::GradNodeBase {
 public:
  UnbindGradNodeFinal() : egr::GradNodeBase() {}
  UnbindGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~UnbindGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "UnbindGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<UnbindGradNodeFinal>(new UnbindGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers

  // Attributes
  int axis_;
};


class UnfoldGradNodeFinal : public egr::GradNodeBase {
 public:
  UnfoldGradNodeFinal() : egr::GradNodeBase() {}
  UnfoldGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~UnfoldGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "UnfoldGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<UnfoldGradNodeFinal>(new UnfoldGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }

  // SetAttributes
  void SetAttributekernel_sizes(const std::vector<int>& kernel_sizes) {
    kernel_sizes_ = kernel_sizes;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  std::vector<int> kernel_sizes_;
  std::vector<int> strides_;
  std::vector<int> paddings_;
  std::vector<int> dilations_;
};


class UnsqueezeGradNodeFinal : public egr::GradNodeBase {
 public:
  UnsqueezeGradNodeFinal() : egr::GradNodeBase() {}
  UnsqueezeGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~UnsqueezeGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "UnsqueezeGradNodeFinal"; }

  void ClearTensorWrappers() override {
    xshape_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<UnsqueezeGradNodeFinal>(new UnsqueezeGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperxshape(const paddle::experimental::Tensor& xshape) {
    xshape_ = egr::TensorWrapper(xshape, false);
  }

  // SetAttributes
  void SetAttributeaxes(const paddle::experimental::IntArray& axes) {
    axes_ = axes;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper xshape_;

  // Attributes
  paddle::experimental::IntArray axes_;
};


class UnsqueezeDoubleGradNodeFinal : public egr::GradNodeBase {
 public:
  UnsqueezeDoubleGradNodeFinal() : egr::GradNodeBase() {}
  UnsqueezeDoubleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~UnsqueezeDoubleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "UnsqueezeDoubleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<UnsqueezeDoubleGradNodeFinal>(new UnsqueezeDoubleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributeaxes(const paddle::experimental::IntArray& axes) {
    axes_ = axes;
  }

 private:
  // TensorWrappers

  // Attributes
  paddle::experimental::IntArray axes_;
};


class WhereGradNodeFinal : public egr::GradNodeBase {
 public:
  WhereGradNodeFinal() : egr::GradNodeBase() {}
  WhereGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~WhereGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "WhereGradNodeFinal"; }

  void ClearTensorWrappers() override {
    condition_.clear();
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<WhereGradNodeFinal>(new WhereGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrappercondition(const paddle::experimental::Tensor& condition) {
    condition_ = egr::TensorWrapper(condition, false);
  }
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, true);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, true);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper condition_;
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};



namespace sparse {
    
class AbsGradNodeFinal : public egr::GradNodeBase {
 public:
  AbsGradNodeFinal() : egr::GradNodeBase() {}
  AbsGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AbsGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AbsGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AbsGradNodeFinal>(new AbsGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AcosGradNodeFinal : public egr::GradNodeBase {
 public:
  AcosGradNodeFinal() : egr::GradNodeBase() {}
  AcosGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AcosGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AcosGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AcosGradNodeFinal>(new AcosGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AcoshGradNodeFinal : public egr::GradNodeBase {
 public:
  AcoshGradNodeFinal() : egr::GradNodeBase() {}
  AcoshGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AcoshGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AcoshGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AcoshGradNodeFinal>(new AcoshGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AddGradNodeFinal : public egr::GradNodeBase {
 public:
  AddGradNodeFinal() : egr::GradNodeBase() {}
  AddGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AddGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AddGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AddGradNodeFinal>(new AddGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class AsinGradNodeFinal : public egr::GradNodeBase {
 public:
  AsinGradNodeFinal() : egr::GradNodeBase() {}
  AsinGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AsinGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AsinGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AsinGradNodeFinal>(new AsinGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AsinhGradNodeFinal : public egr::GradNodeBase {
 public:
  AsinhGradNodeFinal() : egr::GradNodeBase() {}
  AsinhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AsinhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AsinhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AsinhGradNodeFinal>(new AsinhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AtanGradNodeFinal : public egr::GradNodeBase {
 public:
  AtanGradNodeFinal() : egr::GradNodeBase() {}
  AtanGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AtanGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AtanGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AtanGradNodeFinal>(new AtanGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class AtanhGradNodeFinal : public egr::GradNodeBase {
 public:
  AtanhGradNodeFinal() : egr::GradNodeBase() {}
  AtanhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~AtanhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "AtanhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<AtanhGradNodeFinal>(new AtanhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class CastGradNodeFinal : public egr::GradNodeBase {
 public:
  CastGradNodeFinal() : egr::GradNodeBase() {}
  CastGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CastGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CastGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CastGradNodeFinal>(new CastGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributevalue_dtype(const paddle::experimental::DataType& value_dtype) {
    value_dtype_ = value_dtype;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  paddle::experimental::DataType value_dtype_;
};


class Conv3dGradNodeFinal : public egr::GradNodeBase {
 public:
  Conv3dGradNodeFinal() : egr::GradNodeBase() {}
  Conv3dGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Conv3dGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Conv3dGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    kernel_.clear();
    rulebook_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Conv3dGradNodeFinal>(new Conv3dGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperkernel(const paddle::experimental::Tensor& kernel) {
    kernel_ = egr::TensorWrapper(kernel, false);
  }
  void SetTensorWrapperrulebook(const paddle::experimental::Tensor& rulebook) {
    rulebook_ = egr::TensorWrapper(rulebook, false);
  }

  // SetAttributes
  void SetAttributepaddings(const std::vector<int>& paddings) {
    paddings_ = paddings;
  }
  void SetAttributedilations(const std::vector<int>& dilations) {
    dilations_ = dilations;
  }
  void SetAttributestrides(const std::vector<int>& strides) {
    strides_ = strides;
  }
  void SetAttributegroups(const int& groups) {
    groups_ = groups;
  }
  void SetAttributesubm(const bool& subm) {
    subm_ = subm;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper kernel_;
  egr::TensorWrapper rulebook_;

  // Attributes
  std::vector<int> paddings_;
  std::vector<int> dilations_;
  std::vector<int> strides_;
  int groups_;
  bool subm_;
};


class CooToDenseGradNodeFinal : public egr::GradNodeBase {
 public:
  CooToDenseGradNodeFinal() : egr::GradNodeBase() {}
  CooToDenseGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CooToDenseGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CooToDenseGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CooToDenseGradNodeFinal>(new CooToDenseGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class CreateSparseCooTensorGradNodeFinal : public egr::GradNodeBase {
 public:
  CreateSparseCooTensorGradNodeFinal() : egr::GradNodeBase() {}
  CreateSparseCooTensorGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~CreateSparseCooTensorGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "CreateSparseCooTensorGradNodeFinal"; }

  void ClearTensorWrappers() override {
    indices_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<CreateSparseCooTensorGradNodeFinal>(new CreateSparseCooTensorGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperindices(const paddle::experimental::Tensor& indices) {
    indices_ = egr::TensorWrapper(indices, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper indices_;

  // Attributes
};


class DenseToCooGradNodeFinal : public egr::GradNodeBase {
 public:
  DenseToCooGradNodeFinal() : egr::GradNodeBase() {}
  DenseToCooGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DenseToCooGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DenseToCooGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DenseToCooGradNodeFinal>(new DenseToCooGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes

 private:
  // TensorWrappers

  // Attributes
};


class DivideGradNodeFinal : public egr::GradNodeBase {
 public:
  DivideGradNodeFinal() : egr::GradNodeBase() {}
  DivideGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DivideGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DivideGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DivideGradNodeFinal>(new DivideGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;
  egr::TensorWrapper out_;

  // Attributes
};


class DivideScalarGradNodeFinal : public egr::GradNodeBase {
 public:
  DivideScalarGradNodeFinal() : egr::GradNodeBase() {}
  DivideScalarGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~DivideScalarGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "DivideScalarGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<DivideScalarGradNodeFinal>(new DivideScalarGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributescalar(const float& scalar) {
    scalar_ = scalar;
  }

 private:
  // TensorWrappers

  // Attributes
  float scalar_;
};


class Log1pGradNodeFinal : public egr::GradNodeBase {
 public:
  Log1pGradNodeFinal() : egr::GradNodeBase() {}
  Log1pGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~Log1pGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "Log1pGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<Log1pGradNodeFinal>(new Log1pGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class MultiplyGradNodeFinal : public egr::GradNodeBase {
 public:
  MultiplyGradNodeFinal() : egr::GradNodeBase() {}
  MultiplyGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MultiplyGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MultiplyGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MultiplyGradNodeFinal>(new MultiplyGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class PowGradNodeFinal : public egr::GradNodeBase {
 public:
  PowGradNodeFinal() : egr::GradNodeBase() {}
  PowGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~PowGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "PowGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<PowGradNodeFinal>(new PowGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes
  void SetAttributefactor(const float& factor) {
    factor_ = factor;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
  float factor_;
};


class ReluGradNodeFinal : public egr::GradNodeBase {
 public:
  ReluGradNodeFinal() : egr::GradNodeBase() {}
  ReluGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ReluGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ReluGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ReluGradNodeFinal>(new ReluGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ScaleGradNodeFinal : public egr::GradNodeBase {
 public:
  ScaleGradNodeFinal() : egr::GradNodeBase() {}
  ScaleGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ScaleGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ScaleGradNodeFinal"; }

  void ClearTensorWrappers() override {

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ScaleGradNodeFinal>(new ScaleGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...

  // SetAttributes
  void SetAttributescale(const float& scale) {
    scale_ = scale;
  }

 private:
  // TensorWrappers

  // Attributes
  float scale_;
};


class SinGradNodeFinal : public egr::GradNodeBase {
 public:
  SinGradNodeFinal() : egr::GradNodeBase() {}
  SinGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SinGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SinGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SinGradNodeFinal>(new SinGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SinhGradNodeFinal : public egr::GradNodeBase {
 public:
  SinhGradNodeFinal() : egr::GradNodeBase() {}
  SinhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SinhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SinhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SinhGradNodeFinal>(new SinhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SoftmaxGradNodeFinal : public egr::GradNodeBase {
 public:
  SoftmaxGradNodeFinal() : egr::GradNodeBase() {}
  SoftmaxGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SoftmaxGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SoftmaxGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SoftmaxGradNodeFinal>(new SoftmaxGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributeaxis(const int& axis) {
    axis_ = axis;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
  int axis_;
};


class SqrtGradNodeFinal : public egr::GradNodeBase {
 public:
  SqrtGradNodeFinal() : egr::GradNodeBase() {}
  SqrtGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SqrtGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SqrtGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SqrtGradNodeFinal>(new SqrtGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class SquareGradNodeFinal : public egr::GradNodeBase {
 public:
  SquareGradNodeFinal() : egr::GradNodeBase() {}
  SquareGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SquareGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SquareGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SquareGradNodeFinal>(new SquareGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class SubtractGradNodeFinal : public egr::GradNodeBase {
 public:
  SubtractGradNodeFinal() : egr::GradNodeBase() {}
  SubtractGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SubtractGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SubtractGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SubtractGradNodeFinal>(new SubtractGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class TanGradNodeFinal : public egr::GradNodeBase {
 public:
  TanGradNodeFinal() : egr::GradNodeBase() {}
  TanGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanGradNodeFinal>(new TanGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class TanhGradNodeFinal : public egr::GradNodeBase {
 public:
  TanhGradNodeFinal() : egr::GradNodeBase() {}
  TanhGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~TanhGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "TanhGradNodeFinal"; }

  void ClearTensorWrappers() override {
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<TanhGradNodeFinal>(new TanhGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper out_;

  // Attributes
};


class ValuesGradNodeFinal : public egr::GradNodeBase {
 public:
  ValuesGradNodeFinal() : egr::GradNodeBase() {}
  ValuesGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~ValuesGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "ValuesGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<ValuesGradNodeFinal>(new ValuesGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;

  // Attributes
};


class FusedAttentionGradNodeFinal : public egr::GradNodeBase {
 public:
  FusedAttentionGradNodeFinal() : egr::GradNodeBase() {}
  FusedAttentionGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~FusedAttentionGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "FusedAttentionGradNodeFinal"; }

  void ClearTensorWrappers() override {
    query_.clear();
    key_.clear();
    value_.clear();
    softmax_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<FusedAttentionGradNodeFinal>(new FusedAttentionGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperquery(const paddle::experimental::Tensor& query) {
    query_ = egr::TensorWrapper(query, false);
  }
  void SetTensorWrapperkey(const paddle::experimental::Tensor& key) {
    key_ = egr::TensorWrapper(key, false);
  }
  void SetTensorWrappervalue(const paddle::experimental::Tensor& value) {
    value_ = egr::TensorWrapper(value, false);
  }
  void SetTensorWrappersoftmax(const paddle::experimental::Tensor& softmax) {
    softmax_ = egr::TensorWrapper(softmax, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper query_;
  egr::TensorWrapper key_;
  egr::TensorWrapper value_;
  egr::TensorWrapper softmax_;

  // Attributes
};


class MaskedMatmulGradNodeFinal : public egr::GradNodeBase {
 public:
  MaskedMatmulGradNodeFinal() : egr::GradNodeBase() {}
  MaskedMatmulGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MaskedMatmulGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MaskedMatmulGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MaskedMatmulGradNodeFinal>(new MaskedMatmulGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class MatmulGradNodeFinal : public egr::GradNodeBase {
 public:
  MatmulGradNodeFinal() : egr::GradNodeBase() {}
  MatmulGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MatmulGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MatmulGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    y_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MatmulGradNodeFinal>(new MatmulGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappery(const paddle::experimental::Tensor& y) {
    y_ = egr::TensorWrapper(y, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper y_;

  // Attributes
};


class SparseMaxpoolGradNodeFinal : public egr::GradNodeBase {
 public:
  SparseMaxpoolGradNodeFinal() : egr::GradNodeBase() {}
  SparseMaxpoolGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~SparseMaxpoolGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "SparseMaxpoolGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    rulebook_.clear();
    out_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<SparseMaxpoolGradNodeFinal>(new SparseMaxpoolGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrapperrulebook(const paddle::experimental::Tensor& rulebook) {
    rulebook_ = egr::TensorWrapper(rulebook, false);
  }
  void SetTensorWrapperout(const paddle::experimental::Tensor& out) {
    out_ = egr::TensorWrapper(out, false);
  }

  // SetAttributes
  void SetAttributekernel_sizes(const std::vector<int>& kernel_sizes) {
    kernel_sizes_ = kernel_sizes;
  }

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper rulebook_;
  egr::TensorWrapper out_;

  // Attributes
  std::vector<int> kernel_sizes_;
};


class MvGradNodeFinal : public egr::GradNodeBase {
 public:
  MvGradNodeFinal() : egr::GradNodeBase() {}
  MvGradNodeFinal(size_t bwd_in_slot_num, size_t bwd_out_slot_num) :
      egr::GradNodeBase(bwd_in_slot_num, bwd_out_slot_num) {}
  ~MvGradNodeFinal() override = default;

  virtual paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> operator()(
      paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph = false, bool is_new_grad = false) override;
  std::string name() override { return "MvGradNodeFinal"; }

  void ClearTensorWrappers() override {
    x_.clear();
    vec_.clear();

    SetIsTensorWrappersCleared(true);
  }

  std::shared_ptr<GradNodeBase> Copy() const override {
    auto copied_node = std::shared_ptr<MvGradNodeFinal>(new MvGradNodeFinal(*this));
    return copied_node;
  }

  // SetTensorWrapperX, SetTensorWrapperY, ...
  void SetTensorWrapperx(const paddle::experimental::Tensor& x) {
    x_ = egr::TensorWrapper(x, false);
  }
  void SetTensorWrappervec(const paddle::experimental::Tensor& vec) {
    vec_ = egr::TensorWrapper(vec, false);
  }

  // SetAttributes

 private:
  // TensorWrappers
  egr::TensorWrapper x_;
  egr::TensorWrapper vec_;

  // Attributes
};


}


