
#include "glog/logging.h"
#include "paddle/phi/api/all.h"
#include "paddle/phi/api/backward/backward_api.h"
#include "paddle/phi/api/backward/sparse_bw_api.h"
#include "paddle/fluid/imperative/tracer.h"
#include "paddle/fluid/framework/op_registry.h"
#include "paddle/fluid/platform/profiler/event_tracing.h"
#include "paddle/fluid/eager/utils.h"
#include "paddle/fluid/eager/api/utils/global_utils.h"
#include "paddle/fluid/eager/api/generated/eager_generated/backwards/nodes.h"
#include "paddle/fluid/eager/to_static/run_program_op_node.h"
#include "paddle/fluid/eager/nan_inf_utils.h"

#include "paddle/phi/api/include/sparse_api.h"
#include "paddle/fluid/eager/api/manual/eager_manual/nodes/nodes.h"
DECLARE_bool(check_nan_inf);

paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Atan2GradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Atan2GradNodeFinal";

  paddle::experimental::atan2_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan2_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CholeskyGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& upper = this->upper_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CholeskyGradNodeFinal";

  paddle::experimental::cholesky_grad(out, out_grad, upper, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cholesky_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CholeskySolveGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& upper = this->upper_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CholeskySolveGradNodeFinal";

  paddle::experimental::cholesky_solve_grad(x, y, out, out_grad, upper, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cholesky_solve_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CrossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CrossGradNodeFinal";

  paddle::experimental::cross_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cross_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DiagGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& offset = this->offset_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DiagGradNodeFinal";

  paddle::experimental::diag_grad(x, out_grad, offset, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("diag_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DiagonalGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& offset = this->offset_;
  auto& axis1 = this->axis1_;
  auto& axis2 = this->axis2_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DiagonalGradNodeFinal";

  paddle::experimental::diagonal_grad(x, out_grad, offset, axis1, axis2, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("diagonal_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DigammaGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DigammaGradNodeFinal";

  paddle::experimental::digamma_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("digamma_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DistGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& p = this->p_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DistGradNodeFinal";

  paddle::experimental::dist_grad(x, y, out, out_grad, p, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dist_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DotGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DotGradNodeFinal";

  paddle::experimental::dot_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dot_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ErfGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ErfGradNodeFinal";

  paddle::experimental::erf_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("erf_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MvGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto vec = egr::EagerUtils::RecoverTensorWrapper(&this->vec_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MvGradNodeFinal";

  paddle::experimental::mv_grad(x, vec, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mv_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& vec_grad = returns[1][0];
  egr::AutogradMeta* vec_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&vec_grad) : nullptr;
  if (vec_grad_autograd_meta) vec_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PoissonGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PoissonGradNodeFinal";

  paddle::experimental::poisson_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("poisson_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TraceGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& offset = this->offset_;
  auto& axis1 = this->axis1_;
  auto& axis2 = this->axis2_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TraceGradNodeFinal";

  paddle::experimental::trace_grad(x, out_grad, offset, axis1, axis2, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("trace_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TruncGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TruncGradNodeFinal";

  paddle::experimental::trunc_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("trunc_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}



paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AbsGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AbsGradNodeFinal";

  paddle::experimental::abs_grad(x, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("abs_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("abs_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<AbsDoubleGradNodeFinal>(new AbsDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AbsDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AbsDoubleGradNodeFinal";

  paddle::experimental::abs_double_grad(x, grad_x_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("abs_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AcosGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AcosGradNodeFinal";

  paddle::experimental::acos_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acos_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AcoshGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AcoshGradNodeFinal";

  paddle::experimental::acosh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acosh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AddGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: AddGradNodeFinal";

  paddle::experimental::add_grad(x, y, grad_out, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("add_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<AddDoubleGradNodeFinal>(new AddDoubleGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AddDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_grad_x = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_grad_x_optional;
  if(grad_grad_x.initialized()) grad_grad_x_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_grad_x);

  auto& grad_grad_y = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_grad_y_optional;
  if(grad_grad_y.initialized()) grad_grad_y_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_grad_y);

  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_grad_x.initialized()) {
    VLOG(10) << grad_grad_x.name() << "(grad_x_grad) use_count: " << grad_grad_x.impl().use_count();
    if (grad_grad_x.impl().use_count() == 1 || (grad_grad_x.impl().use_count() == 2 && grad_grad_x.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_grad_x, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: AddDoubleGradNodeFinal";

  paddle::experimental::add_double_grad(y, grad_out, grad_grad_x_optional, grad_grad_y_optional, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_out = returns[2][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("add_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<AddTripleGradNodeFinal>(new AddTripleGradNodeFinal(1, 4));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappergrad_grad_x(grad_grad_x);
    grad_node->SetTensorWrappergrad_grad_y(grad_grad_y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_grad_x, 2);
    grad_node->SetGradOutMeta(grad_grad_y, 3);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 0);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_grad_out, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AddTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto grad_grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_grad_x_);
  auto grad_grad_y = egr::EagerUtils::RecoverTensorWrapper(&this->grad_grad_y_);
  auto& grad_grad_out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(4);
  for (int i = 0; i < 4; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  auto* api_output_1 = (out_metas[3].empty() || out_metas[3][0].IsStopGradient()) ? nullptr : &returns[3][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_grad_out_grad.initialized()) {
    VLOG(10) << grad_grad_out_grad.name() << "(grad_grad_out_grad) use_count: " << grad_grad_out_grad.impl().use_count();
    if (grad_grad_out_grad.impl().use_count() == 1 || (grad_grad_out_grad.impl().use_count() == 2 && grad_grad_out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_grad_out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AddTripleGradNodeFinal";

  paddle::experimental::add_triple_grad(grad_grad_x, grad_grad_y, grad_grad_out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_x_grad = returns[2][0];
  egr::AutogradMeta* grad_grad_x_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_x_grad) : nullptr;
  if (grad_grad_x_grad_autograd_meta) grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_grad_y_grad = returns[3][0];
  egr::AutogradMeta* grad_grad_y_grad_autograd_meta = returns[3][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_y_grad) : nullptr;
  if (grad_grad_y_grad_autograd_meta) grad_grad_y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AddmmGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  auto& beta = this->beta_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AddmmGradNodeFinal";

  paddle::experimental::addmm_grad(input, x, y, out_grad, alpha, beta, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("addmm_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  

  auto& x_grad = returns[1][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[2][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ArgsortGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto indices = egr::EagerUtils::RecoverTensorWrapper(&this->indices_);
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& descending = this->descending_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ArgsortGradNodeFinal";

  paddle::experimental::argsort_grad(indices, x, out_grad, axis, descending, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("argsort_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AsinGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AsinGradNodeFinal";

  paddle::experimental::asin_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asin_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AsinhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AsinhGradNodeFinal";

  paddle::experimental::asinh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asinh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AssignGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: AssignGradNodeFinal";

  paddle::experimental::assign_grad(grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("assign_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<AssignDoubleGradNodeFinal>(new AssignDoubleGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AssignDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(grad_x_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: AssignDoubleGradNodeFinal";

  paddle::experimental::assign_double_grad(grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("assign_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<AssignTripleGradNodeFinal>(new AssignTripleGradNodeFinal(1, 1));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AssignTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AssignTripleGradNodeFinal";

  paddle::experimental::assign_triple_grad(grad_x_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[0][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AssignOutGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AssignOutGradNodeFinal";

  paddle::experimental::assign_out__grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("assign_out__grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AtanGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AtanGradNodeFinal";

  paddle::experimental::atan_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AtanhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: AtanhGradNodeFinal";

  paddle::experimental::atanh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atanh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> BatchNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto scale = egr::EagerUtils::RecoverTensorWrapper(&this->scale_);
  auto bias = egr::EagerUtils::RecoverTensorWrapper(&this->bias_);
  auto out_mean = egr::EagerUtils::RecoverTensorWrapper(&this->mean_out_);

  paddle::optional<paddle::experimental::Tensor> out_mean_optional;
  if( out_mean.impl() ) out_mean_optional = paddle::make_optional<paddle::experimental::Tensor>(out_mean);

  auto out_variance = egr::EagerUtils::RecoverTensorWrapper(&this->variance_out_);

  paddle::optional<paddle::experimental::Tensor> out_variance_optional;
  if( out_variance.impl() ) out_variance_optional = paddle::make_optional<paddle::experimental::Tensor>(out_variance);

  auto saved_mean = egr::EagerUtils::RecoverTensorWrapper(&this->saved_mean_);
  auto saved_variance = egr::EagerUtils::RecoverTensorWrapper(&this->saved_variance_);
  auto reserve_space = egr::EagerUtils::RecoverTensorWrapper(&this->reserve_space_);

  paddle::optional<paddle::experimental::Tensor> reserve_space_optional;
  if( reserve_space.impl() ) reserve_space_optional = paddle::make_optional<paddle::experimental::Tensor>(reserve_space);

  auto& grad_out = hooked_grads[0][0];
  auto& momentum = this->momentum_;
  auto& epsilon = this->epsilon_;
  auto& data_layout = this->data_layout_;
  auto& is_test = this->is_test_;
  auto& use_global_stats = this->use_global_stats_;
  auto& trainable_statistics = this->trainable_statistics_;
  auto& fuse_with_relu = this->fuse_with_relu_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(5);
  for (int i = 0; i < 5; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: BatchNormGradNodeFinal";

  paddle::experimental::batch_norm_grad(x, scale, bias, out_mean_optional, out_variance_optional, saved_mean, saved_variance, reserve_space_optional, grad_out, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("batch_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_scale = returns[1][0];
  egr::AutogradMeta* grad_scale_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_scale) : nullptr;
  if (grad_scale_autograd_meta) grad_scale_autograd_meta->SetStopGradient(false);
  

  auto& grad_bias = returns[2][0];
  egr::AutogradMeta* grad_bias_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_bias) : nullptr;
  if (grad_bias_autograd_meta) grad_bias_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("batch_norm_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<BatchNormDoubleGradNodeFinal>(new BatchNormDoubleGradNodeFinal(3, 9));
    // SetAttributes if needed
    grad_node->SetAttributemomentum(momentum);
    grad_node->SetAttributeepsilon(epsilon);
    grad_node->SetAttributedata_layout(data_layout);
    grad_node->SetAttributeis_test(is_test);
    grad_node->SetAttributeuse_global_stats(use_global_stats);
    grad_node->SetAttributetrainable_statistics(trainable_statistics);
    grad_node->SetAttributefuse_with_relu(fuse_with_relu);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperscale(scale);
    grad_node->SetTensorWrapperout_mean(out_mean);
    grad_node->SetTensorWrapperout_variance(out_variance);
    grad_node->SetTensorWrappersaved_mean(saved_mean);
    grad_node->SetTensorWrappersaved_variance(saved_variance);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(scale, 1);
    grad_node->SetGradOutMeta(grad_out, 8);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_scale_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_scale_autograd_meta, 1);
    }
    if (grad_bias_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_bias_autograd_meta, 2);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_scale_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_scale_autograd_meta, grad_node);
    }
    if (grad_bias_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_bias_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_scale, 1);
    grad_node->SetGradInMeta(grad_bias, 2);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_scale);
    egr::EagerUtils::CheckAndRetainGrad(grad_bias);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> BatchNormDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[1][0], input_metas[1][0]);
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[2][0], input_metas[2][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto scale = egr::EagerUtils::RecoverTensorWrapper(&this->scale_);
  auto out_mean = egr::EagerUtils::RecoverTensorWrapper(&this->out_mean_);

  paddle::optional<paddle::experimental::Tensor> out_mean_optional;
  if( out_mean.impl() ) out_mean_optional = paddle::make_optional<paddle::experimental::Tensor>(out_mean);

  auto out_variance = egr::EagerUtils::RecoverTensorWrapper(&this->out_variance_);

  paddle::optional<paddle::experimental::Tensor> out_variance_optional;
  if( out_variance.impl() ) out_variance_optional = paddle::make_optional<paddle::experimental::Tensor>(out_variance);

  auto saved_mean = egr::EagerUtils::RecoverTensorWrapper(&this->saved_mean_);
  auto saved_variance = egr::EagerUtils::RecoverTensorWrapper(&this->saved_variance_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& grad_scale_grad = hooked_grads[1][0];
  auto& grad_bias_grad = hooked_grads[2][0];
  auto& momentum = this->momentum_;
  auto& epsilon = this->epsilon_;
  auto& data_layout = this->data_layout_;
  auto& is_test = this->is_test_;
  auto& use_global_stats = this->use_global_stats_;
  auto& trainable_statistics = this->trainable_statistics_;
  auto& fuse_with_relu = this->fuse_with_relu_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(9);
  for (int i = 0; i < 9; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[8].empty() || out_metas[8][0].IsStopGradient()) ? nullptr : &returns[8][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(grad_out) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == (&this->grad_out_)->get_intermidiate_tensor().impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_2 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_2);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: BatchNormDoubleGradNodeFinal";

  paddle::experimental::batch_norm_double_grad(x, scale, out_mean_optional, out_variance_optional, saved_mean, saved_variance, grad_out, grad_x_grad, grad_scale_grad, grad_bias_grad, momentum, epsilon, data_layout, is_test, use_global_stats, trainable_statistics, fuse_with_relu, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("batch_norm_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& scale_grad = returns[1][0];
  egr::AutogradMeta* scale_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&scale_grad) : nullptr;
  if (scale_grad_autograd_meta) scale_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[8][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[8][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> BceLossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: BceLossGradNodeFinal";

  paddle::experimental::bce_loss_grad(input, label, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("bce_loss_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> BreluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& t_min = this->t_min_;
  auto& t_max = this->t_max_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: BreluGradNodeFinal";

  paddle::experimental::brelu_grad(x, out_grad, t_min, t_max, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("brelu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CastGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CastGradNodeFinal";

  paddle::experimental::cast_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cast_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CeilGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: CeilGradNodeFinal";

  paddle::experimental::ceil_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("ceil_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CeluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: CeluGradNodeFinal";

  paddle::experimental::celu_grad(x, grad_out, alpha, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("celu_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("celu_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<CeluDoubleGradNodeFinal>(new CeluDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CeluDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: CeluDoubleGradNodeFinal";

  paddle::experimental::celu_double_grad(x, grad_out, grad_x_grad, alpha, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("celu_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ClipGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& min = this->min_;
  auto& max = this->max_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: ClipGradNodeFinal";

  paddle::experimental::clip_grad(x, grad_out, min, max, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("clip_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("clip_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ClipDoubleGradNodeFinal>(new ClipDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributemin(min);
    grad_node->SetAttributemax(max);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ClipDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& min = this->min_;
  auto& max = this->max_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ClipDoubleGradNodeFinal";

  paddle::experimental::clip_double_grad(x, grad_x_grad, min, max, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("clip_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ComplexGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ComplexGradNodeFinal";

  paddle::experimental::complex_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("complex_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ConcatGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ConcatGradNodeFinal";

  paddle::experimental::concat_grad(x, grad_out, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("concat_grad", returns); }

  // Get GradOut autograd_meta

    auto& grad_x = returns[0];
    std::vector<egr::AutogradMeta*> grad_x_autograd_meta_vec = egr::EagerUtils::autograd_meta(&grad_x);
    std::vector<egr::AutogradMeta*>* grad_x_autograd_meta = &grad_x_autograd_meta_vec;
    for(auto* meta : grad_x_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("concat_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ConcatDoubleGradNodeFinal>(new ConcatDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ConcatDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0], input_metas[0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ConcatDoubleGradNodeFinal";

  paddle::experimental::concat_double_grad(grad_x_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("concat_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ConjGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ConjGradNodeFinal";

  paddle::experimental::conj_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conj_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv2dTransposeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto& grad_out = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& output_padding = this->output_padding_;
  auto& output_size = this->output_size_;
  auto& padding_algorithm = this->padding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv2dTransposeGradNodeFinal";

  paddle::experimental::conv2d_transpose_grad(x, filter, grad_out, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv2d_transpose_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_filter = returns[1][0];
  egr::AutogradMeta* grad_filter_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_filter) : nullptr;
  if (grad_filter_autograd_meta) grad_filter_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("conv2d_transpose_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv2dTransposeDoubleGradNodeFinal>(new Conv2dTransposeDoubleGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeoutput_padding(output_padding);
    grad_node->SetAttributeoutput_size(output_size);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperfilter(filter);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(filter, 1);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_filter_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_filter_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_filter, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_filter);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv2dTransposeDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& grad_filter_grad = hooked_grads[1][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& output_padding = this->output_padding_;
  auto& output_size = this->output_size_;
  auto& padding_algorithm = this->padding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv2dTransposeDoubleGradNodeFinal";

  paddle::experimental::conv2d_transpose_double_grad(x, filter, grad_out, grad_x_grad, grad_filter_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv2d_transpose_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[1][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv3dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto& grad_out = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& paddding_algorithm = this->paddding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  auto& use_addto = this->use_addto_;
  auto& workspace_size_MB = this->workspace_size_MB_;
  auto& exhaustive_search = this->exhaustive_search_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv3dGradNodeFinal";

  paddle::experimental::conv3d_grad(input, filter, grad_out, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_input = returns[0][0];
  egr::AutogradMeta* grad_input_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_input) : nullptr;
  if (grad_input_autograd_meta) grad_input_autograd_meta->SetStopGradient(false);
  

  auto& grad_filter = returns[1][0];
  egr::AutogradMeta* grad_filter_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_filter) : nullptr;
  if (grad_filter_autograd_meta) grad_filter_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("conv3d_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<Conv3dGradGradNodeFinal>(new Conv3dGradGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepaddding_algorithm(paddding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributeuse_addto(use_addto);
    grad_node->SetAttributeworkspace_size_MB(workspace_size_MB);
    grad_node->SetAttributeexhaustive_search(exhaustive_search);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperfilter(filter);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(filter, 1);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_input_autograd_meta, 0);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_filter_autograd_meta, 1);
    }
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_input_autograd_meta, grad_node);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_filter_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_input, 0);
    grad_node->SetGradInMeta(grad_filter, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_input);
    egr::EagerUtils::CheckAndRetainGrad(grad_filter);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv3dGradGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_input_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_input_grad_optional;
  if(grad_input_grad.initialized()) grad_input_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_input_grad);

  auto& grad_filter_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_filter_grad_optional;
  if(grad_filter_grad.initialized()) grad_filter_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_filter_grad);

  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& paddding_algorithm = this->paddding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  auto& use_addto = this->use_addto_;
  auto& workspace_size_MB = this->workspace_size_MB_;
  auto& exhaustive_search = this->exhaustive_search_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv3dGradGradNodeFinal";

  paddle::experimental::conv3d_grad_grad(input, filter, grad_out, grad_input_grad_optional, grad_filter_grad_optional, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_grad_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[1][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv3dTransposeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto& out_grad = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& output_padding = this->output_padding_;
  auto& output_size = this->output_size_;
  auto& padding_algorithm = this->padding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv3dTransposeGradNodeFinal";

  paddle::experimental::conv3d_transpose_grad(x, filter, out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_transpose_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[1][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CosGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: CosGradNodeFinal";

  paddle::experimental::cos_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cos_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CoshGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: CoshGradNodeFinal";

  paddle::experimental::cosh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cosh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CrossEntropyWithSoftmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto softmax = egr::EagerUtils::RecoverTensorWrapper(&this->softmax_);
  auto& loss_grad = hooked_grads[1][0];
  auto& soft_label = this->soft_label_;
  auto& use_softmax = this->use_softmax_;
  auto& numeric_stable_mode = this->numeric_stable_mode_;
  auto& ignore_index = this->ignore_index_;
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (softmax.initialized()) {
    VLOG(10) << softmax.name() << "(softmax) use_count: " << softmax.impl().use_count();
    if (softmax.impl().use_count() == 1 || (softmax.impl().use_count() == 2 && softmax.impl().get() == (&this->softmax_)->get_intermidiate_tensor().impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(softmax, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: CrossEntropyWithSoftmaxGradNodeFinal";

  paddle::experimental::cross_entropy_with_softmax_grad(label, softmax, loss_grad, soft_label, use_softmax, numeric_stable_mode, ignore_index, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cross_entropy_with_softmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CumprodGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& dim = this->dim_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CumprodGradNodeFinal";

  paddle::experimental::cumprod_grad(x, out, out_grad, dim, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cumprod_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CumsumGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& flatten = this->flatten_;
  auto& exclusive = this->exclusive_;
  auto& reverse = this->reverse_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CumsumGradNodeFinal";

  paddle::experimental::cumsum_grad(out_grad, axis, flatten, exclusive, reverse, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cumsum_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DeformableConvGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto offset = egr::EagerUtils::RecoverTensorWrapper(&this->offset_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto mask = egr::EagerUtils::RecoverTensorWrapper(&this->mask_);

  paddle::optional<paddle::experimental::Tensor> mask_optional;
  if( mask.impl() ) mask_optional = paddle::make_optional<paddle::experimental::Tensor>(mask);

  auto& out_grad = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& dilations = this->dilations_;
  auto& deformable_groups = this->deformable_groups_;
  auto& groups = this->groups_;
  auto& im2col_step = this->im2col_step_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(4);
  for (int i = 0; i < 4; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  auto* api_output_3 = (out_metas[3].empty() || out_metas[3][0].IsStopGradient()) ? nullptr : &returns[3][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DeformableConvGradNodeFinal";

  paddle::experimental::deformable_conv_grad(x, offset, filter, mask_optional, out_grad, strides, paddings, dilations, deformable_groups, groups, im2col_step, api_output_0, api_output_1, api_output_2, api_output_3);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("deformable_conv_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& offset_grad = returns[1][0];
  egr::AutogradMeta* offset_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&offset_grad) : nullptr;
  if (offset_grad_autograd_meta) offset_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[2][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  

  auto& mask_grad = returns[3][0];
  egr::AutogradMeta* mask_grad_autograd_meta = returns[3][0].initialized() ? egr::EagerUtils::autograd_meta(&mask_grad) : nullptr;
  if (mask_grad_autograd_meta) mask_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DepthwiseConv2dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto& grad_out = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& paddding_algorithm = this->paddding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  auto& use_addto = this->use_addto_;
  auto& workspace_size_MB = this->workspace_size_MB_;
  auto& exhaustive_search = this->exhaustive_search_;
  auto& fuse_relu = this->fuse_relu_;
  auto& use_gpudnn = this->use_gpudnn_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DepthwiseConv2dGradNodeFinal";

  paddle::experimental::depthwise_conv2d_grad(input, filter, grad_out, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, use_gpudnn, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("depthwise_conv2d_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_input = returns[0][0];
  egr::AutogradMeta* grad_input_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_input) : nullptr;
  if (grad_input_autograd_meta) grad_input_autograd_meta->SetStopGradient(false);
  

  auto& grad_filter = returns[1][0];
  egr::AutogradMeta* grad_filter_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_filter) : nullptr;
  if (grad_filter_autograd_meta) grad_filter_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("depthwise_conv2d_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<DepthwiseConv2dGradGradNodeFinal>(new DepthwiseConv2dGradGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepaddding_algorithm(paddding_algorithm);
    grad_node->SetAttributegroups(groups);
    grad_node->SetAttributedilations(dilations);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributeuse_addto(use_addto);
    grad_node->SetAttributeworkspace_size_MB(workspace_size_MB);
    grad_node->SetAttributeexhaustive_search(exhaustive_search);
    grad_node->SetAttributefuse_relu(fuse_relu);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperinput(input);
    grad_node->SetTensorWrapperfilter(filter);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(input, 0);
    grad_node->SetGradOutMeta(filter, 1);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_input_autograd_meta, 0);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_filter_autograd_meta, 1);
    }
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_input_autograd_meta, grad_node);
    }
    if (grad_filter_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_filter_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_input, 0);
    grad_node->SetGradInMeta(grad_filter, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_input);
    egr::EagerUtils::CheckAndRetainGrad(grad_filter);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DepthwiseConv2dGradGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_input_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_input_grad_optional;
  if(grad_input_grad.initialized()) grad_input_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_input_grad);

  auto& grad_filter_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_filter_grad_optional;
  if(grad_filter_grad.initialized()) grad_filter_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_filter_grad);

  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& paddding_algorithm = this->paddding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  auto& use_addto = this->use_addto_;
  auto& workspace_size_MB = this->workspace_size_MB_;
  auto& exhaustive_search = this->exhaustive_search_;
  auto& fuse_relu = this->fuse_relu_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DepthwiseConv2dGradGradNodeFinal";

  paddle::experimental::depthwise_conv2d_grad_grad(input, filter, grad_out, grad_input_grad_optional, grad_filter_grad_optional, strides, paddings, paddding_algorithm, groups, dilations, data_format, use_addto, workspace_size_MB, exhaustive_search, fuse_relu, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("depthwise_conv2d_grad_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[1][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DepthwiseConv2dTransposeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto filter = egr::EagerUtils::RecoverTensorWrapper(&this->filter_);
  auto& out_grad = hooked_grads[0][0];
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& output_padding = this->output_padding_;
  auto& output_size = this->output_size_;
  auto& padding_algorithm = this->padding_algorithm_;
  auto& groups = this->groups_;
  auto& dilations = this->dilations_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DepthwiseConv2dTransposeGradNodeFinal";

  paddle::experimental::depthwise_conv2d_transpose_grad(x, filter, out_grad, strides, paddings, output_padding, output_size, padding_algorithm, groups, dilations, data_format, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("depthwise_conv2d_transpose_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& filter_grad = returns[1][0];
  egr::AutogradMeta* filter_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&filter_grad) : nullptr;
  if (filter_grad_autograd_meta) filter_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DetGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DetGradNodeFinal";

  paddle::experimental::det_grad(x, out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("det_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DivideGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DivideGradNodeFinal";

  paddle::experimental::divide_grad(x, y, out, grad_out, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("divide_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<DivideDoubleGradNodeFinal>(new DivideDoubleGradNodeFinal(2, 4));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrapperout(out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(y, 1);
    grad_node->SetGradOutMeta(out, 2);
    grad_node->SetGradOutMeta(grad_out, 3);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappergrad_x(grad_x);
  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DivideDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_x_);
  auto& grad_x_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_x_grad_optional;
  if(grad_x_grad.initialized()) grad_x_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_x_grad);

  auto& grad_y_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_y_grad_optional;
  if(grad_y_grad.initialized()) grad_y_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_y_grad);

  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(4);
  for (int i = 0; i < 4; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  auto* api_output_2 = (out_metas[3].empty() || out_metas[3][0].IsStopGradient()) ? nullptr : &returns[3][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_2 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_2);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: DivideDoubleGradNodeFinal";

  paddle::experimental::divide_double_grad(y, out, grad_x, grad_x_grad_optional, grad_y_grad_optional, axis, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  

  auto& out_grad = returns[2][0];
  egr::AutogradMeta* out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&out_grad) : nullptr;
  if (out_grad_autograd_meta) out_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[3][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[3][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DropoutGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto mask = egr::EagerUtils::RecoverTensorWrapper(&this->mask_);
  auto& out_grad = hooked_grads[0][0];
  auto& p = this->p_;
  auto& is_test = this->is_test_;
  auto& mode = this->mode_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DropoutGradNodeFinal";

  paddle::experimental::dropout_grad(mask, out_grad, p, is_test, mode, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dropout_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> EighGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out_w = egr::EagerUtils::RecoverTensorWrapper(&this->out_w_);
  auto out_v = egr::EagerUtils::RecoverTensorWrapper(&this->out_v_);
  auto& out_w_grad = hooked_grads[0][0];
  auto& out_v_grad = hooked_grads[1][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: EighGradNodeFinal";

  paddle::experimental::eigh_grad(out_w, out_v, out_w_grad, out_v_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("eigh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> EinsumGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x_shape = egr::EagerUtils::RecoverTensorWrapper(&this->x_shape_);
  auto inner_cache = egr::EagerUtils::RecoverTensorWrapper(&this->inner_cache_);
  auto& out_grad = hooked_grads[0][0];
  auto& equation = this->equation_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: EinsumGradNodeFinal";

  paddle::experimental::einsum_grad(x_shape, inner_cache, out_grad, equation, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("einsum_grad", returns); }

  // Get GradOut autograd_meta

    auto& x_grad = returns[0];
    std::vector<egr::AutogradMeta*> x_grad_autograd_meta_vec = egr::EagerUtils::autograd_meta(&x_grad);
    for(auto* meta : x_grad_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ElementwisePowGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ElementwisePowGradNodeFinal";

  paddle::experimental::elementwise_pow_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("elementwise_pow_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> EluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: EluGradNodeFinal";

  paddle::experimental::elu_grad(x, out, grad_out, alpha, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("elu_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("elu_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<EluDoubleGradNodeFinal>(new EluDoubleGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> EluDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: EluDoubleGradNodeFinal";

  paddle::experimental::elu_double_grad(x, grad_out, grad_x_grad, alpha, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("elu_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> EmbeddingGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto weight = egr::EagerUtils::RecoverTensorWrapper(&this->weight_);
  auto& out_grad = hooked_grads[0][0];
  auto& padding_idx = this->padding_idx_;
  auto& sparse = this->sparse_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: EmbeddingGradNodeFinal";

  paddle::experimental::embedding_grad(x, weight, out_grad, padding_idx, sparse, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("embedding_grad", returns); }

  // Get GradOut autograd_meta

  auto& weight_grad = returns[1][0];
  egr::AutogradMeta* weight_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&weight_grad) : nullptr;
  if (weight_grad_autograd_meta) weight_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ErfinvGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ErfinvGradNodeFinal";

  paddle::experimental::erfinv_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("erfinv_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ExpGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: ExpGradNodeFinal";

  paddle::experimental::exp_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("exp_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ExpandGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& shape = this->shape_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ExpandGradNodeFinal";

  paddle::experimental::expand_grad(x, grad_out, shape, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expand_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("expand_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ExpandDoubleGradNodeFinal>(new ExpandDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeshape(shape);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ExpandDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& shape = this->shape_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ExpandDoubleGradNodeFinal";

  paddle::experimental::expand_double_grad(grad_x_grad, shape, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expand_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ExpandAsGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& target_shape = this->target_shape_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ExpandAsGradNodeFinal";

  paddle::experimental::expand_as_grad(x, out_grad, target_shape, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expand_as_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Expm1GradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: Expm1GradNodeFinal";

  paddle::experimental::expm1_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("expm1_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FlattenGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto xshape = egr::EagerUtils::RecoverTensorWrapper(&this->xshape_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: FlattenGradNodeFinal";

  paddle::experimental::flatten_grad(xshape, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("flatten_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FlipGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: FlipGradNodeFinal";

  paddle::experimental::flip_grad(out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("flip_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FloorGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: FloorGradNodeFinal";

  paddle::experimental::floor_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("floor_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: FmaxGradNodeFinal";

  paddle::experimental::fmax_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FminGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: FminGradNodeFinal";

  paddle::experimental::fmin_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fmin_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FrobeniusNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: FrobeniusNormGradNodeFinal";

  paddle::experimental::frobenius_norm_grad(x, out, out_grad, axis, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("frobenius_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GatherGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& overwrite = this->overwrite_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: GatherGradNodeFinal";

  paddle::experimental::gather_grad(x, index, out_grad, axis, overwrite, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gather_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GatherNdGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: GatherNdGradNodeFinal";

  paddle::experimental::gather_nd_grad(x, index, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gather_nd_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GeluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& approximate = this->approximate_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: GeluGradNodeFinal";

  paddle::experimental::gelu_grad(x, out_grad, approximate, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gelu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GraphSendRecvGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto src_index = egr::EagerUtils::RecoverTensorWrapper(&this->src_index_);
  auto dst_index = egr::EagerUtils::RecoverTensorWrapper(&this->dst_index_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);

  paddle::optional<paddle::experimental::Tensor> out_optional;
  if( out.impl() ) out_optional = paddle::make_optional<paddle::experimental::Tensor>(out);

  auto dst_count = egr::EagerUtils::RecoverTensorWrapper(&this->dst_count_);

  paddle::optional<paddle::experimental::Tensor> dst_count_optional;
  if( dst_count.impl() ) dst_count_optional = paddle::make_optional<paddle::experimental::Tensor>(dst_count);

  auto& out_grad = hooked_grads[0][0];
  auto& pool_type = this->pool_type_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: GraphSendRecvGradNodeFinal";

  paddle::experimental::graph_send_recv_grad(x, src_index, dst_index, out_optional, dst_count_optional, out_grad, pool_type, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("graph_send_recv_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GroupNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto scale = egr::EagerUtils::RecoverTensorWrapper(&this->scale_);

  paddle::optional<paddle::experimental::Tensor> scale_optional;
  if( scale.impl() ) scale_optional = paddle::make_optional<paddle::experimental::Tensor>(scale);

  auto bias = egr::EagerUtils::RecoverTensorWrapper(&this->bias_);

  paddle::optional<paddle::experimental::Tensor> bias_optional;
  if( bias.impl() ) bias_optional = paddle::make_optional<paddle::experimental::Tensor>(bias);

  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto mean = egr::EagerUtils::RecoverTensorWrapper(&this->mean_);
  auto variance = egr::EagerUtils::RecoverTensorWrapper(&this->variance_);
  auto& y_grad = hooked_grads[0][0];
  auto& epsilon = this->epsilon_;
  auto& groups = this->groups_;
  auto& data_layout = this->data_layout_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (y_grad.initialized()) {
    VLOG(10) << y_grad.name() << "(y_grad) use_count: " << y_grad.impl().use_count();
    if (y_grad.impl().use_count() == 1 || (y_grad.impl().use_count() == 2 && y_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(y_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: GroupNormGradNodeFinal";

  paddle::experimental::group_norm_grad(x, scale_optional, bias_optional, y, mean, variance, y_grad, epsilon, groups, data_layout, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("group_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& scale_grad = returns[1][0];
  egr::AutogradMeta* scale_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&scale_grad) : nullptr;
  if (scale_grad_autograd_meta) scale_grad_autograd_meta->SetStopGradient(false);
  

  auto& bias_grad = returns[2][0];
  egr::AutogradMeta* bias_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&bias_grad) : nullptr;
  if (bias_grad_autograd_meta) bias_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> GumbelSoftmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: GumbelSoftmaxGradNodeFinal";

  paddle::experimental::gumbel_softmax_grad(out, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("gumbel_softmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> HardShrinkGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& threshold = this->threshold_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: HardShrinkGradNodeFinal";

  paddle::experimental::hard_shrink_grad(x, out_grad, threshold, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_shrink_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> HardSigmoidGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& slope = this->slope_;
  auto& offset = this->offset_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: HardSigmoidGradNodeFinal";

  paddle::experimental::hard_sigmoid_grad(out, out_grad, slope, offset, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_sigmoid_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> HardSwishGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& threshold = this->threshold_;
  auto& scale = this->scale_;
  auto& offset = this->offset_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: HardSwishGradNodeFinal";

  paddle::experimental::hard_swish_grad(x, out_grad, threshold, scale, offset, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("hard_swish_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> HuberLossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto residual = egr::EagerUtils::RecoverTensorWrapper(&this->residual_);
  auto& out_grad = hooked_grads[0][0];
  auto& delta = this->delta_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: HuberLossGradNodeFinal";

  paddle::experimental::huber_loss_grad(residual, out_grad, delta, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("huber_loss_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  

  auto& label_grad = returns[1][0];
  egr::AutogradMeta* label_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&label_grad) : nullptr;
  if (label_grad_autograd_meta) label_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ImagGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ImagGradNodeFinal";

  paddle::experimental::imag_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("imag_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> IndexSampleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: IndexSampleGradNodeFinal";

  paddle::experimental::index_sample_grad(x, index, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("index_sample_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> IndexSelectGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  auto& dim = this->dim_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: IndexSelectGradNodeFinal";

  paddle::experimental::index_select_grad(x, index, out_grad, dim, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("index_select_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> InstanceNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto fwd_scale = egr::EagerUtils::RecoverTensorWrapper(&this->scale_);

  paddle::optional<paddle::experimental::Tensor> fwd_scale_optional;
  if( fwd_scale.impl() ) fwd_scale_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_scale);

  auto saved_mean = egr::EagerUtils::RecoverTensorWrapper(&this->saved_mean_);
  auto saved_variance = egr::EagerUtils::RecoverTensorWrapper(&this->saved_variance_);
  auto& grad_y = hooked_grads[0][0];
  auto& epsilon = this->epsilon_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: InstanceNormGradNodeFinal";

  paddle::experimental::instance_norm_grad(x, fwd_scale_optional, saved_mean, saved_variance, grad_y, epsilon, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("instance_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_scale = returns[1][0];
  egr::AutogradMeta* grad_scale_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_scale) : nullptr;
  if (grad_scale_autograd_meta) grad_scale_autograd_meta->SetStopGradient(false);
  

  auto& grad_bias = returns[2][0];
  egr::AutogradMeta* grad_bias_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_bias) : nullptr;
  if (grad_bias_autograd_meta) grad_bias_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("instance_norm_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<InstanceNormDoubleGradNodeFinal>(new InstanceNormDoubleGradNodeFinal(3, 5));
    // SetAttributes if needed
    grad_node->SetAttributeepsilon(epsilon);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrapperfwd_scale(fwd_scale);
    grad_node->SetTensorWrappersaved_mean(saved_mean);
    grad_node->SetTensorWrappersaved_variance(saved_variance);
    grad_node->SetTensorWrappergrad_y(grad_y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(fwd_scale, 1);
    grad_node->SetGradOutMeta(grad_y, 4);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_scale_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_scale_autograd_meta, 1);
    }
    if (grad_bias_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_bias_autograd_meta, 2);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_scale_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_scale_autograd_meta, grad_node);
    }
    if (grad_bias_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_bias_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_scale, 1);
    grad_node->SetGradInMeta(grad_bias, 2);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_scale);
    egr::EagerUtils::CheckAndRetainGrad(grad_bias);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> InstanceNormDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[2][0], input_metas[2][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto fwd_scale = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_scale_);

  paddle::optional<paddle::experimental::Tensor> fwd_scale_optional;
  if( fwd_scale.impl() ) fwd_scale_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_scale);

  auto saved_mean = egr::EagerUtils::RecoverTensorWrapper(&this->saved_mean_);
  auto saved_variance = egr::EagerUtils::RecoverTensorWrapper(&this->saved_variance_);
  auto grad_y = egr::EagerUtils::RecoverTensorWrapper(&this->grad_y_);
  auto& grad_x_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_x_grad_optional;
  if(grad_x_grad.initialized()) grad_x_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_x_grad);

  auto& grad_scale_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_scale_grad_optional;
  if(grad_scale_grad.initialized()) grad_scale_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_scale_grad);

  auto& grad_bias_grad = hooked_grads[2][0];

  paddle::optional<paddle::experimental::Tensor> grad_bias_grad_optional;
  if(grad_bias_grad.initialized()) grad_bias_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_bias_grad);

  auto& epsilon = this->epsilon_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(5);
  for (int i = 0; i < 5; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[4].empty() || out_metas[4][0].IsStopGradient()) ? nullptr : &returns[4][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: InstanceNormDoubleGradNodeFinal";

  paddle::experimental::instance_norm_double_grad(x, fwd_scale_optional, saved_mean, saved_variance, grad_y, grad_x_grad_optional, grad_scale_grad_optional, grad_bias_grad_optional, epsilon, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("instance_norm_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_scale_grad = returns[1][0];
  egr::AutogradMeta* fwd_scale_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_scale_grad) : nullptr;
  if (fwd_scale_grad_autograd_meta) fwd_scale_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_y_grad = returns[4][0];
  egr::AutogradMeta* grad_y_grad_autograd_meta = returns[4][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y_grad) : nullptr;
  if (grad_y_grad_autograd_meta) grad_y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> KldivLossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto& out_grad = hooked_grads[0][0];
  auto& reduction = this->reduction_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: KldivLossGradNodeFinal";

  paddle::experimental::kldiv_loss_grad(x, label, out_grad, reduction, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kldiv_loss_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> KronGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: KronGradNodeFinal";

  paddle::experimental::kron_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kron_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> KthvalueGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto indices = egr::EagerUtils::RecoverTensorWrapper(&this->indices_);
  auto& out_grad = hooked_grads[0][0];
  auto& k = this->k_;
  auto& axis = this->axis_;
  auto& keepdim = this->keepdim_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: KthvalueGradNodeFinal";

  paddle::experimental::kthvalue_grad(x, indices, out_grad, k, axis, keepdim, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("kthvalue_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LabelSmoothGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& epsilon = this->epsilon_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LabelSmoothGradNodeFinal";

  paddle::experimental::label_smooth_grad(out_grad, epsilon, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("label_smooth_grad", returns); }

  // Get GradOut autograd_meta

  auto& label_grad = returns[0][0];
  egr::AutogradMeta* label_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&label_grad) : nullptr;
  if (label_grad_autograd_meta) label_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LayerNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto scale = egr::EagerUtils::RecoverTensorWrapper(&this->scale_);

  paddle::optional<paddle::experimental::Tensor> scale_optional;
  if( scale.impl() ) scale_optional = paddle::make_optional<paddle::experimental::Tensor>(scale);

  auto bias = egr::EagerUtils::RecoverTensorWrapper(&this->bias_);

  paddle::optional<paddle::experimental::Tensor> bias_optional;
  if( bias.impl() ) bias_optional = paddle::make_optional<paddle::experimental::Tensor>(bias);

  auto mean = egr::EagerUtils::RecoverTensorWrapper(&this->mean_);
  auto variance = egr::EagerUtils::RecoverTensorWrapper(&this->variance_);
  auto& out_grad = hooked_grads[0][0];
  auto& epsilon = this->epsilon_;
  auto& begin_norm_axis = this->begin_norm_axis_;
  auto& is_test = this->is_test_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LayerNormGradNodeFinal";

  paddle::experimental::layer_norm_grad(x, scale_optional, bias_optional, mean, variance, out_grad, epsilon, begin_norm_axis, is_test, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("layer_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& scale_grad = returns[1][0];
  egr::AutogradMeta* scale_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&scale_grad) : nullptr;
  if (scale_grad_autograd_meta) scale_grad_autograd_meta->SetStopGradient(false);
  

  auto& bias_grad = returns[2][0];
  egr::AutogradMeta* bias_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&bias_grad) : nullptr;
  if (bias_grad_autograd_meta) bias_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LeakyReluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: LeakyReluGradNodeFinal";

  paddle::experimental::leaky_relu_grad(x, grad_out, alpha, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("leaky_relu_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("leaky_relu_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<LeakyReluDoubleGradNodeFinal>(new LeakyReluDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributealpha(alpha);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LeakyReluDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_x_grad = hooked_grads[0][0];
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: LeakyReluDoubleGradNodeFinal";

  paddle::experimental::leaky_relu_double_grad(x, grad_x_grad, alpha, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("leaky_relu_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LerpGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto weight = egr::EagerUtils::RecoverTensorWrapper(&this->weight_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LerpGradNodeFinal";

  paddle::experimental::lerp_grad(x, y, weight, out, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("lerp_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LgammaGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LgammaGradNodeFinal";

  paddle::experimental::lgamma_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("lgamma_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: LogGradNodeFinal";

  paddle::experimental::log_grad(x, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("log_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<LogDoubleGradNodeFinal>(new LogDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: LogDoubleGradNodeFinal";

  paddle::experimental::log_double_grad(x, grad_out, grad_x_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Log10GradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: Log10GradNodeFinal";

  paddle::experimental::log10_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log10_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Log1pGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: Log1pGradNodeFinal";

  paddle::experimental::log1p_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log1p_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Log2GradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: Log2GradNodeFinal";

  paddle::experimental::log2_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log2_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogLossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto& out_grad = hooked_grads[0][0];
  auto& epsilon = this->epsilon_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LogLossGradNodeFinal";

  paddle::experimental::log_loss_grad(input, label, out_grad, epsilon, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_loss_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogSoftmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LogSoftmaxGradNodeFinal";

  paddle::experimental::log_softmax_grad(out, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log_softmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogcumsumexpGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& flatten = this->flatten_;
  auto& exclusive = this->exclusive_;
  auto& reverse = this->reverse_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LogcumsumexpGradNodeFinal";

  paddle::experimental::logcumsumexp_grad(x, out, out_grad, axis, flatten, exclusive, reverse, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logcumsumexp_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogitGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& eps = this->eps_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LogitGradNodeFinal";

  paddle::experimental::logit_grad(x, out_grad, eps, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logit_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogsigmoidGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: LogsigmoidGradNodeFinal";

  paddle::experimental::logsigmoid_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logsigmoid_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> LogsumexpGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& keepdim = this->keepdim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: LogsumexpGradNodeFinal";

  paddle::experimental::logsumexp_grad(x, out, out_grad, axis, keepdim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("logsumexp_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaskedSelectGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto mask = egr::EagerUtils::RecoverTensorWrapper(&this->mask_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaskedSelectGradNodeFinal";

  paddle::experimental::masked_select_grad(x, mask, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("masked_select_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MatmulGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& grad_out = hooked_grads[0][0];
  auto& transpose_x = this->transpose_x_;
  auto& transpose_y = this->transpose_y_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MatmulGradNodeFinal";

  paddle::experimental::matmul_grad(x, y, grad_out, transpose_x, transpose_y, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("matmul_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<MatmulDoubleGradNodeFinal>(new MatmulDoubleGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributetranspose_x(transpose_x);
    grad_node->SetAttributetranspose_y(transpose_y);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MatmulDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& fwd_grad_grad_x = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_x_optional;
  if(fwd_grad_grad_x.initialized()) fwd_grad_grad_x_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_x);

  auto& fwd_grad_grad_y = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_y_optional;
  if(fwd_grad_grad_y.initialized()) fwd_grad_grad_y_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_y);

  auto& transpose_x = this->transpose_x_;
  auto& transpose_y = this->transpose_y_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MatmulDoubleGradNodeFinal";

  paddle::experimental::matmul_double_grad(x, y, fwd_grad_out, fwd_grad_grad_x_optional, fwd_grad_grad_y_optional, transpose_x, transpose_y, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  

  auto& grad_grad_out = returns[2][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("matmul_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<MatmulTripleGradNodeFinal>(new MatmulTripleGradNodeFinal(3, 5));
    // SetAttributes if needed
    grad_node->SetAttributetranspose_x(transpose_x);
    grad_node->SetAttributetranspose_y(transpose_y);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrapperfwd_grad_out(fwd_grad_out);
    grad_node->SetTensorWrapperfwd_grad_grad_x(fwd_grad_grad_x);
    grad_node->SetTensorWrapperfwd_grad_grad_y(fwd_grad_grad_y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    grad_node->SetGradOutMeta(fwd_grad_out, 2);
    grad_node->SetGradOutMeta(fwd_grad_grad_x, 3);
    grad_node->SetGradOutMeta(fwd_grad_grad_y, 4);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 2);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    grad_node->SetGradInMeta(grad_grad_out, 2);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MatmulTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[2][0], input_metas[2][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_out_);
  auto fwd_grad_grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_grad_x_);
  auto fwd_grad_grad_y = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_grad_y_);
  auto& grad_x_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_x_grad_optional;
  if(grad_x_grad.initialized()) grad_x_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_x_grad);

  auto& grad_y_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_y_grad_optional;
  if(grad_y_grad.initialized()) grad_y_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_y_grad);

  auto& grad_grad_out_grad = hooked_grads[2][0];

  paddle::optional<paddle::experimental::Tensor> grad_grad_out_grad_optional;
  if(grad_grad_out_grad.initialized()) grad_grad_out_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_grad_out_grad);

  auto& transpose_x = this->transpose_x_;
  auto& transpose_y = this->transpose_y_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(5);
  for (int i = 0; i < 5; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  auto* api_output_3 = (out_metas[3].empty() || out_metas[3][0].IsStopGradient()) ? nullptr : &returns[3][0];
  auto* api_output_4 = (out_metas[4].empty() || out_metas[4][0].IsStopGradient()) ? nullptr : &returns[4][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MatmulTripleGradNodeFinal";

  paddle::experimental::matmul_triple_grad(x, y, fwd_grad_out, fwd_grad_grad_x, fwd_grad_grad_y, grad_x_grad_optional, grad_y_grad_optional, grad_grad_out_grad_optional, transpose_x, transpose_y, api_output_0, api_output_1, api_output_2, api_output_3, api_output_4);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_out_grad = returns[2][0];
  egr::AutogradMeta* fwd_grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_out_grad) : nullptr;
  if (fwd_grad_out_grad_autograd_meta) fwd_grad_out_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_grad_x_grad = returns[3][0];
  egr::AutogradMeta* fwd_grad_grad_x_grad_autograd_meta = returns[3][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_grad_x_grad) : nullptr;
  if (fwd_grad_grad_x_grad_autograd_meta) fwd_grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_grad_y_grad = returns[4][0];
  egr::AutogradMeta* fwd_grad_grad_y_grad_autograd_meta = returns[4][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_grad_y_grad) : nullptr;
  if (fwd_grad_grad_y_grad_autograd_meta) fwd_grad_grad_y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MatrixPowerGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& n = this->n_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MatrixPowerGradNodeFinal";

  paddle::experimental::matrix_power_grad(x, out, out_grad, n, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matrix_power_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaxGradNodeFinal";

  paddle::experimental::max_grad(x, out, out_grad, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaxPool2dWithIndexGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto mask = egr::EagerUtils::RecoverTensorWrapper(&this->mask_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaxPool2dWithIndexGradNodeFinal";

  paddle::experimental::max_pool2d_with_index_grad(x, mask, out_grad, kernel_size, strides, paddings, global_pooling, adaptive, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max_pool2d_with_index_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaxPool3dWithIndexGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto mask = egr::EagerUtils::RecoverTensorWrapper(&this->mask_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaxPool3dWithIndexGradNodeFinal";

  paddle::experimental::max_pool3d_with_index_grad(x, mask, out_grad, kernel_size, strides, paddings, global_pooling, adaptive, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("max_pool3d_with_index_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaximumGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaximumGradNodeFinal";

  paddle::experimental::maximum_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("maximum_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaxoutGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& groups = this->groups_;
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaxoutGradNodeFinal";

  paddle::experimental::maxout_grad(x, out, out_grad, groups, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("maxout_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MeanGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MeanGradNodeFinal";

  paddle::experimental::mean_grad(x, grad_out, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mean_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("mean_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<MeanDoubleGradNodeFinal>(new MeanDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(reduce_all);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MeanDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MeanDoubleGradNodeFinal";

  paddle::experimental::mean_double_grad(grad_x_grad, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mean_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MeanAllGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MeanAllGradNodeFinal";

  paddle::experimental::mean_all_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mean_all_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MeshgridGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto inputs = egr::EagerUtils::RecoverTensorWrapper(&this->inputs_);
  auto& outputs_grad = hooked_grads[0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MeshgridGradNodeFinal";

  paddle::experimental::meshgrid_grad(inputs, outputs_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("meshgrid_grad", returns); }

  // Get GradOut autograd_meta

    auto& inputs_grad = returns[0];
    std::vector<egr::AutogradMeta*> inputs_grad_autograd_meta_vec = egr::EagerUtils::autograd_meta(&inputs_grad);
    for(auto* meta : inputs_grad_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MinGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MinGradNodeFinal";

  paddle::experimental::min_grad(x, out, out_grad, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("min_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MinimumGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MinimumGradNodeFinal";

  paddle::experimental::minimum_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("minimum_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MishGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& threshold = this->threshold_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: MishGradNodeFinal";

  paddle::experimental::mish_grad(x, out_grad, threshold, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mish_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ModeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto indices = egr::EagerUtils::RecoverTensorWrapper(&this->indices_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& keepdim = this->keepdim_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ModeGradNodeFinal";

  paddle::experimental::mode_grad(x, indices, out_grad, axis, keepdim, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mode_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ModuloGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ModuloGradNodeFinal";

  paddle::experimental::modulo_grad(x, y, out_grad, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("modulo_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiDotGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MultiDotGradNodeFinal";

  paddle::experimental::multi_dot_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multi_dot_grad", returns); }

  // Get GradOut autograd_meta

    auto& x_grad = returns[0];
    std::vector<egr::AutogradMeta*> x_grad_autograd_meta_vec = egr::EagerUtils::autograd_meta(&x_grad);
    for(auto* meta : x_grad_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiplexGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto ins = egr::EagerUtils::RecoverTensorWrapper(&this->ins_);
  auto ids = egr::EagerUtils::RecoverTensorWrapper(&this->ids_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MultiplexGradNodeFinal";

  paddle::experimental::multiplex_grad(ins, ids, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiplex_grad", returns); }

  // Get GradOut autograd_meta

    auto& ins_grad = returns[0];
    std::vector<egr::AutogradMeta*> ins_grad_autograd_meta_vec = egr::EagerUtils::autograd_meta(&ins_grad);
    for(auto* meta : ins_grad_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiplyGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MultiplyGradNodeFinal";

  paddle::experimental::multiply_grad(x, y, grad_out, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("multiply_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiplyDoubleGradNodeFinal>(new MultiplyDoubleGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiplyDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& fwd_grad_grad_x = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_x_optional;
  if(fwd_grad_grad_x.initialized()) fwd_grad_grad_x_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_x);

  auto& fwd_grad_grad_y = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_y_optional;
  if(fwd_grad_grad_y.initialized()) fwd_grad_grad_y_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_y);

  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (fwd_grad_grad_x.initialized()) {
    VLOG(10) << fwd_grad_grad_x.name() << "(grad_x_grad) use_count: " << fwd_grad_grad_x.impl().use_count();
    if (fwd_grad_grad_x.impl().use_count() == 1 || (fwd_grad_grad_x.impl().use_count() == 2 && fwd_grad_grad_x.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_2 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(fwd_grad_grad_x, api_output_2);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: MultiplyDoubleGradNodeFinal";

  paddle::experimental::multiply_double_grad(x, y, fwd_grad_out, fwd_grad_grad_x_optional, fwd_grad_grad_y_optional, axis, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  

  auto& grad_grad_out = returns[2][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("multiply_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<MultiplyTripleGradNodeFinal>(new MultiplyTripleGradNodeFinal(3, 5));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(-1);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrapperfwd_grad_out(fwd_grad_out);
    grad_node->SetTensorWrapperfwd_grad_grad_x(fwd_grad_grad_x);
    grad_node->SetTensorWrapperfwd_grad_grad_y(fwd_grad_grad_y);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(y, 1);
    grad_node->SetGradOutMeta(fwd_grad_out, 2);
    grad_node->SetGradOutMeta(fwd_grad_grad_x, 3);
    grad_node->SetGradOutMeta(fwd_grad_grad_y, 4);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 2);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    grad_node->SetGradInMeta(grad_grad_out, 2);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiplyTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[1][0], input_metas[1][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[2][0], input_metas[2][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_out_);
  auto fwd_grad_grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_grad_x_);

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_x_optional;
  if( fwd_grad_grad_x.impl() ) fwd_grad_grad_x_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_x);

  auto fwd_grad_grad_y = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_grad_y_);

  paddle::optional<paddle::experimental::Tensor> fwd_grad_grad_y_optional;
  if( fwd_grad_grad_y.impl() ) fwd_grad_grad_y_optional = paddle::make_optional<paddle::experimental::Tensor>(fwd_grad_grad_y);

  auto& grad_x_grad = hooked_grads[0][0];
  auto& grad_y_grad = hooked_grads[1][0];
  auto& grad_grad_out_grad = hooked_grads[2][0];

  paddle::optional<paddle::experimental::Tensor> grad_grad_out_grad_optional;
  if(grad_grad_out_grad.initialized()) grad_grad_out_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_grad_out_grad);

  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(5);
  for (int i = 0; i < 5; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  auto* api_output_3 = (out_metas[3].empty() || out_metas[3][0].IsStopGradient()) ? nullptr : &returns[3][0];
  auto* api_output_4 = (out_metas[4].empty() || out_metas[4][0].IsStopGradient()) ? nullptr : &returns[4][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MultiplyTripleGradNodeFinal";

  paddle::experimental::multiply_triple_grad(x, y, fwd_grad_out, fwd_grad_grad_x_optional, fwd_grad_grad_y_optional, grad_x_grad, grad_y_grad, grad_grad_out_grad_optional, axis, api_output_0, api_output_1, api_output_2, api_output_3, api_output_4);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_out_grad = returns[2][0];
  egr::AutogradMeta* fwd_grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_out_grad) : nullptr;
  if (fwd_grad_out_grad_autograd_meta) fwd_grad_out_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_grad_x_grad = returns[3][0];
  egr::AutogradMeta* fwd_grad_grad_x_grad_autograd_meta = returns[3][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_grad_x_grad) : nullptr;
  if (fwd_grad_grad_x_grad_autograd_meta) fwd_grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_grad_y_grad = returns[4][0];
  egr::AutogradMeta* fwd_grad_grad_y_grad_autograd_meta = returns[4][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_grad_y_grad) : nullptr;
  if (fwd_grad_grad_y_grad_autograd_meta) fwd_grad_grad_y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> NllLossGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto weight = egr::EagerUtils::RecoverTensorWrapper(&this->weight_);

  paddle::optional<paddle::experimental::Tensor> weight_optional;
  if( weight.impl() ) weight_optional = paddle::make_optional<paddle::experimental::Tensor>(weight);

  auto total_weight = egr::EagerUtils::RecoverTensorWrapper(&this->total_weight_);
  auto& out_grad = hooked_grads[0][0];
  auto& ignore_index = this->ignore_index_;
  auto& reduction = this->reduction_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: NllLossGradNodeFinal";

  paddle::experimental::nll_loss_grad(input, label, weight_optional, total_weight, out_grad, ignore_index, reduction, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("nll_loss_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> NormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto norm = egr::EagerUtils::RecoverTensorWrapper(&this->norm_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& epsilon = this->epsilon_;
  auto& is_test = this->is_test_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: NormGradNodeFinal";

  paddle::experimental::norm_grad(x, norm, out_grad, axis, epsilon, is_test, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PNormGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& porder = this->porder_;
  auto& axis = this->axis_;
  auto& epsilon = this->epsilon_;
  auto& keepdim = this->keepdim_;
  auto& asvector = this->asvector_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PNormGradNodeFinal";

  paddle::experimental::p_norm_grad(x, out, out_grad, porder, axis, epsilon, keepdim, asvector, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("p_norm_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PadGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& paddings = this->paddings_;
  auto& pad_value = this->pad_value_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PadGradNodeFinal";

  paddle::experimental::pad_grad(x, grad_out, paddings, pad_value, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("pad_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<PadDoubleGradNodeFinal>(new PadDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributepad_value(pad_value);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PadDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& paddings = this->paddings_;
  auto& pad_value = this->pad_value_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PadDoubleGradNodeFinal";

  paddle::experimental::pad_double_grad(grad_x_grad, paddings, pad_value, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pad3dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& paddings = this->paddings_;
  auto& mode = this->mode_;
  auto& pad_value = this->pad_value_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pad3dGradNodeFinal";

  paddle::experimental::pad3d_grad(x, grad_out, paddings, mode, pad_value, data_format, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad3d_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("pad3d_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<Pad3dDoubleGradNodeFinal>(new Pad3dDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributemode(mode);
    grad_node->SetAttributepad_value(pad_value);
    grad_node->SetAttributedata_format(data_format);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pad3dDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& paddings = this->paddings_;
  auto& mode = this->mode_;
  auto& pad_value = this->pad_value_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pad3dDoubleGradNodeFinal";

  paddle::experimental::pad3d_double_grad(grad_x_grad, paddings, mode, pad_value, data_format, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pad3d_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PixelShuffleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& upscale_factor = this->upscale_factor_;
  auto& data_format = this->data_format_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PixelShuffleGradNodeFinal";

  paddle::experimental::pixel_shuffle_grad(out_grad, upscale_factor, data_format, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pixel_shuffle_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pool2dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& ceil_mode = this->ceil_mode_;
  auto& exclusive = this->exclusive_;
  auto& data_format = this->data_format_;
  auto& pooling_type = this->pooling_type_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  auto& padding_algorithm = this->padding_algorithm_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pool2dGradNodeFinal";

  paddle::experimental::pool2d_grad(x, out, grad_out, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool2d_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("pool2d_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<Pool2dDoubleGradNodeFinal>(new Pool2dDoubleGradNodeFinal(1, 3));
    // SetAttributes if needed
    grad_node->SetAttributekernel_size(kernel_size);
    grad_node->SetAttributestrides(strides);
    grad_node->SetAttributepaddings(paddings);
    grad_node->SetAttributeceil_mode(ceil_mode);
    grad_node->SetAttributeexclusive(exclusive);
    grad_node->SetAttributedata_format(data_format);
    grad_node->SetAttributepooling_type(pooling_type);
    grad_node->SetAttributeglobal_pooling(global_pooling);
    grad_node->SetAttributeadaptive(adaptive);
    grad_node->SetAttributepadding_algorithm(padding_algorithm);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pool2dDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& ceil_mode = this->ceil_mode_;
  auto& exclusive = this->exclusive_;
  auto& data_format = this->data_format_;
  auto& pooling_type = this->pooling_type_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  auto& padding_algorithm = this->padding_algorithm_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pool2dDoubleGradNodeFinal";

  paddle::experimental::pool2d_double_grad(grad_x_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool2d_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pool2dGradGpudnnUnusedGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& ceil_mode = this->ceil_mode_;
  auto& exclusive = this->exclusive_;
  auto& data_format = this->data_format_;
  auto& pooling_type = this->pooling_type_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  auto& padding_algorithm = this->padding_algorithm_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pool2dGradGpudnnUnusedGradNodeFinal";

  paddle::experimental::pool2d_grad_gpudnn_unused(x, out, out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool2d_grad_gpudnn_unused", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Pool3dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_size = this->kernel_size_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& ceil_mode = this->ceil_mode_;
  auto& exclusive = this->exclusive_;
  auto& data_format = this->data_format_;
  auto& pooling_type = this->pooling_type_;
  auto& global_pooling = this->global_pooling_;
  auto& adaptive = this->adaptive_;
  auto& padding_algorithm = this->padding_algorithm_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Pool3dGradNodeFinal";

  paddle::experimental::pool3d_grad(x, out, out_grad, kernel_size, strides, paddings, ceil_mode, exclusive, data_format, pooling_type, global_pooling, adaptive, padding_algorithm, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pool3d_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PowGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& s = this->s_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: PowGradNodeFinal";

  paddle::experimental::pow_grad(x, out_grad, s, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pow_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PreluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto alpha = egr::EagerUtils::RecoverTensorWrapper(&this->alpha_);
  auto& out_grad = hooked_grads[0][0];
  auto& data_format = this->data_format_;
  auto& mode = this->mode_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PreluGradNodeFinal";

  paddle::experimental::prelu_grad(x, alpha, out_grad, data_format, mode, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("prelu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& alpha_grad = returns[1][0];
  egr::AutogradMeta* alpha_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&alpha_grad) : nullptr;
  if (alpha_grad_autograd_meta) alpha_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PsroiPoolGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto boxes = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_);
  auto boxes_num = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_num_);

  paddle::optional<paddle::experimental::Tensor> boxes_num_optional;
  if( boxes_num.impl() ) boxes_num_optional = paddle::make_optional<paddle::experimental::Tensor>(boxes_num);

  auto& out_grad = hooked_grads[0][0];
  auto& pooled_height = this->pooled_height_;
  auto& pooled_width = this->pooled_width_;
  auto& output_channels = this->output_channels_;
  auto& spatial_scale = this->spatial_scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PsroiPoolGradNodeFinal";

  paddle::experimental::psroi_pool_grad(x, boxes, boxes_num_optional, out_grad, pooled_height, pooled_width, output_channels, spatial_scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("psroi_pool_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PutAlongAxisGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  auto& reduce = this->reduce_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PutAlongAxisGradNodeFinal";

  paddle::experimental::put_along_axis_grad(x, index, out_grad, axis, reduce, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("put_along_axis_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& value_grad = returns[2][0];
  egr::AutogradMeta* value_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&value_grad) : nullptr;
  if (value_grad_autograd_meta) value_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RealGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: RealGradNodeFinal";

  paddle::experimental::real_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("real_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReciprocalGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: ReciprocalGradNodeFinal";

  paddle::experimental::reciprocal_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reciprocal_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReduceProdGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ReduceProdGradNodeFinal";

  paddle::experimental::reduce_prod_grad(x, out, out_grad, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reduce_prod_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: ReluGradNodeFinal";

  paddle::experimental::relu_grad(out, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("relu_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ReluDoubleGradNodeFinal>(new ReluDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReluDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: ReluDoubleGradNodeFinal";

  paddle::experimental::relu_double_grad(out, grad_x_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Relu6GradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& threshold = this->threshold_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: Relu6GradNodeFinal";

  paddle::experimental::relu6_grad(out, out_grad, threshold, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu6_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReshapeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto xshape = egr::EagerUtils::RecoverTensorWrapper(&this->xshape_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: ReshapeGradNodeFinal";

  paddle::experimental::reshape_grad(xshape, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reshape_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("reshape_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ReshapeDoubleGradNodeFinal>(new ReshapeDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReshapeDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: ReshapeDoubleGradNodeFinal";

  paddle::experimental::reshape_double_grad(grad_out, grad_x_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("reshape_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RoiAlignGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto boxes = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_);
  auto boxes_num = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_num_);

  paddle::optional<paddle::experimental::Tensor> boxes_num_optional;
  if( boxes_num.impl() ) boxes_num_optional = paddle::make_optional<paddle::experimental::Tensor>(boxes_num);

  auto& out_grad = hooked_grads[0][0];
  auto& pooled_height = this->pooled_height_;
  auto& pooled_width = this->pooled_width_;
  auto& spatial_scale = this->spatial_scale_;
  auto& sampling_ratio = this->sampling_ratio_;
  auto& aligned = this->aligned_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: RoiAlignGradNodeFinal";

  paddle::experimental::roi_align_grad(x, boxes, boxes_num_optional, out_grad, pooled_height, pooled_width, spatial_scale, sampling_ratio, aligned, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roi_align_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RoiPoolGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto boxes = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_);
  auto boxes_num = egr::EagerUtils::RecoverTensorWrapper(&this->boxes_num_);

  paddle::optional<paddle::experimental::Tensor> boxes_num_optional;
  if( boxes_num.impl() ) boxes_num_optional = paddle::make_optional<paddle::experimental::Tensor>(boxes_num);

  auto arg_max = egr::EagerUtils::RecoverTensorWrapper(&this->arg_max_);
  auto& out_grad = hooked_grads[0][0];
  auto& pooled_height = this->pooled_height_;
  auto& pooled_width = this->pooled_width_;
  auto& spatial_scale = this->spatial_scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: RoiPoolGradNodeFinal";

  paddle::experimental::roi_pool_grad(x, boxes, boxes_num_optional, arg_max, out_grad, pooled_height, pooled_width, spatial_scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roi_pool_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RollGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& shifts = this->shifts_;
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: RollGradNodeFinal";

  paddle::experimental::roll_grad(x, out_grad, shifts, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("roll_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RoundGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: RoundGradNodeFinal";

  paddle::experimental::round_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("round_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RsqrtGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: RsqrtGradNodeFinal";

  paddle::experimental::rsqrt_grad(out, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("rsqrt_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("rsqrt_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<RsqrtDoubleGradNodeFinal>(new RsqrtDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappergrad_x(grad_x);
  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> RsqrtDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_x_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: RsqrtDoubleGradNodeFinal";

  paddle::experimental::rsqrt_double_grad(out, grad_x, grad_x_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("rsqrt_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& out_grad = returns[0][0];
  egr::AutogradMeta* out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&out_grad) : nullptr;
  if (out_grad_autograd_meta) out_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScaleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_out = hooked_grads[0][0];
  auto& scale = this->scale_;
  auto& bias = this->bias_;
  auto& bias_after_scale = this->bias_after_scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: ScaleGradNodeFinal";

  paddle::experimental::scale_grad(grad_out, scale, bias, bias_after_scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("scale_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ScaleDoubleGradNodeFinal>(new ScaleDoubleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributebias(bias);
    grad_node->SetAttributebias_after_scale(bias_after_scale);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScaleDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_grad_x = hooked_grads[0][0];
  auto& scale = this->scale_;
  auto& bias = this->bias_;
  auto& bias_after_scale = this->bias_after_scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ScaleDoubleGradNodeFinal";

  paddle::experimental::scale_double_grad(grad_grad_x, scale, bias, bias_after_scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_out = returns[0][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("scale_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<ScaleTripleGradNodeFinal>(new ScaleTripleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributescale(scale);
    grad_node->SetAttributebias(bias);
    grad_node->SetAttributebias_after_scale(bias_after_scale);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_grad_x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 0);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_grad_out, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScaleTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_grad_out_grad = hooked_grads[0][0];
  auto& scale = this->scale_;
  auto& bias = this->bias_;
  auto& bias_after_scale = this->bias_after_scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ScaleTripleGradNodeFinal";

  paddle::experimental::scale_triple_grad(grad_grad_out_grad, scale, bias, bias_after_scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_x_grad = returns[0][0];
  egr::AutogradMeta* grad_grad_x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_x_grad) : nullptr;
  if (grad_grad_x_grad_autograd_meta) grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScatterGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto updates = egr::EagerUtils::RecoverTensorWrapper(&this->updates_);
  auto& out_grad = hooked_grads[0][0];
  auto& overwrite = this->overwrite_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ScatterGradNodeFinal";

  paddle::experimental::scatter_grad(index, updates, out_grad, overwrite, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scatter_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& updates_grad = returns[2][0];
  egr::AutogradMeta* updates_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&updates_grad) : nullptr;
  if (updates_grad_autograd_meta) updates_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScatterNdAddGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto updates = egr::EagerUtils::RecoverTensorWrapper(&this->updates_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ScatterNdAddGradNodeFinal";

  paddle::experimental::scatter_nd_add_grad(index, updates, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scatter_nd_add_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& updates_grad = returns[2][0];
  egr::AutogradMeta* updates_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&updates_grad) : nullptr;
  if (updates_grad_autograd_meta) updates_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SegmentPoolGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto segment_ids = egr::EagerUtils::RecoverTensorWrapper(&this->segment_ids_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto summed_ids = egr::EagerUtils::RecoverTensorWrapper(&this->summed_ids_);

  paddle::optional<paddle::experimental::Tensor> summed_ids_optional;
  if( summed_ids.impl() ) summed_ids_optional = paddle::make_optional<paddle::experimental::Tensor>(summed_ids);

  auto& out_grad = hooked_grads[0][0];
  auto& pooltype = this->pooltype_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SegmentPoolGradNodeFinal";

  paddle::experimental::segment_pool_grad(x, segment_ids, out, summed_ids_optional, out_grad, pooltype, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("segment_pool_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SeluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& scale = this->scale_;
  auto& alpha = this->alpha_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SeluGradNodeFinal";

  paddle::experimental::selu_grad(out, out_grad, scale, alpha, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("selu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SigmoidGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& fwd_grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (fwd_grad_out.initialized()) {
    VLOG(10) << fwd_grad_out.name() << "(out_grad) use_count: " << fwd_grad_out.impl().use_count();
    if (fwd_grad_out.impl().use_count() == 1 || (fwd_grad_out.impl().use_count() == 2 && fwd_grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(fwd_grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SigmoidGradNodeFinal";

  paddle::experimental::sigmoid_grad(out, fwd_grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SigmoidDoubleGradNodeFinal>(new SigmoidDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrapperfwd_grad_out(fwd_grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(fwd_grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SigmoidDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_out_);
  auto& grad_grad_x = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_grad_x.initialized()) {
    VLOG(10) << grad_grad_x.name() << "(grad_x_grad) use_count: " << grad_grad_x.impl().use_count();
    if (grad_grad_x.impl().use_count() == 1 || (grad_grad_x.impl().use_count() == 2 && grad_grad_x.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_grad_x, api_output_1);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SigmoidDoubleGradNodeFinal";

  paddle::experimental::sigmoid_double_grad(out, fwd_grad_out, grad_grad_x, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out = returns[0][0];
  egr::AutogradMeta* grad_out_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out) : nullptr;
  if (grad_out_autograd_meta) grad_out_autograd_meta->SetStopGradient(false);
  

  auto& grad_grad_out = returns[1][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("sigmoid_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SigmoidTripleGradNodeFinal>(new SigmoidTripleGradNodeFinal(2, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrapperfwd_grad_out(fwd_grad_out);
    grad_node->SetTensorWrappergrad_grad_x(grad_grad_x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(fwd_grad_out, 1);
    grad_node->SetGradOutMeta(grad_grad_x, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_out_autograd_meta, 0);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 1);
    }
    if (grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_out_autograd_meta, grad_node);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_out, 0);
    grad_node->SetGradInMeta(grad_grad_out, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_out);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SigmoidTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto fwd_grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->fwd_grad_out_);
  auto grad_grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_grad_x_);
  auto& grad_out_grad = hooked_grads[0][0];
  auto& grad_grad_out_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_grad_out_grad_optional;
  if(grad_grad_out_grad.initialized()) grad_grad_out_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_grad_out_grad);

  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_grad_x.initialized()) {
    VLOG(10) << grad_grad_x.name() << "(grad_grad_x) use_count: " << grad_grad_x.impl().use_count();
    if (grad_grad_x.impl().use_count() == 1 || (grad_grad_x.impl().use_count() == 2 && grad_grad_x.impl().get() == (&this->grad_grad_x_)->get_intermidiate_tensor().impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_grad_x, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SigmoidTripleGradNodeFinal";

  paddle::experimental::sigmoid_triple_grad(out, fwd_grad_out, grad_grad_x, grad_out_grad, grad_grad_out_grad_optional, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& out_grad = returns[0][0];
  egr::AutogradMeta* out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&out_grad) : nullptr;
  if (out_grad_autograd_meta) out_grad_autograd_meta->SetStopGradient(false);
  

  auto& fwd_grad_out_grad = returns[1][0];
  egr::AutogradMeta* fwd_grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&fwd_grad_out_grad) : nullptr;
  if (fwd_grad_out_grad_autograd_meta) fwd_grad_out_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_grad_x_grad = returns[2][0];
  egr::AutogradMeta* grad_grad_x_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_x_grad) : nullptr;
  if (grad_grad_x_grad_autograd_meta) grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SigmoidCrossEntropyWithLogitsGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto label = egr::EagerUtils::RecoverTensorWrapper(&this->label_);
  auto& out_grad = hooked_grads[0][0];
  auto& normalize = this->normalize_;
  auto& ignore_index = this->ignore_index_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SigmoidCrossEntropyWithLogitsGradNodeFinal";

  paddle::experimental::sigmoid_cross_entropy_with_logits_grad(x, label, out_grad, normalize, ignore_index, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sigmoid_cross_entropy_with_logits_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SiluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SiluGradNodeFinal";

  paddle::experimental::silu_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("silu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SinGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SinGradNodeFinal";

  paddle::experimental::sin_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sin_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SinhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SinhGradNodeFinal";

  paddle::experimental::sinh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sinh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SliceGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto input = egr::EagerUtils::RecoverTensorWrapper(&this->input_);
  auto& grad_out = hooked_grads[0][0];
  auto& axes = this->axes_;
  auto& starts = this->starts_;
  auto& ends = this->ends_;
  auto& infer_flags = this->infer_flags_;
  auto& decrease_axis = this->decrease_axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SliceGradNodeFinal";

  paddle::experimental::slice_grad(input, grad_out, axes, starts, ends, infer_flags, decrease_axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("slice_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_input = returns[0][0];
  egr::AutogradMeta* grad_input_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_input) : nullptr;
  if (grad_input_autograd_meta) grad_input_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("slice_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SliceDoubleGradNodeFinal>(new SliceDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    grad_node->SetAttributestarts(starts);
    grad_node->SetAttributeends(ends);
    grad_node->SetAttributeinfer_flags(infer_flags);
    grad_node->SetAttributedecrease_axis(decrease_axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_input_autograd_meta, 0);
    }
    if (grad_input_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_input_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_input, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_input);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SliceDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_input_grad = hooked_grads[0][0];
  auto& axes = this->axes_;
  auto& starts = this->starts_;
  auto& ends = this->ends_;
  auto& infer_flags = this->infer_flags_;
  auto& decrease_axis = this->decrease_axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SliceDoubleGradNodeFinal";

  paddle::experimental::slice_double_grad(grad_input_grad, axes, starts, ends, infer_flags, decrease_axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("slice_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SoftShrinkGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& lambda = this->lambda_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SoftShrinkGradNodeFinal";

  paddle::experimental::soft_shrink_grad(x, out_grad, lambda, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("soft_shrink_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SoftmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SoftmaxGradNodeFinal";

  paddle::experimental::softmax_grad(out, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("softmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SplitGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0], input_metas[0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SplitGradNodeFinal";

  paddle::experimental::split_grad(out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("split_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SqrtGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SqrtGradNodeFinal";

  paddle::experimental::sqrt_grad(out, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sqrt_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("sqrt_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SqrtDoubleGradNodeFinal>(new SqrtDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed
    grad_node->SetTensorWrappergrad_x(grad_x);
  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SqrtDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_x_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SqrtDoubleGradNodeFinal";

  paddle::experimental::sqrt_double_grad(out, grad_x, grad_x_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sqrt_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& out_grad = returns[0][0];
  egr::AutogradMeta* out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&out_grad) : nullptr;
  if (out_grad_autograd_meta) out_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SquareGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SquareGradNodeFinal";

  paddle::experimental::square_grad(x, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("square_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("square_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SquareDoubleGradNodeFinal>(new SquareDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperx(x);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(x, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SquareDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SquareDoubleGradNodeFinal";

  paddle::experimental::square_double_grad(x, grad_out, grad_x_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("square_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SqueezeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto xshape = egr::EagerUtils::RecoverTensorWrapper(&this->xshape_);
  auto& grad_out = hooked_grads[0][0];
  auto& axes = this->axes_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SqueezeGradNodeFinal";

  paddle::experimental::squeeze_grad(xshape, grad_out, axes, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("squeeze_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("squeeze_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SqueezeDoubleGradNodeFinal>(new SqueezeDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SqueezeDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& axes = this->axes_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SqueezeDoubleGradNodeFinal";

  paddle::experimental::squeeze_double_grad(grad_x_grad, axes, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("squeeze_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> StackGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  std::vector<paddle::experimental::Tensor*> api_output_0;
  api_output_0.reserve(returns[0].size());
  for (size_t i = 0; i < returns[0].size(); ++i) {
    if (out_metas[0].empty() || out_metas[0][i].IsStopGradient()) {
      api_output_0.push_back(nullptr);
    } else {
      api_output_0.push_back(&returns[0][i]);
    }
  }
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: StackGradNodeFinal";

  paddle::experimental::stack_grad(x, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("stack_grad", returns); }

  // Get GradOut autograd_meta

    auto& x_grad = returns[0];
    std::vector<egr::AutogradMeta*> x_grad_autograd_meta_vec = egr::EagerUtils::autograd_meta(&x_grad);
    for(auto* meta : x_grad_autograd_meta_vec){
        meta->SetStopGradient(false);
    }

  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> StridedSliceGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& axes = this->axes_;
  auto& starts = this->starts_;
  auto& ends = this->ends_;
  auto& strides = this->strides_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: StridedSliceGradNodeFinal";

  paddle::experimental::strided_slice_grad(x, out_grad, axes, starts, ends, strides, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("strided_slice_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SubtractGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: SubtractGradNodeFinal";

  paddle::experimental::subtract_grad(x, y, grad_out, axis, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("subtract_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  

  auto& grad_y = returns[1][0];
  egr::AutogradMeta* grad_y_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_y) : nullptr;
  if (grad_y_autograd_meta) grad_y_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("subtract_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SubtractDoubleGradNodeFinal>(new SubtractDoubleGradNodeFinal(2, 3));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappery(y);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_y_autograd_meta, 1);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    if (grad_y_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_y_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    grad_node->SetGradInMeta(grad_y, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    egr::EagerUtils::CheckAndRetainGrad(grad_y);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SubtractDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyOptionalGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto grad_out = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad = hooked_grads[0][0];

  paddle::optional<paddle::experimental::Tensor> grad_x_grad_optional;
  if(grad_x_grad.initialized()) grad_x_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_x_grad);

  auto& grad_y_grad = hooked_grads[1][0];

  paddle::optional<paddle::experimental::Tensor> grad_y_grad_optional;
  if(grad_y_grad.initialized()) grad_y_grad_optional = paddle::make_optional<paddle::experimental::Tensor>(grad_y_grad);

  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad.initialized()) {
    VLOG(10) << grad_x_grad.name() << "(grad_x_grad) use_count: " << grad_x_grad.impl().use_count();
    if (grad_x_grad.impl().use_count() == 1 || (grad_x_grad.impl().use_count() == 2 && grad_x_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SubtractDoubleGradNodeFinal";

  paddle::experimental::subtract_double_grad(y, grad_out, grad_x_grad_optional, grad_y_grad_optional, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("subtract_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[2][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SumGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SumGradNodeFinal";

  paddle::experimental::sum_grad(x, grad_out, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sum_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("sum_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SumDoubleGradNodeFinal>(new SumDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SumDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_grad_x = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SumDoubleGradNodeFinal";

  paddle::experimental::sum_double_grad(grad_grad_x, dims, keep_dim, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sum_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_out = returns[1][0];
  egr::AutogradMeta* grad_grad_out_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_out) : nullptr;
  if (grad_grad_out_autograd_meta) grad_grad_out_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("sum_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<SumTripleGradNodeFinal>(new SumTripleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributedims(dims);
    grad_node->SetAttributekeep_dim(keep_dim);
    grad_node->SetAttributereduce_all(false);
    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrappergrad_grad_x(grad_grad_x);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_grad_x, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_grad_out_autograd_meta, 0);
    }
    if (grad_grad_out_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_grad_out_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_grad_out, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_grad_out);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SumTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto grad_grad_x = egr::EagerUtils::RecoverTensorWrapper(&this->grad_grad_x_);
  auto& grad_grad_out_grad = hooked_grads[0][0];
  auto& dims = this->dims_;
  auto& keep_dim = this->keep_dim_;
  auto& reduce_all = this->reduce_all_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SumTripleGradNodeFinal";

  paddle::experimental::sum_triple_grad(grad_grad_x, grad_grad_out_grad, dims, keep_dim, reduce_all, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sum_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_grad_x_grad = returns[0][0];
  egr::AutogradMeta* grad_grad_x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_grad_x_grad) : nullptr;
  if (grad_grad_x_grad_autograd_meta) grad_grad_x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SwishGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& bete = this->bete_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: SwishGradNodeFinal";

  paddle::experimental::swish_grad(x, out_grad, bete, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("swish_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TakeAlongAxisGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto index = egr::EagerUtils::RecoverTensorWrapper(&this->index_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TakeAlongAxisGradNodeFinal";

  paddle::experimental::take_along_axis_grad(x, index, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("take_along_axis_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: TanGradNodeFinal";

  paddle::experimental::tan_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tan_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& grad_out = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: TanhGradNodeFinal";

  paddle::experimental::tanh_grad(out, grad_out, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("tanh_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<TanhDoubleGradNodeFinal>(new TanhDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrappergrad_out(grad_out);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanhDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto grad_out_forward = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_);
  auto& grad_x_grad_forward = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad_forward.initialized()) {
    VLOG(10) << grad_x_grad_forward.name() << "(grad_x_grad) use_count: " << grad_x_grad_forward.impl().use_count();
    if (grad_x_grad_forward.impl().use_count() == 1 || (grad_x_grad_forward.impl().use_count() == 2 && grad_x_grad_forward.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    VLOG(6) << "No Inplace should happend for wrappered input: {inplace_grad_input_str}";
  } else {
     if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad_forward, api_output_1);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: TanhDoubleGradNodeFinal";

  paddle::experimental::tanh_double_grad(out, grad_out_forward, grad_x_grad_forward, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_new = returns[0][0];
  egr::AutogradMeta* grad_out_new_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_new) : nullptr;
  if (grad_out_new_autograd_meta) grad_out_new_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("tanh_double_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<TanhTripleGradNodeFinal>(new TanhTripleGradNodeFinal(2, 3));
    // SetAttributes if needed

    // Set TensorWrappers for Forward Inputs if needed
    grad_node->SetTensorWrapperout(out);
    grad_node->SetTensorWrappergrad_out_forward(grad_out_forward);
    grad_node->SetTensorWrappergrad_x_grad_forward(grad_x_grad_forward);
    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(out, 0);
    grad_node->SetGradOutMeta(grad_out_forward, 1);
    grad_node->SetGradOutMeta(grad_x_grad_forward, 2);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_out_new_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_out_new_autograd_meta, 0);
    }
    if (grad_out_grad_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_out_grad_autograd_meta, 1);
    }
    if (grad_out_new_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_out_new_autograd_meta, grad_node);
    }
    if (grad_out_grad_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_out_grad_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_out_new, 0);
    grad_node->SetGradInMeta(grad_out_grad, 1);
    egr::EagerUtils::CheckAndRetainGrad(grad_out_new);
    egr::EagerUtils::CheckAndRetainGrad(grad_out_grad);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanhTripleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[1][0], input_metas[1][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto grad_out_forward = egr::EagerUtils::RecoverTensorWrapper(&this->grad_out_forward_);
  auto grad_x_grad_forward = egr::EagerUtils::RecoverTensorWrapper(&this->grad_x_grad_forward_);
  auto& grad_out_new_grad = hooked_grads[0][0];
  auto& grad_out_grad_grad = hooked_grads[1][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_x_grad_forward.initialized()) {
    VLOG(10) << grad_x_grad_forward.name() << "(grad_x_grad_forward) use_count: " << grad_x_grad_forward.impl().use_count();
    if (grad_x_grad_forward.impl().use_count() == 1 || (grad_x_grad_forward.impl().use_count() == 2 && grad_x_grad_forward.impl().get() == (&this->grad_x_grad_forward_)->get_intermidiate_tensor().impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_1 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_x_grad_forward, api_output_1);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: TanhTripleGradNodeFinal";

  paddle::experimental::tanh_triple_grad(out, grad_out_forward, grad_x_grad_forward, grad_out_new_grad, grad_out_grad_grad, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_triple_grad", returns); }

  // Get GradOut autograd_meta

  auto& out_grad = returns[0][0];
  egr::AutogradMeta* out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&out_grad) : nullptr;
  if (out_grad_autograd_meta) out_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_out_forward_grad = returns[1][0];
  egr::AutogradMeta* grad_out_forward_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_forward_grad) : nullptr;
  if (grad_out_forward_grad_autograd_meta) grad_out_forward_grad_autograd_meta->SetStopGradient(false);
  

  auto& grad_x_grad_forward_grad = returns[2][0];
  egr::AutogradMeta* grad_x_grad_forward_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x_grad_forward_grad) : nullptr;
  if (grad_x_grad_forward_grad_autograd_meta) grad_x_grad_forward_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanhShrinkGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: TanhShrinkGradNodeFinal";

  paddle::experimental::tanh_shrink_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_shrink_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ThresholdedReluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& threshold = this->threshold_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  bool can_be_inplaced = false;
  if (out_grad.initialized()) {
    VLOG(10) << out_grad.name() << "(out_grad) use_count: " << out_grad.impl().use_count();
    if (out_grad.impl().use_count() == 1 || (out_grad.impl().use_count() == 2 && out_grad.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy
 if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(out_grad, api_output_0);
    }
  // Call grad_api function
  VLOG(3) << "Final State Running: ThresholdedReluGradNodeFinal";

  paddle::experimental::thresholded_relu_grad(x, out_grad, threshold, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("thresholded_relu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TileGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& grad_out = hooked_grads[0][0];
  auto& repeat_times = this->repeat_times_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TileGradNodeFinal";

  paddle::experimental::tile_grad(x, grad_out, repeat_times, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tile_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("tile_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<TileDoubleGradNodeFinal>(new TileDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributerepeat_times(repeat_times);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TileDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& repeat_times = this->repeat_times_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TileDoubleGradNodeFinal";

  paddle::experimental::tile_double_grad(grad_x_grad, repeat_times, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tile_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TopKGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto indices = egr::EagerUtils::RecoverTensorWrapper(&this->indices_);
  auto& out_grad = hooked_grads[0][0];
  auto& k = this->k_;
  auto& axis = this->axis_;
  auto& largest = this->largest_;
  auto& sorted = this->sorted_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TopKGradNodeFinal";

  paddle::experimental::top_k_grad(x, indices, out_grad, k, axis, largest, sorted, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("top_k_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TransposeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_out = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TransposeGradNodeFinal";

  paddle::experimental::transpose_grad(grad_out, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("transpose_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("transpose_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<TransposeDoubleGradNodeFinal>(new TransposeDoubleGradNodeFinal(1, 1));
    // SetAttributes if needed
    grad_node->SetAttributeaxis(axis);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 0);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TransposeDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TransposeDoubleGradNodeFinal";

  paddle::experimental::transpose_double_grad(grad_x_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("transpose_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[0][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TriangularSolveGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& upper = this->upper_;
  auto& tranpose = this->tranpose_;
  auto& unitriangular = this->unitriangular_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TriangularSolveGradNodeFinal";

  paddle::experimental::triangular_solve_grad(x, y, out, out_grad, upper, tranpose, unitriangular, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("triangular_solve_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TrilTriuGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& diagonal = this->diagonal_;
  auto& lower = this->lower_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TrilTriuGradNodeFinal";

  paddle::experimental::tril_triu_grad(out_grad, diagonal, lower, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tril_triu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> UnbindGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: UnbindGradNodeFinal";

  paddle::experimental::unbind_grad(out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unbind_grad", returns); }

  // Get GradOut autograd_meta

  auto& input_grad = returns[0][0];
  egr::AutogradMeta* input_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&input_grad) : nullptr;
  if (input_grad_autograd_meta) input_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> UnfoldGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_sizes = this->kernel_sizes_;
  auto& strides = this->strides_;
  auto& paddings = this->paddings_;
  auto& dilations = this->dilations_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: UnfoldGradNodeFinal";

  paddle::experimental::unfold_grad(x, out_grad, kernel_sizes, strides, paddings, dilations, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unfold_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> UnsqueezeGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto xshape = egr::EagerUtils::RecoverTensorWrapper(&this->xshape_);
  auto& grad_out = hooked_grads[0][0];
  auto& axes = this->axes_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad
  bool trace_backward = egr::Controller::Instance().HasGrad() && create_graph;

  // Inplace Check

  bool can_be_inplaced = false;
  if (grad_out.initialized()) {
    VLOG(10) << grad_out.name() << "(out_grad) use_count: " << grad_out.impl().use_count();
    if (grad_out.impl().use_count() == 1 || (grad_out.impl().use_count() == 2 && grad_out.impl().get() == grads[0][0].impl().get())) {
      can_be_inplaced = true;
    }
  }
  // Inplace Strategy

  if (trace_backward) {
    if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  } else {
     if (api_output_0 != nullptr && can_be_inplaced) {
      egr::EagerUtils::HandleViewBetweenInputAndOutput(grad_out, api_output_0);
    }
  }
  // Call grad_api function
  VLOG(3) << "Final State Running: UnsqueezeGradNodeFinal";

  paddle::experimental::unsqueeze_grad(xshape, grad_out, axes, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unsqueeze_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_x = returns[0][0];
  egr::AutogradMeta* grad_x_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_x) : nullptr;
  if (grad_x_autograd_meta) grad_x_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node
  if(trace_backward) {
    paddle::platform::RecordEvent node_creation_record_event("unsqueeze_grad node_creation", paddle::platform::TracerEventType::OperatorInner, 1);

    // Node Construction
    auto grad_node = std::shared_ptr<UnsqueezeDoubleGradNodeFinal>(new UnsqueezeDoubleGradNodeFinal(1, 2));
    // SetAttributes if needed
    grad_node->SetAttributeaxes(axes);
    // Set TensorWrappers for Forward Inputs if needed

    // SetGradOutMeta & SetEdges
    grad_node->SetGradOutMeta(grad_out, 1);
    // SetOutRank & SetHistory & SetGradInMeta & RetainGrad
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetOutRankWithSlot(grad_x_autograd_meta, 0);
    }
    if (grad_x_autograd_meta) {
      egr::EagerUtils::SetHistory(grad_x_autograd_meta, grad_node);
    }
    grad_node->SetGradInMeta(grad_x, 0);
    egr::EagerUtils::CheckAndRetainGrad(grad_x);
    // Set TensorWrappers for Forward Outputs if needed

  }

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> UnsqueezeDoubleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& grad_x_grad = hooked_grads[0][0];
  auto& axes = this->axes_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: UnsqueezeDoubleGradNodeFinal";

  paddle::experimental::unsqueeze_double_grad(grad_x_grad, axes, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("unsqueeze_double_grad", returns); }

  // Get GradOut autograd_meta

  auto& grad_out_grad = returns[1][0];
  egr::AutogradMeta* grad_out_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&grad_out_grad) : nullptr;
  if (grad_out_grad_autograd_meta) grad_out_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> WhereGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto condition = egr::EagerUtils::RecoverTensorWrapper(&this->condition_);
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_1 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: WhereGradNodeFinal";

  paddle::experimental::where_grad(condition, x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("where_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[1][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[2][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}



namespace sparse {
    
paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AbsGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AbsGradNodeFinal";

  paddle::experimental::sparse::abs_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("abs_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AcosGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AcosGradNodeFinal";

  paddle::experimental::sparse::acos_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acos_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AcoshGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AcoshGradNodeFinal";

  paddle::experimental::sparse::acosh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("acosh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AddGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AddGradNodeFinal";

  paddle::experimental::sparse::add_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("add_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AsinGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AsinGradNodeFinal";

  paddle::experimental::sparse::asin_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asin_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AsinhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AsinhGradNodeFinal";

  paddle::experimental::sparse::asinh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("asinh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AtanGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AtanGradNodeFinal";

  paddle::experimental::sparse::atan_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atan_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> AtanhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: AtanhGradNodeFinal";

  paddle::experimental::sparse::atanh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("atanh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CastGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& value_dtype = this->value_dtype_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CastGradNodeFinal";

  paddle::experimental::sparse::cast_grad(x, out_grad, value_dtype, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("cast_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Conv3dGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto kernel = egr::EagerUtils::RecoverTensorWrapper(&this->kernel_);
  auto rulebook = egr::EagerUtils::RecoverTensorWrapper(&this->rulebook_);
  auto& out_grad = hooked_grads[0][0];
  auto& paddings = this->paddings_;
  auto& dilations = this->dilations_;
  auto& strides = this->strides_;
  auto& groups = this->groups_;
  auto& subm = this->subm_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Conv3dGradNodeFinal";

  paddle::experimental::sparse::conv3d_grad(x, kernel, rulebook, out_grad, paddings, dilations, strides, groups, subm, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("conv3d_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& kernel_grad = returns[1][0];
  egr::AutogradMeta* kernel_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&kernel_grad) : nullptr;
  if (kernel_grad_autograd_meta) kernel_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CooToDenseGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CooToDenseGradNodeFinal";

  paddle::experimental::sparse::coo_to_dense_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("coo_to_dense_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> CreateSparseCooTensorGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto indices = egr::EagerUtils::RecoverTensorWrapper(&this->indices_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: CreateSparseCooTensorGradNodeFinal";

  paddle::experimental::sparse::create_sparse_coo_tensor_grad(indices, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("create_sparse_coo_tensor_grad", returns); }

  // Get GradOut autograd_meta

  auto& values_grad = returns[0][0];
  egr::AutogradMeta* values_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&values_grad) : nullptr;
  if (values_grad_autograd_meta) values_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DenseToCooGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DenseToCooGradNodeFinal";

  paddle::experimental::sparse::dense_to_coo_grad(out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("dense_to_coo_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DivideGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DivideGradNodeFinal";

  paddle::experimental::sparse::divide_grad(x, y, out, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> DivideScalarGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& scalar = this->scalar_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: DivideScalarGradNodeFinal";

  paddle::experimental::sparse::divide_scalar_grad(out_grad, scalar, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("divide_scalar_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> Log1pGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: Log1pGradNodeFinal";

  paddle::experimental::sparse::log1p_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("log1p_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MultiplyGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors
  const auto& input_metas = this->InputMeta();
  egr::EagerUtils::FillZeroForEmptyGradInput(&grads[0][0], input_metas[0][0]);

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MultiplyGradNodeFinal";

  paddle::experimental::sparse::multiply_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("multiply_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> PowGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  auto& factor = this->factor_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: PowGradNodeFinal";

  paddle::experimental::sparse::pow_grad(x, out_grad, factor, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("pow_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ReluGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ReluGradNodeFinal";

  paddle::experimental::sparse::relu_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("relu_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ScaleGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto& out_grad = hooked_grads[0][0];
  auto& scale = this->scale_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ScaleGradNodeFinal";

  paddle::experimental::sparse::scale_grad(out_grad, scale, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("scale_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SinGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SinGradNodeFinal";

  paddle::experimental::sparse::sin_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sin_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SinhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SinhGradNodeFinal";

  paddle::experimental::sparse::sinh_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sinh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SoftmaxGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& axis = this->axis_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SoftmaxGradNodeFinal";

  paddle::experimental::sparse::softmax_grad(out, out_grad, axis, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("softmax_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SqrtGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SqrtGradNodeFinal";

  paddle::experimental::sparse::sqrt_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sqrt_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SquareGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SquareGradNodeFinal";

  paddle::experimental::sparse::square_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("square_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SubtractGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SubtractGradNodeFinal";

  paddle::experimental::sparse::subtract_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("subtract_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TanGradNodeFinal";

  paddle::experimental::sparse::tan_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tan_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> TanhGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: TanhGradNodeFinal";

  paddle::experimental::sparse::tanh_grad(out, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("tanh_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> ValuesGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: ValuesGradNodeFinal";

  paddle::experimental::sparse::values_grad(x, out_grad, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("values_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> FusedAttentionGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto query = egr::EagerUtils::RecoverTensorWrapper(&this->query_);
  auto key = egr::EagerUtils::RecoverTensorWrapper(&this->key_);
  auto value = egr::EagerUtils::RecoverTensorWrapper(&this->value_);
  auto softmax = egr::EagerUtils::RecoverTensorWrapper(&this->softmax_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(6);
  for (int i = 0; i < 6; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  auto* api_output_2 = (out_metas[2].empty() || out_metas[2][0].IsStopGradient()) ? nullptr : &returns[2][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: FusedAttentionGradNodeFinal";

  paddle::experimental::sparse::fused_attention_grad(query, key, value, softmax, out_grad, api_output_0, api_output_1, api_output_2);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("fused_attention_grad", returns); }

  // Get GradOut autograd_meta

  auto& query_grad = returns[0][0];
  egr::AutogradMeta* query_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&query_grad) : nullptr;
  if (query_grad_autograd_meta) query_grad_autograd_meta->SetStopGradient(false);
  

  auto& key_grad = returns[1][0];
  egr::AutogradMeta* key_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&key_grad) : nullptr;
  if (key_grad_autograd_meta) key_grad_autograd_meta->SetStopGradient(false);
  

  auto& value_grad = returns[2][0];
  egr::AutogradMeta* value_grad_autograd_meta = returns[2][0].initialized() ? egr::EagerUtils::autograd_meta(&value_grad) : nullptr;
  if (value_grad_autograd_meta) value_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MaskedMatmulGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(3);
  for (int i = 0; i < 3; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MaskedMatmulGradNodeFinal";

  paddle::experimental::sparse::masked_matmul_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("masked_matmul_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MatmulGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto y = egr::EagerUtils::RecoverTensorWrapper(&this->y_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MatmulGradNodeFinal";

  paddle::experimental::sparse::matmul_grad(x, y, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("matmul_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& y_grad = returns[1][0];
  egr::AutogradMeta* y_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&y_grad) : nullptr;
  if (y_grad_autograd_meta) y_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> SparseMaxpoolGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto rulebook = egr::EagerUtils::RecoverTensorWrapper(&this->rulebook_);
  auto out = egr::EagerUtils::RecoverTensorWrapper(&this->out_);
  auto& out_grad = hooked_grads[0][0];
  auto& kernel_sizes = this->kernel_sizes_;
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(1);
  for (int i = 0; i < 1; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: SparseMaxpoolGradNodeFinal";

  paddle::experimental::sparse::sparse_maxpool_grad(x, rulebook, out, out_grad, kernel_sizes, api_output_0);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("sparse_maxpool_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> MvGradNodeFinal::operator()(paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize>& grads, bool create_graph, bool is_new_grad) {
  // Fill Zero For GradIn Tensors

  // Apply Gradient Hooks
  auto hooked_grads = ApplyGradientHooks(grads);

  // Collect GradIn Tensors, Attrs and Recovered TensorWrappers
  auto x = egr::EagerUtils::RecoverTensorWrapper(&this->x_);
  auto vec = egr::EagerUtils::RecoverTensorWrapper(&this->vec_);
  auto& out_grad = hooked_grads[0][0];
  // Prepare Grad function call

  const auto& out_metas = OutputMeta();
  paddle::small_vector<std::vector<paddle::experimental::Tensor>, egr::kSlotSmallVectorSize> returns(2);
  for (int i = 0; i < 2; ++i) {
    out_metas[i].size() == 0 ? returns[i].resize(1) : returns[i].resize(out_metas[i].size());
  }

  auto* api_output_0 = (out_metas[0].empty() || out_metas[0][0].IsStopGradient()) ? nullptr : &returns[0][0];
  auto* api_output_1 = (out_metas[1].empty() || out_metas[1][0].IsStopGradient()) ? nullptr : &returns[1][0];
  // Runtime check if we need next grad

  // Inplace Check

  // Inplace Strategy

  // Call grad_api function
  VLOG(3) << "Final State Running: MvGradNodeFinal";

  paddle::experimental::sparse::mv_grad(x, vec, out_grad, api_output_0, api_output_1);
  // Check NaN and Inf id needed
  if (FLAGS_check_nan_inf) { egr::CheckTensorHasNanOrInf("mv_grad", returns); }

  // Get GradOut autograd_meta

  auto& x_grad = returns[0][0];
  egr::AutogradMeta* x_grad_autograd_meta = returns[0][0].initialized() ? egr::EagerUtils::autograd_meta(&x_grad) : nullptr;
  if (x_grad_autograd_meta) x_grad_autograd_meta->SetStopGradient(false);
  

  auto& vec_grad = returns[1][0];
  egr::AutogradMeta* vec_grad_autograd_meta = returns[1][0].initialized() ? egr::EagerUtils::autograd_meta(&vec_grad) : nullptr;
  if (vec_grad_autograd_meta) vec_grad_autograd_meta->SetStopGradient(false);
  
  // Create Grad Node

  // Return
  if(NeedComplexToRealConversion()) HandleComplexGradToRealGrad(&returns);
  return returns;

}


}


