# <div align="center"><strong>OpenManus</strong></div>

## 简介

OpenManus是由MetaGPT团队推出的开源项目，旨在复刻Manus的核心功能。基于ReAct模式运行，可调用多种工具。


## 安装

组件支持

+ Python 3.11

### 使用Docker进行安装

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-py3.11-dtk24.04.3-ubuntu20.04

docker run --shm-size 50g --network=host --name=openmanus --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

pip install -r requirements.txt

playwright install

playwright install-deps
```

## 模型

本项目支持多种模型，要求模型具备tool_call能力。在`config/config.toml`中修改相应配置即可。

### 本地模型源

- [ollama](https://developer.sourcefind.cn/codes/OpenDAS/ollama/-/tree/0.5.7)
- [vllm](https://das.sourcefind.cn:55011/portal/#/installation?id=9385225c-6b7a-11ef-bf92-005056904552&type=frame)

注意：`api_key`部分不可为空，即使使用随机字符，如`api_key="aa"`。

### 其他模型源

- [aliyun](https://help.aliyun.com/zh/model-studio/developer-reference/use-qwen-by-calling-api)

- [openai](https://platform.openai.com/docs/overview)

## 验证

```bash
python main.py
```

## 参考资料

* https://github.com/mannaandpoem/OpenManus

## Release Notes

- 当前使用Bing搜索，搜索结果较google搜索较差。