# OpenCV-python 构建流程及使用方法
## 1、构建流程
### 1.1 容器创建及基础环境搭建
&emsp;&emsp;在 61 节点上创建容器：<br/>
```bash
# 容器创建
docker run -i -t --name opencv  --device=/dev/kfd --network=host --device=/dev/dri --cap-add=SYS_PTRACE -p 6666:6006 --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal/:ro -v /parastor/home/fengzch/:/home/  --group-add video --privileged=true --shm-size 16G 8deabd4d542a
```
&emsp;&emsp;创建好容器之后，安装DTK、torch、numpy、fastpt:<br/>
```bash
# DTK 安装
cd /opt
wget http://10.6.10.68:8000/dtk-pkg/dtk25.04/20250124/DTK-25.04-rc4-ubuntu20.04-x86_64.tar.gz
tar -zxvf DTK-25.04-rc4-ubuntu20.04-x86_64.tar.gz
 
# torch 安装
cd /
mkdir test
cd test
wget http://10.6.10.68:8000/customized/pytorch/dtk25.04-rc4/torch-2.4.1%2Bdas.opt1.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.4.1+das.opt1.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
 
# fastpt 安装
# 下载地址：https://download.sourcefind.cn:65024/4/main/fastpt/DAS1.5
pip install fastpt-2.0.0+das.dtk2504-py3-none-any.whl

pip install numpy==1.24.3
pip install wheel==0.45.1
pip install scikit-build
```
### 1.2 代码拉取
&emsp;&emsp;拉取Pytorch、Opencv、Opencv-contrib 以及 Opencv-python 代码：<br/>
```bash
# Pytorch 代码拉取
cd /test
git clone -b 2.4.1-dev http://10.6.10.68/dcutoolkit/deeplearing/pytorch.git
 
# OpenCV 代码拉取
cd /test
git clone http://10.6.10.68/fengzch/opencv.git
 
# OpenCV_contrib 代码拉取，该模块与 opencv 在同一目录下
cd /test
git clone http://10.6.10.68/fengzch/opencv_contrib.git
 
# OpenCV-Python 代码拉取
cd /test
git clone http://10.6.10.68/fengzch/opencv-python.git
```
### 1.3 环境初始化
&emsp;&emsp;初始化环境：<br/>
```bash
source /opt/dtk-25.04-rc4/env.sh
source /opt/dtk-25.04-rc4/cuda/env.sh
export TORCH_PATH=/usr/local/lib/python3.10/site-packages/torch
export HIP_TORCH_PATH=/test/pytorch
export LD_LIBRARY_PATH=/usr/local/lib/python3.10/site-packages/torch/lib:$LD_LIBRARY_PATH
export USE_FASTPT_CUDA=True

# 下面的两个环境变量需要开启
export CMAKE_ARGS="-DCMAKE_BUILD_TYPE=Release -DCMAKE_INSTALL_PREFIX=/usr/local -DCMAKE_C_COMPILER=/usr/bin/gcc-9 -DCMAKE_CXX_COMPILER=/usr/bin/g++-9"
export ENABLE_CONTRIB=1
```
### 1.4 依赖下载
&emsp;&emsp;下载相关依赖：<br/>
```bash
sudo apt update
sudo apt install -y build-essential cmake git pkg-config libgtk-3-dev libavcodec-dev libavformat-dev libswscale-dev libv4l-dev libxvidcore-dev libx264-dev libjpeg-dev libpng-dev libtiff-dev gfortran openexr libatlas-base-dev libhdf5-mpich-dev libhdf5-dev libvtk6-dev libopenblas-dev libeigen3-dev python3-dev python3-pip libogre-1.12-dev libxaw7-dev
 
# apt无法下载时处理
# 备份原镜像源
sudo cp /etc/apt/sources.list /etc/apt/sources.list.bak
# 将原镜像源更换为阿里云镜像源
sudo sed -i 's/security.ubuntu.com/mirrors.aliyun.com/g' /etc/apt/sources.list
# 如果还有错误，则添加清华镜像源/etc/apt/sources.list
deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal main restricted universe multiverse
deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-updates main restricted universe multiverse
deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-backports main restricted universe multiverse
deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-security main restricted universe multiverse
```
### 1.5 npps 库下载拷贝
&emsp;&emsp;目前，DTk 中暂未提供 npps 动态库，因此暂时使用 cuda 原生的 npps 库：<br/>
```bash
cp /test/opencv-python/npps/libnpps* /opt/dtk-25.04-rc4/cuda/lib64/
```
### 1.6 OIS 编译构建(ovis 模块依赖，默认ovis 模块不构建)
&emsp;&emsp;由于，Opencv_contrib 中的 ovis 模块需要该库的支持，所以需要构建相关依赖库，编译构建指令如下：<br/>
```bash
cd /test
git clone http://10.6.10.68/fengzch/ois.git
cd ois
mkdir build && cd build && cmake ../
make -j32 install
```
**PS: 如果需要构建 ovis 模块，在 setup.py 文件的 226 行 "-DBUILD_opencv_ovis" 设为 ON**
### 1.7 ogre 编译构建(ovis 模块依赖，默认ovis 模块不构建)
&emsp;&emsp;编译构建指令如下：<br/>
```bash
cd /test
git clone http://10.6.10.68/fengzch/orge.git
cd orge
mkdir build && cd build && cmake ../
make -j32 install
```
### 1.8 创建软链接
&emsp;&emsp;在 OpenCV-Python 中创建软链接到OpenCV 和 OpenCV_Contrib:<br/>
```bash
cd /test/opencv-python
ln -sf ../opencv opencv
ln -sf ../opencv_contrib opencv_contrib 
```
### 1.9 编译 wheel 包
&emsp;&emsp;执行下面的指令，编译 wheel 包<br/>
```bash
cd /test/opencv-python
python setup.py bdist_wheel
```
### 1.10 安装使用
```bash
cd /test/opencv-python/dist
pip install opencv-4.8.0+das.opt1.dtk2504-cp310-cp310-linux_x86_64.whl

# 验证
# python
# import cv2
# cv2.__version__
# '4.8.0'
# cv2.__hcu_version__
# '4.8.0+das.opt1.dtk2504'
```
## 2 OpenCV 使用
&emsp;&emsp;如果直接使用提供的 wheel 包，首先按照1.1、1.2配置好基础环境，接着通过 pip install 安装 **（需要首先安转 numpy：pip install numpy==1.24.3）**，**（如果需要 ovis 模块，需要手动编译 OIS 和 ogre，）**最后安装 libxaw7-dev<br/>
```bash
pip install numpy==1.24.3
sudo apt install -y libxaw7-dev
pip install 
```