from mmengine.config import read_base

with read_base():
    from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/qwen1.5-int4-chat/'

from opencompass.models import VLLM


qwen2_meta_template = dict(
    round=[
        dict(role="HUMAN", begin='<|im_start|>user\n', end='<|im_end|>\n'),
        dict(role="BOT", begin="<|im_start|>assistant\n", end='<|im_end|>\n', generate=True),
    ],
    eos_token_id=151645,
)

models = [
    dict(
        type=VLLM,
        abbr='qwen1.5-7b-int4-chat-vllm',
        path="Qwen1.5-7B-Chat-GPTQ-Int4",
        model_kwargs=dict(tensor_parallel_size=1, quantization="gptq"),
        meta_template=qwen2_meta_template,
        max_out_len=100,
        max_seq_len=2048,
        batch_size=1,
        generation_kwargs=dict(temperature=0),
        end_str='<|im_end|>',
        run_cfg=dict(num_gpus=1, num_procs=1),
    )
]