from opencompass.openicl.icl_prompt_template import PromptTemplate
from opencompass.openicl.icl_retriever import ZeroRetriever
from opencompass.openicl.icl_inferencer import GenInferencer
from opencompass.openicl.icl_evaluator import BleuEvaluator
from opencompass.datasets import SummScreenDataset

summscreen_reader_cfg = dict(
    input_columns='content',
    output_column='summary',
    train_split='dev',
    test_split='dev')

summscreen_infer_cfg = dict(
    prompt_template=dict(
        type=PromptTemplate,
        template=
        "Please summarize the following English report in English:{content}\n{summary}."),
    retriever=dict(type=ZeroRetriever),
    inferencer=dict(
        type=GenInferencer, batch_size=4, max_out_len=500, max_seq_len=8192))

summscreen_eval_cfg = dict(
    evaluator=dict(type=BleuEvaluator),
    pred_postprocessor=dict(type='general_cn'),
    dataset_postprocessor=dict(type='general_cn'))

summscreen_datasets = [
    dict(
        type=SummScreenDataset,
        path='./data/SummScreen/',
        abbr='SummScreen',
        reader_cfg=summscreen_reader_cfg,
        infer_cfg=summscreen_infer_cfg,
        eval_cfg=summscreen_eval_cfg)
]
