from opencompass.openicl.icl_prompt_template import PromptTemplate
from opencompass.openicl.icl_retriever import ZeroRetriever
from opencompass.openicl.icl_inferencer import GenInferencer
from opencompass.datasets.custom import OptionSimAccEvaluator
from opencompass.datasets import siqaDataset_V3

siqa_reader_cfg = dict(
    input_columns=["context", "question", "A", "B", "C"],
    output_column="answer",
    test_split="validation")

siqa_infer_cfg = dict(
    prompt_template=dict(
        type=PromptTemplate,
        template=dict(
            round=[
                dict(
                    role="HUMAN",
                    prompt=
                    "{context}\nQuestion: {question}\nA. {A}\nB. {B}\nC. {C}\nAnswer:"
                )
            ], ),
    ),
    retriever=dict(type=ZeroRetriever),
    inferencer=dict(type=GenInferencer),
)

siqa_eval_cfg = dict(
    evaluator=dict(type=OptionSimAccEvaluator, options='ABC'),
    pred_role="BOT",
)

siqa_datasets = [
    dict(
        abbr="siqa",
        type=siqaDataset_V3,
        path='./data/siqa',
        reader_cfg=siqa_reader_cfg,
        infer_cfg=siqa_infer_cfg,
        eval_cfg=siqa_eval_cfg)
]
