from mmengine.config import read_base

with read_base():
    from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/qwen-chat/'

from opencompass.models import VLLM


qwen_meta_template = dict(
    round=[
        dict(role="HUMAN", begin='\n<|im_start|>user\n', end='<|im_end|>'),
        dict(role="BOT", begin="\n<|im_start|>assistant\n", end='<|im_end|>', generate=True),
    ],
)

models = [
    dict(
        type=VLLM,
        abbr='qwen-7b-chat-vllm',
        path="Qwen-7B-Chat",
        model_kwargs=dict(tensor_parallel_size=2),
        meta_template=qwen_meta_template,
        max_out_len=100,
        max_seq_len=2048,
        batch_size=1,
        generation_kwargs=dict(temperature=0),
        end_str='<|im_end|>',
        run_cfg=dict(num_gpus=2, num_procs=1),
    )
]
