# 支持新数据集

尽管 OpenCompass 已经包含了大多数常用数据集，用户在支持新数据集的时候需要完成以下几个步骤：

1. 在 `opencompass/datasets` 文件夹新增数据集脚本 `mydataset.py`, 该脚本需要包含：
    
    - 数据集及其加载方式，需要定义一个 `MyDataset` 类，实现数据集加载方法 `load` ，该方法为静态方法，需要返回 `datasets.Dataset` 类型的数据。这里我们使用 huggingface dataset 作为数据集的统一接口，避免引入额外的逻辑。具体示例如下：

    ```python
    import datasets
    from .base import BaseDataset

    class MyDataset(BaseDataset):

        @staticmethod
        def load(**kwargs) -> datasets.Dataset:
            pass
    ```

    - （可选）如果OpenCompass已有的evaluator不能满足需要，需要用户定义 `MyDatasetlEvaluator` 类，实现评分方法 `score` ，需要根据输入的 `predictions` 和 `references` 列表，得到需要的字典。由于一个数据集可能存在多种metric，需要返回一个 metrics 以及对应 scores 的相关字典。具体示例如下：

    ```python

    from opencompass.openicl.icl_evaluator import BaseEvaluator

    class MyDatasetlEvaluator(BaseEvaluator):

        def score(self, predictions: List, references: List) -> dict:
            pass

    ```

    - （可选）如果 OpenCompass 已有的 postprocesser 不能满足需要，需要用户定义 `mydataset_postprocess` 方法，根据输入的字符串得到相应后处理的结果。具体示例如下：

    ```python
    def mydataset_postprocess(text: str) -> str:
        pass
    ```

2. 在定义好数据集加载，数据后处理以及 `evaluator` 等方法之后，需要在配置文件中新增以下配置：

    ```python
    from opencompass.datasets import MyDataset, MyDatasetlEvaluator, mydataset_postprocess
    
    mydataset_eval_cfg = dict(
        evaluator=dict(type=MyDatasetlEvaluator),
        pred_postprocessor=dict(type=mydataset_postprocess))

    mydataset_datasets = [
        dict(
            type=MyDataset,
            ...,
            reader_cfg=...,
            infer_cfg=...,
            eval_cfg=mydataset_eval_cfg)
    ]
    ```

    配置好数据集之后，其他需要的配置文件直接参考如何启动评测任务教程即可。
    