import fnmatch
import os
from typing import List, Union


def match_files(path: str,
                pattern: Union[str, List],
                fuzzy: bool = False) -> List:
    if isinstance(pattern, str):
        pattern = [pattern]
    if fuzzy:
        pattern = [f'*{p}*' for p in pattern]
    files_list = []
    for root, _, files in os.walk(path):
        for name in files:
            for p in pattern:
                if fnmatch.fnmatch(name.lower(), p.lower()):
                    files_list.append([name[:-3], os.path.join(root, name)])
                    break

    return sorted(files_list, key=lambda x: x[0])
