from opencompass.openicl.icl_prompt_template import PromptTemplate
from opencompass.openicl.icl_retriever import ZeroRetriever
from opencompass.openicl.icl_inferencer import GenInferencer
from opencompass.openicl.icl_evaluator import EMEvaluator, RougeEvaluator
from opencompass.datasets.leval import LEvalGPTEvaluator, LEvalLegalContractQADataset

LEval_legalqa_reader_cfg = dict(
    input_columns=['context', 'question', 'length'],
    output_column='answer',
    train_split='test',
    test_split='test'
)

LEval_legalqa_infer_cfg = dict(
    prompt_template=dict(
        type=PromptTemplate,
        template=dict(
            begin=[
                dict(role='SYSTEM', fallback_role='HUMAN', prompt='Now you are given a very long document. Please follow the instruction after this document. These instructions may include summarizing a document, answering questions based on the document, or writing a required paragraph.'),
            ],
            round=[
                dict(role='HUMAN', prompt='Document is as follows. {context}\nInstruction: {question}\nAnswer this question with {length} words.'),
                dict(role='BOT', prompt=''),
            ], )),
    retriever=dict(type=ZeroRetriever),
    inferencer=dict(type=GenInferencer, max_out_len=128)
)

LEval_legalqa_eval_cfg = dict(
    evaluator=dict(type=LEvalGPTEvaluator), 
    pred_role='BOT'
)

LEval_legalqa_datasets = [
    dict(
        type=LEvalLegalContractQADataset,
        abbr='LEval_legal_contract_qa',
        path='L4NLP/LEval',
        name='legal_contract_qa',
        reader_cfg=LEval_legalqa_reader_cfg,
        infer_cfg=LEval_legalqa_infer_cfg,
        eval_cfg=LEval_legalqa_eval_cfg)
]
