# <div align="center"><strong>opencompass</strong></div>
## 简介
OpenCompass主要由三个核心模块构成：CompassKit、CompassHub和CompassRank。CompassRank不仅囊括了开源基准测试项目，还包含了私有基准测试。CompassHub推出了一个基准测试资源导航平台,可以在多样化的基准测试库中进行搜索与利用。CompassKit 是一系列专为大型语言模型和大型视觉-语言模型打造的强大评估工具合集，它所提供的全面评测工具集能够有效地对这些复杂模型的功能性能进行精准测量和科学评估。


## 安装
opencompass支持
+ Python 3.8.
+ Python 3.9.
+ Python 3.10.

### 使用源码编译方式安装

#### 编译环境准备
提供2种环境准备方式：

1. 基于光源pytorch2.1.0基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch2.1.0、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch2.1.0，pytorch whl包下载目录：[https://cancon.hpccube.com:65024/4/main/pytorch/DAS1.0](https://cancon.hpccube.com:65024/4/main/pytorch/DAS1.0)，根据python、dtk版本,下载对应pytorch2.1.0的whl包。安装命令如下：
```shell
pip install torch* (下载的torch的whl包)
pip install setuptools wheel
```

#### 源码编译安装
```shell
git clone -b 0.2.5.rc1 http://developer.hpccube.com/codes/OpenDAS/opencompass.git 
```

- 提供2种源码编译方式（进入opencompass目录）：
```
基础依赖安装：
pip install -r requirements.txt
pip install sentence_transformers==2.2.2 --no-deps

1. 编译whl包并安装
python setup.py bdist_wheel 
cd dist
pip install opencompass*

2. 源码编译安装
pip install -e .
```


#### 注意事项
+ 若使用 pip install 下载安装过慢，可添加源：-i https://pypi.tuna.tsinghua.edu.cn/simple/


## 使用
### 数据集准备
```
wget https://github.com/open-compass/opencompass/releases/download/0.2.2.rc1/OpenCompassData-core-20240207.zip
unzip OpenCompassData-core-20240207.zip (解压后为data目录)
```

### 使用说明
列出所有配置：
```shell
python tools/list_configs.py
```

列出和llama模型以及mmlu数据集有关的配置：
```shell
python tools/list_configs.py llama mmlu
```

根据需要的框架进行安装，然后运行：

1、使用vllm推理验证
```shell
python run.py configs/vllm/eval_llama2_vllm.py
```
其它模型使用参考`configs/vllm/eval_xxx_vllm.py`

2、使用lmdeploy推理验证
```shell
#安装gpufusion 相关工具
#https://forum.hpccube.com/thread/483 进入网页下载gpufusion工具
#解压至dtk-24.04
unzip gpufusion.zip -d /opt/dtk-24.04/
#激活相关环境变量
source /opt/dtk-24.04/env.sh
source /opt/dtk-24.04/cuda/env.sh
#进入opencompass进行评测
cd opencompass 
#fp16精度评测方法
python run.py configs/lmdeploy/eval_llama2_lmdeploy.py
#awq int4 评测方法
#首先需要转换awqInt4模型  
#model_name:模型名字如 llama2 qwen-7b 
#awq_modelpath:awq 模型路径，例如：/dataset/llm-models/qwen/qwen-chat-7b-AWQ-4bit
#awq_lmdeploymodel_path:生成的lmdeploy格式 awq模型路径
lmdeploy convert ${model_name} ${awq_modelpath} --model-format awq --group-size 128 --dst-path ${awq_lmdeploymodel_path}
#将eval_llama2_lmdeploy.py中的Llama-2-7b-hf 替换为转换好的awq_lmdeploymodel_path
python run.py configs/lmdeploy/eval_llama2_lmdeploy.py
```
其它模型使用参考`configs/lmdeploy/eval_xxx_lmdeploy.py`

3、使用tgi推理验证
```shell
python run.py configs/tgi/eval_llama2_tgi.py
```
其它模型使用参考`configs/tgi/eval_xxx_tgi.py`

参数说明：
（1）数据集配置参数
`work_dir`为保存路径，`from .datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets`为使用的数据集，可以在`configs/datasets`路径下查找并配置，vllm目前不支持ppl-based评测。
（2）模型配置参数
`abbr`为生成数据集指标得分的列名，`path`为模型路径。

## 验证
- python -c "import opencompass; print(opencompass.\_\_version__)"，版本号与官方版本同步，查询该软件的版本号，例如0.2.4；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/open-compass/opencompass](https://github.com/open-compass/opencompass.git)
