from mmengine.config import read_base

with read_base():
    from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets
    from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    # from .datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/llama2_13b/'

from opencompass.models import TGIBASEAPI

models = [
    dict(
        abbr='llama2_13b_tgi',
        path='/models/llama-2-13B',
        type=TGIBASEAPI,
        url='http://localhost:3001/generate',
        meta_template= None,
        batch_size=32,
        rate_per_worker=32,
        retry=4,
        generation_kwargs=dict(
            do_sample=False,
            ignore_eos=False,
            max_new_tokens=100,
            temperature=1,
            top_k=1,
            top_n=0.8
        ),
    ),
]