include(ExternalProject)

set(PROTOBUF_INSTALL_DIR ${THIRD_PARTY_DIR}/protobuf)
set(PROTOBUF_INSTALL_INCLUDEDIR include)
set(PROTOBUF_INSTALL_LIBDIR lib)
set(PROTOBUF_INSTALL_BINDIR bin)
set(PROTOBUF_INCLUDE_DIR ${PROTOBUF_INSTALL_DIR}/${PROTOBUF_INSTALL_INCLUDEDIR})
set(PROTOBUF_LIBRARY_DIR ${PROTOBUF_INSTALL_DIR}/${PROTOBUF_INSTALL_LIBDIR})
set(PROTOBUF_BINARY_DIR ${PROTOBUF_INSTALL_DIR}/${PROTOBUF_INSTALL_BINDIR})

set(PROTOBUF_SRC_DIR ${CMAKE_CURRENT_BINARY_DIR}/protobuf/src/protobuf/src)
set(PROTOBUF_URL "https://github.com/protocolbuffers/protobuf/archive/v3.9.2.zip")
set(PROTOBUF_MD5 cf02c32870a1f78c860039e0f63a6343)

use_mirror(VARIABLE PROTOBUF_URL URL ${PROTOBUF_URL})

if(WIN32)
  set(PROTOBUF_LIBRARY_NAMES libprotobufd.lib)
  set(PROTOC_EXECUTABLE_NAME protoc.exe)
  set(PROTOBUF_ADDITIONAL_CMAKE_OPTIONS -Dprotobuf_MSVC_STATIC_RUNTIME:BOOL=ON -A x64)
else()
  # NOTE: (houjiang, shenghang), to support xrt, must make libproto built as shared
  if("${CMAKE_SHARED_LIBRARY_SUFFIX}" STREQUAL ".dylib")
    set(PROTOBUF_LIBRARY_NAMES libprotobuf.dylib)
  elseif("${CMAKE_SHARED_LIBRARY_SUFFIX}" STREQUAL ".so")
    set(PROTOBUF_LIBRARY_NAMES libprotobuf.so)
  else()
    message(FATAL_ERROR "${CMAKE_SHARED_LIBRARY_SUFFIX} not support for protobuf")
  endif()
  set(PROTOBUF_BUILD_SHARED_LIBS ON)
  set(PROTOC_EXECUTABLE_NAME protoc)
endif()

foreach(LIBRARY_NAME ${PROTOBUF_LIBRARY_NAMES})
  list(APPEND PROTOBUF_STATIC_LIBRARIES ${PROTOBUF_LIBRARY_DIR}/${LIBRARY_NAME})
endforeach()

set(PROTOBUF_PROTOC_EXECUTABLE ${PROTOBUF_BINARY_DIR}/${PROTOC_EXECUTABLE_NAME})

if(THIRD_PARTY)

  ExternalProject_Add(
    protobuf
    PREFIX protobuf
    URL ${PROTOBUF_URL}
    URL_MD5 ${PROTOBUF_MD5}
    UPDATE_COMMAND ""
    BUILD_IN_SOURCE 1
    SOURCE_DIR ${CMAKE_CURRENT_BINARY_DIR}/protobuf/src/protobuf
    SOURCE_SUBDIR cmake
    BUILD_BYPRODUCTS ${PROTOBUF_STATIC_LIBRARIES}
    CMAKE_CACHE_ARGS
      -DCMAKE_C_COMPILER_LAUNCHER:STRING=${CMAKE_C_COMPILER_LAUNCHER}
      -DCMAKE_CXX_COMPILER_LAUNCHER:STRING=${CMAKE_CXX_COMPILER_LAUNCHER}
      -DCMAKE_POLICY_DEFAULT_CMP0074:STRING=NEW
      -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
      -DCMAKE_VERBOSE_MAKEFILE:BOOL=OFF
      -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON
      -DZLIB_ROOT:PATH=${ZLIB_INSTALL}
      -Dprotobuf_WITH_ZLIB:BOOL=${WITH_ZLIB}
      -DCMAKE_CXX_FLAGS_DEBUG:STRING=${CMAKE_CXX_FLAGS_DEBUG}
      -DBUILD_SHARED_LIBS:BOOL=${PROTOBUF_BUILD_SHARED_LIBS}
      -Dprotobuf_BUILD_SHARED_LIBS:BOOL=${PROTOBUF_BUILD_SHARED_LIBS}
      -Dprotobuf_BUILD_TESTS:BOOL=OFF
      -DCMAKE_INSTALL_PREFIX:STRING=${PROTOBUF_INSTALL_DIR}
      -DCMAKE_INSTALL_INCLUDEDIR:STRING=${PROTOBUF_INSTALL_INCLUDEDIR}
      -DCMAKE_INSTALL_LIBDIR:STRING=${PROTOBUF_INSTALL_LIBDIR}
      -DCMAKE_INSTALL_BINDIR:STRING=${PROTOBUF_INSTALL_BINDIR}
      -DCMAKE_INSTALL_MESSAGE:STRING=${CMAKE_INSTALL_MESSAGE}
      -Dprotobuf_DEBUG_POSTFIX:STRING=
      ${PROTOBUF_ADDITIONAL_CMAKE_OPTIONS})
  if(WITH_ZLIB)
    add_dependencies(protobuf zlib)
  endif()
else()
  add_custom_target(protobuf)
endif(THIRD_PARTY)
add_library(protobuf_imported UNKNOWN IMPORTED)
set_property(TARGET protobuf_imported PROPERTY IMPORTED_LOCATION "${PROTOBUF_STATIC_LIBRARIES}")
