# Monkey patch to not ship libjvm.so in pypi wheels
import sys

from auditwheel.main import main
from auditwheel.policy import _POLICIES as POLICIES

# libjvm is loaded dynamically; do not include it
for p in POLICIES:
    p['lib_whitelist'].append('librccl.so.1')
    p['lib_whitelist'].append('libhipblas.so.0')
    p['lib_whitelist'].append('librocblas.so.0')
    p['lib_whitelist'].append('libhiprand.so.1')
    p['lib_whitelist'].append('librocrand.so.1')
    p['lib_whitelist'].append('libMIOpen.so.1')
    p['lib_whitelist'].append('libgalaxyhip.so.5')
    p['lib_whitelist'].append('librocm_smi64.so.2')
    p['lib_whitelist'].append('libhipsolver.so.0')
    p['lib_whitelist'].append('librocsolver.so.0')
    p['lib_whitelist'].append('librocfft.so.0')
    p['lib_whitelist'].append('librocfft-device-3.so.0')
    p['lib_whitelist'].append('librocfft-device-2.so.0')
    p['lib_whitelist'].append('librocfft-device-1.so.0')
    p['lib_whitelist'].append('librocfft-device-0.so.0')
    p['lib_whitelist'].append('libhipfft.so')
    p['lib_whitelist'].append('libhipnn.so')

if __name__ == "__main__":
    sys.exit(main())


