/*
Copyright 2020 The OneFlow Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
#include <chrono>
#include "oneflow/core/common/spin_counter.h"
#include "oneflow/core/common/singleton.h"
#include "oneflow/core/common/foreign_lock_helper.h"

namespace oneflow {

Maybe<void> SpinCounter::WaitUntilCntEqualZero() const {
  return Singleton<ForeignLockHelper>::Get()->WithScopedRelease([&]() -> Maybe<void> {
    while (cnt_val_ > 0) {}
    return Maybe<void>::Ok();
  });
}

}  // namespace oneflow
