/*
Copyright 2020 The OneFlow Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// automatically generated by the FlatBuffers compiler, do not modify

#ifndef FLATBUFFERS_GENERATED_EXAMPLE_ONEREC_EXAMPLE_H_
#define FLATBUFFERS_GENERATED_EXAMPLE_ONEREC_EXAMPLE_H_

#include "flatbuffers/flatbuffers.h"

namespace onerec {
namespace example {

struct Int8List;
struct Int8ListBuilder;

struct Int16List;
struct Int16ListBuilder;

struct Int32List;
struct Int32ListBuilder;

struct Int64List;
struct Int64ListBuilder;

struct Float32List;
struct Float32ListBuilder;

struct Float64List;
struct Float64ListBuilder;

struct StringList;
struct StringListBuilder;

struct Binary;
struct BinaryBuilder;

struct BinaryList;
struct BinaryListBuilder;

struct Tensor;
struct TensorBuilder;

struct Feature;
struct FeatureBuilder;

struct Digest;
struct DigestBuilder;

struct Example;
struct ExampleBuilder;

enum TensorData {
  TensorData_NONE = 0,
  TensorData_Int8List = 1,
  TensorData_Int16List = 2,
  TensorData_Int32List = 3,
  TensorData_Int64List = 4,
  TensorData_Float32List = 5,
  TensorData_Float64List = 6,
  TensorData_StringList = 7,
  TensorData_BinaryList = 8,
  TensorData_MIN = TensorData_NONE,
  TensorData_MAX = TensorData_BinaryList
};

inline const TensorData (&EnumValuesTensorData())[9] {
  static const TensorData values[] = {
      TensorData_NONE,        TensorData_Int8List,   TensorData_Int16List,
      TensorData_Int32List,   TensorData_Int64List,  TensorData_Float32List,
      TensorData_Float64List, TensorData_StringList, TensorData_BinaryList};
  return values;
}

inline const char* const* EnumNamesTensorData() {
  static const char* const names[10] = {"NONE",       "Int8List",    "Int16List",   "Int32List",
                                        "Int64List",  "Float32List", "Float64List", "StringList",
                                        "BinaryList", nullptr};
  return names;
}

inline const char* EnumNameTensorData(TensorData e) {
  if (flatbuffers::IsOutRange(e, TensorData_NONE, TensorData_BinaryList)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTensorData()[index];
}

template<typename T>
struct TensorDataTraits {
  static const TensorData enum_value = TensorData_NONE;
};

template<>
struct TensorDataTraits<onerec::example::Int8List> {
  static const TensorData enum_value = TensorData_Int8List;
};

template<>
struct TensorDataTraits<onerec::example::Int16List> {
  static const TensorData enum_value = TensorData_Int16List;
};

template<>
struct TensorDataTraits<onerec::example::Int32List> {
  static const TensorData enum_value = TensorData_Int32List;
};

template<>
struct TensorDataTraits<onerec::example::Int64List> {
  static const TensorData enum_value = TensorData_Int64List;
};

template<>
struct TensorDataTraits<onerec::example::Float32List> {
  static const TensorData enum_value = TensorData_Float32List;
};

template<>
struct TensorDataTraits<onerec::example::Float64List> {
  static const TensorData enum_value = TensorData_Float64List;
};

template<>
struct TensorDataTraits<onerec::example::StringList> {
  static const TensorData enum_value = TensorData_StringList;
};

template<>
struct TensorDataTraits<onerec::example::BinaryList> {
  static const TensorData enum_value = TensorData_BinaryList;
};

bool VerifyTensorData(flatbuffers::Verifier& verifier, const void* obj, TensorData type);
bool VerifyTensorDataVector(flatbuffers::Verifier& verifier,
                            const flatbuffers::Vector<flatbuffers::Offset<void>>* values,
                            const flatbuffers::Vector<uint8_t>* types);

struct Int8List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int8ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<int8_t>* values() const {
    return GetPointer<const flatbuffers::Vector<int8_t>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Int8ListBuilder {
  typedef Int8List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<int8_t>> values) {
    fbb_.AddOffset(Int8List::VT_VALUES, values);
  }
  explicit Int8ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Int8ListBuilder& operator=(const Int8ListBuilder&);
  flatbuffers::Offset<Int8List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int8List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int8List> CreateInt8List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int8_t>> values = 0) {
  Int8ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Int8List> CreateInt8ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<int8_t>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<int8_t>(*values) : 0;
  return onerec::example::CreateInt8List(_fbb, values__);
}

struct Int16List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int16ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<int16_t>* values() const {
    return GetPointer<const flatbuffers::Vector<int16_t>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Int16ListBuilder {
  typedef Int16List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<int16_t>> values) {
    fbb_.AddOffset(Int16List::VT_VALUES, values);
  }
  explicit Int16ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Int16ListBuilder& operator=(const Int16ListBuilder&);
  flatbuffers::Offset<Int16List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int16List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int16List> CreateInt16List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int16_t>> values = 0) {
  Int16ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Int16List> CreateInt16ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<int16_t>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<int16_t>(*values) : 0;
  return onerec::example::CreateInt16List(_fbb, values__);
}

struct Int32List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int32ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<int32_t>* values() const {
    return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Int32ListBuilder {
  typedef Int32List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<int32_t>> values) {
    fbb_.AddOffset(Int32List::VT_VALUES, values);
  }
  explicit Int32ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Int32ListBuilder& operator=(const Int32ListBuilder&);
  flatbuffers::Offset<Int32List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int32List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int32List> CreateInt32List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> values = 0) {
  Int32ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Int32List> CreateInt32ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<int32_t>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<int32_t>(*values) : 0;
  return onerec::example::CreateInt32List(_fbb, values__);
}

struct Int64List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Int64ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<int64_t>* values() const {
    return GetPointer<const flatbuffers::Vector<int64_t>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Int64ListBuilder {
  typedef Int64List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<int64_t>> values) {
    fbb_.AddOffset(Int64List::VT_VALUES, values);
  }
  explicit Int64ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Int64ListBuilder& operator=(const Int64ListBuilder&);
  flatbuffers::Offset<Int64List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Int64List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Int64List> CreateInt64List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int64_t>> values = 0) {
  Int64ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Int64List> CreateInt64ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<int64_t>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<int64_t>(*values) : 0;
  return onerec::example::CreateInt64List(_fbb, values__);
}

struct Float32List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Float32ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<float>* values() const {
    return GetPointer<const flatbuffers::Vector<float>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Float32ListBuilder {
  typedef Float32List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<float>> values) {
    fbb_.AddOffset(Float32List::VT_VALUES, values);
  }
  explicit Float32ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Float32ListBuilder& operator=(const Float32ListBuilder&);
  flatbuffers::Offset<Float32List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Float32List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Float32List> CreateFloat32List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<float>> values = 0) {
  Float32ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Float32List> CreateFloat32ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<float>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<float>(*values) : 0;
  return onerec::example::CreateFloat32List(_fbb, values__);
}

struct Float64List FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef Float64ListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<double>* values() const {
    return GetPointer<const flatbuffers::Vector<double>*>(VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.EndTable();
  }
};

struct Float64ListBuilder {
  typedef Float64List Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(flatbuffers::Offset<flatbuffers::Vector<double>> values) {
    fbb_.AddOffset(Float64List::VT_VALUES, values);
  }
  explicit Float64ListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  Float64ListBuilder& operator=(const Float64ListBuilder&);
  flatbuffers::Offset<Float64List> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Float64List>(end);
    return o;
  }
};

inline flatbuffers::Offset<Float64List> CreateFloat64List(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<double>> values = 0) {
  Float64ListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<Float64List> CreateFloat64ListDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<double>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<double>(*values) : 0;
  return onerec::example::CreateFloat64List(_fbb, values__);
}

struct StringList FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef StringListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>* values() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>*>(
        VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.VerifyVectorOfStrings(values())
           && verifier.EndTable();
  }
};

struct StringListBuilder {
  typedef StringList Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> values) {
    fbb_.AddOffset(StringList::VT_VALUES, values);
  }
  explicit StringListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  StringListBuilder& operator=(const StringListBuilder&);
  flatbuffers::Offset<StringList> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<StringList>(end);
    return o;
  }
};

inline flatbuffers::Offset<StringList> CreateStringList(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> values = 0) {
  StringListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<StringList> CreateStringListDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<flatbuffers::Offset<flatbuffers::String>>* values = nullptr) {
  auto values__ = values ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*values) : 0;
  return onerec::example::CreateStringList(_fbb, values__);
}

struct Binary FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BinaryBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_BUFFER = 4 };
  const flatbuffers::Vector<int8_t>* buffer() const {
    return GetPointer<const flatbuffers::Vector<int8_t>*>(VT_BUFFER);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_BUFFER)
           && verifier.VerifyVector(buffer()) && verifier.EndTable();
  }
};

struct BinaryBuilder {
  typedef Binary Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_buffer(flatbuffers::Offset<flatbuffers::Vector<int8_t>> buffer) {
    fbb_.AddOffset(Binary::VT_BUFFER, buffer);
  }
  explicit BinaryBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  BinaryBuilder& operator=(const BinaryBuilder&);
  flatbuffers::Offset<Binary> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Binary>(end);
    return o;
  }
};

inline flatbuffers::Offset<Binary> CreateBinary(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int8_t>> buffer = 0) {
  BinaryBuilder builder_(_fbb);
  builder_.add_buffer(buffer);
  return builder_.Finish();
}

inline flatbuffers::Offset<Binary> CreateBinaryDirect(flatbuffers::FlatBufferBuilder& _fbb,
                                                      const std::vector<int8_t>* buffer = nullptr) {
  auto buffer__ = buffer ? _fbb.CreateVector<int8_t>(*buffer) : 0;
  return onerec::example::CreateBinary(_fbb, buffer__);
}

struct BinaryList FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef BinaryListBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUES = 4 };
  const flatbuffers::Vector<flatbuffers::Offset<onerec::example::Binary>>* values() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<onerec::example::Binary>>*>(
        VT_VALUES);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_VALUES)
           && verifier.VerifyVector(values()) && verifier.VerifyVectorOfTables(values())
           && verifier.EndTable();
  }
};

struct BinaryListBuilder {
  typedef BinaryList Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_values(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<onerec::example::Binary>>>
          values) {
    fbb_.AddOffset(BinaryList::VT_VALUES, values);
  }
  explicit BinaryListBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  BinaryListBuilder& operator=(const BinaryListBuilder&);
  flatbuffers::Offset<BinaryList> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<BinaryList>(end);
    return o;
  }
};

inline flatbuffers::Offset<BinaryList> CreateBinaryList(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<onerec::example::Binary>>> values =
        0) {
  BinaryListBuilder builder_(_fbb);
  builder_.add_values(values);
  return builder_.Finish();
}

inline flatbuffers::Offset<BinaryList> CreateBinaryListDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    const std::vector<flatbuffers::Offset<onerec::example::Binary>>* values = nullptr) {
  auto values__ =
      values ? _fbb.CreateVector<flatbuffers::Offset<onerec::example::Binary>>(*values) : 0;
  return onerec::example::CreateBinaryList(_fbb, values__);
}

struct Tensor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_SHAPE = 4,
    VT_DATA_TYPE = 6,
    VT_DATA = 8
  };
  const flatbuffers::Vector<int32_t>* shape_view() const {
    return GetPointer<const flatbuffers::Vector<int32_t>*>(VT_SHAPE);
  }
  onerec::example::TensorData data_type() const {
    return static_cast<onerec::example::TensorData>(GetField<uint8_t>(VT_DATA_TYPE, 0));
  }
  const void* data() const { return GetPointer<const void*>(VT_DATA); }
  template<typename T>
  const T* data_as() const;
  const onerec::example::Int8List* data_as_Int8List() const {
    return data_type() == onerec::example::TensorData_Int8List
               ? static_cast<const onerec::example::Int8List*>(data())
               : nullptr;
  }
  const onerec::example::Int16List* data_as_Int16List() const {
    return data_type() == onerec::example::TensorData_Int16List
               ? static_cast<const onerec::example::Int16List*>(data())
               : nullptr;
  }
  const onerec::example::Int32List* data_as_Int32List() const {
    return data_type() == onerec::example::TensorData_Int32List
               ? static_cast<const onerec::example::Int32List*>(data())
               : nullptr;
  }
  const onerec::example::Int64List* data_as_Int64List() const {
    return data_type() == onerec::example::TensorData_Int64List
               ? static_cast<const onerec::example::Int64List*>(data())
               : nullptr;
  }
  const onerec::example::Float32List* data_as_Float32List() const {
    return data_type() == onerec::example::TensorData_Float32List
               ? static_cast<const onerec::example::Float32List*>(data())
               : nullptr;
  }
  const onerec::example::Float64List* data_as_Float64List() const {
    return data_type() == onerec::example::TensorData_Float64List
               ? static_cast<const onerec::example::Float64List*>(data())
               : nullptr;
  }
  const onerec::example::StringList* data_as_StringList() const {
    return data_type() == onerec::example::TensorData_StringList
               ? static_cast<const onerec::example::StringList*>(data())
               : nullptr;
  }
  const onerec::example::BinaryList* data_as_BinaryList() const {
    return data_type() == onerec::example::TensorData_BinaryList
               ? static_cast<const onerec::example::BinaryList*>(data())
               : nullptr;
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_SHAPE)
           && verifier.VerifyVector(shape_view()) && VerifyField<uint8_t>(verifier, VT_DATA_TYPE)
           && VerifyOffset(verifier, VT_DATA) && VerifyTensorData(verifier, data(), data_type())
           && verifier.EndTable();
  }
};

template<>
inline const onerec::example::Int8List* Tensor::data_as<onerec::example::Int8List>() const {
  return data_as_Int8List();
}

template<>
inline const onerec::example::Int16List* Tensor::data_as<onerec::example::Int16List>() const {
  return data_as_Int16List();
}

template<>
inline const onerec::example::Int32List* Tensor::data_as<onerec::example::Int32List>() const {
  return data_as_Int32List();
}

template<>
inline const onerec::example::Int64List* Tensor::data_as<onerec::example::Int64List>() const {
  return data_as_Int64List();
}

template<>
inline const onerec::example::Float32List* Tensor::data_as<onerec::example::Float32List>() const {
  return data_as_Float32List();
}

template<>
inline const onerec::example::Float64List* Tensor::data_as<onerec::example::Float64List>() const {
  return data_as_Float64List();
}

template<>
inline const onerec::example::StringList* Tensor::data_as<onerec::example::StringList>() const {
  return data_as_StringList();
}

template<>
inline const onerec::example::BinaryList* Tensor::data_as<onerec::example::BinaryList>() const {
  return data_as_BinaryList();
}

struct TensorBuilder {
  typedef Tensor Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_shape(flatbuffers::Offset<flatbuffers::Vector<int32_t>> shape) {
    fbb_.AddOffset(Tensor::VT_SHAPE, shape);
  }
  void add_data_type(onerec::example::TensorData data_type) {
    fbb_.AddElement<uint8_t>(Tensor::VT_DATA_TYPE, static_cast<uint8_t>(data_type), 0);
  }
  void add_data(flatbuffers::Offset<void> data) { fbb_.AddOffset(Tensor::VT_DATA, data); }
  explicit TensorBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  TensorBuilder& operator=(const TensorBuilder&);
  flatbuffers::Offset<Tensor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Tensor>(end);
    return o;
  }
};

inline flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> shape = 0,
    onerec::example::TensorData data_type = onerec::example::TensorData_NONE,
    flatbuffers::Offset<void> data = 0) {
  TensorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_shape(shape);
  builder_.add_data_type(data_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<Tensor> CreateTensorDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const std::vector<int32_t>* shape = nullptr,
    onerec::example::TensorData data_type = onerec::example::TensorData_NONE,
    flatbuffers::Offset<void> data = 0) {
  auto shape__ = shape ? _fbb.CreateVector<int32_t>(*shape) : 0;
  return onerec::example::CreateTensor(_fbb, shape__, data_type, data);
}

struct Feature FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef FeatureBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_NAME = 4, VT_TENSOR = 6 };
  const flatbuffers::String* name() const {
    return GetPointer<const flatbuffers::String*>(VT_NAME);
  }
  bool KeyCompareLessThan(const Feature* o) const { return *name() < *o->name(); }
  int KeyCompareWithValue(const char* val) const { return strcmp(name()->c_str(), val); }
  const onerec::example::Tensor* tensor() const {
    return GetPointer<const onerec::example::Tensor*>(VT_TENSOR);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffsetRequired(verifier, VT_NAME)
           && verifier.VerifyString(name()) && VerifyOffset(verifier, VT_TENSOR)
           && verifier.VerifyTable(tensor()) && verifier.EndTable();
  }
};

struct FeatureBuilder {
  typedef Feature Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(Feature::VT_NAME, name);
  }
  void add_tensor(flatbuffers::Offset<onerec::example::Tensor> tensor) {
    fbb_.AddOffset(Feature::VT_TENSOR, tensor);
  }
  explicit FeatureBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  FeatureBuilder& operator=(const FeatureBuilder&);
  flatbuffers::Offset<Feature> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Feature>(end);
    fbb_.Required(o, Feature::VT_NAME);
    return o;
  }
};

inline flatbuffers::Offset<Feature> CreateFeature(
    flatbuffers::FlatBufferBuilder& _fbb, flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<onerec::example::Tensor> tensor = 0) {
  FeatureBuilder builder_(_fbb);
  builder_.add_tensor(tensor);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<Feature> CreateFeatureDirect(
    flatbuffers::FlatBufferBuilder& _fbb, const char* name = nullptr,
    flatbuffers::Offset<onerec::example::Tensor> tensor = 0) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return onerec::example::CreateFeature(_fbb, name__, tensor);
}

struct Digest FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef DigestBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE { VT_VALUE = 4 };
  int64_t value() const { return GetField<int64_t>(VT_VALUE, 0); }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyField<int64_t>(verifier, VT_VALUE)
           && verifier.EndTable();
  }
};

struct DigestBuilder {
  typedef Digest Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_value(int64_t value) { fbb_.AddElement<int64_t>(Digest::VT_VALUE, value, 0); }
  explicit DigestBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  DigestBuilder& operator=(const DigestBuilder&);
  flatbuffers::Offset<Digest> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Digest>(end);
    return o;
  }
};

inline flatbuffers::Offset<Digest> CreateDigest(flatbuffers::FlatBufferBuilder& _fbb,
                                                int64_t value = 0) {
  DigestBuilder builder_(_fbb);
  builder_.add_value(value);
  return builder_.Finish();
}

struct Example FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ExampleBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_FEATURES = 4,
    VT_METADIGEST = 6
  };
  const flatbuffers::Vector<flatbuffers::Offset<onerec::example::Feature>>* features() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<onerec::example::Feature>>*>(
        VT_FEATURES);
  }
  const onerec::example::Digest* metaDigest() const {
    return GetPointer<const onerec::example::Digest*>(VT_METADIGEST);
  }
  bool Verify(flatbuffers::Verifier& verifier) const {
    return VerifyTableStart(verifier) && VerifyOffset(verifier, VT_FEATURES)
           && verifier.VerifyVector(features()) && verifier.VerifyVectorOfTables(features())
           && VerifyOffset(verifier, VT_METADIGEST) && verifier.VerifyTable(metaDigest())
           && verifier.EndTable();
  }
};

struct ExampleBuilder {
  typedef Example Table;
  flatbuffers::FlatBufferBuilder& fbb_;
  flatbuffers::uoffset_t start_;
  void add_features(
      flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<onerec::example::Feature>>>
          features) {
    fbb_.AddOffset(Example::VT_FEATURES, features);
  }
  void add_metaDigest(flatbuffers::Offset<onerec::example::Digest> metaDigest) {
    fbb_.AddOffset(Example::VT_METADIGEST, metaDigest);
  }
  explicit ExampleBuilder(flatbuffers::FlatBufferBuilder& _fbb) : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ExampleBuilder& operator=(const ExampleBuilder&);
  flatbuffers::Offset<Example> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Example>(end);
    return o;
  }
};

inline flatbuffers::Offset<Example> CreateExample(
    flatbuffers::FlatBufferBuilder& _fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<onerec::example::Feature>>>
        features = 0,
    flatbuffers::Offset<onerec::example::Digest> metaDigest = 0) {
  ExampleBuilder builder_(_fbb);
  builder_.add_metaDigest(metaDigest);
  builder_.add_features(features);
  return builder_.Finish();
}

inline flatbuffers::Offset<Example> CreateExampleDirect(
    flatbuffers::FlatBufferBuilder& _fbb,
    std::vector<flatbuffers::Offset<onerec::example::Feature>>* features = nullptr,
    flatbuffers::Offset<onerec::example::Digest> metaDigest = 0) {
  auto features__ =
      features ? _fbb.CreateVectorOfSortedTables<onerec::example::Feature>(features) : 0;
  return onerec::example::CreateExample(_fbb, features__, metaDigest);
}

inline bool VerifyTensorData(flatbuffers::Verifier& verifier, const void* obj, TensorData type) {
  switch (type) {
    case TensorData_NONE: {
      return true;
    }
    case TensorData_Int8List: {
      auto ptr = reinterpret_cast<const onerec::example::Int8List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_Int16List: {
      auto ptr = reinterpret_cast<const onerec::example::Int16List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_Int32List: {
      auto ptr = reinterpret_cast<const onerec::example::Int32List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_Int64List: {
      auto ptr = reinterpret_cast<const onerec::example::Int64List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_Float32List: {
      auto ptr = reinterpret_cast<const onerec::example::Float32List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_Float64List: {
      auto ptr = reinterpret_cast<const onerec::example::Float64List*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_StringList: {
      auto ptr = reinterpret_cast<const onerec::example::StringList*>(obj);
      return verifier.VerifyTable(ptr);
    }
    case TensorData_BinaryList: {
      auto ptr = reinterpret_cast<const onerec::example::BinaryList*>(obj);
      return verifier.VerifyTable(ptr);
    }
    default: return true;
  }
}

inline bool VerifyTensorDataVector(flatbuffers::Verifier& verifier,
                                   const flatbuffers::Vector<flatbuffers::Offset<void>>* values,
                                   const flatbuffers::Vector<uint8_t>* types) {
  if (!values || !types) return !values && !types;
  if (values->size() != types->size()) return false;
  for (flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyTensorData(verifier, values->Get(i), types->GetEnum<TensorData>(i))) {
      return false;
    }
  }
  return true;
}

inline const onerec::example::Example* GetExample(const void* buf) {
  return flatbuffers::GetRoot<onerec::example::Example>(buf);
}

inline const onerec::example::Example* GetSizePrefixedExample(const void* buf) {
  return flatbuffers::GetSizePrefixedRoot<onerec::example::Example>(buf);
}

inline const char* ExampleIdentifier() { return "1REC"; }

inline bool ExampleBufferHasIdentifier(const void* buf) {
  return flatbuffers::BufferHasIdentifier(buf, ExampleIdentifier());
}

inline bool VerifyExampleBuffer(flatbuffers::Verifier& verifier) {
  return verifier.VerifyBuffer<onerec::example::Example>(ExampleIdentifier());
}

inline bool VerifySizePrefixedExampleBuffer(flatbuffers::Verifier& verifier) {
  return verifier.VerifySizePrefixedBuffer<onerec::example::Example>(ExampleIdentifier());
}

inline void FinishExampleBuffer(flatbuffers::FlatBufferBuilder& fbb,
                                flatbuffers::Offset<onerec::example::Example> root) {
  fbb.Finish(root, ExampleIdentifier());
}

inline void FinishSizePrefixedExampleBuffer(flatbuffers::FlatBufferBuilder& fbb,
                                            flatbuffers::Offset<onerec::example::Example> root) {
  fbb.FinishSizePrefixed(root, ExampleIdentifier());
}

}  // namespace example
}  // namespace onerec

#endif  // FLATBUFFERS_GENERATED_EXAMPLE_ONEREC_EXAMPLE_H_
