/*
Copyright 2020 The OneFlow Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
#include "oneflow/core/kernel/kernel.h"

namespace oneflow {

class DynamicReshapeLikeKernel final : public Kernel {
 public:
  OF_DISALLOW_COPY_AND_MOVE(DynamicReshapeLikeKernel);
  DynamicReshapeLikeKernel() = default;
  ~DynamicReshapeLikeKernel() override = default;

 private:
  void ForwardDataContent(KernelContext* ctx) const override;
};

void DynamicReshapeLikeKernel::ForwardDataContent(KernelContext* ctx) const {
  const Blob* in_blob = ctx->BnInOp2Blob("x");
  Blob* out_blob = ctx->BnInOp2Blob("y");
  AutoMemcpy(ctx->stream(), out_blob, in_blob);
}

REGISTER_KERNEL(OperatorConf::kDynamicReshapeLikeConf, DynamicReshapeLikeKernel);

}  // namespace oneflow
