# <div align="center"><strong>Ollama</strong></div>

## 简介

Ollama可快速部署主流模型。

## 安装

### 1、使用源码编译方式安装

#### 环境准备

##### Docker

```bash
docker pull harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226

docker run -i -t -d  --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home  -v /opt/hyhal:/opt/hyhal:ro -v --group-add video --shm-size 16G --name {容器名} {镜像ID}
```

1、下载源码

```bash
git clone -b 0.11.2 http://developer.sourcefind.cn/codes/OpenDAS/ollama.git --depth=1
cd ollama
```

#### 编译

##### 安装go

```bash
wget wget https://golang.google.cn/dl/go1.24.1.linux-amd64.tar.gz
tar -C /usr/local -xzf go1.24.1.linux-amd64.tar.gz
export PATH=$PATH:/usr/local/go/bin

# 修改go下载源，提升速度（按需设置）
go env -w GOPROXY=https://goproxy.cn,direct
```

##### 运行编译

```bash
mkdir build && cd build
cmake -DCMAKE_HIP_COMPILER=/opt/dtk/llvm/bin/clang++ -DAMDGPU_TARGETS=gfx936 ..
make -j$(nproc)
```

## 运行

```bash
export HSA_OVERRIDE_GFX_VERSION=设备型号（如: Z100L gfx906对应9.0.6；K100 gfx926对应9.2.6；K100AI gfx928对应9.2.8,bw gfx936对应9.3.6）
export ROCR_VISIBLE_DEVICES=所有设备号（0,1,2,3,4,5,6,...）/选择设备号
go run . serve  （选择可用设备，可通过上条命令输出结果查看）
go run . run llama3.1
```

更多使用方式请参考[原项目](https://github.com/ollama/ollama)。

注意：每次运行前请检查环境变量`HSA_OVERRIDE_GFX_VERSION`是否正确设置。

## 参考资料

* https://github.com/ollama/ollama
