import requests

# 定义请求的 URL
url = "http://localhost:11434/api/generate"
for num_batch in(1,2,4):
    for num_predict in (128,128):
    # 定义请求的 JSON 数据
        data = {
            "model" : "deepseek-r1:70b",
            "prompt" : "hi",
            "stream" : False,
            "raw" : True,
            "keep_alive" : "1h",
            "options": {
                "num_predict": num_predict,
                "num_batch": num_batch,
                "seed" : 42,
                "stop" : []
            }
        }

        # 发送 POST 请求
        response = requests.post(url, json=data)

        # 打印响应内容
        if response.status_code == 200:
            respose_josn = response.json()
            
            prompt_tokens = respose_josn["prompt_eval_count"]
            generate_tokens = respose_josn["eval_count"]
            prefill_throughput = respose_josn["prompt_eval_count"] / respose_josn["prompt_eval_duration"] * (10**9)
            generate_throughput = respose_josn["eval_count"] / respose_josn["eval_duration"] * (10**9)
            print (f"batch : {num_batch}\nprompt_tokens : {prompt_tokens}\ngenerate_tokens : {generate_tokens}\nprefill_throughput : {round(prefill_throughput,2)}\ngenerate_throughput : {round(generate_throughput,2)}")
            #print(response.json())
            print("====================================")
        else:
            print(f"请求失败，状态码: {response.status_code}")
            print("====================================")