# Neural Network Intelligence

[![Build Status](https://travis-ci.org/Microsoft/nni.svg?branch=master)](https://travis-ci.org/Microsoft/nni)

NNI (Neural Network Intelligence) is a toolkit to help users run automated machine learning experiments. 
The tool dispatches and runs trial jobs that generated by tuning algorithms to search the best neural architecture and/or hyper-parameters in different environments (e.g. local machine, remote servers and cloud).

```
            AutoML experiment                                 Training Services
┌────────┐        ┌────────────────────────┐                  ┌────────────────┐
│ nnictl │ ─────> │  nni_manager           │                  │ Local Machine  │
└────────┘        │    sdk/tuner           │                  └────────────────┘
                  │      hyperopt_tuner    │
                  │      evolution_tuner   │    trial jobs    ┌────────────────┐
                  │      ...               │     ────────>    │ Remote Servers │          
                  ├────────────────────────┤                  └────────────────┘
                  │  trial job source code │                  
                  │    sdk/annotation      │                  ┌────────────────┐
                  ├────────────────────────┤                  │ Yarn,K8s,      │
                  │  nni_board             │                  │ ...            │
                  └────────────────────────┘                  └────────────────┘
```
## **Who should consider using NNI**
* You want to try different AutoML algorithms for your training code (model) at local
* You want to run AutoML trial jobs in different environments to speed up search (e.g. remote servers and cloud)
* As a researcher and data scientist, you want to implement your own AutoML algorithms and compare with other algorithms
* As a ML platform owner, you want to support AutoML in your platform

# Getting Started with NNI

## **Installation**
Install through python pip. (the current version only supports linux, nni on ubuntu 16.04 or newer has been well tested)
* requirements: python >= 3.5, git, wget
```
pip3 install -v --user git+https://github.com/Microsoft/nni.git@v0.1
source ~/.bashrc
```


## **Quick start: run an experiment at local**
Requirements:
* NNI installed on your local machine
* tensorflow installed

Run the following command to create an experiment for [mnist]
```bash
    nnictl create --config ~/nni/examples/trials/mnist-annotation/config.yml
```
This command will start an experiment and a WebUI. The WebUI endpoint will be shown in the output of this command (for example, `http://localhost:8080`). Open this URL in your browser. You can analyze your experiment through WebUI, or browse trials' tensorboard. 

## **Please refer to [Get Started Tutorial](docs/GetStarted.md) for more detailed information.**
## More tutorials
* [How to write a trial running on NNI (Mnist as an example)?](WriteYourTrial.md)
* [Tutorial of NNI python annotation.](../tools/annotation/README.md)
* [Tuners supported by NNI.](../src/sdk/pynni/nni/README.md)
* [How to enable early stop (i.e. assessor) in an experiment?](EnableAssessor.md)
* [How to run an experiment on multiple machines?](RemoteMachineMode.md)
* [How to write a customized tuner?](CustomizedTuner.md)
* [How to write a customized assessor?](../examples/assessors/README.md)
* [How to resume an experiment?](NNICTLDOC.md)
* [Tutorial of the command tool *nnictl*.](NNICTLDOC.md)
* [How to use *nnictl* to control multiple experiments?]()

# Contributing
This project welcomes contributions and suggestions, we are constructing the contribution guidelines, stay tuned =).

We use [GitHub issues](https://github.com/Microsoft/nni/issues) for tracking requests and bugs.

