import * as React from 'react';
import { MessageBar, MessageBarType } from 'office-ui-fabric-react';

interface MessageInfoProps {
    info: string;
    typeInfo: string;
    className?: string;
}

class MessageInfo extends React.Component<MessageInfoProps, {}> {

    constructor(props: MessageInfoProps) {
        super(props);
    }

    render(): React.ReactNode {
        const { info, typeInfo, className } = this.props;
        return (
            <MessageBar
                messageBarType={MessageBarType[typeInfo]}
                isMultiline={false}
                className={className}
            >
                {info}
            </MessageBar>
        );
    }
}

export default MessageInfo;